1;;; -*- Mode:Common-Lisp; Package:SYSTEM-INTERNALS; Fonts:(CPTFONT CPTFONTB); Base:8; Cold-Load:T -*-

;;;                           RESTRICTED RIGHTS LEGEND

;;;Use, duplication, or disclosure by the Government is subject to
;;;restrictions as set forth in subdivision (c)(1)(ii) of the Rights in
;;;Technical Data and Computer Software clause at 52.227-7013.

;;;                     TEXAS INSTRUMENTS INCORPORATED.
;;;                              P.O. BOX 2909
;;;                           AUSTIN, TEXAS 78769
;;;                                 MS 2151

;;; Copyright (C) 1986-1989 Texas Instruments Incorporated. All rights reserved.*



(DEFUN ZLC:FIND-POSITION-IN-LIST-EQUAL (ITEM IN-LIST)
  "Return the numeric position of the first element of IN-LIST that is EQUAL to ITEM.
The first element is position 0.  Returns NIL if no match is found."
    (DO ((L IN-LIST (CDR L))
	 (C 0 (1+ C)))
	((NULL L))
      (AND (EQUAL ITEM (CAR L)) (RETURN C))))

(DEFUN ZLC:ASSOC (ITEM IN-LIST)
  "Return the first element of IN-LIST whose CAR is EQUAL to ITEM."
  (PROG ()
	(IF (TYPEP ITEM '(OR SYMBOL FIXNUM SHORT-FLOAT))
	    (RETURN (ASSOC ITEM IN-LIST :test #'eq)))
     L	(COND ((NULL IN-LIST) (RETURN NIL))
	      ((NULL (CAR IN-LIST)))
	      ((EQUAL ITEM (CAAR IN-LIST)) (RETURN (CAR IN-LIST))))
	(SETQ IN-LIST (CDR IN-LIST))
	(GO L))) 

(DEFUN ZLC:RASSOC (ITEM IN-LIST) 
  "Return the first element of IN-LIST whose CDR is EQUAL to ITEM."
  (DO ((L IN-LIST (CDR L)))
      ((NULL L)) 
    (AND (EQUAL ITEM (CDAR L)) 
	 (RETURN (CAR L)))))


