;; -*- Mode:Common-Lisp; Package:SYSTEM-INTERNALS; Base:10 -*-

;;;                           RESTRICTED RIGHTS LEGEND

;;;Use, duplication, or disclosure by the Government is subject to
;;;restrictions as set forth in subdivision (c)(1)(ii) of the Rights in
;;;Technical Data and Computer Software clause at 52.227-7013.

;;;                     TEXAS INSTRUMENTS INCORPORATED.
;;;                              P.O. BOX 2909
;;;                           AUSTIN, TEXAS 78769
;;;                                 MS 2151

;; Copyright (c) 1980 Massachusetts Institute of Technology 
;; Copyright (c) 1984-1989 Texas Instruments Incorporated.  All Rights Reserved.

;; Trace package

;;	"There is always a place for debugging.  No matter how
;;	 hard you try to think of everything in advance, you
;;	 will always find that there is something else that you
;;	 hadn't thought of."
;;			- My Life as a Mathematician
;;			  by Hfpsh Dboups

;; MISSING:
;;	 - HAIRY DISPLAY FEATURES?
;;	 - "TRACE-EDSUB"


(defvar trace-compile-flag ()
   "If flag is Non-Nil, the traced definitions will be compiled.  That way, PROG, COND, etc. can be traced.") 



(defvar traced-functions () "List of all traced function-specs.") 


(defvar inside-trace ()
   "T means disable tracing, while inside processing the tracing of something.") 


(defvar trace-level 0
   "Total depth within traced functions.  Controls indentation of trace output.") 


(defvar trace-output () "Stream used for trace output.") 


(defvar *trace-output* :unbound "Stream used for trace output.") 


(forward-value-cell '*trace-output* 'trace-output) 


;(deff trace-apply #'apply) 

;;;(deff trace-step-apply 'step-apply)


;;; Rjf 11/17/87 spr 6185 - Changed trace to get value of traced-functions
;;;                         at run time instead of macroexpand time
(defmacro trace ( &rest specs)
  "Trace one or more functions.  The default tracing action is to print
the function's name and arguments when it is called and print its name
and value(s) when it returns.
Each trace spec can take any of the following forms:
A symbol which is a function name, with no options;
A list (:FUNCTION <function-spec> <option-1> <option-2> ...); or
A list ((<function-1> <function-2> ...) <option-1> <option-2> ...)
The following are valid trace options:
:BREAK <pred> (or :EXITBREAK <pred>) causes a breakpoint to be entered
before (or after) the function is executed if <pred> is NON-NIL.
:ERROR causes the debugger to be invoked before the function is executed. 
:STEP causes the function to be single-stepped whenever it is called.
:ENTRYCOND <pred> (or :EXITCOND <pred>) causes trace information to
be printed on function entry (or exit) only if <pred> is NON-NIL.
:COND <pred> specifies both :ENTRYCOND and :EXITCOND together.
:WHEREIN <function> causes the function to be traced only when called 
from <function>.
:ARGPDL <pdl> specifies a symbol <pdl> which will contain the recent history
of the function.  <pdl> should be examined from within a breakpoint.
:ENTRYPRINT <form> (or :EXITPRINT <form>) evaluates <form> and prints the value
before (or after) the function is executed.
:PRINT <form> specifies both :ENTRYPRINT and :EXITPRINT together.
:ENTRY <list> (or :EXIT <list>) specifies a list of forms whose values are
printed on function entry (or exit).
:ARG prints the function's name and arguments on function entry.
:VALUE prints the function's returned value(s)  on function exit.
:BOTH  specifies both :ARG and :VALUE together. This is the default"
  (cond
    ((null specs) `traced-functions)
    (t `(mapcan #'trace-1 ',specs))))

;;;(defmacro trace ( &rest specs)
;;;  (cond
;;;    ((null specs) `',traced-functions)
;;;    (t `(mapcan #'trace-1 ',specs))))

;;; Rjf 11/17/87 spr 6879 - Changed untrace to not complain in untraceing all
;;;                         and some on list have been deleted
(defmacro untrace (&rest fns)
  "Untrace one or more functions.  With no arg, untrace all traced functions."
  `(loop for spec in ,(if fns `',fns '(trace))
     collect (untrace-1 spec ,(not (null fns)))))
  
;;;(defmacro untrace (&rest fns)
;;;  "Untrace one or more functions.  With no arg, untrace all traced functions."
;;;  `(mapcar #'untrace-1 ,(if fns `',fns '(trace))))



(defun (:property trace encapsulation-pprint-function) (function def  real-io)
  function
  def
  real-io
  (princ "
;Traced
" real-io))

;; A list in the args to UNTRACE is taken as a non-atomic function-name
;; rather than a wherein-spec, as Maclisp would do, since UNTRACE WHEREIN
;; is not implemented anyway, and since WHEREIN doesn't work that way in
;; this TRACE anyway (that is, it still modifies the function cell.)

(defun untrace-1 (spec &optional (dwim-p t))
  ;;If dwim-p is NIL, we presumably know what we are untracing, probably
  ;;because we are untracing ALL functions.  If this is the case, remove the
  ;;function spec from traced-functions regardless of whether it's a valid spec.
  (when dwim-p
    (SETQ SPEC (DWIMIFY-ARG-PACKAGE SPEC 'SPEC)))
  (cond
    ((fdefinedp spec)
     (let* ((spec1 (unencapsulate-function-spec spec 'trace))
	    (spec2 (unencapsulate-function-spec spec1 '(trace))))
       (when (neq spec1 spec2)
	 (fdefine spec1 (fdefinition spec2) () t)
	 (setq traced-functions (delete spec (the list traced-functions) :test #'equal)))))
    (t (setq traced-functions (delete spec (the list traced-functions) :test #'equal))))
  spec)

;;;(defun untrace-1 (spec &aux spec1 spec2)
;;;  (SETQ SPEC (DWIMIFY-ARG-PACKAGE SPEC 'SPEC))
;;;  (setq spec1 (unencapsulate-function-spec spec 'trace))
;;;  (cond
;;;    ((neq spec1 (setq spec2 (unencapsulate-function-spec spec1 '(trace))))
;;;     (fdefine spec1 (fdefinition spec2) () t)
;;;     (setq traced-functions (delete spec (the list traced-functions) :test #'equal))))
;;;  spec) 


;;PHD 2/19/87 Put dwimify call back.
;; 7/29/87 DNG - Bind compile-encapsulations-flag to itself as part of fix for SPR 5906.
(defun trace-1 (spec)
  (prog (break
	 exitbreak
	 entrycond
	 exitcond
	 wherein
	 argpdl
	 entry
	 exit
	 (arg t)
	 (value t)
	 step
	 (barfp t)
	 stepcond
	 entryvals
	 exitvals
	 mumble
	 fcn
	 spec1
	 trfcn
	 error
	 step-compile-flag
	 (compile-encapsulations-flag compile-encapsulations-flag) ; may be set by encapsulate
	 (default-cons-area background-cons-area))
	(cond
	  ((atom spec) (setq fcn spec))
	  (t
	   (cond
	     ((eq (car spec) :function) (setq fcn (cadr spec)
					      spec (cdr spec)))
	     ((atom (car spec)) (setq fcn (car spec)))
	     ((validate-function-spec spec) (SETQ fcn spec spec (LIST spec)))
	     ((validate-function-spec (CAR SPEC)) (SETQ FCN (CAR SPEC)))
	     (t (return (loop for fcn in (car spec) nconc (trace-1 `(:function ,fcn ,@(cdr spec)))))))
	   (do ((specs (cdr spec) (cdr specs)))
	       ((null specs)
		nil)
	     (case (car specs)
		   (:break (setq barfp specs
				 specs (cdr specs)
				 break (car specs)))
		   (:exitbreak (setq barfp specs
				     specs (cdr specs)
				     exitbreak (car specs)))
		   (:stepcond (setq barfp specs
				    specs (cdr specs)
				    stepcond (car specs)
				    step t))
		   (:step (setq step t) (setq step-compile-flag t))
		   (:error (setq error t))
		   (:cond (setq barfp specs
				specs (cdr specs))
			  (setq stepcond (setq exitcond (setq entrycond (car specs)))))
		   (:entrycond (setq barfp specs
				     specs (cdr specs)
				     entrycond (car specs)))
		   (:exitcond (setq barfp specs
				    specs (cdr specs)
				    exitcond (car specs)))
		   (:wherein (setq barfp specs
				   specs (cdr specs)
				   wherein (car specs)))
		   (:argpdl (setq barfp specs
				  specs (cdr specs)
				  argpdl (car specs)))
		   (:entry (setq barfp specs
				 specs (cdr specs)
				 entry (car specs)))
		   (:exit (setq barfp specs
				specs (cdr specs)
				exit (car specs)))
		   (:print
		    (setq barfp specs
			  specs (cdr specs)
			  entry (cons (car specs) entry)
			  exit (cons (car specs) exit)))
		   (:entryprint (setq barfp specs
				      specs (cdr specs)
				      entry (cons (car specs) entry)))
		   (:exitprint (setq barfp specs
				     specs (cdr specs)
				     exit (cons (car specs) exit)))
		   ((:arg :value :both nil) (and (eq (car specs) :arg) (setq value ()))
					    (and (eq (car specs) :value) (setq arg ()))
					    (and (eq (car specs) ()) (setq arg ()
									   value ()))
					    (and arg (setq entryvals (cdr specs))) (and value (setq exitvals (cdr specs)))
					    (return ()))
		   (otherwise (setq mumble (car specs)) (return ())))
	     (and (null barfp) (ferror () "Parameter missing")))))
	(SETQ FCN (DWIMIFY-ARG-PACKAGE FCN 'FCN))
	(untrace-1 fcn)
	(and mumble (return (ferror () "Meaningless TRACE keyword: ~S" mumble)))
	(check-arg argpdl symbolp "a symbol")
	(setq spec1 (unencapsulate-function-spec fcn 'trace))
	(setq trfcn
	      (encapsulate spec1 fcn 'trace
		 `(block nil
		    (let* (,@(and argpdl `((,argpdl (cons (list (1+ ,copy) ',fcn arglist) ,argpdl))))
				    values
				    (,copy (1+ ,copy))
				    (trace-level (1+ trace-level)))
		    (declare (special ,copy values))
		    ,(if error
			 `(progn
			    (let ((eh:*error-depth* (1+ eh:*error-depth*))
				  (eh:*condition-proceed-types* '(:no-action)))
			      (eh:invoke-debugger (make-condition 'eh:trace-breakpoint "~S entered" ',fcn)))
			    (return (values-list (multiple-value-list (apply ,encapsulated-function arglist)))))
			 `(cond
			    ((or inside-trace ,@(and wherein `((not (function-active-p ',wherein)))))
			     (return (apply ,encapsulated-function arglist)))
			    (t
			     (let ((inside-trace t))
			       ,(trace-maybe-conditionalize entrycond
							    `(trace-print ,copy 'enter ',fcn ',arg ',entry
									  ',entryvals))
			       ,@(and break `((and ,break (let (inside-trace)
							    (break "Entering ~S." ',fcn)))))
			       (setq values
				     (let ((inside-trace nil))
				       (multiple-value-list
					 ,(if (and step stepcond)
					      ;; conditionally call the stepper.
					      `(if ,stepcond
						   (step-apply ,encapsulated-function arglist)
						   (apply ,encapsulated-function arglist))
					      `(,(if step
						     'step-apply
						     'apply)
						,encapsulated-function arglist)))))
			       ,(trace-maybe-conditionalize exitcond
							    `(trace-print ,copy 'exit ',fcn ',value ',exit
									  ',exitvals))
			       ,@(and exitbreak
				      `((and ,exitbreak (let (inside-trace)
							  (break "Exiting ~S." ',fcn)))))
			       (return (values-list values)))))))) ))
	(set trfcn 0)
	(push fcn traced-functions)
	(if (or trace-compile-flag step-compile-flag compile-encapsulations-flag)
	    (compile-encapsulations spec1 'trace))
	(return (cons fcn ())))) 


(defun trace-maybe-conditionalize (condition action)
  (cond
    (condition `(and ,condition ,action))
    (t action))) 


(defun trace-print (depth direction function print-args-flag extras-1 extras-2)
  (declare (special arglist values))
  (terpri *trace-output*)
  (do ((n (* 2 trace-level) (1- n)))
      ((not (> n 2))
       nil)
    (write-char #\SPACE *trace-output*))
  (princ "(" *trace-output*)
  (prin1 depth *trace-output*)
  (princ " "  *trace-output*)
  (princ direction *trace-output* )
  (princ " "  *trace-output*)
  (prin1 function *trace-output*)
  (let ((stuff (if (eq direction 'enter)
		   arglist
		   values)))
    (when (and stuff print-args-flag)
      (princ ":" *trace-output*)
      (do ((tail stuff (cdr tail)))
	  ((atom tail)
	   (when tail
	     (princ " . " *trace-output*)
	     (prin1 tail *trace-output*)))
	(write-char #\SPACE *trace-output*)
	(prin1 (car tail) *trace-output*))))
  (when extras-1
    (princ "  \\\\" *trace-output*)
    (dolist (e extras-1)
      (princ " " *trace-output*)
      (prin1 (eval e) *trace-output*)))
  (when extras-2
    (princ "  //" *trace-output*)
    (dolist (e extras-2)
      (princ " " *trace-output*)
      (prin1 (eval e) *trace-output*)))
  (princ ")" *trace-output*)) 

;; See if a function is currently active

(defun function-active-p (function-spec)
  "If dynamically within any activation of FUNCTION-SPEC, return the frame-pointer,
otherwise NIL."
  (let* ((sg %current-stack-group)
	 (rp (sg-regular-pdl sg))
	 (fnval (fdefinition function-spec)))
    (do* ((frame (%pointer-difference (%stack-frame-pointer) (locf (aref rp 0)))
		(eh:sg-next-frame sg frame)))
	((null frame) nil)
      (when (eq fnval (rp-function-word rp frame))
	(return frame)))))


(pushnew ':TRACE *features*) ; added 12/10/87 by DNG
