;;; -*- Mode:Common-Lisp; Package:SYSTEM-Internals; Base:10 -*-

;;;                           RESTRICTED RIGHTS LEGEND

;;;Use, duplication, or disclosure by the Government is subject to
;;;restrictions as set forth in subdivision (c)(1)(ii) of the Rights in
;;;Technical Data and Computer Software clause at 52.227-7013.
;;;
;;;                     TEXAS INSTRUMENTS INCORPORATED.
;;;                              P.O. BOX 2909
;;;                           AUSTIN, TEXAS 78769
;;;                                 MS 2151
;;;
;;; Copyright (C) 1987- 1989 Texas Instruments Incorporated. All rights reserved.

;;;
;;; This file contains Configuration ROM (CROM) hacking routines.

;;; Edit History:
;;; 
;;;   Date    Patcher  Patch #  Description
;;;-------------------------------------------------------------------------
;;; 03-16-87    dm       --     Original.
;;; 03-29-87    ab       --     Replaced hard-coded offsets with symbolic constants.
;;;                             Added chassis-config checksum support.
;;; 01-27-87    ab              Fixes for MX.  Should eventually be conditionalized
;;;                             on a NUBUS-related conditional instead of NVRAM.

;; Should eventually look at our config ROM & maybe call host for her info.
(DEFUN (:cond (NOT (resource-present-p :NVRAM)) get-hardware-info) ()
  (FORMAT nil "~a" (MACHINE-VERSION)))

(DEFUN (:cond (resource-present-p :NVRAM) get-hardware-info) ()
  "Returns a string showing Explorer boards and their revision levels"
  (LET* ((board-type CROMO-Board-Type-Offset-Name)
	 (board-type-nbytes CROMO-Board-Type-Name-Length)
	 (serial-num CROMO-Board-Serial-Number)
	 (serial-num-nbytes CROMO-Serial-Number-Length)
	 (rev-level CROMO-Board-Rev-Level)
	 (rev-level-nbytes CROMO-Rev-Level-Length)
	 (vendor-id CROMO-Vendor-ID)
	 (vendor-id-nbytes CROMO-Vendor-ID-Length)
	 (part-number CROMO-Board-Part-Number)
	 (part-number-nbytes CROMO-Part-Number-Length)
	 (board-fields (LIST (LIST vendor-id vendor-id-nbytes)
			     (LIST board-type board-type-nbytes)
			     (LIST part-number part-number-nbytes)
			     (LIST serial-num serial-num-nbytes)
			     (LIST rev-level rev-level-nbytes)
			     ))
	 (config-rom-bytes (MAKE-ARRAY 16. :initial-value nil))
	 (boards (make-array 960 :element-type '(STRING-CHAR) :fill-pointer 0)))
    #+explorer    
    (LOOP FOR slotid FROM 0 TO #xF
	  DO (WHEN (NUMBERP (si:%nubus-read-8b-careful (+ #xF0 slotid) board-type))
	       (SETF (AREF config-rom-bytes slotid)
		     (MAKE-ARRAY 38. :fill-pointer 0))
	       (LOOP FOR (offset nbytes) IN board-fields
		     DO (DOTIMES (i nbytes)
			  (VECTOR-PUSH (si:%nubus-read-8b-careful (+ #xF0 slotid) offset)
				       (AREF config-rom-bytes slotid))
			  (INCF offset 4)))
	       (LOOP FOR i FROM 37. DOWNTO 31.
		     UNTIL (< 0 (AREF (AREF config-rom-bytes slotid) i) #xFF)
		     FINALLY (RETURN (AREF (AREF config-rom-bytes slotid) i)))))
    #+explorer
    (DOTIMES (slotid 16.)
      (IF (NULL (AREF config-rom-bytes slotid))
	  nil
	  (SETF boards
		(STRING-nconc
		  boards #\return
		  (FORMAT nil "SLOT~2D.  ~
                               TYPE = ~C~C~C.  ~
                               PART # = ~C~C~C~C~C~C~C~C~C~C~C~C~C~C~C~C.  ~
                               SERIAL # = ~16,2,48R~16,2,48R~16,2,48R~
                               ~[~255;~:*~16,2,48R~:;-~:*~C~]~[~255;~:*~16,2,48R~:;~:*~C~]~[~255;~:*~16,2,48R~:;~:*~C~]~
                               ~[~255;~:*~16,2,48R~:;-~:*~C~]~
                               ~[~255;~:*~16,2,48R. ~:;-~:*~2D.  ~]~
                               REV = ~C~C"
			  slotid
			; (AREF (AREF config-rom-bytes slotid) 0)
			; (AREF (AREF config-rom-bytes slotid) 1)
			; (AREF (AREF config-rom-bytes slotid) 2)
			; (AREF (AREF config-rom-bytes slotid) 3)
			  
			  (AREF (AREF config-rom-bytes slotid) 4)
			  (AREF (AREF config-rom-bytes slotid) 5)
			  (AREF (AREF config-rom-bytes slotid) 6)
			  
			  (AREF (AREF config-rom-bytes slotid) 7)
			  (AREF (AREF config-rom-bytes slotid) 8)
			  (AREF (AREF config-rom-bytes slotid) 9)
			  (AREF (AREF config-rom-bytes slotid) 10.)
			  (AREF (AREF config-rom-bytes slotid) 11.)
			  (AREF (AREF config-rom-bytes slotid) 12.)
			  (AREF (AREF config-rom-bytes slotid) 13.)
			  (AREF (AREF config-rom-bytes slotid) 14.)
			  (AREF (AREF config-rom-bytes slotid) 15.)
			  (AREF (AREF config-rom-bytes slotid) 16.)
			  (AREF (AREF config-rom-bytes slotid) 17.)
			  (AREF (AREF config-rom-bytes slotid) 18.)
			  (AREF (AREF config-rom-bytes slotid) 19.)
			  (AREF (AREF config-rom-bytes slotid) 20.)
			  (AREF (AREF config-rom-bytes slotid) 21.)
			  (AREF (AREF config-rom-bytes slotid) 22.)
			  
			  (AREF (AREF config-rom-bytes slotid) 23.)
			  (AREF (AREF config-rom-bytes slotid) 24.)
			  (AREF (AREF config-rom-bytes slotid) 25.)
			  (AREF (AREF config-rom-bytes slotid) 26.)
			  (AREF (AREF config-rom-bytes slotid) 27.)
			  (AREF (AREF config-rom-bytes slotid) 28.)
			  (AREF (AREF config-rom-bytes slotid) 29.)
			  (AREF (AREF config-rom-bytes slotid) 30.)
			  
			  (AREF (AREF config-rom-bytes slotid) 31.)
			  (LOOP FOR i FROM 37. DOWNTO 31.
				UNTIL (< 0 (AREF (AREF config-rom-bytes slotid) i) #xFF)
				FINALLY (RETURN (AREF (AREF config-rom-bytes slotid) i))))))))
    boards))


;;;
;;; Chassis-Config-Checksum support
;;;

(si:DEFINE-WHEN :NVRAM				;should be NUBUS-MASTER or something.

(DEFUN get-CROM-info (slot field-offset field-length)
  (LOOP WITH crom-info = (MAKE-ARRAY field-length :element-type '(unsigned-byte 8.))
	FOR i FROM 0 BELOW field-length
	FOR rom-byte = (%nubus-read-8b-careful slot (+ field-offset (* i 4.)))
	DO
	(IF (NUMBERP rom-byte)
	    (SETF (AREF crom-info i) rom-byte)
	    (RETURN nil))
	FINALLY (RETURN crom-info))
  )

(DEFUN get-CROM-string (crom-info &optional start end &aux len)
  (SETQ len (LENGTH crom-info)
	start (IF start (MIN start len) 0)
	end (IF end (MIN end len) len))
  (LET ((str (MAKE-ARRAY (- end start) :element-type '(STRING-CHAR))))
    (LOOP FOR el FROM (OR start 0) BELOW (OR end (LENGTH crom-info))
	  DO (SETF (AREF str el)
		   (INT-CHAR (AREF crom-info el))))
    str))

(DEFUN get-part-number (slot)
  (LET ((info (get-crom-info slot CROMO-Board-Part-Number CROMO-Part-Number-Length)))
    (WHEN info (get-crom-string info))))

(DEFUN display-part-number-info ()
  (DOTIMES (board 16.)
    (LET* ((slot (DPB #x+F (BYTE 4. 4.) board))
	   (pn (GET-part-number slot)))
      (WHEN pn
	(FORMAT t "~%Slot:  #x+~x,   Part-Number:  ~a" slot pn)))
    ))

(DEFUN calculate-config-checksum ()
  (LOOP FOR slot-num FROM 0 BELOW 16.
	FOR slot = (DPB slot-num (BYTE 4. 0.) #x+F0)
	WITH pn = NIL
	WITH config-checksum = 0
	DO
	(WHEN (SETQ pn (get-crom-info slot CROMO-Board-Part-Number CROMO-Part-Number-Length))
	  (LOOP FOR el FROM 0 BELOW (LENGTH pn)
		WITH sum = 0
		DO (INCF sum (AREF pn el))
		FINALLY (INCF config-checksum sum)))
	FINALLY (RETURN config-checksum))
  )

;;End of DEFINE-WHEN
)