;;;-*- Mode: Common-Lisp; Package:system-internals ; Base: 8. -*-

;;;                           RESTRICTED RIGHTS LEGEND

;;;Use, duplication, or disclosure by the Government is subject to
;;;restrictions as set forth in subdivision (c)(1)(ii) of the Rights in
;;;Technical Data and Computer Software clause at 52.227-7013.
;;;
;;;                     TEXAS INSTRUMENTS INCORPORATED.
;;;                              P.O. BOX 2909
;;;                           AUSTIN, TEXAS 78769
;;;                                 MS 2151
;;;
;;; Copyright (C) 1985- 1989 Texas Instruments Incorporated. All rights reserved.
;;;
;;; Defsystem for NVRAM, which includes routines for setting up (and changing) 
;;; NVRAM format, writing crash record information, and analyzing crash records.
;;; First integrated into Explorer system 4/85 in Experimental J (some minimal
;;; support in Experimental I).  -ab
;;;
;;; Files restructured, defsystem changed 9/85, -ab
;;; Updated.  Added CROM file. 3-87, -ab

;;; Build notes:
;;; These modules all depend on templates from QDEV, so the correct version
;;; of that must be loaded in the compile environment of this system.

(DEFSYSTEM nvram
  (:name "NVRAM")
  (:pathname-default "SYS:NVRAM;")
  (:patchable "SYS: PATCH.NVRAM;" patch)
  (:warnings-pathname-default "SYS: CWARNS; nvram.lisp")
  (:module defs ("accessors"			;Low level access functions and all macros
		 "nvram-defs"))                 ;Defvars
  (:module nvram
	   ("inits"				;Initializations and init list funcitons
	    "nvram"))				;NVRAM setup, change routines
  (:module crash-analyzer 
	   ("crash"				;Core analyzer functions
	    "analysis-functions"))		;Functions to interpret specific crash codes
  (:module misc		  
	   ("shutdown"				;System shutdown routine
	    "config-rom"))			;Configuration ROM hacking
  (:compile-load defs)
  (:compile-load-init nvram
		      (defs)
		      (:fasload defs)
		      (:fasload defs))
  (:compile-load-init crash-analyzer
		      (defs)
		      (:fasload defs)
		      (:fasload defs))
  (:compile-load-init misc
		      (defs)
		      (:fasload defs)
		      (:fasload defs))
  )
