;;; -*- Mode:Zetalisp; Package:COMPILER; Base:8; Cold-load:T -*-

;;;                           RESTRICTED RIGHTS LEGEND
;;;
;;;Use, duplication, or disclosure by the Government is subject to
;;;restrictions as set forth in subdivision (c)(1)(ii) of the Rights in
;;;Technical Data and Computer Software clause at 52.227-7013.
;;;
;;;   TEXAS INSTRUMENTS INCORPORATED      
;;;   P.O. BOX 2909, M/S 2151             
;;;   AUSTIN, TEXAS 78769                 
;;;
;;; Copyright (C) 1985-1989 Texas Instruments Incorporated.
;;; All rights reserved.

;;; This file contains the definition of the machine instruction set

;;; ***** DO NOT CHANGE THE NUMBER FOR ANY ENTRY OR REUSE ANY NUMBER ******
;;; ***** WITHOUT CONSULTING A UCODE WIZZARD!!			     ******

;;; Descriptors for the instructions.  Each descriptor is:
;;; (DEFOP <name or names> <opcode> <result-disposition> <arglist>
;;;        &Optional &Keyword :Documentation :Lisp-Function-P :No-Reg)
;;;
;;; Where:
;;;   <name or names> is the name of the instruction or a list of names.  If there are one
;;;             or more Lisp functions that compile directly to this instruction, then this
;;;             is a list whose CAR is the instruction name and remaining elements are the
;;;             names of lisp functions that compile directly to this.
;;;   <opcode> is the number which should be in the %%QMI-FULL-OPCODE field to represent this
;;;            instruction.
;;;   <result-disposition> is the "old style" destination symbol for what this instruction
;;;            does with its result:  D-PDL, D-INDS, or D-RETURN
;;;            Also D-VARIES if depends on subordinate op
;;;             and D-STORE  stores somewhere and also does D-INDS
;;;            Also D-NONE, does not affect the indicators
;;;   <arglist> is a list argument names.  This resembles a lambda-list for a Lisp function.
;;;             No lambda-list keywords are allowed.  Defaults to NIL if unsupplied.
;;;   :Lisp-Function-P  If present should be either T or NIL.  If T, then there
;;;             will be a Lisp function defined and which does this instruction.
;;;   :Documentation    If present is the documentation for this instruction.  Should be present
;;;             if Lisp-Function-P is Non-NIL.
;;;   :NO-REG   Default is NIL.  If non-NIL, there is no register field in this instruction.
;;;             It can not be arg prefetched.  The value of NO-REG is the name of the decode
;;;             template that decodes this instruction's reg field.
;;; Edit History:
;;;
;;;                   Patch
;;;   Date    Author  Number   Description
;;;------------------------------------------------------------------------------
;;; 09-24-86    ab             Add miscops:
;;;                              %phys-logldb        #o  54
;;;                              %phys-logdpb        #o  55
;;;                              %load-memory-map    #o 364   
;;;                            Miscop deletions:
;;;                              %add-device         #o 361
;;; 12-09-86   GRH    C-67     Cleaned up the TV miscop doc strings
;;;  1-09-86   RJF             Added "lisp-function-p t" to internal-char-equal
;;;                            and internal-float per David Gray.
;;;  1/12/87   GRH    C-92     Deleted the %draw-char miscop.
;;;  1-23-87   ab              Added doc strings for %NuBus- miscops.
;;;  2-06-87   RJF    ---      Changed lisp-function-p to nil for "Set" per
;;;                            P. Dussud
;;;  2-08-87   ab              Changed an argument name.
;;; 02-19-87   ab              Fixed DEF-MISC-OP of SET.  Needed to have 
;;;                            :LISP-FUNCTION-P T and :INTERPRETER-DEFINITION NIL.
;;;  3/11/87   KK	       Corrected doc string for %draw-character
;;;  3-30-87   GRH  C-170,176  Major improvements to the graphics primitives doc strings.
;;;  7-02-87   GRH             Added "expansion" documentation to bitblt.
;;; 07-14-87   ab    Sys 47    Add :LISP-FUNCTION-P T & doc string to SET-%INSTANCE-REF [SPR 4436]
;;; 07-23-87   ab    D-43      Add PROLOG miscops for KT.
;;; 07-28-87   GRH  d-48       Add %scroll miscop entry
;;;  8-24-87   RJF             Add :LISP-FUNCTION-P T to %Test&Set-68K miscop [spr 6334]
;;; 09-10-87   ab   e-24       Added %IO-SPACE-READ and %IO-SPACE-WRITE miscops for Exp2
;;;            11-13-87         RJF        Added :Interpreter-Definition nil to common-lisp-listp, eql, arrayp
;;;                                        fixnump, stringp.
;;;             1-07-88         RJF        Added new aux-op si:%FLUSH-EXTRA-PDL
;;;             1-15-88         RJF        Added new Misc-op for CLOS %dispatch-Method
;;;	F-37	01/21/88	JHO/HRC	   Added new aux-ops, %SCRUB and %DELETE-PHT-ENTRY.
;;;					   %SCRUB is used by the scheduler to clean dirty pages
;;;					   of age trap 0-2.  %DELETE-PHT-ENTRY is used by 
;;;					   disk-save to delete pht entries without restructuring
;;;					   the LRU list.
;;;     H-6    05/05/88         RJF        Added apply-method aux-op.
;;;     ---    05/27/88         RJF        Added miscop %make-list*
;;;     I-2    08-05-88         kt/ab      Added new miscops %getlong & friends.
;;;     I-3    08-17-88         kt/ab      Added new miscop %sum-array.
;;;     ---    10-18-88         RJF        Added new miscop %TEST&STORE-68K
;;;     ----   10/26/88         RJF        Minor changes to %TEST&STORE-68K.
;;;            02/09/89         JLM        Corrected argument name for %CREATE-PHYSICAL-PAGE (should be PFN)
;;;     j-39   05/17/89         JLM        Added new misc-op %ALLOCATE-AND-INITIALIZE-SYMBOL


;; no reg and no push

(DEFOP AUX-GROUP          0 D-NONE () :No-Reg AUX)	;non-result ops
(DEFOP TEST-MISC-GROUP    1 D-INDS   () :No-Reg MISC)
(DEFOP TEST-MODULE-GROUP  2 D-INDS   () :No-Reg Module)
(DefOp EQ-IMMED           3 D-INDS (x immed-y) :No-Reg Immed )	;(EQ x y)
(DefOp =-IMMED            4 D-INDS (x immed-y) :No-Reg Immed )	;(= x y)
(DefOp >-IMMED            5 D-INDS (x immed-y) :No-Reg Immed )	;(> x y)
(DefOp <-IMMED            6 D-INDS (x immed-y) :No-Reg Immed )	;(< x y)
(DefOp Test-AREFI         7 D-INDS    () :No-Reg AREFI)

;; have reg and push
(DEFOP TEST               10 D-INDS   (obj))
(DEFOP (TEST-CAR CAR)     11 D-INDS   (list))
(DEFOP (TEST-CDR CDR)     12 D-INDS   (list))
(DEFOP (TEST-CADR CADR)   13 D-INDS   (list))
(DEFOP (TEST-CDDR CDDR)   14 D-INDS   (list))
(DEFOP (TEST-CAAR CAAR)   15 D-INDS   (list))
(DEFOP (TEST-MEMQ MEMQ)   16 D-INDS   (x list))
(DEFOP RETURN             17 D-RETURN   (val))	;<---- NOTE:  TRANSFER OF CONTROL

;;; Comparison
(DefOp (= = INTERNAL-=)  20 D-INDS (x y))
(DefOp (> > INTERNAL->)  21 D-INDS (x y))
(DefOp (< < INTERNAL-<)  22 D-INDS (x y))
(DefOp EQ                23 D-INDS (x y) :Lisp-Function-P T)
(DefOp EQL               24 D-INDS (x y) :Lisp-Function-P T)
(DefOp EQUAL             25 D-INDS (x y) :Lisp-Function-P T)
(DefOp EQUALP            26 D-INDS (x y) :Lisp-Function-P T)


;;; Other predicates
(DefOp Numberp           30 D-INDS (x) :Lisp-Function-P T)
(DefOp Arrayp            31 D-INDS (x) :Lisp-Function-P T)
(DefOp (CLI:Listp sys:COMMON-LISP-LISTP CLI:Listp)
                         32 D-INDS (x) :Lisp-Function-P T	;common-lisp listp   <--- NOTE  CLI:
       :documentation "T if OBJECT is a list (including the empty list), otherwise returns NIL.")
(DefOp Stringp           33 D-INDS (x) :Lisp-Function-P T)
(DefOp Fixnump           34 D-INDS (x) :Lisp-Function-P T)
(DefOp (Integerp GLOBAL:Fixp Integerp) 35 D-INDS (x) :Lisp-FUnction-P T)
(DefOp Plusp             36 D-INDS (x) :Lisp-FUnction-P T)
(DefOp Minusp            37 D-INDS (x) :Lisp-FUnction-P T)

;; have no reg but push
;; 40
(DEFOP PUSH-MISC-GROUP   41 D-PDL    () :No-Reg MISC)
(DEFOP PUSH-MODULE-GROUP 42 D-PDL    () :No-Reg Module)
(DEFOP ADD-IMMED         43 D-PDL    (x immed-y) :No-Reg Immed)
(DEFOP LDB-IMMED         44 D-PDL    (x immed-PPSS) :No-Reg Nothing)	;immed<8:4> is 5-bit pos immed<3:0> is 4-bit len
(DefOp Push-Number       45 D-PDL    () :No-Reg Nothing)
(DefOp Push-Neg-Number   46 D-PDL () :No-Reg Nothing)
;;; AREFI
(DefOp Push-ArefI        47 D-PDL     () :No-Reg AREFI)

;; have reg and push
(DEFOP PUSH              50 D-PDL    (obj))
(DEFOP (PUSH-CAR CAR)    51 D-PDL    (list))
(DEFOP (PUSH-CDR CDR)    52 D-PDL    (list))
(DEFOP (PUSH-CADR CADR)  53 D-PDL    (list))
(DEFOP (PUSH-CDDR CDDR)  54 D-PDL    (list))
(DEFOP (PUSH-CADDR CADDR) 55 D-PDL   (list))
(DEFOP (PUSH-CONS CONS)  56 D-PDL    (car cdr))
(DEFOP (PUSH-GET INTERNAL-GET-2) 57 D-PDL    (sym ind))

;; have reg and push
;;; Arith
(DefOp (+ + *PLUS)	60 D-PDL    (x y))
(DefOp (- - *DIF)	61 D-PDL    (x y))
(DefOp (* * *TIMES)	62 D-PDL    (x y))
(DefOp (LOGAND LOGAND *LOGAND) 63 D-PDL    (x y))
(DefOp (LOGXOR LOGXOR *LOGXOR) 64 D-PDL    (x y))
(DefOp 1+                65 D-PDL    (N) :Lisp-FUnction-P T
       :documentation "Returns N plus one.  N can be any type of number.")
(DefOp 1-                66 D-PDL    (N) :Lisp-FUnction-P T
       :documentation "Returns N minus one.  N can be any type of number.")
(DefOp PUSH-AR-1         67 D-PDL    (idx array))	;this is common-lisp-ar1

;;Random
;;; 70-77 use arg in funny ways
(DefOp Push-Long-FEF   70 D-PDL    (x) :No-Reg Nothing)		;9-bit FEF offset
(DefOp Select          71 D-INDS (x seltable) :No-Reg Nothing)	;table at 9-bit FEF offset
(DefOp Dispatch        72 D-INDS (index disptable) :No-Reg Nothing)   ;table at 9-bit FEF offset
;; 73 reserved for CASE
;; 74 reserved for lexclose
;; 75 reserved for lexclose
(DefOp (Lexical-Unshare)            76 D-PDL   () :No-Reg Nothing)	;9-bit local slot num
(DefOp (Locate-Lexical-Environment) 77 D-PDL   () :No-Reg Nothing)	;a/b bit and 8-bit num levels

;; Calling Ops:  Reg and Transfer of Control
(Def-CallOp CALL-0    100 (func))
(Def-CallOp CALL-1    104 (func))
(Def-CallOP CALL-2    110 (func))
(Def-CallOp CALL-3    114 (func))
(Def-CallOp CALL-4    120 (func))
(Def-CallOp CALL-5    124 (func))
(Def-CallOp CALL-6    130 (func))
(Def-CallOp CALL-N    134 (n func))		;punted CALL-7
;;; (Def-CallOp CALL-COMPLEX 134 (n call-type-code func)) ;;; make it an AUX op

;;; Storing
(DefOp POP               140 D-STORE  (obj loc))
(DefOp MOVEM             141 D-STORE  (obj loc))	;movem pdl-push is eqv DUP
(DefOp SETE-CDR          142 D-STORE  (loc))
(DefOp SETE-CDDR         143 D-STORE  (loc))
(DefOp SETE-1+           144 D-STORE  (loc))
(DefOp SETE-1-           145 D-STORE  (loc))
;; 146
(DefOp (PUSH-CDR-Store-CAR-IF-CONS) 147 D-STORE (x dest))	;flush this??? reluctantly no!!

(DefOp PUSH-LOC          150 D-PDL    (loc))	;don't store but return address
;;; Binding
(DefOp BIND-NIL          151 D-STORE  (loc))
(DefOp BIND-T            152 D-STORE  (loc)) 
(DefOp BIND-POP          153 D-STORE  (newval loc))
(DefOp BIND-CURRENT      154 D-STORE  (loc))
;; Setting
(DefOp SET-NIL           155 D-STORE (loc))
(DefOp SET-T             156 D-STORE (loc))
(DefOp SET-ZERO          157 D-STORE (loc))

;; Branching Ops: No Reg but transfer of control
;;; simple BR ops
(Def-Branch-Op NULL TRUE   T   160)		;BR-NIL-ELSE-POP
(Def-Branch-Op NULL FALSE  T   161)		;BR-NOT-NIL-ELSE-POP
(Def-Branch-Op NULL TRUE   NIL 162)		;BR-NIL tests indicators
(Def-Branch-Op NULL FALSE  NIL 163)		;BR-NOT-NIL tests indicators
(Def-Branch-Op ATOM TRUE   NIL 164)		;BR-ATOM tests indicators
(Def-Branch-Op ATOM FALSE  NIL 165)		;BR-NOT-ATOM tests indicators
(Def-Branch-Op ZEROP TRUE  NIL 166)		;BR-ZEROP tests indicators
(Def-Branch-Op ZEROP FALSE NIL 167)		;BR-NOT-ZEROP tests indicators


(Def-Branch-Op SYMBOLP TRUE  NIL 170)
(Def-Branch-Op SYMBOLP FALSE NIL 171)
;; 172-173
;;; 174-177 are special BRANCH-LIKELY instructions
;;; Hummingbird hardware will follow these branches in the macro-pipeline
;;; 
(Def-Branch-Op NULL TRUE NIL  174 LIKELY)	;BR-NIL-LIKELY will almost always branch 
(Def-Branch-Op NULL FALSE NIL  175 LIKELY)	;BR-NOT-NIL-LIKELY will almost always branch
(Def-Branch-Op ALWAYS NIL NIL 176)		;Branches always, very likely to branch
;;; 177 is illegal

;;; AUX instructions
;;; These are instructions that don't produce a result that are
;;; extensions to the main instruction set like MISC and MODULE instructions.

;;; 0-67 Random instructions
;; 0 is reserved as an illegal instruction so that the unused halfword at the end of some FEF's 
;;   can contain a known invalid instruction.
;; these are sort of invalid too.
(Def-Aux-Op BREAKPOINT        1 ())
(Def-Aux-Op (HALT %HALT)      2 ()
   :documentation "Halts the processor.")
(Def-Aux-Op (CRASH %CRASH)    3 (code object paws-up-p) :Lisp-Function-P T :Interpreter-Definition T
   :documentation "Causes machine to crash (like ILLOP) indicating crash reason as software
with CODE remembered as the crash code.  OBJECT is also remembered for crash
analysis.  If PAWS-UP-P is not NIL then will display paws-up as ILLOP does.
If PAWS-UP-P is NIL then it is presumed that the called has indicated the
lossage to the user.  %CRASH is not restartable, but you may be able to warm-
boot out of it.")
;; 4-7

;; 10 starts stack hacking instructions
(Def-Aux-Op EXCHANGE           10)		;swaps top two items on stack
(Def-Aux-Op %SPREAD            11 (list) :Lisp-Function-P T :Interpreter-Definition NIL  ;would always return NIL
	    :documentation "Takes a list and pushes its elements on the stack")
(Def-Aux-Op %ASSURE-PDL-ROOM   12 (room) :Lisp-Function-P T :Interpreter-Definition NIL)
	;Trap if not ROOM more words in PDL frame
(Def-Aux-Op POP-M-FROM-UNDER-N 13 (NUM-POPS NUM-TO-KEEP))  ; was miscop 374
(Def-Aux-Op POPJ               14 (return-PC))	;or call it RETURN-SUBR, will bounds-check PC
(Def-Aux-OP %Unwind-Protect-Cleanup 15)
(Def-Aux-Op %USING-BINDING-INSTANCES 16 (BINDING-INSTANCES) :Lisp-Function-P T :Interpreter-Definition NIL) ;525
(Def-Aux-Op UNBIND-TO-INDEX    17 (SPECIAL-PDL-INDEX))	;was 645

;; 20-21
(Def-Aux-Op %SET-SELF-MAPPING-TABLE  22 (MAPPING-TABLE))	;i??, 336
;; 23-27

;; 30-77
(Def-Aux-Op STORE-IN-HIGHER-CONTEXT   30 (VALUE Context-Desc))
(Def-Aux-Op LEXICAL-UNSHARE-ALL       31 ())
(Def-Aux-Op %store-key-word-args      32 (VALID-KEYS ALLOW-OTHER-KEYS LOCATIVE-TO-FIRST-STORE) :Lisp-Function-P T
	    :documentation "Support for keyword argument decoding. The argument-list of keys and values
are obtained from Local 0 and compared against valid keys.  ALLOW-OTHER-KEYS is true or nil and indicate
whether other keys should be allowed. LOCATIVE-TO-FIRST-STORE is a locative to the first local slot to
where to store the values.  CLOS uses the args slightly different, since it just wants to check the keys and
not store them. In CLOS. the argument list is passed in the ALLOW-OTHER-KEYS and LOCATIVE-TO-FIRST-STORE is
always  NIL. VALID-KEYS is same as the normal case.")

;; Complex Funcall - 100
(Def-Aux-Op Complex-Call 100) ; uses call-info word
(Def-Aux-Op APPLY 104)
(Def-Aux-Op Apply-Method 110)                                                                   ;;#H-6
(Def-Aux-Op LEXPR-FUNCALL-WITH-MAPPING-TABLE 114)

(Def-Aux-Op Complex-Call-to-Inds     100  (callinfo function)) 
(Def-Aux-Op Complex-Call-to-Push     101  (callinfo function)) 
(Def-Aux-Op Complex-Call-to-Return   102  (callinfo function)) 
(Def-Aux-Op Complex-Call-to-Tail-Rec 103  (callinfo function)) 

(Def-Aux-Op Apply-to-Inds            104  (arglist fn)) 
(Def-Aux-Op Apply-to-Push            105  (arglist fn)) 
(Def-Aux-Op Apply-to-Return          106  (arglist fn)) 
(Def-Aux-Op Apply-to-Tail-Rec        107  (arglist fn)) 

(Def-Aux-Op Apply-Method-to-Inds     110  (mapping-table-list fn))                              ;;#H-6
(Def-Aux-Op Apply-Method-to-Push     111  (mapping-table-list fn))                              ;;#H-6
(Def-Aux-Op Apply-Method-to-Return   112  (mapping-table-list fn))                              ;;#H-6
(Def-Aux-Op Apply-Method-to-Tail-rec 113  (mapping-table-list fn))                              ;;#H-6

(Def-Aux-Op LEXPR-Funcall-with-Mapping-Table-to-Inds     114  (arglist mapping-table fn))
(Def-Aux-Op LEXPR-Funcall-with-Mapping-Table-to-Push     115  (arglist mapping-table fn))
(Def-Aux-Op LEXPR-Funcall-with-Mapping-Table-to-Return   116  (arglist mapping-table fn))
(Def-Aux-Op LEXPR-Funcall-with-Mapping-Table-to-Tail-rec 117  (arglist mapping-table fn))

(Def-Aux-Op Return-N                 120 (numvals))	;returns top NUMVALS things on stack
(Def-Aux-Op Return-List              121 (VALUES)	;404
   :documentation "Return the elements of VALUES, as multiple values, from a PROG.")
(Def-Aux-Op Return-NIL		     122 ())
(Def-Aux-Op Return-T                 123 ())

(Def-Aux-Op %Open-Catch              124 (catch-tag restart-pc))
(Def-Aux-Op %Open-Catch-Multiple-Value 125 (catch-tag restart-pc number-of-values))
(Def-Aux-Op %Open-Catch-Tail-Recursive 126 (catch-tag restart-pc))	;why need?  Lose the name.
(Def-Aux-Op %Open-Catch-MV-List      127 (catch-tag restart-pc))

;; 130 throw and friends
(Def-Aux-Op %THROW             130 (TAG VALUE))	;was 470
(Def-Aux-Op %THROW-N           131 (TAG &REST VALUES-AND-COUNT))	;was 447
;;;(DEF-AUX-OP THROW-SPREAD       132 (TAG VALUE-LIST))	;was 554
(Def-Aux-Op %Unwind-Protect-Continue 132 ())	;Maybe continue throwing after unwind-protect undo-forms.
(Def-Aux-Op *Unwind-Stack      133 (TAG VALUE FRAME-COUNT ACTION)	;was 636
   :lisp-function-p t :Interpreter-Definition nil
   :documentation "Throw VALUE at most FRAME-COUNT frames;  then call ACTION if it's not NIL.
ACTION receives VALUE as its only arg.  If FRAME-COUNT is non-NIL, it must be a fixnum.
If ACTION is NIL, FRAME-COUNT must not be, and the frame that many frames out,
whatever it is, is returned from, returning VALUE.  TAG exists only for compatibility
with the older form of *UNWIND-STACK, and must be T.")

(Def-Aux-Op %Close-Catch       134 ())
(Def-Aux-Op %Close-Catch-Unwind-Protect 135 ())	;close catch but leave info for %unwind-protect-continue

(Def-Aux-Op Return-Pred              136 ())	;returns NIL iff (null inds) else returns T
(Def-Aux-Op Return-Not-Inds          137 ())	;returns T iff (null inds) else returns NIL


;; Paging - 140
(Def-Aux-Op %enable-nupi-locking  140 (nubus-addr-hi nubus-addr-low) :Lisp-Function-P T)
(Def-Aux-Op %disable-nupi-locking  141 () :Lisp-Function-P T)
;; 142-143
;;(Def-Aux-Op %RETURN-PAGE-CLUSTER  144 (page-device-number cluster-offset-number) :Lisp-Function-P T
;;	    :documentation "Sets the bit in the swap band bitmap that corresponds to the
;;cluster passed.  Setting the bit indicates the cluster is free and
;;will allow that disk space to be re-used.")
(Def-Aux-Op %SCRUB                 145 ()   :Lisp-Function-P T)		;; F-37
(Def-Aux-Op %CREATE-PHYSICAL-PAGE 146 (PFN) :Lisp-Function-P T)		;; JLM 2/09/89
(Def-Aux-Op %DELETE-PHT-ENTRY   147 (pfn)   :Lisp-Function-P T)		;; F-37
;; GC - 150
(Def-Aux-Op %GC-FREE-REGION  150 (REGION) :Lisp-Function-P T)
(Def-Aux-Op %GC-FLIP         151 (flip-type) :Lisp-Function-P T)
(Def-Aux-Op %GC-SCAVENGE     152 (WORK-UNITS) :Lisp-Function-P T)
(Def-Aux-Op %GC-CONS-WORK    153 (NQS) :Lisp-Function-P T)
(Def-Aux-Op %FLUSH-EXTRA-PDL 154 ()    :Lisp-Function-P T)
(Def-Aux-Op %IMPORT-OBJECT   155 (x)   :Lisp-Function-P T)
;; 155
;; disk save/restore
(Def-Aux-Op %DISK-RESTORE    156 (PARTITION-HIGH-16-BITS LOW-16-BITS PHYSICAL-UNIT) :Lisp-Function-P T	;530
	    :documentation "Restore a world load partition.
The first two args make a 32-bit number that is interpreted as 4 characters, the partition name.
Zero means the current band is used.  PHYSICAL-UNIT is a number representing the physical (not
logical) unit to restore from.")
;;;(Def-Aux-Op %DISK-SAVE       157 (MAIN-MEMORY-SIZE PARTITION-HIGH-16-BITS LOW-16-BITS PHYSICAL-UNIT) T)	;531

;; Long Branch 160-177
;; same AUX OP as main branch op
;; these should be absolute rather than relative PC's
(Def-Aux-Op Long-BR-NULL-ELSE-POP     160)
(Def-Aux-Op Long-BR-NOT-NULL-ELSE-POP 161)
(Def-Aux-Op Long-BR-NULL              162)
(Def-Aux-Op Long-BR-NOT-NULL          163)
(Def-Aux-Op Long-BR-ATOM              164)
(Def-Aux-Op Long-BR-Not-ATOM          165)
(Def-Aux-Op Long-BR-ZeroP             166)
(Def-Aux-Op Long-BR-Not-ZeroP         167)
(Def-Aux-Op Long-BR-SYMBOLP           170)
(Def-Aux-Op Long-BR-NOT-SYMBOLP       171)
;; 172-173
(Def-Aux-Op Long-BR-NULL-LIKELY       174)
(Def-Aux-Op Long-BR-NOT-NULL-LIKELY   175)
(Def-Aux-Op Long-BR                   176)
(Def-Aux-Op Long-PUSHJ                177)	;or call it BR-Subr



;;;200-377 unused.  Reserved for future expansion

;;;400-477 UNBIND
;; block decode low 6-bits of op is number of unbinds to do.
(Def-Aux-Op Unbind-1         400)
(Def-Aux-Op Unbind-2         401)
(Def-Aux-Op Unbind-3         402)
(Def-Aux-Op Unbind-4         403)
(Def-Aux-Op Unbind-5         404)
(Def-Aux-Op Unbind-6         405)
(Def-Aux-Op Unbind-7         406)
(Def-Aux-Op Unbind-8         407)
(Def-Aux-Op Unbind-9         410)
(Def-Aux-Op Unbind-10        411)
(Def-Aux-Op Unbind-11        412)
(Def-Aux-Op Unbind-12        413)
(Def-Aux-Op Unbind-13        414)
(Def-Aux-Op Unbind-14        415)
(Def-Aux-Op Unbind-15        416)
(Def-Aux-Op Unbind-16        417)
;; on to (Def-Aux-Op Unbind-64  477)??

;;; 500-577 POP-PDL
(Def-Aux-Op Pop-PDL-1        500)
(Def-Aux-Op Pop-PDL-2        501)
(Def-Aux-Op Pop-PDL-3        502)
(Def-Aux-Op Pop-PDL-4        503)
(Def-Aux-Op Pop-PDL-5        504)
(Def-Aux-Op Pop-PDL-6        505)
(Def-Aux-Op Pop-PDL-7        506)
(Def-Aux-Op Pop-PDL-8        507)
(Def-Aux-Op Pop-PDL-9        510)
(Def-Aux-Op Pop-PDL-10       511)
(Def-Aux-Op Pop-PDL-11       512)
(Def-Aux-Op Pop-PDL-12       513)
(Def-Aux-Op Pop-PDL-13       514)
(Def-Aux-Op Pop-PDL-14       515)
(Def-Aux-Op Pop-PDL-15       516)
(Def-Aux-Op Pop-PDL-16       517)
;; on to (Def-Aux-Op Pop-PDL-64   577)??

;;; 600-677 Return-N
(Def-Aux-Op Return-0         600)
(Def-Aux-Op Return-1         601)		;redundant.  Not needed.
(Def-Aux-Op Return-2         602)
(Def-Aux-Op Return-3         603)
(Def-Aux-Op Return-4         604)
(Def-Aux-Op Return-5         605)
(Def-Aux-Op Return-6         606)
(Def-Aux-Op Return-7         607)
(Def-Aux-Op Return-8         610)
(Def-Aux-Op Return-9         611)
(Def-Aux-Op Return-10        612)
(Def-Aux-Op Return-11        613)
(Def-Aux-Op Return-12        614)
(Def-Aux-Op Return-13        615)
(Def-Aux-Op Return-14        616)
(Def-Aux-Op Return-15        617)
(Def-Aux-Op Return-16        620)
(Def-Aux-Op Return-17        621)
(Def-Aux-Op Return-18        622)
(Def-Aux-Op Return-19        623)
(Def-Aux-Op Return-20        624)
(Def-Aux-Op Return-21        625)
(Def-Aux-Op Return-22        626)
(Def-Aux-Op Return-23        627)
(Def-Aux-Op Return-24        630)
(Def-Aux-Op Return-25        631)
(Def-Aux-Op Return-26        632)
(Def-Aux-Op Return-27        633)
(Def-Aux-Op Return-28        634)
(Def-Aux-Op Return-29        635)
(Def-Aux-Op Return-30        636)
(Def-Aux-Op Return-31        637)
(Def-Aux-Op Return-32        640)
(Def-Aux-Op Return-33        641)
(Def-Aux-Op Return-34        642)
(Def-Aux-Op Return-35        643)
(Def-Aux-Op Return-36        644)
(Def-Aux-Op Return-37        645)
(Def-Aux-Op Return-38        646)
(Def-Aux-Op Return-39        647)
(Def-Aux-Op Return-40        650)
(Def-Aux-Op Return-41        651)
(Def-Aux-Op Return-42        652)
(Def-Aux-Op Return-43        653)
(Def-Aux-Op Return-44        654)
(Def-Aux-Op Return-45        655)
(Def-Aux-Op Return-46        656)
(Def-Aux-Op Return-47        657)
(Def-Aux-Op Return-48        660)
(Def-Aux-Op Return-49        661)
(Def-Aux-Op Return-50        662)
(Def-Aux-Op Return-51        663)
(Def-Aux-Op Return-52        664)
(Def-Aux-Op Return-53        665)
(Def-Aux-Op Return-54        666)
(Def-Aux-Op Return-55        667)
(Def-Aux-Op Return-56        670)
(Def-Aux-Op Return-57        671)
(Def-Aux-Op Return-58        672)
(Def-Aux-Op Return-59        673)
(Def-Aux-Op Return-60        674)
(Def-Aux-Op Return-61        675)
(Def-Aux-Op Return-62        676)
(Def-Aux-Op Return-63        677)

;; 700-777

;;; MODULE instructions
;;; have module name and instruction name.
;;; There may be up to 16 instructions in a module
;;; These are for "optional" instructions.
;; default are lisp functions

(Def-Module TV 0)

(Def-Module-Op %DRAW-RECTANGLE TV 1 (WIDTH HEIGHT X Y ALU WINDOW-OR-ARRAY)
	       :documentation 
 "Draw a solid rectangle of size WIDTH and HEIGHT with upper left corner
coordinates of X and Y on WINDOW-OR-ARRAY using ALU.  The rectangle is clipped
according to the the edges specified by W:WITH-CLIPPING-RECTANGLE.")

(Def-Module-Op %DRAW-CHARACTER TV 3 (FONT CHAR CHAR-WIDTH-OR-NIL X Y ALU WINDOW-OR-ARRAY)
	       :documentation 
 "Draw CHAR from FONT at X and Y on WINDOW-OR-ARRAY with CHAR-WIDTH using
ALU.  CHAR is either a character or fixnum.  FONT is a font object.  X and
will be the upper left corner of the character.  If CHAR-WIDTH is nil, the 
font raster width is used.  Common ALU values are W:ALU-IOR or W:ALU-XOR.
The character will not be drawn if any part of it overlaps the clipping 
rectangle as specified by W:WITH-CLIPPING-RECTANGLE.  If WINDOW-OR-ARRAY is 
a window instance, it must be the currently prepared window.

Many italic fonts have character images which extend past their designated
character width.  The raster width should be used when drawing these types
of characters, except possibly at the edge of a window where an excessive
width may cause inadvertent clipping.  If a complementing ALU is used then
real character widths should be used instead of raster widths.")

(Def-Module-Op %SCROLL TV 4 (WIDTH HEIGHT X FROM-Y TO-Y ARRAY)
	       :documentation 
 "Copy rectangle given by WIDTH and HEIGHT FROM-Y TO-Y at X on ARRAY.
No clipping is performed.  Physical arrays are not handled.")

(Def-Module-Op %DRAW-SHADED-TRIANGLE TV 5 (X1 Y1 X2 Y2 X3 Y3 ALU
   DRAW-FIRST-EDGE DRAW-SECOND-EDGE DRAW-THIRD-EDGE PATTERN-OR-NIL WINDOW-OR-ARRAY)
	       :documentation 
 "Draw a triangle at (X1, Y1) (X2, Y2) (X3, Y3) using ALU with fill PATTERN 
on WINDOW-OR-ARRAY.  If PATTERN is nil a solid pattern is used, else a pixel
array such as W:50%-GRAY should be given.  DRAW-FIRST-EDGE, DRAW-SECOND-EDGE, 
and DRAW-THIRD-EDGE specify whether or not to draw each edge.  These 
arguments are useful when drawing adjacent triangles to form a more complex 
shape.  The first edge corresponds to the line between the first and second
vertices.  The triangle is clipped to the edges specified by W:WITH-CLIPPING-
RECTANGLE.  If the three vertices are colinear then a line is drawn.  Note
that the DRAW-EDGE arguments still work in this case, so that part of the line
may not be drawn if one of the DRAW-EDGE arguments is nil.")

(Def-Module-Op %DRAW-SHADED-RASTER-LINE TV 6 (X1 X2 Y ALU DRAW-LAST-POINT PATTERN-OR-NIL WINDOW-OR-ARRAY)
	       :documentation 
 "Draw a horizontal line from X1 to X2 at Y with ALU using PATTERN on
WINDOW-OR-ARRAY.  If DRAW-LAST-POINT is NIL, the point (X1, Y) is not
drawn.  If PATTERN is nil a solid line is drawn.  The line is clipped
according to the edges specified by W:WITH-CLIPPING-RECTANGLE.")

(Def-Module-Op %DRAW-STRING TV 7 (FONT STRING INDEX END-OR-NIL X Y ALU WINDOW-OR-ARRAY)
	       :documentation 
 "Draw STRING from INDEX through END-OR-NIL at X Y using FONT and ALU on WINDOW-OR-ARRAY. 
X is incremented by the font-character-width for each character drawn and must be a fixed
width font.  The characters are drawn using the font-raster-width so that italic 
characters do not lose any pixels which may extend past their actual character width.  
Either nil or a fixnum is returned.  Nil is returned for one of five conditions.

 (1) Font is a variable width font.
 (2) Font has a left kern table.
 (3) Font-character-width is greater than 32.
 (4) String is a displaced array.
 (5) String is not of type art-string.

Otherwise a fixnum containing two pieces of information is returned.  The X position of
the first character NOT drawn will be in the bottom 12. bits.  The index of the first
character not drawn will be in the next 12. bits.  This fixnum is returned when one of 
three conditions occurs.

 (1) The end position is reached.  If END is nil then the last position is used.
 (2) A non-graphic character is encountered. (#x80 - #x9F inclusive)
 (3) A character extends past the edges specified by W:WITH-CLIPPING-RECTANGLE.  The
     font-character-width is used for this test, as opposed to the font-raster-width.")

;;  11-17

(Def-Module MOUSE 1)
;;;(Def-Module MOUSE)
(Def-Module-Op %SET-MOUSE-SCREEN MOUSE  0 (WINDOW))
(Def-Module-Op %OPEN-MOUSE-CURSOR MOUSE 1 ())

;;; MISC instructions
;;; These are extended instructions
;;; Each is potentially available in either D-INDS or D-PDL but many are available
;;; only in one form.  These are grouped together to decrease the decoding tables
;;; required.

;;; 0-200 both D-PDL and D-INDS, hard to tell which is usual
;;; These are accessors
(Def-MISC-Op CAR  2 (X)  :Lisp-FUnction-P T)
(Def-MISC-OP CDR  3 (X)  :Lisp-FUnction-P T)
(Def-MISC-OP CAAR 4 (X)  :Lisp-FUnction-P T)
(Def-MISC-OP CADR 5 (X)  :Lisp-FUnction-P T)
(Def-MISC-OP CDAR 6 (X)  :Lisp-FUnction-P T)
(Def-MISC-OP CDDR 7 (X)  :Lisp-FUnction-P T)

;;; These could work on bit pattern
;;; of the low 3 bits  1=CDR and 0=CAR
(Def-MISC-OP CAAAR 10 (X)  :Lisp-FUnction-P T)
(Def-MISC-OP CAADR 11 (X)  :Lisp-FUnction-P T)
(Def-MISC-OP CADAR 12 (X)  :Lisp-FUnction-P T)
(Def-MISC-OP CADDR 13 (X)  :Lisp-FUnction-P T)
(Def-MISC-OP CDAAR 14 (X)  :Lisp-FUnction-P T)
(Def-MISC-OP CDADR 15 (X)  :Lisp-FUnction-P T)
(Def-MISC-OP CDDAR 16 (X)  :Lisp-FUnction-P T)
(Def-MISC-OP CDDDR 17 (X)  :Lisp-FUnction-P T)

;;; These could work on bit pattern
;;; of the low 4 bits 1=CDR and 0=CAR
(Def-MISC-OP CAAAAR 20 (X)  :Lisp-FUnction-P T)
(Def-MISC-OP CAAADR 21 (X)  :Lisp-FUnction-P T)
(Def-MISC-OP CAADAR 22 (X)  :Lisp-FUnction-P T)
(Def-MISC-OP CAADDR 23 (X)  :Lisp-FUnction-P T)
(Def-MISC-OP CADAAR 24 (X)  :Lisp-FUnction-P T)
(Def-MISC-OP CADADR 25 (X)  :Lisp-FUnction-P T)
(Def-MISC-OP CADDAR 26 (X)  :Lisp-FUnction-P T)
(Def-MISC-OP CADDDR 27 (X)  :Lisp-FUnction-P T)
(Def-MISC-OP CDAAAR 30 (X)  :Lisp-FUnction-P T)
(Def-MISC-OP CDAADR 31 (X)  :Lisp-FUnction-P T)
(Def-MISC-OP CDADAR 32 (X)  :Lisp-FUnction-P T)
(Def-MISC-OP CDADDR 33 (X)  :Lisp-FUnction-P T)
(Def-MISC-OP CDDAAR 34 (X)  :Lisp-FUnction-P T)
(Def-MISC-OP CDDADR 35 (X)  :Lisp-FUnction-P T)
(Def-MISC-OP CDDDAR 36 (X)  :Lisp-FUnction-P T)
(Def-MISC-OP CDDDDR 37 (X)  :Lisp-FUnction-P T)


;; 40 - stack hacking
(Def-Misc-Op PDL-WORD     40 (N))			;337
(Def-Misc-Op SHRINK-PDL-SAVE-TOP 41 (VALUE-TO-MOVE N-SLOTS))	;643
;; 42-45
;;; Stack Groups
(Def-Misc-Op STACK-GROUP-RETURN 46 (X) :Lisp-Function-P T	;537
	     :documentation "Resume the stack group which invoked this one, with X as argument.
Does not change which stack group is recorded as that one's resumer.")
(Def-Misc-Op STACK-GROUP-RESUME 47 (SG X) :Lisp-Function-P T	;542
	     :documentation "Resume stack group SG with X as argument.")

;; TI IO instruction
;; %-functions
(DEF-MISC-OP %P-DPB           50 (VALUE PPSS POINTER) :Lisp-FUnction-P T
	     :documentation "Store VALUE into byte PPSS in the word addressed by POINTER.
This byte can include any of the bits in the word, and can overlap
between the various fields normally used by Lisp.
But it may not be more than 24. bits long.
POINTER's data type is ignored -- it can even be a fixnum -- so this
can be dangerous unless used with care.")
(DEF-MISC-OP %P-DEPOSIT-FIELD 51 (VALUE PPSS POINTER) :Lisp-FUnction-P T
	     :documentation "Stores into the byte PPSS of the word addressed by POINTER from teh same byte of VALUE.
This byte can include any of the bits in the word, and can overlap
between the various fields normally used by Lisp.
For example, part of VALUE's data type field may be included.
POINTER's data type is ignored -- it can even be a fixnum -- so this
can be dangerous unless used with care.")
(DEF-MISC-OP %P-DPB-OFFSET    52 (VALUE PPSS POINTER OFFSET) :Lisp-FUnction-P T
	     :documentation "Stores VALUE into the byte PPSS in the word OFFSET beyond POINTER.
This is not the same as (%P-DPB VALUE PPSS (%MAKE-POINTER-OFFSET ... POINTER OFFSET))
because it checks for a forwarding pointer in the word addressed by POINTER.
The idea is that POINTER points at the beginning of a structure
and OFFSET is an offset within it.")
(DEF-MISC-OP %P-DEPOSIT-FIELD-OFFSET 53 (VALUE PPSS POINTER OFFSET) :Lisp-FUnction-P T
	     :documentation "Copy byte PPSS from VALUE into the word OFFSET beyond POINTER.
This is not the same what you could simulate using %P-DPB
because it checks for a forwarding pointer in the word addressed by POINTER.
The idea is that POINTER points at the beginning of a structure
and OFFSET is an offset within it.")

(DEF-MISC-OP %PHYS-LOGLDB 54 (PPSS NUBUS-SLOT SLOT-BYTE-ADR) :Lisp-Function-P T
	     :documentation "Return the contents of byte PPSS at the physical address
represented by NUBUS-SLOT and SLOT-BYTE-ADR.  NUBUS-SLOT is the high order 8 bits of 
the Nubus physical address, and SLOT-BYTE-ADR is the low order 24-bit BYTE address.")
(DEF-MISC-OP %PHYS-LOGDPB 55 (VALUE PPSS NUBUS-SLOT SLOT-BYTE-ADR) :Lisp-Function-P T
	     :documentation "Stores VALUE into the byte PPSS at the physical address
represented by NUBUS-SLOT and SLOT-BYTE-ADR.  NUBUS-SLOT is the high order 8 bits of 
the Nubus physical address, and SLOT-BYTE-ADR is the low order 24-bit BYTE address.")

;; 56
;; GC
(Def-Misc-Op %GC-SCAV-RESET   57 (REGION))

;; %-functions
;; 60
;; 61
(Def-Misc-Op %P-STORE-CONTENTS          62 (POINTER VALUE) :Lisp-FUnction-P T
	     :documentation "Store VALUE into the memory location addressed by POINTER.
Only the data type and pointer fields of the word are changed
/(the fields which are part of the /"contents/" of the word).
POINTER's data type is ignored -- it can even be a fixnum -- so this
is dangerous if not used with care.")
(Def-Misc-Op %P-STORE-TAG-AND-POINTER   63 (POINTER MISC-FIELDS POINTER-FIELD) :Lisp-FUnction-P T
	     :documentation "Store the entire word addressed by POINTER from two numbers.
MISC-FIELDS is stored into the top 8 bits, and POINTER-FIELD into the bottom 24.
POINTER's data type is ignored -- it can even be a fixnum -- so this
is dangerous if not used with care.")
(Def-Misc-Op %P-STORE-CDR-CODE          64 (POINTER CDR-CODE) :Lisp-FUnction-P T
	     :documentation "Store CDR-CODE into the cdr-code field of the word addressed by POINTER.
CDR-CODE is a number from 0 to 3.
POINTER's data type is ignored -- it can even be a fixnum -- so this
can be dangerous unless used with care.")
(Def-Misc-Op %P-STORE-DATA-TYPE         65 (POINTER DATA-TYPE) :Lisp-FUnction-P T
	     :documentation "Store DATA-TYPE into the data-type field of the word addressed by POINTER.
DATA-TYPE is a value such as %DATA-TYPE might return.
POINTER's data type is ignored -- it can even be a fixnum -- so this
can be dangerous unless used with care.")
(Def-Misc-Op %P-STORE-POINTER           66 (POINTER POINTER-TO-STORE) :Lisp-FUnction-P T
	     :documentation "Store POINTER-TO-STORE into the pointer field of the word addressed by POINTER.
POINTER's data type is ignored -- it can even be a fixnum -- so this
can be dangerous unless used with care.")
(Def-Misc-Op %P-STORE-CONTENTS-OFFSET   67 (VALUE POINTER OFFSET) :Lisp-FUnction-P T
	     :documentation "Store VALUE in contents of word OFFSET beyond that addressed by POINTER.
This is not the same as (%P-STORE-CONTENTS (%MAKE-POINTER-OFFSET ... POINTER OFFSET))
because it checks for a forwarding pointer in the word addressed by POINTER.
The idea is that POINTER points at the beginning of a structure
and OFFSET is an offset within it.")

;;; Symbols both dests
(Def-Misc-Op INTERNAL-GET-2  70 (SYMBOL PROPERTY))	;320
(Def-Misc-Op GETL            71 (SYMBOL INDICATOR-LIST) :Lisp-FUnction-P T	;321
	     :documentation "Find any of the properties in INDICATOR-LIST, on SYMBOL.
Whichever of those properties occurs first in the property list is used.
The value is a pointer to the cell in the property list that points
to the indicator.  The CADR of the value is the property's value.")
(Def-Misc-Op GET-LOCATION-OR-NIL 72 (SYMBOL PROPERTY) :Lisp-FUnction-P T
	     :documentation "Return the location of property PROPERTY in  plist of SYMBOL, or NIL if no property.
SYMBOL can actually be anything you can GET from.")
(Def-Misc-Op INTERNAL-GET-3  73 (SYMBOL PROPERTY DEFAULT))	;1022
;; 74-75
(Def-Misc-Op Predicate       76 ())		;result is NIL iff (null inds) else T
(Def-Misc-Op Not-Indicators  77 ())		;result is T   iff (null inds) else NIL

;;; 100-177

;;; 200-377 usually D-INDS
(Def-Misc-Op BIND      200 (loc val)
   :documentation "Bind any location to a specified value.
Adds the binding to the current stack-frame.  Only works in compiled code.
This allows you to bind cells other than value cells and to do conditional
binding.")

;; I/O -- mostly writes
(Def-Misc-Op %IO                     210 (RQB DEVICE-DESC) :Lisp-FUnction-P T)	;returns NIL, 1023
(DEF-Misc-OP %ADD-INTERRUPT     211 (DEVICE-DESC LEVEL))	;1024
;; 212-213
(DEF-Misc-OP %MULTIBUS-WRITE-16 214  (MULTIBUS-BYTE-ADR WORD) :Lisp-Function-P T)	;733
(DEF-Misc-OP %MULTIBUS-WRITE-8  215  (MULTIBUS-BYTE-ADR WORD) :Lisp-Function-P T)	;735
(DEF-Misc-OP %MULTIBUS-WRITE-32 216  (MULTIBUS-BYTE-ADR WORD) :Lisp-Function-P T)	;737

;;NuBus IO instructions
;;  SLOT is really the high 8 bits.
;;  the "top F" can be supplied via slot, avoiding bignums.
(DEF-Misc-OP %NUBUS-WRITE       217 (NUBUS-SLOT SLOT-BYTE-ADR VALUE) :Lisp-FUnction-P T	;762
	     :documentation "Write 32 bits of VALUE to the NuBus.  The NuBus address is
specified by NUBUS-SLOT (top 8 bits) and the byte offset into the slot SLOT-BYTE-ADR (low
24 bits).  Returns NIL.")

;; NEW NuBus Instructions
(Def-Misc-Op %NuBus-Write-8B    220 (NUBUS-SLOT SLOT-BYTE-ADR VALUE) :Lisp-FUnction-P T	;1031
	     :documentation "Write the low byte of VALUE to the NuBus.  The NuBus address is
specified by NUBUS-SLOT (top 8 bits) and the byte offset into the slot SLOT-BYTE-ADR (low
24 bits).  Returns NIL.")
(Def-Misc-Op %NuBus-Write-16B   221 (NUBUS-SLOT SLOT-BYTE-ADR VALUE) :Lisp-FUnction-P T	;1033
	     :documentation "Write the low 16 bits of VALUE to the NuBus.  The NuBus address is
specified by NUBUS-SLOT (top 8 bits) and the byte offset into the slot SLOT-BYTE-ADR (low
24 bits).  Returns NIL.")

;;; Next opcode is reserved for when (and if) implemented.
;;;(Def-Misc-OP %NuBus-Write-32B   222 (Hi-Address Low-Address Data) T)
(Def-Misc-Op %blt-to-physical   223		;1045
	(source-address destination-address number-of-words increment) :Lisp-FUnction-P T)
(Def-Misc-Op %blt-from-physical 224		;1046
	(source-address destination-address number-of-words increment) :Lisp-FUnction-P T)

(Def-Misc-Op %IO-SPACE-WRITE    225 (ADR-HI-8B ADR-LO-24B VALUE) :Lisp-Function-P T :Interpreter-Definition T
	     :documentation "Write VALUE to IO Space.")

(Def-Misc-Op %TEST&STORE-68K    226 (slot offset old new) :Lisp-Function-P T
   :documentation "Test for old in address specified by SLOT and OFFSET, then stores new
if current value = old. There is no transporting. Return T if word is not already set, else NIL.")

(Def-Misc-Op %TEST&SET-68K      227 (slot offset) :Lisp-Function-P T
   :documentation "Test for 1 (then set it) in high bit of byte specified by SLOT and OFFSET.
Return T if bit is not already set, else NIL.")

;;; Predicates usually D-INDS
(Def-Misc-Op FLOATP          230 (X) :Lisp-Function-P T		;334
	     :documentation "T if X is a floating point number of any size.  Never an error.")
(Def-Misc-Op LENGTH-GREATERP 231 (LIST-OR-ARRAY VALUE) :Lisp-FUnction-P T	;407
	     :documentation "This is equivalent to (> (length LIST-OR-ARRAY) VALUE).
LIST-OR-ARRAY must be a list or an array, VALUE must be a Fixnum.")
(Def-Misc-Op INTERNAL-CHAR-EQUAL 232 (CH1 CH2) :Lisp-Function-P T)	;414
(Def-Misc-Op %STRING-EQUAL   233 (STRING1 INDEX1 STRING2 INDEX2 COUNT) :Lisp-FUnction-P T	;416
	     :documentation "T if COUNT characters of STRING1 at INDEX1 match those of STRING2 at INDEX2.
Similar to STRING-EQUAL, but args are slightly different and all required -- and it's faster.
The comparison ignores case unless ALPHABETIC-CASE-AFFECTS-STRING-COMPARISON is non-NIL.")
(Def-Misc-Op ARRAY-HAS-LEADER-P 234 (ARRAY) :Lisp-FUnction-P T	;503
	     :documentation "Returns T if ARRAY has a leader.")
(Def-Misc-Op GLOBAL:NLISTP          235 (X) :Lisp-FUnction-P T		;570
	     :documentation "T if X is not a list.  Currently (NLISTP NIL) is T, but it will change.")
(Def-Misc-Op NSYMBOLP        236 (X) :Lisp-FUnction-P T		;572
	     :documentation "T if X is not a symbol.")
(Def-Misc-Op FBOUNDP         237 (SYMBOL) :Lisp-FUnction-P T	;574
	     :documentation "T if SYMBOL has a function definition.")

(Def-Misc-Op BOUNDP            240 (SYMBOL) :Lisp-FUnction-P T	;576
	     :documentation "T if SYMBOL has a value, as a special variable.")
(Def-Misc-Op ARRAY-HAS-FILL-POINTER-P 241 (ARRAY) :Lisp-FUnction-P T	;750, d??
	     :documentation "T if ARRAY has a fill pointer.")
;;; 242
(Def-Misc-Op COMMON-LISP-LISTP 243 (OBJECT) :Lisp-FUnction-P T :Interpreter-Definition nil	;760
	     :documentation "T if OBJECT is a list (including the empty list), otherwise returns NIL.")
(Def-Misc-Op VECTORP           244 (OBJECT) :Lisp-FUnction-P T	;770
	     :documentation "T if OBJECT is a vector:  an array of rank 1.")
(Def-Misc-Op SIMPLE-VECTOR-P   245 (OBJECT) :Lisp-FUnction-P T	;771
	     :documentation "T if OBJECT is a simple general vector.
This is a simple array of rank 1 whose elements are unrestricted.
A simple array is one which is not displaced and has no fill pointer.")
(Def-Misc-Op SIMPLE-ARRAY-P    246 (OBJECT) :Lisp-FUnction-P T	;772
	     :documentation "T if OBJECT is a simple array, an array which is not displaced and has no fill pointer.")
(Def-Misc-Op SIMPLE-STRING-P   247 (OBJECT) :Lisp-FUnction-P T	;773
	     :documentation "T if OBJECT is a simple string, a string which is not displaced and has no fill pointer.")

(Def-Misc-Op BIT-VECTOR-P      250 (OBJECT) :Lisp-FUnction-P T	;774
	     :documentation "T if OBJECT is a bit vector, an array of rank 1 whose elements are restricted to 0 and 1.")
(Def-Misc-Op SIMPLE-BIT-VECTOR-P 251 (OBJECT) :Lisp-FUnction-P T	;775
	     :documentation "T if OBJECT is a simple bit vector, one which is not displaced and has no fill pointer.")
(Def-Misc-Op TYPEP-STRUCTURE-OR-FLAVOR 252 (OBJECT TYPE) :Lisp-FUnction-P T)	;777
(DEF-MISC-OP SMALL-FLOATP      253 (OBJECT) :Lisp-FUnction-P T	;1001
	     :documentation "T if OBJECT is of type SHORT-FLOAT (a small flonum).")
(DEF-MISC-OP CHARACTERP        254 (OBJECT) :Lisp-FUnction-P T	;1002
	     :documentation "T if OBJECT is a character.")
(DEF-MISC-OP ENDP              255 (LIST) :Lisp-FUnction-P T	;1013
	     :documentation "T if LIST is nil, NIL if LIST is a cons cell.")
(DEF-MISC-OP Rationalp         256 (X) :Lisp-FUnction-P T	;1040
	     :documentation "T if X is a ratio or an integer.  Never an error.")
(DEF-MISC-OP Ratiop            257 (X) :Lisp-FUnction-P T	;1041
	     :documentation "T if X is a ratio.  Never an error.")

(DEF-MISC-OP Complexp          260 (X) :Lisp-FUnction-P T	;1042
	     :documentation "T if X is a complex number.  Never an error.")
(Def-Misc-Op EQ-T              261 (OBJECT) :Lisp-FUnction-P NIL)
(Def-Misc-Op Single-Floatp     262 (OBJECT) :Lisp-Function-P T
	     :documentation "T if OBJECT is of type SINGLE-FLOAT.")
(Def-Misc-Op Double-Floatp     263 (OBJECT) :Lisp-Function-P T
	     :documentation "T if OBJECT is of type DOUBLE-FLOAT.")
;;264-267

;; List functions to INDS
(Def-Misc-Op RPLACA   300 (CONS NEW-CAR) :Lisp-FUnction-P T	;327
	     :documentation "Modifies the CAR of CONS to contain NEW-CAR.  Returns CONS.")
(Def-Misc-Op RPLACD   301 (CONS NEW-CDR) :Lisp-FUnction-P T	;330
	     :documentation "Modifies the CDR of CONS to contain NEW-CDR.  Returns CONS.")
(Def-Misc-Op SETCAR   302 (CONS NEWCAR) :Lisp-FUnction-P T)	;724
(Def-Misc-Op SETCDR   303 (CONS NEWCDR) :Lisp-FUnction-P T)	;725
(Def-Misc-Op CONSP-OR-POP 304 (OBJECT))	;1014
;; 305-306
;;; Sequence fns D-INDS
(Def-Misc-Op SETELT   307 (SEQUENCE INDEX VALUE) :Lisp-FUnction-P T)	;711

;;; Symbols D-INDS
(Def-Misc-Op SET           310 (SYMBOL VALUE) :Lisp-Function-P T :Interpreter-Definition NIL	;332
	     :documentation "Modifies the value of SYMBOL to be VALUE.
/(SET 'FOO 'BAR) changes the value of the symbol FOO.
May not be used to change local variables in compiled code.")
;; 311-317

;; Array to Inds 
(Def-Misc-Op STORE-ARRAY-LEADER 320 (VALUE ARRAY INDEX) :Lisp-FUnction-P T	;431
	     :documentation "Stores VALUE into leader slot INDEX of ARRAY.")
(Def-Misc-Op AS-1         321 (VALUE ARRAY SUB) :Lisp-FUnction-P T)	;515
(Def-Misc-Op AS-2         322 (VALUE ARRAY SUB1 SUB2) :Lisp-FUnction-P T)	;516
(Def-Misc-Op AS-3         323 (VALUE ARRAY SUB1 SUB2 SUB3) :Lisp-FUnction-P T)	;517
(Def-Misc-Op AS-1-FORCE   324 (VALUE ARRAY INDEX) :Lisp-FUnction-P T	;715
	     :documentation "Store VALUE into element INDEX of ARRAY, treated as one-dimensional.
ARRAY is treated as one-dimensional in that it is indexed with
a single subscript regardless of its rank.")
(Def-Misc-Op GLOBAL:AS-2-REVERSE 325 (VALUE ARRAY INDEX2 INDEX1) :Lisp-FUnction-P T	;540
	     :documentation "Store VALUE in ARRAY, optionally reversing the indices.
While arrays are stored with first index varying fastest,
this is the same as ASET.  When arrays are stored with last index varying fastest,
this uses INDEX1 as the first index even though it is the last argument.")
;; 326-327

(Def-Misc-Op SET-ARRAY-LEADER 330 (ARRAY INDEX VALUE) :Lisp-FUnction-P T)	;745
(Def-Misc-Op SET-AR-1     331 (ARRAY SUBSCRIPT VALUE) :Lisp-FUnction-P T)	;740
(Def-Misc-Op SET-AR-2     332 (ARRAY SUBSCRIPT1 SUBSCRIPT2 VALUE) :Lisp-FUnction-P T)	;741
;; 333
(Def-Misc-Op SET-AR-3     334 (ARRAY SUBSCRIPT1 SUBSCRIPT2 SUBSCRIPT3 VALUE) :Lisp-FUnction-P T)	;742
(Def-Misc-Op SET-AR-1-FORCE 335 (ARRAY SUBSCRIPT VALUE) :Lisp-FUnction-P T)	;743
;; 336-337

(Def-Misc-Op GLOBAL:ARRAY-PUSH   340 (ARRAY VALUE) :Lisp-FUnction-P T	;433
	     :documentation "Add VALUE as an element at the end of ARRAY.
The fill pointer (leader element 0) is the index of the next element to
be added.  Returns NIL and does no add the element if the array is full;
use ARRAY-PUSH-EXTEND instead if you want the array to grow automatically.")
(Def-Misc-Op VECTOR-PUSH  341 (NEW-ELEMENT VECTOR) :Lisp-FUnction-P T	;747
	     :documentation "Add NEW-ELEMENT as an element at the end of VECTOR.
The fill pointer (leader element 0) is the index of the next element to
be added.  If the array is full, VECTOR-PUSH returns NIL and the array is 
unaffected;  use VECTOR-PUSH-EXTEND instead if you want the array to grow 
automatically.")
(Def-Misc-Op COPY-ARRAY-CONTENTS 342 (FROM TO) :Lisp-FUnction-P T	;500
	     :documentation "Copy all the elements of the array FROM into TO.
If TO is longer than FROM, it is filled out with zeros (if numeric array) or NILs.
If either array is multidimensional, its elements are used in the order
they are stored in memory.")
(Def-Misc-Op COPY-ARRAY-CONTENTS-AND-LEADER 343 (FROM TO) :Lisp-FUnction-P T	;501
	     :documentation "Copy all the elements and leader slots of the array FROM into TO.
If TO is longer than FROM, it is filled out with zeros (if numeric array) or NILs.
If either array is multidimensional, its elements are used in the order
they are stored in memory.")
(Def-Misc-Op COPY-ARRAY-PORTION 344 (FROM-ARRAY FROM-START FROM-END TO-ARRAY TO-START TO-END) :Lisp-FUnction-P T	;504
	     :documentation "Copies specified elements of FROM-ARRAY into TO-ARRAY.
FROM-START and FROM-END are indices in FROM-ARRAY indicating the portion to copy.
TO-START and TO-END are indices in TO-ARRAY.  If the specified portion of
TO-ARRAY is longer, it is filled out with zeros (if TO-ARRAY is a numeric array) or NILs.
If either array is multidimensional, its elements are used in the order
they are stored in memory.")
(Def-Misc-Op BITBLT 345 (ALU WIDTH HEIGHT FROM-ARRAY FROM-X FROM-Y TO-ARRAY TO-X TO-Y) :Lisp-FUnction-P T	;665
	     :documentation "Features:
   The X and Y arguments specify the coordinates of the upper-left-hand
   corner of the WIDTH by HEIGHT region to be operated on.  The operation
   is normally performed top to bottom then left to right, but making
   WIDTH or HEIGHT negative will make it go the other way, useful when
   regions overlap.  The X and Y should still be for the top-left corner.

   Works on any numeric array type.  For more than 1-bit bytes, the X 
   and Y arguments are in bytes rather than bits.

   If you run off the edge of the source array, it wraps around
   to the opposite edge.  This is intended to allow such
   things as replication of small stipple patterns through a large screen
   area. If you run off the edge of the destination array, an error occurs.

   The function cannot be made to reference outside of the argument arrays
   by giving it bad arguments.

   If the source array is art-1b and the destination is art-8b, the zeros in
   the source array will be expanded to the current system background color
   and ones will be expanded to the current system foreground color in the 
   destination array.  This requires WIDTH and HEIGHT to be positive.

Crocks:
   Requires that the first dimension of the array be a multiple of 32. bits.
   Index-offset arrays do not work with wrap-around.")
(Def-Misc-Op %BLT              346 (FROM-ADDRESS TO-ADDRESS COUNT INCREMENT) :Lisp-FUnction-P T		;467
	     :documentation "Copy a block of memory, a word at a time, with no decoding, for untyped data.
Use %BLT-TYPED for words which contain Lisp data types.
The first word is copied from FROM-ADDRESS to TO-ADDRESS.
INCREMENT is added to each address and then another word is copied, and so on.
COUNT is the number of words to copy.")
(Def-Misc-Op %BLT-TYPED        347 (FROM-ADDRESS TO-ADDRESS COUNT INCREMENT) :Lisp-FUnction-P T		;712
	     :documentation "Copy a block of memory, a word at a time, with no decoding, for typed data.
Use %BLT for words of raw bits which do not contain Lisp data types.
The first word is copied from FROM-ADDRESS to TO-ADDRESS.
INCREMENT is added to each address and then another word is copied, and so on.
COUNT is the number of words to copy.")

;;; Instance support to stack
;; 350-353.  7/14/87, ab.  Add :LISP-FUNCTION-P T.  [SPR 4436]
(Def-Misc-Op SET-%INSTANCE-REF 354 (INSTANCE INDEX VALUE) :Lisp-Function-P T	;746
	     :documentation "Set contents of slot INDEX in INSTANCE to VALUE.  1 is the lowest valid index.")

(Def-Misc-op %DISPATCH-METHOD  355 (hashtable permuatation-list) 
             :documentation "Dispatches on the correct CLOS method if it can be determined.")

(Def-Misc-op %CLASS-DESCRIPTION  356 (object) :LISP-FUNCTION-P t
             :documentation "Returns the CLOS class-description for object.")
;; 357

(Def-Misc-Op %CHANGE-PAGE-STATUS   360 (VIRT-ADDR SWAP-STATUS ACCESS-AND-META) :Lisp-Function-P T)
;;(Def-Misc-Op %ADD-PAGE-DEVICE      361 (unit-number starting-block size) :Lisp-Function-P T)	;may don't have
(Def-Misc-Op %DELETE-PHYSICAL-PAGE 362 (PHYS-ADDR) :Lisp-Function-P T)
(Def-Misc-Op %PAGE-IN              363 (PFN VPN) :Lisp-Function-P T)
(DEF-MISC-OP %LOAD-MEMORY-MAP      364 (Virt-Addr Map-Valid-Bit Phys-Pg-Nbr Map-Control-Field) :Lisp-Function-P T
	     :documentation "Manipulate the hardware memory map associated with virtual address VIRT-ADDR.
The specific action taken depends on the MAP-VALID-BIT:
  NIL  Means just read the map contents and return them.  The two values returned are the LVL2 address
       and LVL2 control fields, or NIL NIL if no h/w map currently exists for VIRT-ADDR.
  0    Means deallocate the level 2 map if one exists.
  1    Means write the values PHYS-PG-NBR and MAP-CONTROL-FIELD to the level 2 map (one is
       allocated if it didn't previously exist).  PHYS-PG-NBR is the 22-bit physical page number
       where the virtual page resides.  It is stored in the LVL2 address field.  MAP-CONTROL-FIELD
       is stored into the LVL2 control register.")
;; 365-367

;; Random %-fns
(Def-Misc-Op %WRITE-INTERNAL-PROCESSOR-MEMORIES 370 (CODE ADR D-HI D-LOW) :Lisp-Function-P T)	;656
(Def-Misc-Op %PAGE-TRACE   371 (TABLE) :Lisp-Function-P T)	;446
(Def-Misc-Op %RECORD-EVENT      372 (DATA-4 DATA-3 DATA-2 DATA-1 STACK-LEVEL EVENT MUST-BE-4) :Lisp-Function-P T)	;705
;; 373-377

;;; 400-777 usually D-PDL
;; Stack
(Def-Misc-Op %MAKE-STACK-LIST 400 (N) :Lisp-Function-P T :Interpreter-Definition NIL)	;541
(Def-Misc-Op %MAKE-EXPLICIT-STACK-LIST 401 (LENGTH) :Lisp-Function-P T :Interpreter-Definition NIL)	;677
(Def-Misc-Op %MAKE-EXPLICIT-STACK-LIST* 402 (LENGTH) :Lisp-Function-P T :Interpreter-Definition NIL)	;723
(Def-Misc-Op %MAKE-STACK-LIST* 403 (N) :Lisp-Function-P T :Interpreter-Definition NIL)	;
(Def-Misc-Op %STACK-FRAME-POINTER 404 () :Lisp-Function-P T :Interpreter-Definition NIL	;635
	     :documentation "Returns a locative pointing at the current stack frame.
This happens to be the same as a pointer to local 0.")
(Def-Misc-Op SPECIAL-PDL-INDEX 405 NIL :Lisp-Function-P T)	;644
(Def-Misc-Op UNBIND-TO-INDEX-MOVE 406 (SPECIAL-PDL-INDEX VALUE-TO-MOVE))	;646
;; 407

;; Consing
(Def-Misc-Op GLOBAL:NCONS         410 (CAR) :Lisp-FUnction-P T		;364
	     :documentation "Returns (CONS X NIL).")
(Def-Misc-Op GLOBAL:NCONS-IN-AREA 411 (CAR AREA) :Lisp-FUnction-P T	;365
	     :documentation "Returns (CONS-IN-AREA X NIL AREA).")
(Def-Misc-Op CONS          412 (CAR CDR) :Lisp-FUnction-P T	;366
	     :documentation "Returns a newly allocated CONS whose CAR is CAR and CDR is CDR.")
(Def-Misc-Op CONS-IN-AREA  413 (CAR CDR AREA) :Lisp-FUnction-P T	;367
	     :documentation "Returns a newly allocated CONS in area AREA whose CAR is CAR and CDR is CDR.
AREA is an area number, such as WORKING-STORAGE-AREA.")
(Def-Misc-Op %MAKE-LIST    414 (INITIAL-VALUE AREA LENGTH) :Lisp-FUnction-P T	;435
	     :documentation "Construct a cdr-coded list of the specified LENGTH, each element being
INITIAL-VALUE, in the specified AREA.")
(Def-Misc-Op %ALLOCATE-AND-INITIALIZE 415 (RETURN-DTP HEADER-DTP HEADER WORD2 AREA NQS) :Lisp-FUnction-P T)	;615
(Def-Misc-Op %ALLOCATE-AND-INITIALIZE-ARRAY 416 (HEADER INDEX-LENGTH LEADER-LENGTH AREA NQS) :Lisp-FUnction-P T)	;616
(DEF-MISC-OP %Ratio-Cons        417 (Numerator Denominator) :Lisp-FUnction-P T	;not in use but should be!!  ,  1037
	     :documentation "Returns the ratio NUMERATOR\DENOMINATOR.")

(Def-Misc-Op %Allocate-and-Initialize-Instance 420 (header area nqs) :Lisp-Function-P T :Interpreter-Definition NIL
	     :documentation "Allocates storage for an instance, sets header type to DTP-Instance-Header
and sets data type to DTP-Instance.  Fills allocated space with 'nulls' and 
places header in word 0.")
(Def-Misc-Op %MAKE-LIST*    421 (INITIAL-VALUE AREA LENGTH) :Lisp-FUnction-P T
	     :documentation "Construct a cdr-coded list of the specified LENGTH with the last pair not cdr-coded,
each element being INITIAL-VALUE, in the specified AREA. This is better than %make-list if Rplacd is going
to be use on the last element.")

(Def-Misc-Op %ALLOCATE-AND-INITIALIZE-SYMBOL 422 (PNAME AREA) :Lisp-FUnction-P T
	     :documentation "Builds an uninterned symbol block")	;JLM 5/17/89


;; 423-427

;; I/O
(Def-Misc-Op %PHYSICAL-ADDRESS 430 (PTR) :Lisp-FUnction-P T	;667
	     :documentation "Return the address in core of the page which contains PTR.
The value is a fixnum which may be negative.
Only the pointer field of PTR is significant.")
(Def-Misc-Op %MULTIBUS-READ-16 431 (MULTIBUS-BYTE-ADR) :Lisp-FUnction-P T)	;732
(Def-Misc-Op %MULTIBUS-READ-8  432 (MULTIBUS-BYTE-ADR) :Lisp-FUnction-P T)	;734
(Def-Misc-Op %MULTIBUS-READ-32 433 (MULTIBUS-BYTE-ADR) :Lisp-FUnction-P T)	;736
(Def-Misc-Op %NUBUS-READ       434 (NUBUS-SLOT SLOT-BYTE-ADR) :Lisp-FUnction-P T	;761
	     :documentation "Read a 32-bit value from the NuBus.  The NuBus address is
specified by NUBUS-SLOT (top 8 bits) and the byte offset into the slot SLOT-BYTE-ADR (low
24 bits).  Returns the contents of the address as a number if the access completes
successfully; else signals an error.")
(Def-Misc-Op %NuBus-Read-8B    435 (NUBUS-SLOT SLOT-BYTE-ADR) :Lisp-FUnction-P T	;1030
	     :documentation "Read a byte from the NuBus.  The NuBus address is
specified by NUBUS-SLOT (top 8 bits) and the byte offset into the slot SLOT-BYTE-ADR (low
24 bits).  Returns the contents of the address as a fixnum if the access completes
successfully; else signals an error.")
(Def-Misc-Op %NuBus-Read-16B   436 (NUBUS-SLOT SLOT-BYTE-ADR) :Lisp-FUnction-P T	;1032
	     :documentation "Read a 16-bit value from the NuBus.  The NuBus address is
specified by NUBUS-SLOT (top 8 bits) and the byte offset into the slot SLOT-BYTE-ADR (low
24 bits).  Returns the contents of the address as a fixnum if the access completes
successfully; else signals an error.")

;;; Next opcode is reserved for when (and if) implemented.
;;;(Def-Misc-Op %NuBus-Read-32B 437 (NUBUS-SLOT SLOT-BYTE-ADR) T) ;1034

(Def-Misc-Op %NuBus-Read-8B-Careful 440 (NUBUS-SLOT SLOT-BYTE-ADR) :Lisp-FUnction-P T	;1036
	     :documentation "Read a byte from the NuBus.  The NuBus address is specified
by NUBUS-SLOT (top 8 bits) and the byte offset into the slot SLOT-BYTE-ADR (low 24 bits).
Returns the contents of the address as a fixnum if the access completes successfully.
  If the access is not successful, either the symbol T or the symbol NIL will be returned
rather than signalling an error.  If the addressed device signals an error NIL is returned.
If there is a bus timeout T is returned.  If a GACBL is encountered it is retried.  After
a very large number of retries an error is assumed and NIL is returned.")

;;#e-24 AB 9/4/87
(Def-Misc-Op %IO-SPACE-READ       441 (ADR-HI-8B ADR-LO-24B) :Lisp-Function-P T :Interpreter-Definition T
	     :documentation "Read a 32-bit value from IO Space.")

;; 442-443

;;; %-functions
;; 444
(Def-Misc-Op %POINTER      445 (X) :Lisp-FUnction-P T
	     :documentation "Return the address or pointer-field of X.")
(Def-Misc-Op %MAKE-POINTER 446 (DTP ADDRESS) :Lisp-FUnction-P T
	     :documentation "Create a lisp datum given a data type code DTP and pointer ADDRESS.")
(Def-Misc-Op %MAKE-POINTER-OFFSET 447 (NEW-DTP POINTER OFFSET) :Lisp-FUnction-P T
	     :documentation "Given data-type NEW-DTP and address as POINTER+OFFSET, fake up a Lisp object.")

(Def-Misc-Op %DATA-TYPE    450 (X) :Lisp-FUnction-P T
	     :documentation "Return the data-type field of X.
The value is a number less than 32.  The data types are all standard
and have names on the list Q-DATA-TYPES, such as DTP-SYMBOL for symbols.")
(Def-Misc-Op %P-CDR-CODE   451 (POINTER) :Lisp-FUnction-P T
	     :documentation "Returns the cdr-code value of the word addressed by POINTER.
This is a number from 0 to 3.  The values have standard names
which are CDR-NEXT, CDR-NIL, CDR-NORMAL and CDR-ERROR.
POINTER's data type is ignored -- it can even be a fixnum.")
(Def-Misc-Op %P-DATA-TYPE  452 (POINTER) :Lisp-FUnction-P T
	     :documentation "Returns the data type field of the word addressed by POINTER.
This is similar to (%DATA-TYPE (CAR (%MAKE-POINTER DTP-LIST POINTER))),
except that if the word contains an illegal data type or a forwarding pointer,
this function returns the illegal data type or the data type of the forwarding pointer.
POINTER's data type is ignored -- it can even be a fixnum.")
(Def-Misc-Op %P-POINTER    453 (POINTER) :Lisp-FUnction-P T
	     :documentation "Returns the pointer field of the word addressed by POINTER.
This is similar to (%POINTER (CAR (%MAKE-POINTER DTP-LIST POINTER))),
except that if the word contains an illegal data type or a forwarding pointer,
this function returns address field actually in the memory location
rather than getting an error or forwarding.
POINTER's data type is ignored -- it can even be a fixnum.")
(Def-Misc-Op %P-LDB        454 (PPSS POINTER) :Lisp-FUnction-P T
	     :documentation "Return the contents of byte PPSS in the word addressed by POINTER.
This byte can include any of the bits in the word, and can overlap
between the various fields normally used by Lisp.
But it may not be more than 23. bits long.
POINTER's data type is ignored -- it can even be a fixnum.")
(Def-Misc-Op %P-MASK-FIELD 455  (PPSS POINTER) :Lisp-FUnction-P T
	     :documentation "Return (MASK-FIELD PPSS (%P-POINTER POINTER)).")
(Def-Misc-Op %P-CONTENTS-OFFSET 456 (POINTER OFFSET) :Lisp-FUnction-P T
	     :documentation "Returns the contents of the word OFFSET beyond that addressed by POINTER.
This is not the same as (%P-CONTENTS (%MAKE-POINTER-OFFSET ... POINTER OFFSET))
because it checks for a forwarding pointer in the word addressed by POINTER.
The idea is that POINTER points at the beginning of a structure
and OFFSET is an offset within it.")
(Def-Misc-Op %P-LDB-OFFSET 457 (PPSS POINTER OFFSET) :Lisp-FUnction-P T
	     :documentation "Returns the contents of byte PPSS in the word OFFSET beyond POINTER.
This is not the same as (%P-LDB PPSS (%MAKE-POINTER-OFFSET ... POINTER OFFSET))
because it checks for a forwarding pointer in the word addressed by POINTER.
The idea is that POINTER points at the beginning of a structure
and OFFSET is an offset within it.")
(Def-Misc-Op %P-MASK-FIELD-OFFSET 460 (PPSS POINTER OFFSET) :Lisp-FUnction-P T
	     :documentation "MASK-FIELD of PPSS from the contents of the word OFFSET beyond POINTER.
This is not the same as (%P-MASK-FIELD PPSS (%MAKE-POINTER-OFFSET ... POINTER OFFSET))
because it checks for a forwarding pointer in the word addressed by POINTER.
The idea is that POINTER points at the beginning of a structure
and OFFSET is an offset within it.")
(Def-Misc-Op %P-CONTENTS-AS-LOCATIVE 461 (POINTER) :Lisp-FUnction-P T
	     :documentation "Returns a locative whose pointer field is copied from the word POINTER points to.
If you have determined that that word contains a datum that points at memory,
this is a good way to find the object it points to without getting things
confused by forwarding or by DTP-NULL or by header data types.")
(Def-Misc-Op %P-CONTENTS-AS-LOCATIVE-OFFSET 462 (POINTER OFFSET) :Lisp-FUnction-P T
	     :documentation "Like %P-CONTENTS-AS-LOCATIVE but fetches the word OFFSET beyond where POINTER points.
This is not the same as (%P-CONTENTS-AS-LOCATIVE (%MAKE-POINTER-OFFSET ... POINTER OFFSET))
because it checks for a forwarding pointer in the word addressed by POINTER.
The idea is that POINTER points at the beginning of a structure
and OFFSET is an offset within it.")
(Def-Misc-Op %POINTER-DIFFERENCE 463 (PTR1 PTR2) :Lisp-FUnction-P T
	     :documentation "Return the number of words difference between two pointers.
They had better be locatives into the same object for this operation to be meaningful;
otherwise, their relative position will be changed by GC.")
;;; Random %-fns
(Def-Misc-Op %STORE-CONDITIONAL 464 (POINTER OLD NEW) :Lisp-FUnction-P T	;634
	     :documentation "Store NEW into POINTER if the old contents of POINTER match OLD.
Returns T if the store was done, otherwise NIL.
This is a basic interlocking primitive, which can be used to simulate
any sort of atomic test-and-modify operation.")
;; 465-467

;;; Time
(Def-Misc-Op %MICROSECOND-TIME        470 () :Lisp-FUnction-P T) ; Returns 32 bits maybe as a bignum, 763
(Def-Misc-Op %FIXNUM-MICROSECOND-TIME 471 () :Lisp-FUnction-P T)	;764
(Def-Misc-Op TIME-IN-60ths            472 () :Lisp-FUnction-P T)	;1051
;; 473

;;; Paging
(Def-Misc-Op %PAGE-STATUS       474 (PTR) :Lisp-Function-P T)	;657
(Def-Misc-Op %COMPUTE-PAGE-HASH 475 (ADDR) :Lisp-Function-P T)	;553
(Def-Misc-Op %FINDCORE          476 () :Lisp-Function-P T)	;674
;;;(Def-Misc-Op FREE-PAGE-CLUSTER-COUNT 477 (page-device-number) :Lisp-Function-P T	;1053
;;;	     :documentation "Returns the number of free clusters for the swap band indicated.")

;; GC
(Def-Misc-Op %AREA-NUMBER 500 (X) :Lisp-FUnction-P T		;561
	     :documentation "Returns the area number of the area the pointer X points into.")
(Def-Misc-Op %REGION-NUMBER 501 (PTR) :Lisp-FUnction-P T	;660
	     :documentation "Return the number of the region PTR points into.
Only the %POINTER field of PTR is significant.")
(Def-Misc-Op %FIND-STRUCTURE-HEADER 502 (PTR) :Lisp-FUnction-P T	;661
	     :documentation "Given a locative return the object containing it.
Finds the overall structure containing the cell addressed by the locative pointer.")
(Def-Misc-Op %STRUCTURE-BOXED-SIZE 503 (PTR) :Lisp-FUnction-P T	;662
	     :documentation "Returns the number of normal Lisp pointers in the object indicated by PTR.
This many words at the beginning of the object contain normal Lisp data.
The remaining words contain just numbers (such as the instructions of a compiled function,
or the data in a numeric array).")
(Def-Misc-Op %STRUCTURE-TOTAL-SIZE 504 (PTR) :Lisp-FUnction-P T	;663
	     :documentation "Returns the number of words in the object indicated by PTR.")
(Def-Misc-Op %MAKE-REGION 505 (BITS SIZE))	;664
(Def-Misc-Op %FIND-STRUCTURE-LEADER 506 (PTR) :Lisp-FUnction-P T	;672
	     :documentation "Given a locative return the object containing it.
This is like %FIND-STRUCTURE-HEADER except that it always returns the base of the
structure; thus for an array with a leader it gives a locative to the base instead
of giving the array.")
;; 507

;;
;;; Arithmetic
(Def-Misc-Op GLOBAL:FIX            510 (NUMBER) :Lisp-FUnction-P T	;647
	     :documentation "Convert NUMBER to an integer, which is less than or equal to NUMBER.")
(Def-Misc-Op SMALL-FLOAT    511 (NUMBER) :Lisp-FUnction-P T	;651
	     :documentation "Convert NUMBER to a small flonum.")
(Def-Misc-Op INTERNAL-FLOAT 512 (NUMBER) :Lisp-Function-P T)    ;307
(Def-Misc-Op ABS            513 (NUMBER) :Lisp-FUnction-P T	;627
	     :documentation "Returns the absolute value of NUMBER, which can be any type of number, even complex.")
(Def-Misc-Op GLOBAL:MINUS          514 (NUMBER) :Lisp-FUnction-P T	;357
	     :documentation "Returns zero minus NUMBER.")
(Def-Misc-Op HAULONG        515 (INTEGER) :Lisp-FUnction-P T	;614
	     :documentation "Returns the /"size/" of INTEGER in bits.  The size of 777 is nine bits.")
(Def-Misc-Op FLOAT-EXPONENT 516 (FLONUM) :Lisp-FUnction-P T	;435
	     :documentation "Return as an integer the exponent of FLONUM, a floating point number.")
(Def-Misc-Op FLOAT-FRACTION 517 (FLONUM) :Lisp-FUnction-P T	;454
	     :documentation "Return FLONUM modified to contain 0 as its exponent.
The result is either zero or has abs value at least 1//2 and less than one.")

(Def-Misc-Op LDB           520 (PPSS WORD) :Lisp-FUnction-P T	;315
	     :documentation "Load a byte specified by PPSS out of the number WORD.
PPSS is a number whose printed representation in octal, as four digits,
 contains a two-digit position-within-word and a two-digit size.
The position is the number of low bits of WORD after the desired byte.")
(Def-Misc-Op %LOGLDB       521 (PPSS WORD) :Lisp-FUnction-P T	;THESE DONT COMPLAIN ABOUT LOADING/CLOBBERING SIGN, 313
	     :documentation "Fixnums-only form of LDB.
No complaint about loading//clobbering the sign bit.")
(Def-Misc-Op MASK-FIELD    522 (PPSS FIXNUM) :Lisp-FUnction-P T	;474
	     :documentation "Return a number which is FIXNUM with all but the byte PPSS replaced by zero.")
;; 523
(Def-Misc-Op DPB           524 (VALUE PPSS WORD) :Lisp-FUnction-P T	;316
	     :documentation "Deposit VALUE into the byte PPSS of the number WORD, returning a new number.
PPSS is a number whose printed representation in octal, as four digits,
 contains a two-digit position-within-word and a two-digit size.
The position is the number of low bits of WORD after the desired byte.")
(Def-Misc-Op %LOGDPB       525 (VALUE PPSS WORD) :Lisp-FUnction-P T	;RESULT IS ALWAYS A FIXNUM, 314
	     :documentation "Fixnums-only form of DPB.
No complaint about loading//clobbering the sign bit.")
(Def-Misc-Op DEPOSIT-FIELD 526 (VALUE PPSS FIXNUM) :Lisp-FUnction-P T	;476
	     :documentation "Returns a number which in the byte PPSS matches VALUE, and the rest matches FIXNUM.")
;; 527

(Def-Misc-Op LSH    530 (N NBITS) :Lisp-FUnction-P T		;350
	     :documentation "Logical shift N by NBITS.  Sign controls direction of shift.  N must be a fixnum.")
(Def-Misc-Op ASH    531 (N NBITS) :Lisp-FUnction-P T		;676
	     :documentation "Shift N arithmetically by NBITS.  N must be an integer.")
(Def-Misc-Op ROT    532 (N NBITS) :Lisp-FUnction-P T		;351
	     :documentation "Rotate the 24 bits of the fixnum N by NBITS.")
(Def-Misc-Op *BOOLE 533 (FN ARG1 ARG2))		;352
(Def-Misc-Op (MAX MAX *MAX)  534 (NUM1 NUM2))	;562
(Def-Misc-Op (MIN MIN *MIN)  535 (NUM1 NUM2))	;563
(Def-Misc-Op (EXPT EXPT GLOBAL:^)  536 (Base Exponent) :Lisp-FUnction-P T
	     :documentation "Exponentiate BASE to the EXPONENT power.")
;; 537

(Def-Misc-Op (global:REMAINDER global:REMAINDER GLOBAL:\) 540 (X Y) :Lisp-FUnction-P T		;356
	     :documentation "Return the remainder of X divided by Y.")
(Def-Misc-Op (QUOTIENT QUOTIENT *QUO) 541 (NUM1 NUM2))		;424 
(Def-Misc-Op (LOGIOR LOGIOR *LOGIOR)  542 (NUM1 NUM2))		;427
(Def-Misc-Op (GCD GCD \\ INTERNAL-\\) 543 (NUM1 NUM2))	;577
(Def-Misc-Op %DIV        544 (DIVIDEND DIVISOR) :Lisp-Function-P T	;461
	     :documentation "Divide DIVIDEND by DIVISOR, returning a rational number if args are integers.")
(Def-Misc-Op SCALE-FLOAT 545 (FLONUM INTEGER) :Lisp-FUnction-P T	;455
	     :documentation "Return a flonum like FLONUM but with INTEGER added to its exponent.")
(Def-Misc-Op DOUBLE-FLOAT  546 (NUMBER) :Lisp-Function-P T             ;546
	     :documentation "Convert NUMBER to a double precision float.")

;; 547

(Def-Misc-Op FLOOR-1    550 (DIVIDEND DIVISOR)) ; one value to stack
(Def-Misc-Op CEILING-1  551 (DIVIDEND DIVISOR))
(Def-Misc-Op TRUNCATE-1 552 (DIVIDEND DIVISOR))
(Def-Misc-Op ROUND-1    553 (DIVIDEND DIVISOR))
(Def-Misc-Op FLOOR-2    554 (DIVIDEND DIVISOR)) ; two values to stack
(Def-Misc-Op CEILING-2  555 (DIVIDEND DIVISOR))
(Def-Misc-Op TRUNCATE-2 556 (DIVIDEND DIVISOR))
(Def-Misc-Op ROUND-2    557 (DIVIDEND DIVISOR))


;;; Predicates usually D-PDL
(Def-Misc-Op ZEROP	560 (NUMBER) :Lisp-FUnction-P T	;331, D-INDS mostly by BR-ZEROP
	     :documentation "T if NUMBER is zero.  Error if NUMBER is not a number.")
(Def-Misc-Op FIXP	561 (X)		;333, D-INDS by FIXP
   :documentation "T if X is an integer.  No error no matter what X is.")
(Def-Misc-Op EQUAL	562 (X Y)		;335, D-INDS by EQUAL
   :documentation "T if X and Y are EQ, or if they are lists whose elements are EQUAL.
Numbers are compared with EQL, so the answer is T if they have the same type and value.
Strings are compared by their contents, using STRING=.
Other kinds of arrays, however, are compared with EQ.")
(Def-Misc-Op (NOT NULL NOT)  563 (X) :Lisp-Function-P T		;342
	     :documentation "Returns T if X is NIL.")
(Def-Misc-Op ATOM	564 (X) :Lisp-FUnction-P T		;343, D-INDS mostly by BR-ATOM
	     :documentation "Returns T if X is not a CONS.")
(Def-Misc-Op NUMBERP	565 (X)	;353, D-INDS by NUMBERP
   :documentation "Returns T if X is a number.")
(Def-Misc-Op PLUSP	566 (NUMBER)	;354, D-INDS by PLUSP
   :documentation "Returns T if NUMBER is greater than zero.
Error if NUMBER is not a real number.")
(Def-Misc-Op MINUSP	567 (NUMBER)	;355, D-INDS by MINUSP
   :documentation "Returns T if NUMBER is less than zero.
Error if NUMBER is not a real number.")

(Def-Misc-Op (< < INTERNAL-<) 570 (NUM1 NUM2))	;411, D-INDS by <
(Def-Misc-Op (> > INTERNAL->) 571 (NUM1 NUM2))	;412, D-INDS by >
(Def-Misc-Op (= = INTERNAL-=) 572 (NUM1 NUM2))	;413, D-INDS by =
(Def-Misc-Op EQL        573 (X Y) :Lisp-FUnction-P T :Interpreter-Definition nil	;511, D-INDS by EQL
	     :documentation "Like = when both arguments are numbers of the same type;  like EQ otherwise.")
(Def-Misc-Op EQ		574 (X Y)		;633, D-INDS by EQ
   :documentation "T if X and Y are the same Lisp object.")
(Def-Misc-Op EQUALP	575 (X Y)	;722, D-INDS by EQUALP
   :documentation "Like EQUAL but ignores case and numeric type, and looks at elts of arrays.
Strings are compared by their contents, using STRING-EQUAL.
Other arrays are just compared elementwise.
All numbers are passed to =, so that 0 and 0.0 give T.")
(Def-Misc-Op LISTP	576 (X)		;567, D-INDS by LISTP
   :lisp-function-p t
   :documentation "T if X is a list.  Currently this does not include NIL, but it will change.")
(Def-Misc-Op SYMBOLP    577 (X) :Lisp-FUnction-P T		;571, D-INDS mostly by BR-SYMBOLP
	     :documentation "T if X is a symbol.")

(Def-Misc-Op ARRAYP      600 (X) :Lisp-FUnction-P T :Interpreter-Definition nil      ;573, D-INDS by ARRAYP
	     :documentation "T if X is an array.")
(Def-Misc-Op STRINGP     601 (X) :Lisp-FUnction-P T :Interpreter-Definition nil      ;575, D-INDS by STRINGP
	     :documentation "T if X is a string.")
(Def-Misc-Op FIXNUMP     602 (OBJECT) :Lisp-FUnction-P T :Interpreter-Definition nil ;1000, D-INDS by FIXNUMP
	     :documentation "T if OBJECT is a fixnum;  an integer close enough to zero to require no storage.")
(Def-Misc-Op (NAMED-STRUCTURE-P NAMED-STRUCTURE-SYMBOL NAMED-STRUCTURE-P)
	     603 (OBJECT) :Lisp-FUnction-P T	;776
	     :documentation "If OBJECT is a named-structure, return its structure type keyword, otherwise NIL.")
;; 604-607

;;; List functions usually to PDL
(Def-Misc-Op GLOBAL:ASSQ   610 (X ALIST) :Lisp-FUnction-P T		;322
	     :documentation "Search association list ALIST for X.
An association list is a list of lists.  The keys are the CARs of the elements.
ALIST is searched for an element whose CAR is X.
That element is returned.  If there is none, NIL is returned.")
(Def-Misc-Op LAST   611 (LIST) :Lisp-FUnction-P T		;323
	     :documentation "Return the last cons-cell in LIST.
Works by CDR'ing down LIST until it finds a cell whose CDR is not a cons.
That cell is the value.  The last element of the list is the cell's CAR.")
(Def-Misc-Op LENGTH 612 (LIST-OR-ARRAY) :Lisp-FUnction-P T	;324
	     :documentation "If LIST-OR-ARRAY is a list, returns the number of elements in LIST-OR-ARRAY.
If LIST-OR-ARRAY is an array, returns the active length of the array,
which is the value of the fill-pointer, if any, or else the number of elements
in the array.")
(Def-Misc-Op GLOBAL:MEMQ   613 (X LIST) :Lisp-FUnction-P T		;410
	     :documentation "Returns the first link in LIST whose CAR is EQ to X, or else NIL.")
(Def-Misc-Op NTH    614 (N LIST) :Lisp-FUnction-P T		;417
	     :documentation "Returns the N'th element of LIST.
Counting starts from 0, so element 1 is the CADR.")
(Def-Misc-Op NTHCDR 615 (N LIST) :Lisp-FUnction-P T		;420
	     :documentation "Discards N elements from LIST;  performs CDR N times.")
(Def-Misc-Op GLOBAL:FIND-POSITION-IN-LIST 616 (ELEMENT LIST) :Lisp-FUnction-P T	;505
	     :documentation "Returns a number N such that (NTH N LIST) is EQ to ELEMENT.
The value is NIL if ELEMENT is not an element of LIST.")
;; 617

(Def-Misc-Op CAR-SAFE 620 (OBJECT) :Lisp-FUnction-P T)		;1003
(Def-Misc-Op CDR-SAFE 621 (OBJECT) :Lisp-FUnction-P T)		;1004
(Def-Misc-Op CARCDR   622 (LIST))		;1012, two vals to stack
;; 623-624
;;; Sequence fns D-PDL
;(Def-Misc-Op ELT      625 (SEQUENCE INDEX) :Lisp-Function-P T	;641
;	     :documentation "Return element INDEX of SEQUENCE.  SEQUENCE is a vector or a list.
;Same as ELT except returns fixnums instead of char data-type for strings.")
(Def-Misc-Op (COMMON-LISP-ELT cli:elt common-lisp-elt) 626 (SEQUENCE INDEX) :Lisp-Function-P T	;1054
	     :documentation "Return element INDEX of SEQUENCE.  SEQUENCE is a vector or a list.")

;(Def-Misc-Op FSYMEVAL 627 (SYMBOL)		;600
;   :documentation "Returns the function definition of SYMBOL.")
(Def-Misc-Op (SYMBOL-FUNCTION global:FSYMEVAL Symbol-Function) 627 (SYMBOL) :Lisp-Function-P T	;600
	     :documentation "Returns the function definition of SYMBOL.")

;;; Symbols D-PDL
;;;(Def-Misc-Op GET-PNAME               630 (SYMBOL) :Lisp-FUnction-P T)	;347
(Def-Misc-Op (SYMBOL-NAME GLOBAL:GET-PNAME Symbol-Name) 631 (SYMBOL) :Lisp-Function-P T	;347
	     :documentation "Returns the pname-string of SYMBOL.")
(Def-Misc-Op VALUE-CELL-LOCATION     632 (SYMBOL) :Lisp-Function-P T	;361
	     :documentation "Returns a locative to the cell which holds SYMBOL's value.
This ignores such things as local variables of compiled code;
it always returns a pointer to the value-cell word inside SYMBOL.")
(Def-Misc-Op FUNCTION-CELL-LOCATION  633 (SYMBOL) :Lisp-Function-P T	;362
	     :documentation "Returns a locative to the cell inside SYMBOL that holds its function definition.")
(Def-Misc-Op PROPERTY-CELL-LOCATION  634 (SYMBOL) :Lisp-Function-P T	;363
	     :documentation "Returns a locative to the cell inside SYMBOL that holds its property list.")
(Def-Misc-Op SYMBOL-PACKAGE 635 (SYMBOL) :Lisp-Function-P T) 
;;(Def-Misc-Op SYMEVAL                 636 (SYMBOL) :Lisp-FUnction-P T)	;373
(Def-Misc-Op (SYMBOL-VALUE GLOBAL:SYMEVAL Symbol-Value)  636 (SYMBOL) :Lisp-Function-P T	;373
	     :documentation "Returns the contents of the value cell of SYMBOL.
This is the value that would be obtained by use of SYMBOL as a special variable.")
(Def-Misc-Op %EXTERNAL-VALUE-CELL    637 (SYMBOL) :Lisp-Function-P T)	;524

;;; Array usually to PDL
(Def-Misc-Op ARRAY-LEADER 640 (ARRAY INDEX) :Lisp-Function-P T	;430
	     :documentation "Returns the contents of leader slot INDEX of ARRAY.")
(Def-Misc-Op GLOBAL:AR-1         641 (ARRAY SUB) :Lisp-Function-P T)	;512
(Def-Misc-Op AR-2         642 (ARRAY SUB1 SUB2) :Lisp-Function-P T)	;513
(Def-Misc-Op AR-3         643 (ARRAY SUB1 SUB2 SUB3) :Lisp-Function-P T)	;514
(Def-Misc-Op AP-LEADER    644 (ARRAY INDEX) :Lisp-Function-P T	;604
	     :documentation "Returns a locative to leader slot INDEX of ARRAY.")
(Def-Misc-Op AP-1         645 (ARRAY SUB) :Lisp-Function-P T)	;601
(Def-Misc-Op AP-2         646 (ARRAY SUB1 SUB2) :Lisp-Function-P T)	;602
(Def-Misc-Op AP-3         647 (ARRAY SUB1 SUB2 SUB3) :Lisp-Function-P T)	;603

(Def-Misc-Op GLOBAL:AR-2-REVERSE 650 (ARRAY INDEX2 INDEX1) :Lisp-Function-P T	;566
	     :documentation "Return an element of ARRAY, optionally reversing the indices.
While arrays are stored with first index varying fastest,
this is the same as AREF.  When arrays are stored with last index varying fastest,
this uses INDEX1 as the first index even though it is the last argument.")
(Def-Misc-Op GLOBAL:AR-1-FORCE   651 (ARRAY INDEX) :Lisp-Function-P T	;714
	     :documentation "Return contents of element INDEX of ARRAY, treated as one-dimensional.
ARRAY is treated as one-dimensional in that it is indexed with
a single subscript regardless of its rank.")
(Def-Misc-Op AP-1-FORCE   652 (ARRAY INDEX) :Lisp-Function-P T	;716
	     :documentation "Return a locative to element INDEX of ARRAY, treated as one-dimensional.
ARRAY is treated as one-dimensional in that it is indexed with
a single subscript regardless of its rank.")
(Def-Misc-Op G-L-P        653 (ARRAY) :Lisp-Function-P T	;507
	     :documentation "Return a list that overlays the contents of ARRAY.
ARRAY must be an array of type ART-Q-LIST.")
(Def-Misc-Op BIGNUM-TO-ARRAY 654 (BIGNUM BASE) :Lisp-Function-P T	;653
	     :documentation "Converts a bignum into an array.
The first argument is a bignum, the second is a fixnum.  The bignum is
expressed in the base of the fixnum and stuffed into an appropriate art-q
array.  The sign of the bignum is ignored.")
;; 655-657

;; info on arrays
(Def-Misc-Op (ARRAY-LENGTH ARRAY-TOTAL-SIZE ARRAY-LENGTH)  660 (ARRAY) :Lisp-Function-P T	;551
	     :documentation "Returns the number of elements in ARRAY.
This does not take account of the fill pointer.")
;;;(Def-Misc-Op ARRAY-TOTAL-SIZE 661 (ARRAY) :Lisp-Function-P T)	;551
(Def-Misc-Op ARRAY-ACTIVE-LENGTH 662 (ARRAY) :Lisp-Function-P T	;552
	     :documentation "Returns the number of elements in ARRAY, or the fill pointer if there is one.")
(Def-Misc-Op ARRAY-LEADER-LENGTH 663 (ARRAY) :Lisp-Function-P T	;751
	     :documentation "Return the number of elements in ARRAY's leader, or NIL if no leader.")
(Def-Misc-Op ARRAY-RANK    664 (ARRAY) :Lisp-Function-P T	;752
	     :documentation "Return the number of dimensions of ARRAY.")
(Def-Misc-Op ARRAY-DIMENSION 665 (ARRAY DIMENSION) :Lisp-Function-P T	;753
	     :documentation "Return the length of dimension DIMENSION of ARRAY.  The first dimension is number 0.")
;; 676-677

;; common-lisp
(Def-Misc-Op COMMON-LISP-AR-1 670 (ARRAY INDEX) :Lisp-Function-P T)	;1020
(Def-Misc-Op COMMON-LISP-AR-2 671 (array sub1 sub2) :Lisp-Function-P T	;1047
	     :documentation "Returns the element specified for the 2-dimensional array specified.  Just like
AR-2 excepts returns 'character' type instead of fixnum for arrays of type ART-STRING.")
(Def-Misc-Op COMMON-LISP-AR-3 672 (array sub1 sub2 sub3) :Lisp-Function-P T	;1050
	     :documentation "Returns the element specified for the 3-dimensional array specified.  Just like
AR-3 excepts returns 'character' type instead of fixnum for arrays of type ART-STRING.")
(Def-Misc-Op COMMON-LISP-AR-1-FORCE 673 (ARRAY INDEX) :Lisp-Function-P T)	;1021
;; 674-677

;;; String and Char fns to stack
(Def-Misc-Op %SXHASH-STRING 700 (STRING CHARACTER-MASK) :Lisp-Function-P T)	;360
(Def-Misc-Op %STRING-SEARCH-CHAR 701 (CHAR STRING START END) :Lisp-Function-P T	;415
	     :documentation "The same as STRING-SEARCH-CHAR, but without coercion and error checking.
Also, all the args are required.  And it's faster.")
(Def-Misc-Op %STRING-WIDTH  702 (TABLE OFFSET STRING START END STOP-WIDTH) :lisp-function-p t)	;727
(Def-Misc-Op INT-CHAR       703 (fixnum) :Lisp-Function-P T	;1043
	     :documentation "Returns a character whose value corresponds to FIXNUM.")
(Def-Misc-Op CHAR-INT       704 (character) :Lisp-Function-P T	;1044
	     :documentation "Returns a fixnum whose value corresponds to CHARACTER.")
;; 705-707

;;; Instance support to stack
(Def-Misc-Op LOCATE-IN-INSTANCE 710 (INSTANCE SYMBOL) :Lisp-Function-P T	;442
	     :documentation "Returns a locative to the slot in INSTANCE for instance variable SYMBOL.")
(Def-Misc-Op %GET-SELF-MAPPING-TABLE 711 (METHOD-FLAVOR-NAME) :Lisp-Function-P T)	;506
(Def-Misc-Op %INSTANCE-REF      712 (INSTANCE INDEX) :Lisp-Function-P T		;520
	     :documentation "Return contents of slot INDEX in INSTANCE.  1 is the lowest valid index.")
(Def-Misc-Op %INSTANCE-LOC      713 (INSTANCE INDEX) :Lisp-Function-P T		;521
	     :documentation "Return location of slot INDEX in INSTANCE.  1 is the lowest valid index.")
(Def-Misc-Op %FUNCTION-INSIDE-SELF 714 ())
;; 715-716
(Def-Misc-Op CLOSURE            717 (SYMBOL-LIST FUNCTION) :Lisp-Function-P T	;565
	     :documentation "Returns a closure, closing FUNCTION over the variables in SYMBOL-LIST.
The closure is a function which when called will perform FUNCTION
in an environment in which those variables have the same bindings they have now.
Only special variables may be closed over;  the closure is a dynamic closure,
not a lexical closure.")

;; Lexical-Support
(Def-Misc-Op LOAD-FROM-HIGHER-CONTEXT 720 (Context-Desc))
(Def-Misc-Op LOCATE-IN-HIGHER-CONTEXT 721 (Context-Desc))
(Def-Misc-Op GET-LEXICAL-VALUE-CELL   722 (ENV-LIST SYMBOL-CELL-LOCATION) :Lisp-Function-P T)	;375
(Def-Misc-Op MAKE-LEXICAL-CLOSURE     723 (envdesc function))
(Def-Misc-Op MAKE-EPHEMERAL-LEXICAL-CLOSURE 724 (envdesc function))

;;;
;;; Prolog miscops
;;;
(DEF-MISC-OP PL-TRAIL1           725 (Var)       :Lisp-Function-P T)
(DEF-MISC-OP PL-BIND-VAR-TO-VAR  726 (var1 Var2) :Lisp-Function-P T)
(DEF-MISC-OP PL-BIND-VAR-TO-TERM 727 (term Var)  :Lisp-Function-P T)
(DEF-MISC-OP PL-VARP             730 (item)      :Lisp-Function-P T) 
(DEF-MISC-OP PL-LISTP            731 (item)      :Lisp-Function-P T) 
(DEF-MISC-OP PL-STRUCTP          732 (item)      :Lisp-Function-P T) 
(DEF-MISC-OP PL-ATOMP            733 (item)      :Lisp-Function-P T) 
(DEF-MISC-OP PL-ATOMICP          734 (item)      :Lisp-Function-P T)
(DEF-MISC-OP PL-INITIALIZE       735 (heap-limits local-limits stack-size stack) :Lisp-Function-P T) 
(DEF-MISC-OP PL-INITIALIZE1      736 (CP BP E G HB H TR) :Lisp-Function-P T)
(DEF-MISC-OP PL-DEREFERENCE      737 (term)       :Lisp-Function-P T)
(DEF-MISC-OP PL-RESOLVE          740 (goal words) :Lisp-Function-P T)

(DEF-MISC-OP PL-Stack-Overflow-SaveCP 741 () :Lisp-Function-P T)
(DEF-MISC-OP PLL-FAIL1                742 () :Lisp-Function-P T)
(DEF-MISC-OP PL-UNIFY1                743 (tr tro) :Lisp-Function-P T)
;; END PROLOG

;; Start new miscops; I-2
(Def-Misc-Op %getlong 744 (ARRAY WORD-NUMBER) :Lisp-Function-P T		;; for byte swapping
  :documentation "Read the word WORD-NUMBER in ARRAY.  Byte-swap the word and 
return the value as a FIXNUM or BIGNUM.
  ARRAY must be an 8-bit, 16-bit, 32-bit or string array.  Note that WORD-NUMBER 
is not the same as an array index.")
(Def-Misc-Op %putlong 745 (ARRAY WORD-NUMBER VALUE) :Lisp-Function-P T	;; for byte swapping
  :documentation "Store VALUE, byte-swapped, at word WORD-NUMBER in ARRAY.  
VALUE must be an unsigned FIXNUM or BIGNUM representing a 32-bit quantity.
  ARRAY must be an 8-bit, 16-bit, 32-bit or string array.  Note that WORD-NUMBER 
is not the same as an array index.")
(DEF-MISC-OP %PUTWORD-16B 746 (ARRAY HALFWORD-NUMBER VALUE) :Lisp-Function-P T
  :documentation "Store VALUE, byte-swapped, at halfword HALFWORD-NUMBER in ARRAY.
VALUE must be a nonnegative FIXNUM.
  ARRAY must be an 8-bit 16-bit or string array.  Note that HALFWORD-NUMBER 
is only the same as an array index in the case of a 16b array.")
(DEF-MISC-OP %GETWORD-16B 747 (array halfword-number) :Lisp-Function-P T
  :documentation "Read the halfword HALFWORD-NUMBER in ARRAY.  Byte-swap the halfword 
and return the value as a FIXNUM.
  ARRAY must be an 8-bit 16-bit or string array.  Note that HALFWORD-NUMBER 
is only the same as an array index in the case of a 16b array.")
(DEF-MISC-OP %BUFFER-CHAR-MAP 750 (source-array source-start source-end
				   dest-array dest-start dest-end
				   mapping-table mask alu) :Lisp-Function-P T
  :documentation "Using MAPPING-TABLE, map the elements of SOURCE-ARRAY from SOURCE-START
below SOURCE-END and store the mapped value in DEST-ARRAY from DEST-START below DEST-END.
For the mapping operation, the element of SOURCE-ARRAY is read and AND'd with MASK.  The
resulting value is used as an index into mapping table.  The mapping table element at that
index is then stored into DEST-ARRAY.
  SOURCE-ARRAY must be an array of integers (a byte array or ART-FIX).  MAPPING-TABLE and
DEST-ARRAY may be arbitrary arrays.  MAPPING-TABLE should be large enough so that any legal 
integer value read from SOURCE-ARRAY can be used as an index for it.
  MASK should be a FIXNUM.  The ALU argument is not currently supported (it defaults to AND).
Zero must be supplied.")
;; End new miscops; I-2

;;I-3
(DEF-MISC-OP %sum-array 751 (array start-index num) :Lisp-Function-P T
  :documentation "Calculates the sum of the elements of ARRAY beginning at START for NUM 
elements and returns the value as a FIXNUM or BIGNUM.
  ARRAY must be an 8-bit or 16-bit non-displaced array.")


;; Array var num subscripts to INDS
(Def-Ucode-Entry ASET              0 (VALUE ARRAY &REST SUBSCRIPTS)	;720 <========== uentry
   :documentation "Store VALUE in the element of ARRAY specified by SUBSCRIPTS.")
;; Array var num subscripts to PDL
(Def-Ucode-Entry AREF              1 (ARRAY &REST SUBSCRIPTS)	;717
   :documentation "Return the contents of the element of ARRAY specified by SUBSCRIPTS.")
(Def-Ucode-Entry ALOC              2 (ARRAY &REST SUBSCRIPTS)	;721
   :documentation "Return a locative to the element of ARRAY specified by SUBSCRIPTS.")
;; Array var num subscripts to PDL
(Def-Ucode-Entry COMMON-LISP-AREF  3 (ARRAY &REST INDICES))	;1017
;; Array var num subscripts to INDS
(Def-Ucode-Entry SET-AREF          4 (ARRAY &REST SUBSCRIPTS-AND-VALUE))	;744

(Def-Ucode-Entry ARRAY-IN-BOUNDS-P 5 (ARRAY &REST SUBSCRIPTS)	;754, d??
   :documentation "T if SUBSCRIPTS are in bounds for the dimensions of ARRAY.")
;;; 6-7

;;; these are funny, they can't be called as misc-op's but only as uentry functions
(Def-Ucode-Entry LIST          10 (&REST ELEMENTS)	;436  <================================== uentry
   :documentation "Return a list whose elements are the arguments.")
(Def-Ucode-Entry LIST*         11 (FIRST &REST ELEMENTS)	;437  "(&REST ELEMENTS LAST)" <== uentry
   :documentation "Return a list whose elements are the arguments, and whose tail is the last argument.
/(LIST* 'A 'B '(C D)) returns a list (A B C D).")
(Def-Ucode-Entry LIST-IN-AREA  12 (AREA &REST ELEMENTS)	;440   <========================= uentry
   :documentation "Returns a list of ELEMENTS, constructed in area AREA.")
(Def-Ucode-Entry LIST*-IN-AREA 13 (AREA FIRST &REST ELEMENTS)	;441  "(AREA &REST ELEMENTS LAST)" <= uentry
   :documentation "Returns a LIST* of ELEMENTS, constructed in area AREA.")

;;; -------
