;;; -*- Mode: LISP; Base:8.; Package: SI -*-

;;;                           RESTRICTED RIGHTS LEGEND

;;;Use, duplication, or disclosure by the Government is subject to
;;;restrictions as set forth in subdivision (c)(1)(ii) of the Rights in
;;;Technical Data and Computer Software clause at 52.227-7013.
;;;
;;;                     TEXAS INSTRUMENTS INCORPORATED.
;;;                              P.O. BOX 2909
;;;                           AUSTIN, TEXAS 78769
;;;                                 MS 2151
;;;
;;; Copyright (C) 1987-1989 Texas Instruments Incorporated. All rights reserved.

;;; This file (EXP2-UNIQUE-TEMPLATES) contains IO-SPACE definitions for the Explorer2
;;;
;;;  Edit History
;;;
;;; Patch #   Date    Author  Description
;;;---------------------------------------------------------------------------------
;;;  ---    02-26-86   RJF    Added some cache tag bits definitions. Also clean up some
;;;                           VMM definitions
;;;         03-27-87   JHL    Added the NuBus status register Fields description
;;;  E-21   09-09-87   ab     Added %Max-IO-Space-Address constant.
;;;  --     11-16-87   ab     Added ExpII-Physical-Space-Offsets.
;;; #f-11   12-03-87   ab     Broke of Exp2-unique IO Space resources into this file from EXP2-QDEV.
;;;

;;=======================================================================================
;;; I/O Space layout for explorer II (not to be confused with the same stuff for CLM)

(DefSysConst %Max-IO-Space-Address #x3FFFFFFF)          ;E-21

(DefAlternate EXPII-PHYSICAL-SPACE-OFFSETS (Q-CORRESPONDING-VARIABLE-LISTS SYSTEM-CONSTANT-LISTS)
   (%ExpII-Flag-Register           #xC00000
    %ExpII-LED-Register            #xC00004     
    %ExpII-Config-Register         #xD00000
    %ExpII-Nubus-Test-Register     #xD00004
    %ExpII-Event-Timer-Register    #xD80000       ; Read-only by other masters.
      ))

;;; IO Space Sources  (for reading,  If * in comment - writable)

(DefAlternate EXPLORER-II-IO-SPACE (Q-CORRESPONDING-VARIABLE-LISTS SYSTEM-CONSTANT-LISTS)
   (Boot-EPROM              0.			  ;0 - 7FFF is boot EPROM data
    External-Control-reg    #x02000000	          ;* Bus and Timer controls  (Slot ID is read-only  - XCREG<07:04>)
    Map-Status-Register     #x04000000
    NuBus-Status-Register   #x06000000	          ;These statuses are in External Control Register on CLM
    VMM-Status-Bits         #x08000000		  ;* 2 bit Map status for each of the 128K possible pages
                                                  ; 08000000 - 0bFFFFFF
    Zeros-Generator         #x0C000000
    Ones-Generator          #x0E000000

    Cache-Data-RAM          #x10000000		  ;* first left 10000000 - 11FFFFFF then right 12000000 - 12FFFFFF
    Left-Cache-Data-RAM     #x10000000		  ;*
    Right-Cache-Data-RAM    #x12000000	          ;*

    Cache-Tag-RAM           #x14000000		  ;* first left 14000000 - 15FFFFFF then right 16000000 - 17FFFFFF
    Left-Cache-Tag-RAM      #x14000000		  ;*
    Right-Cache-Tag-RAM     #x16000000		  ;*

    Cache-LRU-Bit           #x18000000		  ;*
    FIFO                    #x1A000000		  ;First-in First-out memory
    FIFO-POP		    #x1B000000		  ;

    IMEM-Data               #x20000000		  ;* Writable Control Store data (test mode only)

    Virtual-Memory-Map      #x24000000		  ;* Virtual Memory Map IO Space Address
    VMM-Data-Left           #x24000000		  ;* Left bank of the memory map registers 24000000 - 25FFFFFF
    VMM-Data-Right          #x26000000		  ;* Right bank of Mem Map Register 26000000 - 27FFFFFF
	
    Address-space-Memory-Map        #x28000000    ;* 28000000
    Address-space-Map-Register      #x28000000	  ;CLM has separate addresses for read and write, hence two labels here
    Address-Space-Map-Test-Register #x2A000000	  

    Transport-IO-Space      #x20000000		  ;*
    Floating-Point-IO-Space #x2E000000	          ;*
    Flag-Register           #x30000000		  ;*
    LED-Register            #x30000001 		  ;*
    FTimer                  #x32000000		  ;* Microsecond Timer
    Config-Register         #x34000000		  ;*
    STimer                  #x36000000		  ;* Event Generating Timer

    Event-Posting-Addr      #x38000000		  ;* Event Posting Addresses 38000000 - 3800000F 
                                                  ; (0 is event 0, F is event 15)
    Event-Status            #x3A000000		  ;Pending Event Encoded level and status
    Testmode-Offset-Register	#x3c000000
    Read-Data-Exchange-Register #x3c000000
    Config-ROM              #x3E000000		  ;Config ROM 3E000000 - 3FFFFFFF

    Size-of-VMM             16384.		  ;16K memory map registers in each bank on Kricket
    Size-of-VM-Cache        4096.		  ;4K blocks of 4 words each on Kricket
    Size-of-ASM             4096.		  ;16K Address space map
    Size-of-VMM-status      131072.		  ;128k VMM status RAM

      ))


;; Bits in external-control register (these are constant between Kricket and CLM)

(DefAlternate External-Control-Register-Fields (Q-CORRESPONDING-VARIABLE-LISTS
						 System-Constant-Lists)
	(%%Cache-ALL	     3701		  ;Cache all cycles
	 %%Cache-Mapped	     3601		  ; Cache mapped cycles
	 %%Cache-Program     3501		  ; Cache IFetches
	 %%Cache-Data	     3401		  ; Cache data cycles
	 %%Cache-Prefetch    3301		  ; Cache prefetch cycles
	 %%Cache-Transports  3201		  ; Cache auto transport cycles
	 %%Spare-25	     3101		  ;XCRSPACE25
	 %%Cache-UnMapped    3001		  ; Cache unmapped cycles
	 %%spare-23	     2701		  ;XCRSPARE23  - Temporarily used in checkout to enable 1 deep
	 %%Test-Fill-Rd	     2601
	 %%P3-Option-Bits    2303		  ;XP3OPTION3- through XP3OPTION1-  used by stbm
	 %%P2-Option-Bits    2003		  ;P2OPTION3- through P2OPTION1-    used to determine attached hdw
	 %%Buffered-Writes   1701		  ;Enable bit for buffered writes
	 %%FIFO-Reset	     1601		  ; Resets fifo - used when a block read or write error occurs
	 %%Test-Bus-Error    1501		  ; Changes Bus error signalling form trap to poll
	 %%Auto-Transporter  1401	          ;hardware to be invoked on transport cycles
	 %%IDLE-TM0-TM1	     1103		  ;The below 3 bits as a group
	 %%Force-Idle	     1301		  ;Forces next NuBus cycle to idle
	 %%XCRTM1	     1201		  ;  During Idle cycles - TM1 condition
	 %%XCRTM0	     1101		  ;  During Idle cycles - TM0 condition
	 %%TEST-NUACK	     1001		  ;   Test of slave sending and master receiving TM signals
	 %%Processor-Slot-ID 0404		  ;Nubus slot number of processor card
	 %%Bus-Lock          0301
	 %%Event-Timer-Run   0201		  ;Event generator runs when this bit is set
	 %%Microsecond-Timer-Run	0101	  ;Microsecond timer runs when set
	 %%Cache-On	     0001		  ;Enable the cache

	))

;; Fields in the NuBus status register
(defalternate NuBus-Status-Register-Fields (Q-Corresponding-variable-lists
						System-Constant-Lists)
        (%%NSR-LAST-SLAVE-AD-LSBS      0002           ;AD01,AD00 for the last slave access (testmode)
	 %%NSR-LAST-SLAVE-START-TMS    0202           ;NuBus start tm status for last slave access (testmode)
	 %%NSR-BLOCKEND-MARKER         0401           ;Block end reached when set
	 %%NSR-BLOCKMOVE               0501           ;Last NuBus cycle was a blockmove
	 %%NSR-NUBUS-CYCLE-VALID       0601           ;Last NuBUs cycle was valid
	 %%NSR-FIRSTWORD               0701           ;NuBus cycle completed after transfer of the first word
	 %%NSR-END-STATUS-TMS          1002           ;NuBus cycle end status
	 %%NSR-ENCODED-CYCLE-TYPE      1206           ;NuBus address bit <05:00> 
         %%NSR-START-TM0               2001           ;NuBus cycle start TM0
	 %%NSR-START-TM1               2101           ;NuBus cycle start TM1
         %%NSR-CREGMASENQQ             2201           ;NuBus Master enabled on last Cycle
	 %%NSR-WRTQUEUED               2301           ;Indicates an outstanding buffered write error when set
	 %%NSR-MC-IN-PROG              2401           ;Indicates a master cycle is in progress when set
	 %%NSR-MAPPEDQ                 2501           ;Last NuBus cycle was mapped when bit is clear
	 %%NSR-READFIFORDY             2601           ;Read FIFO contains words when bit is clear
	 %%NSR-MASTERQ                 2701           ;Indicates EXPLORER II is the current NuBus master when set
       ))

(defsysconst Size-of-VMM-Cache 4096.)		  ;4K blocks of 4 words each on Kricket

(defalternate configuration-register-fields (Q-CORRESPONDING-VARIABLE-LISTS
						 System-Constant-Lists)
        (%%CR-reset                0001           ;Reset (write only)
         %%CR-Nubus-master-enable  0101           ;NuBus master enable (read/write)
         %%CR-Board-test-Led       0201           ;Board test Led (read/write)
         %%CR-NuBus-test           0301           ;Nubus test (read/write)
       )) 


;;next definitions are for the NuBus status register

(Defsysconst %%NSR-End-Cycle-Status         (Byte 6. 4.))
 

;; This is here for MX Lashup (Explorer 2 pseudo-MX mode).  #F-11, ab
(DefAlternate Mx-Boot-Status-Values (Q-CORRESPONDING-VARIABLE-LISTS
				      System-Constant-Lists)
  (%MBS-Initial-Value   7.
   %MBS-Comm-Sync       1.
   %MBS-Warm-Boot       3.
   %MBS-Start-Lisp      5.
   %MBS-Software-Halted 7.
   ))
