;;; -*- Mode:Lisp; Base:8 -*-
;;;
;;; This is the instruction mnemonic and field definition file
;;; for the microcode assembler for the MegaChip processor.
;;;
;;;						6/86  -- MDM
;;;

(DECLARE (SPECIAL **Indicator**))
(AllRemProp 'Micasm-SYM)			; Clear predef symbol table

;;; Enter SYMBOL into the assembler predefined table with VALUE.
;;;
(DEFMACRO PreDef (symbol value)
  `(PUTPROP ',symbol ,value 'Micasm-Sym))


;;; Field Definitions and predefined values

(PreDef A-Source-Multiplier (Byte-Position-Multiplier %%MInst-A-Source-Address))
(PreDef M-Source-Multiplier (Byte-Position-Multiplier %%MInst-M-Source-Address))
(PreDef A-Destination-Multiplier
        (Byte-Position-Multiplier %%MInst-Destination-Address))
(PreDef M-Destination-Multiplier
        (Byte-Position-Multiplier %%MInst-Destination-M-Memory-Address))
(PreDef Jump-Address-Multiplier (Byte-Position-Multiplier %%MInst-New-Micro-PC))
(PreDef Dispatch-Address-Multiplier (Byte-Position-Multiplier %%MInst-Dispatch-Address))
(PreDef Condition (Byte-Position-Multiplier %%MInst-Condition))
(PreDef T-Ref-Multiplier (Byte-Position-Multiplier %%MInst-Condition))

;;; Abbreviated jump field for any instruction.
(PreDef ABJ (Byte-Position-Multiplier %%MInst-Abbrv-Jump))
;;; Abbreviated jump field for ALU and BYTE instructions.
(PreDef ABJ-Byte-or-ALU
	'(Force-ALU-or-Byte ABJ))

(PreDef Function-Source '(Field M-Source-Multiplier 1))
(PreDef Function-Destination
        (Byte-Position-Multiplier %%MInst-Destination-Functional-Destination))
(PreDef ALU-Output-Bus-Selector-Multiplier
	(Byte-Position-Multiplier %%MInst-Output-Bus-Control))
(PreDef Hum-Misc-Function (Byte-Position-Multiplier %%MInst-Misc-Function))
(PreDef M-Source-Strip    (Byte-Position-Multiplier %%MInst-M-Field-Stripping))
(PreDef A-Immediate-Field (Byte-Position-Multiplier %%MInst-A-Immediate-Bit))
(PreDef Prefetch-Field    (Byte-Position-Multiplier %%MInst-Prefetch))

;NOT USED UNTIL WE FIGURE OUT THE RIGHT MNEMONICS FOR THE TRANSPORT TYPES
(PreDef Read-Trans-Type-Field
	(Byte-Position-Multiplier %%MInst-Destination-Read-Transport-Type))
(PreDef Write-Trans-Type-Field
	(Byte-Position-Multiplier %%MInst-Destination-Write-Transport-Type))


;;; Miscellaneous functions
(PreDef HALT `(Field Hum-Misc-Function ,%HUM-MISC-Halt))
(PreDef HALT-Machine `(Field Hum-Misc-Function ,%HUM-MISC-Halt))
(PreDef MISC-No-op   `(Field Hum-Misc-Function ,%HUM-MISC-Nop))
(PreDef MISC-No-op-2 `(Field Hum-Misc-Function ,%HUM-Misc-Nop-2))
(PreDef Enable-Control-Memory
	`(Field Hum-Misc-Function ,%HUM-MISC-Control-Memory))

;;; More Miscellaneous functions
(PreDef No-op `(Force-ALU (Field Condition ,%Condition-True-ALU)))

;(PreDef Enable-Macro-Prefetch
;	`(Field Hum-Misc-Function ,%HUM-MISC-Macro-Prefetch))

;;; Prefetch control field functions
(PreDef Prefetch-No-Op  
	`(Field Prefetch-Field ,%prefetch-field-nop))
(PreDef Prefetch-OK
	`(Field Prefetch-Field ,%Prefetch-Field-Macro-Prefetch))
(PreDef Prefetch-Operand-Trans-Read
	`(Field Prefetch-Field ,%Prefetch-Field-Operand-Fetch-Trans-Read))
(PreDef Prefetch-Operand-Trans-Write
	`(Field Prefetch-Field ,%Prefetch-Field-Operand-Fetch-Trans-Write))

;;; This feature is NO-OPed in the Explorer
(PreDef Instruction-Stream
	'(Warning "Use of Instruction-Stream is obselete."))

;;; for M-Source field stripping.
(PreDef MS-no-op 
	`(Field M-Source-Strip ,%mfield-strip-nop))

(PreDef MS-Typed-Pointer 
	`(Field M-Source-Strip ,%MField-Strip-Typed-Pointer))

(PreDef MS-Pointer 
	`(Field M-Source-Strip ,%MField-Strip-Pointer))

(PreDef MS-Pointer3
	`(Field M-Source-Strip ,%MField-Strip-Pointer3))



;;; Tag memory predefined data type identifiers.  These are defined here
;;; to make them directly available from the assembly environment.  The values
;;; are defined from Q-Com.
;;;(PreDef DTP-Trap DTP-Trap)
;;;(PreDef DTP-Null DTP-Null)
;;;(PreDef DTP-Free DTP-Free)
;;;(PreDef DTP-Symbol DTP-Symbol)
;;;(PreDef DTP-Symbol-Header DTP-Symbol-Header)
;;;(PreDef DTP-Fix DTP-Fix)
;;;(PreDef DTP-Extended-Number DTP-Extended-Number)
;;;(PreDef DTP-Header DTP-Header)
;;;(PreDef DTP-GC-Forward DTP-GC-Forward)
;;;(PreDef DTP-External-Value-Cell-Pointer DTP-External-Value-Cell-Pointer)
;;;(PreDef DTP-One-Q-Forward DTP-One-Q-Forward)
;;;(PreDef DTP-Header-Forward DTP-Header-Forward)
;;;(PreDef DTP-Body-Forward DTP-Body-Forward)
;;;(PreDef DTP-Locative DTP-Locative)
;;;(PreDef DTP-List DTP-List)
;;;(PreDef DTP-U-Entry DTP-U-Entry)
;;;(PreDef DTP-FEF-Pointer DTP-FEF-Pointer)
;;;(PreDef DTP-Array-Pointer DTP-Array-Pointer)
;;;(PreDef DTP-Array-Header DTP-Array-Header)
;;;(PreDef DTP-Stack-Group DTP-Stack-Group)
;;;(PreDef DTP-Closure DTP-Closure)
;;;(PreDef DTP-Small-Flonum DTP-Small-Flonum)
;;;(PreDef DTP-Select-Method DTP-Select-Method)
;;;(PreDef DTP-Instance DTP-Instance)
;;;(PreDef DTP-Instance-Header DTP-Instance-Header)
;;;(PreDef DTP-Entity DTP-Entity)
;;;(PreDef DTP-Stack-Closure DTP-Stack-Closure)
;;;(PreDef DTP-Self-Ref-Pointer DTP-Self-Ref-Pointer)


;;; Abbreviated jump field specifiers.

;;; Abbreviated jump specifiers for all instructions.
(PreDef And-Popj-Xct-Next  `(Field ABJ ,%A-Jump-Field-Popj-After-Next))

;;; Abbreviated jump specifiers for ALU and BYTE instructions.
(PreDef And-No-Jump 	   	 `(Field ABJ-Byte-or-ALU ,%a-jump-field-nop))
(PreDef And-Skip           	 `(Field ABJ-Byte-or-ALU ,%A-Jump-Field-Skip))
;;(PreDef And-Popj-Xct-Next  `(Field ABJ ,%A-Jump-Field-Popj-After-Next))
(PreDef And-Popj           	 `(Field ABJ-Byte-or-ALU ,%A-Jump-Field-Popj))
(PreDef And-No-Jump4       	 `(Field ABJ-Byte-or-ALU ,%A-Jump-Field-NOP4))
(PreDef And-Skip5          	 `(Field ABJ-Byte-or-ALU ,%A-Jump-Field-SKIP5))
(PreDef And-Popj-Xct-Next-Likely `(Field ABJ-Byte-or-ALU ,%A-Jump-Field-Popj-XctNext-Likely))
(PreDef And-Popj-Likely    	 `(Field ABJ-Byte-or-ALU ,%A-Jump-Field-Popj-Likely))
(Predef And-Call-Illop     	 `(Field ABJ-Byte-or-ALU ,%A-Jump-Field-Call-Illop))
(PreDef And-Call-Trap      	 `(Field ABJ-Byte-or-ALU ,%A-Jump-Field-Call-Trap))
(PreDef And-Call-Bus-Error 	 `(Field ABJ-Byte-or-ALU ,%A-Jump-Field-Call-Buserr))
(PreDef And-Jump-Unused-13  	 `(Field ABJ-Byte-or-ALU ,%A-Jump-Field-Unused-13))
(PreDef And-Jump-Unused-14  	 `(Field ABJ-Byte-or-ALU ,%A-Jump-Field-Unused-14))
(PreDef And-Jump-Unused-15  	 `(Field ABJ-Byte-or-ALU ,%A-Jump-Field-Unused-15))
(PreDef And-Jump-Unused-16  	 `(Field ABJ-Byte-or-ALU ,%A-Jump-Field-Unused-16))
(PreDef And-Jump-Unused-17  	 `(Field ABJ-Byte-or-ALU ,%A-Jump-Field-Unused-17))


;;; ALU instruction definitions

(PreDef ALU-Inst '(Force-ALU 0))
(PreDef ALU-Op `(Force-ALU ,(Byte-Position-Multiplier %%MInst-ALU-Opcode)))
(PreDef ALU-Output-Bus-Selector-Multiplier
        `(Force-ALU ,(Byte-Position-Multiplier %%MInst-Output-Bus-Control)))

(PreDef Read-M-Tag-Classifier			                  ;CH 6.13.84
        `(Force-ALU (PLUS ,(Byte-Value 0 %%MInst-Write-Classifier-Ram)
                          (Field Condition ,%Condition-Tag-Classify)
			  Enable-Control-Memory)))
(PreDef Write-M-Tag-Classifier
        `(Force-ALU (PLUS ,(Byte-Value 1 %%MInst-Write-Classifier-Ram)
                          (Field Condition ,%Condition-Tag-Classify)
			  Enable-Control-Memory)))

;;; Q control values
(PreDef Shift-Q-Nop
	`(Force-ALU ,(Byte-Value %Q-Control-Nop        	     %%MInst-Q-Control)))
(PreDef Shift-Q-Left
        `(Force-ALU ,(Byte-Value %Q-Control-Shift-Left       %%MInst-Q-Control)))
(PreDef Shift-Q-Right
        `(Force-ALU ,(Byte-Value %Q-Control-Shift-Right      %%MInst-Q-Control)))
(PreDef Load-Q
        `(Force-ALU ,(Byte-Value %Q-Control-Load4-Underf0    %%MInst-Q-Control)))
(PreDef Shift-Q-Right2
        `(Force-ALU ,(Byte-Value %Q-Control-Shift-Right2     %%MInst-Q-Control)))
(PreDef Load-Q-Underflow-Unchanged
        `(Force-ALU ,(Byte-Value %Q-Control-Load6-Underfsame %%MInst-Q-Control)))

;;; ALU carry values
(PreDef ALU-Carry-in-Zero
        `(Force-ALU ,(Byte-Value 0 %%MInst-ALU-Carry-In)))

(PreDef ALU-Carry-in-One
        `(Force-ALU ,(Byte-Value 1 %%MInst-ALU-Carry-In)))

;;; ALU output bus selector

(PreDef Output-Selector-Normal
        `(Field ALU-Output-Bus-Selector-Multiplier ,%Output-Bus-Normal))
(PreDef Output-Selector-LeftShift-1
        `(Field ALU-Output-Bus-Selector-Multiplier ,%Output-Bus-LeftShift-1))
(PreDef Output-Selector-RightShift-1
        `(Field ALU-Output-Bus-Selector-Multiplier ,%Output-Bus-RightShift-1))
(PreDef Output-Selector-RightShift-Double
        `(Field ALU-Output-Bus-Selector-Multiplier ,%Output-Bus-RightShift-Double))
(PreDef Output-Selector-Typed-ALU
        `(Field ALU-Output-Bus-Selector-Multiplier ,%Output-Bus-Typed-ALU))
(PreDef Output-Selector-Sign-Extend
        `(Field ALU-Output-Bus-Selector-Multiplier ,%Output-Bus-Pointer-Extend))
(PreDef Output-Selector-Normalizer
        `(Field ALU-Output-Bus-Selector-Multiplier ,%Output-Bus-Normalizer))
;;; removed by special decree... 
;;(PreDef Output-Selector-Masker
;;        `(Field ALU-Output-Bus-Selector-Multiplier ,%Output-Bus-Masker))
;;; for assembler check out only
(PreDef Output-Selector-unused-7
        `(Field ALU-Output-Bus-Selector-Multiplier ,%Output-Bus-unused-7))
;;; additional ALU output bus selector control

(PreDef Typed-ALU-Op
	`(Field ALU-Output-Bus-Selector-Multiplier ,%Output-Bus-Typed-ALU))
(PreDef Shift-ALU-Left 'Output-Selector-LeftShift-1)
(PreDef Shift-ALU-Right 'Output-Selector-RightShift-1)
(PreDef Shift-ALU-Right-Double 'Output-Selector-RightShift-Double)



;;; ALU operation codes
(PreDef No-Op 		'ALU-Inst)
(PreDef SETZ  		`(Field ALU-Op ,%ALU-Opcode-SETZ))
(PreDef AND   		`(Field ALU-Op ,%ALU-Opcode-AND))
(PreDef ANDCA 		`(Field ALU-Op ,%ALU-Opcode-ANDCA))
(PreDef SETM  		`(Field ALU-Op ,%ALU-Opcode-SETM))
(PreDef ANDCM 		`(Field ALU-Op ,%ALU-Opcode-ANDCM))
(PreDef SETA  		`(Field ALU-Op ,%ALU-Opcode-SETA))
(PreDef XOR   		`(Field ALU-Op ,%ALU-Opcode-XOR))
(PreDef IOR   		`(Field ALU-Op ,%ALU-Opcode-IOR))
(PreDef ANDCB 		`(Field ALU-Op ,%ALU-Opcode-ANDCB))
(PreDef EQV   		`(Field ALU-Op ,%ALU-Opcode-EQV))
(PreDef SETCA 		`(Field ALU-Op ,%ALU-Opcode-SETCA))
(PreDef ORCA  		`(Field ALU-Op ,%ALU-Opcode-ORCA))
(PreDef SETCM 		`(Field ALU-Op ,%ALU-Opcode-SETCM))
(PreDef ORCM  		`(Field ALU-Op ,%ALU-Opcode-ORCM))
(PreDef ORCB  		`(Field ALU-Op ,%ALU-Opcode-ORCB))
(PreDef SETO  		`(Field ALU-Op ,%ALU-Opcode-SETO))

(PreDef ADD     	`(Field ALU-Op ,%ALU-Opcode-ADD))
(PreDef SUB     	`(PLUS (Field ALU-Op ,%ALU-Opcode-SUB) ALU-Carry-in-One))
(PreDef SUB-M+1 	`(Field ALU-Op ,%ALU-Opcode-SUB))
(PreDef M-A-1   	`(Field ALU-Op ,%ALU-Opcode-SUB))
(PreDef M+A+1   	`(PLUS (Field ALU-Op ,%ALU-Opcode-ADD) ALU-Carry-in-One))
(PreDef M+2A    	`(Field ALU-Op ,%ALU-Opcode-M+2A))
(PreDef M+2A+1  	`(PLUS (Field ALU-Op ,%ALU-Opcode-M+2A) ALU-Carry-in-One))
(PreDef M-2A    	`(PLUS (Field ALU-Op ,%ALU-Opcode-M-2A) ALU-Carry-in-One))
(PreDef M-2A-1 		` (Field ALU-Op ,%ALU-Opcode-M-2A))

(PreDef ADD-C		`(Field ALU-Op ,%ALU-Opcode-ADD-C))
(PreDef ADD-Setc	`(Field ALU-Op ,%ALU-Opcode-ADD-Setc))
(PreDef ADD-Setc+1	`(PLUS (Field ALU-Op ,%ALU-Opcode-ADD-Setc) ALU-Carry-In-One))
(PreDef ADD-C-Setc	`(Field ALU-Op ,%ALU-Opcode-ADD-C-Setc))
(PreDef SUB-C		`(Field ALU-Op ,%ALU-Opcode-SUB-C))
(PreDef SUB-Setc-1	`(Field ALU-Op ,%ALU-Opcode-SUB-Setc))
(PreDef SUB-Setc	`(PLUS (Field ALU-Op ,%ALU-Opcode-SUB-Setc) ALU-Carry-In-One))
(PreDef SUB-C-Setc	`(Field ALU-Op ,%ALU-Opcode-SUB-C-Setc))

(PreDef ALU-unused-23	`(Field ALU-Op ,%ALU-Opcode-unused-23))	;;; for completness
(PreDef ALU-unused-26	`(Field ALU-Op ,%ALU-Opcode-unused-26))
(PreDef ALU-unused-27	`(Field ALU-Op ,%ALU-Opcode-unused-27))

(PreDef Multiply-Two-Step
        `(PLUS (Field ALU-Op ,%ALU-Opcode-MUL-Two)
               Shift-Q-Right2   Output-Selector-RightShift-Double))

(PreDef Multiply-Last-Step
        `(PLUS (Field ALU-Op ,%ALU-Opcode-MUL-Two)
               Shift-Q-Right Output-Selector-RightShift-1))

(PreDef Divide-First-Step
        `(PLUS (Field ALU-Op ,%ALU-Opcode-SUB)
	        ALU-Carry-in-One
		Shift-Q-Left
		Output-Selector-LeftShift-1))

(PreDef Divide-Step
        `(PLUS (Field ALU-Op ,%ALU-Opcode-DIV)
                Shift-Q-Left
	        Output-Selector-LeftShift-1))

(PreDef Divide-Last-Step
        `(PLUS (Field ALU-Op ,%ALU-Opcode-DIV)
                Shift-Q-Left))

(PreDef Divide-Remainder-Correction-Step `(Field ALU-Op ,%ALU-Opcode-DIV-Corr))


;;; BYTE instruction definitions
(PreDef Byte-Inst '(Force-Byte 0))
(PreDef Byte-Opcode `(Force-Byte ,(Byte-Position-Multiplier %%MInst-Byte-Op)))
(PreDef LDB `(Field Byte-Opcode ,%Byte-Op-LDB))
(PreDef DPB `(Field Byte-Opcode ,%Byte-Op-Deposit-Byte))
(PreDef Selective-Deposit `(Field Byte-Opcode ,%Byte-Op-Selective-Deposit))

;; This def impacts the assembler, it should put the twos complement of the
;; rotation count in the count field. It also should force Byte, Dispatch or Jump
;; 
(PreDef Rotate-Right
        `(PLUS ,(Byte-Value 1 %%MInst-Rotation-Direction)
               (Notification "Rotate-Right only sets the Rotation Direction Bit")))
(PreDef Byte-Special `(Field Byte-Opcode ,%Byte-Op-Special))
(PreDef Funnel-Shift
	`(PLUS ,(Byte-Value 0 %%MInst-Rotation-Direction)  Byte-Special))
(PreDef Byte-Arith-Right-Shift
	`(PLUS ,(Byte-Value 1 %%MInst-Rotation-Direction)  Byte-Special))


;;; Jump related fields and values
(PreDef Jump-Inst '(Force-Jump 0))
(PreDef N-Bit (Byte-Value 1 %%MInst-Inhibit-Bit))
(PreDef Inhibit-Xct-Next-Bit (Byte-Value 1 %%MInst-Inhibit-Bit))
(PreDef P-Bit (Byte-Value 1 %%MInst-Call-Bit))
(PreDef R-Bit (Byte-Value 1 %%MInst-Return-Bit))
(PreDef Invert-Jump-Sense
        (Byte-Position-Multiplier %%MInst-Condition-Invert-Sense-Bit))

;;; Jump Instruction Code Mnemonic Definitions

(PreDef Jump-Op-Xct-Next 'Jump-Inst)
(PreDef Jump-Op '(PLUS Jump-Inst N-Bit))

(PreDef Jump-Xct-Next 'Jump-Op-Xct-Next)
(PreDef Jump 'Jump-Op)

(PreDef Call-Xct-Next '(PLUS Jump-Xct-Next P-Bit))
(PreDef Call '(PLUS Jump P-Bit))

(PreDef Popj-Xct-Next '(PLUS Jump-Xct-Next R-Bit))
(PreDef Popj '(PLUS Jump R-Bit))

(PreDef Skip '(PLUS Jump-Op R-Bit P-Bit))

(PreDef Jump2 '(PLUS Jump-Inst R-Bit P-Bit N-Bit))      ;duplicates JUMP
(PreDef Jump2-Xct-Next '(PLUS Jump-Inst R-Bit P-Bit))

;;; Special case jump instruction: Read/Write with Instruction memory
(PreDef Write-I-Mem
        `(PLUS  Call-Xct-Next
		Always
		,(Byte-Value 1 %%MInst-Write-Control-Store)
		Enable-Control-Memory))
(PreDef Read-I-Mem
        `(PLUS  Call-Xct-Next
		Always
		,(Byte-Value 0 %%MInst-Write-Control-Store)
		Enable-Control-Memory))


;;; Jump conditions
(PreDef If-Bit-Set 	    `(Field Condition ,%Condition-Bit-Set))
(PreDef If-Bit-Clear 	    '(PLUS Invert-Jump-Sense If-Bit-Set))
(PreDef If-Less-Than 	    `(Field Condition ,%Condition-Less))
(PreDef If-Less 	    `(Field Condition ,%Condition-Less))
(PreDef If-Less-Or-Equal    `(Field Condition ,%Condition-Less-or-Equal))
(PreDef If-Equal 	    `(Field Condition ,%Condition-Equal))
(PreDef If-Not-Equal 	    '(PLUS Invert-Jump-Sense If-Equal))
(PreDef If-Greater 	    '(PLUS Invert-Jump-Sense If-Less-Or-Equal))
(PreDef If-Greater-Than     '(PLUS Invert-Jump-Sense If-Less-Or-Equal))
(PreDef If-Greater-Or-Equal '(PLUS Invert-Jump-Sense If-Less))
(PreDef If-Page-Fault 	    `(Field Condition ,%Condition-Page-Fault))
(PreDef If-Not-Page-Fault   '(PLUS Invert-Jump-Sense If-Page-Fault))
(PreDef If-Page-Fault-or-Transport-Fault
	`(Field Condition ,%Condition-Page-Fault-or-Transport-Fault))
(PreDef If-Not-Page-Fault-or-Transport-Fault
	'(PLUS Invert-Jump-Sense If-Page-Fault-or-Transport-Fault))
(PreDef If-Page-Fault-or-Interrupt-Pending
        `(Field Condition ,%Condition-Page-Fault-or-Interrupt))
(PreDef If-Not-Page-Fault-or-Interrupt-Pending
        '(PLUS Invert-Jump-Sense If-Page-Fault-or-Interrupt-Pending))
(PreDef If-Page-Fault-or-Transport-Fault-or-Interrupt-Pending
        `(Field Condition ,%Condition-Page-Fault-or-Transport-Fault-or-Interrupt))
(PreDef If-Not-Page-Fault-or-Transport-Fault-or-Interrupt-Pending
        '(PLUS Invert-Jump-Sense If-Page-Fault-or-Transport-Fault-or-Interrupt-Pending))
(PreDef If-Page-Fault-or-Interrupt-Pending-or-Sequence-Break
      `(Field Condition ,%Condition-Page-Fault-or-Interrupt-or-Sequence-Break))
(PreDef If-Not-Page-Fault-or-Interrupt-Pending-or-Sequence-Break
        '(PLUS Invert-Jump-Sense If-Page-Fault-or-Interrupt-Pending-or-Sequence-Break))
(PreDef If-Page-Fault-or-Transport-Fault-or-Interrupt-Pending-or-Sequence-Break
      `(Field Condition
	      ,%Condition-Page-Fault-or-Transport-Fault-or-Interrupt-or-Sequence-Break))
(PreDef If-Not-Page-Fault-or-Transport-Fault-or-Interrupt-Pending-or-Sequence-Break
        '(PLUS Invert-Jump-Sense
	       If-Page-Fault-or-Transport-Fault-or-Interrupt-Pending-or-Sequence-Break))
(PreDef If-Tag-Not-Equal `(Field Condition ,%Condition-Tag-Not-Equal))
(PreDef If-Tag-Equal '(PLUS Invert-Jump-Sense If-Tag-Not-Equal))
(PreDef If-Negative `(Field Condition ,%Condition-Boxed-Sign-Bit))
(PreDef If-Positive '(PLUS Invert-Jump-Sense If-Negative))
(PreDef If-Memory-Busy `(Field Condition ,%Condition-Memory-Busy))
(PreDef If-Not-Memory-Busy '(PLUS Invert-Jump-Sense If-Memory-Busy))
(PreDef If-NuBus-Error `(Field Condition ,%Condition-NU-Bus-Error))
(PreDef If-Not-NuBus-Error '(PLUS Invert-Jump-Sense If-NuBus-Error))
(PreDef If-Fixnum-Overflow `(Field Condition ,%Condition-Fixnum-Overflow))
(PreDef If-Not-Fixnum-Overflow '(PLUS Invert-Jump-Sense If-Fixnum-Overflow))
(PreDef If-In-Class `(Field Condition ,%Condition-Tag-Classify))
(PreDef If-Not-In-Class '(PLUS Invert-Jump-Sense If-in-Class))
(PreDef Always `(Field Condition ,%Condition-True))
(PreDef Never '(PLUS Invert-Jump-Sense Always))
(PreDef If-32Bit-Overflow `(Field Condition ,%Condition-32Bit-Overflow))
(PreDef If-Not-32Bit-Overflow '(PLUS Invert-Jump-Sense If-32Bit-Overflow))
(PreDef If-Interrupt-or-Sequence-Break
	`(Field Condition ,%Condition-Interrupt-or-Sequence-Break))
(PreDef If-Fixnum-Overflow-or-Tag-Not-Equal `(Field Condition ,%Condition-Fixnum-Overflow-or-Tag-Not-Equal))
(PreDef If-Not-Fixnum-Overflow-and-Tag-Equal '(PLUS Invert-Jump-Sense If-Fixnum-Overflow-or-Tag-Not-Equal))


;;; Dispatch instruction definitions
(PreDef Dispatch '(Force-Dispatch 0))
;;; The following are for notational convenience
(PreDef Dispatch-Xct-Next '(Force-Dispatch 0))
(PreDef Dispatch-Call '(Force-Dispatch 0))
(PreDef Dispatch-Call-Xct-Next '(Force-Dispatch 0))
(PreDef Dispatch-Popj-Xct-Next '(Force-Dispatch 0))

;;; Special dispatch operations
(PreDef Dispatch-Advance-Instruction-Stream
        `(Force-Dispatch ,(Byte-Value 1 %%MInst-Enable-Instruction-Stream)))
(PreDef Dispatch-Push-Own-Address
        `(Force-Dispatch ,(Byte-Value 1 %%MInst-Dispatch-STACK-OwnAddress)))

;;;(PreDef Dispatch-Load-VMA
;;;        `(Force-Dispatch ,(Byte-Value 1 %%MInst-Write-VMA-Register)))

;;; Dispatch options
(PreDef Use-Old-Space-Bit
        `(Force-Dispatch ,(Byte-Value 1 %%MInst-Map-Old-Space-Bit)))
(PreDef Use-GC-Volatility-Bit
        `(Force-Dispatch ,(Byte-Value 1 %%MInst-Map-GC-Volatility-Bit)))
(PreDef Write-Dispatch-Ram
        `(Force-Dispatch
	   (PLUS Enable-Control-Memory
		 ,(Byte-Value 1 %%MInst-Write-Dispatch-Memory))))
(PreDef Read-Dispatch-Ram
        `(Force-Dispatch
	   (PLUS Enable-Control-Memory
		 ,(Byte-Value 0 %%MInst-Write-Dispatch-Memory))))
#|(PreDef Test-Dispatch-Ram
        `(Force-Dispatch
	   (Plus Enable-Control-Memory
		 ,(Byte-Value 1 %%MInst-Test-Dispatch-Memory)))) 
|#
(PreDef Use-MIR
	`(Force-Dispatch ,(Byte-Position-Multiplier %%MInst-Dispatch-Macro-Decode)))


;;; Functional sources and destinations, run time eval

;;; This is the default M-Source
(PreDef Mzeroes
        `(OR (Source-P (Field Function-Source ,%MBS-Mzeroes))
             (ERROR "Mzeroes must be a source")))

(PreDef Dest-No-Op
        `(OR (Source-P (ERROR "MBD-Nop must be a Destination"))
             (Field Function-Destination ,%MBD-nop)))

(PreDef Read-I-Arg
        `(OR (Source-P (Field Function-Source ,%MBS-Read-I-Arg))
	     (ERROR "Read-I-Arg must be a source")))

(PreDef Write-I-Arg
        `(OR (Source-P (ERROR "Write-I-Arg must be a destination"))
             (Field Function-Destination ,%MBD-I-ARG)))

(PreDef Micro-Stack-Pointer
        `(OR (Source-P (Field Function-Source ,%MBS-Micro-Stack-Pointer))
             (Field Function-Destination ,%MBD-Micro-Stack-Pointer)))

(PreDef Micro-Stack-Data
        `(OR (Source-P (Field Function-Source ,%MBS-Micro-Stack-Data))
             (Field Function-Destination ,%MBD-Micro-Stack-Data)))

(PreDef Micro-Stack-Data-Pop
	`(OR (Source-P (Field Function-Source ,%MBS-Micro-Stack-Data-Pop))
             (ERROR "Micro-Stack-Data-Pop must be a source")))

(PreDef Micro-Stack-Data-Push
	`(OR (Source-P
	       (PLUS (Field Function-Source ,%MBS-Micro-Stack-Data-Increment)
		     (Notification "Micro-Stack-Data-Push is not a source, use Micro-Stack-Data-Increment")))
	     (Field Function-Destination ,%MBD-Micro-Stack-Data-Push)))

(PreDef Micro-Stack-Data-Increment
	`(OR (Source-P (Field Function-Source ,%MBS-Micro-Stack-Data-Increment))
	     (ERROR "Micro-Stack-Data-Increment must be a source")))

(PreDef Q-R
        `(OR (Source-P (Field Function-Source ,%MBS-Q-R))
             Load-Q))

(PreDef C-PDL-Buffer-Pointer
        `(OR (Source-P (Field Function-Source ,%MBS-C-PDL-Buffer-Pointer))
             (Field Function-Destination ,%MBD-C-PDL-Buffer-Pointer)))

(PreDef C-PDL-Buffer-Index
        `(OR (Source-P (Field Function-Source ,%MBS-C-PDL-Buffer-Index))
             (Field Function-Destination ,%MBD-C-PDL-Buffer-Index)))

(PreDef C-PDL-Buffer-Effective-Address
        `(OR (Source-P (Field Function-Source ,%MBS-C-PDL-Buffer-EffAddr))
             (Field Function-Destination ,%MBD-C-PDL-Buffer-EffAddr)))

(PreDef C-PDL-Buffer-Pointer-Pop
        `(OR (Source-P (Field Function-Source ,%MBS-C-PDL-Buffer-Pointer-Pop))
             (ERROR "C-PDL-Buffer-Pointer-Pop must be a source")))

(PreDef C-PDL-Buffer-Index-Decrement
        `(OR (Source-P (Field Function-Source ,%MBS-C-PDL-Buffer-Index-Decrement))
             (ERROR "C-PDL-Buffer-Index-Decrement must be a source")))

(PreDef C-PDL-Buffer-Pointer-Push
    `(OR (Source-P
	   (PLUS (Field Function-Source ,%MBS-C-PDL-Buffer-Pointer-Increment)
		 (Notification "C-PDL-Buffer-Pointer-Push is not a source, use C-PDL-Buffer-Pointer-Increment")))
         (Field Function-Destination ,%MBD-C-PDL-Buffer-Pointer-Push)))

(PreDef C-PDL-Buffer-Pointer-Increment
    `(OR (Source-P (Field Function-Source ,%MBS-C-PDL-Buffer-Pointer-Increment))
         (ERROR "C-PDL-Buffer-Pointer-Increment must be a source")))

(PreDef C-PDL-Buffer-Index-Increment
        `(OR (Source-P (Field Function-Source ,%MBS-C-PDL-Buffer-Index-Increment))
             (PLUS (Field Function-Destination ,%MBD-C-PDL-Buffer-Index-Push)
		   (Notification "C-PDL-Buffer-Index-Increment is not a destination, use C-PDL-Buffer-Index-Push"))))

(PreDef C-PDL-Buffer-Index-Push
        `(OR (Source-P (ERROR "C-PDL-Buffer-Pointer-Push must be a destination"))
             (Field Function-Destination ,%MBD-C-PDL-Buffer-Index-Push)))

(PreDef PDL-Buffer-Pointer
        `(OR (Source-P (Field Function-Source ,%MBS-PDL-Buffer-Pointer))
             (Field Function-Destination ,%MBD-PDL-Buffer-Pointer)))

(PreDef PDL-Buffer-Index
        `(OR (Source-P (Field Function-Source ,%MBS-PDL-Buffer-Index))
             (Field Function-Destination ,%MBD-PDL-Buffer-Index)))

(PreDef PDL-Buffer-AP
        `(OR (Source-P (Field Function-Source ,%MBS-PDL-Buffer-AP))
             (Field Function-Destination ,%MBD-PDL-Buffer-AP)))

(PreDef PDL-Buffer-LOCALP
        `(OR (Source-P (Field Function-Source ,%MBS-PDL-Buffer-LOCALP))
             (Field Function-Destination ,%MBD-PDL-Buffer-LOCALP)))

(PreDef PDL-Buffer-Pointer-Pop
        `(OR (Source-P (Field Function-Source ,%MBS-PDL-Buffer-Pointer-Pop))
             (ERROR "PDL-Buffer-Pointer-Pop must be a source")))

(PreDef PDL-Buffer-Index-Increment
        `(OR (Source-P (Field Function-Source ,%MBS-PDL-Buffer-Index-Increment))
             (ERROR "PDL-Buffer-Index-Increment must be a source")))

(PreDef PDL-Buffer-Pointer-Increment
        `(OR (Source-P (Field Function-Source ,%MBS-PDL-Buffer-Pointer-Increment))
             (ERROR "PDL-Buffer-Pointer-Increment must be a source")))

(PreDef PDL-Buffer-Index-Decrement
        `(OR (Source-P (Field Function-Source ,%MBS-PDL-Buffer-Index-Decrement))
             (ERROR "PDL-Buffer-Index-Decrement must be a source")))

(PreDef M-Bus-Signature-Analyzer
        `(OR (Source-P (Field Function-Source ,%MBS-Mbus-Signature-Analyzer))
             (Field Function-Destination ,%MBD-Mbus-Signature-Analyzer)))

(PreDef O-Bus-Signature-Analyzer
        `(OR (Source-P (Field Function-Source ,%MBS-Obus-Signature-Analyzer))
             (Field Function-Destination ,%MBD-Obus-Signature-Analyzer)))

(PreDef IRAM-RW-Low
        `(OR (Source-P (Field Function-Source ,%MBS-IRAM-Low-Register))
             (Field Function-Destination ,%MBD-IRAM-Low-Register)))

(PreDef IRAM-RW-High
        `(OR (Source-P (Field Function-Source ,%MBS-IRAM-High-Register))
             (Field Function-Destination ,%MBD-IRAM-High-Register)))

(PreDef Tag-RAM-RW-Register
        `(OR (Source-P (Field Function-Source ,%MBS-Tag-RAM-Test))
             (Field Function-Destination ,%MBD-Tag-RAM-Test)))

(PreDef Dispatch-RW-Register
        `(OR (Source-P (Field Function-Source ,%MBS-Dispatch-Register))
             (Field Function-Destination ,%MBD-Dispatch-Register)))

(PreDef PDL-Buffer-Effective-Address
        `(OR (Source-P (Field Function-Source ,%MBS-PDL-Buffer-EffAddr))
	     (ERROR "PDL-Buffer-Effective-Address must be a source")))

(PreDef VMA
        `(OR (Source-P (Field Function-Source ,%MBS-VMA))
             (Field Function-Destination ,%MBD-VMA)))

(PreDef VMA-OUT
        `(OR (Source-P (Field Function-Source ,%MBS-VMA-OUT))
	     (PLUS (Field Function-Destination ,%MBD-VMA)
		   (Notification "VMA-OUT is not a destination, using VMA"))))


(PreDef VMA-Start-Read
        `(OR (Source-P (ERROR "VMA-Start-Read must be a destination"))
             (Field Function-Destination ,%MBD-VMA-Start-Read)))

(PreDef VMA-Start-Write 
      `(OR (Source-P (ERROR "VMA-Start-Write must be a destination"))
           (Field Function-Destination ,%MBD-VMA-Start-Write)))

(PreDef VMA-Start-IO-Read
        `(OR (Source-P (ERROR "VMA-Start-IO-Read must be a destination"))
             (Field Function-Destination ,%MBD-VMA-Start-IO-Read)))

(PreDef VMA-Start-IO-Write 
      `(OR (Source-P (ERROR "VMA-Start-Write must be a destination"))
           (Field Function-Destination ,%MBD-VMA-Start-IO-Write)))


(PreDef VMA-Start-Unmapped-Read
        `(OR (Source-P (ERROR "VMA-Start-Read-Unmapped must be a destination"))
             (Field Function-Destination ,%MBD-VMA-Start-Read-Unmapped)))
        
(PreDef VMA-Start-Unmapped-Write
        `(OR (Source-P (ERROR "VMA-Start-Write-Unmapped must be a destination"))
             (Field Function-Destination ,%MBD-VMA-Start-Write-Unmapped)))
        
(PreDef VMA-Start-Unmapped-Byte-Read
        `(OR (Source-P (ERROR "VMA-Start-Read-Unmapped-NU must be a destination"))
             (Field Function-Destination ,%MBD-VMA-Start-Read-Unmapped-NU)))
        
(PreDef VMA-Start-Unmapped-Byte-Write
        `(OR (Source-P (ERROR "VMA-Start-Write-Unmapped-NU must be a destination"))
             (Field Function-Destination ,%MBD-VMA-Start-Write-Unmapped-NU)))

(PreDef VMA-Start-Trans-Read-0
        `(OR (Source-P (ERROR "VMA-Start-Trans-Read must be a destination"))
             (Field Function-Destination ,%MBD-VMA-Start-Transport-Read-0)))

(PreDef VMA-Start-Trans-Read-1
        `(OR (Source-P (ERROR "VMA-Start-Trans-Read must be a destination"))
             (Field Function-Destination ,%MBD-VMA-Start-Transport-Read-1)))

(PreDef VMA-Start-Trans-Read-2
        `(OR (Source-P (ERROR "VMA-Start-Trans-Read must be a destination"))
             (Field Function-Destination ,%MBD-VMA-Start-Transport-Read-2)))

(PreDef VMA-Start-Trans-Read-3
        `(OR (Source-P (ERROR "VMA-Start-Trans-Read must be a destination"))
             (Field Function-Destination ,%MBD-VMA-Start-Transport-Read-3)))

(PreDef VMA-Start-Trans-Read-4
        `(OR (Source-P (ERROR "VMA-Start-Trans-Read must be a destination"))
             (Field Function-Destination ,%MBD-VMA-Start-Transport-Read-4)))

(PreDef VMA-Start-Trans-Read-5
        `(OR (Source-P (ERROR "VMA-Start-Trans-Read must be a destination"))
             (Field Function-Destination ,%MBD-VMA-Start-Transport-Read-5)))

(PreDef VMA-Start-Trans-Read-6
        `(OR (Source-P (ERROR "VMA-Start-Trans-Read must be a destination"))
             (Field Function-Destination ,%MBD-VMA-Start-Transport-Read-6)))

(PreDef VMA-Start-Trans-Read-7
        `(OR (Source-P (ERROR "VMA-Start-Trans-Read must be a destination"))
             (Field Function-Destination ,%MBD-VMA-Start-Transport-Read-7)))

(PreDef MD
        `(OR (Source-P (Field Function-Source ,%MBS-MD))
             (Field Function-Destination ,%MBD-MD)))

(PreDef MD-Start-Read
        `(OR (Source-P (ERROR "MD-Start-Read must be a destination"))
             (Field Function-Destination ,%MBD-MD-Start-Read)))

(PreDef MD-Start-Write
        `(OR (Source-P (ERROR "MD-Start-Write must be a destination"))
             (Field Function-Destination ,%MBD-MD-Start-Write)))

(PreDef MD-Start-IO-Read
        `(OR (Source-P (ERROR "MD-Start-IO-Read must be a destination"))
             (Field Function-Destination ,%MBD-MD-Start-IO-Read)))

(PreDef MD-Start-IO-Write 
      `(OR (Source-P (ERROR "MD-Start-IO-Write must be a destination"))
           (Field Function-Destination ,%MBD-MD-Start-IO-Write)))

(PreDef MD-Start-Unmapped-Read
        `(OR (Source-P (ERROR "MD-Start-Read-Unmapped must be a destination"))
             (Field Function-Destination ,%MBD-MD-Start-Read-Unmapped)))

(PreDef MD-Start-Unmapped-Write
        `(OR (Source-P (ERROR "MD-Start-Write-Unmapped must be a destination"))
             (Field Function-Destination ,%MBD-MD-Start-Write-Unmapped)))

(PreDef MD-Start-Unmapped-Byte-Read
        `(OR (Source-P (ERROR "MD-Start-Read-Unmapped-NU must be a destination"))
             (Field Function-Destination ,%MBD-MD-Start-Read-Unmapped-NU)))

(PreDef MD-Start-Unmapped-Byte-Write
        `(OR (Source-P (ERROR "MD-Start-Write-Unmapped-NU must be a destination"))
             (Field Function-Destination ,%MBD-MD-Start-Write-Unmapped-NU)))

(PreDef MD-Start-Trans-Write-0
        `(OR (Source-P (ERROR "MD-Start-Transport-Write must be a destination"))
             (Field Function-Destination ,%MBD-MD-Start-Transport-Write-0)))

(PreDef MD-Start-Trans-Write-1
        `(OR (Source-P (ERROR "MD-Start-Transport-Write must be a destination"))
             (Field Function-Destination ,%MBD-MD-Start-Transport-Write-1)))

(PreDef MD-Start-Trans-Write-2
        `(OR (Source-P (ERROR "MD-Start-Transport-Write must be a destination"))
             (Field Function-Destination ,%MBD-MD-Start-Transport-Write-2)))

(PreDef MD-Start-Trans-Write-3
        `(OR (Source-P (ERROR "MD-Start-Transport-Write must be a destination"))
             (Field Function-Destination ,%MBD-MD-Start-Transport-Write-3)))

(PreDef IMOD-Low
        `(OR (Source-P (ERROR "OA-Reg-Low must be a destination"))
             (Field Function-Destination ,%MBD-OA-Reg-Low)))

(PreDef IMOD-High
        `(OR (Source-P (ERROR "OA-Reg-High must be a destination"))
             (Field Function-Destination ,%MBD-OA-Reg-High)))

(PreDef Location-Counter
	`(OR (Source-P (Field Function-Source ,%MBS-Location-Counter))
	     (Field Function-Destination ,%MBD-Location-Counter)))

(PreDef LC								;; Same as above
	`(OR (Source-P (Field Function-Source ,%MBS-Location-Counter))
	     (Field Function-Destination ,%MBD-Location-Counter)))

(PreDef Macro-Branch-on-Condition
        `(OR (Source-P (ERROR "Macro-Branch-on-Condition must be a destination"))
             (PLUS Sub
		   (Field Function-Destination ,%MBD-Macro-Branch))))

(PreDef MCR
	`(OR (Source-P (Field Function-Source ,%MBS-MCR))
	     (Field Function-Destination ,%MBD-MCR)))
  
(PreDef I-Arg
	`(OR (Source-P (Field Function-Source ,%MBS-Read-I-Arg))
	     (Error "I-Arg must be a source")
	     ))

(PreDef Write-I-Arg
	`(OR (Source-P (ERROR "Write-I-Arg must be a destination"))
	     (Field Function-Destination ,%MBD-I-ARG)
	     ))     

#|(PreDef Test-Synch
        `(Or (Source-P (Error "Test-Synch must be a destination"))
             (Field Function-Destination ,%MBD-Test-Synch)))
|#

(PreDef MIB
        `(OR (Source-P (Field Function-Source ,%MBS-Macro-Instruction-Buffer))
             (Field Function-Destination ,%MBD-Macro-Instruction-Buffer)))

(PreDef MIB-Argument-Offset
        `(OR (Source-P (Field Function-Source ,%MBS-Macro-Instruction-Argument-Field))
             (ERROR "MIB-Argument-Offset must be a source")))

(PreDef MIB-Branch-Offset
        `(OR (Source-P (Field Function-Source ,%MBS-Macro-Instruction-Branch-Field))
             (ERROR "MIB-Branch-Offset must be a source")))

(PreDef FEF-P
        `(OR (Source-P (Field Function-Source ,%MBS-FEF-P))
             (Field Function-Destination ,%MBD-FEF-P)))

(PreDef FEF-Effective-Address
        `(OR (Source-P (Field Function-Source ,%MBS-FEF-Effective-Address))
             (ERROR "FEF-Effective-Address must be a source")))

#|(PreDef Tag-RAM-Error
        `(Or (Source-P (Field Function-Source ,%MBS-Tag-RAM-Error))
             (Field Function-Destination ,%MBD-Tag-RAM-Error))) 
|#

(PreDef Prefetch-LC
        `(OR (Source-P (Field Function-Source ,%MBS-Prefetch-LC))
             (ERROR "Prefetch-LC must be a source")))

(PreDef Prefetch-MIB
        `(OR (Source-P (Field Function-Source ,%MBS-Prefetch-MIB))
             (ERROR "Prefetch-MIB must be a source")))

(PreDef M-Source-Unused-114
        `(OR (Source-P (Field Function-Source ,%MBS-UNUSED-114))
             (ERROR "M-Source-Unused-114 must be a source")))

(PreDef M-Source-Unused-115
        `(OR (Source-P (Field Function-Source ,%MBS-UNUSED-115))
             (ERROR "M-Source-Unused-115 must be a source")))


(PreDef M-Source-Unused-117
        `(OR (Source-P (Field Function-Source ,%MBS-UNUSED-117))
             (ERROR "M-Source-Unused-117 must be a source")))

(PreDef M-Source-Unused-121
        `(OR (Source-P (Field Function-Source ,%MBS-UNUSED-121))
             (ERROR "M-Source-Unused-121 must be a source")))

(PreDef M-Source-Unused-125
        `(OR (Source-P (Field Function-Source ,%MBS-UNUSED-125))
             (ERROR "M-Source-Unused-125 must be a source")))

(PreDef M-Source-Unused-130
        `(OR (Source-P (Field Function-Source ,%MBS-UNUSED-130))
             (ERROR "M-Source-Unused-130 must be a source")))

(PreDef M-Source-Unused-131
        `(OR (Source-P (Field Function-Source ,%MBS-UNUSED-131))
             (ERROR "M-Source-Unused-131 must be a source")))

(PreDef M-Source-Unused-132
        `(OR (Source-P (Field Function-Source ,%MBS-UNUSED-132))
             (ERROR "M-Source-Unused-132 must be a source")))

(PreDef M-Source-Unused-133
        `(OR (Source-P (Field Function-Source ,%MBS-UNUSED-133))
             (ERROR "M-Source-Unused-133 must be a source")))

(PreDef M-Source-Unused-134
        `(OR (Source-P (Field Function-Source ,%MBS-UNUSED-134))
             (ERROR "M-Source-Unused-134 must be a source")))

(PreDef M-Source-Unused-135
        `(OR (Source-P (Field Function-Source ,%MBS-UNUSED-135))
             (ERROR "M-Source-Unused-135 must be a source")))

(PreDef M-Source-Unused-136
        `(OR (Source-P (Field Function-Source ,%MBS-UNUSED-136))
             (ERROR "M-Source-Unused-136 must be a source")))

(PreDef M-Source-Unused-137
        `(OR (Source-P (Field Function-Source ,%MBS-UNUSED-137))
             (ERROR "M-Source-Unused-137 must be a source")))

(PreDef M-Source-Unused-143
        `(OR (Source-P (Field Function-Source ,%MBS-UNUSED-143))
             (ERROR "M-Source-Unused-143 must be a source")))

(PreDef M-Source-Unused-166
        `(OR (Source-P (Field Function-Source ,%MBS-UNUSED-166))
             (ERROR "M-Source-Unused-166 must be a source")))

(PreDef M-Source-Unused-170
        `(OR (Source-P (Field Function-Source ,%MBS-UNUSED-170))
             (ERROR "M-Source-Unused-170 must be a source")))

(PreDef M-Source-Unused-171
        `(OR (Source-P (Field Function-Source ,%MBS-UNUSED-171))
             (ERROR "M-Source-Unused-171 must be a source")))

(PreDef M-Source-Unused-172
        `(OR (Source-P (Field Function-Source ,%MBS-UNUSED-172))
             (ERROR "M-Source-Unused-172 must be a source")))

(PreDef M-Source-Unused-173
        `(OR (Source-P (Field Function-Source ,%MBS-UNUSED-173))
             (ERROR "M-Source-Unused-173 must be a source")))

(PreDef M-Source-Unused-174
        `(OR (Source-P (Field Function-Source ,%MBS-UNUSED-174))
             (ERROR "M-Source-Unused-174 must be a source")))

(PreDef M-Source-Unused-175
        `(OR (Source-P (Field Function-Source ,%MBS-UNUSED-175))
             (ERROR "M-Source-Unused-175 must be a source")))

(PreDef M-Source-Unused-176
        `(OR (Source-P (Field Function-Source ,%MBS-UNUSED-176))
             (ERROR "M-Source-Unused-176 must be a source")))

(PreDef M-Source-Unused-177
        `(OR (Source-P (Field Function-Source ,%MBS-UNUSED-177))
             (ERROR "M-Source-Unused-177 must be a source")))

