;;; -*- Mode: LISP; Base: 10. -*-

;;; Make the wildcard symbol for OPCODE be ? so that we can have
;;; "*" for an opcode.
(Defprop Opcode "?" :Wild-Parse-Spec)

;;;
;;; Field templates for the LROY instruction set
;;;

(Make-Template 'Register
               'Register
               (List (Make-Parse FEF   '(nil nil ((0 2 1))))
		     (Make-Parse LEX   '(nil nil (3)))
                     (Make-Parse IVAR  '(nil nil (4)))
                     (Make-Parse LOCAL '(nil nil (5)))
                     (Make-Parse ARG   '(nil nil (6)))
                     (Make-Parse PDL-POP '(nil nil (7))))
               '((0 7 1)))

(Make-Template 'Store-Register
	       'Register
	       (List (Make-Parse FEF   '(nil nil ((0 2 1))))
		     (Make-Parse LEX   '(nil nil (3)))
                     (Make-Parse IVAR  '(nil nil (4)))
                     (Make-Parse LOCAL '(nil nil (5)))
                     (Make-Parse ARG   '(nil nil (6)))
                     (Make-Parse PDL-PUSH '(nil nil (7))))
               '((0 7 1)))

(Make-Template 'Call
	       'Call-Dests
               (List (Make-Parse D-INDS     (Make-Decode-From-Template 'Register  0))
                     (Make-Parse D-PDL      (Make-Decode-From-Template 'Register #o10))
                     (Make-Parse D-Return   (Make-Decode-From-Template 'Register #o20))
                     (Make-Parse D-Tail-Rec (Make-Decode-From-Template 'Register #o30)))
               '((0 #o37 1)))


(Make-Template 'BRANCH
	       'Branch
	       (List (Make-Parse FORWARD '(nil nil ((0 3 1))))
		     (Make-Parse BACK    '(nil nil ((4 7 1)))))
	       '((0 7 1)))

(Make-Template 'AUX
	       'AUX-Groups
	       (List (Make-Parse Random0 '(nil nil (0)))
		     (Make-Parse Random1 '(nil nil (1)))
		     (Make-Parse UnUsed2 '(nil nil (2)))
		     (Make-Parse UnUsed3 '(nil nil (3)))
		     (Make-Parse UnBind  '(nil nil (4)))
		     (Make-Parse Pop-PDL '(nil nil (5)))
		     (Make-Parse Return-N '(nil nil (6)))
		     (Make-Parse UnUsed7 '(nil nil (7)))
		     )
	       '((0 7 1)))

(Make-Template 'MISC
	       'MISC-Groups
	       (List (Make-Parse Misc0 '(nil nil (0)))
		     (Make-Parse Misc1 '(nil nil (1)))
		     (Make-Parse Misc2 '(nil nil (2)))
		     (Make-Parse Misc3 '(nil nil (3)))
		     (Make-Parse Misc4 '(nil nil (4)))
		     (Make-Parse Misc5 '(nil nil (5)))
		     (Make-Parse Misc6 '(nil nil (6)))
		     (Make-Parse Misc7 '(nil nil (7)))
		     )
	       '((0 7 1)))

(Make-Template 'Module
	       'Module-Groups
	       (List (Make-Parse Mod0 '(nil nil (0)))
		     (Make-Parse Mod1 '(nil nil (1)))
		     (Make-Parse Mod2 '(nil nil (2)))
		     (Make-Parse Mod3 '(nil nil (3)))
		     (Make-Parse Mod4 '(nil nil (4)))
		     (Make-Parse Mod5 '(nil nil (5)))
		     (Make-Parse Mod6 '(nil nil (6)))
		     (Make-Parse Mod7 '(nil nil (7)))
		     )
	       '((0 7 1)))

(Make-Template 'Immed
	       'Immediate
	       (List (Make-Parse + '(nil nil ((0 3 1))))
		     (Make-Parse - '(nil nil ((4 7 1)))))
	       '((0 7 1)))


(Make-Template 'Nothing
	       'Uninterpretted
	       (List (Make-Parse * '(nil nil ((0 7 1)))))
	       '((0 7 1)))


(Make-Template 'AREFI
	       'AREFI-Type
	       (List (Make-Parse AR-1 '(nil nil (0)))
		     (Make-Parse LEADER '(nil nil (1)))
		     (Make-Parse INSTANCE '(nil nil (2)))
		     (Make-Parse CL-AR-1 '(nil nil (3)))
		     (Make-Parse SET-AR-1 '(nil nil (4)))
		     (Make-Parse SET-LEADER '(nil nil (5)))
		     (Make-Parse SET-INSTANCE '(nil nil (6)))
		     )
	       '((0 6 1)))

