#ifndef E3MACROOP_H
#define E3MACROOP_H

#include "memmap.h"

// Mainops et similiae.

typedef enum
{
   DEFOP_AUX_GROUP = 00,
   DEFOP_TEST_MISC_GROUP,
   DEFOP_TEST_MODULE_GROUP,
   DEFOP_EQ_IMMED,
   DEFOP_EQUALS_IMMED,
   DEFOP_GREATERP_IMMED,
   DEFOP_LESSP_IMMED,
   DEFOP_TEST_AREFI,

   DEFOP_TEST = 010,
   DEFOP_TEST_CAR,
   DEFOP_TEST_CDR,
   DEFOP_TEST_CADR,
   DEFOP_TEST_CDDR,
   DEFOP_TEST_CAAR,
   DEFOP_TEST_CDAR,
   DEFOP_RETURN,
   
   DEFOP_EQUALS = 020,
   DEFOP_GREATERP,
   DEFOP_LESSP,
   DEFOP_EQ,
   DEFOP_EQL,
   DEFOP_EQUAL,
   DEFOP_EQUALP,
   // No 027.
   DEFOP_027,

   DEFOP_NUMBERP = 030,
   DEFOP_ARRAYP,
   DEFOP_CLI_LISTP,
   DEFOP_STRINGP,
   DEFOP_FIXNUMP,
   DEFOP_INTEGERP,
   DEFOP_PLUSP,
   DEFOP_MINUSP,

   // No 040.
   DEFOP_040 = 040,
   DEFOP_PUSH_MISC_GROUP,
   DEFOP_PUSH_MODULE_GROUP,
   DEFOP_ADD_IMMED,
   DEFOP_LDB_IMMED,
   DEFOP_PUSH_NUMBER,
   DEFOP_PUSH_NEG_NUMBER,
   DEFOP_PUSH_AREFI,

   DEFOP_PUSH = 050,
   DEFOP_PUSH_CAR,
   DEFOP_PUSH_CDR,
   DEFOP_PUSH_CADR,
   DEFOP_PUSH_CDDR,
   DEFOP_PUSH_CADDR,
   DEFOP_PUSH_CONS,
   DEFOP_PUSH_GET,

   DEFOP_PLUS = 060,
   DEFOP_DIF,
   DEFOP_TIMES,
   DEFOP_LOGAND,
   DEFOP_LOGXOR,
   DEFOP_ONE_PLUS,
   DEFOP_ONE_MINUS,
   DEFOP_PUSH_AR_1,

   DEFOP_PUSH_LONG_FEF = 070,
   DEFOP_SELECT,
   DEFOP_DISPATCH,
   // No 073, reserved for CASE?
   DEFOP_073,
   DEFOP_MAKE_STACK_CLOSURE,
   DEFOP_STACK_CLOSURE_DISCONNECT,
   DEFOP_STACK_CLOSURE_UNSHARE,
   DEFOP_STACK_CLOSURE_DISCONNECT_FIRST,

   DEFCALLOP_CALL_0_DEST_INDS = 0100,
   DEFCALLOP_CALL_0_DEST_PUSH,
   DEFCALLOP_CALL_0_DEST_RETURN,
   DEFCALLOP_CALL_0_DEST_TAIL_REC,
   DEFCALLOP_CALL_1_DEST_INDS = 0104,
   DEFCALLOP_CALL_1_DEST_PUSH,
   DEFCALLOP_CALL_1_DEST_RETURN,
   DEFCALLOP_CALL_1_DEST_TAIL_REC,

   DEFCALLOP_CALL_2_DEST_INDS = 0110,
   DEFCALLOP_CALL_2_DEST_PUSH,
   DEFCALLOP_CALL_2_DEST_RETURN,
   DEFCALLOP_CALL_2_DEST_TAIL_REC,
   DEFCALLOP_CALL_3_DEST_INDS = 0114,
   DEFCALLOP_CALL_3_DEST_PUSH,
   DEFCALLOP_CALL_3_DEST_RETURN,
   DEFCALLOP_CALL_3_DEST_TAIL_REC,

   DEFCALLOP_CALL_4_DEST_INDS = 0120,
   DEFCALLOP_CALL_4_DEST_PUSH,
   DEFCALLOP_CALL_4_DEST_RETURN,
   DEFCALLOP_CALL_4_DEST_TAIL_REC,
   DEFCALLOP_CALL_5_DEST_INDS = 0124,
   DEFCALLOP_CALL_5_DEST_PUSH,
   DEFCALLOP_CALL_5_DEST_RETURN,
   DEFCALLOP_CALL_5_DEST_TAIL_REC,

   DEFCALLOP_CALL_6_DEST_INDS = 0130,
   DEFCALLOP_CALL_6_DEST_PUSH,
   DEFCALLOP_CALL_6_DEST_RETURN,
   DEFCALLOP_CALL_6_DEST_TAIL_REC,
   DEFCALLOP_CALL_N_DEST_INDS = 0134,
   DEFCALLOP_CALL_N_DEST_PUSH,
   DEFCALLOP_CALL_N_DEST_RETURN,
   DEFCALLOP_CALL_N_DEST_TAIL_REC,

   DEFOP_POP = 0140,
   DEFOP_MOVEM,
   DEFOP_SETE_CDR,
   DEFOP_SETE_CDDR,
   DEFOP_SETE_1_PLUS,
   DEFOP_SETE_1_MINUS,
   // No 0146.
   DEFOP_0146,
   DEFOP_PUSH_CDR_STORE_CAR_IF_CONS,

   DEFOP_PUSH_LOC = 0150,
   /* Binding. */
   DEFOP_BIND_NIL,
   DEFOP_BIND_T,
   DEFOP_BIND_POP,
   DEFOP_BIND_CURRENT,
   /* Setting. */
   DEFOP_SET_NIL,
   DEFOP_SET_T,
   DEFOP_SET_ZERO,

   DEFBRANCHOP_BR_NIL_ELSE_POP = 0160,
   DEFBRANCHOP_BR_NOT_NIL_ELSE_POP,
   DEFBRANCHOP_BR_NIL,
   DEFBRANCHOP_BR_NOT_NIL,
   DEFBRANCHOP_BR_ATOM,
   DEFBRANCHOP_BR_NOT_ATOM,
   DEFBRANCHOP_BR_ZEROP,
   DEFBRANCHOP_BR_NOT_ZEROP,

   DEFBRANCHOP_BR_SYMBOLP = 0170,
   DEFBRANCHOP_BR_NOT_SYMBOLP,
   // No 0172, 0173.
   DEFOP_0172,
   DEFOP_0173,
   DEFBRANCHOP_BR_NIL_LIKELY,
   DEFBRANCHOP_BR_NOT_NIL_LIKELY,
   DEFBRANCHOP_BR_ALWAYS_NIL,
   // No 0177 -- is illegal.
   DEFOP_0177_ILLEGAL

} e3DefOp;


// Auxops.

typedef enum
{
  // "Sort of illegal" insns.
  AUXOP_RESERVED_ILLEGAL = 0,
  AUXOP_BREAKPOINT,
  AUXOP_HALT,
  AUXOP_CRASH,

  // No 4 thru 7.
  AUXOP_4,
  AUXOP_5,
  AUXOP_6,
  AUXOP_7,

  // Stack hacking.
  AUXOP_EXCHANGE = 010,
  AUXOP_SPREAD,
  AUXOP_ASSURE_PDL_ROOM,
  AUXOP_POP_M_FROM_UNDER_N,
  AUXOP_POPJ,
  AUXOP_UNWIND_PROTECT_CLEANUP,
  AUXOP_USING_BINDING_INSTANCES,
  AUXOP_UNBIND_TO_INDEX,

  AUXOP_20,
  AUXOP_21,
  AUXOP_SET_SELF_MAPPING_TABLE = 022,
  AUXOP_23,
  AUXOP_24,
  AUXOP_25,
  AUXOP_STACK_GROUP_RETURN = 026,
  AUXOP_STACK_GROUP_RESUME,

  AUXOP_STORE_IN_HIGHER_CONTEXT = 030,
  AUXOP_LEXICAL_UNSHARE_ALL,
  AUXOP_STORE_KEY_WORD_ARGS,
  AUXOP_33,
  AUXOP_34,
  AUXOP_35,
  AUXOP_36,
  AUXOP_37,

  AUXOP_40,
  AUXOP_41,
  AUXOP_42,
  AUXOP_43,
  AUXOP_44,
  AUXOP_45,
  AUXOP_46,
  AUXOP_47,

  AUXOP_50,
  AUXOP_51,
  AUXOP_52,
  AUXOP_53,
  AUXOP_54,
  AUXOP_55,
  AUXOP_56,
  AUXOP_57,

  AUXOP_60,
  AUXOP_61,
  AUXOP_62,
  AUXOP_63,
  AUXOP_64,
  AUXOP_65,
  AUXOP_66,
  AUXOP_67,

  AUXOP_70,
  AUXOP_71,
  AUXOP_72,
  AUXOP_73,
  AUXOP_74,
  AUXOP_75,
  AUXOP_76,
  AUXOP_77,

  // Complex funcalling.
  AUXOP_COMPLEX_CALL_TO_INDS = 0100,
  AUXOP_COMPLEX_CALL_TO_PUSH,
  AUXOP_COMPLEX_CALL_TO_RETURN,
  AUXOP_COMPLEX_CALL_TO_TAIL_REC,
  AUXOP_APPLY_TO_INDS = 0104,
  AUXOP_APPLY_TO_PUSH,
  AUXOP_APPLY_TO_RETURN,
  AUXOP_APPLY_TO_TAIL_REC,
  AUXOP_APPLY_METHOD_TO_INDS = 0110,
  AUXOP_APPLY_METHOD_TO_PUSH,
  AUXOP_APPLY_METHOD_TO_RETURN,
  AUXOP_APPLY_METHOD_TO_TAIL_REC,
  AUXOP_LEXPR_FUNCALL_WITH_MAPPING_TABLE_TO_INDS = 0114,
  AUXOP_LEXPR_FUNCALL_WITH_MAPPING_TABLE_TO_PUSH,
  AUXOP_LEXPR_FUNCALL_WITH_MAPPING_TABLE_TO_RETURN,
  AUXOP_LEXPR_FUNCALL_WITH_MAPPING_TABLE_TO_TAIL_REC,
  AUXOP_RETURN_N = 0120,
  AUXOP_RETURN_LIST,
  AUXOP_RETURN_NIL,
  AUXOP_RETURN_T,
  AUXOP_OPEN_CATCH = 0124,
  AUXOP_OPEN_CATCH_MULTIPLE_VALUE,
  AUXOP_OPEN_CATCH_TAIL_RECURSIVE,
  AUXOP_OPEN_CATCH_MV_LIST,

  // Throw et alia.
  AUXOP_THROW = 0130,
  AUXOP_THROW_N,
  // AUXOP_THROW_SPREAD (0132) apparently flushed...
  AUXOP_UNWIND_STACK = 0133,
  AUXOP_CLOSE_CATCH,
  AUXOP_CLOSE_CATCH_RETURN = 0135,         // Same op but
  AUXOP_CLOSE_CATCH_UNWIND_PROTECT = 0135, // different names.
  AUXOP_RETURN_PRED,
  AUXOP_RETURN_NOT_INDS,

  // Paging.
  AUXOP_CHANGE_PAGE_STATUS = 0140,  // Same op but
  AUXOP_ENABLE_NUPI_LOCKING = 0140, // different names.
  AUXOP_DISABLE_NUPI_LOCKING,
  AUXOP_PAGE_IN,
  // AUXOP_RETURN_PAGE_CLUSTER (0144) apparently flushed...
  AUXOP_ADD_PAGE_DEVICE = 0145, // Same op but
  AUXOP_SCRUB = 0145,           // different names.
  AUXOP_CREATE_PHYSICAL_PAGE,
  AUXOP_DELETE_PHYSICAL_PAGE = 0147, // Same op but
  AUXOP_DELETE_PHT_ENTRY     = 0147, // different names.

  // GC.
  AUXOP_GC_FREE_REGION = 0150,
  AUXOP_GC_FLIP,
  AUXOP_GC_SCAVENGE,
  AUXOP_GC_CONS_WORK,
  AUXOP_FLUSH_EXTRA_PDL,
  AUXOP_IMPORT_OBJECT,

  // Disk restore/save.
  AUXOP_DISK_RESTORE = 0156,
  AUXOP_DISK_SAVE,

  // Long branch.
  AUXOP_LONG_BR_NULL_ELSE_POP = 0160,
  AUXOP_LONG_BR_NOT_NULL_ELSE_POP,
  AUXOP_LONG_BR_NULL,
  AUXOP_LONG_BR_NOT_NULL,
  AUXOP_LONG_BR_ATOM,
  AUXOP_LONG_BR_NOT_ATOM,
  AUXOP_LONG_BR_ZEROP,
  AUXOP_LONG_BR_NOT_ZEROP,
  AUXOP_LONG_BR_SYMBOLP,
  AUXOP_LONG_BR_NOT_SYMBOLP,
  // No 0172, 0173.
  AUXOP_172,
  AUXOP_173,
  AUXOP_LONG_BR_NULL_LIKELY = 0174,
  AUXOP_LONG_BR_NOT_NULL_LIKELY,
  AUXOP_LONG_BR,
  AUXOP_LONG_PUSHJ   = 0177, // Same op but
  AUXOP_LONG_BR_SUBR = 0177, // different names.

  // No 0200 thru 0377.
  // No fake auxops for these either.

  // Unbind.
  AUXOP_UNBIND_1 = 0400,
  AUXOP_UNBIND_2,
  AUXOP_UNBIND_3,
  AUXOP_UNBIND_4,
  AUXOP_UNBIND_5,
  AUXOP_UNBIND_6,
  AUXOP_UNBIND_7,
  AUXOP_UNBIND_8,
  AUXOP_UNBIND_9 = 0410,
  AUXOP_UNBIND_10,
  AUXOP_UNBIND_11,
  AUXOP_UNBIND_12,
  AUXOP_UNBIND_13,
  AUXOP_UNBIND_14,
  AUXOP_UNBIND_15,
  AUXOP_UNBIND_16,
  AUXOP_UNBIND_17 = 0420,
  AUXOP_UNBIND_18,
  AUXOP_UNBIND_19,
  AUXOP_UNBIND_20,
  AUXOP_UNBIND_21,
  AUXOP_UNBIND_22,
  AUXOP_UNBIND_23,
  AUXOP_UNBIND_24,
  AUXOP_UNBIND_25 = 0430,
  AUXOP_UNBIND_26,
  AUXOP_UNBIND_27,
  AUXOP_UNBIND_28,
  AUXOP_UNBIND_29,
  AUXOP_UNBIND_30,
  AUXOP_UNBIND_31,
  AUXOP_UNBIND_32,
  AUXOP_UNBIND_33 = 0440,
  AUXOP_UNBIND_34,
  AUXOP_UNBIND_35,
  AUXOP_UNBIND_36,
  AUXOP_UNBIND_37,
  AUXOP_UNBIND_38,
  AUXOP_UNBIND_39,
  AUXOP_UNBIND_40,
  AUXOP_UNBIND_41 = 0450,
  AUXOP_UNBIND_42,
  AUXOP_UNBIND_43,
  AUXOP_UNBIND_44,
  AUXOP_UNBIND_45,
  AUXOP_UNBIND_46,
  AUXOP_UNBIND_47,
  AUXOP_UNBIND_48,
  AUXOP_UNBIND_49 = 0460,
  AUXOP_UNBIND_50,
  AUXOP_UNBIND_51,
  AUXOP_UNBIND_52,
  AUXOP_UNBIND_53,
  AUXOP_UNBIND_54,
  AUXOP_UNBIND_55,
  AUXOP_UNBIND_56,
  AUXOP_UNBIND_57 = 0470,
  AUXOP_UNBIND_58,
  AUXOP_UNBIND_59,
  AUXOP_UNBIND_60,
  AUXOP_UNBIND_61,
  AUXOP_UNBIND_62,
  AUXOP_UNBIND_63,
  AUXOP_UNBIND_64,

  // POP-PDL.
  AUXOP_POP_PDL_1 = 0500,
  AUXOP_POP_PDL_2,
  AUXOP_POP_PDL_3,
  AUXOP_POP_PDL_4,
  AUXOP_POP_PDL_5,
  AUXOP_POP_PDL_6,
  AUXOP_POP_PDL_7,
  AUXOP_POP_PDL_8,
  AUXOP_POP_PDL_9 = 0510,
  AUXOP_POP_PDL_10,
  AUXOP_POP_PDL_11,
  AUXOP_POP_PDL_12,
  AUXOP_POP_PDL_13,
  AUXOP_POP_PDL_14,
  AUXOP_POP_PDL_15,
  AUXOP_POP_PDL_16,
  AUXOP_POP_PDL_17 = 0520,
  AUXOP_POP_PDL_18,
  AUXOP_POP_PDL_19,
  AUXOP_POP_PDL_20,
  AUXOP_POP_PDL_21,
  AUXOP_POP_PDL_22,
  AUXOP_POP_PDL_23,
  AUXOP_POP_PDL_24,
  AUXOP_POP_PDL_25 = 0530,
  AUXOP_POP_PDL_26,
  AUXOP_POP_PDL_27,
  AUXOP_POP_PDL_28,
  AUXOP_POP_PDL_29,
  AUXOP_POP_PDL_30,
  AUXOP_POP_PDL_31,
  AUXOP_POP_PDL_32,
  AUXOP_POP_PDL_33 = 0540,
  AUXOP_POP_PDL_34,
  AUXOP_POP_PDL_35,
  AUXOP_POP_PDL_36,
  AUXOP_POP_PDL_37,
  AUXOP_POP_PDL_38,
  AUXOP_POP_PDL_39,
  AUXOP_POP_PDL_40,
  AUXOP_POP_PDL_41 = 0550,
  AUXOP_POP_PDL_42,
  AUXOP_POP_PDL_43,
  AUXOP_POP_PDL_44,
  AUXOP_POP_PDL_45,
  AUXOP_POP_PDL_46,
  AUXOP_POP_PDL_47,
  AUXOP_POP_PDL_48,
  AUXOP_POP_PDL_49 = 0560,
  AUXOP_POP_PDL_50,
  AUXOP_POP_PDL_51,
  AUXOP_POP_PDL_52,
  AUXOP_POP_PDL_53,
  AUXOP_POP_PDL_54,
  AUXOP_POP_PDL_55,
  AUXOP_POP_PDL_56,
  AUXOP_POP_PDL_57 = 0570,
  AUXOP_POP_PDL_58,
  AUXOP_POP_PDL_59,
  AUXOP_POP_PDL_60,
  AUXOP_POP_PDL_61,
  AUXOP_POP_PDL_62,
  AUXOP_POP_PDL_63,
  AUXOP_POP_PDL_64,

  // Return-N.
  AUXOP_RETURN_0 = 0600,
  AUXOP_RETURN_1,               // Redundant.  Use mainop RETURN.
  AUXOP_RETURN_2,
  AUXOP_RETURN_3,
  AUXOP_RETURN_4,
  AUXOP_RETURN_5,
  AUXOP_RETURN_6,
  AUXOP_RETURN_7,
  AUXOP_RETURN_8 = 0610,
  AUXOP_RETURN_9,
  AUXOP_RETURN_10,
  AUXOP_RETURN_11,
  AUXOP_RETURN_12,
  AUXOP_RETURN_13,
  AUXOP_RETURN_14,
  AUXOP_RETURN_15,
  AUXOP_RETURN_16 = 0620,
  AUXOP_RETURN_17,
  AUXOP_RETURN_18,
  AUXOP_RETURN_19,
  AUXOP_RETURN_20,
  AUXOP_RETURN_21,
  AUXOP_RETURN_22,
  AUXOP_RETURN_23,
  AUXOP_RETURN_24 = 0630,
  AUXOP_RETURN_25,
  AUXOP_RETURN_26,
  AUXOP_RETURN_27,
  AUXOP_RETURN_28,
  AUXOP_RETURN_29,
  AUXOP_RETURN_30,
  AUXOP_RETURN_31,
  AUXOP_RETURN_32 = 0640,
  AUXOP_RETURN_33,
  AUXOP_RETURN_34,
  AUXOP_RETURN_35,
  AUXOP_RETURN_36,
  AUXOP_RETURN_37,
  AUXOP_RETURN_38,
  AUXOP_RETURN_39,
  AUXOP_RETURN_40 = 0650,
  AUXOP_RETURN_41,
  AUXOP_RETURN_42,
  AUXOP_RETURN_43,
  AUXOP_RETURN_44,
  AUXOP_RETURN_45,
  AUXOP_RETURN_46,
  AUXOP_RETURN_47,
  AUXOP_RETURN_48 = 0660,
  AUXOP_RETURN_49,
  AUXOP_RETURN_50,
  AUXOP_RETURN_51,
  AUXOP_RETURN_52,
  AUXOP_RETURN_53,
  AUXOP_RETURN_54,
  AUXOP_RETURN_55,
  AUXOP_RETURN_56 = 0670,
  AUXOP_RETURN_57,
  AUXOP_RETURN_58,
  AUXOP_RETURN_59,
  AUXOP_RETURN_60,
  AUXOP_RETURN_61,
  AUXOP_RETURN_62,
  AUXOP_RETURN_63,

  // No 0700 thru 0777.
  // No fake auxops for these either.
} e3AuxOp;


// Miscops.

typedef enum
{
  // Accessors.
  // Both D-PDL and D-INDS.
  MISCOP_CAR = 02,
  MISCOP_CDR,
  MISCOP_CAAR,
  MISCOP_CADR,
  MISCOP_CDAR,
  MISCOP_CDDR,
  
  MISCOP_CAAAR = 010,
  MISCOP_CAADR,
  MISCOP_CADAR,
  MISCOP_CADDR,
  MISCOP_CDAAR,
  MISCOP_CDADR,
  MISCOP_CDDAR,
  MISCOP_CDDDR,

  MISCOP_CAAAAR = 020,
  MISCOP_CAAADR,
  MISCOP_CAADAR,
  MISCOP_CAADDR,
  MISCOP_CADAAR,
  MISCOP_CADADR,
  MISCOP_CADDAR,
  MISCOP_CDAAAR = 030,
  MISCOP_CDAADR,
  MISCOP_CDADAR,
  MISCOP_CDADDR,
  MISCOP_CDDAAR,
  MISCOP_CDDADR,
  MISCOP_CDDDAR,
  MISCOP_CDDDDR,

  MISCOP_PDL_WORD = 040,
  MISCOP_SHRINK_PDL_SAVE_TOP,
  MISCOP_42,
  MISCOP_43,
  MISCOP_44,
  MISCOP_45,
  MISCOP_STACK_GROUP_RETURN,
  MISCOP_STACK_GROUP_RESUME,

  MISCOP_P_DPB = 050,
  MISCOP_P_DEPOSIT_FIELD,
  MISCOP_P_DPB_OFFSET,
  MISCOP_P_DEPOSIT_FIELD_OFFSET,
  MISCOP_PHYS_LOGLDB,
  MISCOP_PHYS_LOGDPB,
  MISCOP_56,
  MISCOP_GC_SCAV_RESET = 057,

  MISCOP_60,
  MISCOP_61,
  MISCOP_P_STORE_CONTENTS = 062,
  MISCOP_P_STORE_TAG_AND_POINTER,
  MISCOP_P_STORE_CDR_CODE,
  MISCOP_P_STORE_DATA_TYPE,
  MISCOP_P_STORE_POINTER,
  MISCOP_P_STORE_CONTENTS_OFFSET,

  // Symbols both dests.
  MISCOP_INTERNAL_GET_2 = 070,
  MISCOP_GETL,
  MISCOP_GET_LOCATION_OR_NIL,
  MISCOP_INTERNAL_GET_3,
  MISCOP_PREDICATE,
  MISCOP_NOT_INDICATORS,
  MISCOP_76,
  MISCOP_77,

  // No 0100 thru 0177.
  // FILL ME

  // Ops 0200 thru 0377 usually D-INDS.
  MISCOP_BIND = 0200,
  MISCOP_201,
  MISCOP_202,
  MISCOP_203,
  MISCOP_204,
  MISCOP_205,
  MISCOP_206,
  MISCOP_207,

  MISCOP_IO = 0210,
  MISCOP_ADD_INTERRUPT,
  MISCOP_212,
  MISCOP_213,
  MISCOP_MULTIBUS_WRITE_16 = 0214,
  MISCOP_MULTIBUS_WRITE_8,
  MISCOP_MULTIBUS_WRITE_32,
  MISCOP_NUBUS_WRITE,

  MISCOP_NUBUS_WRITE_8B = 0220,
  MISCOP_NUBUS_WRITE_16B,
  MISCOP_NUBUS_WRITE_32B,
  MISCOP_BLT_TO_PHYSICAL,
  MISCOP_BLT_FROM_PHYSICAL,
  MISCOP_IO_SPACE_WRITE,
  MISCOP_TEST_AND_STORE_68K,
  MISCOP_TEST_AND_SET_68K,

  // Predicates usually D-INDS.
  MISCOP_FLOATP = 0230,
  MISCOP_LENGTH_GREATERP,
  MISCOP_INTERNAL_CHAR_EQUAL,
  MISCOP_STRING_EQUAL,
  MISCOP_ARRAY_HAS_LEADER,
  MISCOP_NLISTP,
  MISCOP_NSYMBOLP,
  MISCOP_FBOUNDP,

  MISCOP_BOUNDP = 0240,
  MISCOP_ARRAY_HAS_FILL_POINTER,
  MISCOP_COMMON_LISP_LISTP,
  MISCOP_VECTORP,
  MISCOP_SIMPLE_VECTOR_P,
  MISCOP_SIMPLE_ARRAY_P,
  MISCOP_SIMPLE_STRING_P,

  MISCOP_BIT_VECTOR_P = 0250,
  MISCOP_SIMPLE_BIT_VECTOR_P,
  MISCOP_TYPEP_STRUCTURE_OR_FLAVOR,
  MISCOP_SMALL_FLOATP,
  MISCOP_CHARACTERP,
  MISCOP_ENDP,
  MISCOP_RATIONALP,
  MISCOP_RATIOP,

  MISCOP_COMPLEXP = 0260,
  MISCOP_EQ_T,
  MISCOP_SINGLE_FLOATP,
  MISCOP_DOUBLE_FLOATP,
  MISCOP_264,
  MISCOP_265,
  MISCOP_266,
  MISCOP_267,

  MISCOP_270,
  MISCOP_271,
  MISCOP_272,
  MISCOP_273,
  MISCOP_274,
  MISCOP_275,
  MISCOP_276,
  MISCOP_277,

  // List functions to D-INDS.
  MISCOP_RPLACA = 0300,
  MISCOP_RPLACD,
  MISCOP_SETCAR,
  MISCOP_SETCDR,
  MISCOP_CONSP_OR_POP,
  MISCOP_305,
  MISCOP_306,
  MISCOP_SETELT,

  // Symbols D-INDS.
  MISCOP_SET = 0310,
  MISCOP_311,
  MISCOP_312,
  MISCOP_313,
  MISCOP_314,
  MISCOP_315,
  MISCOP_316,
  MISCOP_317,

  MISCOP_STORE_ARRAY_LEADER = 0320,
  MISCOP_AS_1,
  MISCOP_AS_2,
  MISCOP_AS_3,
  MISCOP_AS_1_FORCE,
  MISCOP_AS_2_REVERSE,
  MISCOP_326,
  MISCOP_327,

  MISCOP_SET_ARRAY_LEADER = 0330,
  MISCOP_SET_AR_1,
  MISCOP_SET_AR_2,
  MISCOP_SET_AR_3,
  MISCOP_SET_AR_1_FORCE,
  MISCOP_336,
  MISCOP_337,

  MISCOP_ARRAY_PUSH = 0340,
  MISCOP_VECTOR_PUSH,
  MISCOP_COPY_ARRAY_CONTENTS,
  MISCOP_COPY_ARRAY_CONTENTS_AND_LEADER,
  MISCOP_COPY_ARRAY_PORTION,
  MISCOP_BITBLT,
  MISCOP_BLT,
  MISCOP_BLT_TYPED,

  MISCOP_350,
  MISCOP_351,
  MISCOP_352,
  MISCOP_353,

  // Instance support D-PDL.
  MISCOP_SET_INSTANCE_REF = 0354,
  MISCOP_DISPATCH_METHOD,
  MISCOP_CLASS_DESCRIPTION,
  MISCOP_357,

  MISCOP_CHANGE_PAGE_STATUS = 0360,
  MISCOP_ADD_PAGE_DEVICE,
  MISCOP_DELETE_PHYSICAL_PAGE,
  MISCOP_PAGE_IN,
  MISCOP_LOAD_MEMORY_MAP,
  MISCOP_365,
  MISCOP_366,
  MISCOP_367,

  MISCOP_WRITE_INTERNAL_PROCESSOR_MEMORIES = 0370,
  MISCOP_PAGE_TRACE,
  MISCOP_RECORD_EVENT,
  MISCOP_373,
  MISCOP_374,
  MISCOP_375,
  MISCOP_376,
  MISCOP_377,

  // 0400 thru 0777 usually D-PDL.
  MISCOP_MAKE_STACK_LIST = 400,
  MISCOP_MAKE_EXPLICIT_STACK_LIST,
  MISCOP_MAKE_EXPLICIT_STACK_LIST_STAR,
  MISCOP_MAKE_STACK_LIST_STAR,
  MISCOP_STACK_FRAME_POINTER,
  MISCOP_SPECIAL_PDL_INDEX,
  MISCOP_UNBIND_TO_INDEX_MOVE,
  MISCOP_407,

  MISCOP_NCONS = 0410,
  MISCOP_NCONS_IN_AREA,
  MISCOP_CONS,
  MISCOP_CONS_IN_AREA,
  MISCOP_MAKE_LIST_STAR,
  MISCOP_ALLOCATE_AND_INITIALIZE,
  MISCOP_ALLOCATE_AND_INITIALIZE_ARRAY,
  MISCOP_RATIO_CONS,

  MISCOP_ALLOCATE_AND_INITIALIZE_INSTANCE = 0420,
  MISCOP_MAKE_LIST,
  MISCOP_ALLOCATE_AND_INITIALIZE_SYMBOL,
  MISCOP_423,
  MISCOP_424,
  MISCOP_425,
  MISCOP_426,
  MISCOP_427,

  MISCOP_PHYSICAL_ADDRESS = 0430,
  MISCOP_MULTIBUS_READ_16,
  MISCOP_MULTIBUS_READ_8,
  MISCOP_MULTIBUS_READ_32,
  MISCOP_NUBUS_READ,
  MISCOP_NUBUS_READ_8B,
  MISCOP_NUBUS_READ_16B,
  MISCOP_NUBUS_READ_32B,

  MISCOP_NUBUS_READ_8B_CAREFUL = 0440,
  MISCOP_IO_SPACE_READ,
  MISCOP_442,
  MISCOP_443,
  MISCOP_444,
  MISCOP_POINTER,
  MISCOP_MAKE_POINTER,
  MISCOP_MAKE_POINTER_OFFSET,

  MISCOP_DATA_TYPE = 0450,
  MISCOP_P_CDR_CODE,
  MISCOP_P_DATA_TYPE,
  MISCOP_P_POINTER,
  MISCOP_P_LDB,
  MISCOP_P_MASK_FIELD,
  MISCOP_P_CONTENTS_OFFSET,
  MISCOP_P_LDB_OFFSET,

  MISCOP_MASK_FIELD_OFFSET = 0460,
  MISCOP_CONTENTS_AS_LOCATIVE,
  MISCOP_CONTENTS_AS_LOCATIVE_OFFSET,
  MISCOP_POINTER_DIFFERENCE,
  MISCOP_STORE_CONDITIONAL,
  MISCOP_465,
  MISCOP_466,
  MISCOP_467,

  // Time.
  MISCOP_MICROSECOND_TIME = 0470,
  MISCOP_FIXNUM_MICROSECOND_TIME,
  MISCOP_TIME_IN_60THS,
  MISCOP_473,

  // Paging.
  MISCOP_PAGE_STATUS = 0474,
  MISCOP_COMPUTE_PAGE_HASH,
  MISCOP_FINDCORE,
  MISCOP_FREE_PAGE_CLUSTER_COUNT,

  // GC.
  MISCOP_AREA_NUMBER = 0500,
  MISCOP_REGION_NUMBER,
  MISCOP_FIND_STRUCTURE_HEADER,
  MISCOP_STRUCTURE_BOXED_SIZE,
  MISCOP_STRUCTURE_TOTAL_SIZE,
  MISCOP_MAKE_REGION,
  MISCOP_FIND_STRUCTURE_LEADER,
  MISCOP_507,

  // Arithmetic.
  MISCOP_FIX = 0510,
  MISCOP_SMALL_FLOAT,
  MISCOP_INTERNAL_FLOAT,
  MISCOP_ABS,
  MISCOP_MINUS,
  MISCOP_HAULONG,
  MISCOP_FLOAT_EXPONENT,
  MISCOP_FLOAT_FRACTION,

  MISCOP_LDB = 0520,
  MISCOP_LOGLDB,
  MISCOP_MASK_FIELD,
  MISCOP_DPB,
  MISCOP_LOGDPB,
  MISCOP_DEPOSIT_FIELD,
  MISCOP_527,

  MISCOP_LSH = 0530,
  MISCOP_ASH,
  MISCOP_ROT,
  MISCOP_STAR_BOOLE,
  MISCOP_MAX,
  MISCOP_MIN,
  MISCOP_EXPT,
  MISCOP_537,

  MISCOP_REMAINDER = 0540,
  MISCOP_QUOTIENT,
  MISCOP_LOGIOR,
  MISCOP_GCD,
  MISCOP_DIV,
  MISCOP_SCALE_FLOAT,
  MISCOP_DOUBLE_FLOAT,
  MISCOP_547,

  MISCOP_FLOOR_1 = 0550,
  MISCOP_CEILING_1,
  MISCOP_TRUNCATE_1,
  MISCOP_ROUND_1,
  MISCOP_FLOOR_2,
  MISCOP_CEILING_2,
  MISCOP_TRUNCATE_2,
  MISCOP_ROUND_2,

  // Predicates usually D-PDL.
  MISCOP_ZEROP = 0560,
  MISCOP_FIXP,
  MISCOP_EQUAL,
  MISCOP_NOT,                   // aka NULL
  MISCOP_ATOM,
  MISCOP_NUMBERP,
  MISCOP_PLUSP,
  MISCOP_MINUSP,

  MISCOP_LESSP = 0570,
  MISCOP_GREATERP,
  MISCOP_EQUALS,
  MISCOP_EQL,
  MISCOP_EQ,
  MISCOP_EQUALP,
  MISCOP_LISTP,
  MISCOP_SYMBOLP,

  MISCOP_ARRAYP = 0600,
  MISCOP_STRINGP,
  MISCOP_FIXNUMP,
  MISCOP_NAMED_STRUCTURE_P,
  MISCOP_604,
  MISCOP_605,
  MISCOP_606,
  MISCOP_607,

  // List functions usually D-PDL.
  MISCOP_ASSQ = 0610,
  MISCOP_LAST,
  MISCOP_LENGTH,
  MISCOP_MEMQ,
  MISCOP_NTH,
  MISCOP_NTHCDR,
  MISCOP_FIND_POSITION_IN_LIST,
  MISCOP_617,

  MISCOP_CAR_SAFE = 0620,
  MISCOP_CDR_SAFE,
  MISCOP_CARCDR,
  MISCOP_623,
  MISCOP_624,

  // Sequence functions D-PDL.
  MISCOP_ELT = 0625,
  MISCOP_COMMON_LISP_ELT,
  MISCOP_FSYMEVAL,

  // Symbols D-PDL.
  MISCOP_GET_PNAME = 0630,
  MISCOP_SYMBOL_NAME,
  MISCOP_VALUE_CELL_LOCATION,
  MISCOP_FUNCTION_CELL_LOCATION,
  MISCOP_PROPERTY_CELL_LOCATION,
  MISCOP_SYMBOL_PACKAGE,
  MISCOP_SYMBOL_VALUE,
  MISCOP_EXTERNAL_VALUE_CELL,

  // Arrays usually D-PDL.
  MISCOP_ARRAY_LEADER = 0640,
  MISCOP_AR_1,
  MISCOP_AR_2,
  MISCOP_AR_3,
  MISCOP_AP_LEADER,
  MISCOP_AP_1,
  MISCOP_AP_2,
  MISCOP_AP_3,

  MISCOP_AR_2_REVERSE = 0650,
  MISCOP_AR_1_FORCE,
  MISCOP_AP_1_FORCE,
  MISCOP_G_L_P,
  MISCOP_BIGNUM_TO_ARRAY,
  MISCOP_655,
  MISCOP_656,
  MISCOP_657,

  // Array info.
  MISCOP_ARRAY_LENGTH = 0660,
  MISCOP_ARRAY_TOTAL_SIZE,
  MISCOP_ARRAY_ACTIVE_LENGTH,
  MISCOP_ARRAY_LEADER_LENGTH,
  MISCOP_ARRAY_RANK,
  MISCOP_ARRAY_DIMENSION,
  MISCOP_666,
  MISCOP_667,

  // CL arrays.
  MISCOP_COMMON_LISP_AR_1 = 0670,
  MISCOP_COMMON_LISP_AR_2,
  MISCOP_COMMON_LISP_AR_3,
  MISCOP_COMMON_LISP_AR_1_FORCE,
  MISCOP_674,
  MISCOP_675,
  MISCOP_676,
  MISCOP_677,

  // String and char fns D-PDL.
  MISCOP_SXHASH_STRING = 0700,
  MISCOP_STRING_SEARCH_CHAR,
  MISCOP_STRING_WIDTH,
  MISCOP_INT_CHAR,
  MISCOP_CHAR_INT,
  MISCOP_705,
  MISCOP_706,
  MISCOP_707,

  // Instance support D-PDL.
  MISCOP_LOCATE_IN_INSTANCE,
  MISCOP_GET_SELF_MAPPING_TABLE,
  MISCOP_INSTANCE_REF,
  MISCOP_INSTANCE_LOC,
  MISCOP_FUNCTION_INSIDE_SELF,
  MISCOP_715,
  MISCOP_716,
  MISCOP_CLOSURE,

  // Lexical support.
  MISCOP_LOAD_FROM_HIGHER_CONTEXT = 0720,
  MISCOP_LOCATE_IN_HIGHER_CONTEXT,
  MISCOP_GET_LEXICAL_VALUE,
  MISCOP_MAKE_LEXICAL_CLOSURE,
  MISCOP_MAKE_EPHEMERAL_LEXICAL_CLOSURE,

  // Prolog miscops.
  MISCOP_PL_TRAIL1 = 0725,
  MISCOP_PL_BIND_VAR_TO_VAR,
  MISCOP_PL_BIND_VAR_TO_TERM,

  MISCOP_PL_VARP = 0730,
  MISCOP_PL_LISTP,
  MISCOP_PL_STRUCTP,
  MISCOP_PL_ATOMP,
  MISCOP_PL_ATOMICP,
  MISCOP_PL_INITIALIZE,
  MISCOP_PL_INITIALIZE1,
  MISCOP_PL_DEREFERENCE,

  MISCOP_PL_RESOLVE = 0740,
  MISCOP_PL_STACK_OVERFLOW_SAVECP,
  MISCOP_PLL_FAIL1,             // FIXME: TYPO?
  MISCOP_PL_UNIFY1,

  // New miscops I-2.
  MISCOP_GETLONG = 0744,
  MISCOP_PUTLONG,
  MISCOP_PUTWORD_16B,
  MISCOP_GETWORD_16B,
  
  MISCOP_BUFFER_CHAR_MAP = 0750,
  // I-3.
  MISCOP_SUM_ARRAY,

  // 0752 thru 01000 unused.
} e3MiscOp;


// AREFI ops.
typedef enum
{
  AREFIOP_AREF = 0,
  AREFIOP_ARRAY_LEADER,
  AREFIOP_INSTANCE_REF,
  AREFIOP_CL_AREF,
  AREFIOP_SETF_AREF,
  AREFIOP_SETF_ARRAY_LEADER,
  AREFIOP_SETF_INSTANCE_REF,
  AREFIOP_UNUSED
} e3ArefiOp;


// Assorted enums.

typedef enum
{
  REG_FEF = 0,
  REG_FEF_PLUS_64,
  REG_FEF_PLUS_128,
  REG_HIGHER_LEXICAL_CONTEXT,
  REG_SELF_MAPPING_TABLE,
  REG_LOCAL_VARIABLES,
  REG_ARGUMENTS,
  REG_PDL_POP
} e3MacroInstructionRegister;

typedef enum
{
  IMM_FIXNUM = 0,
  IMM_PPSS = 1
} e3MacroInstructionImmedType;


// The e3MacroInstruction class.

class e3MacroInstruction
{
 public:

  e3MacroInstruction(e3u16);

  e3u16 selectBitsPPSS(e3u16 position, e3u16 size) const; // DOES shift bits down.
  void  dump(ostream &) const;
  void  dumpOperands(ostream &os) const;
  void  dumpMainOperands(ostream &os) const;
  void  dumpShortBranchOperands(ostream &os) const;
  void  dumpImmedOperands(ostream &os, e3MacroInstructionImmedType type) const;
  void  dumpArefiOperands(ostream &os) const;

  // FIXME: The following should all be inlined later.
  e3DefOp QMIFullOpcode(void) const;
  e3u8    QMIDestOpcode(void) const;
  e3MacroInstructionRegister QMIRegister(void) const;
  e3u8    QMIOffset(void) const;
  e3u8    QMICallDest(void) const;
  e3u8    QMICallNumargs(void) const;
  e3u16   QMIDisplacement(void) const;
  e3u16   QMIImmedValue(void) const;
  e3u8    QMIAuxOpcode(void) const;
  e3u8    QMIAuxCallType(void) const;
  e3u8    QMIAuxCallDest(void) const;
  e3u8    QMIAuxLBTest(void) const;
  e3u8    QMIAuxLBSense(void) const;
  e3u8    QMIAuxCountOp(void) const;
  e3u8    QMIAuxCountCount(void) const;
  e3u16   QMIMiscOpcode(void) const;
  e3u8    QMIArefiRefKind(void) const;
  e3u8    QMIArefiIndex(void) const;
  e3u8    QMIModuleNumber(void) const;
  e3u8    QMIModuleOpcode(void) const;
  e3u8    QMIModuleDest(void) const;

 private:

  e3u16   getBits(void) const;	/* $ Inline later. */
  void    setBits(e3u16);	/* $ Inline later. */
  e3u16   selectBitsMask(e3u16 mask) const;

  e3u16   myBits;
};


// The insn execution engine.

class e3MacroOpCodeEngine: public e3MemMap
{
 public:

  e3MacroOpCodeEngine();
  virtual ~e3MacroOpCodeEngine();

  e3Boolean      setDebugging(e3Boolean);
  e3Boolean      runMacroOpCode(void);

  e3MacroInstruction currentInstruction(void) const;
  e3Word             fetchOperand(e3MacroInstruction i) const;

#ifdef NOTDEF
 protected:
#endif

  void           setInitialStateFromScratchPadInitArea(void);
  void           setInitialTopLevelFunction(e3Word itlf_locative);
  void           setErrorHandlerStackGroup(e3Word ehsg);
  void           setCurrentStackGroup(e3Word csg);
  void           setInitialStackGroup(e3Word isg);
  void           setLastArrayElementAccessed(e3Word laea);

  void           disassembleMemory(e3WordAddr start, e3u32 len);
  void           dumpMemory(e3WordAddr start, e3u32 len);
  void           dumpInterestingAreas(void);
  void           findNIL(void);


  e3u32          myNumberOfWordsLoaded;

  e3Word         myDTPFunction; /* Part 1 of program counter value.  */
  e3Word         myErrorHandlerStackGroup;
  e3Word         myCurrentStackGroup;
  e3Word         myInitialStackGroup;
  e3Word         myLastArrayElementAccessed;

 private:

  e3Boolean      myDebuggingOn;
  e3u32	  myFEFPC;	/* Part 2 of program counter value.   Probably only needs 8 or 16 bits. */

  e3Boolean      opcode_DEFOP_CALL_1(e3MacroInstruction);
};
  

// The base class for macroinsns.

typedef void (*execute_signature)(e3MacroOpCodeEngine *);
typedef int  (*disassemble_signature)(e3MacroOpCodeEngine *);

class e3MacroOpBaseClass
{
public:
  static void execute(e3MacroOpCodeEngine *);
  static int  disassemble(e3MacroOpCodeEngine *);

  static e3Boolean  theTrace;

  static const int             theLengthOfDispatchTables = 128; // 7 bits of opcode
  static execute_signature     theExecuteDispatchTable[theLengthOfDispatchTables];
  static disassemble_signature theDisassembleDispatchTable[theLengthOfDispatchTables];

  static void       test(void);
};


// The macroinsn template.

template <int opcode>
class e3MacroOpTemplateClass: public e3MacroOpBaseClass
{
public:

  e3MacroOpTemplateClass::e3MacroOpTemplateClass()
  {
#ifdef PARANOID
    if (opcode > theLengthOfDispatchTables)
      {
	cerr << "opcode " << opcode << " too big!\n";
	abort();
      }
    else
#endif
      {
	theExecuteDispatchTable[opcode] = execute;
	theDisassembleDispatchTable[opcode] = disassemble;
      }
  }

  static void execute(e3MacroOpCodeEngine *e);
  static int  disassemble(e3MacroOpCodeEngine *e);
};


// The macro for defining insns.  Use like "DEFOP(mnemonic, 123);"

#define DEFOP(opcode_classname, opcode_number)  \
  typedef e3MacroOpTemplateClass<opcode_number> opcode_classname; \
  opcode_classname  opcode_classname##_instance;

#define DEFNOP(opcode_classname, opcode_number)  \
  typedef e3MacroOpTemplateClass<opcode_number> opcode_classname; \
  opcode_classname  opcode_classname##_instance; \
  void opcode_classname::execute(e3MacroOpCodeEngine *e) \
  { \
     cout << "opcode #0" << oct <<  opcode_number << " execute not implemented\n"; \
     abort(); \
   } \
  int opcode_classname::disassemble(e3MacroOpCodeEngine *e) \
  { \
    cout << "opcode #0" << oct << opcode_number << " disassemble not implemented\n"; \
    abort(); \
    return(2); \
  }

#endif /* E3MACROOP_H */
