/*
 * auxop.c
 *
 * auxop instruction handlers
 */

#include "exploiter.h"
#include "context.h"
#include "memory.h"
#include "interp.h"
#include "utils.h"
#include "funcall.h"
#include <stdio.h>

int auxop_012(u16 opcode) { /* %ASSURE-PDL-ROOM */
    dump_q(pop(), 0);

    printf("%%ASSURE-PDL-ROOM not implemented, ignoring.\n");
    
    return 1;
}

int auxop_014(u16 opcode) { /* POPJ */
    context.location_counter = ADDRESS(pop());
    
    return 1;
}

int auxop_017(u16 opcode) { /* UNBIND-TO-INDEX */
    lisp_q index;

    index = pop();

    unbind_n(ADDRESS(context.spdl_pointer) - ADDRESS(index));

    return 1;
}

int auxop_032(u16 opcode) { /* %STORE-KEY-WORD-ARGS */
    lisp_q valid_keys;
    lisp_q allow_other_keys;
    lisp_q first_store;

    lisp_q args_list;

    /*
     * From the documentation string:
     *
     * Support for keyword argument decoding. The argument-list of keys and
     * values are obtained from Local 0 and compared against valid keys.
     * ALLOW-OTHER-KEYS is true or nil and indicate whether other keys should
     * be allowed. LOCATIVE-TO-FIRST-STORE is a locative to the first local
     * slot to where to store the values. CLOS uses the args slightly
     * different, since it just wants to check the keys and not store them.
     * In CLOS. the argument list is passed in the ALLOW-OTHER-KEYS and
     * LOCATIVE-TO-FIRST-STORE is always NIL. VALID-KEYS is the same as the
     * normal case.
     *
     * Also see the definition of STORE-KEYARGS in kernel/functions.lisp (the
     * runtime version of this opcode, used when the compiler can't optimize
     * it out to this).
     */

    first_store = NOT_CDRCODE(pop());
    allow_other_keys = NOT_CDRCODE(pop());
    valid_keys = NOT_CDRCODE(pop());

    if (first_store == C_NIL) {
	printf("%%STORE-KEY-WORD-ARGS: CLOS case unimplemented.\n");
	return 0;
    }

    dump_q(valid_keys, 0);
    dump_q(allow_other_keys, 0);
    dump_q(first_store, 0);

    dump_q(car(valid_keys), 1);
    dump_q(cdr(valid_keys), 1);
    dump_string(memread(car(valid_keys) + SYM_PRINTNAME));

    dump_q(context.arg_pointer, 2);
    dump_q(context.local_pointer, 2);
    
    args_list = memread(context.local_pointer);
    dump_q(args_list, 2);

    while (NOT_CDRCODE(args_list) != C_NIL) {
	lisp_q cur_key;
	lisp_q match_key;
	lisp_q target_loc;
	int done;

	dump_q(car(args_list), 1);
	dump_q(cdr(args_list), 1);
	dump_string(memread(car(args_list) + SYM_PRINTNAME));

	cur_key = NOT_CDRCODE(car(args_list));
	match_key = valid_keys;
	target_loc = first_store;
	done = 0;

	while (NOT_CDRCODE(match_key) != C_NIL) {
	    if (NOT_CDRCODE(car(match_key)) == cur_key) {
		/* FIXME: Signal an error if a keyarg is represented twice */
		dump_q(target_loc, 5);
		dump_q(car(cdr(args_list)), 6);
		memwrite(target_loc, car(cdr(args_list)));
		break;
	    }

	    match_key = cdr(match_key);
	    target_loc += 1;
	}

	if (done) {
	    printf("%%STORE-KEY-WORD-ARGS: Unmatched keys unimplemented.\n");
	    return 0;
	}
	
	args_list = cdr(cdr(args_list));
    }

    return 1;
}

int auxop_104(u16 opcode) { /* APPLY-TO-INDS */
    lisp_q args;
    lisp_q function;
    int num_args;
    lisp_q call_info;

    function = pop();
    args = pop();

    dump_q(args, 0);
    dump_q(function, 1);

    num_args = 0;
    while (NOT_CDRCODE(args) != C_NIL) {
	push_cdrnext(car(args));
	args = cdr(args);
	num_args++;
    }

    call_info = DTP_FIX | 0x004000 | num_args | D_INDS;

    funcall(function, call_info);
    
    return 1;
}

int auxop_125(u16 opcode) { /* %OPEN-CATCH-MULTIPLE-VALUE */
    push_cdrnext(DTP_LOCATIVE | ADDRESS(context.spdl_pointer));
    push_cdrnext(context.m_catch_pointer);
    push(CDR_NIL | C_NIL);

    context.m_catch_pointer = DTP_LOCATIVE | (ADDRESS(context.pdl_pointer) - 6);
    
    return 1;
}

int auxop_132(u16 opcode) { /* %UNWIND-PROTECT-CONTINUE */
    /*
     * FIXME: Does nothing becuase of how we hacked up
     * %close-catch-unwind-protect
     */
    
    return 1;
}

int auxop_134(u16 opcode) { /* %CLOSE-CATCH */
    lisp_q being_thrown;
    lisp_q new_catch_pointer;

    u32 from;
    u32 to;
    u32 until;
    lisp_q tmp;

    being_thrown = memread(context.m_catch_pointer + 5);

    if (NOT_CDRCODE(being_thrown) != C_NIL) {
	printf("%%CLOSE-CATCH: throw in progress, not dealing.\n");
	return 0;
    }

    new_catch_pointer = memread(context.m_catch_pointer + 4);

    to = ADDRESS(context.m_catch_pointer);
    from = to + 6;
    until = ADDRESS(context.pdl_pointer);
    while (from != until) {
	tmp = memread(from);
	memwrite(to, tmp);
	from++;
	to++;
    }

    context.pdl_pointer = (context.pdl_pointer & ~Q_BITS_ADDRESS) | to;
    context.m_catch_pointer = new_catch_pointer;

    return 1;
}

int auxop_135(u16 opcode) { /* %CLOSE-CATCH-UNWIND-PROTECT */
    lisp_q being_thrown;
    lisp_q new_catch_pointer;

    u32 from;
    u32 to;
    u32 until;
    lisp_q tmp;

    being_thrown = memread(context.m_catch_pointer + 5);

    if (NOT_CDRCODE(being_thrown) != C_NIL) {
	printf("%%CLOSE-CATCH-UNWIND-PROTECT: throw in progress, not dealing.\n");
	return 0;
    }

    new_catch_pointer = memread(context.m_catch_pointer + 4);

    to = ADDRESS(context.m_catch_pointer);
    from = to + 6;
    until = ADDRESS(context.pdl_pointer);
    while (from != until) {
	tmp = memread(from);
	memwrite(to, tmp);
	from++;
	to++;
    }

    context.pdl_pointer = (context.pdl_pointer & ~Q_BITS_ADDRESS) | to;
    context.m_catch_pointer = new_catch_pointer;

    return 1;
}

int auxop_146(u16 opcode) { /* %CREATE-PHYSICAL-PAGE */
    lisp_q pfn;

    pfn = pop();

    dump_q(pfn, 0);

    create_physical_page(ADDRESS(pfn));
    
    return 1;
};

int auxop_160(u16 opcode) { /* LONG-BR-NULL-ELSE-POP */
    if (NOT_CDRCODE(context.indicators) == C_NIL) {
	context.location_counter = get_opcode();
    } else {
	pop();
	context.location_counter++;
    }

    return 1;
}

int auxop_162(u16 opcode) { /* LONG-BR-NULL */
    if (NOT_CDRCODE(context.indicators) == C_NIL) {
	context.location_counter = get_opcode();
    } else {
	context.location_counter++;
    }

    return 1;
}

int auxop_177(u16 opcode) { /* LONG-PUSHJ */
    push_cdrnext(DTP_FIX | (context.location_counter + 1));
    context.location_counter = get_opcode();
    
    return 1;
}

int step_auxop(u16 opcode)
{
    u16 opnum;

    opnum = opcode & 0x1ff;

    if (opnum == 012) {
	return auxop_012(opcode);
    } else if (opnum == 014) {
	return auxop_014(opcode);
    } else if (opnum == 017) {
	return auxop_017(opcode);
    } else if (opnum == 032) {
	return auxop_032(opcode);
    } else if ((opnum == 0101) || /* COMPLEX-CALL-TO-PUSH */
	       (opnum == 0102)) { /* COMPLEX-CALL-TO-RETURN */
	lisp_q function;
	lisp_q call_info;

	function = pop();
	call_info = pop();
	
	dump_q(function, 0);
	dump_q(call_info, 1);

	call_info &= 0xfffff1ff;
	call_info |= (opnum & 3) << 9;
	
	funcall(function, call_info);
    } else if (opnum == 0104) { /* APPLY-TO-INDS */
	return auxop_104(opcode);
    } else if (opnum == 0120) { /* RETURN-N */
	lisp_q numvals;
	numvals = pop();
	dump_q(numvals, 0);
	/* FIXME: ASSERT_DTP numvals to be DTP_FIX */
	return_n(fixnum_value(numvals));
    } else if (opnum == 0122) { /* RETURN-NIL */
	return_1(C_NIL);
    } else if (opnum == 0123) { /* RETURN-T */
	return_1(C_T);
    } else if (opnum == 0125) { /* %OPEN-CATCH-MULTIPLE-VALUE */
	return auxop_125(opcode);
    } else if (opnum == 0132) { /* %UNWIND-PROTECT-CONTINUE */
	return auxop_132(opcode);
    } else if (opnum == 0134) { /* %CLOSE-CATCH */
	return auxop_134(opcode);
    } else if (opnum == 0135) { /* %CLOSE-CATCH-UNWIND-PROTECT */
	return auxop_135(opcode);
    } else if (opnum == 0136) { /* RETURN-PRED */
	return_1((NOT_CDRCODE(context.indicators) == C_NIL)? C_NIL: C_T);
    } else if (opnum == 0137) { /* RETURN-NOT-INDS */
	return_1((NOT_CDRCODE(context.indicators) == C_NIL)? C_T: C_NIL);
    } else if (opnum == 0146) { /* %CREATE-PHYSICAL-PAGE */
	return auxop_146(opcode);
    } else if (opnum == 0160) { /* LONG-BR-NULL-ELSE-POP */
	return auxop_160(opcode);
    } else if (opnum == 0162) { /* LONG-BR-NULL */
	return auxop_162(opcode);
    } else if (opnum == 0177) { /* LONG-PUSHJ */
	return auxop_177(opcode);
    } else if ((opnum & 0700) == 0400) { /* UNBIND-n */
	/* FIXME: Need to implement this when we implement BIND */
	unbind_n((opnum & 077) + 1);
	return 1;
    } else if ((opnum & 0700) == 0500) { /* POP-n */
	context.pdl_pointer -= (opnum & 077) + 1;
    } else if ((opnum & 0700) == 0600) { /* RETURN-n */
	return_n(opnum & 077);
    } else {
	printf("Unknown auxop.\n");
	return 0;
    }

    return 1;
}

/* EOF */
