/*
 * cpu.c
 *
 * cpu board functions
 */

#include "types.h"
#include "exploiter.h"

#include "cpu.h"
#include "nubus.h"

#include <stdio.h>
#include <stdlib.h>

#define CPU_BOARD_NAME "CPU"

nubus_result cpu_read8(struct nubus_board *board, u32 address, u8 *data)
{
    printf("cpu_read8: 0x%06lx.\n", address);

    if (address == 0xfffe00) {
	*data = 0x00;
    } else if (address == 0xffff04) {
	*data = 0xc3;
    } else if (address == 0xffff38) {
	*data = 0x00;
    } else if (address == 0xffff3c) {
	*data = 0xfe;
    } else if (address == 0xffff40) {
	*data = 0xff;
    } else if (address == 0xffff84) {
	*data = CPU_BOARD_NAME[0];
    } else if (address == 0xffff88) {
	*data = CPU_BOARD_NAME[1];
    } else if (address == 0xffff8c) {
	*data = CPU_BOARD_NAME[2];
    } else if (address == 0xffc000) {
	printf("cpu_read8: %%Memory-Configuration-Register.\n");
	return NR_BUSERR;
    } else if (address == 0xffff00) {
	printf("cpu_read8: CROMO-Resource-Bits.\n");
	*data = 0x10; /* cpu */
    } else {
	printf("cpu_read8: 0x%06lx Not CROMO-Board-Type-Memory-Size-Offset.\n", address);
	exit(-1);
    }

    return NR_SUCCESS;
}

nubus_result cpu_read16(struct nubus_board *board, u32 address, u16 *data)
{
    printf("CPU: Read to unmapped space (0x%06lx).\n", address);
    exit(-1);
}

nubus_result cpu_read32(struct nubus_board *board, u32 address, u32 *data)
{
    printf("CPU: Read to unmapped space (0x%06lx).\n", address);
    exit(-1);
}

nubus_result cpu_write8(struct nubus_board *board, u32 address, u8 data)
{
    printf("CPU: Write to unmapped space (0x%06lx = 0x%02x).\n",
	   address, data);
    exit(-1);
}

nubus_result cpu_write32(struct nubus_board *board, u32 address, u32 data)
{
    printf("CPU: Write to unmapped space (0x%06lx = 0x%08lx).\n",
	   address, data);
    exit(-1);
}

void cpu_init()
{
    struct nubus_board *board;

    board = malloc(sizeof(struct nubus_board));
    board->read8 = cpu_read8;
    board->read16 = cpu_read16;
    board->read32 = cpu_read32;
    board->write8 = cpu_write8;
    board->write32 = cpu_write32;
    nubus_add_board(0xf6, board);
}

/* EOF */
