/*
 * nubus.h
 *
 * NuBus simulation
 */

#ifndef NUBUS_H
#define NUBUS_H

#include "types.h"

typedef int nubus_result; /* NR_xxx constants */

struct nubus_board {
    nubus_result (*read8)(struct nubus_board *, u32 address, u8 *data);
    nubus_result (*read16)(struct nubus_board *, u32 address, u16 *data);
    nubus_result (*read32)(struct nubus_board *, u32 address, u32 *data);
    nubus_result (*write8)(struct nubus_board *, u32 address, u8 data);
    nubus_result (*write32)(struct nubus_board *, u32 address, u32 data);
    void *(*get_memory_base)(struct nubus_board *, u32 address);
};

#define NR_SUCCESS 0
#define NR_BUSERR  1

nubus_result nubus_read8(u8 slot, u32 offset, u8 *data);
nubus_result nubus_read16(u8 slot, u32 offset, u16 *data);
nubus_result nubus_read32(u8 slot, u32 offset, u32 *data);

nubus_result nubus_write8(u8 slot, u32 offset, u8 data);
nubus_result nubus_write16(u8 slot, u32 offset, u16 data);
nubus_result nubus_write32(u8 slot, u32 offset, u32 data);

void *nubus_get_memory_base(u8 slot, u32 offset); /* speedhack */

void nubus_create_memory_board(u8 slot, u8 size_byte);
void nubus_add_board(u8 slot, struct nubus_board *board);

#define RSB_2MEG 0x1b
#define RSB_4MEG 0x2b
#define RSB_8MEG 0x4b

#endif /* NUBUS_H */

/* EOF */
