;;; -*- Mode:Common-Lisp; Package:TV; Base:10; Fonts:(CPTFONT HL10B HL12BI HL12B CPTFONTB)1;* Patch-File: T -*-

;1;;                     RESTRICTED RIGHTS LEGEND          *
;1;; Use, duplication, or disclosure by the Government is subject to*
;1;; restrictions as set forth in subdivision (b)(3)(ii) of the Rights in*
;1;; Technical Data and Computer Software clause at 52.227-7013.*
;1;;                   TEXAS INSTRUMENTS INCORPORATED.*
;1;;                            P.O. BOX 149149*
;1;;                         AUSTIN, TEXAS 78714-9149*
;1;;                             MS 2151*
;1;; Copyright (C) 1986,1987, 1988, 1989 Texas Instruments Incorporated. All rights reserved.*

;1;; This software developed by:*
;1;;*	1James Rice*
;1;; at the Stanford University Knowledge Systems Lab in 1986 and 1987.*
;1;;*
;1;; This work was supported in part by:*
;1;;*	1DARPA Grant F30602-85-C-0012*
;1;;----------------------------------------------------------------------*
;1;;  Most of this file derived from code licensed from Texas Instruments*
;1;;  Inc.  Since we'd like them to adopt these changes, we're claiming*
;1;;  no rights to them, however, the following restrictions apply to the*
;1;;  TI code:*

;1;; Your rights to use and copy Explorer System Software must be obtained*
;1;; directly by license from Texas Instruments Incorporated.  Unauthorized*
;1;; use is prohibited.*

;1;; This file implements a set of commands which add consistency between the*
;1;; tools already provided oon the Lispm.  For instance and inspect command*
;1;; is added to Zmacs, just there is one in the other tools.*

;1;; Also defined is a facility whereby edit buffer streams appear in the who*
;1;; line.*

;1 TAC 07-25-89 commented out edit buffer streams appearing in who line - problems.*
;1-------------------------------------------------------------------------------*
;1zwei:*
;1(defvar zwei:*Zmacs-Buffer-Streams-Displayed-In-Who-Line-P* nil*
;1"When true any open Zmacs buffer streams wil be displayed in the who line*
;1 along with ordinary files.*
;1"*
;1)*

;1(defvar *background-process-display-font* fonts:tiny*
;1"The font in which to display background processes."*
;1)*

;1(defvar *who-line-run-state-toggle-time* 0.5*
;1"The time after which the run state sheet toggles into showing*
;1 background processes.*
;1"*
;1)*

;1(defvar *show-background-processes-in-who-line* nil*
;1"When true background processes that are interesting are shown in the who-line*
;1 run-state part of the who line.*
;1"*
;1)*

;1;(setq *show-background-processes-in-who-line* t)*

;1(defvar *Chars-for-who-line-package* 7.*
;1  "The number of chars in the who-line for the package name."*
;1)*
;1(export '*Chars-for-who-line-package* 'tv)*

;1(defvar *Chars-for-who-line-process-state* 20.*
;1  "The number of chars in the who-line for the process-state."*
;1)*
;1(export '*Chars-for-who-line-process-state* 'tv)*

;1(defvar *Show-Two-Files-In-Who-Line* nil*
;1  "When non-nil, two files will be shown in the who line when appropriate."*
;1)*
;1(export '*Show-Two-Files-In-Who-Line* 'tv)*

;1 ;; End of microExplorer conditionalization*

;1-----------------------------------------------------------------------------------------------------------*
;1;; Support for fat strings.*

(DEFUN 4format-fat-string-stream* (op &rest args)
  (CASE op
    (:tyo
     (OR format::format-string (SETQ format::format-string (MAKE-ARRAY 64. :type 'art-fat-string :fill-pointer 0.)))
      (VECTOR-PUSH-EXTEND (FIRST args) format::format-string))
    (:string-out
     (LET ((STRING (FIRST args))
	   (FIRST (OR (SECOND args) 0.))
	   (LAST (THIRD args))
	   new-length)
       (OR format::format-string (SETQ format::format-string (MAKE-ARRAY 64. :type 'art-fat-string :fill-pointer 0.)))
       (SETQ last (OR last (LENGTH string)))
       (SETQ new-length (+ (ARRAY-LEADER format::format-string 0.) (- last first)))
       (AND (< (ARRAY-TOTAL-SIZE format::format-string) new-length)
	  (ADJUST-ARRAY format::format-string (+ (ARRAY-TOTAL-SIZE format::format-string) new-length)))
       (COPY-ARRAY-PORTION string first last format::format-string (ARRAY-LEADER format::format-string 0.)
			   new-length)
       (STORE-ARRAY-LEADER new-length format::format-string 0.)))
    (:read-cursorpos
     (LET ((mode (OR (FIRST args) :character))
	   pos)
       (OR format::format-string (SETQ format::format-string (MAKE-ARRAY 64. :type 'art-fat-string :fill-pointer 0.)))
       (OR (EQ mode :character) (FERROR () "3String cannot have :PIXEL*"))
       (SETQ pos
	     (POSITION #\Newline (THE string (STRING format::format-string)) :from-end t :test
		       #'CHAR-EQUAL))
       (VALUES (- (LENGTH format::format-string) (IF pos
					   (+ pos 1.)
					   0.)) 0.)))
    (:increment-cursorpos
     (LET ((dx (FIRST args))
	   (dy (SECOND args))
	   (mode (OR (THIRD args) :character))
	   newlen)
       (OR format::format-string (SETQ format::format-string (MAKE-ARRAY 64. :type 'art-fat-string :fill-pointer 0.)))
       (OR (EQ mode :character) (FERROR () "3String cannot have :PIXEL*"))
       (OR (AND (ZEROP dy) (NOT (MINUSP dx))) (FERROR () "3Cannot do this :INCREMENT-CURSORPOS*"))
       (SETQ newlen (+ (LENGTH format::format-string) dx))
       (AND (< (ARRAY-TOTAL-SIZE format::format-string) newlen)
	  (ADJUST-ARRAY format::format-string (+ (ARRAY-TOTAL-SIZE format::format-string) newlen)))
       (DO ((i (LENGTH format::format-string) (1+ i)))
	   ((>= i newlen))
	 (SETF (AREF format::format-string i) #\Space))
       (STORE-ARRAY-LEADER newlen format::format-string 0.)))
    (:set-cursorpos
     (LET ((x (FIRST args))
	   (y (SECOND args))
	   (mode (OR (THIRD args) :character))
	   pos
	   delta
	   newlen)
       (OR format::format-string (SETQ format::format-string (MAKE-ARRAY 64. :type 'art-fat-string :fill-pointer 0.)))
       (OR (EQ mode :character) (FERROR () "3String cannot have :PIXEL*"))
       (SETQ pos (STRING-REVERSE-SEARCH-SET '(#\Newline #\Linefeed #\Page) format::format-string)
	     delta (- x (- (LENGTH format::format-string) (IF pos
						    (+ pos 1.)
						    0.))))
       (OR (AND (ZEROP y) (PLUSP delta)) (FERROR () "3Cannot do this :SET-CURSORPOS*"))
       (SETQ newlen (+ (LENGTH format::format-string) delta))
       (AND (< (ARRAY-TOTAL-SIZE format::format-string) newlen)
	  (ADJUST-ARRAY format::format-string (+ (ARRAY-TOTAL-SIZE format::format-string) newlen)))
       (DO ((i (LENGTH format::format-string) (1+ i)))
	   ((>= i newlen))
	 (SETF (AREF format::format-string i) #\Space))
       (STORE-ARRAY-LEADER newlen format::format-string 0.)))
    (:untyo-mark (FILL-POINTER format::format-string))
    (:untyo (LET ((mark (FIRST args)))
	      (SETF (FILL-POINTER format::format-string) mark)))
    (extract-string (PROG1
		      format::format-string
		      (SETQ format::format-string ())))
    (:get-string format::format-string)
    (:fresh-line
     (WHEN (NOT
       (OR (NULL format::format-string) (ZEROP (LENGTH format::format-string))
	  (= (AREF format::format-string (1- (LENGTH format::format-string))) #\Newline)))
       (VECTOR-PUSH-EXTEND #\Newline format::format-string)
       t))
    (:which-operations nil
     '(:tyo :string-out :read-cursorpos :increment-cursorpos :set-cursorpos :untyo-mark :untyo
       extract-string :fresh-line))
    (t (STREAM-DEFAULT-HANDLER 'format::format-string-stream op (CAR args) (CDR args)))))

(DEFUN 4make-fat-string-output-stream* (&optional string start-index extra-arg)
  (IF (STRINGP start-index)
    (LET ((STRING start-index)
	  (start-index extra-arg))
      (LET-CLOSED
       ((format-string
	  (OR string
	      (MAKE-ARRAY 64. :type 'art-fat-string :fill-pointer 0.))))
       (IF start-index
	 (SETF (FILL-POINTER format-string) start-index))
       'format-string-stream))
    (LET-CLOSED
      ((format-string
	 (OR string
	     (MAKE-ARRAY 64. :type 'art-fat-string :fill-pointer 0.))))
       (IF start-index
	 (SETF (FILL-POINTER format-string) start-index))
       'format-fat-string-stream)))

(DEFMACRO 4with-output-to-fat-string*
	  ((STREAM string index) &body body &aux (string-symbol string))
  (MULTIPLE-VALUE-BIND (realbody decls)
      (PARSE-BODY body nil nil)
    (LET ((doc (AND  decls `((DECLARE . ,(sys::flatten-declarations decls))))))
      (IF index
	  `(LET* (,@(AND (NOT (SYMBOLP string))
			 `((,(SETF string-symbol (GENSYM))  ,string)))
		  (,stream
		   (make-fat-string-output-stream ,string-symbol ,index)))
	     ,@doc 
	     (UNWIND-PROTECT
		     (PROGN
		       ,@realbody)
		   (SETF ,index (LENGTH ,string-symbol))))
	      `(LET ((,stream (make-fat-string-output-stream
				,@(IF string `(,string)))))
		 ,@doc
		 ,@realbody
		 ,@(IF (NULL string )
		       `((GET-OUTPUT-STREAM-STRING ,stream))))))))

sys:
(DEFUN 4sys::make-string-input-stream* (STRING &optional (start 0) end)
  "2Return a stream from which one can read the characters of STRING, or some substring of it.
 START and END are indices specifying a substring of STRING;
 they default to 0 and NIL (NIL for END means the end of STRING).*"
  (SETQ string (IF (TYPEP string 'VECTOR) string (STRING string)))
  (LET-CLOSED ((*ioch start) (*ioend (OR end (LENGTH string))) (*iolst string))
     'read-from-string-stream))

;1-------------------------------------------------------------------------------*

;1;; Support for searching and grovling over items in inspectors and such-like.*

;1**************
;1 TAC 07-26-89 - defstruct was defined in Structure-Enhancements which*
;1                redefines 2 kernel functions radically enough that a decision*
;1                NOT to use it was made. Instead, map defstruct back to *
;1                original DEFSTRUCT with (DEFF defstruct 'DEFSTRUCT) in the*
;1                TI-ENV-INSPECTOR-INTERFACE file .*

;1------------------------------------------------------------------------------*

;1;; A defstruct with which to remember the saved points in the searches.*
(defstruct 4(saved-pos* :named) line char printed string failed-p)

(DEFUN 4(:property saved-pos named-structure-invoke*)
       (message-name pos &rest arguments)
  (CASE message-name
    (:print-self
      (LET ((STREAM   (FIRST arguments)))
	   (FORMAT stream "3#<Saved Pos: ~A, ~A>*" (saved-pos-line pos)
		   (saved-pos-char pos))))
    (:which-operations '(:which-operations :print-self))
    (otherwise (FERROR "3Illegal message ~A sent to a saved pos.*"))))

(DEFPARAMETER 4*last-search-string** ""
"2The last string used by the user in searching.*")

;1-------------------------------------------------------------------------------*

;1 TAC 08-09-89 - not doing source code debugging*
;1(defparameter *fontify-this-region* nil*		
;1"When true tells the pretty printer to fontify the region.  If it is not source*
;1 code debugging then its value is the font number to fontify to.*
;1"*
;1)*

;1(defparameter *font-for-selected-region* 1*
;1"The font number to use for the selected region in source code debugging."*
;1)*

;1(defun shifted-font ()*
;1"Returns the font number to which to shift."*
;1  (declare (special eh::*grinding-debugged-source-code* eh::*current-pc*))*
;1  (if (and (boundp 'eh::*grinding-debugged-source-code*)*
;	1   eh::*grinding-debugged-source-code**
;1      )*
;1      ;;; Hook for Source code debugger.*
;1      (if (equal (first (funcall 'eh::numbered-component-numbers*
;			1  (first eh::*grinding-debugged-source-code*)))*
;		1 eh::*current-pc* )*
;	1  *font-for-selected-region**
;	1  (+ 1 *font-for-selected-region*))*
;1      (if (numberp *fontify-this-region*)*
;	1  *fontify-this-region**
;	1  0)))*

(DEFPARAMETER 4*fontify-this-region** nil		
  "2When true tells the pretty printer to fontify the region.*")

(DEFUN 4shifted-font* ()
  "2Returns the font number to which to shift.*"
  (IF (NUMBERP *fontify-this-region*)
      *fontify-this-region*
      0))

(DEFUN 4fontify-char* (CHAR)
"2Given a char returns the char fontified to the (shifted-font).*"
  (CODE-CHAR (TYPECASE char
	       (integer (CODE-CHAR char))
	       (CHARACTER (CODE-CHAR (CHAR-CODE char)))
	       (otherwise (BEEP) char))
	     0 (OR (shifted-font) 0)))

(DEFFLAVOR 4pseudo-itemising-stream*
	   (STREAM           ;1; Actual stream to print to.*
	    (current-font 0) ;1; Printing in this font.*
	    superior         ;1; The superior of the current window, which created me.*
	    (width 0)        ;1; The current printed width in pixels.*
	    max-width        ;1; The max width of the window.*
	    font-map         ;1; The font map of the window.*
	   )
	   (si:output-stream)
  :initable-instance-variables
  :settable-instance-variables
  :gettable-instance-variables
  (:documentation "3A stream which font-shifts all of its characters if necessary.*"))

(DEFMETHOD 4(pseudo-itemising-stream :tyo*) (CHAR &rest args)
"2Prints char to the stream, fontifying it to the stream's current font.*"
  (LET ((the-char (CODE-CHAR (CHAR-CODE (fontify-char char)) 0 current-font)))
       ;1; Record the width of the char.*
       (SETQ width (+ (font-char-width (AREF font-map current-font)) width))
       ;1; Throw if we've written too much, otherwise print it.*
       (IF (>= width max-width)
	   (THROW 'TRUNCATE nil)
	   (LEXPR-SEND stream :tyo the-char args))))

(DEFMETHOD 4(pseudo-itemising-stream :item1*)
    (item type &optional (FUNCTION #'PRIN1) &rest print-args)
"2A dummy version of the :item1 method.*"
  (IGNORE type)
  (APPLY function item self print-args))

(DEFMETHOD 4(pseudo-itemising-stream :compound*) (some-items)
  (LOOP for item in some-items do
	(IF (CONSP item)
	    (LEXPR-SEND self item)
	    (FORMAT self "3~A*" item))))

(DEFMETHOD 4(pseudo-itemising-stream :read-cursorpos*) (&rest args)
"2Passes this message on so that tabbing works ok.*"
  (LEXPR-SEND stream :read-cursorpos args))

(DEFMETHOD 4(pseudo-itemising-stream :increment-cursorpos*)
	   (x-increment y-increment &optional (mode :pixel))
"2Passes this message on so that tabbing works ok.*"
  ;1; Increment width as approriate.*
  (SETQ width (+ (IF (EQUAL mode :pixel)
		     x-increment
		     (* (font-char-width (AREF font-map 0)) x-increment))
		 width))
  ;1; Do this because sometimes we get negative increments on 0 length strings.*
  (CATCH-ERROR (SEND stream :increment-cursorpos x-increment y-increment mode)
	       nil))

;1-------------------------------------------------------------------------------*

(DEFUN 4print-out-item*
       (print-function print-function-arg item item-number width)
"2Prints out a window item for an inspect window into a fat string.*"
  (LET ((result
	  (IF (EQUAL (SEND self :print-function-arg)
		     :list-structure)
	      (LET ((item (AREF (SEND self :items) item-number)))
		   (IF (AND (CONSP item) (STRINGP (SECOND item)))
		       (SECOND item)
		       ""))
	      (with-output-to-fat-string (string-stream)
		(LET ((*standard-output*
			(MAKE-INSTANCE
			  'pseudo-itemising-stream
			  :stream    string-stream
			  :superior  (SEND self :superior)
			  :max-width (OR width (SEND self :width))
			  :font-map  (SEND self :font-map))))
		     (CATCH 'TRUNCATE
			    (FUNCALL print-function item print-function-arg
				     *standard-output* item-number)))))))
       (IF result result "")))

(DEFMETHOD 4(function-text-scroll-window :stringise-item*)
	   (item-number cache &optional (max-width (SEND self :width)))
"2Given an item number from self's items, finds a fat-string printed
 representation of it in the cache or prints it to a fat string and caches it
 as needed.  Returns the string.*"
  (OR (AREF cache item-number)
      (LET ((str (print-out-item print-function print-function-arg
				 (SEND self :item-of-number item-number)
				 item-number max-width)))
	   (SETF (AREF cache item-number) str)
	   str)))

(DEFUN 4search-for-item*
    (cache string item-number from-line from-char reverse-p)
"2Searches forwards or backwards, according to reverse-p for String in the item
 of self, whose index is Item-Number.  It starts looking from the beginning or
 end of the item as approriate, using from-line and from-char to tell it where
 to start from if the search is on the line that we're already on - we have to
 make sure that we don't find the same match again unless we want to.*"
  (LET ((printed
	  (SEND self :stringise-item item-number cache most-positive-fixnum)))
       (LET ((index
	        (IF (EQUAL from-line item-number)
		    (SEARCH string printed :test #'CHAR-EQUAL
			    :start2 (IF reverse-p nil from-char)
			    :end2   (IF reverse-p
					(+ (LENGTH string) from-char)
					nil)
			    :from-end reverse-p)
		    (SEARCH string printed :test #'CHAR-EQUAL
			    :from-end reverse-p))))
	    (IF index
		(VALUES index printed)
		(VALUES nil nil)))))

(DEFMETHOD 4(function-text-scroll-window :search*)
	   (cache for &optional (from-line 0) (from-char 0) (printed-line "")
	    (reverse-p nil))
"2Searches for the string For in the window items self either forwarrds or
 backwards, as defined by reverse-p, starting from From-line, From-Char.*"
  (IGNORE printed-line)
  (IF reverse-p
      (LOOP for item downfrom from-line to 0
	    do (MULTIPLE-VALUE-BIND (CHAR line)
		   (search-for-item cache for item from-line from-char t)
		 (IF char (RETURN item char line) nil))
	    finally (RETURN nil nil nil))
      (LOOP for item from from-line to (- (SEND self :number-of-items) 1)
	    do (MULTIPLE-VALUE-BIND (CHAR line)
		   (search-for-item cache for item from-line from-char nil)
		 (IF char (RETURN item char line) nil))
	    finally (RETURN nil nil nil))))

(DEFMETHOD 4(function-text-scroll-window :move-to*) (pos reverse-p)
"2Moves Self to the position described by Pos, scrolling the window so that the
 item is at the top if necessary.  The blinker is moved to point at the
 beginning of the string and sized to fit the char under it.*"
  (MULTIPLE-VALUE-BIND (bottom line) (SEND self :bottom-item-no-on-screen)
    (IGNORE line)
    (IF (OR (< (saved-pos-line pos) top-item) (> (saved-pos-line pos) bottom))
	(SEND self :scroll-to (saved-pos-line pos) :absolute)
	nil)
    (IF (STRING-EQUAL "" (saved-pos-printed pos))
	nil
	(LET ((CHAR (+ (AREF (saved-pos-printed pos) (saved-pos-char pos))
		       (IF reverse-p 0 (LENGTH (saved-pos-string pos))))))
	     (SEND (FIRST blinker-list) :set-visibility :blink)
	     (LET ((font (AREF font-map (CHAR-FONT char))))
	          (LET ((bl-width (IF (AND (font-char-width-table font)
					   (> (AREF (font-char-width-table font)
						    (CHAR-CODE char))
					      0))
				      (AREF (font-char-width-table font)
					    (CHAR-CODE char))
				      (font-char-width font))))
		       (MULTIPLE-VALUE-BIND (final-x final-y)
			   (sheet-compute-motion self 0 0
			       (saved-pos-printed pos) 0
			       (+ (IF reverse-p
				      0
				      (LENGTH (saved-pos-string pos)))
				  (saved-pos-char pos)))
			 (SEND (FIRST blinker-list) :set-size-and-cursorpos
			       bl-width
			       (font-char-height font)
			       (IF (> final-y 0)
				   (- (sheet-inside-right self) bl-width)
				   final-x)
			       (* (SEND self :line-height)
				  (- (saved-pos-line pos) top-item))))))))))

(DEFMACRO 4with-saved-pos* (&body body)
"2Binds the names Line, Char and Printed to position at the top of the
 saved position stack.*"
  `(LET ((pos (FIRST saved-positions)))
        (DECLARE (UNSPECIAL pos))
	(CHECK-TYPE pos saved-pos)
        (LET ((line    (saved-pos-line    pos))
	      (CHAR    (saved-pos-char    pos))
	      (printed (saved-pos-printed pos))
	      (STRING  (saved-pos-string  pos))
	     )
	  (DECLARE (UNSPECIAL line char printed string))
	     (CHECK-TYPE line    integer)
	     (CHECK-TYPE char    integer)
	     (CHECK-TYPE printed string)
	     (CHECK-TYPE string  string)
	     ,@body)))

(DEFUN 4new* (new-string line char printed failed-p)
"2Create a new saved position record for new-string, line, char.  If the last one
 was a failed one then do nothing.  If this one is failed then use the line char
 etc. of the last one.  Beep if this is the first failure.*"
  (DECLARE (SPECIAL saved-positions))
  (IF failed-p
      (IF (AND (saved-pos-failed-p (FIRST saved-positions))
	       (STRING-EQUAL (saved-pos-string (FIRST saved-positions))
			     new-string))
	  nil ;1; We've already failed so do nothing.*
	  (with-saved-pos
	    (IF (saved-pos-failed-p (FIRST saved-positions)) nil (BEEP))
	    (PUSH (make-saved-pos :line line
				  :char char
				  :printed printed
				  :string new-string
				  :failed-p failed-p)
		  saved-positions)))
      (PUSH (make-saved-pos :line line
			    :char char
			    :printed printed
			    :string new-string
			    :failed-p failed-p)
	    saved-positions)))

(DEFMETHOD 4(function-text-scroll-window :process-other-char*)
	   (cache char reverse-p)
"2Processes a typed in char which is not a special one, such as c-s.  Continues
 the search.*"
  (DECLARE (SPECIAL *last-search-string* saved-positions))
  (LET ((new-string
	  (STRING-APPEND (saved-pos-string (FIRST saved-positions)) char)))
       (MULTIPLE-VALUE-BIND (line char printed)
	   (with-saved-pos (IGNORE string)
	     (SEND self :search cache new-string line char printed reverse-p))
	 (IF line
	     (PROGN (new new-string line char printed nil)
		    (SETQ *last-search-string* new-string)
		    (SEND self :move-to (FIRST saved-positions) reverse-p))
	     (with-saved-pos (IGNORE string)
	       (new new-string line char printed t))))))

(DEFMETHOD 4(function-text-scroll-window :process-next-search*) (cache reverse-p)
"2Processes a request to continue the search, i.e. c-s or c-r.  Reverse-p defines
 whether to search forwards or backwards.*"
  (DECLARE (SPECIAL saved-positions))
  (MULTIPLE-VALUE-BIND (line char printed)
      (with-saved-pos
	(LET ((STRING (IF (EQUALP string "") *last-search-string* string)))
	     (DECLARE (UNSPECIAL string))
	     (SEND self :search cache string line (+ (IF reverse-p -1 1) char)
		   printed reverse-p)))
      (LET ((STRING (IF (EQUALP (saved-pos-string (FIRST saved-positions)) "")
			*last-search-string*
			(saved-pos-string (FIRST saved-positions)))))
	   (DECLARE (UNSPECIAL string))
	   (IF line
	       (PROGN (new string line char printed nil)
		      (SEND self :move-to (FIRST saved-positions) reverse-p))
	       (new string line char printed t)))))

(DEFMETHOD 4(function-text-scroll-window :show-search-string*) (reverse-p)
"2Print out the search string in the prompt window i nthe form \"ISearch: foo\".
 Also prints out Reverse and Failing, as appropriate.*"
  (DECLARE (SPECIAL saved-positions))
  (SEND *query-io* :set-cursorpos 0
       (SECOND (MULTIPLE-VALUE-LIST (SEND *query-io* :read-cursorpos))))
  (SEND *query-io* :clear-eol)
  (IF (saved-pos-failed-p (FIRST saved-positions))
      (FORMAT *query-io* "3Failing *")
      nil)
  (IF reverse-p (FORMAT *query-io* "3Reverse *") nil)
  (FORMAT *query-io* "3I-Search: ~A*" (saved-pos-string (FIRST saved-positions))))

(DEFMETHOD 4(function-text-scroll-window :get-a-char*) ()
"2Reads a char from the user, coercing it into a char if it can.  It does this so
 that it can spot mouse blips and yet still get char objects.*"
  (LET ((CHAR (SEND *query-io* :any-tyi)))
       (TYPECASE char
	 (CONS char)
	 (integer (INT-CHAR char))
	 (CHARACTER char)
	 (otherwise (BEEP)))))

(DEFMETHOD 4(function-text-scroll-window :control-s-internal*) (reverse-p cache)
"2Loops reading chars from the user and searches for the designated thing in the
 window, like c-s/c-r in ZMacs.*"
  (DECLARE (SPECIAL saved-positions))
  (LOOP for char = (SEND self :get-a-char)
	do (CASE char
	     (#\ (FORMAT *query-io* "3~&*") (RETURN nil))
	     (#\c-s
	      (SETQ reverse-p nil)
	      (SEND self :process-next-search cache reverse-p))
	     (#\c-r
	      (SETQ reverse-p :backwards)
	      (SEND self :process-next-search cache reverse-p))
	     (#\rubout
	       (IF (REST saved-positions)
		   (PROGN (POP saved-positions)
			  (SEND self :move-to (FIRST saved-positions) reverse-p))
		   (BEEP)))
	     (otherwise
	      (IF (CONSP char)
		  (PROGN (FORMAT *query-io* "3~&*") (RETURN nil))
		  (SEND self :process-other-char cache char reverse-p))))
	   (SEND self :show-search-string reverse-p)))

(DEFMETHOD 4(function-text-scroll-window :bottom-item-no-on-screen*) ()
"2Returns values of the item# for the bottom item on the screen and the number
 of lines on the screen.*"
  (LET ((lines-on-screen (FLOOR (/ (SEND self :inside-height)
				   (SEND self :line-height)))))
    (VALUES (+ top-item lines-on-screen) lines-on-screen)))

(DEFMETHOD 4(function-text-scroll-window :start-saved-position*) (reverse-p cache)
"2Determines an initial position from which to start the search and makes a
 saved position do hold it.  It has to stringise a line to do this so the cache
 is passed so that it can be saved.*"
  (IF reverse-p
      (LET ((line (- (MIN (SEND self :bottom-item-no-on-screen)
		          (SEND self :number-of-items))
		     1)))
	   ;1; End of last line on screen.*
	   (LET ((STRING (SEND self :stringise-item line cache)))
	       `(,(make-saved-pos :line line :printed string :string ""
			:char (MAX 0 (- (ARRAY-ACTIVE-LENGTH string) 1))
			:failed-p nil))))
      ;1; Beginning of first line on screen.*
     `(,(make-saved-pos :line (SEND self :top-item) :char 0 :string "" :printed
           (SEND self :stringise-item 0 cache) :failed-p nil))))

(DEFMETHOD 4(function-text-scroll-window :reset-blinkers*) ()
"2Cleans up blinkers.  Sometimes these can get confused.  This is bit kludgy.*"
  (LET ((blinkers (BUTLAST (tv:sheet-blinker-list self) 2)))
       (MAPCAR #'(lambda (x)
		   (SEND x :set-visibility nil)
		   (SETF (tv:sheet-blinker-list self)
			 (REMOVE x (tv:sheet-blinker-list self))))
		 blinkers)))

(DEFMETHOD 4(function-text-scroll-window :make-a-blinker*) (reverse-p)
"2Makes a blinker and sets its initial position.  The initial position is
 determined by whether we are going forwards or backwards.*"
  (make-blinker self 'rectangular-blinker
		;1;; These positions are a bit random.*
		:x-pos (IF reverse-p (- (SEND self :inside-width)  10) 10)
		:y-pos (IF reverse-p (- (SEND self :inside-height) 10)  0)))

(DEFMETHOD 4(function-text-scroll-window :control-s*) (reverse-p)
"2Searches over the items in an inspect window (optionally backwards) in such
 a manner that it looks like I-Search in ZMacs.*"
  (SEND self :reset-blinkers)
  (FORMAT *query-io* (IF reverse-p "3~&Reverse I-Search: *" "3~&I-Search: *"))
  (IF (> (SEND self :number-of-items) 0)
      (LET ((cache (MAKE-ARRAY (SEND self :number-of-items))))
	   (LET ((saved-positions
		   (SEND self :start-saved-position reverse-p cache))
		 (old-visibilities (get-visibility-of-all-sheets-blinkers self))
		 (blinker (SEND self :make-a-blinker reverse-p)))
	        (DECLARE (SPECIAL saved-positions)
			 (UNSPECIAL old-visibilities blinker))
	        ;1; These functions would be IVs if this was to be a mixin.*
	        ;1; Mixing it in would be a good idea in principle but a drag in practice.*
	        (UNWIND-PROTECT
		    (PROGN (set-visibility-of-all-sheets-blinkers
			     self
			     (CONS :blink
				   (MAKE-LIST (LENGTH old-visibilities))))
			   (SEND self :control-s-internal reverse-p cache))
		  (open-blinker blinker)
		  (set-visibility-of-all-sheets-blinkers
		    self (CONS nil old-visibilities))
		  (SETF (sheet-blinker-list self)
			(REMOVE blinker (sheet-blinker-list self))))))
      (PROGN (FORMAT *query-io* "3Nothing in window.*") (BEEP))))

(DEFUN 4get-a-pane* (frame numeric-arg)
"2Given a frame and the numeric arg typed by the user, if any, it selects a pane
 in the frame to use.  This should be an instance of Function-Text-Scroll-Window.
 If there is a numeric arg, then it picks the window under the mouse.  If not then 
 it picks the first Inspect-Pane-With-Typeout instance in the exposed-inferiors, 
 failing that it picks the first Basic-Inspect.*"
  (IF numeric-arg
      (IF (TYPEP (window-under-mouse) 'function-text-scroll-window)
	  (window-under-mouse)
	  (PROGN (BEEP)
		 (FORMAT *query-io*
			 "3~&Cannot search in window under mouse.~&*")
		 nil))
      (OR (FIND-IF
	    #'(lambda (x) (TYPEP x 'inspect-pane-with-typeout))
	    (SEND frame :exposed-inferiors))
	  (FIND-IF
	    #'(lambda (x) (TYPEP x 'inspect-window-with-typeout))
	    (SEND frame :exposed-inferiors))
	  (FIND-IF
	    #'(lambda (x) (TYPEP x 'basic-inspect))
	    (SEND frame :exposed-inferiors)))))

(DEFUN 4process-control-s* (frame reverse-p numeric-arg)
"2Searches over the items in the main inspect window (optionally backwards) of
 the frame in such a manner that it looks like I-Search in ZMacs.*"
  (LET ((pane (get-a-pane frame numeric-arg)))
       (IF pane (SEND pane :control-s reverse-p) nil)))

;1-------------------------------------------------------------------------------*

(DEFMETHOD 4(function-text-scroll-window :meta-w*) ()
"2Like m-w in Zmacs, copies the text in the window into the kill ring.*"
  (IF (> (SEND self :number-of-items) 0)
      (LET ((cache (MAKE-ARRAY (SEND self :number-of-items))))
	   (MULTIPLE-VALUE-BIND (bottom ignore)
	       (SEND self :bottom-item-no-on-screen)
	     (LET ((result nil))
	          (LOOP for i
			from top-item
			to (- (MIN bottom (SEND self :number-of-items)) 1)
			do (PUSH (SEND self :stringise-item i cache) result)
			   (PUSH #\newline result))
		  (zwei:kill-string
		    (APPLY #'STRING-APPEND
			   (CONS (FORMAT nil "3~A~&*" (SIXTH (SEND self :label)))
				 (REVERSE result)))
		    nil nil))))
      (PROGN (FORMAT *query-io* "3Nothing in window.*") (BEEP))))

(DEFUN 4process-meta-w* (frame numeric-arg)
"2Called when the user does a m-w in the inspector/debugger.  Copies the text
 in the window into the kill ring as appropriate.*"
  (LET ((pane (get-a-pane frame numeric-arg)))
       (IF pane (SEND pane :meta-w) nil)))

;1-------------------------------------------------------------------------------*

;1;; The Meta-W command (save-region).*

(DEFCOMMAND 4save-region-cmd* (numeric-arg)
  '(:description
     "3Puts the contents of the window into the kill ring, numeric arg for window under mouse.*"
    :names ("3Save Region*")
    :keys (#\m-w)
    :arguments (ucl:numeric-argument))
  (DECLARE (SPECIAL frame))
  (process-meta-w frame numeric-arg)
  (SEND frame :handle-prompt))

eh:
(DEFCOMMAND 4eh::comw-save-region* (numeric-arg)
  '(:description
     "3Puts the contents of the window into the kill ring, numeric arg for window under mouse.*"
     :names ("3Save Region*")
     :keys (#\m-w)
     :arguments (ucl:numeric-argument))
  (DECLARE (SPECIAL *window-debugger*))
  (tv::process-meta-w *window-debugger* numeric-arg)
  (SEND *window-debugger* :handle-prompt))

;1-------------------------------------------------------------------------------*

;1;; The ISearch Command.*

(DEFCOMMAND 4search-cmd* (numeric-arg)
  '(:description
     "3I-Search for text in window, numeric arg for window under mouse.*"
    :names ("3Search*")
    :keys (#\c-s #\c-sh-s)
    :arguments (ucl:numeric-argument))
  (DECLARE (SPECIAL frame))
  (process-control-s frame nil numeric-arg)
  (SEND frame :handle-prompt))

eh:
(DEFCOMMAND 4eh::comw-isearch* (numeric-arg)
  '(:description
     "3I-Search for text in window, numeric arg for window under mouse.*"
     :names ("3Search*")
     :keys (#\c-sh-s)
     :arguments (ucl:numeric-argument))
  (DECLARE (SPECIAL *window-debugger*))
  (tv::process-control-s *window-debugger* nil numeric-arg)
  (SEND *window-debugger* :handle-prompt))

;1-------------------------------------------------------------------------------*

;1;; The Reverse ISearch command.*

;1**************
;1 TAC 08-01-89 - moved into INSPECT.LISP where it belongs*
;1(defcommand refresh-cmd nil*
;1  '(:description *
;1"Redisplay the inspected objects, updating any fields that have changed values."*
;1;;; Changed from Control r by JPR.*
;1    :names ("Refresh" "Decache") :keys (#\m-R))*
;1  (declare (special history frame))*
;1  (send history :set-cache nil)*
;1  (update-panes)*
;1)*

(DEFCOMMAND 4reverse-search-cmd* (numeric-arg)
  '(:description
     "3Reverse I-Search for text in window, numeric arg for window under mouse.*"
    :names ("3Reverse Search*")
    :keys (#\c-r #\c-sh-r)
    :arguments (ucl:numeric-argument))
  (DECLARE (SPECIAL frame))
  (process-control-s frame :backwards numeric-arg)
  (SEND frame :handle-prompt))

eh:
(DEFCOMMAND 4eh::comw-reverse-isearch* (numeric-arg)
  '(:description
     "3Reverse-I-Search for text in window, numeric arg for window under mouse.*"
     :names ("3Reverse Search*")
     :keys (#\c-sh-r)
     :arguments (ucl:numeric-argument))
  (DECLARE (SPECIAL *window-debugger*))
  (tv::process-control-s *window-debugger* :backwards numeric-arg)
  (SEND *window-debugger* :handle-prompt))

;1-------------------------------------------------------------------------------*

;1;; The Inspect command*

;1-------------------------------------------------------------------------------*


;1;; Code for the implementation of an Inspect Region command in Zmacs.*

zwei:
(DEFUN 4zwei::read-until-eof* (STREAM)
"2Given a stream this function returns a list of all of the forms that it reads
from the stream until it gets to the end of file.*"
  (LET ((sexpr (READ stream nil :eof)))
       (IF (EQUAL sexpr :eof) nil (CONS sexpr (read-until-eof stream)))))

zwei:
(DEFUN 4zwei::read-form-or-forms-from-buffer* (&optional (section-p nil))
"2This function reads either a form or a collection of forms from the current
buffer.  If a section has been marked out then forms are read from this,
otherwise a form is read from after the cursor.  If only one form is found
then this is returned.  If more than one form is found then a list containing
these forms is returned.*"
  (IF (OR (window-mark-p *window*) section-p)
      (LET ((bp1 (mark))
	    (bp2 (point))
	    (defun-name nil)	   )
	   (OR (bp-< bp1 bp2) (PSETQ bp1 bp2 bp2 bp1))
	   (IF (bp-= (forward-over *whitespace-chars* (mark))
		     (forward-over *whitespace-chars* (point)) )
	       (SETQ *mark-stays* nil)
	       (SETQ defun-name "3Region*"))
	   (COND (defun-name)
		 ((SETQ bp1 (defun-interval (beg-line (point)) 1 () ()))
		  (SETQ bp2 (interval-last-bp bp1) bp1 (interval-first-bp bp1))
		  ;;(SETQ si:*force-defvar-init* t)
		  )
		 (t (barf "3Unbalanced parentheses*")))
	   (LET ((STREAM (interval-stream bp1 bp2 t)))
	        (UNWIND-PROTECT
		  (LET ((all-sexprs (read-until-eof stream)))
		       (VALUES (IF (EQUAL (LENGTH all-sexprs) 1)
				   (FIRST all-sexprs)
				   all-sexprs)
			       (IF defun-name
				   defun-name
				   (SEND (ARRAY-LEADER (bp-line bp1) 5) :name))))
		  (CLOSE stream))))
      (LET ((STREAM (rest-of-interval-stream (point))))
	   (UNWIND-PROTECT
	     (LET ((sexpr (READ stream nil :eof)))
	          (VALUES (IF (EQUAL :eof sexpr) :nothing-found sexpr)
			  "3Expression*"))
	     (CLOSE stream)))))

zwei:
(defcom 4zwei::com-inspect-region* "3Call the inspector on a region.*" ()
  (LET ((sexprs (read-form-or-forms-from-buffer)))
       (IF (EQUAL :nothing-found sexprs)
	   (BEEP)
	   (INSPECT sexprs)))
  dis-none)

;1 TAC 08-01-89 - moved code below to WINDOW-DEBUG.LISP*
;1-------------------------------------------------------------------------------*

;1;; Add key assignments to the inspect command in the debugger.*

;1eh:*
;1(DEFCOMMAND eh:COMW-INSPECT-CMD NIL*
;1 '(:DESCRIPTION  "Inspect an object specified with keyboard or mouse."*
;1   :NAMES "Inspect" *
;1   :KEYS (#\c-sh-I #\M-sh-I #\c-I))*
;1 (SEND *WINDOW-DEBUGGER* :SET-WHO-LINE-DOC-STRING-OVERIDE "Select an object to inspect.")*
;1 (UNWIND-PROTECT*
;1  (PROGN*
;1   (COMW-INSPECT *ERROR-SG* *ERROR-OBJECT*)*
;1   (TV:DELAYING-SCREEN-MANAGEMENT*
;1    (WHEN (EQUAL (SEND *WINDOW-DEBUGGER* :CONFIGURATION) 'STEP-CONFIGURATION)*
;1      (SEND *WINDOW-DEBUGGER* :SET-CONFIGURATION 'DEBUGGER-CONFIGURATION))))*
;1  (PROGN (SEND *WINDOW-DEBUGGER* :SET-WHO-LINE-DOC-STRING-OVERIDE NIL)*
;1         (SEND *WINDOW-DEBUGGER* :HANDLE-PROMPT))))*
;1-------------------------------------------------------------------------------*
;1-------------------------------------------------------------------------------*

;1;; Modifications to the macroexpand command and additions of macroexpand*
;1;; to tools.*

;1-------------------------------------------------------------------------------*

;1;; Code for the modification of the macro-expand-expression (c-sh-m) command*
;1;; in ZMacs.*

;1; functionality is probably already in si pkg - it belongs there anyway.*
zwei:
(DEFUN 4zwei::map-with-args* (a-function over-a-list &rest other-arguments)
"2This function is much like mapcar only more useful.  It takes a function and a
 list to map the function over and an &Rest arguments feature.  It applies the
 function to each element in the list, with the element being the first argument 
 and any subsequent arguments being taken from the &Rest parameter. The value of 
 a call to this function is a list of values from this function call, one element 
 for each element in the source list.*"
  (LOOP for element in over-a-list
        collect (APPLY a-function element other-arguments)))

zwei:
(DEFUN 4zwei::expand-n-times* (form n)
"2Takes a form and a depth count.  It returns a new form, which has macros in
 form expanded to a depth of n.*"
  (IF (< n 1)
      form
      (IF (CONSP form)
	  (LET ((expanded-form (macroexpand-1 form)))
	       (IF (CONSP expanded-form)
		   (IF (EQUAL form expanded-form)
		       (map-with-args 'expand-n-times form n)
		       (map-with-args 'expand-n-times expanded-form (- n 1)))
		   form))
          form)))

zwei:
(defcom 4zwei::com-macro-expand-expression* 
"3Print macroexpansion of next s-expression or marked s-expression(s).
The result is printed on the screen with PPrint.
If a numeric arg is supplied then that number of macroexpansions is applied.*" ()
  (LET ((form (read-form-or-forms-from-buffer)))
    (AND (EQ form :nothing-found) (barf))
    (IF *numeric-arg-p*
	(PPRINT
	    (expand-n-times (macroexpand-1 form) (- *numeric-arg* 1)))
	(PPRINT (macroexpand-1 form))))
  dis-none)


;1-------------------------------------------------------------------------------*

;1;; Code for the implementation of a MacroExpand command in the Inspector.*

;1-------------------------------------------------------------------------------*

(DEFUN 4macroexpand-and-inspect-expression* (expr)
"2Is passed an expression which it macroexpands and then inspects.*"
  (DECLARE (SPECIAL frame))
  (UNWIND-PROTECT
      (LET ((value (macroexpand-1 expr)))
	   (SEND frame :look-at-this-object value))
    nil))

;1**************
;1 TAC 08-01-89 - moved these three to INSPECT.LISP*
;1(defun data-from-inspection-data (thing)*
;1  (or (send thing :Send-If-Handles :Middle-Button-Result)*
;1      (send thing :Send-If-Handles :Aux-Data)*
;1      (send thing :Data)*
;1  )*
;1)*

;1(defun maybe-data-from-inspection-data (thing)*
;1  (if (typep thing 'tv:inspection-data)*
;1      (data-from-inspection-data thing)*
;1      thing*
;1  )*
;1)*

;1(defun do-something-and-inspect (string action)*
;1"Takes a prompt string and a function argument.  It prompts the user with the*
;1 string, rewads in a value, perhaps with the mouse, and calls the function*
;1 with the value returned.*
;1"*
;1   (declare (special user history = inspectors frame))*
;1;   (send user :clear-screen)*
;1   (format user string)*
;1   (multiple-value-bind (value punt-p)*
;1       (inspect-get-value-from-user user history inspectors)*
;1     (or punt-p (funcall action value))*
;1   )*
;1   (send frame :handle-prompt)*
;1)*
;1-------------*

(DEFCOMMAND 4inspect-macroexpand-cmd* nil			
  '(:description "3MacroExpand and inspect something.*"
    :names ("3MacExp*")
    :keys (#\c-sh-m))
   (do-something-and-inspect "3~&Expression to macroexpand:*"
			     'macroexpand-and-inspect-expression))

;1-------------------------------------------------------------------------------*

;1;; Code for the Trace command in ZMacs.*

;1-------------------------------------------------------------------------------*

zwei:
(DEFUN 4zwei::just-trace-name* (name)
"2Given a name traces it without a menu.*"
  (si:eval-abort-trivial-errors
    (IF (ATOM name) `(TRACE (,name)) `(TRACE (:function ,name)))))

zwei:
(defcom 4zwei::com-just-trace* "3Trace a function without any menu.
Reads the name of the function from the mini-buffer (the top of the kill
ring has the 'current' function from the buffer) and then traces it.*" ()
  (LET ((fcn (read-function-name 
	       "3Trace*"
	       (relevant-function-name (point) nil t t t) t))
	(*print-case* :capitalize))
       (just-trace-name fcn)
       (FORMAT *query-io* "3Traced ~A.*" fcn))
  dis-none)

zwei:
(set-comtab *standard-comtab* nil
	    (make-command-alist '(com-just-trace)))

;1-------------------------------------------------------------------------------*

zwei:
(DEFUN 4zwei::untrace-name* (name)
"2Given a name untraces it without a menu.*"
  (si:eval-abort-trivial-errors
    (IF (ATOM name) `(UNTRACE ,name) `(UNTRACE ,name))))

zwei:
(defcom 4zwei::com-untrace* "3Untrace a function without any menu.
Reads the name of the function from the mini-buffer (the top of the kill
ring has the 'current' function from the buffer) and then untraces it.*" ()
  (LET ((fcn (read-function-name 
	       "3Untrace*"
	       (relevant-function-name (point) nil t t t) t))
	(*print-case* :capitalize))
       (untrace-name fcn)
       (FORMAT *query-io* "3Untraced ~A.*" fcn))
  dis-none)

zwei:
(set-comtab *standard-comtab* nil
	    (make-command-alist '(com-untrace)))

;1-------------------------------------------------------------------------------*

;1;; Code required to implement a Trace command in the Inspector.*

;1-------------------------------------------------------------------------------*

(DEFUN 4function-if-defined* (spec)
"2Nil if it is passed an invalid function spec or a spec for an undefined
 function, otherwise the function object for the spec.*"
  (IF (function-spec-p spec)
      (LET ((FUNCTION (IF (CONSP spec)
			  (FUNCALL (GET (FIRST spec) 'function-spec-handler)
			           'ticl:fdefinedp spec)
			  (IF (FBOUNDP spec) (SYMBOL-FUNCTION spec) nil))))
	   (COND ((EQUAL t function) (FDEFINITION spec))
		 ((AND (SYMBOLP function) (FBOUNDP function))
		  (SYMBOL-FUNCTION function))
		 ((OR (FUNCTIONP function) (CONSP function)) function)
		 (t nil)))
      (IF (FUNCTIONP spec)
	  spec
	  (IF (AND (FBOUNDP 'any-sort-of-clos-method-p)
		   (any-sort-of-clos-method-p spec))
	      (method-function-safe spec)
	      nil))))

(DEFUN 4get-real-inspect-thing* (thing)
  (IF (FBOUNDP 'map-into-show-x)
      (LET ((MAP (FUNCALL 'map-into-show-x thing)))
	   (IF map
	       map
	       (IF (TYPEP thing 'inspection-data)
		    (IF (NOT (SYMBOLP (SEND thing :send-if-handles :aux-data)))
			(SEND thing :aux-data)
			(SEND thing :data))
		    thing)))
      thing))


(DEFUN 4get-method-spec-if-instance* (FUNCTION prompter &aux message)
"2If it is passed an instance then it prompts for a message name to be clicked
 on and then returns a method spec for that method, otherwise it returns the
 function that it was passed.*"
  (AND (CLOSUREP function)
       (SETQ function (CAR (%make-pointer dtp-list function))))
  (COND ((AND (MEMBER (DATA-TYPE function)
		      '(dtp-entity dtp-instance dtp-select-method))
	      (TYPEP function 'inspection-data))
	 (get-real-inspect-thing function))
	((AND (FBOUNDP 'any-sort-of-clos-method-p)
	      (any-sort-of-clos-method-p function))
	 (method-function-safe function))
	((MEMBER (DATA-TYPE function)
		 '(dtp-entity dtp-instance dtp-select-method))
	 (SETQ message
	       (FUNCALL prompter
			"3~&Type or mouse a message name for ~S:~%*" function))
	 (LET ((handler (GET-HANDLER-FOR function message)))
	      (OR handler
		  (FORMAT t "3~&~S does not handle the ~S message.~%*"
			  function message))
	      (SETQ function handler)))
	(t function)))

(DEFUN 4trace-something* (thing prompter action)
"2Prompts the user for something to trace and traces it with a menu, just traces
 it or untraces it according to Action, which can be :Menu, :Just-Trace,
 :Untrace.*"
  (LET ((thing-to-trace
	    (get-method-spec-if-instance thing prompter)))
       (LET ((FUNCTION (IF (FUNCTIONP thing-to-trace)
			   thing-to-trace
			   (function-if-defined thing-to-trace))))
	    (IF function
		(LET ((name (FUNCTION-NAME function)))
		     (CASE action
		       (:menu
			(EVAL (trace-via-menus (FUNCTION-NAME function))))
		       (:just-trace (zwei::just-trace-name name))
		       (:untrace (zwei::untrace-name name))))
		(PROGN (BEEP)
		       (FORMAT t "3~S cannot be traced.*" thing))))))

(DEFUN 4read-value-from-user* (&rest format-args)
"2Is passed a set of format args.  It prompts the user in the Inspector user
interaction pane for something, using the format args as the prompt.*"
  (DECLARE (SPECIAL user history inspectors frame))
  (SEND user :clear-screen)
  (APPLY #'FORMAT user format-args)
  (inspect-get-value-from-user user history inspectors))

(DEFUN 4trace-command-body* (action string)
"2The body of all trace related commands for the inspector.*"
   (DECLARE (SPECIAL user history = inspectors frame))
   (SEND user :clear-screen)
   (FORMAT user "3~&Function to ~A:*" string)
   (MULTIPLE-VALUE-BIND (value punt-p)
       (inspect-get-value-from-user user history inspectors)
     (OR punt-p (trace-something value 'read-value-from-user action)))
   (SEND frame :handle-prompt))

(DEFCOMMAND 4trace-cmd* nil			
  '(:description "3Trace a function using trace menu.*"
    :names ("3Trace*")
    :keys (#\c-sh-t))
   (trace-command-body :menu "3trace with menus*"))



(DEFCOMMAND 4just-trace-cmd* nil			
  '(:description "3Trace a function without using trace menu.*"
    :names ("3Just Trace*")
    :keys (#\m-sh-t))
   (trace-command-body :just-trace "3trace*"))



(DEFCOMMAND 4untrace-cmd* nil			
  '(:description "3Untrace a function without using trace menu.*"
    :names ("3Untrace*")
    :keys (#\s-sh-t))
   (trace-command-body :untrace "3untrace*"))

;1-------------------------------------------------------------------------------*

;1;; Trace command in the window debugger.*

;1-------------------------------------------------------------------------------*

eh:
(DEFUN 4eh::window-read-thing-dont-eval* (prompt &rest format-args)
  (LETF ((#'eh::sg-eval-in-frame
	  #'(lambda (IGNORE thing &rest ignore) (LIST thing))))
	(APPLY 'eh::window-read-thing prompt format-args)))

eh:
(DEFUN 4eh::get-something-and-trace-it* (action string)
"2Gets something to trace from the user.*"
  (tv::trace-something
      (eh::window-read-function string)
      #'eh::window-read-thing
      action))

eh:
(DEFCOMMAND 4eh::comw-trace* ()
            '(:description "3Trace a function using trace menu.*"
              :names "3Trace*"
	      :keys (#\c-sh-t)) 
   (SEND *window-debugger* :set-who-line-doc-string-overide
	 "3Select something to trace using the trace menu.*")
   (UNWIND-PROTECT
       (get-something-and-trace-it :menu "3to trace using the trace menu*")
      (SEND *window-debugger* :set-who-line-doc-string-overide nil)
      (SEND *window-debugger* :handle-prompt)))

eh:
(DEFCOMMAND 4eh::comw-just-trace* ()
            '(:description "3Trace a function without using the trace menu.*"
              :names "3Just Trace*"
	      :keys (#\m-sh-t)) 
   (SEND *window-debugger* :set-who-line-doc-string-overide
	 "3Select something to trace without using the trace menu.*")
   (UNWIND-PROTECT (get-something-and-trace-it :just-trace "3to trace*")
      (SEND *window-debugger* :set-who-line-doc-string-overide nil)
      (SEND *window-debugger* :handle-prompt)))

eh:
(DEFCOMMAND 4eh::comw-untrace* ()
            '(:description "3Untrace a function without using the trace menu.*"
              :names "3Untrace*"
	      :keys (#\s-sh-t)) 
   (SEND *window-debugger* :set-who-line-doc-string-overide
	 "3Select something to untrace without using the trace menu.*")
   (UNWIND-PROTECT (get-something-and-trace-it :untrace "3to untrace*")
      (SEND *window-debugger* :set-who-line-doc-string-overide nil)
      (SEND *window-debugger* :handle-prompt)))

;1-------------------------------------------------------------------------------*

;1;; The Eval command.*

;1-------------------------------------------------------------------------------*

;1;; Code for the implementation of an Eval command in the Inspector.*

;1-------------------------------------------------------------------------------*

(DEFMETHOD 4(basic-inspect-frame :look-at-this-object*) (object)
"2Is passed something to inspect.  It puts it into the history window and
inspects it.*"
  (SEND self :inspect-object object))

(DEFUN 4eval-and-inspect-expression* (expr)
"2Is passed an expression which it Evals and then inspects.*"
  (DECLARE (SPECIAL frame))
  (UNWIND-PROTECT
      (LET ((value (EVAL expr)))
	   (SEND frame :look-at-this-object value))
    nil))

(DEFCOMMAND 4inspect-eval-cmd* nil			
  '(:description "3Eval and inspect something.*"
    :names ("3Eval*")
    :keys (#\c-sh-e))
   (do-something-and-inspect "3~&Expression to eval:*"
			     'eval-and-inspect-expression))

;1-------------------------------------------------------------------------------*

;1;; The compile command.*

;1-------------------------------------------------------------------------------*

;1;; Code for the implementation of a Compile command in the Inspector.*

;1-------------------------------------------------------------------------------*

(DEFUN 4inspect-compile* (something)
  (IF (FUNCTIONP something)
      (compile (FUNCTION-NAME something))
      (compiler:compile-form something)))

(DEFCOMMAND 4inspect-compile-cmd* nil			
  '(:description "3Compile something.*"
    :names ("3Compile*")
    :keys (#\c-sh-c))
   (do-something-and-inspect "3~&Expression to compile:*" 'inspect-compile))

;1-------------------------------------------------------------------------------*

;1;; The compile command in the window debugger.*

eh:
(DEFCOMMAND 4eh::comw-compile-cmd* nil
  '(:description "3Compile something.*"
    :names "3Compile*"
    :keys (#\c-sh-c))
   (SEND *window-debugger* :set-who-line-doc-string-overide
	 "3Select a something to compile.*")
   (UNWIND-PROTECT
       (tv::inspect-compile (eh::window-read-thing
			     "3~&Type or mouse something to compile.~%*"))
     (PROGN (SEND *window-debugger* :set-who-line-doc-string-overide nil)
	    (SEND *window-debugger* :handle-prompt))))

;1-------------------------------------------------------------------------------*

;1;; The arglist command.*

;1------------------------------------------------------------------------------*

;1;; Code required to implement an Arglist command in the inspector.*

;1-------------------------------------------------------------------------------*

(DEFUN 4inspect-arglist* (something)
"2Is passed something that the user wants the arglist for.  If it is a function
name or function object then it prints the arglist.*"
  (LET ((FUNCTION (function-if-defined something)))
       (IF (EQUAL nil function)
	   (PROGN (BEEP) (FORMAT t "3~S is not a function.*" something))
	   (zwei::print-arglist (FUNCTION-NAME function)))))

(DEFCOMMAND 4arglist-cmd* nil			
  '(:description "3Display arglist of a function.*"
    :names ("3Arglist*")
    :keys (#\c-sh-a))
   (do-something-and-inspect "3~&Function whose arglist is to be printed:*"
			     'inspect-arglist))

;1**************
;1 TAC 08-01-89 - moved arglist command code commented below to WINDOW-DEBUG.LISP*
;1;-------------------------------------------------------------------------------*

;1;;; The Arglist command in the window debugger.*

;1;;; Redefine the arglist command so that it will take c-sh-a as a key*
;1;;; assignment for compatibility with ZMacs.*

;1eh:*
;1(defcommand eh:Comw-Arglist-Cmd nil*
;1  '(:description "Display the argument list of a specified function."*
;1    :names "Arglist"*
;1    :keys (#\c-A #\c-sh-A)*
;1   )*
;1   (send *window-debugger* :set-who-line-doc-string-overide*
;	1 "Select a function to apply Arglist to."*
;1   )*
;1   (unwind-protect (comw-arglist *error-sg* *error-object*)*
;1     (progn (send *window-debugger* :set-who-line-doc-string-overide nil)*
;	1    (send *window-debugger* :handle-prompt)*
;1     )*
;1   )*
;1)*
;1-------------------------------------------------------------------------------*


;1-------------------------------------------------------------------------------*

;1;; The document command.*

;1-------------------------------------------------------------------------------*

;1(defparameter *documentors**
;1  (list*
;1    (list*
;1      #'(lambda (name) (or (functionp name t) (fdefinedp name)))*
;1      #'(lambda (name &aux doc)*
;	1  (multiple-value-bind (args return macro-p) (arglist name)*
;	1    (if (get name 'si::defstruct-slot)*
;		1(format t "~%~S is a defstruct accessor macro for ~s" name*
;			1(car (get name 'si::defstruct-slot)))*
;		1(format t "~%~s is a ~:[function~;macro~]" name macro-p))*
;	1    (format t "~%arguments  ~A~%" args)*
;	1    (when return*
;	1      (format t "returns  ~{~A  ~}~%" return)))*
;	1  (when (setq doc (documentation name))*
;	1    (format t "~A~%" doc))))*
;1    (list*
;1      #'(lambda (name) (get name 'si:flavor))*
;1      #'(lambda (name &aux doc)*
;	1  (let ((temp (get name 'si:flavor)))*
;	1    (format t "~%~s is a flavor~%" name)*
;	1    (when (and (setq temp (si:flavor-plist temp))*
;		1       (setq doc*
;			1     (second (member :documentation temp :test #'eq))))*
;	1      (format t "~a~%" doc)))))*
;1    (list*
;1      #'(lambda (name) (get name 'defresource))*
;1      #'(lambda (name) (format t "~%~s is the name of a resource." name))*
;1    )*
;1    (list*
;1      #'(lambda (name) (get name 'si::defstruct-description))*
;1      #'(lambda (name &aux doc)*
;	1  (let ((temp (get name 'si::defstruct-description)))*
;	1    (format t "~%~s is a structure~%" name)*
;	1    (when*
;	1      (and (setq temp (si::defstruct-description-property-alist temp))*
;		1   (setq doc (rest (assoc :documentation temp :test #'eq))))*
;	1      (format t "~a~%" doc)))))*
;1    (list*
;1      #'(lambda (name) (and (symbolp name) (boundp name)))*
;1      #'(lambda (name &aux temp)*
;	1  (if (get name 'compiler:system-constant) ;; may 7-11-88*
;	1      (format t "~%~s is a constant~%" name);; may 7-11-88*
;	1      (format t "~%~s is a variable~%" name))*
;	1  (if (consp (setq temp (symbol-value name)))*
;	1      (format t "Value is a ~A~%" (type-of temp))*
;	1      (format t "Value is ~s~%" temp))*
;	1  (format t "~@[~a~%~]"*
;		1  (getf (get name 'sys:documentation-property) 'variable))))*
;1    (list*
;1      #'(lambda (name) (get name 'eh::make-condition-function))*
;1      #'(lambda (name &aux doc)*
;	1  (let ((temp (get name 'eh::make-condition-function)))*
;	1    (format t "~%~S is an ~:[undocumented ~]error condition~%" name*
;		1    (setq doc (documentation temp)))*
;	1    (when doc*
;	1      (format t "~a~%" doc)))))*
;1    (list*
;1      #'(lambda (name)*
;	1  (and (find-package 'ticlos)*
;	1       (funcall (read-from-string "ticlos:class-named") name t)*
;	1       (documentation*
;		1 (funcall (read-from-string "ticlos:class-named") name)*
;	1       )*
;	1  )*
;	1)*
;1      #'(lambda (name)*
;	1  (format t "~&~S is the name of a CLOS class.~&~A"*
;		1  name*
;		1  (documentation*
;		1    (funcall (read-from-string "ticlos:class-named") name)*
;		1  ))))*
;1   )*
;1)*

;1(defun long-document (name stream)*
;1  (let ((*package* nil)*
;	1(docs nil))*
;1     (loop for (pred doc-fn) in *documentors**
;	1   when (funcall pred name)*
;	1   do (let ((str (with-output-to-string (*standard-output*)*
;			1   (funcall doc-fn name))))*
;		1   (push str docs)*
;		1   (princ str stream)))*
;1     (let ((temp (get name :documentation)))*
;1          (if (and temp (not (member temp docs :test #'equal)))*
;	1      (progn (format stream "~%~s is a ~a~%" name (type-of name))*
;		1     (format stream "~a~%" temp)))*
;	1  (if (and (not temp) (not docs))*
;	1      (format *query-io* "~&~s was not found." name)))))*

;1(Defun Long-Documentation (name)*
;1 (with-output-to-string (output-string)*
;1  (long-document name output-string)))*

;1zwei:*
;1(DEFCOM zwei:COM-LONG-DOCUMENTATION*
;1   "Print long documentation for the specified function.*
;1Reads the name of the function from the mini-buffer (the default is*
;1the \"current\" function from the buffer) and displays the*
;1function's arguments and documentation" () ;;by OREN/STENGER. Patched in by gsl*
;1   (LET ((NAME (READ-FUNCTION-NAME "Document" (RELEVANT-FUNCTION-NAME (POINT)) 'AARRAY-OK)))*
;1        ;;; JPR.*
;1        (princ (tv:long-documentation name))*
;	1dis-none))*

;1***************
;1 TAC 08-09-89 - MAY provided preferred implementation below.*
;1; COM-LONG-DOCUMENTATION redefined by patch 94.215.*
;1; may 01/20/89 Changed documentation string and 'structure test.*
;1; may 04/20/89 Allowed meta-sh-d to get at special compiler arglist/function documentation.*
zwei:
(defcom 4zwei::com-long-documentation * 
  "3Reads the name2 *from the mini-buffer or mouse (the default is the \"current\" function from the buffer) 
and displays the function's arguments,2 *whether it is a function, variable, flavor, structure, or condition, 
and its documentation2.**"  ;1; by OREN/STENGER. Patched in by gsl*
  ()
  (LET ((name (read-function-name "3Document*" (relevant-function-name (point)) 'aarray-ok))
        ;1; Bind package to nil to force it to print out*
        (*package* nil))
    (long-documentation name))
  dis-none) 

zwei:
(DEFUN 4zwei::long-documentation* (name &optional (STREAM t))
  "3Print long documentation for almost anything.*"
  (LET (doc temp)
    (COND-EVERY
      (;1; function*
       ;1; (fdefinedp '(:method tv:sheet :init)) => t *
       ;1; (functionp '(:method tv:sheet :init)) => nil*
       (OR (FUNCTIONP name t) (FDEFINEDP name) 	                ;1; may 7-11-88 added (fdefinedp name)*
	   ;1; for special compiler functions like: (ticlos:call-next-method) *	1;; may 04/20/89 *
	   (AND (SYMBOLP name) (DOCUMENTATION name))) 		;1; may 04/20/89 *
       (MULTIPLE-VALUE-BIND (args return macro-p) (ARGLIST name)
	 (IF ;1; (SETQ TEMP (GET NAME 'SI::DEFSTRUCT-SLOT)) *				1;; may 01/25/89 obsolete*
	   ;1; (FORMAT STREAM "~%~S is a defstruct accessor macro for ~s" NAME (CAR TEMP))   ;; may 01/25/89 sort of ...*
	   (AND (SETQ temp (si:function-parent name))				;1; may 01/25/89 *
		(GET temp 'si::defstruct-description)) 				;1; may 01/25/89 *
	   (FORMAT stream "3~%~S is a defstruct accessor function for ~s*" name temp) 	;1; may 01/25/89 *
	   (FORMAT stream "3~%~s is a ~:[function~;~:*~a~]*" name				;1; may 01/25/89 *
		   (AND macro-p (STRING-DOWNCASE macro-p)))) 				;1; may 01/25/89 macro/subst *
	 (FORMAT stream "3~%arguments  ~A~%*" args)
	 (WHEN return
	   (FORMAT stream "3returns  ~{~A  ~}~%*" return)))
       (WHEN (SETQ doc (DOCUMENTATION name))
	 (FORMAT stream "3~A~%*" doc)))
      (;1; flavor*
       (SETQ temp (GET name 'si::flavor))
       (FORMAT stream "3~%~s is a flavor~%*" name)
       (WHEN (AND (SETQ temp (si::flavor-plist temp))
		  (SETQ doc (SECOND (MEMBER :documentation temp :test #'EQ))))
	 (FORMAT stream "3~a~%*" doc)))
      (;1; class  - added class documentation - TAC 08-30-89*
       (SETQ temp (ticlos::class-named name))
       (FORMAT stream "3~%~s is a class~%*" name)
       (WHEN
	 (SETQ doc (DOCUMENTATION temp)) 				
	 (FORMAT stream "3~a~%*" doc)))
      (;1; structure*
       (SETQ temp (GET name 'si::defstruct-description))
       (FORMAT stream "3~%~s is a structure~%*" name)
       (WHEN
	 (SETQ doc (DOCUMENTATION name 'structure)) 				;1; may 01/25/89 *
	 (FORMAT stream "3~a~%*" doc)))
      (;1; other ...*
       (AND (SETQ temp (GET name :documentation)) (NEQ doc temp))
       (FORMAT stream "3~%~s is a ~a~%*" name (TYPE-OF name))
       (FORMAT stream "3~a~%*" temp))
      (;1; variable*
       (AND (SYMBOLP name) (BOUNDP name))
       (IF (GET name 'compiler:system-constant) ;1; may 7-11-88*
	   (FORMAT stream "3~%~s is a constant~%*" name);1; may 7-11-88*
	   (FORMAT stream "3~%~s is a variable~%*" name))
       (IF (CONSP (SETQ temp (SYMBOL-VALUE name)))
	   (FORMAT stream "3Value is a ~A~%*" (TYPE-OF temp))
	   (FORMAT stream "3Value is ~s~%*" temp))
       (FORMAT stream "3~@[~a~%~]*" (GETF (GET name 'sys::documentation-property) 'variable))) ;1; may 7-11-88*
      (;1; condition*
       (SETQ temp (GET name 'eh::make-condition-function))
       (FORMAT stream "3~%~S is an ~:[undocumented ~]error condition~%*" name
	       (SETQ doc (DOCUMENTATION temp)))
       (WHEN doc
	 (FORMAT stream "3~a~%*" doc)))
      (otherwise				;1(FORMAT *QUERY-IO* "~&~S was not found." NAME)*
       (FORMAT stream "3~&~S has no documentation.*" name)
       ))))

(DEFUN 4document-an-object* (thing window)
"2Given something it displays the documentation for it.*"
  (LET ((thing-to-document
	   (COND ((OR (SYMBOLP thing)
		      (AND (CONSP thing) (function-spec-p thing)))
		  thing)
		 ((FUNCTIONP thing) (FUNCTION-NAME thing))
		 ;1; TAC 08-30-89 - added recognition of flavors*
		 ((AND (NAMED-STRUCTURE-P thing) (TYPEP thing 'si::flavor))
		  (si::flavor-name thing))
		 ((ticlos::classp thing) ;1; TAC 08-30-89 - added class recognition*
		  (ticlos:class-name thing))
		 ((AND (OR (NAMED-STRUCTURE-P thing) (TYPEP thing 'instance))
		       (NOT (DOCUMENTATION thing))) ;1; TAC 08-30-89 rearranged order of 2 conditions of AND*
		  (TYPE-OF thing))
		 (t nil))))
	(IF thing-to-document
;1;  TAC 08-18-89 - zwei:long-documentation allows a stream to passed in. Use it in that manner.*
;	1    ;(LET ((docs (zwei:long-documentation thing-to-document)))*	1;; may 08/08/89 *
;		1 ;(IF (EQUAL docs "")*
;		1     ;(FORMAT t "has no documentation.")*
		     (si:with-help-stream
		       (window :label "3Documentation*" :superior window)
		       (zwei::long-documentation thing-to-document window)	;1))*
		       )
	    (PROGN (BEEP)
		   (FORMAT t "3is not documentable.*")))))

(DEFCOMMAND 4document-something-cmd* nil			
  '(:description "3Document something.*"
    :names ("3Docmnt*")
    :keys (#\m-sh-d #\c-sh-d))
   (DECLARE (SPECIAL frame))
   (do-something-and-inspect "3~&Object to show documentation for:*"
     #'(lambda (value) (document-an-object value frame))))


;1-------------------------------------------------------------------------------*

;1;; The Document command in the window debugger.*

;1-------------------------------------------------------------------------------*

eh:
(DEFUN 4eh::find-and-document-something* ()
"2Prompts the user for something to document and displays its doc string if it
 can.*"
  (tv::document-an-object
      (window-read-thing "3~&Type or mouse something to document:~%*")
      *window-debugger*))

eh:
(DEFCOMMAND 4eh::comw-debug-document-something* ()
  '(:description  "3Show documentation for something.*"
    :names "3Docmnt*"
    :keys (#\c-sh-d #\m-sh-d))
   (SEND *window-debugger* :set-who-line-doc-string-overide
	 "3Select something to document.*")
   (UNWIND-PROTECT (find-and-document-something)
      (SEND *window-debugger* :set-who-line-doc-string-overide nil)
      (SEND *window-debugger* :handle-prompt)))

;1-------------------------------------------------------------------------------*

;1 TAC 08-01-89 - moved all Help command code into INSPECT.LISP*
;1-------------------------------------------------------------------------------*

;1;; The Help command.*

;1-------------------------------------------------------------------------------*

;1(defun uniquise-commands (commands)*
;1  (if (and commands (rest commands))*
;1      (if (and (equalp (first  (first commands)) (first  (second commands)))*
;	1       (equalp (second (first commands)) (second (second commands)))*
;	1  )*
;	1  (uniquise-commands (rest commands))*
;	1  (cons (first commands) (uniquise-commands (rest commands)))*
;1      )*
;1      commands*
;1  )*
;1)*

;1(defun show-all-commands-for-frame (frame on-window)*
;1  (format on-window "~&The following commands are supported on top of the normal input editor commands.~%")*
;1  (let ((all-commands*
;	1  (mapcar #'(lambda (table)*
;		1      (mapcar #'(lambda (command)*
;				1  (append*
;				1    (firstn 2 (send command :parsed-edit-form))*
;				1    (list (send command :description)*
;					1  (if (string-equal*
;						1(send command :description)*
;						1(send command :documentation)*
;					1      )*
;					1      ""*
;					1      (send command :documentation)*
;					1  )*
;				1    )*
;				1  )*
;				1)*
;			1        (listarray*
;				1  (send (symbol-value table) :commands)*
;				1)*
;		1      )*
;		1    )*
;		1    (uniqueise (send frame :all-command-tables))*
;	1  )*
;	1)*
;1       )*
;1       (let ((sorted (sortcar (apply #'append all-commands) #'string-lessp)))*
;	1    (mapcar #'(lambda (list)*
;			1(apply #'format on-window "~&~A~25T~A~48T~A ~A" list))*
;		1    (uniquise-commands sorted)*
;	1    )*
;1       )*
;1  )*
;1)*


;1(Defcommand Documentation-Cmd nil*		
;1  '(:description *
;1    "Display some brief documentation about each of the Inspector's panes."*
;1    :names ("Help")*
;1    :keys (#\c-HELP #\m-HELP)*
;1   )*
;1   (declare (special frame))*
;1   (si:with-help-stream (window :label "Documentation for Inspector"*
;				1:superior frame*
;			1)*
;1     (format window*
;1"*
;1  -----------------------------------------------------------------------------------*
;1                    *** Optional Third Inspection Pane ****

;1    Displays previously inspected item.*

;1 ------------------------------------------------------------------------------------*
;1                    *** Optional Second Inspection Pane ****

;1    Displays previously inspected item.*

;1 ------------------------------------------------------------------------------------ *
;1                        *** Main Inspection Pane ****

;1    This pane displays the structure of the most recently inspected item.*
;1    Specify objects to inspect by*

;1      1) Entering them into the Interaction Pane or,*
;1      2) Clicking left on the mouse sensitive elements of previously inspected items.*

;1    Right click on items here tries to inspect the item's function definition.*


;1 ------------------------------------------------------------------------------------*
;1   * Command * |                  *** History Pane ****
;1   *  Menu   * |*
;1               |    This pane displays a list of the objects that have been*
;1     For UCL   |  inspected.  To bring an object back into the Main Inspection*
;1     command   |  pane click left on it in this pane.*
;1     display   |*
;1      press    |    To remove an item from the history, click middle in the item's*
;1      HYPER-   |  line area (the area just left of the item where the mouse cursor*
;1     CONTROL-  |  becomes a right pointing arrow).*
;1      HELP.    |*
;1 ------------------------------------------------------------------------------------*
;1                           *** Interaction Pane *** *

;1      Enter items to inspect in this pane.  This pane may also be used for command*
;1    name typein and for Lisp typein.  For Lisp typein use the Mode command.*

;1      The last three inspected objects are stored in *, ** and ***.*
 
;1 ------------------------------------------------------------------------------------*
;1  ")*
;1     (show-all-commands-for-frame frame window)))*

;1 (reinstall-inspector-commands)  ; TAC 08-01-89 dont need this since code above moved *

;1**************
;1 TAC 08-01-89 - moved window-debugger-help and window-debugger-help-cmd to WINDOW-DEBUG.LISP*
;1-------------------------------------------------------------------------------*
;1;; The window debugger Help command.  This used to be the document command.*
;1-------------------------------------------------------------------------------*

;1eh:*
;1(DEFUN WINDOW-DEBUGGER-HELP (&OPTIONAL IGNORE IGNORE)*
;1  (declare (special *window-debugger*))*
;1  (SI:WITH-HELP-STREAM (WINDOW :LABEL*
;1                               "Help for Window-based debugger"*
;1                               :SUPERIOR*
;1                               tv:default-screen)          ;!*
;1    (FORMAT WINDOW "*
;1                                 WINDOW-BASED DEBUGGER HELP*

;1----------------------------------------------------------------------------------------------*
;1                                   *** INSPECTION PANE ****

;1     This pane displays the structure of the most recently inspected item.  By default*
;1     the item inspected here is the selected stack frame.  To inspect other items here, *
;1     use the Inspect command or click Mouse-Left on them in this pane or *
;1     in the Inspection History Pane.*

;1----------------------------------------------------------------------------------------------*
;1             *** ARGS PANE ***                 |             *** LOCALS PANE ****
;1                                               |*
;1     This pane displays the argument           |     This pane displays the local variable*
;1     values for the currently selected         |     values and the special variable values*
;1     frame if there are any.  Otherwise,       |     for the currently selected frame if*
;1     this pane is gray.                        |     there are any.  Otherwise, this pane*
;1                                               |     is gray.*
;1                                               |*
;1----------------------------------------------------------------------------------------------*
;1                                      *** STACK PANE ****

;1     This pane displays the execution stack that contained the error.  The contents of the *
;1     above three panes are determined by the frame that is selected.  The selected frame is*
;1     the frame in this pane with the small arrow pointing to it.*

;1     To select another frame to see its args\/locals\/specials\/code use the up\/down*
;1     commands or move the mouse cursor to where you want the new arrow to be.  Then click *
;1     Mouse-Left when the cursor changes back to the small arrow.*

;1----------------------------------------------------------------------------------------------*
;1*** MENU PANE ***    |                   *** INSPECTION HISTORY PANE ****
;1                     |*
;1Click Mouse-Left     |     This pane maintains a history of objects that have appeared *
;1to select a          |     in the Inspection Pane.  To see these objects in the Inspection*
;1command.             |     Pane again, click Mouse-Left on them here.*
;1                     |*
;1----------------------------------------------------------------------------------------------*
;1                                    *** INTERACTION PANE ****

;1This pane is used to output messages and to evaluate Lisp forms.  Clicking Mouse-Left on*
;1mouse-sensitive items within the Args, Locals, or Stack panes will print them out here and*
;1will set * to these items.*

;1----------------------------------------------------------------------------------------------*



;1 ")*
;1    (tv:show-all-commands-for-frame *window-debugger* window)))*


;1eh:*
;1(defcommand eh:Window-Debugger-Help-Cmd ()*
;1            '(:description "Show documentation for each of the panes."*
;			1    :names "Help"*
;			1    :keys (#\c-help #\m-help)*
;	1     )*
;1             (window-debugger-help *error-sg* *error-object*)*
;1)*
;1-------------------------------------------------------------------------------*


;1********************************************************************************
;1 TAC 08-01-89 - moved code delimited by **** into INSPECT.LISP*


;1-------------------------------------------------------------------------------*
;1;; The flavor inspect command.*
;1-------------------------------------------------------------------------------*

;1;; For Zmacs*

;1zwei:*
;1(defun zwei:safe-inspect-flavor (object)*
;1"Inspects an object but just beeps if it is not inspectable."*
;1  (let ((flavor (cond ((or (instancep object) (typep object 'si:flavor))*
;		1       object*
;		1      )*
;		1      ((symbolp object)*
;		1       (get object 'si:flavor)*
;		1      )*
;		1      (t nil)*
;		1)*
;	1)*
;1       )*
;1       (if flavor*
;	1   (Process-Run-Function "Flavor Inspector" 'inspect-flavor flavor)*
;1           (progn (beep)*
;		1  (format *query-io* "~S is not a flavor." object)*
;	1   )*
;1       )*
;1  )*
;1)*

;1zwei:*
;1(defcom zwei:com-flavor-inspect "Call the flavor inspector on something." ()*
;1  (let ((flavor (read-function-name "Flavor Inspect"*
;				1    (relevant-function-name (point) nil t t t) t*
;	1        )*
;	1)*
;	1(*print-case* :Capitalize)*
;1       )*
;1       (safe-inspect-flavor flavor)*
;1  )*
;1  dis-none*
;1)*

;1zwei:*
;1(set-comtab *standard-comtab* nil*
;	1    (make-command-alist '(com-flavor-inspect))*
;1)*
;1;-------------------------------------------------------------------------------*

;1;;; For the inspector.*

;1(defcommand Flavor-Inspect-Cmd nil*			
;1  '(:description "Flavor Inspect a Flavor or Method."*
;1    :names ("FlavIns")*
;1    :keys (#\c-sh-f #\m-sh-f #\h-F)*
;1   )*
;1   (declare (special user history = inspectors frame))*
;1   (send user :clear-screen)*
;1   (if (fboundp 'inspect-flavor) *
;1       (progn*
;	1 (format user "~&Object to Flavor Inspect:")*
;	1 (multiple-value-bind (value punt-p)*
;	1     (inspect-get-value-from-user user history inspectors)*
;	1   (or punt-p*
;	1       (zwei:safe-inspect-flavor value)))*
;	1 (send frame :handle-prompt))*
;1       (progn*
;	1 (if (y-or-n-p "The Flavor Inspector is not currently loaded. Do you wish to load it?")*
;	1     (progn*
;	1       (load "sys:debug-tools;flavor-inspector")   *
;	1       (send user :clear-screen)*
;	1       (format user "~&Object to Flavor Inspect:")*
;	1       (multiple-value-bind (value punt-p)*
;		1   (inspect-get-value-from-user user history inspectors)*
;		1 (OR PUNT-P*
;		1     (zwei:safe-inspect-flavor value)))*
;	1       (send frame :handle-prompt))))))*

;	1     )*
;	1 )*
;1       )*
;1   )*
;1)*

;1;-------------------------------------------------------------------------------*

;1;;; For the window debugger.*

;1eh:*
;1(Defcommand eh:Flavor-Inspect-Cmd nil*			
;1  '(:description "Flavor Inspect a Flavor or Method."*
;1    :names ("FlavIns")*
;1    :keys (#\c-sh-f #\m-sh-f #\h-F)*
;1   )*
;1   (zwei:safe-inspect-flavor (window-read-thing "~&Object to Flavor Inspect:"))*
;1)*
;1;-------------------------------------------------------------------------------*
;1********************************************************************************


;1^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^*
;1 TAC 08-01-89 - this section of code used to define edit command that is*
;1                consistent in editor, inspector, and debugger.*
;1                code is delimited by ^^^^^^^^^^^*
;1-------------------------------------------------------------------------------*
;1;; The edit command.*
;1-------------------------------------------------------------------------------*
;1 For Zmacs - Just add a new key assignment.*

zwei:
(set-comtab *standard-comtab* '(#\h-e com-edit-definition)
	                       (make-command-alist '(com-edit-definition)))

;1-------------------------------------------------------------------------------*
;1 For the inspector - adds new edit capability, including CLOS objects*

(DEFUN 4make-ununspecific* (path)
"2Takes a path and makes sure that it has an specific type.*"
  (OR (AND (NOT (EQUAL :unspecific (SEND path :type)))
	   path)
      (LET ((new-path (MAKE-PATHNAME :defaults path
				     :type :lisp
				     :version :newest)))
	   new-path)))

(DEFUN 4pathname-could-be-editted* (path)
"2Is true if the pathname represents something that could reasonably be editted.
 This means that it has a name and type.*"
  (LET ((name (SEND path :name))
        (type (SEND path :type)))
       (AND name
	    type
	    (OR (AND (NOT (EQUAL :unspecific type))
		     (PROBE-FILE path))
		(LET ((new-path (MAKE-PATHNAME :defaults path
					       :type :lisp
					       :version :newest)))
		     (AND (PROBE-FILE new-path)
			  (Y-OR-N-P "3Try and edit Lisp file: \"~A\"*"
				    (SEND new-path :string-for-printing))))))))

(DEFUN 4edit-a-path* (path)
"2Given a pathname edits the file for it.  If the version of the path is
 :UnSpecific then it edits the :Newest*"
  (ED (IF (EQUAL :unspecific (SEND path :version))
	  (SEND path :new-version :newest)
	  path)))

(DEFUN 4try-and-edit-flavor-of-object* (object)
"2Given an instance it tries to edit the source file of the type of the instance.*"
  (COND ((AND (FBOUNDP 'class-p-safe) (class-p-safe object))
	 (try-and-edit (class-name-safe object)))
	((AND (FBOUNDP 'any-sort-of-clos-method-p)
	      (any-sort-of-clos-method-p object))
	 (try-and-edit (method-function-safe object)))
	(t (TYPECASE object
	     (si::flavor  (try-and-edit (si::flavor-name  object)))
	     (otherwise
	       (IF (GET (TYPE-OF object) :source-file-name)
		   (ED (TYPE-OF object))
		   (PROGN (BEEP)
			  (FORMAT *query-io*
				  "3~&No source file can be found for ~S*"
				  object))))))))

(DEFUN 4try-and-edit-object* (object)
"2Is passed an instance or a defstruct instance and tries to edit it in the most
 intelligent way possible.  If the thing responds to the :Pathname message then
 it tries to edit the file defined by the path.  If it fails to do this then
 it tries to edit the source file of the type of the thing.*"
  (IF (IF (TYPEP object 'instance)
	  (SEND object :operation-handled-p :pathname)
	  (MEMBER 'PATHNAME (SEND object :which-operations) :test #'EQ)
          ;1;; Can't use :Operation-Handled-P because most defstructs do not support it*
      )
      (LET ((path (SEND object :pathname)))
	   (IF (AND (TYPEP path 'PATHNAME)
		    (pathname-could-be-editted path)
		    (PROBE-FILE path))
	       (edit-a-path path)
	       (try-and-edit-flavor-of-object object)))
      (try-and-edit-flavor-of-object object)))

(DEFUN 4try-and-edit-string* (STRING)
"2Given a string it tries to edit a file which the string denotes.  If it fails
 to find such a file then it beeps and tells you why it failed to edit it.*"
  (LET ((path (fs:parse-pathname string nil nil 0 nil t)))
       (IF path
	   (IF (pathname-could-be-editted path)
	       (IF (PROBE-FILE path)
		   (edit-a-path path)
		   (PROGN (BEEP)
			  (FORMAT *query-io* "3~&File not found for ~S*" string)))
	       (PROGN (BEEP)
		      (FORMAT *query-io*
			     "3~&~S cannot be coerced into an edittable pathname*"
			     string)))
	   (PROGN (BEEP)
		  (FORMAT *query-io* "3~&~S cannot be coerced into a pathname*"
			  string)))))

(DEFUN 4remove-internals* (name)
"2Extracts a function name from any closure specs.
 Thus (:internal (:internal foo 0) 123) -> foo.*"
  (IF (AND (CONSP name) (EQUAL (FIRST name) :internal))
      (remove-internals (SECOND name))
      name))

#-clos
(DEFUN 4try-and-edit* (object)
"2Takes any object and edits its definition if it can find a meaningful definition  
to edit.  For instance if it is passed a named structure then it edits the defstruct 
definition for that type.  If it fails to edit the object it beeps and tells you what 
it was that it failed to edit a definition of.*"
  (COND ((AND (TYPEP object 'symbol)
	      (OR (GET object :source-file-name)
		  (GET object 'zwei:zmacs-buffers)))
	 (ED object))
	((AND (TYPEP object 'PATHNAME)
	      (pathname-could-be-editted object))
	 (edit-a-path (make-ununspecific object)))
	((AND (FUNCTIONP object)
	      (OR (si:function-spec-get
		    (remove-internals (FUNCTION-NAME object))
		    :source-file-name)
		  (si:function-spec-get
		    (remove-internals (FUNCTION-NAME object))
		    'zwei:zmacs-buffers)))
	 (ED (FUNCTION-NAME object)))
	((AND (OR (NAMED-STRUCTURE-P object) (TYPEP object 'instance)))
	 (try-and-edit-object object))
	((AND (CONSP object) (function-spec-p object)
	      (OR (si:function-spec-get object :source-file-name)
		  (si:function-spec-get object 'zwei:zmacs-buffers)))
	 (ED object))
	((AND (CONSP object) (MEMBER (FIRST object) '(FUNCTION quote)))
	 (try-and-edit (SECOND object)))
        ((TYPEP object 'STRING) (try-and-edit-string object))
	(t (BEEP)
	   (FORMAT *query-io* "3~&Cannot find a definition to edit for ~S*"
		   object))))

#+clos
ticlos:
(defgeneric 4tv::edit* (something)
  (:documentation "3Takes any object and edits its definition if it can find a
meaningful definition to edit.  For instance, if it is passed a named structure 
then it edits the defstruct definition for that type.  If it fails to edit the 
object it beeps and tells you what it was that it failed to edit a definition of.*"))

#+clos
(DEFMETHOD 4edit* ((me t))
  (IF (NAMED-STRUCTURE-P me)
      (try-and-edit-object me)
      (PROGN (BEEP)
	     (FORMAT *query-io* "3~&Cannot find a definition to edit for ~S*"
		     me))))

#+clos
(DEFMETHOD 4edit* ((me symbol))
  (IF (OR (GET me :source-file-name)
	  (GET me 'zwei::zmacs-buffers))
      (ED me)
      (ticlos:call-next-method)))

#+clos
(DEFMETHOD 4edit* ((me pathname))
  (IF (pathname-could-be-editted me)
      (edit-a-path (make-ununspecific me))
      (ticlos:call-next-method)))

#+clos
(DEFMETHOD 4edit* ((me compiled-function))
  (IF (OR (si:function-spec-get
	     (remove-internals (FUNCTION-NAME me))
	     :source-file-name)
	   (si:function-spec-get
	     (remove-internals (FUNCTION-NAME me))
	     'zwei::zmacs-buffers))
      (ED (FUNCTION-NAME me))
      (ticlos:call-next-method)))

#+clos
(DEFMETHOD 4edit* ((me ticlos:generic-function))
  (edit (clos:generic-function-name me)))

(DEFUN 4menu-of-methods* (object)
  (w:menu-choose (MAPCAR #'(lambda (method)
			     (LET ((method-spec 
				     (FUNCTION-NAME
				       (method-function-safe
					 method))))
				  (LIST (FORMAT nil "3~s*" method-spec)
					:value
					method-spec)))
			   (generic-function-methods-safe
			     (function-generic-function-safe
			       (SYMBOL-FUNCTION object))))
		 :label
		 (FORMAT nil "3~s is a generic function.  Edit which method?*"
			 object)))

#+clos
;1 TAC 08-17-89 - removing PCL support*
;1(DEFMETHOD edit ((me lexical-closure))*
;1  (LET ((fef (FIRST (si:convert-closure-to-list me))))*
;1       (IF (AND (FBOUNDP 'pcl-p) (pcl-p) (fef-of-gf-p me)) ;;; Allow for PCL.*
;	1   (LET ((choice (menu-of-methods (generic-function-name-safe me))))*
;		1(IF choice*
;		1    (edit choice)*
;		1    (BEEP)))*
;	1   (edit fef))))*

;1 TAC 09-04-89 - substituting (si::closure-function me) for (FIRST (si:convert-closure-to-list me))*
;1                      David Gray's preferred way to handle closure*
;1(DEFMETHOD edit ((me lexical-closure))*
;1  (LET ((fef (FIRST (si:convert-closure-to-list me))))*
;1    (edit fef)))*

(DEFMETHOD 4edit* ((me lexical-closure))
  (LET ((fef (si::closure-function me)))
    (edit fef)))

#+clos
(DEFMETHOD 4edit* ((me cons))
  (IF (AND (function-spec-p me)
	   (OR (si:function-spec-get me :source-file-name)
	       (si:function-spec-get me 'zwei::zmacs-buffers)))
      (ED me)
      (IF (MEMBER (FIRST me) '(FUNCTION quote))
	  (edit (SECOND me))
	  (ticlos:call-next-method))))

#+clos
(DEFMETHOD 4edit* ((me string))
  (try-and-edit-string me))

#+clos
(DEFMETHOD 4edit* ((me array))
  (IF (NAMED-STRUCTURE-P me)
      (try-and-edit-object me)
      (ticlos:call-next-method)))

#+clos
(DEFMETHOD 4edit* ((me si:vanilla-flavor))
  (try-and-edit-object me))

#+clos
(DEFMETHOD 4edit* ((me clos:standard-class))
  (try-and-edit-object me))

#+clos
(DEFMETHOD 4edit* ((me ticlos:flavor-class))
  (try-and-edit-object me))

#+clos
(DEFMETHOD 4edit* ((me ticlos:method))
  (edit (ticlos:method-function me)))

#+clos
(DEFMETHOD 4edit* ((me inspection-data))
  (try-and-edit-object (SEND me :middle-button-result)))

#+clos
(DEFUN 4try-and-edit* (object)
"2Takes any object and edits its definition if it can find a meaningful definition 
to edit.  For instance, if it is passed a named structure then it edits the defstruct 
definition for that type.  If it fails to edit the object it beeps and tells you what 
it was that it failed to edit a definition of.*"
  (edit object))

;1;; Just compile this so that M-. works ok.*
#+clos
(ticlos:prepare-generic-function #'edit)
;1-------------------------------------------------------------------------------*

;1;; Extensions for reading in things to edit.*

(DEFUN 4try-in-all-packages* (action symbols &rest args)
"2Performs Action to all of the symbols in Symbols &rest args, within a
 catch error.  If there is no error and a non null result from the action then
 this is returned.*"
  (IF symbols
      (LET ((result (CATCH-ERROR (APPLY action (FIRST symbols) args) nil)))
	   (IF result
	       result
	       (try-in-all-packages action (REST symbols))))
      nil))

(DEFUN 4try-to-find-function-spec-for-type* (spec type)
"2Given a spec of the form [eg] (foo :after :bar) and a type of the form [eg]
 :Method or :Property, try to find a function spec of the form
 (:method foo :after :bar), where foo is tried in all reasonable packages.*"
  (IF (SYMBOLP (FIRST spec))
      (APPLY 'try-in-all-packages
	#'(lambda (symbol &rest args)
	    (LET ((fspec (CONS type (CONS symbol args))))
	         (IF (FDEFINITION-LOCATION fspec)
		     fspec
		     nil)))
	(zwei::package-lookalike-symbols (SYMBOL-NAME (FIRST spec)))
	(REST spec))
      nil))

(DEFPARAMETER 4*function-spec-first-symbols** '(:method :property)
"2A list of all of the keywords which can start a function spec.*")

(DEFUN 4try-to-find-function-spec* (spec symbols)
"2Given a function spec of the form [eg] (foo :after :bar) and a list of type
 symbols of the form (:Method or :Property), try to find a function spec of
 the form (:method foo :after :bar), where foo is tried in all reasonable
 packages.*"
  (IF (EQUAL nil symbols)
      nil
      (LET ((result (try-to-find-function-spec-for-type spec (FIRST symbols))))
	   (IF result
	       result
	       (try-to-find-function-spec-for-type spec (REST symbols))))))

(DEFUN 4something-to-edit-error-handler* (condition)
"2An error handler for the try to edit operation.  If it finds an unbound symbol
 then this is returned, since it might be the name of a function.  If it finds
 a (:method... type spec then it returns this (this would have resulted in an
 undefined function error for :Method.  If it finds a list of the form
 (foo bar baz) then it tries to dwimify a bit looking for a method of plist
 function of that name.*"
  (DECLARE (SPECIAL *form-read*))
  (COND ((AND (CONDITION-TYPEP condition 'sys:unbound-variable)
	      (SYMBOLP *form-read*))
	 (THROW :error? :proceed-with-this))
	((CONDITION-TYPEP condition 'sys:undefined-function)
	 (IF (MEMBER (FIRST *form-read*) '(:method :property))
	     (THROW :error? :proceed-with-this)
	     (THROW :error? :try-dwimifying)))
	(t (BEEP) nil))
  (VALUES))
  
(DEFUN 4read-and-record-a-form* (FUNCTION)
"2Reads a form using function, which may prompt, and setqs the form to a special
 which is read outside the function.  The form is then evaled.  Errors which
 happen during the read or the eval will be caught.*"
  (DECLARE (SPECIAL *form-read*))
  (SETQ *form-read* (FUNCALL function))
  (EVAL *form-read*))

(DEFUN 4try-to-read-something-to-edit* (FUNCTION)
"2Is passed a function, such as #'read (which may prompt the user) and reads
 in something which might be interpretable as something to edit.  It catches
 sundry errors in order to try to do the Right Thing.  Thus if you type
 (foo :bar) then it will try to look for functions and methods of this name,
 and if it finds one will return it.*"
  (LET ((*form-read* nil))
       (DECLARE (SPECIAL *form-read* *function-spec-first-symbols*))
       (LET ((result
	       (CATCH :error?
		 (CONDITION-BIND-IF t
		   (((sys:unbound-variable sys:undefined-function)
		     'something-to-edit-error-handler))
		   (read-and-record-a-form function)))))
	    (CASE result
	      (:proceed-with-this *form-read*)
	      (:try-dwimifying
	       (IF (CONSP *form-read*)
		   (IF (EQUAL (FIRST *form-read*) 'FUNCTION)
		       *form-read*
		       ;1;; Could be a method/prop spec.*
		       (try-to-find-function-spec
			 *form-read* *function-spec-first-symbols*))
		   nil))
	      (otherwise *form-read*)))))

(DEFUN 4abort-handler* (&rest ignore)
  (THROW :abort-tag nil))

(DEFUN 4read-something-to-edit* (FUNCTION message-function)
  (LET ((result (try-to-read-something-to-edit function)))
       (IF (AND (TYPEP result 'si:vanilla-flavor)
	        (OR (NOT (FBOUNDP 'any-sort-of-clos-instance-p))
		    (NOT (any-sort-of-clos-instance-p result))))
	   (LET ((message
		   (CATCH :abort-tag
		     (CONDITION-BIND
		       (((sys:abort) #'abort-handler))
		       (try-to-read-something-to-edit message-function)))))
	        (IF message
		    (LET ((handler (GET-HANDLER-FOR result message)))
			 (IF handler
			     handler
			     (PROGN
			      (BEEP)
			      (FORMAT t "3~&~S does not handle the ~S message.~%*"
				      result message)
			      result)))
		    result))
	   result)))

;1---------------------------------------------------------------------------------*
;1 TAC 08-15-89 - advice moved to WINDOW-DEBUG.LISP*
;1eh:*
;1(LET ((compiler:compile-encapsulations-flag t))*
;1     (ADVISE eh:window-read-thing :around :make-sure-not-inspection-data*
;	1     nil*
;1       (LET ((results (MULTIPLE-VALUE-LIST :do-it)))*
;	1    (IF (TYPEP (FIRST results) 'tv:inspection-data)*
;		1(VALUES-LIST (CONS (OR (SEND (FIRST results) :send-if-handles*
;					1     :middle-button-result)*
;				1       (SEND (FIRST results) :send-if-handles*
;					1     :aux-data)*
;				1       (SEND (FIRST results) :data))*
;				1   (REST results)))*
;		1(VALUES-LIST results)))))*

;1----------------------------------------------------------------------------------*

;1---------------------------------------------------------------------------------*
;1 TAC 08-15-89 - incorporated into function below *
;1eh:*
;1(LET ((compiler:compile-encapsulations-flag t))*
;1     (ADVISE tv:my-window-read-thing :around :make-sure-not-inspection-data*
;	1     nil*
;1       (LET ((results (MULTIPLE-VALUE-LIST :do-it)))*
;	1    (IF (TYPEP (FIRST results) 'tv:inspection-data)*
;		1(VALUES-LIST (CONS (OR (SEND (FIRST results) :send-if-handles*
;					1     :middle-button-result)*
;				1       (SEND (FIRST results) :send-if-handles*
;					1     :aux-data)*
;				1       (SEND (FIRST results) :data))*
;				1   (REST results)))*
;		1(VALUES-LIST results)))))*
;1---------------------------------------------------------------------------------*

(DEFUN 4my-window-read-thing* (prompt &rest format-args)
  "2A modified version of eh:window-read-thing.  This allows the reading of things
 for editting.*"
  (LET ((results 
	  (MULTIPLE-VALUE-LIST
	    ;1; --- original body of code represented by :do-it in advice commented above ---*
	    (LET (SPECIAL thing)
	      (APPLY (FUNCTION format) t prompt format-args)
	      (MULTIPLE-VALUE-SETQ (SPECIAL thing) (eh::window-command-loop-read))
	      (SETQ thing (IF special
			      (IF (SEND eh::*window-debugger* :inspect-window-p (THIRD special))
				  (inspect-real-value special)
				  (CASE (FIRST special)
				    (:menu  (EQ (SEND (FOURTH special) :execute (SECOND special)) t))
				    (stack-frame  (eh::list-stack-frame-function-and-args eh:*error-sg*
										      (SECOND special)))
				    (:line-area  (eh::list-stack-frame-function-and-args eh:*error-sg*
										     (SECOND special)))
				    ((SPECIAL arg local)  (FIRST (SECOND special)))
				    ((:value :function special)  (SECOND special))))
			      thing))		;1.. take frame into consideration*
	      (IF (NULL thing) (FORMAT t "3~&Aborted.~%*"))
	      thing))))
              ;1; ---------------------------------------------------------------------*
    (IF (TYPEP (FIRST results) 'inspection-data)
	(VALUES-LIST (CONS (OR (SEND (FIRST results) :send-if-handles
				     :middle-button-result)
			       (SEND (FIRST results) :send-if-handles
				     :aux-data)
			       (SEND (FIRST results) :data))
			   (REST results)))
	(VALUES-LIST results))))

(DEFUN 4inspect-get-value-from-user* (*terminal-io* history inspectors)	
  "2Get a value either by the mouse pointing at it or by read and eval on *TERMINAL-IO*.*"
  (DECLARE (SPECIAL frame))
  (UNWIND-PROTECT (BLOCK 
                   nil
                   (DOLIST (i inspectors)
                     (SEND i :set-setting-mode t))
                   (SEND history :set-setting-mode t)
                   (FORMAT *terminal-io* "3~%(type a form to be evaled or select with mouse)~%*")
                   (LET ((thing (w:read-any *terminal-io*))
                         error)
                     (COND
                       ((CONSP thing);1; Choose somthing with the mouse -- display it truncated and proceed*
                        
                        (COND
                          ((EQ (FIRST thing) :menu) (BEEP)
                           (FORMAT *terminal-io* "3~&Cannot select a menu item.~%Aborted.~%*")
                           (RETURN nil t))
                          ((EQ (FIRST thing) :mouse-button) (BEEP)
                           (FORMAT *terminal-io* "3~&Did not select anything.~%Aborted.~%*")
                           (RETURN nil t))
                          ((CHAR-EQUAL (FOURTH thing) #\Mouse-3-1)
			    (FORMAT *terminal-io* "3~&Aborted.~%*")
			    (RETURN nil t)))
                        (LET ((*print-level* 3)
                              (*print-length* 5))
			  ;1; JPR. - new functionality*
			  (SETQ thing (inspect-real-value thing))
			  (SETQ thing (maybe-data-from-inspection-data thing))
                          (PRIN1 thing *terminal-io*)))
                       (t (w:unread-any thing *terminal-io*)
                        (MULTIPLE-VALUE-SETQ (thing error)
                          (CATCH-ERROR
                           (EVAL (LET ((*standard-input* *terminal-io*))
                                   (READ-FOR-TOP-LEVEL)))))
                        (WHEN error;1; Failed to eval, punt*
                          (BEEP)
                          (FORMAT *terminal-io* "3~&Aborted.~%*")
                          (RETURN nil t))))
                     (TERPRI *terminal-io*)
                     (RETURN thing)) nil)
                  (DOLIST (i inspectors)
     (SEND i :set-setting-mode nil))
    (SEND history :set-setting-mode nil)))


(DEFUN 4my-inspect-get-value-from-user* (*terminal-io* history inspectors)	
  "2Get a value either by the mouse pointing at it or by read and eval on *TERMINAL-IO*.  
   Modified from Inspect-Get-Value-from-User, so as to read things for editting.*"
  (DECLARE (SPECIAL frame))
  (UNWIND-PROTECT (BLOCK 
                   nil
                   (DOLIST (i inspectors)
                     (SEND i :set-setting-mode t))
                   (SEND history :set-setting-mode t)
                   (FORMAT *terminal-io* "3~%(type a form to be evaled or select with mouse)~%*")
                   (LET ((thing (w:read-any *terminal-io*))
                         error)
                     (COND
                       ((CONSP thing);1; Choose somthing with the mouse -- display it truncated and proceed*
                        
                        (COND
                          ((EQ (FIRST thing) :menu) (BEEP)
                           (FORMAT *terminal-io* "3~&Cannot select a menu item.~%Aborted.~%*")
                           (RETURN nil t))
                          ((EQ (FIRST thing) :mouse-button) (BEEP)
                           (FORMAT *terminal-io* "3~&Did not select anything.~%Aborted.~%*")
                           (RETURN nil t))
                          ((CHAR-EQUAL (FOURTH thing) #\Mouse-3-1)
			    (FORMAT *terminal-io* "3~&Aborted.~%*")
			    (RETURN nil t)))
                        (LET ((*print-level* 3)
                              (*print-length* 5))
			  ;1; JPR - new functionality *
			  (SETQ thing (inspect-real-value thing))
			  (SETQ thing (maybe-data-from-inspection-data thing))
                          (PRIN1 thing *terminal-io*)))
                       (t (w:unread-any thing *terminal-io*)
                        (MULTIPLE-VALUE-SETQ (thing error)
                          (CATCH-ERROR
                           (LET ((*standard-input* *terminal-io*))
			            ;1; JPR - new functionality *
                                   (try-to-read-something-to-edit
				     'READ-FOR-TOP-LEVEL))))
                        (WHEN error ;1; Failed to eval, punt*
                          (BEEP)
                          (FORMAT *terminal-io* "3~&Aborted.~%*")
                          (RETURN nil t))))
                     (TERPRI *terminal-io*)
                     (RETURN thing)) nil)
                  (DOLIST (i inspectors)
     (SEND i :set-setting-mode nil))
    (SEND history :set-setting-mode nil)))

;1-------------------------------------------------------------------------------*

(DEFUN 4inspect-try-and-edit* (something)
  (DECLARE (SPECIAL user history = inspectors frame))
  (IF (AND (TYPEP something 'si:vanilla-flavor)
	   (OR (NOT (FBOUNDP 'any-sort-of-clos-instance-p))
	       (NOT (any-sort-of-clos-instance-p something))))
      (IF (AND (BOUNDP '*general-inspector-enabled*)
	       (SYMBOL-VALUE '*general-inspector-enabled*)
	       (TYPEP something 'inspection-data))
	  ;1; Hook for general inspector.*
	  (IF (FUNCALL 'map-into-show-x something)
	      (try-and-edit (FUNCALL 'map-into-show-x something))
	      (try-and-edit (SEND something :send-if-handles :data)))
	  (LET ((message
		  (CATCH :abort-tag
		    (CONDITION-BIND
		      (((sys:abort) #'abort-handler))
		      (FORMAT user 
	     "3~&Select a method name [*3] for flavor definition:*")
		      (MULTIPLE-VALUE-BIND (value punt-p)
			  (inspect-get-value-from-user user history inspectors)
			(IF punt-p
			    (THROW :abort-tag nil)
			    value))))))
	       (IF message
		   (LET ((handler (GET-HANDLER-FOR something message)))
			(IF handler
			    (try-and-edit handler)
			    (PROGN
			      (BEEP)
			      (FORMAT t "3~&~S does not handle the ~S message.~%*"
				      something message)
			      (try-and-edit something))))
		   (try-and-edit something))))
      (try-and-edit something)))

(DEFCOMMAND 4inspect-edit-cmd* nil			
  '(:description "3Edit the definition of something.*"
    :names ("3Edit*")
    :keys (#\m-. #\c-e #\h-e))
   (LETF ((#'inspect-get-value-from-user #'my-inspect-get-value-from-user))
	 (do-something-and-inspect "3~&Object to edit definition of:*"
				   'inspect-try-and-edit)))
;1^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^*


;1****************
;1 TAC 08-01-89 - redefines code originally in window-debug*
;1-------------------------------------------------------------------------------*
;1 For the window debugger.*
;1-------------------------------------------------------------------------------*
;1;; Redefine the edit command so that it will take m-. as a key assignment for *
;1;; compatibility with ZMacs. Just add new key assignments.*

eh:
(DEFUN 4eh::comw-edit* (IGNORE ignore)
"2This is a redefined version of the debugger's edit command.  It uses the
 consistency enhancements mechanism for finding the source file to edit.*"
  (LET ((thing (tv::read-something-to-edit
		 #'(lambda ()
		     (tv::my-window-read-thing
		       "3~%Type or mouse on something to edit: *" t))
		 #'(lambda ()
		     (tv::my-window-read-thing
      "3~%Type or mouse on a message name [*3] for flavor definition : *" t)))))
     (tv::try-and-edit thing)))

eh:
(DEFCOMMAND 4eh::comw-edit-cmd* nil
  '(:description  "3Invoke the Editor on a specified function.*"
    :names "3Edit*" 
    :keys (#\m-. #\c-e #\h-e))
  (SEND *window-debugger* :set-who-line-doc-string-overide
	"3Select a function to edit.*")
  (UNWIND-PROTECT (comw-edit *error-sg* *error-object*)
    (PROGN (SEND *window-debugger* :set-who-line-doc-string-overide nil)
	   (SEND *window-debugger* :handle-prompt))))
;1----------------------------------------------------------------------*


;1-------------------------------------------------------------------------------*
;1; TAC 07-25-89 - I commented this out - it is not clear how the user supplies *
;1; any of the options (:never :query t nil) for documenting standard generic functions.*
;1; Casey worked with me on this and the normal documenting of standard generic functions*
;1; will work with the general inspector.  *

;1#+CLOS*
;1(defvar ticlos:*display-method-docs-for-generic-functions-p* nil*
;1"When t, causes the doc strings for methods of a generic function to be*
;1 printed when (documentation is called on a GF.  If this is :query then*
;1 the user is asked before the method docs are shown.  If it is :never, then*
;1 the method docs are never shown, even when the GF has no docs.*
;1"*
;1)*

;1#+CLOS*
;1ticlos:*
;1(defmethod ticlos:documentation ((dobj ticlos:standard-generic-function) &optional doc-type)*
;1  (when doc-type*
;1    (error "~%A second argument, ~s, was supplied in a call to DOCUMENTATION *
;1of a generic function object.~%" doc-type))*
;1  (let ((doc-string (if (compiled-function-p dobj)*
;			1(let ((dbi (si:get-debug-info-struct dobj)))*
;			1  (si:get-debug-info-field dbi :documentation))*
;			1(ticlos:generic-function-documentation dobj))))*
;1    (case *display-method-docs-for-generic-functions-p**
;1      (nil (or doc-string*
;	1       (apply #'string-append*
;		1      (mapcar 'get-method-doc (generic-function-methods dobj))*
;	1       )*
;	1   )*
;1      )*
;1      (:never doc-string)*
;1      (:query (if (y-or-n-p "~&Show doc strings for methods of ~S?" dobj)*
;		1  (apply #'string-append*
;			1 doc-string*
;			1 (mapcar 'get-method-doc*
;				1 (generic-function-methods dobj)*
;			1 )*
;		1  )*
;		1  doc-string*
;	1      )*
;1      )*
;1      (t (apply #'string-append*
;		1doc-string*
;		1(mapcar 'get-method-doc (generic-function-methods dobj))*
;	1 )*
;1      )*
;1    )*
;1  )*
;1)*

;1#+CLOS*
;1ticlos:*
;1(defun ticlos:get-method-doc (method)*
;1  (let ((doc (documentation method)))*
;1       (if doc*
;	1   (format nil "~%From ~A:~%~A~%"*
;		1   (function-name (method-function method)) doc*
;	1   )*
;	1   ""*
;1       )*
;1  )*
;1)*
;1-------------------------------------------------------------------------------*

;1;; W A R N I N G.....*
;1;; The following puts a pathname dependency into this file.*
;1;; This should really be done by a conditional load in the defsystem,*
;1;; but Defsystem doesn't have such things....   JPR. 28 Feb 89.*

;1 TAC 07-25-89 - this causes problems so I removed it*
;1(if (eq sys:(processor-type microcode-type-code) :micro-Explorer)*
;1    (si:load-if "TOOLS:TOOLS;DTCE-MICROEXPLORER-SPECIFIC" :verbose nil)*
;1    (si:load-if "TOOLS:TOOLS;DTCE-EXPLORER-SPECIFIC" :verbose nil)*
;1)*

;1(provide 'Development-Tool-Consistency-Enhancements)*


;1;; Code to install the commands...*

;1-------------------------------------------------------------------------------*

;1;; Commands to add, Command Menus, and Command Installation*

;1-------------------------------------------------------------------------------*

;1**************
;1 TAC 08-08-89 - changing constant to a parameter because later on grapher setqs it.*
;1(defconstant *all-consistancy-commands**

(DEFPARAMETER 4*all-consistancy-commands**
	      '(("3Inspect*" :value
		 (((#\c-sh-i zwei::com-inspect-region)
		   (#\m-sh-i zwei::com-inspect-region))
		  nil
		  nil))
		("3Eval*" :value
		 (nil
		   ((inspect-eval-cmd t))
		   nil))
		("3MacroExpand*" :value
		 (nil
		   ((inspect-macroexpand-cmd t))
		   nil))
		("3Compile*" :value
		 (nil
		   ((inspect-compile-cmd t))
		   ((eh::comw-compile-cmd t))))
		("3Save Region*" :value
		 (nil
		   ((save-region-cmd nil))
		   ((eh::comw-save-region nil))))
		("3ISearch*" :value
		 (nil
		   ((search-cmd nil))
		   ((eh::comw-isearch nil))))
		("3Reverse ISearch*" :value
		 (nil
		   ((reverse-search-cmd nil))
		   ((eh::comw-reverse-isearch nil))))
		("3Arglist*" :value
		 (nil
		   ((arglist-cmd t))
		   ((eh::comw-arglist-cmd t))))
		("3Trace*" :value
		 (((#\s-sh-t zwei::com-untrace)
		   (#\m-sh-t zwei::com-just-trace)
		   (#\c-sh-t zwei::com-trace))
		  ((trace-cmd t)
		   (just-trace-cmd nil)
		   (untrace-cmd nil))
		  ((eh::comw-trace t)
		   (eh::comw-just-trace nil)
		   (eh::comw-untrace nil))))
		("3Document*" :value
		 (nil
		   ((document-something-cmd t)
		    (documentation-cmd t))
		   ((eh::comw-debug-document-something t)
		    (eh::window-debugger-help-cmd t))))
		("3Flavor Inspect*" :value
		 (((#\c-sh-f zwei::com-flavor-inspect)
		   (#\m-sh-f zwei::com-flavor-inspect)
		   (#\h-f    zwei::com-flavor-inspect))
		  nil
		  ((eh::flavor-inspect-cmd t)))))
  
  "2This is a list of the commands which can be added to the system.  
 The structure of this list is as follows :
 It is made of items.  Each item is a list of the form (Menustring :Value spec). The spec 
 is used to determine which commands for which tools is represented  by the menu item. 
 The spec is a list of the form (zmacs-commands inspector-commands debugger-commands)
 Each element of zmacs-commands has the form (key command-name).  Each element of
 inspector-commands and debugger-commands has the form (command-name put-in-frames-menu-p).*")

(DEFVAR 4*selected-consistancy-commands** :all
"2Can have the value :All, in which case all consistancy commands are loaded,
 :Menu in which case the user is prompted, or a list of commands to load.*")

(DEFUN 4install-consistency-commands* ()
"2Installs all of the commands necessary to induce consistency in the system
 that the user wants.*"
  (select-and-install-commands *all-consistancy-commands*
			       *selected-consistancy-commands*))

(DEFUN 4convert-to-non-menu-item* (item)
"2Given a menu item which might generate a menuable command, this one returns
 a command which will certainly not appear in the frame's command menu.*"
  (APPEND (LIST (FIRST item) (SECOND item))
	  (LIST
	  (CONS (FIRST (THIRD item))
		(MAPCAR #'(lambda (component)
			    (MAPCAR #'(lambda (element)
					(LIST (FIRST element) nil))
				      component))
			  (REST (THIRD item)))))))

(DEFUN 4convert-to-column-list* (LIST)
"2Given a list of items to put in the menu of commands, this turns it into
 a list of menu items suitable to be in two columns, one for commands to go
 into the frame's command menu and one which is not.*"
  (APPEND '(("3Put in Menu*" :noselect nil :font fonts:hl12b))
	  '(("3Don't put in Menu*" :noselect nil :font fonts:hl12b))
	  (APPLY #'APPEND
		 (MAPCAR #'LIST list (MAPCAR 'convert-to-non-menu-item list)))))

(DEFUN 4install-zmacs-commmand* (command)
"2Installs a zmacs command.*"
  (zwei::set-comtab zwei::*standard-comtab* command
		   (zwei::make-command-alist (REST command))))

(DEFUN 4reinstall-inspector-commands* ()
"2Reinstalls all inspector commands just in case they have changed.*"
  (BUILD-COMMAND-TABLE
    'inspector-menu-cmd-table
    'inspect-frame inspector-menu-cmds :init-options	
    '(:name "3Inspector menu commands*"))
  (BUILD-COMMAND-TABLE
    'inspector-other-cmd-table
    'inspect-frame inspector-non-menu-cmds :init-options	
    '(:name "3Other Inspector commands*"))
  (BUILD-MENU 'ucl-inspector-menu 'inspect-frame
    :default-item-options `(:font ,inspect-standard-font)	
    :item-list-order inspector-menu-cmds))

(DEFUN 4install-inspector-command* (command)
"2Installs an inspector command.*"
  (LET ((command-name (FIRST command))
	(menu-p (SECOND command)))
       (IF menu-p
	   (IF (MEMBER command-name inspector-menu-cmds)
	       nil
	       (PROGN (SETQ inspector-menu-cmds
			    (CONS command-name inspector-menu-cmds))
		      (reinstall-inspector-commands)))
	   (IF (MEMBER command-name inspector-non-menu-cmds)
	       nil
	       (PROGN (SETQ inspector-non-menu-cmds
			    (CONS command-name inspector-non-menu-cmds))
		      (reinstall-inspector-commands))))))

eh:
(DEFPARAMETER 4eh::*debugger-examine-menu-commands**
  '(comw-inspect-cmd
    window-debugger-help-cmd 
    comw-edit-cmd
    comw-search-cmd
    bug-report-cmd
    comw-what-error-cmd 
    comw-arglist-cmd
    stay-cmd
    comw-set-arg-cmd
   )
"2The commands for the window debugger extracted from the source code where they
 are a literal constant (groan).*")


eh:
(DEFPARAMETER 4eh::*debugger-general-commands**
  '(comw-what-error-cmd
    comw-arglist-cmd
    comw-exit-cmd
    comw-inspect-cmd 
    com-top-level-throw-cmd
    comw-edit-cmd
    window-debugger-help-cmd 
    clear-screen-cmd
    bug-report-cmd
    all-commands-menu-cmd
   )
"2The commands for the window debugger extracted from the source code where they
 are a literal constant (groan).*")

eh:
(DEFPARAMETER 4eh::*window-debugger-all-commands-menu-commands**
   '((comw-what-error-cmd :column "3General*")
     (comw-arglist-cmd :column "3General*") 
     (comw-exit-cmd :column "3General*")
     (comw-inspect-cmd :column "3General*") 
     (com-top-level-throw-cmd :column "3General*")
     (comw-edit-cmd :column "3General*") 
     (window-debugger-help-cmd :column "3General*")
     (clear-screen-cmd :column "3General*")
     (bug-report-cmd :column "3General*")
     (comw-search-cmd :column "3Stack*") 
     (up-stack-cmd :column "3Stack*")
     (down-stack-cmd :column "3Stack*") 
     (page-up-stack-cmd :column "3Stack*")
     (page-down-stack-cmd :column "3Stack*") 
     (top-stack-cmd :column "3Stack*")
     (bottom-stack-cmd :column "3Stack*") 
     (step-cmd :column "3Step*")
     (com-toggle-trap-on-call-cmd :column "3Step*") 
     (com-toggle-frame-trap-on-exit-cmd :column "3Step*") 
     (com-set-all-frames-trap-on-exit-cmd :column "3Step*") 
     (com-clear-all-frames-trap-on-exit-cmd :column "3Step*") 
     (com-toggle-all-frames-trap-on-exit-cmd :column "3Step*") 
     (toggle-config-cmd :column "3Step*") (stay-cmd :column "3Step*") 
     (com-return-reinvocation-cmd :column "3Resume*") 
     (comw-set-arg-cmd :column "3Resume*")
     (com-return-a-value-cmd :column "3Resume*") 
     (com-proceed-cmd :column "3Resume*")
     (com-throw-cmd :column "3Resume*"))
"2The commands for the window debugger extracted from the source code where they
 are a literal constant (groan).*")

(DEFUN 4reinstall-debugger-commands* ()
"2Reinstalls all debugger commands just in case they have changed.*"
  (BUILD-COMMAND-TABLE 'window-debugger-general-cmd-table
		       'debugger-frame
    eh::*debugger-general-commands*
    :init-options
    '(:name "3General window-based debugger commands*"))
  (BUILD-MENU 'ucl-window-debugger-examine-menu
	      'debugger-frame
    :default-item-options '(:font fonts:cptfont)
    :item-list-order
    (CONS '("3Examine*" :font fonts:hl10b)
	  eh::*debugger-examine-menu-commands*))
  (BUILD-MENU '*window-debugger-all-commands-menu*
	      'debugger-frame
    :item-list-order eh::*window-debugger-all-commands-menu-commands*
    :column-list-order
    '(("3General*" :font fonts:hl12b)
      ("3Stack*" :font fonts:hl12b) 
      ("3Step*" :font fonts:hl12b)
      ("3Resume*" :font fonts:hl12b))))

(DEFUN 4install-debugger-command* (command)
"2Installs a new debugger command.*"
  (LET ((command-name (FIRST command))
	(menu-p (SECOND command)))
       (IF menu-p
	   (IF (MEMBER command-name eh::*debugger-examine-menu-commands*)
	       nil
	       (PROGN (SETQ eh::*debugger-examine-menu-commands*
			    (CONS command-name
				  eh::*debugger-examine-menu-commands*))
		      (reinstall-debugger-commands))))
       (IF (MEMBER command-name eh::*debugger-general-commands*)
	   nil
	   (PROGN (SETQ eh::*debugger-general-commands*
			(CONS command-name eh::*debugger-general-commands*))
		  (reinstall-debugger-commands)))
       (LET ((general-command-spec (LIST command-name :column "3General*")))
	    (IF (MEMBER general-command-spec
			eh::*window-debugger-all-commands-menu-commands*)
		nil
		(PROGN (SETQ eh::*window-debugger-all-commands-menu-commands*
			 (APPEND eh::*window-debugger-all-commands-menu-commands*
				 (LIST general-command-spec)))
		       (reinstall-debugger-commands))))))

(DEFUN 4install-command* (command-spec)
"2Given a command spec from the menu of commands to install, install the commands
 in all of the tools that are interested in them.*"
  (LET ((zmacs-component     (FIRST  command-spec))
	(inspector-component (SECOND command-spec))
	(debugger-component  (THIRD  command-spec))
       )
       (MAPCAR 'install-zmacs-commmand    zmacs-component)
       (MAPCAR 'install-inspector-command inspector-component)
       (MAPCAR 'install-debugger-command  debugger-component)))

(DEFUN 4select-and-install-commands* (commands switch)
"2Is passed a list of all of the commands that can be added and a switch
 which tells the system what commands to add.  This switch can have the values
 :Menu, :All or it can be a list of items.  Each item can be an element from
 Commands, a subitem from Commands (the bit following the :Value) or a string
 denoting the name of one of the menu items.*" 
  (LET ((selected-items
	  (IF (EQUAL switch :menu)
	      (w:menu-choose (convert-to-column-list commands)
			     :highlighting t
			     :highlighted-items nil
			     :near-mode '(:mouse)
			     :label "3Select commands*"
			     :menu-margin-choices '(:doit)
			     :geometry '(2)
			     :superior mouse-sheet)
	      (IF (EQUAL switch :all)
		  (MAPCAR #'THIRD commands)
		  (MAPCAR #'(lambda (command)
			      (IF (CONSP command)
				  (IF (STRINGP (FIRST command))
				      (THIRD command)
				      command)
				  (IF (STRINGP command)
				      (LET ((entry (ASSOC command commands
							  :test #'STRING-EQUAL)))
					   (IF entry
					       (THIRD entry)
					       (FERROR nil
						       "3~S is not a defined command to add.*" command)))
				      (FERROR nil "3~S is not a valid command specifier.*" command))))
			    (IF (CONSP switch)
				switch
				(FERROR nil "3~S is not :Menu :All or a list of commands*" switch))))))
	) ;1; all of the code above determines the value of selected-items*
       (MAPCAR 'install-command selected-items)))
;1-------------------------------------------------------------------------------*

(reinstall-inspector-commands) 

(install-consistency-commands)  



