;;; -*- Mode:Common-Lisp; Package:TV; Base:10; Fonts:(CPTFONT HL10B HL12BI HL12B CPTFONTB); Patch-File: T -*-

;1;;                     RESTRICTED RIGHTS LEGEND          *
;1;; Use, duplication, or disclosure by the Government is subject to*
;1;; restrictions as set forth in subdivision (b)(3)(ii) of the Rights in*
;1;; Technical Data and Computer Software clause at 52.227-7013.*
;1;;                   TEXAS INSTRUMENTS INCORPORATED.*
;1;;                            P.O. BOX 149149*
;1;;                         AUSTIN, TEXAS 78714-9149*
;1;;                             MS 2151*
;1;; Copyright (C) 1986,1987, 1988, 1989 Texas Instruments Incorporated. All rights reserved.*

;-------------------------------------------------------------------------------
;;; This file written by James Rice of the Stanford University
;;; Knowledge Systems Laboratory (Rice@Sumex-Aim.Stanford.Edu)
;;; Some of this code was written by modifying existing
;;; code belonging to TI.

;;; In this file there are a lot of functions called foo-Safe.  This is
;;; a bit of a strange name, that exists for historical reasons.  Maybe I'll
;;; change them all sometime.  Anyway the reason that they are "SAFE" is not
;;; that they won't barf horribly if you give them the wrong args or something
;;; goes wrong, but rather that foo-safe should work and do the right thing
;;; whether it is given a TICLOS thing or a PCL thing.  This is crucial to
;;; my intent of supporting both TICLOS and PCL in the Inspector.

;1;;   NOT SUPPORTING PCL, but need the safety checks that these macros provide. TAC 08-17-89*
;-------------------------------------------------------------------------------

;1**************
;1 TAC 07-26-89 - defstruct-safe was defined in Structure-Enhancements which*
;1                      redefined 2 kernel functions radically enough that a decision*
;1                      NOT to use it was made. Instead, map defstruct-safe back to *
;1                      original DEFSTRUCT with (DEFF defstruct-safe 'DEFSTRUCT).*

(DEFF 4defstruct-safe* 'DEFSTRUCT)

;1****************
;1 TAC 08-16-89 - this is from Structure-Enhancements - it gives an error message for*
;1                        structures instead of returning nil.*

(DEFUN 4general-structure-message-handler* (message-name thing-to-deal-with &Rest other-arguments)
  "2This is a general message handler for named structures.  It handles two
 messages: The first of these is :Which-Operations, which takes takes no
 arguments.  This message handler replies '(:Which-Operations :Print-Self) to
 this.  The second message that it responds to is :Print-Self.  This message
 takes three arguments; the stream to which the object is to be printed, the
 indentation depth and a slashification flag.  It uses the system's default
 named structure printer called si:print-named-structure to do this.  If it is
 sent a message other than these then an error is caused.  this is unlike the
 default behaviour, which causes nil to be returned.*"
  (IF (EQUAL message-name :Print-Self)
      (LET ((STREAM (FIRST other-arguments))
	    (print-depth (SECOND other-arguments))
	    (slashify (THIRD other-arguments)))
	(IGNORE slashify print-depth)
	(si::print-named-structure (NAMED-STRUCTURE-P thing-to-deal-with)
				  thing-to-deal-with
				  print-depth
				  stream
				  (si::which-operations-for-print stream)))
      (IF (EQUAL message-name :Which-Operations)
	  '(:Which-Operations :Print-Self)
	  (FERROR "3Illegal message sent to structure.*"))))

(IMPORT 'General-Structure-Message-Handler 'TICL)
(EXPORT 'General-Structure-Message-Handler 'TICL)

;1-------------------------------------------------------------------------------*
;1;; Just define a dummy package if CLOS is not loaded.  This should mean*
;1;; that these patches can be loaded onto a system which does not have CLOS loaded.*

;1;;  *** from Rice message Mods to TI-ENV-INSP.-INTERF. 8 Jun 1989 13:56:40 PDT*
;1;; !!!!!!!!!!!!!!! Note that the following three forms should be in this order.*

;1 TAC 08-17-89 - removing PCL support *
;1(EVAL-WHEN (COMPILE load)*
;1  (LET ((si:inhibit-fdefine-warnings t))*
;1       (IF (FIND-PACKAGE 'ticlos)*
;	1   nil*
;	1   (DEFPACKAGE ticl (:use lisp ticl)))*
;1       (IF (NOT (sys:find-system-named 'pcl t t))*
;	1   (DEFPACKAGE pcl (:use lisp))*
;	1   nil)))*

;(EVAL-WHEN (COMPILE load)
;  (LET ((si:inhibit-fdefine-warnings t))
;       (IF (FIND-PACKAGE 'ticlos)
;	   nil
;	   (DEFPACKAGE ticl (:use lisp ticl)))
;       ))

;1; * TAC 08-28-891 - as per David Gray, better definition for ticlos-p, considering our environment *
;(DEFUN 4ticlos-p* ()
;"2True if TICLOS is loaded.*"
;  (MEMBER :clos *features*))

(DEFF-MACRO TICLOS-P #'TRUE)

;1 TAC 08-17-89 - removing PCL support *
;1(DEFUN pcl-p ()*
;1"True if PCL is loaded."*
;1  ;;; Both of these are kludges.*
;1  (OR (MEMBER :portable-commonloops *features*)*
;1      (FBOUNDP 'pcl:defmethod)))*

;1-------------------------------------------------------------------------------*

;1 TAC 08-17-89 - removing PCL support *
;1(DEFUN clos-p ()*
;1"True if some sort of CLOS is loaded."*
;1  (OR (ticlos-p) (pcl-p)))*

(DEFUN 4clos-p* ()
"2True if TICLOS is loaded.*"
  (ticlos-p))

;1; Warning this is very system dependent !!!!!!!! JPR.*
(DEFUN 4ticlos-instance-p* (instance)
"2This should return T if Instance is an instance of a TICLOS class.
 Whenever a TICLOS class is instantiated it has a cdr code bit set, which
 distinguishes it from flavors instances.  This is sometimes not the case,
 however, for standard methods and such like, which are flavor class instances
 for some reason.*"
  (AND (INSTANCEP instance)
           ;1; definitely.*
       (OR (TICLOS:CLOS-INSTANCE-P instance)
	   ;1; Somewhat kludgy, but standard classes seem not to have the above property.*
	   (AND (SYMBOLP (TYPE-OF instance))
		(OR (MEMBER (TYPE-OF instance)
			    '(ticlos:standard-writer-method
			      ticlos:standard-reader-method
			      ticlos::combined-method))
		    (NOT (TYPEP (CLOS:CLASS-OF instance) 'ticlos:flavor-class)))))))

;1 TAC 08-17-89 - removing PCL support and redefining defsafe macro *
;1(DEFMACRO defsafe*
;1      (fname (discriminator &rest args) &key (DOCUMENTATION nil)*
;1       (pcl nil) (ticlos nil) (error-p t) (declarations nil))*
;1"Defines a function called FName, which should execute PCL if Discriminator*
;1 is a PCL thing or TICLOS if it is a TICLOS instance.  If Error-p is true*
;1 and Discriminator is neither a PCL or TICLOS thing then it generates an error*
;1 otherwise it returns nil."*
;1  `(DEFUN ,fname (,discriminator ,@args)*
;1     ,documentation*
;1     ,declarations*
;1     (IF (AND (pcl-p) (iwmc-class-p-safe ,discriminator))*
;	1,(IF pcl*
;	1     pcl*
;	1     (IF error-p '(FERROR nil "Don't know how to do this.") nil))*
;	1 (IF (AND (ticlos-p) (ticlos-instance-p ,discriminator))*
;	1    ,(IF ticlos*
;		1 ticlos*
;		1 (IF error-p '(FERROR nil "Don't know how to do this.") nil))*
;	1    ,(IF error-p*
;		1`(FERROR nil "Something wrong with ~S." ,discriminator)*
;		1 nil)))))*

(DEFMACRO 4defsafe*
      (fname (discriminator &rest args) &key (DOCUMENTATION nil)
        (ticlos nil) (error-p t) (declarations nil))
"2Defines a function called FName, which should execute TICLOS if it is a TICLOS instance.  
 If Error-p is true and Discriminator is not TICLOS thing then it generates an error
 otherwise it returns nil.*"
  `(DEFUN ,fname (,discriminator ,@args)
     ,documentation
     ,declarations
	 (IF (AND (ticlos-p) (ticlos-instance-p ,discriminator))
	    ,(IF ticlos
		 ticlos
		 (IF error-p '(FERROR nil "3Don't know how to do this.*") nil))
	    ,(IF error-p
		`(FERROR nil "3Something wrong with ~S.*" ,discriminator)
		 nil))))

;1 TAC 08-17-89 - removing PCL support and redefining defsafe-gf macro *
;1(DEFMACRO defsafe-gf*
;1      (fname (discriminator &rest args) &key (DOCUMENTATION nil)*
;1       (pcl nil) (ticlos nil) (error-p t) (declarations nil))*
;1"Defines a function called FName, which should execute PCL if Discriminator*
;1 is a PCL GF or TICLOS if it is a TICLOS GF.  If Error-p is true*
;1 and Discriminator is neither a PCL or TICLOS thing then it generates an error*
;1 otherwise it returns nil."*
;1  `(DEFUN ,fname (,discriminator ,@args)*
;1     ,documentation*
;1     ,declarations*
;1     (IF (AND (pcl-p) (pcl:generic-function-p ,discriminator))*
;	1,(IF pcl*
;	1     pcl*
;	1     (IF error-p '(FERROR nil "Don't know how to do this.") nil))*
;	1 (IF (AND (ticlos-p) (ticlos:generic-function-p ,discriminator))*
;	1    ,(IF ticlos*
;		1 ticlos*
;		1 (IF error-p '(FERROR nil "Don't know how to do this.") nil))*
;	1    ,(IF error-p*
;		1`(FERROR nil "Something wrong with ~S." ,discriminator)*
;		1 nil)))))*

(DEFMACRO 4defsafe-gf*
	  (fname (discriminator &rest args) &key (DOCUMENTATION nil)
	   (ticlos nil) (error-p t) (declarations nil))
  "2Defines a function called FName, which should execute TICLOS if it is a TICLOS GF.  
 If Error-p is true and Discriminator is not a TICLOS thing then it generates an error
 otherwise it returns nil.*"
  `(DEFUN ,fname (,discriminator ,@args)
     ,documentation
     ,declarations
     (IF (AND (ticlos-p) (ticlos::generic-function-p ,discriminator))
	 ,(IF ticlos
	      ticlos
	      (IF error-p '(FERROR nil "3Don't know how to do this.*") nil))
	 ,(IF error-p
	      `(FERROR nil "3Something wrong with ~S.*" ,discriminator)
	      nil))))

;1 TAC 08-17-89 - removing PCL support and redefining defsafe-simple macro *
;1(DEFMACRO defsafe-simple*
;1     (fname (discriminator &rest args)*
;1      &key (DOCUMENTATION nil) (both nil) (pcl nil) (ticlos nil) (error-p t)*
;1      (declarations nil))*
;1"Defines a function called FName, which should execute*
;1 (PCL:PCL discriminator ,@args) if Discriminator*
;1 is a PCL thing or (TICLOS:TICLOS discriminator ,@args)*
;1 if it is a TICLOS instance.  If Both is specified instead*
;1 of either of the above, then both functions will have the*
;1 same name, though different packages.  If Error-p is true*
;1 and Discriminator is neither a PCL or TICLOS thing then*
;1 it generates an error otherwise it returns nil.*
;1 (defsafe-simple class-named-safe (x) :both class-named)*
;1 ~=*
;1 (defsafe class-named-safe (x)*
;1   :pcl (pcl:class-named x) *
;1   :ticlos (ticlos:class-named x))"*
;1  (LET ((real-pcl (INTERN (SYMBOL-NAME*
;			1    (OR both pcl (AND (NOT error-p) 'IDENTITY)))*
;			1  'pcl))*
;	1(real-ti  (INTERN (SYMBOL-NAME*
;			1    (OR both ticlos (AND (NOT error-p) 'IDENTITY)))*
;			1  'ticlos)))*
;1      `(DEFUN ,fname (,discriminator ,@args)*
;	1 ,documentation*
;	1 ,declarations*
;	1  (IF ,(IF (OR pcl both (NOT error-p))*
;		1  `(AND (pcl-p) (iwmc-class-p-safe ,discriminator))*
;		1   nil)*
;	1       (,real-pcl ,discriminator ,@args)*
;	1       (IF ,(IF (OR ticlos both (NOT error-p))*
;		1       `(AND (ticlos-p) (ticlos-instance-p ,discriminator))*
;		1        nil)*
;		1    (,real-ti ,discriminator ,@args)*
;		1   ,(IF error-p*
;		1       `(FERROR nil "Something wrong with ~S." ,discriminator)*
;			1nil))))))*

(DEFMACRO 4defsafe-simple*
     (fname (discriminator &rest args)
      &key (DOCUMENTATION nil) (ticlos nil) (error-p t)
      (declarations nil))
"2Defines a function called FName, which should execute
 (TICLOS:TICLOS discriminator ,@args) if it is a TICLOS instance. 
 If Error-p is true and Discriminator is not a TICLOS thing then
 it generates an error otherwise it returns nil.
 (defsafe-simple class-named-safe (x) :ticlos class-named)
 ~=
 (defsafe class-named-safe (x)
   :ticlos (ticlos:class-named x))*"
  (LET ((real-ti  (INTERN (SYMBOL-NAME
			    (OR ticlos (AND (NOT error-p) 'IDENTITY)))
			  'ticlos)))
      `(DEFUN ,fname (,discriminator ,@args)
	 ,documentation
	 ,declarations
	       (IF ,(IF (OR ticlos (NOT error-p))
		       `(AND (ticlos-p) (ticlos-instance-p ,discriminator))
		        nil)
		    (,real-ti ,discriminator ,@args)
		   ,(IF error-p
		       `(FERROR nil "3Something wrong with ~S.*" ,discriminator)
			nil)))))

;1 TAC 08-17-89 - removing PCL support and redefining defsafe-gf-simple macro *
;1(DEFMACRO defsafe-gf-simple*
;1     (fname (discriminator &rest args)*
;1      &key (DOCUMENTATION nil) (both nil) (pcl nil) (ticlos nil) (error-p t)*
;1      (declarations nil))*
;1"Defines a function called FName, which should execute*
;1 (PCL:PCL discriminator ,@args) if Discriminator*
;1 is a PCL GF or (TICLOS:TICLOS discriminator ,@args)*
;1 if it is a TICLOS GF.  If Both is specified instead*
;1 of either of the above, then both functions will have the*
;1 same name, though different packages.  If Error-p is true*
;1 and Discriminator is neither a PCL or TICLOS thing then*
;1 it generates an error otherwise it returns nil.*
;1 (defsafe-gf-simple class-named-safe (x) :both class-named)*
;1 ~=*
;1 (defsafe-gf generic-function-name-safe (x)*
;1   :pcl (pcl:generic-function-name x) *
;1   :ticlos (ticlos:generic-function-name x))"*
;1  (LET ((real-pcl (INTERN (SYMBOL-NAME*
;			1    (OR both pcl (AND (NOT error-p) 'IDENTITY)))*
;			1  'pcl))*
;	1(real-ti  (INTERN (SYMBOL-NAME*
;			1    (OR both ticlos (AND (NOT error-p) 'IDENTITY)))*
;			1  'ticlos)))*
;1      `(DEFUN ,fname (,discriminator ,@args)*
;	1 ,documentation*
;	1 ,declarations*
;	1  (IF ,(IF (OR pcl both (NOT error-p))*
;		1  `(AND (pcl-p) (pcl:generic-function-p ,discriminator))*
;		1   nil)*
;	1       (,real-pcl ,discriminator ,@args)*
;	1       (IF ,(IF (OR ticlos both (NOT error-p))*
;		1       `(AND (ticlos-p)*
;			1     (ticlos:generic-function-p ,discriminator))*
;		1        nil)*
;		1    (,real-ti ,discriminator ,@args)*
;		1   ,(IF error-p*
;		1       `(FERROR nil "~S is not a generic function."*
;				1,discriminator)*
;			1nil))))))*


(DEFMACRO 4defsafe-gf-simple*
	  (fname (discriminator &rest args)
	   &key (DOCUMENTATION nil) (ticlos nil) (error-p t)
	   (declarations nil))
  "2Defines a function called FName, which should execute
 (TICLOS:TICLOS discriminator ,@args) if it is a TICLOS GF.  
 If Error-p is true and Discriminator is not a TICLOS thing then
 it generates an error otherwise it returns nil.
 (defsafe-gf-simple class-named-safe (x) :ticlos class-named)
 ~=
 (defsafe-gf generic-function-name-safe (x)
   :ticlos (ticlos:generic-function-name x))*"
  (LET ((real-ti  (INTERN (SYMBOL-NAME
			    (OR ticlos (AND (NOT error-p) 'IDENTITY)))
			  'ticlos)))
    `(DEFUN ,fname (,discriminator ,@args)
       ,documentation
       ,declarations
       (IF ,(IF (OR ticlos (NOT error-p))
		`(AND (ticlos-p)
		      (ticlos::generic-function-p ,discriminator))
		nil)
	   (,real-ti ,discriminator ,@args)
	   ,(IF error-p
		`(FERROR nil "3~S is not a generic function.*"
			 ,discriminator)
		nil)))))

;1 TAC 08-17-89 - removing PCL support and redefining defsafe-slotd macro *
;1(DEFMACRO defsafe-slotd*
;1     (fname (discriminator &rest args)*
;1      &key (DOCUMENTATION nil) (both nil) (pcl nil) (ticlos nil) (error-p t)*
;1      (declarations nil))*
;1"Defines a function called FName, which should execute*
;1 (PCL:PCL discriminator ,@args) if Discriminator*
;1 is a PCL slot-descriptor or (TICLOS:TICLOS discriminator ,@args)*
;1 if it is a TICLOS slot-descriptor.  If Both is specified instead*
;1 of either of the above, then both functions will have the*
;1 same name, though different packages.  If Error-p is true*
;1 and Discriminator is neither a PCL or TICLOS thing then*
;1 it generates an error otherwise it returns nil.*
;1 eg: (defsafe-slotd slotd-name-safe (x)*
;1       :pcl slotd-name*
;1       :ticlos slot-description-name)"*
;1  (LET ((real-pcl (INTERN (SYMBOL-NAME*
;			1    (OR both pcl (AND (NOT error-p) 'IDENTITY)))*
;			1  'pcl))*
;	1(real-ti  (INTERN (SYMBOL-NAME*
;			1    (OR both ticlos (AND (NOT error-p) 'IDENTITY)))*
;			1  'ticlos)))*
;1      `(DEFUN ,fname (,discriminator ,@args)*
;	1 ,documentation*
;	1 ,declarations*
;	1  (IF ,(IF (OR pcl both (NOT error-p))*
;		1  `(AND (pcl-p)*
;			1(TYPEP ,discriminator 'pcl:standard-slot-description))*
;		1   nil)*
;	1       (,real-pcl ,discriminator ,@args)*
;	1       (IF ,(IF (OR ticlos both (NOT error-p))*
;		1       `(AND (ticlos-p)*
;			1     (TYPEP ,discriminator 'ticlos:slot-description))*
;		1        nil)*
;		1    (,real-ti ,discriminator ,@args)*
;		1   ,(IF error-p*
;		1       `(FERROR nil "Something wrong with ~S." ,discriminator)*
;			1nil))))))*

(DEFMACRO 4defsafe-slotd*
	  (fname (discriminator &rest args)
	   &key (DOCUMENTATION nil) (ticlos nil) (error-p t)
	   (declarations nil))
  "2Defines a function called FName, which should execute
 (TICLOS:TICLOS discriminator ,@args) if it is a TICLOS slot-definition. 
If Error-p is true and Discriminator is not a TICLOS thing then
 it generates an error otherwise it returns nil.
 eg: (defsafe-slotd slotd-name-safe (x)
       :ticlos slot-description-name)*"
  (LET ((real-ti  (INTERN (SYMBOL-NAME
			    (OR ticlos (AND (NOT error-p) 'IDENTITY)))
			  'ticlos)))
    `(DEFUN ,fname (,discriminator ,@args)
       ,documentation
       ,declarations
       (IF ,(IF (OR ticlos (NOT error-p))
		`(AND (ticlos-p)
		      ;1;* (TYPEP ,discriminator 'ticlos:slot-description))
		      ;1; * TAC 08-28-891 - as per David Gray, slot-description should be slot definition  *
		       (TYPEP ,discriminator 'clos:slot-definition))
		nil)
	   (,real-ti ,discriminator ,@args)
	   ,(IF error-p
		`(FERROR nil "3Something wrong with ~S.*" ,discriminator)
		nil)))))

;1; TAC 09-04-89 - substituted (si::closure-function x) for (FIRST (si:convert-closure-to-list x))*
;1;                      David Gray's preferred method of handling closures.*
(DEFUN 4get-fef-from-object* (x)
  "2Tries to extract a fef from an object.  X could be a method or a
 generic function, which is not itself a fef, but points to one.
 This is used by code that grovles over the fef for one reason or other.*"
  (FLET (
	 ;1; TAC 08-17-89 - removing PCL support*
;	1 (pcl ()*
;	1   (TYPECASE x*
;	1     (pcl:standard-method*
;	1      (get-fef-from-object (method-function-safe x)))*
;	1     (pcl:standard-generic-function*
;	1      (FIRST (si:convert-closure-to-list x)))*
;	1     (compiled-function x)*
;	1     (CLOSURE (FIRST (si:convert-closure-to-list x)))*
;	1     (otherwise nil)))*
	 (ticlos ()
		 (TYPECASE x
		   (ticlos:standard-method (method-function-safe x))
		   (ticlos:standard-generic-function
		    (ticlos::generic-function-discriminator-code x))
		   (compiled-function x)
		   ;1; *(CLOSURE (FIRST (si:convert-closure-to-list x)))
		   (CLOSURE (si::closure-function x))
		   (otherwise nil))))
    ;1; TAC 08-17-89 - removing PCL support*
;1    (IF (pcl-p)*
;	1(OR (pcl) (IF (ticlos-p) (OR (ticlos) (LIST nil)) (LIST nil)))*
;	1(IF (ticlos-p) (OR (ticlos) (LIST nil)) (LIST nil)))*
    (IF (ticlos-p) (OR (ticlos) (LIST nil)) (LIST nil))))

;1; TAC 08-17-89 - removing PCL support*
;1(DEFUN slotd-p-safe (slotd)*
;1"Is true if SlotD is a slot descriptor object."*
;1  (OR (AND (pcl-p)*
;	1   (TYPEP slotd 'pcl:standard-slot-description))*
;1      (AND (ticlos-p)*
;	1   (TYPEP slotd 'ticlos:slot-description))))*

(DEFUN 4slotd-p-safe* (slotd)
  "2Is true if SlotD is a slot definition object.*"
  (AND (ticlos-p)
       ;1; *(TYPEP slotd 'ticlos:slot-description)))
       ;1; *TAC 08-28-891 - as per David Gray, slot-description should be slot-definition*
       (TYPEP slotd 'clos:slot-definition)))

;1(defsafe-slotd slotd-name-safe (slotd)*
;1  :documentation "Returns the name of the slot described by SlotD."*
;1  :ticlos slot-definition-name*
;1  :pcl slotd-name)*

(defsafe-slotd 4slotd-name-safe* (slotd)
  :documentation "3Returns the name of the slot described by SlotD.*"
  :ticlos slot-definition-name)

;1(defsafe-simple slot-value-safe (instance slot)*
;1  :documentation*
;1  "Returns the value of the slot named Slot in the instance Instance."*
;1  :both slot-value)*

(defsafe-simple 4slot-value-safe* (instance slot)
  :documentation
  "3Returns the value of the slot named Slot in the instance Instance.*"
  :ticlos slot-value)

;1(defsafe-simple class-of-safe (thing)*
;1  :documentation "Returns the class of Thing."*
;1  :both class-of)*

(defsafe-simple 4class-of-safe* (thing)
  :documentation "3Returns the class of Thing.*"
  :ticlos class-of)

;1(DEFUN class-of-gf-safe (thing)*
;1"Returns the class of Thing."*
;1  (IF (AND (ticlos-p) (ticlos:generic-function-p thing))*
;1      (ticlos:class-of thing)*
;1      (IF (AND (pcl-p) (pcl:generic-function-p thing))*
;	1  (pcl:class-of-generic-function thing)*
;	1  (FERROR nil "~S is not a generic function." thing))))*

(DEFUN 4class-of-gf-safe* (thing)
"2Returns the class of Thing.*"
  (IF (AND (ticlos-p) (ticlos::generic-function-p thing))
      (ticlos:class-of thing)
      (FERROR nil "3~S is not a generic function.*" thing)))

;1(defsafe-simple method-function-safe (method)*
;1  :documentation "Returns the method function of Method."*
;1  :both method-function)*

(defsafe-simple 4method-function-safe* (method)
  :documentation "3Returns the method function of Method.*"
  :ticlos method-function)

;1(defsafe-slotd slotd-initform-safe (slotd)*
;1  :documentation "Returns the initform of the slot descriptor SlotD."*
;1  :pcl slotd-initform*
;1  :ticlos slot-definition-initform)*

(defsafe-slotd 4slotd-initform-safe* (slotd)
  :documentation "3Returns the initform of the slot descriptor SlotD.*"
  :ticlos slot-definition-initform)

;1(defsafe-slotd slotd-accessors-safe (slotd)*
;1  :documentation "Returns the accessors of the slot descriptor SlotD."*
;1  :pcl slotd-accessors ;;; !!!!! JPR.*
;1  :ticlos slot-definition-writers)*

(defsafe-slotd 4slotd-accessors-safe* (slotd)
  :documentation "3Returns the accessors of the slot descriptor SlotD.*"
  :ticlos slot-definition-writers)

;1(defsafe-slotd slotd-readers-safe (slotd)*
;1  :documentation "Returns the readers of the slot descriptor SlotD."*
;1  :pcl slotd-readers*
;1  :ticlos slot-definition-readers)*

(defsafe-slotd 4slotd-readers-safe* (slotd)
  :documentation "3Returns the readers of the slot descriptor SlotD.*"
  :ticlos slot-definition-readers)

;1(defsafe-slotd slotd-type-safe (slotd)*
;1  :documentation "Returns the type of the slot descriptor SlotD."*
;1  :pcl slotd-type*
;1  :ticlos slot-definition-type)*

(defsafe-slotd 4slotd-type-safe* (slotd)
  :documentation "3Returns the type of the slot descriptor SlotD.*"
  :ticlos slot-definition-type)

;1(defsafe-slotd slotd-allocation-safe (slotd)*
;1  :documentation "Returns the allocation of the slot descriptor SlotD."*
;1  :pcl slotd-allocation*
;1  :ticlos slot-definition-allocation)*

(defsafe-slotd 4slotd-allocation-safe* (slotd)
  :documentation "3Returns the allocation of the slot descriptor SlotD.*"
  :ticlos slot-definition-allocation)

;1(defsafe-slotd slotd-initargs-safe (slotd)*
;1  :documentation "Returns the initargs of the slot descriptor SlotD."*
;1  :pcl slotd-initargs*
;1  :ticlos slot-definition-initargs)*

(defsafe-slotd 4slotd-initargs-safe* (slotd)
  :documentation "3Returns the initargs of the slot descriptor SlotD.*"
  :ticlos slot-definition-initargs)

;1(defsafe class-local-slots-safe (class)*
;1  :documentation "Returns the local slots of the class Class."*
;1  :ticlos (ticlos:class-direct-slots class)*
;1  :pcl (LET ((others (MAPCAR #'pcl:slotd-name*
;			1     (APPLY #'APPEND*
;				1      (MAPCAR #'pcl:class-direct-slots*
;					1      (REST (class-precedence-list-safe*
;						1      class)))))))*
;	1    (REMOVE-IF #'(lambda (slotd) (MEMBER (pcl:slotd-name slotd) others))*
;		1       (pcl:class-direct-slots class))))*

(defsafe 4class-local-slots-safe* (class)
  :documentation "3Returns the local slots of the class Class.*"
  :ticlos (ticlos:class-direct-slots class))

(DEFUN 4all-shared-slots* (class)
  (LET ((cpl (class-precedence-list-safe class t)))
       (APPLY #'APPEND
	      (MAPCAR #'(lambda (a-class)
			  (MAPCAR #'FIRST
				  (ticlos::class-class-slot-alist (ticlos::class-description a-class))))
		        cpl))))

;1(DEFUN class-instance-slots-safe (class)*
;1"Returns a list of the Local slots posessed by instances of the class CLASS."*
;1  (IF (TYPEP class 'ticlos-instance)*
;1      (LET ((descr (ticlos:class-description class)))*
;	1   (LET ((shared (all-shared-slots class)))*
;	1        (REMOVE-IF*
;		1  #'(lambda (slotd)*
;		1      (MEMBER (ticlos:slot-name slotd) shared))*
;	1            (GETF (ticlos:class-description-plist descr)*
;			1  'ticlos:all-slots))))*
;1      (LET ((slots (pcl:class-slots class)))*
;	1   (REMOVE-IF*
;	1     #'(lambda (slotd) (EQUAL (slotd-allocation-safe slotd) :class))*
;	1       slots))))*

(DEFUN 4class-instance-slots-safe* (class)
  "2Returns a list of the Local slots posessed by instances of the class CLASS.*"
  (WHEN (TYPEP class 'ticlos-instance)
    (LET ((shared (all-shared-slots class)))
      (REMOVE-IF
	#'(lambda (slotd)
	    ;1; *(MEMBER (ticlos:slot-name slotd) shared))
	    ;1; *TAC 08-28-891 - as per David Gray, slot-name should be slot-definition-name*
	    (MEMBER (clos:slot-definition-name slotd) shared))
	(CLOS:CLASS-SLOTS class)))))

;1(DEFUN class-non-instance-slots-safe (class)*
;1"Returns a list of the Shared slots posessed by instances of the class CLASS."*
;1  (IF (TYPEP class 'ticlos-instance)*
;1      (LET ((descr (ticlos:class-description class)))*
;	1   (LET ((shared (all-shared-slots class)))*
;	1        (REMOVE-IF-NOT*
;		1  #'(lambda (slotd)*
;		1      (MEMBER (ticlos:slot-name slotd) shared))*
;	1            (GETF (ticlos:class-description-plist descr)*
;			1  'ticlos:all-slots))))*
;1      (LET ((slots (pcl:class-slots class)))*
;	1   (REMOVE-IF-NOT*
;	1     #'(lambda (slotd) (EQUAL (slotd-allocation-safe slotd) :class))*
;	1       slots))))*

(DEFUN 4class-non-instance-slots-safe* (class)
  "2Returns a list of the Shared slots posessed by instances of the class CLASS.*"
  (WHEN (TYPEP class 'ticlos-instance)
    (LET ((shared (all-shared-slots class)))
      (REMOVE-IF-NOT
	#'(lambda (slotd)
	    ;1; *(MEMBER (ticlos:slot-name slotd) shared))
	    ;1; *TAC 08-28-891 - as per David Gray, slot-name should be slot-definition-name*
	    (MEMBER (clos:slot-definition-name slotd) shared))
	(CLOS:CLASS-SLOTS class)))))

;1(defsafe-simple class-finalized-p-safe (class)*
;1  :documentation "Is true if Class has been finalized."*
;1  :both class-finalized-p)*

(defsafe-simple 4class-finalized-p-safe* (class)
  :documentation "3Is true if Class has been finalized.*"
  :ticlos class-finalized-p)

;1(defsafe-simple class-precedence-list-safe-1 (class)*
;1  :documentation "Returns the class precedence list of a finalized class."*
;1  :both class-precedence-list)*

(defsafe-simple 4class-precedence-list-safe-1* (class)
  :documentation "3Returns the class precedence list of a finalized class.*"
  :ticlos class-precedence-list)

(DEFUN 4class-precedence-list-safe* (class &optional (undefined-ok nil))
"2Returns the class precedence list of a class.  If undefined-ok is true then
 it's alright to return just the names of undefined classes, rather than the
 class objects themselves.  The class does not have to be finalized for this
 function to work.*" 
  (IF (class-finalized-p-safe class)
      (class-precedence-list-safe-1 class)
      (REMOVE nil (MAPCAR #'(lambda (a-class)
			      (OR (AND (class-p-safe a-class)
				       a-class)
				  (class-named-safe a-class t)
				  (AND undefined-ok a-class)))
			    (CONS class (class-local-supers-safe class))))))

(DEFUN 4class-precedence-list-1* (class undefined-ok)
  (CONS class 
        (APPLY #'APPEND
		(MAPCAR #'(lambda (class)
			     (IF (class-p-safe class)
				 (class-precedence-list-1
				   class undefined-ok)
				 class))
			   (MAPCAR #'(lambda (a-class)
				       (OR (AND (class-p-safe a-class)
						a-class)
					   (class-named-safe a-class t)
					   (AND undefined-ok a-class)))
				     (class-local-supers-safe class))))))

;1**************
;1 TAC 07-26-89 - moved from TI-ENV-FLAVOR-INSPECTOR-INTERFACE -----*
;1 TAC 07-25-89 - pulled from PATHNAME-EXTENSIONS file (fs package).*
(DEFUN 4cons-new* (x list &key (test #'EQL))
  (IF (MEMBER x list :test test)
      list
      (CONS x list))) 

(DEFUN 4uniquify* (LIST result &key (test #'EQL))
"2Given a list collects the elements of list into result and returns them.
 Result is a Set at the end (unless it was non-nil and not a set at the start).
 Test is the membership test function.*"
  (IF list
      (uniquify (REST list) (cons-new (FIRST list) result :test test)
		:test test)
      (NREVERSE result)))
;1-------------------------------------------------------------------*

(DEFUN 4class-precedence-list-safe* (class &optional (undefined-ok nil))
"2Returns the class precedence list of a class.  If undefined-ok is true then
 it's alright to return just the names of undefined classes, rather than the
 class objects themselves.  The class does not have to be finalized for this
 function to work.*" 
  (IF (class-finalized-p-safe class)
      (class-precedence-list-safe-1 class)
      (uniquify (class-precedence-list-1 class undefined-ok) nil)))

(DEFUN 4clos-method-name* (method)
"2Returns the name of a clos method.*"
  (FUNCTION-NAME (method-function-safe method)))

(DEFUN 4coerce-to-class* (class)
"2Makes sure that class is a class.*"
  (IF (class-p-safe class)
      class
      (IF (CONSP class)
	  (IF (EQUAL 'EQL (FIRST class))
	      class
	      (LIST (FIRST class) (coerce-to-class (SECOND class))))
	  (coerce-to-class (class-named-safe class)))))

;1(defsafe method-parameter-specializers-safe (method)*
;1  :documentation "Returns the parameter specializers of method Method."*
;1  :ticlos (MAPCAR #'coerce-to-class*
;		1  (ticlos:method-parameter-specializers method))*
;1  :pcl    (MAPCAR #'coerce-to-class (pcl:method-type-specifiers method)))*

(defsafe 4method-parameter-specializers-safe* (method)
  :documentation "3Returns the parameter specializers of method Method.*"
  :ticlos (MAPCAR #'coerce-to-class
		  (clos:method-specializers method)))

(DEFUN 4method-primary-p-safe* (method)
"2Is true if Method is a primary method.*"
  (OR (EQUAL nil (method-qualifiers-safe method))
      ;1;;; !!!! Allow for PCL reader/writer methods.  *
      ;1; TAC 08-17-89 not sure which part the above comment references, but neither should hurt*
      (EQUAL :internal
	     (FIRST (FUNCTION-NAME (method-function-safe method))))))

(DEFUN 4is-specialised-by* (method class looking-for-class)
"2Is true if Method is specialized by Class, i.e. Class is something like
 bottle, where bottle is built on container and method has a name something like
 (method fill-me ((me container) (with t))).
 Looking for Class is the class we are really interested in.  This means that,
 although container is built on T, we are not interested in methods that have
 t as specializers.*"
  (AND (MEMBER class (method-parameter-specializers-safe method))
       (REMOVE nil (MAPCAR #'(lambda (x)
			       (AND (NOT (EQUAL t (class-name-safe x)))
				    (my-subtypep looking-for-class x)))
			     (method-parameter-specializers-safe method)))))

(DEFUN 4is-specialised-by-components* (method class)
"2Is true if Method is specialized by Class, i.e. Class is something like
 bottle, where bottle is built on container and method has a name something like
 (method fill-me ((me container) (with t))).  If it is true then it returns
 the method, otherwise nil.*"
  (LET ((matches
	  (REMOVE-IF-NOT #'(lambda (cl) (is-specialised-by method cl class))
			 (class-precedence-list-safe class))))
       (IF matches method nil)))

(DEFUN 4actual-method-entry* (x)
"2Returns the method entry we are interested in.*"
  (IF (CONSP (FIRST x))
      (THIRD x)
      (actual-method-entry (SECOND x))))

;1(defsafe-gf generic-function-methods-safe (generic-function)*
;1  :documentation "Returns the methods associated with a generic function."*
;1  :pcl (pcl:generic-function-methods generic-function)*
;1  ;; Use this for because ticlos:generic-function-methods doesn't get set methods.*
;1  :ticlos (LET ((LIST (ticlos:generic-function-method-list generic-function)))*
;	1       ;;; Put in catch error to oprotect from During Transport*
;	1       ;;; of Self-Ref-Pointer error.*
;	1       (APPLY #'APPEND (MAPCAR 'get-method-from-spec list)))*
;1;  :ticlos (ticlos:generic-function-methods generic-function)*
;1  )*

(defsafe-gf 4generic-function-methods-safe* (generic-function)
  :documentation "3Returns the methods associated with a generic function.*"
  :ticlos (clos:generic-function-methods generic-function)
  )

(DEFUN 4ticlos-class-direct-generic-functions*
       (a-class &optional (top-class a-class))
"2Returns the list of generic functions that name the methods directly
 specialized by a-class.  Top-class is the class we're actually interested in
 since this might be different from a-class (see ticlos-class-direct-methods).*"
  (LET ((methods (ticlos-class-direct-methods a-class top-class)))
       (uniquify (MAPCAR #'method-generic-function-safe methods) nil)))

(DEFUN 4get-method-from-spec* (spec)
"2Given a method spec returns the actual method.*"
  (DECLARE (optimize (safety 0)))
  (IF (AND (CONSP spec) (CONSP (FIRST spec))
	   (NOT (EQUAL 'EQL (FIRST (FIRST spec)))))
      (IF (EQUAL 'ticlos:method (FIRST (FIRST spec)))
	  (IF (EQUAL :combined (THIRD (FIRST spec)))
	      nil
	      (LIST (THIRD spec)))
	  (get-method-from-spec (REST (REST (REST spec)))))
      (IF (CONSP spec)
	  (REMOVE nil (APPLY #'APPEND (MAPCAR 'get-method-from-spec spec)))
	  nil)))

(DEFUN 4class-all-slots-safe* (class)
"2Returns a list of the slotds for all of the slots in Class.*"
  (LET ((slots (MAPCAR #'class-local-slots-safe
		       (class-precedence-list-safe class))))
       (LET ((result nil))
	    (LOOP for slotd in (APPLY #'APPEND slots)
		  unless (MEMBER slotd result
				 :test #'(lambda (x y)
					   (EQ (slotd-name-safe x)
					       (slotd-name-safe y))))
		  do (PUSH slotd result))
	    result)))

(DEFUN 4get-gfs-for-slot* (slotd)
  (APPEND (slotd-accessors-safe slotd)
	  (slotd-readers-safe slotd)))

;1**************
;1 TAC 07-26-89 - moved from TI-ENV-FLAVOR-INSPECTOR-INTERFACE ---------*
(DEFUN 4get-gf-for-slot-function* (fn)
"2Given a function name e.g. foo or (setf foo), returns the gf for it.*"
  (function-generic-function-safe
    (fdefinition fn)))

;1-----------------------------------------------------------------------*

(DEFUN 4get-gfs-for-slots-of* (class)
  (LET ((slotds (class-all-slots-safe class)))
       (MAPCAR #'get-gf-for-slot-function
	       (uniquify (APPLY #'APPEND (MAPCAR 'get-gfs-for-slot slotds)) nil))))

(DEFUN 4ticlos-class-direct-methods* (a-class &optional (top-class a-class))
"2Returns the list of methods directly specialized by a-class.  Top-class
 is the class we're actually interested in since this might be different
 from a-class during checks of subclasses (e.g. show-all-clos-methods).
 Top-class allows is-specialised-by to know which class we are actually
 interested in.*"
  (LET ((fns (APPEND (CLOS:SPECIALIZER-DIRECT-GENERIC-FUNCTIONS a-class)
		     (get-gfs-for-slots-of a-class))))
       (LET ((locals nil))
            (LOOP for fn in fns do
		  (LOOP for meth in (generic-function-methods-safe fn)
			when (AND meth
				  (is-specialised-by meth a-class top-class))
			do (PUSH meth locals)))
	    locals)))

;1(defsafe method-lambda-list-safe (method)*
;1  :documentation "Returns the method lambda list of a method."*
;1  ;; Protect agains self-ref-transport bug.*
;1  :ticlos (CATCH-ERROR (ticlos:method-lambda-list method) nil)*
;1  :pcl (pcl:method-arglist method))*

(defsafe 4method-lambda-list-safe* (method)
  :documentation "3Returns the method lambda list of a method.*"
  ;1; Protect agains self-ref-transport bug.*
  :ticlos (CATCH-ERROR (ticlos:method-lambda-list method) nil))


(DEFUN 4method-type-specifiers-safe* (method)
  "2Returns the type specifiers of a method.*"
  (method-lambda-list-safe method))

;1(defsafe method-docs-safe (method)*
;1  :documentation "Returns the documentation of a method."*
;1  :pcl (slot-value-safe method 'DOCUMENTATION)*
;1  :ticlos (DOCUMENTATION method))*

(defsafe 4method-docs-safe* (method)
  :documentation "3Returns the documentation of a method.*"
  :ticlos (DOCUMENTATION method))

(DEFUN 4path-string-1* (path types)
"2Is given a spec that might have been got from the :source-file-name
 property of something and the type of definition path to look for (e.g. defun).
 It returns either the string-for-printing of the pathname or the string
 \"Not Defined\".*"
  (IF path
      (FORMAT nil "3~a*"
        (SEND (IF (CONSP path)
		  (LOOP for type in (IF (LISTP types) types (LIST types))
			when (ASSOC type path :test #'EQ)
			return (SECOND (ASSOC type path :test #'EQ)))
		  path)
	      :string-for-printing))
      '(:font 2 "3Not Defined*")))

(DEFUN 4path-string* (name type)
"2Returns the string for the source file pathname of Name of type Type.  Type
 is something like Defun or Defflavor.*"
  (LET ((path (si:function-spec-get name :source-file-name)))
       (path-string-1 path type)))

;1(DEFUN path-string-safe (class)*
;1"Returns a string for the source file name of a class."*
;1  (path-string (class-name-safe class)*
;	1       (IF (iwmc-class-p-safe class)*
;		1   'pcl:class*
;		1   '(ticlos:defclass ticl:defflavor))))*

(DEFUN 4path-string-safe* (class)
  "2Returns a string for the source file name of a class.*"
  (path-string (class-name-safe class)
	       '(ticlos:defclass ticl:defflavor)))

(DEFUN 4is-for* (entry method)
"2Is true if the method table entry Entry is the entry for Method.*"
  (IF (CONSP (FIRST entry))
      (MEMBER method entry)
      (is-for (SECOND entry) method)))

;(DEFUN 4ticlos-method-plist* (method)
;"2Gets the plist from the method table entry for Method.*"
;  (LET ((gf (method-generic-function-safe method)))
;       (LET ((entry (ticlos:generic-function-method-list gf)))
;	    (LOOP for meth in entry
;		  when (is-for meth method)
;		  return (is-for meth method)))))

;1(defsafe method-path-string-safe (method)*
;1  :documentation "Returns the pathname string for the source file of Method."*
;1  :ticlos (LET ((path (GETF (ticlos-method-plist method) :source-file-name)))*
;	1       (path-string-1 path 'DEFUN))*
;1  :pcl (IF (COMPILED-FUNCTION-P (method-function-safe method))*
;	1   (path-string-1*
;	1     (si:function-spec-get*
;	1       (FUNCTION-NAME (method-function-safe method)) :source-file-name)*
;	1     'DEFUN)*
;	1   '(:font 2 "Not Defined")))*

(defsafe 4method-path-string-safe* (method)
  :documentation "3Returns the pathname string for the source file of Method.*"
  :ticlos (LET ((path (ticlos:definition-generic-pathname method)))
	       (path-string-1 path 'DEFUN)))

;1(defsafe class-direct-methods-safe (class &optional (top-class class))*
;1  :documentation *
;1"Returns the list of methods that have been defined to specialise Class*
;1 directly."*
;1  :pcl (pcl:class-direct-methods class)*
;1  :ticlos (ticlos-class-direct-methods class top-class))*

(defsafe 4class-direct-methods-safe* (class &optional (top-class class))
  :documentation 
"3Returns the list of methods that have been defined to specialise Class
 directly.*"
  :ticlos (ticlos-class-direct-methods class top-class))

;1(defsafe class-default-initargs-safe (class)*
;1  :documentation "Returns the default initargs of the class Class."*
;1  :pcl (pcl:class-default-initargs class)*
;1  :ticlos*
;1      (MAPCAR #'(lambda (x) (LIST (FIRST x) (THIRD x)))*
;	1     (GETF (ticlos:class-description-plist*
;		1     (ticlos:class-description class))*
;		1   :default-initargs)))*

(defsafe 4class-default-initargs-safe* (class)
  :documentation "3Returns the default initargs of the class Class.*"
  :ticlos
      (MAPCAR #'(lambda (x) (LIST (FIRST x) (SECOND x)))
	      (CLOS:CLASS-DIRECT-DEFAULT-INITARGS class)))

;1(defsafe class-direct-generic-functions-safe (class &optional (top-class class))*
;1  :documentation *
;1"Gets a list of all of the generic functions that name methods, which have been*
;1 defined directly on this class.  Top class is the class we are actually*
;1 interested in."*
;1  :pcl    (pcl:class-direct-generic-functions    class)*
;1  :ticlos (ticlos-class-direct-generic-functions class top-class))*

(defsafe 4class-direct-generic-functions-safe* (class &optional (top-class class))
  :documentation 
"3Gets a list of all of the generic functions that name methods, which have been
 defined directly on this class.  Top class is the class we are actually
 interested in.*"
  :ticlos (ticlos-class-direct-generic-functions class top-class))

;1; *** from Rice message Mods to TI-ENV-INSP.-INTERF. 8 Jun 1989 13:56:40 PDT*
(DEFUN 4method-arglist-safe* (method)
"2Returns the method arglist of a method.*"
  (LET ((args (method-lambda-list-safe method))
       (VALUES (CATCH-ERROR
		 (SECOND (MULTIPLE-VALUE-LIST
			   (ARGLIST (method-function-safe method))))
		 nil)))
      (VALUES args values)))

;1(defsafe-simple method-qualifiers-safe (method)*
;1  :documentation "Returns the qualifiers (e.g. :Before) of Method."*
;1  :both method-qualifiers)*

(defsafe-simple 4method-qualifiers-safe* (method)
  :documentation "3Returns the qualifiers (e.g. :Before) of Method.*"
  :ticlos method-qualifiers)

;1(defsafe unparse-specializers-safe (method)*
;1  :documentation *
;1"Unparses the specializers of Method.  Returns the specializers list and T*
;1 if the method is combined."*
;1  :declarations (DECLARE (VALUES specializers combined-method-p))*
;1  :pcl (VALUES (pcl:unparse-specializers method)*
;	1       (method-qualifiers-safe method))*
;1  :ticlos (LET ((name (FUNCTION-NAME (ticlos:method-function method))))*
;	1       (VALUES (IF (FOURTH name) (FOURTH name) (THIRD name))*
;		1       (method-qualifiers-safe method))))*

(defsafe 4unparse-specializers-safe* (method)
  :documentation 
"3Unparses the specializers of Method.  Returns the specializers list and T
 if the method is combined.*"
  :declarations (DECLARE (VALUES specializers combined-method-p))
  :ticlos (LET ((name (FUNCTION-NAME (ticlos:method-function method))))
	       (VALUES (IF (FOURTH name) (FOURTH name) (THIRD name))
		       (method-qualifiers-safe method))))

;1(DEFUN class-named-safe (class &optional (noerrorp nil))*
;1"Returns the class named by the name Class.  If noerrorp is true then no error*
;1 is signaled and nil is returned if Class is does not, in fact, name a class."*
;1  (IF (AND (ticlos-p) (ticlos:class-named class t))*
;1      (ticlos:class-named class t)*
;1      (IF (AND (pcl-p) (pcl:find-class class nil))*
;	1  (pcl:find-class class nil)*
;	1  (OR (AND (ticlos-p) (ticlos:class-named class noerrorp))*
;	1      (AND (pcl-p)   (pcl:find-class class (NOT noerrorp)))*
;	1      (AND (NOT noerrorp)*
;		1    (FERROR nil "~S does not name a class." class))))))*

(DEFUN 4class-named-safe* (class &optional (noerrorp nil))
"2Returns the class named by the name Class.  If noerrorp is true then no error
 is signaled and nil is returned if Class is does not, in fact, name a class.*"
  (ticlos::class-named class noerrorp))

;1(defsafe-simple class-name-safe (class)*
;1  :documentation "Returns the name of the class Class."*
;1  :both class-name)*

(defsafe-simple 4class-name-safe* (class)
  :documentation "3Returns the name of the class Class.*"
  :ticlos class-name)

;1(defsafe-simple subclassp-safe (x y)*
;1  :documentation "Is true if x is a subclass of y"*
;1  :both subclassp*
;1  :error-p nil)*

(defsafe-simple 4subclassp-safe* (x y)
  :documentation "3Is true if x is a subclass of y*"
  :ticlos subclassp
  :error-p nil)

;1(DEFUN pcl-class-p (x)*
;1"True if x is a pcl class object."*
;1  (OR (TYPEP x 'pcl:standard-class)*
;1;      (typep x 'pcl:structure-class)*
;1      (TYPEP x 'pcl:built-in-class)))*

;1(defsafe class-p-safe (x)*
;1  :documentation*
;1"Is true if x is some sort of class object.  This could be a built-in class*
;1 standard or structure class."*
;1  :pcl (pcl-class-p x)*
;1  :ticlos (TYPEP x 'clos:class)*
;1  :error-p nil)*

(defsafe 4class-p-safe* (x)
  :documentation
"3Is true if x is some sort of class object.  This could be a built-in class
 standard or structure class.*"
  :ticlos (TYPEP x 'clos:class)
  :error-p nil)

;1(DEFUN generic-function-p-safe (x)*
;1"Is true if x is a generic function."*
;1  (OR (AND (pcl-p) (pcl:generic-function-p x))*
;1      (AND (ticlos-p) (ticlos:generic-function-p x))))*

(DEFUN 4generic-function-p-safe* (x)
  "2Is true if x is a generic function.*"
  (AND (ticlos-p) (ticlos::generic-function-p x)))

;1(DEFUN function-generic-function-safe (FUNCTION)*
;1"Returns the generic function object for the function function, where*
;1 function is a fef."*
;1  (IF (AND (pcl-p) (pcl::generic-function-p function))*
;1      function*
;1      (IF (AND (ticlos-p) (ticlos:generic-function-p function))*
;	1  (IF (TYPEP function 'ticlos:generic-function)*
;	1      function*
;	1      ;;; It is a fef.*
;	1      (ticlos:get-generic-function-object function))*
;	1  nil)))*

(DEFUN 4function-generic-function-safe* (FUNCTION)
  "2Returns the generic function object for the function function, where
 function is a fef.*"
  (IF (AND (ticlos-p) (ticlos::generic-function-p function))
      (IF (TYPEP function 'ticlos:generic-function)
	  function
	  ;1;; It is a fef.*
	  (ticlos::get-generic-function-object function))
      nil))

;1(DEFUN name-safe (x)*
;1"Reads the name slot of x if it has one.  This returns nil if X either isn't*
;1 an instance or doesn't have a Name slot."*
;1  (OR (CATCH-ERROR (slot-value-safe x 'pcl:name)    nil)*
;1      (CATCH-ERROR (slot-value-safe x 'ticlos:name) nil)*
;1      (CATCH-ERROR (generic-function-name-safe x) nil)))*

(DEFUN 4name-safe* (x)
"2Reads the name slot of x if it has one.  This returns nil if X either isn't
 an instance or doesn't have a Name slot.*"
  (OR (CATCH-ERROR (slot-value-safe x 'ticlos::name) nil)
      (CATCH-ERROR (generic-function-name-safe x) nil)))

;1(defsafe-gf-simple argument-precedence-order-safe (gf)*
;1  :documentation*
;1    "Returns the argument precedence order of the generic-function GF."*
;1  :both generic-function-argument-precedence-order)*

(defsafe-gf-simple 4argument-precedence-order-safe* (gf)
  :documentation
    "3Returns the argument precedence order of the generic-function GF.*"
  :ticlos generic-function-argument-precedence-order)

;1(defsafe-gf-simple generic-function-method-class-safe (gf)*
;1  :documentation "Returns the method class of a generic function."*
;1  :both generic-function-method-class)*

(defsafe-gf-simple 4generic-function-method-class-safe* (gf)
  :documentation "3Returns the method class of a generic function.*"
  :ticlos generic-function-method-class)

;1(defsafe-gf-simple generic-function-method-combination-safe (gf)*
;1  :documentation "Returns the method combination type of a generic function."*
;1  :both generic-function-method-combination)*

(defsafe-gf-simple 4generic-function-method-combination-safe* (gf)
  :documentation "3Returns the method combination type of a generic function.*"
  :ticlos generic-function-method-combination)

;1(defsafe-gf-simple generic-function-declarations-safe (gf)*
;1  :documentation "Returns any declarations made for the generic function GF."*
;1  :both generic-function-declare)*

(defsafe-gf-simple 4generic-function-declarations-safe* (gf)
  :documentation "3Returns any declarations made for the generic function GF.*"
  :ticlos generic-function-declare)

;1(defsafe class-local-supers-safe (class)*
;1  :documentation*
;1"Returns a list of the local superclasses of the class class.  If a class is*
;1 undefined then it returns a symbol that names the undefined class."*
;1  :pcl (pcl:class-local-supers class)*
;1  :ticlos*
;1  ;; This should be fixed when Forward-Referenced-Class is impemented.*
;1    (MAPCAR #'(lambda (x) (OR (class-named-safe x t) x))*
;	1    (ticlos:class-direct-supers class))*
;1;    (let ((old #'ticlos:class-named))*
;1;*	1 (letf ((#'ticlos:class-named*
;1;*		1 #'(lambda (name &optional no-error-p environment)*
;1;*		1     (ignore no-error-p)*
;1;*		1     (or (funcall old name t environment) name)*
;1;*		1   )*
;1;*		1)*
;1;*	1       )*
;1;*	1       (ticlos:class-direct-superclasses class)*
;1;*	1 )*
;1;    )*
;1    )*

(defsafe 4class-local-supers-safe* (class)
  :documentation
"3Returns a list of the local superclasses of the class class.  If a class is
 undefined then it returns a symbol that names the undefined class.*"
  :ticlos
  ;1; This should be fixed when Forward-Referenced-Class is impemented.*
    (MAPCAR #'(lambda (x) (OR (class-named-safe x t) x))
	    (ticlos::class-direct-supers class)))

;1(defsafe-simple method-generic-function-safe (method)*
;1  :documentation "Returns the generic function that names the method Method."*
;1  :both method-generic-function)*

(defsafe-simple 4method-generic-function-safe* (method)
  :documentation "3Returns the generic function that names the method Method.*"
  :ticlos method-generic-function)

;1(defsafe-simple class-direct-subclasses-safe (class)*
;1  :documentation*
;1  "Returns a list of the classes that are direct subclasses of the class Class."*
;1  :both class-direct-subclasses)*

(defsafe-simple 4class-direct-subclasses-safe* (class)
  :documentation
  "3Returns a list of the classes that are direct subclasses of the class Class.*"
  :ticlos class-direct-subclasses)

;1(DEFUN iwmc-class-p-safe (something)*
;1"Is true if something is iwmc-class-p (instance-with-metaclass-p)."*
;1  (IF (FBOUNDP 'pcl:iwmc-class-p)*
;1      (pcl:iwmc-class-p something)*
;1      nil))*

(DEFPARAMETER 4*cached-ticlos-class-names** nil
"2A list of the ticlos class names of the classes that have been found.  This
 Gets set if the user opts to do an exhaustive search for all ticlos classes.*")

;1**************
;1 TAC 07-27-89 - Rewrote all-class-names to take advantage of *
;1                TICLOS:*ALL-STANDARD-CLASS-NAMES**
;1                which David Gray made available in patch 17.4*

;1(defun all-class-names (&optional (cheep-p nil))*

;1(DEFUN all-class-names (&optional (cheep-p nil))*
;1"Returns a list of all of the class names."*
;1  (DECLARE (SPECIAL pcl:*class-name-hash-table*))*
;1  cheep-p ; prevents compiler complaint*
;1  (APPEND (IF (BOUNDP 'pcl:*class-name-hash-table*)*
;	1      (MAPHASH-RETURN #'(lambda (key &rest ignore) key)*
;			1      pcl:*class-name-hash-table*)*
;	1      nil)*
;	1  ticlos:*all-standard-class-names*))*

(DEFUN 4all-class-names* ()
"2Returns a list of all of the class names.*"
  ticlos::*all-standard-class-names*)

;1(DEFUN generic-function-name-safe (gf)*
;1  :documentation "Returns the name of the generic function GF."*
;1  (OR (CATCH-ERROR (ticlos:generic-function-name gf) nil)*
;1      (CATCH-ERROR (pcl:generic-function-name gf) nil)*
;1      (ticlos:generic-function-name gf)*
;1      (pcl:generic-function-name gf)))*

(DEFUN 4generic-function-name-safe* (gf)
  :documentation "3Returns the name of the generic function GF.*"
  (OR (CATCH-ERROR (clos:generic-function-name gf) nil)
      (clos:generic-function-name gf)))

;1-------------------------------------------------------------------------------*

(DEFTYPE 4ticlos-instance* ()
 "2The type which is true for instances of TICLOS classes.*" 
 `(satisfies ticlos-instance-p))

;1(DEFUN any-sort-of-clos-instance-p (x)*
;1"Is true if x is any sort of clos instance, be it PCL or TICLOS."*
;1  (OR (ticlos-instance-p x)*
;1      (iwmc-class-p-safe x)))*

(DEFUN 4any-sort-of-clos-instance-p* (x)
"2Is true if x is any sort of clos instance.*"
  (ticlos-instance-p x))

;1(DEFTYPE any-sort-of-clos-instance ()*
;1  "The type which is true for instances of either TICLOS or PCL classes."*
;1 `(satisfies any-sort-of-clos-instance-p))*

(DEFTYPE 4any-sort-of-clos-instance* ()
  "2The type which is true for instances of TICLOS classes.*"
 `(satisfies any-sort-of-clos-instance-p))

;1(defsafe standard-method-p-safe (x)*
;1  :documentation "Is true if x is a standard method."*
;1  :pcl    (TYPEP x 'pcl:standard-method)*
;1  :ticlos (TYPEP x 'ticlos:standard-method))*

(defsafe 4standard-method-p-safe* (x)
  :documentation "3Is true if x is a standard method.*"
  :ticlos (TYPEP x 'ticlos:standard-method))

;1(defsafe standard-generic-function-p-safe (x)*
;1  :documentation "Is true if x is a standard generic function."*
;1  :pcl    (TYPEP x 'pcl:standard-generic-function)*
;1  :ticlos (TYPEP x 'ticlos:standard-generic-function))*

(defsafe 4standard-generic-function-p-safe* (x)
  :documentation "3Is true if x is a standard generic function.*"
  :ticlos (TYPEP x 'ticlos:standard-generic-function))

;1(defsafe directly-standard-generic-function-p-safe (x)*
;1  :documentation*
;1"Is true if x is a standard generic function and not an instance of some*
;1 specialisation of standard generic function."*
;1  :pcl    (AND (CLOSUREP x) (TYPEP x 'pcl:standard-generic-function))*
;1  :ticlos (EQUAL (TYPE-OF x) 'ticlos:standard-generic-function))*

(defsafe 4directly-standard-generic-function-p-safe* (x)
  :documentation
"3Is true if x is a standard generic function and not an instance of some
 specialisation of standard generic function.*"
  :ticlos (EQUAL (TYPE-OF x) 'ticlos:standard-generic-function))

;1(DEFUN any-sort-of-clos-method-p (x)*
;1"Is true if x is either a PCL or a TICLOS method object."*
;1  (IF (iwmc-class-p-safe x)*
;1      (TYPEP x 'pcl:standard-method) ;;; JPR !!!*
;1      (IF (ticlos-p)*
;	1  (TYPEP x 'ticlos:method)*
;	1  nil)))*

(DEFUN 4any-sort-of-clos-method-p* (x)
  "2Is true if x is a TICLOS method object.*"
  (IF (ticlos-p)
      (TYPEP x 'ticlos:method)
      nil))

;1(DEFTYPE any-type-of-clos-method ()*
;1"The type that defines either PCL or TICLOS method objects."*
;1  `(satisfies any-sort-of-clos-method-p))*

(DEFTYPE 4any-type-of-clos-method* ()
"2The type that defines TICLOS method objects.*"
  `(satisfies any-sort-of-clos-method-p))

;1(DEFUN any-sort-of-clos-gf-p (x)*
;1"Is true if x is either a PCL or a TICLOS generic function object."*
;1  (OR (AND (pcl-p)*
;	1   (TYPEP x 'pcl:standard-generic-function))*
;1      (AND (ticlos-p)*
;	1   (TYPEP x 'ticlos:generic-function))))*

(DEFUN 4any-sort-of-clos-gf-p* (x)
"2Is true if x is a TICLOS generic function object.*"
      (AND (ticlos-p)
	   (TYPEP x 'ticlos:generic-function)))

;1(DEFTYPE any-type-of-clos-gf ()*
;1"The type that defines either PCL or TICLOS generic function objects."*
;1  `(satisfies any-sort-of-clos-gf-p))*

(DEFTYPE 4any-type-of-clos-gf* ()
"2The type that defines TICLOS generic function objects.*"
  `(satisfies any-sort-of-clos-gf-p))

;1(DEFUN fef-of-gf-p (x)*
;1"Is true if x is the fef that defines a generic function."*
;1  (OR (AND (pcl-p) (TYPEP x 'pcl:standard-generic-function))*
;1      (AND (ticlos-p) (function-generic-function-safe x))))*

(DEFUN 4fef-of-gf-p* (x)
  "2Is true if x is the fef that defines a generic function.*"
  (AND (ticlos-p) (function-generic-function-safe x)))

(DEFTYPE 4fef-of-gf* ()
"2The type that is true for fefs that are for generic functions.*"
  `(satisfies fef-of-gf-p))

(DEFUN 4is-a-class-name-not-flavor-class* (name)
"2Is true if Name is a symbol that names a class that does not have a flavor
 class declaration.  This is useful because it lets us view flavors as flavors
 even though they have flavor-class declarations.*"
  (AND (TYPEP name 'symbol)
       (FBOUNDP 'class-named-safe)
       (FUNCALL 'class-named-safe name t)
       (OR (NOT (GET name 'si::flavor))
	   (NOT (TYPE-SPECIFIER-P 'ticlos:flavor-class))
	   (AND (TYPE-SPECIFIER-P 'ticlos:flavor-class)
		(NOT (TYPEP (FUNCALL 'class-named-safe
				     name t)
			    'ticlos:flavor-class))))))

;1(defsafe-simple method-specializers-safe (method)*
;1  :documentation "Returns the list of method specializers for Method."*
;1  :ticlos method-specializers*
;1  :pcl method-type-specifiers)*

(defsafe-simple 4method-specializers-safe* (method)
  :documentation "3Returns the list of method specializers for Method.*"
  :ticlos method-specializers)

;1(defsafe-gf-simple compute-applicable-methods-safe (gf methods)*
;1  :documentation "Returns a list of the applicable methods for a generic*
;1function GF from a list of methods Methods."*
;1  :both compute-applicable-methods)*

(defsafe-gf-simple 4compute-applicable-methods-safe* (gf methods)
  :documentation 
  "3Returns a list of the applicable methods for a generic function GF from a list of methods Methods.*"
  :ticlos compute-applicable-methods)

;1(defsafe-gf compute-effective-method-safe*
;	1       (gf method-combination methods)*
;1  :documentation*
;1"Computes the code for the effective method of a generic function, using a*
;1 particular type of method combination and a list of effective methods."*
;1  :ticlos (ticlos:compute-effective-method gf method-combination methods)*
;1  :pcl (pcl:compute-effective-method-body gf methods))*

(defsafe-gf 4compute-effective-method-safe*
	       (gf method-combination methods)
  :documentation
"3Computes the code for the effective method of a generic function, using a
 particular type of method combination and a list of effective methods.*"
  :ticlos (ticlos:compute-effective-method gf method-combination methods))

;1(defsafe-simple class-prototype-safe (class)*
;1  :documentation "Returns the class prototype oc a class."*
;1  :both class-prototype)*

(defsafe-simple 4class-prototype-safe* (class)
  :documentation "3Returns the class prototype oc a class.*"
  :ticlos class-prototype)

(DEFVAR 4*method-combination-indent-increment** 2
"2The number of spaces to indent by each time the method combination display
 throws a newline and tabs for a sublist.*")

(DEFUN 4post-process-combined-method* (form &optional (indent 0))
"2Takes a form that (when ground) would appear as follows:
   (progn (sys:%apply-method before method 1)
          (sys:%apply-method before method 2)
          ...
          (sys:%apply-method before method n)
          (multiple-value-prog1
            (sys:%apply-method primary method)
            (sys:%apply-method after method 1)
            (sys:%apply-method after method 2)
            ...
            (sys:%apply-method after method n)))

 and transforms it into an inspector compatible item list that will
 look like:
   (progn <before method 1>
          <before method 2>
          ...
          <before method n>
          (multiple-value-prog1
            <primary method>
            <after method 1>
            <after method 2>
            ...
            <after method n>))

 where the things labeled <...> will appear as mouse-sensitive items of the
 type show-clos-method.m  The grindingf that this function does is very
 primitive.  Sub-lists are started on new lines indented by a few spaces
 (*method-combination-indent-increment*).*"
  (DECLARE (SPECIAL *this-line* *all-lines*))
  (IF (CONSP form)
      (IF (MEMBER (FIRST form)
		  ;1;* TAC 08-17-891 - remove pcl references *
		  ;1; *'(ticlos:call-method sys:%apply-method pcl:call-method))
		  '(ticlos:call-method sys::%apply-method))
	  (LET ((meth
		  (IF (EQUAL (FIRST form) 'sys::%apply-method)
		      (method-from-method-function-safe
			(FDEFINITION (SECOND (SECOND form))))
		      (SECOND form))))
	       (PUSH (REVERSE *this-line*) *all-lines*)
	       (SETQ *this-line* nil)
	       (PUSH `(,*space-format* ,indent) *this-line*)
	       (PUSH (IF meth
			 `(:item1 instance
				 ,(allocate-data
				    'show-clos-method
				    meth)
				  print-unpadded-method)
			 `(:font 1
			   ,(FORMAT nil "3~S*"
			     (FUNCTION-NAME
			       (FDEFINITION (SECOND (SECOND form)))))))
		     *this-line*))
	  (PROGN (PUSH (REVERSE *this-line*) *all-lines*)
		 (SETQ *this-line* nil)
		 (PUSH `(,*space-format* ,indent) *this-line*)
		 (PUSH '(:font 1 "3(*") *this-line*)
		 (MAPCAR #'(lambda (x)
			    (post-process-combined-method
			      x
			      (+ *method-combination-indent-increment* indent)))
			   form)
		 (PUSH '(:font 1 "3)*") *this-line*)))
      (IF form (PUSH `(:font 1 ,(SYMBOL-NAME form)) *this-line*) nil)))

(DEFUN 4clean-up-method* (method)
"2Just makes sure that the method body doesn't have a boring definition for
 apply method at the front.*"
  (IF (EQUAL (FIRST method) 'MACROLET)
      (clean-up-method (REST (REST method)))
      method))

(DEFUN 4method-combination-of-method-safe* (method)
"2Returns the list of method combination type for Method.*"
  (CATCH-ERROR ;1; This catches things like eql specializers.*
    (LET ((methods (compute-applicable-methods-safe
		     (method-generic-function-safe method)
		     (MAPCAR #'(lambda (x)
				 (IF (TYPEP x 'ticlos:built-in-class)
				     t
				     (class-prototype-safe x)))
			       (method-specializers-safe method)))))
	 (LET ((code (compute-effective-method-safe
		       (method-generic-function-safe method)
		       (generic-function-method-combination-safe
			 (method-generic-function-safe method))
		       methods)))
	      (LET ((form (clean-up-method code)))
		   (LET ((*this-line* nil)
			 (*all-lines* nil))
			(DECLARE (SPECIAL *this-line* *all-lines*))
			(post-process-combined-method
			  (IF (EQUAL (LENGTH form) 1)
			      (FIRST form)
			      form))
			(PUSH (REVERSE *this-line*) *all-lines*)
			(LET ((result (REVERSE (REMOVE nil *all-lines*))))
			     result)))))
    nil))

;1(defsafe-simple slot-boundp-safe (instance slot)*
;1  :documentation "Is true if the slot Slot is bound in the instance Instance."*
;1  :both slot-boundp)*

(defsafe-simple 4slot-boundp-safe* (instance slot)
  :documentation "3Is true if the slot Slot is bound in the instance Instance.*"
  :ticlos slot-boundp)

(DEFUN 4method-from-generic-function-using-method-function* (fef gf)
"2Given a method function and a generic function, returns the method object that
 has the method function Fef.*"
  (LET ((methods (generic-function-methods-safe gf)))
       (FIND-IF #'(lambda (method)
		    (EQUAL fef (method-function-safe method)))
		  methods)))

(DEFUN 4method-from-method-function-safe* (fef)
"2Given a method function returns the method object for it.*"
  (LET ((first-try (sys:get-debug-info-field (sys:get-debug-info-struct fef)
					     :method)))
       (OR first-try
	   (method-from-generic-function-using-method-function
	     fef (function-generic-function-safe
		   (fdefinition-safe (SECOND (FUNCTION-NAME fef)))))
	   (FERROR nil "3Can't get a method from ~S*" fef))))
;1-------------------------------------------------------------------------------*
;1**************
;1 TAC 07-27-89 - moved to INSPECT.LISP *
;1;; Abstracted out of TI definition of inspect-setup-object-display-list.*
;1(defun generic-object-foo-method (for-object)*

;1;;; Abstracted out of TI definition of inspect-setup-object-display-list.*
;1(defun inspect-object-display-list (object window)*

;1(defun inspect-setup-object-display-list*
;1       (object window &optional top-item label &aux str)*
;1-------------------------------------------------------------------------------*

;1(DEFUN (:property clos-slot set-function)*
;1       (item new-value object)*
;1  (LET ((slot (THIRD (SECOND item))))*
;1       (IF (iwmc-class-p-safe object)*
;	1   ;; Use Eval here to make completely sure that there are no*
;	1   ;; macro-expansion dependencies for compilation of this file.*
;	1   ;; We don't want to have to load PCL just to compile this function.*
;	1   (EVAL `(SETF (pcl:slot-value    ,object ',slot) ,new-value))*
;	1   (EVAL `(SETF (ticlos:slot-value ,object ',slot) ,new-value)))))*

(DEFUN 4(:property clos-slot set-function*)
       (item new-value object)
  (LET ((slot (THIRD (SECOND item))))
    (EVAL `(SETF (ticlos:slot-value ,object ',slot) ,new-value))))

;1; Slot names are only mouse sensitive when they're being modified.*
(DEFPROP 4clos-slot* t only-when-modify)

(DEFMETHOD 4(basic-inspect :object-clos-instance*) (obj &aux result)
"2The itemiser method for clos instances.*"
  (SETQ result (display-in-inspector obj result))
  (VALUES (NREVERSE result) obj 'inspect-printer))

(DEFPARAMETER 4*clos-inspect-tab-width** 30.
"2The default width to tab to when displaying clos instances.  This should give
 enough room for most slot names.*")

(DEFUN 4inspect-slots* (me title slots result &aux (maxlength 0))
"2Generates an item list for the Slots of the instance Me, with title Title.
 Result is the list that we'll be collecting into.  It may already have
 had stuff put into it.*"
  (DOLIST (c slots)
    (SETQ maxlength (MAX (FLATSIZE c) maxlength)))
  (SETQ maxlength (MIN *clos-inspect-tab-width* maxlength))
  (PUSH `((:font 1 ,title)) result)
  (PUSH '("") result)
  (DOLIST (c slots)
    (PUSH `((:item1 clos-slot ,(slotd-name-safe c)
		    ,#'(lambda (name stream) (FORMAT stream "3~S*" name)))
	    (:colon ,(+ 2 maxlength))
	    ;1; Try to be really careful here.  Lots of catch-errors and such.*
	    ;1; The last thing we want is for the Inspector to lock up*
	    ;1; whilst looking at/printing slots and their values.*
	   ,(MULTIPLE-VALUE-BIND (BOUNDP error-p)
		(CATCH-ERROR (slot-boundp-safe me (slotd-name-safe c)) nil)
	      (IF error-p
		 '(:font 2 "3Error reading slot*")
		  (IF boundp
		      (MULTIPLE-VALUE-BIND (value error-p)
			  (CATCH-ERROR
			    (slot-value-safe me (slotd-name-safe c)) nil)
			(IF error-p
		           `(:font 2
			     "3Some error happened whilst reading this slot.*")
			   `(:item1 named-structure-value ,value)))
		     '(:font 2 "3unbound*")))))
	   result))
  (PUSH '("") result)
  result)

;1-------------------------------------------------------------------------------*

;1(DEFUN display-in-inspector (me result)*
;1"Generates a complete item list for the instance Me and collects it all into*
;1 Result, which is returned."*
;1  (LET* ((class (class-of-safe me))*
;	1 (instance-slots (class-instance-slots-safe class))*
;	1 (non-instance-slots (class-non-instance-slots-safe class)))*
;1    (PUSH `(,(IF (ticlos-instance-p me)*
;		1 "CLOS instance of "*
;		1 "CLOS (PCL) instance of ")*
;	1    (:item1 instance*
;		1    ,(allocate-data 'show-clos-class (class-of-safe me))))*
;	1   result)*
;1    (PUSH '("") result)*						
;1    (WHEN (NOT (NULL non-instance-slots))*
;1      (SETQ result*
;	1    (inspect-slots me "Shared Slots:"*
;			1   non-instance-slots result))*
;1      (PUSH '("") result))*
;1    (WHEN (NOT (NULL instance-slots))*
;1      (SETQ result*
;	1    (inspect-slots me "Local Slots:"*
;			1   instance-slots result)))*
;1    result))*

(DEFUN 4display-in-inspector* (me result)
"2Generates a complete item list for the instance Me and collects it all into
 Result, which is returned.*"
  (LET* ((class (class-of-safe me))
	 (instance-slots (class-instance-slots-safe class))
	 (non-instance-slots (class-non-instance-slots-safe class)))
    (PUSH `("3CLOS instance of *"
	    (:item1 instance
		    ,(allocate-data 'show-clos-class (class-of-safe me))))
	   result)
    (PUSH '("") result)						
    (WHEN (NOT (NULL non-instance-slots))
      (SETQ result
	    (inspect-slots me "3Shared Slots:*"
			   non-instance-slots result))
      (PUSH '("") result))
    (WHEN (NOT (NULL instance-slots))
      (SETQ result
	    (inspect-slots me "3Local Slots:*"
			   instance-slots result)))
    result))

;1-------------------------------------------------------------------------------*

;1;; Temporary fixes?? !!!!! JPR.*

;1(DEFUN pcl:class-finalized-p (class)*
;1  (IGNORE class)*
;1  nil)*

;1(DEFUN pcl:class-direct-slots (class)*
;1  (pcl:class-slots class))*

;1(DEFUN pcl:slotd-accessors (slotd)*
;1  (IGNORE slotd)*
;1  nil)*

;1(DEFUN pcl:generic-function-method-combination (gf)*
;1  (IGNORE gf)*
;1  :standard)*

;1(DEFUN pcl:generic-function-argument-precedence-order (gf)*
;1  (ARGLIST (get-fef-from-object gf)))*

;1(DEFUN pcl:generic-function-declare (gf)*
;1  (IGNORE gf)*
;1  nil)*

;1(DEFUN pcl:class-of-generic-function (gf)*
;1  (IGNORE gf)*
;1  (class-named-safe 'pcl:standard-generic-function))*

;1-------------------------------------------------------------------------------*

;1(EVAL-WHEN (COMPILE load eval)*
;1  (IF (NOT (GET 'pcl:iwmc-class 'sys:defstruct-description))*
;1      ;; Make a dummy definition for iwmc-class so that we can defined methods*
;1      ;; on it, even if we don't have PCL loaded.*
;1      (EVAL '(DEFSTRUCT (pcl:iwmc-class)*
;	1       (pcl:class-wrapper nil)*
;	1       (pcl:static-slots nil)))*
;1      nil))*

;1(ticlos:defmethod documentation ((thing pcl:iwmc-class) &optional doc-type)*
;1  (IGNORE doc-type)*
;1  (TYPECASE thing*
;1    (pcl:standard-slot-description (pcl:slotd-documentation thing))*
;1    (pcl:standard-class*
;1     (SECOND (ASSOC :documentation (pcl:class-options thing))))*
;1    (pcl:standard-method (pcl:method-documentation thing))*
;1    (otherwise nil)))*

;1**************
;1 TAC 07-26-89 ----- moved from TI-ENV-FLAVOR-INSPECTOR-INTERFACE ---------*

(DEFUN 4my-subtypep* (a b)
"2Like subtypep, only it works for classes as well as symbols.*"
  (LET ((name-a (IF (class-p-safe a) (class-name-safe a) a))
	(name-b (IF (class-p-safe b) (class-name-safe b) b)))
      (OR (SUBTYPEP name-a name-b)
	  (CATCH-ERROR (subclassp-safe (coerce-to-class a) (coerce-to-class b))
		       nil))))
    
(DEFUN 4class-shadows* (class1 class2)
"2Is true if Class1 shadows Class2, i.e. if class1 is not class2, but class2
 is subtypep of class1.  This allows us to compute which primary methods
 are being shadowed.  If the classes are known to be disjoint then it returns
 :disjoint.*"
  (IF (AND class1 class2
	   (NOT (EQUAL class1 class2)))
      (IF (my-subtypep class1 class2)
	  t
	  (IF (my-subtypep class2  class1)
	      nil
	      :disjoint))
      nil))
;1 -------------------------------------------------------------------------*

(DEFUN 4class-matches-p* (specs1 specs2 so-far)
"2Is true if the method spec spec1 for a method class-matches the method
 defined by spec2.  So-far accumulates whether we currently think that
 they match.*"
  (IF specs1
      (IF specs2
	  (LET ((class-matches
		  (OR (EQUAL (FIRST specs2) (FIRST specs1))
		      (class-shadows (FIRST specs2) (FIRST specs1)))))
	       (IF (OR (EQUAL :disjoint class-matches) (NOT class-matches))
		   nil
		   (class-matches-p (REST specs1) (REST specs2)
				    (OR class-matches so-far))))
	  so-far)
      so-far))

;1;; Supplied by David Gray.*
(DEFUN 4handlesp* (generic-function &rest arguments)
  (LET* ((defn generic-function)
	 (gfun
	   (COND
	     ((sys:typep-structure-or-flavor defn 'generic-function) defn)
	     ((ticlos::generic-function-p defn)
	      (ticlos::get-generic-function-object defn))
	     ((FUNCTIONP defn) (RETURN-FROM handlesp defn))
	     (t (ERROR "3~S is not a function.*" generic-function))))
	 (mloc
	   (APPLY #'ticlos::find-right-method
		  (OR (ticlos::generic-function-method-hash-table gfun)
		      (PROGN (ticlos::build-method-hash-table gfun)
			     (ticlos::generic-function-method-hash-table gfun)))
		  (ticlos::reorder-parameter-specializers gfun arguments))))
    (OR (CONTENTS mloc)
	(VALUES (ticlos::find-handler
		  gfun
		  (MAPCAR #'ticlos:class-of
			  (ticlos::reorder-parameter-specializers
			    gfun arguments))) ))))

(DEFUN 4handlers-for* (gf &rest classes)
"2Given a generic function and a list of classes it returns all of the methods
 that it thinks will handle the GF if called with those args.*"
  (LET ((methods (generic-function-methods-safe
		   (function-generic-function-safe (get-fef-from-object gf)))))
       (REMOVE (sys:get-debug-info-field
		 (sys:get-debug-info-struct
		   #'(ticlos:method ticlos:print-object (t t)))
		 :method)
	       (REMOVE-IF-NOT
		#'(lambda (x)
		    (class-matches-p (unparse-specializers-safe x) classes t))
		  methods))))

;1(handlers-for #'ticlos:print-object 'ticlos:standard-object)*
;1(handlers-for #'ticlos:print-object 'ticlos:standard-class)*
;1(handlers-for #'ticlos:print-object 'lexical-closure)*
;1(handlers-for #'ticlos:print-object 'closure)*

(DEFUN 4print-pointer* (of stream)
  (LET ((*print-base* 8.)
	(*print-radix* nil)
	(*nopoint t))
       (FORMAT stream "3~A*" (%pointer of))))

;1(ticlos:defmethod ticlos:print-object ((thing lexical-closure) stream)*
;1  (IF (generic-function-p-safe thing)*
;1      (FORMAT stream "#<PCL Generic-function ~s ~A>"*
;	1      (generic-function-name-safe thing) (print-pointer thing nil))*
;1      (FORMAT stream "#<~A ~A>"*
;	1      (STRING (DATA-TYPE thing))*
;	1      (print-pointer thing nil))))*

(ticlos:defmethod ticlos:print-object ((thing lexical-closure) stream)
  (FORMAT stream "3#<~A ~A>*"
	  (STRING (DATA-TYPE thing))
	  (print-pointer thing nil)))

;1**************
;1 TAC 08-07-89 - current kernel function is sufficient. See sys:kernel;who-calls.lisp *
;1                5/2/89 DNG - Updated to recognize and scan SETF and LOCF functions.*
;1;; Generalisation of the Who-Calls fix that I gave DG.*
;1sys:*
;1(defun sys:find-callers-of-symbols-aux (caller symbol function)*
;1-------------------------------------------------------------------------------*

;1**************
;1 TAC 08-01-89 - moved this into INSPECT.LISP where it belongs.*
;1;; Redefine this so that we have :middle-button-result as a new required method.*
;1(DEFFLAVOR inspection-data (data) ()
*;1-------------------------------------------------------------------------------