/*                                                                       */
/*                                                                       */
/*                      RESTRICTED RIGHTS LEGEND                         */
/*                                                                       */
/* Use, duplication, or disclosure by the Government is subject to       */
/* restrictions as set forth in subdivision (c)(1)(ii) of the Rights in  */
/* Technical Data and Computer Software clause at 252.227-7013.          */
/*                                                                       */
/*                    TEXAS INSTRUMENTS INCORPORATED.                    */
/*                            P.O. BOX 149149                            */
/*                         AUSTIN, TEXAS 78714-9149                      */
/*                              MS 2151                                  */
/*                                                                       */
/*  Copyright (C)   1987,1988,1989,1990 Texas Instruments Incorporated.  */
/*  All rights reserved.                                                 */
/*                                                                       */
/*
 * Sun RPC is a product of Sun Microsystems, Inc. and is provided for
 * unrestricted use provided that this legend is included on all tape
 * media and as a part of the software program in whole or part.  Users
 * may copy or modify Sun RPC without charge, but are not authorized
 * to license or distribute it to anyone else except as part of a product or
 * program developed by the user.
 * 
 * SUN RPC IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
 * WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 * 
 * Sun RPC is provided with no support and without any obligation on the
 * part of Sun Microsystems, Inc. to assist in its use, correction,
 * modification or enhancement.
 * 
 * SUN MICROSYSTEMS, INC. SHALL HAVE NO LIABILITY WITH RESPECT TO THE
 * INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY SUN RPC
 * OR ANY PART THEREOF.
 * 
 * In no event will Sun Microsystems, Inc. be liable for any lost revenue
 * or profits or other special, indirect and consequential damages, even if
 * Sun has been advised of the possibility of such damages.
 * 
 * Sun Microsystems, Inc.
 * 2550 Garcia Avenue
 * Mountain View, California  94043
 */
#ifndef lint
static char sccsid[] = "@(#)clnt_perror.c 1.1 86/02/03 Copyr 1984 Sun Micro";
#endif

/*
 * clnt_perror.c
 *
 * Copyright (C) 1984, Sun Microsystems, Inc.
 *
 */
#include "rpc-types.h"
#include "xdr.h"
#include "auth.h"
#include "clnt.h"
#include "rpc_msg.h"
#include <stdio.h>
/*
extern char *sys_errlist[];
*/

/*
 * Print reply error info
 */
void
clnt_perror(rpch, s)
	CLIENT *rpch;
	char *s;
{
#pragma unused(s)			/* 11/22/89 sbw */
	struct rpc_err e;
	void clnt_perrno();

	CLNT_GETERR(rpch, &e);
	printf("clnt_perror: error occured\n");
	switch (e.re_status) {
		case RPC_SUCCESS:
		case RPC_CANTENCODEARGS:
		case RPC_CANTDECODERES:
		case RPC_TIMEDOUT:
		case RPC_PROGUNAVAIL:
		case RPC_PROCUNAVAIL:
		case RPC_CANTDECODEARGS:
			clnt_perrno(e.re_status);
			break;
		case RPC_CANTSEND:
			clnt_perrno(e.re_status);
			printf("RPC cannot send\n");
			break;
	
		case RPC_CANTRECV:
			clnt_perrno(e.re_status);
			printf("RPC cannot receive\n");
			break;
	
		case RPC_VERSMISMATCH:
			clnt_perrno(e.re_status);
			printf("clnt_perror:RPC version mismatch\n");
			break;
	
		case RPC_AUTHERROR:
			clnt_perrno(e.re_status);
			printf("clnt_perror: RPC auth error\n");
			switch (e.re_why) {
			case AUTH_OK:
				printf("AUTH_OK");
				break;
	
			case AUTH_BADCRED:
				printf("AUTH_BOGUS_CREDENTIAL");
				break;
	
			case AUTH_REJECTEDCRED:
				printf("AUTH_REJECTED_CREDENTIAL");
				break;
	
			case AUTH_BADVERF:
				printf("AUTH_BOGUS_VERIFIER");
				break;
	
			case AUTH_REJECTEDVERF:
				printf("AUTH_REJECTED_VERIFIER");
				break;
	
			case AUTH_TOOWEAK:
				printf("AUTH_TOO_WEAK (remote error)");
				break;
	
			case AUTH_INVALIDRESP:
				printf("AUTH_INVALID_RESPONSE");
				break;
	
			default:
				printf("AUTH_UNKNOWN_FAILURE");
				break;
			}
			break;
	
		case RPC_PROGVERSMISMATCH:
			clnt_perrno(e.re_status);
			printf("RPC program version mismatch\n");
			break;
	
		default:
			printf("RPC_UNKNOWN_FAILURE\n");
			break;
	}
	printf("\n");
}

/*
 * This interface for use by clntrpc
 */
void
clnt_perrno(num)
	int num;      /* clm 10/16/89 - no longer use the enum clnt_stat type */
{
	switch (num) {
		case RPC_SUCCESS:
			printf("RPC_SUCCESS");
			break;
	
		case RPC_CANTENCODEARGS:
			printf("RPC_CANT_ENCODE_ARGS");
			break;
	
		case RPC_CANTDECODERES:
			printf("RPC_CANT_DECODE_RESULTS");
			break;
	
		case RPC_CANTSEND:
			printf("RPC_CANT_SEND");
			break;
	
		case RPC_CANTRECV:
			printf("RPC_CANT_RECV");
			break;
	
		case RPC_TIMEDOUT:
			printf("RPC_TIMED_OUT");
			break;
	
		case RPC_VERSMISMATCH:
			printf("RPC_VERSION_MISMATCH");
			break;
	
		case RPC_AUTHERROR:
			printf("RPC_AUTH_ERROR");
			break;
	
		case RPC_PROGUNAVAIL:
			printf("RPC_REMOTE_PROGRAM_UNAVAILABLE");
			break;
	
		case RPC_PROGVERSMISMATCH:
			printf("RPC_PROGRAM_MISMATCH");
			break;
	
		case RPC_PROCUNAVAIL:
			printf("RPC_UNKNOWN_PROCEDURE");
			break;
	
		case RPC_CANTDECODEARGS:
			printf("RPC_CANT_DECODE_ARGS");
			break;
		case RPC_UNKNOWNHOST:
			printf("RPC_UNKNOWNHOST");
			break;
		case RPC_PMAPFAILURE:
			printf("RPC_PMAP_FAILURE");
			break;
		case RPC_PROGNOTREGISTERED:
			printf("RPC_PROG_NOT_REGISTERED");
			break;
		case RPC_SYSTEMERROR:
			printf("RPC_SYSTEM_ERROR");
			break;
	}
}

/*
 * A handle on why an rpc creation routine failed (returned NULL.)
 */
struct rpc_createerr rpc_createerr;

clnt_pcreateerror(s)
	char *s;
{
#pragma unused(s)			/* 11/22/89 sbw */

	printf("clnt_pcreateerror: error occured\n");
	clnt_perrno(rpc_createerr.cf_stat);
	switch (rpc_createerr.cf_stat) {
		case RPC_PMAPFAILURE:
			printf(" - ");
			clnt_perrno(rpc_createerr.cf_error.re_status);
			break;

		case RPC_SYSTEMERROR:
			printf("RPC system error\n");
			break;

	}
	printf("\n");
}
