/* -*- Mode:C; Tab-width:4 -*- */

/*                                                                       */
/*                                                                       */
/*                      RESTRICTED RIGHTS LEGEND                         */
/*                                                                       */
/* Use, duplication, or disclosure by the Government is subject to       */
/* restrictions as set forth in subdivision (c)(1)(ii) of the Rights in  */
/* Technical Data and Computer Software clause at 252.227-7013.          */
/*                                                                       */
/*                    TEXAS INSTRUMENTS INCORPORATED.                    */
/*                            P.O. BOX 149149                            */
/*                         AUSTIN, TEXAS 78714-9149                      */
/*                              MS 2151                                  */
/*                                                                       */
/*  Copyright (C)   1987,1988,1989,1990 Texas Instruments Incorporated.  */
/*  All rights reserved.                                                 */
/*                                                                       */

#include <addincomm.h>
#include <micronet-device.h>

/*

  Some functions to facilitate RPC in the driver. 

*/

/* 10/30/89 clm for SBW - Modified rpc_shutdown to use opcode 14 instead of 15. */
/*                        The micronet channel was not getting shutdown correctly. */

rpc_init()
{
	extern unsigned char in_driver_p;
    socket_initialize();
	if(in_driver_p)
	  portmap_initialize();

	return 0;
}

rpc_shutdown()
{
	extern unsigned short trap_channel;
	if(trap_channel)
	  {
		  acb *cmd = get_acb_fast(1);
		  set_opcode(cmd, 14);  /* clm 10/30/89 - changed opcode to 14 */ 
		  set_subopcode(cmd, 1);
		  set_parm_8b(cmd, 0, trap_channel);
		  transmit_packet(cmd, MISC_CHANNEL);
		  trap_channel = 0;
	  }
	return 0;
}

extern void handle_traps();
extern void mx_launch();
extern void rpc_command();

#define MAX_RPC_OPCODE 2
static void 
(*rpc_handlers[])(cmd) =
{
  handle_traps,     	/* 0  */
  mx_launch,            /* 1  */
  rpc_command           /* 2  */
};

void
rpc_handler(cmd)
	 acb *cmd;
{		
    unsigned char op = opcode(cmd);
  
    if((op <= MAX_RPC_OPCODE) && rpc_handlers[op]) 
      (*rpc_handlers[op])(cmd);

	/* This is a kludge to keep from returning rpc packets twice. */
	if(op != 2)
	  return_acb_server(cmd);
  
}

static void
rpc_command(pkt)
     char *pkt;
{
	extern int select_word;
	socket_command(pkt);
	if(select_word)
	  svc_run();
}

