;;;
;;; raven-variables.lisp
;;;
;;; Assorted variables.
;;;

(defvar *microstack* (make-array '(64) :element-type '(unsigned-byte 32)
				:initial-element 0)
  "Micro-stack data storage.")

(defvar *pdl-buffer* (make-array '(#x400) :element-type '(unsigned-byte 32)
				 :initial-element 0))

(defvar *level-1-map* (make-array '(#x1000) :element-type '(unsigned-byte 32)
				  :initial-element 0)
  "Level-1 Memory Map storage")

(defvar *level-2-control* (make-array '(#x1000)
				      :element-type '(unsigned-byte 32)
				      :initial-element 0)
  "Level-2 Memory Map Control storage")

(defvar *level-2-address* (make-array '(#x1000)
				      :element-type '(unsigned-byte 32)
				      :initial-element 0)
  "Level-2 Memory Map Address storage")

(defvar *d-memory* (make-array '(#x1000) :element-type '(unsigned-byte 32)
			       :initial-element 0)
  "Dispatch memory storage")

(defvar *microstack-pointer* 0 "Micro-stack pointer")
(defvar *memory-data* 0)
(defvar *virtual-memory-address* 0)
(defvar *q-register* 0 "The Q register.")
(defvar *pdl-buffer-pointer* 0)
(defvar *pdl-buffer-index* 0)
(defvar *location-counter* 0)
(defvar *macroinstruction-buffer* 0 "Here come the Men In Black!")
(defvar *dispatch-constant* 0 "I-Arg?")

(defvar *micro-instruction-pointer* 0
  "Index of next microinstruction to read")

(defvar *last-micro-instruction-pointer* 0
  "Index of last microinstruction read")

(defvar *inhibit-micro-execution* nil
  "Flag for if the next microinstruction should be ignored.")

(defvar *next-micro-instruction* 0
  "Next microinstruction to execute")

(defvar *micro-instruction-trace* t
  "Flag to enable/disable disassembly of microinstructions during step")

(defvar *page-fault* nil "T if last memory/map access caused a page fault.")


;;; EOF
