;;; -*- cold-load:t; Mode:Common-Lisp; Package:SI; Base:10 -*-

;;;                           RESTRICTED RIGHTS LEGEND

;;;Use, duplication, or disclosure by the Government is subject to
;;;restrictions as set forth in subdivision (c)(1)(ii) of the Rights in
;;;Technical Data and Computer Software clause at 52.227-7013.
;;;
;;;                     TEXAS INSTRUMENTS INCORPORATED.
;;;                              P.O. BOX 2909
;;;                           AUSTIN, TEXAS 78769
;;;                                 MS 2151
;;;
;;; Copyright (C) 1985-1989 Texas Instruments Incorporated. All rights reserved.
;	** (c) Copyright 1980 Massachusetts Institute of Technology **






(DEFVAR READ-DISCARD-FONT-CHANGES NIL
  "T means input stream contains 's that signify font changes.
READ ignores the font information.")

(DEFVAR READ-CHECK-INDENTATION NIL
  "If T, do not allow an internal list to start in column 0.
It will get a SYS:MISSING-CLOSEPAREN error.  If you proceed
with :NO-ACTION, closeparens will be invented and then the
openparen will be re-read.")

(ADD-INITIALIZATION 'READ-CHECK-INDENTATION
		    '(SETQ READ-CHECK-INDENTATION NIL 
			   READ-DISCARD-FONT-CHANGES NIL
			   )
		    '(:WARM))

(DEFUN READ-FOR-TOP-LEVEL (&REST READ-ARGS)
  "Similar to READ, but ignores stray closeparens and ignores end of file.
Interactive command loops such as the lisp listener use this function."
  (MULTIPLE-VALUE-BIND (STREAM EOF-OPTION)
      (DECODE-READ-ARGS READ-ARGS)
    (INTERNAL-READ STREAM NIL EOF-OPTION NIL NIL T)))

(DEFUN global:READ (&REST READ-ARGS)
  "Read an s-expression from a stream and return it.
The args are the STREAM and an EOF-OPTION, in either order.
The EOF-OPTION is recognized as anything that is not a reasonable stream.
It is what will be returned if end of file is encountered.
If there is no EOF-OPTION, end of file is an error.
READ gets an error if an extraneous closeparen or dot is found.
Command loops should use READ-FOR-TOP-LEVEL instead, to discard them."
  (MULTIPLE-VALUE-BIND (STREAM EOF-OPTION)
      (DECODE-READ-ARGS READ-ARGS)
    (INTERNAL-READ STREAM (EQ EOF-OPTION 'NO-EOF-OPTION) EOF-OPTION NIL NIL)))

(DEFUN READ-CHECK-INDENTATION (&REST READ-ARGS)
  "Read an s-expression from a stream and return it, requiring proper indentation.
We assume that all open parens in column zero are supposed
to be top-level lists, except that EVAL-WHEN's, etc, may surround them.
/(Symbols such as EVAL-WHEN should have a SI:MAY-SURROUND-DEFUN property).
If an open paren is encountered in column 0 and is not top level,
closeparens are imagined so as to close off enough pending lists
to make the data valid.  End of file closes off all pending lists.
In either case, the SYS:MISSING-CLOSEPAREN condition is signaled,
with an argument that is T for end of file, NIL for open paren encountered."
  (MULTIPLE-VALUE-BIND (STREAM EOF-OPTION)
      (DECODE-READ-ARGS READ-ARGS)
    (INTERNAL-READ STREAM (EQ EOF-OPTION 'NO-EOF-OPTION) EOF-OPTION NIL NIL NIL T)))

(DEFUN READ-RECURSIVE (&OPTIONAL (STREAM *STANDARD-INPUT*))
  "Readmacros that wish to read an expression should use this funtion instead of READ."
  (INTERNAL-READ STREAM T NIL T))







