1;;; -*- *cold-load:t; 1Mode:Common-Lisp; Package:SYSTEM-INTERNALS; Fonts:(CPTFONT CPTFONTB); Base:10. -*-

;;;                           RESTRICTED RIGHTS LEGEND

;;;Use, duplication, or disclosure by the Government is subject to
;;;restrictions as set forth in subdivision (c)(1)(ii) of the Rights in
;;;Technical Data and Computer Software clause at 52.227-7013.

;;;                     TEXAS INSTRUMENTS INCORPORATED.
;;;                              P.O. BOX 2909
;;;                           AUSTIN, TEXAS 78769
;;;                                 MS 2151

;;; Copyright (C) 1986-1989 Texas Instruments Incorporated. All rights reserved.*

;; 11/12/86 DNG - Moved definition of DEFSUBST to new file FUNCTION-MACROS.
;;		Updated SUBST-EXPAND.
;;  3/02/88 DNG - Modified SUBST-EXPAND-1 to return two values and not loop 
;;		forever when the interpreted definition has been deleted, 
;;		and renamed it to SUBST-EXPANDER.


;;; (DEFSUBST FOO (X) (AR-1 X 5)) is like a similar DEFUN
;;; except that the definition of FOO will be substituted in at compile time
;;; and FOO's argument variables eliminated by substitution.
;;; It is your responsibility to make sure that FOO's args
;;; are evaluated exactly once, in the right ordr, in FOO's body,
;;; and that the symbols used for the args do not appear except
;;; to represent the args.

;;; DEFSUBST itself is now defined in the FUNCTION-MACROS file.

(DEFUN SUBST-EXPANDER (form)
  (DECLARE (VALUES EXPANSION EXPANDED-FLAG))
  (LET ((subst (CAR form))
	simple-substitution-ok)
    (DO-FOREVER
      (TYPECASE subst
	(null ; interpreted definition may have been deleted by SYS:BAND-CLEANER.
	 (RETURN-FROM SUBST-EXPANDER (VALUES form NIL)))
	(symbol (SETQ subst (DECLARED-DEFINITION subst)))
	(compiled-function
	 (LET ((di (GET-DEBUG-INFO-STRUCT  subst)))	;
	   (SETQ simple-substitution-ok (NOT (GET-DEBUG-INFO-FIELD di :NO-SIMPLE-SUBSTITUTION))
		 subst (GET-DEBUG-INFO-FIELD di :INTERPRETED-DEFINITION))))
	(T (RETURN))))
    (VALUES (SUBST-EXPAND SUBST FORM SIMPLE-SUBSTITUTION-OK)
	    T)))

;; Expand a call to a SUBST function.  SUBST is the function definition to use.
;; FORM is the whole form.
;; Match the SUBST args with the expressions in the form
;; and then substitute the expressions for the args in the body of the function with SUBLIS.
(DEFUN SUBST-EXPAND (SUBST FORM &OPTIONAL SIMPLE-SUBSTITUTION-OK)
  ;; 11/12/86 DNG - Use PARSE-BODY instead of EXTRACT-DECLARATIONS.  Delete
  ;;		kludge for eliminating BLOCK since DEFSUBST doesn't include one anymore.
  (LET (ALIST OPTIONAL-FLAG REST-ALREADY-FLAG LAMBDA-LIST BODY FN-NAME)
    ;; Extract the lambda-list, body, and function name from the definition.
    (COND ((or (EQ (CAR SUBST) 'global:NAMED-SUBST)
	       (eq (car subst) 'named-subst))
	   (SETQ LAMBDA-LIST (CADDR SUBST) BODY (CDDDR SUBST))
	   (SETQ FN-NAME (COND ((SYMBOLP (CADR SUBST)) (CADR SUBST))
			       (T (CAADR SUBST)))))
	  (T (SETQ LAMBDA-LIST (CADR SUBST) BODY (CDDR SUBST)
		   FN-NAME (CAR FORM))))
    ;; Discard documentation string or declarations from front of body.
    (SETQ BODY (PARSE-BODY BODY NIL T))
    ;; Provide an implicit PROGN for the body.
    (COND ((CDR BODY) (SETQ BODY `(PROGN . ,BODY)))
	  (T (SETQ BODY (CAR BODY))))
    ;; Process the lambda list and args to make the alist.
    (DO ((VALS (CDR FORM) (CDR VALS)))
	(NIL)
      ;; We allow only &OPTIONAL, &REST and &EXTENSION.
      (DO-FOREVER
	(CASE (CAR LAMBDA-LIST)
	  (&OPTIONAL (SETQ OPTIONAL-FLAG T))
	  (&REST (OR REST-ALREADY-FLAG
		     (SETQ VALS (LIST (CONS 'LIST VALS))
			   REST-ALREADY-FLAG T)))
	  (&EXTENSION)
	  (OTHERWISE (RETURN)))
	(POP LAMBDA-LIST))
      ;; All lambda-list keywords aside from &OPTIONAL, &REST and &EXTENSION are erroneous.
      (AND (MEMBER (CAR LAMBDA-LIST) LAMBDA-LIST-KEYWORDS :TEST #'EQ)
	   (RETURN
	     (CONS (CERROR T NIL 'INVALID-FORM
			   "Subst-function ~S contains inappropriate keyword ~A."
			   FN-NAME (CAR LAMBDA-LIST))
		   (CDR FORM))))
      ;; Detect runout of lambda list or of args.
      (COND ((NULL VALS)
	     (COND ((NULL LAMBDA-LIST)
		    (RETURN (IF SIMPLE-SUBSTITUTION-OK
				(SUBLIS ALIST BODY)
			      (SUBLIS-EVAL-ONCE (NREVERSE ALIST) BODY))))
		   ((NOT OPTIONAL-FLAG)
		    (RETURN (CERROR T NIL 'INVALID-FORM
				    "Too few arguments for ~S."
				    FN-NAME FORM)))))
	    ((NULL LAMBDA-LIST)
	     (RETURN (CERROR T NIL 'INVALID-FORM
			     "Too many arguments for ~S."
			     FN-NAME FORM))))
      ;; Here we have one more arg.  Add it to the alist.
      (PUSH (CONS (COND ((ATOM (CAR LAMBDA-LIST)) (CAR LAMBDA-LIST))
			(T (CAAR LAMBDA-LIST)))
		  (COND (VALS (CAR VALS))
			((ATOM (CAR LAMBDA-LIST)) NIL)
			(T (CADAR LAMBDA-LIST))))
	    ALIST)
      (POP LAMBDA-LIST))))

(defun nsubst-eq-safe (new old sexp &optional previous-sexps &aux car cdr)
  (cond ((eq sexp old) new)
	((atom sexp) sexp)
	((member sexp previous-sexps :test #'eq) sexp)
	(t (with-stack-list* (previous-sexps sexp previous-sexps)
	     (setq car (nsubst-eq-safe new old (car sexp) previous-sexps))
	     (if (neq car (car sexp)) (setf (car sexp) car))
	     (with-stack-list* (previous-sexps (car sexp) previous-sexps)
	       (setq cdr (nsubst-eq-safe new old (cdr sexp) previous-sexps))
	       (if (neq cdr (cdr sexp)) (setf (cdr sexp) cdr))))
	   sexp)))
