;;; -*- Mode: LISP; Base:8.; Package: SI -*-

;;;                           RESTRICTED RIGHTS LEGEND

;;;Use, duplication, or disclosure by the Government is subject to
;;;restrictions as set forth in subdivision (c)(1)(ii) of the Rights in
;;;Technical Data and Computer Software clause at 52.227-7013.
;;;
;;;                     TEXAS INSTRUMENTS INCORPORATED.
;;;                              P.O. BOX 2909
;;;                           AUSTIN, TEXAS 78769
;;;                                 MS 2151
;;;
;;; Copyright (C) 1987, Texas Instruments Incorporated. All rights reserved.

;;; This file (MX-QDEV) contains additional hardware definitions for the MicroExplorer.
;;;
;;;  Edit History
;;;
;;; Patch #   Date    Author  Description
;;;---------------------------------------------------------------------------------
;;;  --     11-16-87    ab    Original


;;; IO Space Sources  (for reading,  If * in comment - writable)

(DefAlternate MX-IO-SPACE (Q-CORRESPONDING-VARIABLE-LISTS SYSTEM-CONSTANT-LISTS)
   (Mx-Phys-Bus-Resource-Register  #x0          ;EPROM ID, Slot ID, Memory Expansion 
    Mx-Boot-EPROM                  #x0		;EPROM etc.  Name similar to Exp2
    Mx-FTimer                      #x01000000	;* Microsecond Timer
    Mx-STimer                      #x01800000	;* Event Generating Timer
    Mx-External-Control-Reg        #x02000000	;* Bus and Timer controls  (Slot ID is read-only  - XCREG<07:04>)
    Mx-Map-Status-Register         #x02800000
    Mx-Address-Space-Memory-Map    #x03000000	;* 
    Mx-Address-Space-Map-Register  #x03800000	;*
    Mx-Virtual-Memory-Map          #x04000000	;* Virtual Memory Map IO Space Address
    Mx-VMM-Data-Left               #x04000000	;* Left  bank of Mem Map Registers 4000000 - 43FFFFF
    Mx-VMM-Data-Right              #x05000000	;* Right bank of Mem Map Registers 5000000 - 53FFFFF
    Mx-VMM-Status-Bits             #x06000000	;* 2 bit Map status for each of the xxK possible pages 

    Mx-Size-of-VMM                 4096.	;4K memory map registers in each bank
    Mx-Size-of-VMM-status          65536.	;64k VMM status RAM

      ))


;;; Physical Space

(DefAlternate MX-PHYSICAL-SPACE-OFFSETS (Q-CORRESPONDING-VARIABLE-LISTS SYSTEM-CONSTANT-LISTS)
   (%Mx-Max-In-Slot-Memory-Offset  #xBFFFFF

    %Mx-Physical-Space-Base        #xC00000
    %Mx-uP-Event-Status            #xC00000	; (RO)
    %Mx-Board-Control-Register     #xC00004	; Also in IO Space
    %Mx-PCI-Command-Register       #xC00008	; AKA Spare R/W register A
    %Mx-PCI-Status-Register        #xC0000C	; AKA Spare R/W register B
    %Mx-DRAM-Bank-0-Status         #xC00010
    %Mx-DRAM-Bank-1-Status         #xC00014
    %Mx-DRAM-Bank-2-Status         #xC00018
    %Mx-DRAM-Control-Register      #xC0001C

    %Mx-Host-Event-Base            #xD00000
    %Mx-Host-Event-0               #xD00000	; (WO)
    %Mx-Host-Event-1               #xD00004	; (WO)
    %Mx-Host-Event-2               #xD00008	; (WO)
    %Mx-Host-Event-3               #xD0000C	; (WO)
    %Mx-Host-Event-4               #xD00010	; (WO)
    %Mx-Host-Event-5               #xD00014	; (WO)
    %Mx-Host-Event-6               #xD00018	; (WO)
    %Mx-Host-Event-7               #xD0001C	; (WO)
    %Mx-Host-Event-Status          #xD00020	; (RO)
    %Mx-Host-Event-Mask            #xD00024

    %Mx-uP-Event-Base              #xE00000	; Same as Exp2.  Here for completness only.
    %Mx-uP-Event-0                 #xE00000	; (WO)
    %Mx-uP-Event-1                 #xE00004	; (WO)
    %Mx-uP-Event-2                 #xE00008	; (WO)
    %Mx-uP-Event-3                 #xE0000C	; (WO)
    %Mx-uP-Event-4                 #xE00010	; (WO)
    %Mx-uP-Event-5                 #xE00014	; (WO)
    %Mx-uP-Event-6                 #xE00018	; (WO)
    %Mx-uP-Event-7                 #xE0001C	; (WO)
    %Mx-uP-Event-8                 #xE00020	; (WO)
    %Mx-uP-Event-9                 #xE00024	; (WO)
    %Mx-uP-Event-10                #xE00028	; (WO)
    %Mx-uP-Event-11                #xE0002C	; (WO)
    %Mx-uP-Event-12                #xE00030	; (WO)
    %Mx-uP-Event-13                #xE00034	; (WO)
    %Mx-uP-Event-14                #xE00038	; (WO)
    %Mx-uP-Event-15                #xE0003C	; (WO)

    %Mx-EPROM-Base                 #xF00000     ; (RO)  EPROM & ID Reg
    ))


(DefAlternate Mx-Phys-Bus-Resource-Register-Fields (Q-CORRESPONDING-VARIABLE-LISTS
						     System-Constant-Lists)
  (%%PBR-EPROM-Value         (byte  8.  0.)	;0-7
   %%PBR-Slot-ID             (byte  4.  8.)	;8-11
   %%PBR-Memex8              (byte  1. 12.)	;Memory expansion bank 1 (1=installed)
   %%PBR-Memex12             (byte  1. 13.)	;Memory expansion bank 2 (1=installed)
   ))


(DefAlternate Mx-External-Control-Register-Fields (Q-CORRESPONDING-VARIABLE-LISTS
						     System-Constant-Lists)
  (%%MXCR-Program-Fetch-Cache-Enable    (byte  1.  0.)  ;1=enable, reset:0  Shortens prefetch access 1 cycle when on
   %%MXCR-Microsecond-Timer-Enable      (byte  1.  1.)	;1=enable, reset:0
   %%MXCR-Event-Timer-Enable            (byte  1.  2.)	;1=enable, reset:0
   %%MXCR-Lock-Mode                     (byte  1.  3.)	;1=locked, reset:0  Bus lock
   %%MXCR-Program-Fetch-Cache-Valid     (byte  1.  9.)  ;1=valid  (RO)
   %%MXCR-Event-Timer-Reload-Mode       (byte  1. 10.)  ;1=reload mode, 0=Exp2 compatible
   ))


(DefAlternate Mx-Board-Control-Register-Fields (Q-CORRESPONDING-VARIABLE-LISTS
						     System-Constant-Lists)
  (%%BCR-Reset                         (byte  1.  0.)	;write 1=reset, read:0
   %%BCR-Self-Test-Busy                (byte  1.  1.)	;1=busy, reset:1
   %%BCR-Fault-LED                     (byte  1.  2.)	;1=on, reset:1
   %%BCR-Phys-Bus-Addressing-Mode      (byte  1.  3.)	;0=16MB mode, 1=64MB mode(unused), reset:0
   %%BCR-All-But-Boot-Status           (byte  4.  0.)
   %%BCR-Limpet-Boot-Status            (byte  4.  4.)	;Boot Status (aka LBS; software only)
   ))

(DefAlternate Mx-Limpet-Boot-Status-Values (Q-CORRESPONDING-VARIABLE-LISTS
					     System-Constant-Lists)
  (%LBS-Initial-Value   0.
   %LBS-Comm-Sync       1.
   %LBS-Warm-Boot       3.
   %LBS-Start-Lisp      5.
   %LBS-Software-Halted 7.
   ))

(DefAlternate Mx-Dram-Status-Fields (Q-CORRESPONDING-VARIABLE-LISTS
				      System-Constant-Lists)
  (%%DS-Byte-0-Parity-Error            (byte  1.  0.)
   %%DS-Byte-1-Parity-Error            (byte  1.  1.)
   %%DS-Byte-2-Parity-Error            (byte  1.  2.)
   %%DS-Byte-3-Parity-Error            (byte  1.  3.)
   ))


;; NOTE: Dram control register resets to all zeros.

(DefAlternate Mx-Dram-Control-Fields (Q-CORRESPONDING-VARIABLE-LISTS
				      System-Constant-Lists)
  (%%DC-Spare                          (byte  1.  0.)	;Readable/Writable
   %%DC-Fast-Refresh-Mode              (byte  1.  1.)	;1=fast, 0=normal
   %%DC-Host-Bus-Parity-Error-Disable  (byte  1.  2.)	;1=disable error
   %%DC-uP-Bus-Parity-Error-Disable    (byte  1.  3.)	;1=disable error
   %%DC-Refresh-Disable                (byte  1.  4.)	;1=disabled
   %%DC-Force-Errors                   (byte  1.  5.)	;1=force errors on writes
   %%DC-Swap-Parity                    (byte  1.  6.)	;1=swap parity with bit 0 of each byte on read & write
   %%DC-Error-Clear                    (byte  1.  7.)	;write 1=clear all parity status, read:0
   ))