/*
 * amem.h
 *
 * A-Memory and M-Memory layout
 */

#ifndef AMEM_H
#define AMEM_H

#include "exploiter.h"

/*
 * Overview map:
 *
 * 000 - 03f: M-Memory
 * 040 - 09d: A-Memory base locations
 * 09e - 0ff: Unknown
 * 100 - 139: A-Memory counter block (tentative location)
 * 13a - 197: Unknown
 * 198 - 19f: Physical Memory Map (tentative location)
 * 1a0 - 3f7: Unknown
 * 3f8 - 3ff: Startup information
 */


/*
 * M-Memory locations
 */

#define VM_M_BASE 0x01fffc00

#define M_MODE_FLAGS                   0x20
#define M_SEQUENCE_BREAK_SOURCE_ENABLE 0x21
#define M_METER_MICRO_ENABLES          0x22
#define M_SELF                         0x23
#define M_SELF_MAPPING_TABLE           0x24

/* 8 more M-Mem registers after this, mostly to do with Prolog */

#define M_LOCATIVE(foo) ((foo) | DTP_LOCATIVE | VM_M_BASE)


/*
 * A-Memory locations
 */

#define A_MICROCODE_VERSION_NUMBER    0x40
#define A_NUMBER_OF_MICRO_ENTRIES     0x41
#define A_DEFAULT_CONS_AREA           0x42
#define A_NUMBER_CONS_AREA            0x43


/*
 * From A_INITIAL_FEF through A_INITIAL_STACK_GROUP is similar to
 * SPIA_xxx constants
 */
#define A_INITIAL_FEF                 0x44
#define A_ERROR_HANDLER_STACK_GROUP   0x45
#define A_CURRENT_STACK_GROUP         0x46
#define A_INITIAL_STACK_GROUP         0x47

#define A_SCHEDULER_STACK_GROUP       0x48
#define A_CURRENT_STACK_GROUP_STATE   0x49
#define A_CURRENT_STACK_GROUP_PREVIOUS_STACK_GROUP 0x4a
#define A_CURRENT_STACK_GROUP_CALLING_ARGS_POINTER 0x4b
#define A_CURRENT_STACK_GROUP_CALLING_ARGS_NUMBER  0x4c
#define A_RESUMED_TRAP_AP_LEVEL       0x4d
#define A_RESUMED_REGULAR_PDL_POINTER 0x4e
#define A_RESUMED_SPECIAL_PDL_POINTER 0x4f
#define A_TRAP_MICRO_PC               0x50
#define A_RESUMED_SAVED_M_FLAGS       0x51

#define A_COUNTER_BLOCK_A_MEM_ADDRESS 0x52
#define A_MAR_LOW                     0x53
#define A_MAR_HIGH                    0x54
#define A_METHOD_SEARCH_POINTER       0x55
#define A_INHIBIT_SCHEDULING_FLAG     0x56
#define A_INHIBIT_SCAVENGING_FLAG     0x57
#define A_DISK_RUN_LIGHT              0x58
#define A_FREE_CLUSTER_COUNT          0x59
#define A_DISK_BLOCKS_PER_TRACK       0x5a
#define A_DISK_BLOCKS_PER_CYLINDER    0x5b

#define A_REGION_CONS_ALARM           0x5c
#define A_PAGE_CONS_ALARM             0x5d
#define A_GC_FLIP_READY               0x5e
#define A_INHIBIT_READ_ONLY           0x5f
#define A_SCAVENGER_WS_ENABLE         0x60

#define A_METHOD_SUBROUTINE_POINTER   0x61
#define A_CURRENT_SHEET               0x62
#define A_DISK_SWITCHES               0x63
#define A_MC_CODE_EXIT_VECTOR         0x64

#define A_ALPHABETIC_CASE_AFFECTS_STRING_COMPARISON 0x65
#define A_ZUNDERFLOW                  0x66
#define A_METER_GLOBAL_ENABLE         0x67
#define A_METER_BUFFER_POINTER        0x68
#define A_METER_DISK_ADDRESS          0x69
#define A_METER_DISK_COUNT            0x6a
#define A_CURRENTLY_PREPARED_SHEET    0x6b

#define A_MOUSE_CURSOR_STATE          0x6c
#define A_MOUSE_X                     0x6d
#define A_MOUSE_Y                     0x6e
#define A_MOUSE_CURSOR_X_OFFSET       0x6f
#define A_MOUSE_CURSOR_Y_OFFSET       0x70
#define A_MOUSE_CURSOR_WIDTH          0x71
#define A_MOUSE_CURSOR_HEIGHT         0x72
#define A_MOUSE_X_SPEED               0x73
#define A_MOUSE_Y_SPEED               0x74
#define A_MOUSE_BUTTONS_BUFFER_IN_INDEX  0x75
#define A_MOUSE_BUTTONS_BUFFER_OUT_INDEX 0x76
#define A_MOUSE_WAKEUP                0x77
#define A_MOUSE_H3                    0x78

#define A_LEXICAL_ENVIRONMENT         0x79
#define A_AMEM_EVCP_VECTOR            0x7a
#define A_BACKGROUND_CONS_AREA        0x7b
#define A_SYSTEM_SWITCHES             0x7c
#define A_ARRAY_INDEX_ORDER           0x7d
#define A_UNUSED_1                    0x7e
#define A_AR_1_ARRAY_POINTER_1        0x7f
#define A_AR_1_ARRAY_POINTER_2        0x80
#define A_LOAD_UNIT                   0x81
#define A_METER_UNIT                  0x82
#define A_ADDRESS_OF_PAGE_DEVICE_TABLE 0x83
#define A_NUMBER_OF_PAGE_DEVICES      0x84
#define A_MICROCODE_DEBUG_FLAGS       0x85

#define A_CLIPPING_RECTANGLE_LEFT_EDGE   0x86
#define A_CLIPPING_RECTANGLE_TOP_EDGE    0x87
#define A_CLIPPING_RECTANGLE_RIGHT_EDGE  0x88
#define A_CLIPPING_RECTANGLE_BOTTOM_EDGE 0x89

#define A_MICROCODE_TYPE              0x8a
#define A_PROCESSOR_TYPE              0x8b

/* 18 (0x12) more A-Mem registers after this, mostly to do with Prolog */


/*
 * A-Memory counter block locations
 */

#define A_COUNTER_BLOCK_BASE 0x100 /* FIXME: This may need moving later */

#define ACB_COUNT_FIRST_LEVEL_MAP_RELOADS       0x00
#define ACB_COUNT_SECOND_LEVEL_MAP_RELOADS      0x01
#define ACB_COUNT_PDL_BUFFER_READ_FAULTS        0x02
#define ACB_COUNT_PDL_BUFFER_WRITE_FAULTS       0x03
#define ACB_COUNT_PDL_BUFFER_MEMORY_FAULTS      0x04
#define ACB_COUNT_META_BITS_MAP_RELOADS         0x05
#define ACB_COUNT_CONS_WORK                     0x06
#define ACB_COUNT_SCAVENGER_WORK                0x07
#define ACB_TV_CLOCK_RATE                       0x08
#define ACB_LOWEST_DIRECT_VIRTUAL_ADDRESS       0x09
#define ACB_COUNT_FINDCORE_STEPS                0x0a
#define ACB_COUNT_FINDCORE_EMERGENCIES          0x0b
#define ACB_COUNT_FINDCORE_CLEAR_PAGES          0x0c
#define ACB_PAGE_TABLE_SEARCH_COUNT             0x0d
#define ACB_PHT_SEARCH_DEPTH                    0x0e
#define ACB_COUNT_CLEAN_PAGE_REQUESTS           0x0f
#define ACB_COUNT_CLEAN_PAGE_REQUEST_FAILED     0x10
#define ACB_COUNT_DISK_PAGE_READS               0x11
#define ACB_COUNT_FRESH_PAGES                   0x12
#define ACB_COUNT_DISK_PAGE_READ_RESUBMISSIONS  0x13
#define ACB_COUNT_DISK_PAGE_WRITE_OPERATIONS    0x14
#define ACB_COUNT_DISK_PAGE_WRITES              0x15
#define ACB_COUNT_DISK_PAGE_WRITE_APPENDS       0x16
#define ACB_COUNT_DISK_PAGE_WRITE_WAITS         0x17
#define ACB_COUNT_DISK_PAGE_WRITE_BUSYS         0x18
#define ACB_ABORTED_SWAPOUTS                    0x19
#define ACB_COUNT_SWAPOUT_PAGE_COUNT_REACHED    0x1a
#define ACB_SWAPOUT_SIZED_BY_RQB_OR_PAGE_COUNT  0x1b
#define ACB_DISK_WAIT_TIME                      0x1c
#define ACB_TOTAL_PAGE_FAULT_TIME               0x1d
#define ACB_MX_EVENT_TIMER_COUNTDOWN            0x1e
#define ACB_SWAPOUT_SEQUENCE_BREAKS_IN_PROGRESS 0x1f
#define ACB_LEAST_USED_PAGE                     0x20
#define ACB_MOST_RECENTLY_REFERENCED_PAGE       0x21
#define ACB_PAGE_HASH_TABLE_ADDRESS             0x22
#define ACB_PHT_INDEX_SIZE                      0x23
#define ACB_PHT_INDEX_LIMIT                     0x24
#define ACB_PHYSICAL_PAGE_DATA_ADDRESS          0x25
#define ACB_PHYSICAL_PAGE_DATA_END              0x26
#define ACB_COUNT_NUBUS_GACBL_RETRIES           0x27
#define ACB_COUNT_NUBUS_PARITY_RETRIES          0x28
#define ACB_METER_WAIT_TIME                     0x29
#define ACB_TGC_COUNTER                         0x2a
#define ACB_SLOTS_I_OWN                         0x2b
#define ACB_IO_SPACE_VIRTUAL_ADDRESS            0x2c
#define ACB_CRASH_RECORD_PHYSICAL_ADDRESS       0x2d
#define ACB_CNFG_PARTITION_SLOT_UNIT            0x2e
#define ACB_CNFG_PARTITION_NAME                 0x2f
#define ACB_GC_SAFETY_PAD                       0x30
#define ACB_COUNT_PRE_PAGES_READ                0x31
#define ACB_COUNT_PRE_PAGES_USED                0x32
#define ACB_MAX_GENERATION_0_OBJECT_SIZE        0x33
#define ACB_COUNT_TRANSPORT_FAULTS              0x34
#define ACB_MAX_SCAV_QUANTUM                    0x35
#define ACB_OVERLAY_LOAD_COUNT                  0x36
#define ACB_PHYSICAL_RESOURCE_BITMAP            0x37
#define ACB_CURRENT_WORLD_RECORD                0x38
#define ACB_MAX_EXTERNAL_WORLD_SIZE             0x39


/*
 * A-Memory Physical Memory Map locations
 */

#define A_PMM_BASE 0x198 /* FIXME: This may need moving later */
#define A_PMM_SIZE 8


/*
 * A-Memory startup information locations
 */

#define A_BOOT_COMMAND_BLOCK  0x3f8
#define A_BOOT_LOD_DEVICE     0x3f9
#define A_BOOT_MEMORY         0x3fa
#define A_BOOT_MONITOR        0x3fb
#define A_BOOT_KEYBOARD       0x3fc
#define A_BOOT_DEVICE         0x3fd
#define A_BOOT_MCR_NAME       0x3fe
#define A_BOOT_LOD_NAME       0x3ff


/*
 * Physical Resource Bitmap values
 */

#define PRB_DISK         0x01
#define PRB_SIB_BW       0x02
#define PRB_SIB_COLOR    0x04
#define PRB_NVRAM        0x08
#define PRB_MOUSE        0x10
#define PRB_KEYBOARD     0x20
#define PRB_NUBUS_MASTER 0x40
#define PRB_NUBUS_SLAVE  0x80


/*
 * A-Mem interface functions
 */

lisp_q read_amem(int address);
void write_amem(int address, lisp_q data);


/*
 * A-Mem variables used by various modules
 */

extern lisp_q a_default_cons_area;
extern lisp_q a_background_cons_area;

extern lisp_q a_disk_switches;
extern lisp_q a_inhibit_scheduling;
extern u32 a_slots_i_own;
extern u32 a_physical_resource_bitmap;

extern lisp_q a_pht_search_depth;
extern lisp_q a_pht_addr;
extern lisp_q a_pht_index_size;
extern lisp_q a_pht_index_limit;
extern lisp_q a_ppd_addr;
extern lisp_q a_ppd_end;

extern lisp_q m_self;
extern lisp_q m_self_mapping_table;

extern u32 a_boot_command_block;
extern u32 a_boot_lod_device;
extern u32 a_boot_memory;
extern u32 a_boot_monitor;
extern u32 a_boot_keyboard;
extern u32 a_boot_device;
extern u32 a_boot_mcr_name;
extern u32 a_boot_lod_name;


#endif /* AMEM_H */

/* EOF */
