;;; -*- Mode:Common-Lisp; Package:USER; Fonts:(CPTFONT HL12B HL12BI); Base:10 -*-
;;; Created 4/10/85 10:35:46 by Dan Nichols
;
;;;*****************************************************************************
;;;
;;;               If something is worth doing, it's worth doing
;;;                  at a higher level of abstraction.
;;;

#|Documentation:

|#

;;;*****************************************************************************


;;;
(defvar *DAN-LOGICAL-DIRECTORY-TRANSLATIONS*
	'(
	  ("FONTS"                      "FONTS")
	  ("FRACTAL"                    "GRAPHICS.FRACTAL")
	  ("GRAPHICS"                   "GRAPHICS")
	  ("HACKS"                      "HACKS")
	  ("OH"                         "GRAPHICS.OH")
          ("TOYS"                       "TOYS")
	  ("UTILITIES"                  "UTILITIES")
	  ("WINDOW"                     "WINDOW")
	  ("ZMACS"                      "ZMACS")
	  )
 2 "List of pairs translating logical DAN: directory names into the corresponding
  physical subdirectory names (subdirectories of the physical directory corresponding to
  *DAN-LOGICAL-DIRECTORY*).  Usually the logical and physical names here will be
  the same, but the physical names can be changed as needed.  This list is used by
  DEFINE-DAN-LOGICAL-HOST."*)



;;;
(defvar *DAN-LOGICAL-DIRECTORY* "NICHOLS")


;;;
;;; DEFINE-DAN-LOGICAL-HOST
;;;
;;; WARNING:  ASSUMING TI-EXPLORER PHYSICAL PATHNAMES. 

(DEFUN DEFINE-DAN-LOGICAL-HOST ()
2  "Defines DAN:*; to be logical pathnames associated with the physical host and the sub-
  directories of the directory from which this function was loaded.  All DAN systems
  use those logical names so the programs will run regardless of where they are, as long
  as they are together.  If this function is called twice the system gets confused about
  pathnames in general for some reason, SO DON'T CALL THIS FUNCTION TWICE."*
  (LET* ((SOURCE (GET 'DEFINE-DAN-LOGICAL-HOST :SOURCE-FILE-NAME))
	 (PHYSICAL-PATHNAME (IF (LISTP SOURCE)
			      (SECOND (ASSOC 'DEFUN SOURCE :TEST #'EQ))
			      SOURCE))
	 (PHYSICAL-HOST (SEND (SEND PHYSICAL-PATHNAME :HOST) :NAME))
	 (PHYSICAL-DIRECTORY (SEND PHYSICAL-PATHNAME :DIRECTORY)))
#-elroy    (si:ADD-LOGICAL-PATHNAME-HOST "DAN" PHYSICAL-HOST
			       (CONS
				`(,*DAN-LOGICAL-DIRECTORY*
				  ,(STRING-APPEND PHYSICAL-DIRECTORY ";"))
				(LOOP FOR (LOGICAL-DIRECTORY PHYSICAL-SUBDIRECTORY) IN
				   *DAN-LOGICAL-DIRECTORY-TRANSLATIONS* COLLECT
				   `(,LOGICAL-DIRECTORY
				     ,(STRING-APPEND PHYSICAL-DIRECTORY "."
						     PHYSICAL-SUBDIRECTORY ";")))))
#+elroy    (FS:ADD-LOGICAL-PATHNAME-HOST "DAN" PHYSICAL-HOST
			       (CONS
				`(,*DAN-LOGICAL-DIRECTORY*
				  ,(STRING-APPEND PHYSICAL-DIRECTORY ";"))
				(LOOP FOR (LOGICAL-DIRECTORY PHYSICAL-SUBDIRECTORY) IN
				   *DAN-LOGICAL-DIRECTORY-TRANSLATIONS* COLLECT
				   `(,LOGICAL-DIRECTORY
				     ,(STRING-APPEND PHYSICAL-DIRECTORY "."
						     PHYSICAL-SUBDIRECTORY ";")))))
    )) 

;(if (null (fs:get-pathname-host *DAN-logical-directory* t))
;    (define-DAN-logical-host))

;1 If loaded from the vax, use the backup logical file pathname (this happens when CEREBUS is broke)*
;(IF (TYPEP SYSTEM:FDEFINE-FILE-PATHNAME 'FS::VMS4-PATHNAME)
;    (ADD-LOGICAL-PATHNAME-HOST "Dan" "V3" '(("Nichols" "[DNICHOLS.BACKUP]")) "V4UD")
;    ;1; If loaded from a lispm, use CEREBUS*
;    (PROGN
(FS:ADD-LOGICAL-PATHNAME-HOST "Dan" "CEREBUS"
                                 '(("Nichols" "Nichols;")
                                   ("CELL" "Nichols.Toys.Cellular-automata;")
                                   ("FONTS" "nichols.FONTS;")
                                   ("FRACTAL" "Nichols.Graphics.Fractal;")
                                   ("GAMES" "Nichols.Toys.Games;")
                                   ("GRAPHICS" "nichols.GRAPHICS;") ("HACKS" "nichols.HACKS;")
                                   ("MISC" "Nichols.Misc;") ("MUSIC" "Sound.music;")
                                   ("NOISE" "Sound.noise;") ("OH" "Nichols.Graphics.Oh;")
                                   ("PUBLIC" "PUBLIC;") ("SLIME" "HOLLAND;") ("SOUND" "SOUND;")
                                   ("TOUR" "Nichols.Toys.Tour;") ("TOYS" "Nichols.Toys;")
                                   ("UTILITIES" "nichols.UTILITIES;") ("WINDOW" "nichols.WINDOW;")
                                   ("ZMACS" "nichols.ZMACS;")))
;      (ADD-LOGICAL-PATHNAME-HOST "DE" "V4" '(("BUG" "[expsrc.rel2.debug_utilities]")) "exp"))) 

(ADD-LOGICAL-PATHNAME-HOST "2s4*" "2sun4*" '(("xsrc" "/tilde/lagoon.u1/XV11R2/")
                                          ("dix" "/tilde/lagoon.u1/XV11R2/server/dix/")))
(ADD-LOGICAL-PATHNAME-HOST "2s3*" "2lagoon*" '(("xsrc" "/abuser/XV11R2/")
                                          ("dix" "/abuser/XV11R2/server/dix/")))
(ADD-LOGICAL-PATHNAME-HOST "2cross*" "2mips*" '(("dress" "/tilde/u1/dnichols/Misc/Personal/cdf/")))
(ADD-LOGICAL-PATHNAME-HOST "2dn*" "2mips*" '(("tex-stuff" "/tilde/u1/dnichols/TeX/Stuff/")
                                          ("letters" "/tilde/u1/dnichols/TeX/Letters/")))
                                          
;;;--------------------------------------------------------------------------------------------
;;; SYSTEMS -- 
;;;

(loop for (system source-file) in
       '(
;	 (CUBE                  "DAN:CUBE;defsystem")
;	 (HACKS                 "lam1:demo;hacksys")
	 (I-CHING               "DAN:TOYS;i-ching-defsystem")
;	 (GED                   "lam1:ged;defsystem")
;	 (GRASPER               "lam1:grasper;defsystem")
;	 (GWIN                  "lam1:gwin;defsystem")
         (ISKR-PROLOG           "cerebus:iskr.prolog;defsystem")
         (KBOTS                 "cerebus:iskr.k-bots;intro-grid-game-system")
;	 (MOVIE                 "lam1:demo.movie;movie-demo-system")
;	 (PROLOG                "lam1:prolog.source-code;defsystem-10")
         (PUBLIC                "dan:public;defsystem")
	 (MIN-PUBLIC            "dan:public;defsystem")
	 (MY-PUBLIC             "dan:public;defsystem")
;	 (3D-DISPLAY            "BEF0:BRUCEF;3dd-system")
;	 (4D-DISPLAY            "BEF0:BRUCEF;4dd-system")
	 )
      do (si:set-system-source-file system source-file))




 
