
;;; -*- Mode: LISP; Base: 10; Package: USER -*-
(defflavor sparse-matrix (rows number-of-rows type-of-entries
                               current-row current-row-number
                               current-row-length
                               pivot-row pivot-row-number
                               characteristic 
                               inverse-array
                               special-inverse
                               special-plus
                               (minimum-size-to-grow 1)
                               (allow-reorder t)
                               last-good-row
                               columns-used-to-pivot ;;key is the column ==>row
 number
                               column-used-in-row  ;;(aref column-used-in-row r
ow-num)
                                                   ;;==>column for row row-num
                               list-of-all-columns-occurring
                               pivot-entry
                              (pivot-test-list '(unit  min))
                               row-number-before-swap 
                               special-multiply
                               transpose
                               (reduced nil)
                               sort-pivot
                               (sign-of-row-permutation 1)
                               current-column-above-pivot-row-number 
                               columns-with-no-pivot ;;list of them
                               rows-with-no-pivot  ;;has a 1 in slot i --> no p
ivot in row i
                               solutions
                               constants-column-number
                               special-solution  ;; a sparse-matrix row which d
ots with rows 
                               (constants-column nil))  ;to give the constants-
column.
           (si:vanilla-flavor)
                               

           (:init-keywords :rows :type-of-entries :solutions :column-used-in-ro
w
            :columns-used-to-pivot)
           (:settable-instance-variables minimum-size-to-grow sort-pivot)
           :gettable-instance-variables)
          


(defmacro row-length (arow)
  `(array-dimension-n 1 ,arow))


(defmacro array-push-extend-replace (array data &rest options
                                     &aux (si:inhibit-scheduling-flag t) extens
ion body forms)
  "Keywords :AMOUNT-TO-GROW :REPLACE.
  Like array-push-extend but makes ARRAY point at the new array. It takes the k
eyword
 :REPLACE which should be followed by a list eg. :REPLACE ((aref rows i) bb) wi
ll put
  the new array in slot i of rows, and as value of bb, using setf. and also set
f's any
  replacement forms to point to the new array.  This will increase speed of ref
erence."
  (keyword-extract options vv ((:amount-to-grow extension)(:replace forms)) nil
)
  (setq body (loop for u in forms
        collecting `(setf ,u ,array)))
              
  `(cond ((array-push ,array ,data))
         (t (setq ,array
                  (adjust-array-size ,array
                                     (+ (array-length ,array)
                                        ;; If amount to extend by not specified
,
                                        ;; try to guess a reasonable amount
                                        (cond (,extension)
                                              ((< (%structure-total-size ,array
) si:page-size)
                                               (max (array-length ,array) 100))
                                              (t (// (array-length ,array) 4)))
)))
                   (catch-error  ,@body nil)
                  (array-push ,array ,data))))


(defmacro flag (x)
  `(cond ((variable-boundp ,x) ,x)
         (t nil)))
macsyma:
(defun $zerop ( n &aux type-of-n tem answer)
  (cond ((numberp n) (zerop n))
        ((atom n) nil)
        (t (setq type-of-n (caar n))
           (cond ((memq type-of-n '(mrat rat))
                  (equal (cdr n) (rzero)))
                 (t (and (numberp (setq tem ($ratsimp n)))(zerop tem)))))))

macsyma:
(defun sp-add* (&rest llist)
  (let ((varlist))
    (lexpr-funcall 'add*  llist)))
macsyma:
(defun sp-minus* (a)
  (let ((varlist))
    (simplifya (list '(mminus) a) nil)))
macsyma:
(defun sp-sub* (a b )
  (sp-add* a (sp-minus* b)))
macsyma: 
(defun sp-mul* (&rest a-list)
  (let ((varlist ))
    (cond ((< (length a-list) 3)(apply 'mul* a-list))
          (t (sp-mul* (car a-list) (apply 'sp-mul* (cdr a-list)))))))
macsyma:
(defun sp-div* (a b)
  (let ((varlist))
   (simplifya  (list '(mquotient) a b) nil)))

(defmacro make-number (n) 
  `(if (null ,n) 0 ,n))

(defun make-one-dimensional (aarray &aux ans)
  (cond ((eq (array-#-dims aarray) 1) aarray)
        (t (setq ans (make-array (apply '* (array-dimensions aarray)) :fill-poi
nter 0))
           (loop for i below (row-length aarray)
                 
                 when (aref aarray i 0)
                 do
                 (array-push-extend-replace ans (aref aarray i 0))
                 (array-push-extend-replace ans (aref aarray i 1)))
           ans)))
                 
(defmacro with-characteristic (&body body &aux body1 body2 body3)
  (setq body1 (sublis  '((special-times . *) (special-plus  .  +)) body))
  (setq body2 (sublis '((special-times . finite-characteristic-times)
                        (special-plus . finite-characteristic-plus)) body))
  (setq body3 (sublis '((special-times . macsyma:sp-mul*)
                        (special-plus . macsyma:sp-add*)) body))
  
  `(cond ((equal type-of-entries 'any-macsyma) ,@ body3)
          ((zerop characteristic) ,@ body1)
         (t (let ((.characteristic. characteristic))
              ,@ body2))))
(eval-when  (compile load eval)
 (defun appears-in ( tree   var)
  "Yields t if var appears in tree" 
  (*catch 'appears (appears tree var)))
 (defun appears (tree var) (cond ((equal tree var)  (*throw 'appears t))
                           ((atom tree) nil)
                           (t  (appears  (car tree) var) (appears (cdr tree) va
r)))
       nil))

(defmacro with-once-only ( &body body &aux body1 ll variables var reset)
  "This macro is to save re-evaluation of instance variables again and
   again. Care must be taken if control leaves in middle of body that
   the value of the variables will not be current" 
  (setq body1 (cdr body))
  (setq variables (car body))
  (loop for u in variables
        when (appears-in  body1 u)
        do
        (setq ll (cons (setq var (list (gensym) u)) ll))
        
        (setq body1 (subst (car var) (cadr var) body1))
        (setq reset (append reset (list `(setf ,@(reverse var))))))
  (cond (ll  `(let (,@ ll) ( prog1 (progn ,@ body1) ,@ reset)))
        (t   (cdr body1))))



(defmacro finite-characteristic-times (&rest l)
  `(mod (* ,@l) .characteristic.))

(defmacro finite-characteristic-plus (&rest l)
  `(mod (+ ,@l) .characteristic.))
;
;(defmacro special-times (a b )
;  "these won't usually be called but will be substituted"
;         
;  `(let (.prod.)
;     (setq .prod. (* ,a ,b))           ;for in the code by the with-characteri
stic 
;     (cond ((zerop characteristic) .prod.)             ;macro.  They can be us
ed
;          (t (mod .prod. characteristic)))))
;
;(defmacro special-plus (a b )
;  `(let (.sum.) (setq .sum. (+ ,a ,b))
;         (cond ((zerop characteristic) .sum.)
;               (t (mod .sum. characteristic)))))

(defmacro special-minus (a) `(special-times -1 ,a))

(defmacro special-times (&rest l)
  `(cond ((equal type-of-entries 'any-macsyma)(macsyma:sp-mul*  ,@ l))
        ((zerop characteristic)(* ,@ l))
        (t (mod (* ,@ l) characteristic))))
(defmacro special-plus (&rest l)
  `(cond ((eq type-of-entries 'any-macsyma) (macsyma:sp-add* ,@ l))
        ((zerop characteristic) (+ ,@ l))
        (t (mod (+ ,@ l) characteristic))))

(defmacro non-negative-remainder (x y)
  `(progn (setq ,x (remainder ,x ,y))
          (cond ((minusp ,x)   (+ ,x ,y))
                (t  ,x))))
(defsubst row-entry ( arow j )
 (let ((.this-row. arow)(.j. j) ind)
  (*catcH 'entry
    (loop for ii below (array-active-length .this-row.) by 2
          when (and (setq ind (aref .this-row. ii )) (eq ind .j.))
         do (*throw 'entry (aref .this-row. (add1 ii )))))))

;(defmacro row-dot (.this-row. brow ) "dot product of rows arow and brow"
; 
;  `(let ((.val.)
;        (.char. characteristic)  .prod.)
;     (loop for .iii. below (row-length ,arow)
;       when (and (aref ,arow .iii. 0)  (setq .val. (row-entry ,brow (aref ,aro
w .iii. 0))))
;       summing (special-times
;                        .val.
;                        (aref ,arow .iii. 1)))))

;(defun row-dot (arow brow ) "dot product of rows arow and brow"
; 
;  (let ((val)
;        prod)
;     (loop for iii below (row-length arow)
;       when (and (aref arow iii 0)  (setq val (row-entry brow (aref arow iii 0
))))
;       summing  (special-times
;                        val
;                        (aref arow iii 1)))))


;(defun make-number (n)
;  (cond ((null n) 0)
;       (t n)))

(defmethod (sparse-matrix :row-dot) (arow brow &aux aindex (ans 0))
  
  (with-characteristic
    
                   (let (val)
                     (loop for iii below (array-active-length arow) by 2
                           when (and (setq aindex (aref arow iii ))
                                     (setq val (row-entry brow aindex)))
                           do (setq ans
                                    (special-plus ans
                                      (special-times
                                      val
                                      (aref arow (add1 iii) )))))))
  ans)
(defmethod (sparse-matrix :row-dot-row-numbers) (i j)
  (send self :row-dot (aref rows i) (aref rows j)))

(defmacro below-fill (a)
  `(max (- (array-active-length ,a) 2) 0))
(defsubst set-fill-pointer (array n)
  (store-array-leader n array 0))

(defsubst maybe-move-back-fill-pointer (arow)
  (cond ((equal (array-active-length arow) 0) nil)
        (t
  
  (let ((this-row arow))
    (loop for i downfrom (below-fill this-row) to 0 by 2
          when (aref this-row i)
          do (set-fill-pointer this-row (+ i 2)) (return 'done)
          finally (set-fill-pointer this-row 0))))))


(defmethod (sparse-matrix :reduce-elements-for-type) ()
  (cond ((typep type-of-entries :fixnum)
         (loop for iii below number-of-rows
              do (let ((this-row (aref rows iii)))
                   (loop for ii below (array-         when (aref this-row eew(add1 ii))))
                            (cond (value
                                   (setq value (mod value type-of-entries))
                                   (cond ((eq value 0) (aset nil this-row ii  )
)
                                         (t (aset value this-row ii 1)))))))
                   (maybe-move-back-fill-pointer this-row))))))




(defmethod (sparse-matrix :reset-list-of-all-columns-occurring )(&aux  ind)
  (setq list-of-all-columns-occurring 
        (loop for ii below number-of-rows
              for this-row = (aref  rows ii)
              appending 
              (loop for jj below (array-active-length  this-row) by 2
                    when (and (setq ind (aref this-row jj ))
                              (not (memq ind temp)))
                    collecting ind)
                    into temp
              finally (return temp))))

(defmethod (sparse-matrix :set-rows) (the-rows )
  (loop for i below (array-length the-rows)
        do
        (let ((this-row (aref the-rows i)))
        (aset (make-one-dimensional this-row) the-rows i)))
  (setq rows the-rows)
  (setq number-of-rows (car (array-dimensions rows)))
  (setq last-good-row (sub1 number-of-rows))
  (send self :reset-list-of-all-columns-occurring)
  (setq column-used-in-row (make-array (row-length rows)))
  (setq rows-with-no-pivot  (make-array (row-length rows) :type 'art-1b))
  (cond ((and (variable-boundp columns-used-to-pivot)
              (typep columns-used-to-pivot 'si:eq-hash-table))
         (send columns-used-to-pivot :clear-hash))
        (t
         (setq columns-used-to-pivot (make-hash-table :size number-of-rows)))))

(defmethod (sparse-matrix :set-current-row ) (i)
  (setq current-row-number i)
  (setq current-row  (aref rows i))
  (setq current-row-length (array-active-length current-row))
  current-row)

(defmethod (sparse-matrix :row ) (i)
  (aref rows i))
(defmethod (sparse-matrix :set-pivot-row) (i)
           (setq pivot-row-number i)
          (setq pivot-row  (aref rows i))

  pivot-row)
(defmethod (sparse-matrix :pivot-row) ()
  pivot-row)
  
(defmethod (sparse-matrix :entry) ( i j)
  (let ((this-row (aref rows i)))
    (*catcH 'entry
      (loop for ii below (array-active-length this-row) by 2
            when (eq j (aref this-row ii ))
            do (*throw 'entry (aref this-row (add1 ii)))))))

(defun fix-even (n)
  (* 2 (fixr (quotient n 2.0))))

(defmethod (sparse-matrix :grow-current-row) ( &optional (ratio 1.3))
  (let ((new-length (max (fix-even (* ratio (row-length  (aref rows current-row
-number) )))
                         minimum-size-to-grow)))
    (aset
      (array-grow current-row new-length )
      
      rows current-row-number)
    (send self :set-current-row current-row-number)))




(defmethod (sparse-matrix :grow-row) (row-number &optional (ratio 1.3))
  (let ((new-length (max (fix-even (* ratio (row-length  (aref rows row-number)
 )))
                         minimum-size-to-grow)))
    (aset
      (array-grow (aref rows row-number)  new-length )
      
      rows row-number)))
  

;(defmacro current-rowset ( element index sslot)
;  `(progn (cond ((equal ,element 0) (aset nil current-row  ,sslot )
;                (maybe-move-back-fill-pointer current-row))
;               (t (cond (< ,sslot
;                (aset  ,element current-row (add1 ,sslot) )
;                (aset  ,index current-row , sslot )))))

;(defmacro this-row-set ( element index sslot)
;  `(progn (cond ((equal ,element 0) (aset nil this-row  ,sslot )
;                (maybe-move-back-fill-pointer this-row))
;               
;               (t
;                (aset  ,element this-row (add1 ,sslot) )
;                (aset  ,index this-row , sslot )))))

(defsubst set-entry ( value arow index)
  (*catch 'entry-is-set
    (let* ((.this-row. arow)
          (.ind. index) j (.val. value)
          first-empty-slot 
          (active-length (array-active-length .this-row.)))
      (setq first-empty-slot
            (loop for ii below (array-active-length .this-row.) by 2
                  do
                  (cond ((null (setq j (aref .this-row. ii))) (return ii))
                        ((eq j .ind.)
                         (cond ((macsyma:$zerop .val.) (aset nil .this-row. .in
d.)
                                (if (eq ii (- active-length 2))
                                    (maybe-move-back-fill-pointer .this-row.))
                                )
                               (t
                                (aset .val. .this-row. (add1 ii ))
                                (aset .ind. .this-row. ii)))
                         (*throw 'entry-is-set t)))))
      (cond (first-empty-slot
             (loop for ii from first-empty-slot below active-length by 2
                   when (eq .ind. (aref .this-row. ii))
                   do
                   (cond ((macsyma:$zerop  .val.) (aset nil .this-row. .ind.)
                          (if (eq ii (- active-length 2))
                              (maybe-move-back-fill-pointer .this-row.))
                          )
                         (t
                          (aset .val. .this-row. (add1 ii ))
                          (aset .ind. .this-row. ii)))
                   (*throw 'entry-is-set t)
                   finally
                   (cond ((macsyma:$zerop  .val.) nil)
                         (t (aset .val. .this-row. (add1 first-empty-slot))
                            (aset .ind. .this-row. first-empty-slot)))))
            ((not (macsyma:$zerop  .val.))
             (array-push-extend .this-row. .ind.)
             (array-push-extend .this-row. .val.))))))

(defsubst set-entry-without-moving-back-fill-pointer ( value arow index)
  (*catch 'entry-is-set
    (let ((.this-row. arow)
          (.ind. index) j (.val. value)
          first-empty-slot 
          )
      (setq first-empty-slot
            (loop for ii below (array-active-length .this-row.) by 2
                  do
                  (cond ((null (setq j (aref .this-row. ii))) (return ii))
                        ((eq j .ind.)
                         (cond ((macsyma:$zerop  .val.) (aset nil .this-row. .i
nd.)
;                               (if (eq ii (- active-length 2))
;                                   (maybe-move-back-fill-pointer .this-row.))
                                )
                               (t
                                (aset .val. .this-row. (add1 ii ))
                                (aset .ind. .this-row. ii)))
                         (*throw 'entry-is-set t)))))
      (cond (first-empty-slot
             (loop for ii from first-empty-slot below (array-active-length .thi
s-row.) by 2
                   when (eq .ind. (aref .this-row. ii))
                   do
                   (cond ((macsyma:$zerop  .val.) (aset nil .this-row. .ind.)
;                         (if (eq ii (- active-length 2))
;                             (maybe-move-back-fill-pointer .this-row.))
                          )
                         (t
                          (aset .val. .this-row. (add1 ii ))
                          (aset .ind. .this-row. ii)))
                   (*throw 'entry-is-set t)
                   finally
                   (cond ((macsyma:$zerop  .val.) nil)
                         (t (aset .val. .this-row. (add1 first-empty-slot))
                            (aset .ind. .this-row. first-empty-slot)))))
            ((not (macsyma:$zerop  .val.))
             (array-push-extend .this-row. .ind.)
             (array-push-extend .this-row. .val.))))))

;(defmethod (sparse-matrix :rem-current-row-entry) ( index)
;  (aset nil current-row index 0))

(defmethod (sparse-matrix :set-current-row-entry) (  value ind)
 (set-entry value current-row ind))

(defmethod (sparse-matrix :set-entry) (  value i j)
  (set-entry value (aref rows i) j))
;(defun row-set-entry (value this-row j)
;  (let ((first-empty-slot nil))
;       
;    (*catch 'finished 
;      (setq first-empty-slot
;           (*catch 'first
;             (loop for ii below (row-length this-row)
;                   do (cond ((eq (aref this-row ii 0) j) (this-row-set value j
 ii)
;                             (*throw 'finished t))
;                            ((null (aref this-row ii 0)) (*throw 'first ii))
;                            (t nil)))))
;      (cond ( first-empty-slot 
;            (loop for ii from first-empty-slot  below (row-length this-row)
;                  do (cond ((eq (aref this-row ii 0) j) (this-row-set value j 
ii)
;                            (*throw 'finished t))))
;            (this-row-set value j first-empty-slot))
;           (t 
;            (let ((last-spot (row-length this-row)))
;              (array-grow this-row (list (fixr (* 1.3 (row-length this-row))) 
2))
;              (this-row-set value j last-spot)))))))

;(defmacro pivot-row-ref (index)
;  `(*catch 'pivot-row-ref
;     (loop for .ii. below (array-active-length pivot-row) by 2
;          do (cond ((eq ,index (aref pivot-row .ii.))
;                    (*throw 'pivot-row-ref (aref pivot-row (add1 .ii. ))))))))

;(defmacro current-row-ref (index)
;  `(*catch 'current-row-ref
;     (loop for .ii. below (array-active-length current-row) by 2
;          do (cond ((eq ,index (aref current-row .ii. ))
;                    (*throw 'current-row-ref (aref current-row (add1 .ii.) )))
))))

;(defmacro current-row-slot (index)
;  `(*catch 'current-row-slot
;     (loop for .ii. below (array-active-length current-row) by 2
;          do (cond ((eq ,index (aref current-row .ii. ))
;                    (*throw 'current-row-slot .ii.))))))



;(defmacro matrix-entry ( i j) "This finds the entry of a sparse-matrix


SHUTDOWN message on CRLV4 from user CHANG at _CRLV4$OPA0:   10:45:01

CRLV4 will shut down in 16 minutes; back up shortly via automatic reboot.
REBOOT


; the ith row and jth column"
;  `(*catch 'matrix-entry
;     (let ((.row. (aref rows ,i)))
;     (loop for .ii. below (row-length .row.)
;          do (cond ((eq ,j (aref .row. .ii. 0))
;                    (*throw 'matrix-entry (aref .row. .ii. 1))))))))

;(defmacro set-matrix-entry (value i j) "This sets the entry of a sparse-matrix
; the ith row and jth column"
;  `(*catch 'set-matrix-entry
;     (setq first-empty-slot (*catch 'where
;     (let ((.row. (aref rows ,i)))
;     (loop for .ii. below (row-length .row.)
;          do (cond ((null (aref .row. .ii. 0) (*throw 'where .ii.))))))))))
;                   ((eq ,j (aref .row. .ii. 0))
;                    (aset value .row. .ii. 1)
;                    (*throw 'set-matrix-entry t)))))) nil)

(defmacro row-slot (row index)
  "Returns the slot that the INDEX (column) appears in ROW"
  `(*catch 'row-slot
     (loop for .ii. below (array-active-length ,row) by 2
           do (cond ((eq ,index (aref ,row .ii. ))
                     (*throw 'row-slot .ii.))))))

(defmacro set-current-row-entry-in-new-column (value row index)
  "Puts new entry in a column not occurring in row.  Would work
  for rows other than current-row except for wanting the row number
  to be able to replace it in ROWS if ROW is grown."
  `(let ((.val. ,value)
        (.ind. ,index))
  (cond ((macsyma:$zerop  .val.) nil)
        (t
  (loop for ii below (array-active-length ,row) by 2
        when (null (aref ,row ii))
        do (aset .ind. ,row ii)
        (aset .val. ,row (add1 ii))  
        (return 'entry-is-set)   
        finally (array-push-extend-replace ,row .ind.
                                           :replace ((aref rows current-row-num
ber)))  
        (array-push-extend-replace ,row .val. :replace ((aref rows current-row-
number))))))))



(defmethod (sparse-matrix :row-operation ) (factor &aux current-row-slot new-va
lue
                                                   piv-col temp)
  "this replaces the current-row by current-row + factor pivot-row"

  (with-characteristic
     (with-once-only
      (pivot-row current-row)
      (cond ((equal factor 0) nil)
            (t
             (loop for ii below (array-active-length pivot-row) by 2
                   when (setq piv-col (aref pivot-row ii ))
                   do (cond ((setq current-row-slot (row-slot  current-row piv-
col))
                             (setq  new-value (special-plus
                                                (special-times
                                                  factor (aref pivot-row (add1 
ii )))
                                                (aref current-row
                                                      (add1 current-row-slot)))
)
                             (cond ((macsyma:$zerop  new-value )
                                    (aset nil current-row current-row-slot ))
                                   (t (aset new-value current-row (add1 current
-row-slot )))))
                            (t (set-current-row-entry-in-new-column
                                 (special-times factor (aref pivot-row (add1 ii
)))
                                          current-row piv-col))))
             (maybe-move-back-fill-pointer current-row))))
      (cond ((and constants-column
              (not (macsyma:$zerop  (setq temp (aref constants-column pivot-row
-number)))))
         (aset (special-plus (aref constants-column current-row-number)
                             (special-times factor temp))
               constants-column current-row-number)))))

    
 

;(with-characteristic
;  (special-times 3 4))

(defun get-rows-from-array ( matrix)
  (let* ((dims (array-dimensions matrix))
         (the-rows (make-array (car dims)))
         arow)
    (loop for i below (car dims)
          do (setq arow (make-array (* (second dims) 2) :fill-pointer 0))
          (aset arow the-rows i)
          (loop for j below (second dims)
                do (let ((entry (aref matrix i j)))
                     (cond ((not (equal entry 0))
                            (array-push arow j)
                            (array-push arow entry)))))
          finally (return the-rows))))

(defun random-matrix (m n &optional (random-size 5))
  (let ((mat (make-array (list  m n))) )
    (loop for i below m
          do (loop for j below n
                   do (aset (random random-size) mat i j))
          finally (return mat))))
(defun show-matrix (mat)
  (let ((dims (array-dimensions mat)))
    (loop for i below (car dims)
        do (format t "~%")
        (loop for j below (second dims)
              do (format t "~3D" (aref mat i j))))))

(defmethod (sparse-matrix :gcd-row) (i)
  (let ((ans (send self :first-element-of-row i))
        (this-row (aref rows i)))
       (loop for ii below (array-active-length this-row) by 2
             when (aref this-row ii )
             do (setq ans (gcd ans (aref this-row (add1 ii ))))
             finally (return ans))))
(defmethod (sparse-matrix :first-element-of-row) (ii)
  (*catch 'first-element
    (let ((this-row (aref rows ii)))
   (loop for i below (array-active-length this-row) by 2
         when (aref this-row i ) do (*throw 'first-element (aref this-row (add1
 i )))))))


(defsubst show-row (arow)
  (let ((this-row arow) ind)
  (loop for jj below (array-active-length this-row) by 2
        when (setq ind (aref this-row jj))
        do (format t "~%In slot ~D ~D-->~D " (// jj 2) ind (aref this-row (add1
 jj))))))
           
(defmethod (sparse-matrix :show-row) (i)
  (let ((this-row (aref rows i)))
   (format t "~%Row ~D is ~A." i this-row)
   (show-row this-row)))
    
(defmethod (sparse-matrix :show-current-and-pivot) ()
  (let ((crn current-row-number))
    (format t "~%Current row is ~D which is ~A." crn current-row)
    (show-row current-row)
    (format t "~%Pivot Row is ~D which is ~A." pivot-row-number
            pivot-row)
    (show-row pivot-row)))

(defmacro special-inverse (x)
  `(cond ((equal type-of-entries 'any-macsyma)(macsyma:sp-div* 1 ,x))
         ((numberp type-of-entries) (aref inverse-array (mod ,x type-of-entries
)))
         (t (sys:rational-quotient 1 ,x))))

(defun sp-rat (x)
  (cond ((or (macsyma:polynomialp x)(macsyma:rational-functionp x)) x)
        (t (macsyma:new-rat x))))
(defmethod (sparse-matrix :set-type-of-entries) (y)
  (setq type-of-entries y)
  (cond ((equal y ':integer)
         (setq characteristic 0)
         (setq pivot-test-list '(unit gcd-column)))
        ((equal y ':rational)
         (setq pivot-test-list '(unit gcd any))
         (setq characteristic 0))
        ((equal y 'user:any-macsyma)
         (setq pivot-test-list '(any-macsyma))
         (setq characteristic 0)
         (loop for i below (array-length rows)
               do
               (let ((this-row (aref rows i)))
                 (loop for j below (array-length this-row) by 2
                       when (aref this-row j)
                       do (aset (sp-rat (aref this-row (add1 j))) this-row (add
1 j))))))
        ((and (fixnump y) (> y 0))
         (setq characteristic y)
         (if (> y 70) (ferror "For integers mod ~D you want another inverse alg
orithm" y))
         (setq inverse-array (make-array y))
         
         (loop for i from 1 below y
               do
               (loop for j below y
                     when (equal (mod (* i j) y) 1) do
                     (aset j inverse-array  i ) (loop-finish))))
        (t (ferror "At present only positive integers (ie finite char),integer,
 rational, or
'user:any-macsyma are valid types"))))






(defmethod (sparse-matrix :enter-pivot-data) (col)
 (puthash
                          col
                          pivot-row-number columns-used-to-pivot)
                        (aset col
                              column-used-in-row  pivot-row-number)
                        (fmat t "Row ~D has pivot ~D in column ~D." pivot-row-n
umber
                                pivot-entry
                                col))
                        

(defmethod (sparse-matrix :remove-zero-entries-from-row) (i)
  (let ((this-row (aref rows i)))
    (loop for ii below (array-active-length this-row) by 2
          when (aref this-row ii )
          do (if (null (aref this-row (add1 ii) )) (aset nil this-row ii 0)))
    (maybe-move-back-fill-pointer this-row))) 
          

(defmacro hloop (for u and v in table do body)
     for and in do
    `(send ,table :map-hash '(lambda (,u ,v) ,body)))
(defun show-hash (tabl )
  (hloop for x and y in tabl do (format t "~%~A -->~A" x y)))
(defmethod (sparse-matrix :show-rows)(&rest l)
  (cond ((null l) (setq l (loop for i below number-of-rows
                                collecting i))))
   (loop for i in l do (send self :show-row i))
   (format t "~%Current row is row ~D." current-row-number)
   (format t "~%Pivot row is row ~D." pivot-row-number))

(defmethod (sparse-matrix :list-pivots) (&optional pred &aux entry col)
  (cond ((null pred) (setq pred (function (lambda (ignore) t))))
        ((equal pred :non-unit) (setq pred (function (lambda (x) (neq (abs x) 1
))))))
  ;(hloop for u and v in columns-used-to-pivot do
    (loop for i below number-of-rows
          when (and (setq col (aref column-used-in-row i))
                    (funcall pred (setq entry (send self :entry i col))))
          collecting  entry into tem
          
;         (format t "~%Row ~D has pivot ~D in column ~D." i entry col)
          finally (return tem)))

 
(defmethod (sparse-matrix :show-pivots) (&optional pred &aux entry col)
  (cond ((null pred) (setq pred (function (lambda (ignore) t))))
        ((equal pred :non-unit) (setq pred (function (lambda (x) (neq (abs x) 1
))))))
  ;(hloop for u and v in columns-used-to-pivot do
    (loop for i below number-of-rows
          when (and (setq col (aref column-used-in-row i))
                    (funcall pred (setq entry (send self :entry i col))))
          do
          (format t "~%Row ~D has pivot ~D in column ~D." i entry col)))
    
                



(defmethod (sparse-matrix :show-matrix)()
  (cond ((variable-boundp list-of-all-columns-occurring ) nil)
        (t 
         (setq list-of-all-columns-occurring (sort list-of-all-columns-occurrin
g '<))))
  (format t "~%       " )
  (loop for i in list-of-all-columns-occurring do (format t "C~D   " i))
  (cond (constants-column (format t "Const~D" (flag constants-column-number))))
  (loop for i below number-of-rows
        do (format t "~%R~2D " i)
        (loop for j in list-of-all-columns-occurring
              do (format t "~5D" (make-number (send self :entry i j))))
        (cond (constants-column (format t "~5D" (aref constants-column i)))))
  (cond ((and (variable-boundp special-solution) special-solution)
         (format t "~%SpSol")
         (loop for j in list-of-all-columns-occurring
               do (format t "~5D" (make-number (row-entry special-solution j)))
))))

(defmethod (sparse-matrix :reduce) (&optional type-of-entry &aux current-row-en
try)
  (cond (type-of-entry (send self :set-type-of-entries type-of-entry)))
  (cond ((typep type-of-entries :fixnum) (send self :reduce-elements-for-type))
)
  (send self :clear-pivots)
  (with-characteristic
   (loop for i below number-of-rows
        do
        (send self :set-pivot-row i)
        (send self :best-pivot)
        (if pivot-entry
            (let ((pivoting-column (aref column-used-in-row pivot-row-number))
                  (minus-inverse-pivot-entry (special-minus (special-inverse pi
vot-entry))))
            (loop for ii from (+ 1 i) below number-of-rows
                  do
                  (send self :set-current-row ii)
                  (cond ((setq current-row-entry
                               (send self :entry ii
                                    pivoting-column ))
                         (send self
                               :row-operation
                                (special-times
                                        current-row-entry
                                        minus-inverse-pivot-entry)
                               ))))

            ))))
                        

                        
  (setq reduced t))

(defmethod (sparse-matrix :multiply-row) (row-number factor)
  (let ((this-row (aref rows row-number)))
    
    (cond ((equal 0 (special-times 1 factor))
           
           (loop for i below (row-length this-row)
                 do (aset nil this-row i 0))
           (set-fill-pointer this-row 0))
          ((equal 1 factor) nil)
          (t
           (with-characteristic
             (loop for i below (array-active-length this-row) by 2
                   when (aref this-row i )
                   do (aset   (special-times
                                (aref this-row (add1 i )) factor ) this-row (ad
d1 i) )))))))


(defmacro dsend (object &rest body)
 `(progn (send ,object .,body)
         (send ,object :show-matrix)))

(defmethod (sparse-matrix :clear-pivots)()
  (send columns-used-to-pivot :clear-hash)
  (fillarray column-used-in-row  nil)
  (fillarray rows-with-no-pivot  '(0))
  (loop for i below number-of-rows
        do (aset nil column-used-in-row i)))

(defmethod (sparse-matrix :get-rows-from-array) (array &optional (type :integer
))
      (send self :set-rows (get-rows-from-array array))
    (send self :set-type-of-entries type))
;(defun h (i j) (macsyma:$concat '$dd i j))
;(defun zero-out (array a-list)
;  (loop for u in a-list do (lexpr-funcall 'aset 0 array u)))
;(zero-out aa '((0 1) (0 3) (0 5) (0 7)(1 0)(1 2)(1 4) (1 6)(3 1) (3 3)(3 5)(3 
7)
;              (4 0)(4 2)(4 4)(4 6)))
(defun genmatrix (m n fun)
  (let ((ans (make-array (list m n))))
    (loop for i below m
          do (loop for j below n do
                   (aset (funcall fun i j ) ans i j)))
    
  ans))
  

(defun macsyma-array-to-row  (&quote aarray &optional (grow-ratio 1))
  (let* ((array (fsymeval (macsyma:mget  aarray 'macsyma:hashar)))
        (actual-size (funcall aarray 1))
        (index 0)
        ans  val )
    (setq ans (make-array  (fixr (* actual-size 2 grow-ratio)) :fill-pointer 0)
)
    (loop for i from 3 below (car (array-dimensions array))
          do (cond ((setq val (aref array i))
                    (loop for u in val do
                        (array-push-extend-replace ans  (caar u) )
                        (array-push-extend-replace ans  (cdr u) )))))
                     
    (cond ((not (equal (setq index (sys:rational-quotient (fill-pointer ans) 2)
 )
                       actual-size))
           (format t "We only found ~D elements while there should h-of-macsyma-arrays-to-rows (llist)
  (let* ((size (length (cdr llist))))
;  (cond ((null filename) (setq filename (string name-of-object-to-dump))))
;       
;  `(sys:dump-forms-to-file ,filename
;                          (list (list 'setq ',name-of-object-to-dump
;                                      (list 'quote ,name-of-object-to-dump)))
;                          ,file-atribute-list))
;
;(defun te (n   c &aux a aa)
;  (setq a c)   ;;96 ms. this is best.93 ms. if put the aa let outside the do l
oop
;  (loop for i below n do (let(( aa (* i 2))) (cond ((zerop a) aa)
;                                                (t (remainder aa a))))))
;
;(defun te (n   c &aux d)  ;;130ms.
;  (local-declare ((special d)) (setq d c)
;  (loop for i below n do ((lambda(a b)(cond  ((eq d 0) (* a b))
;                                           (t (remainder (* a b) d)))) i 2 )))
)
;
;(defun te (n c &aux d)
;  (let ((d c))       ;;108 ms. slower than if you set up variable for (* i 2)
;    (loop for i below n do (cond ((zerop d) (* i 2))
;                                (t (remainder (* i 2) d))))))
;(defun te (n c &aux d) ;;faster than without the setq d! approx 75ms.
;  (loop for i below n do  (setq d (aref c 500)) ))
;
;(defun te (n c &aux sp)
;  
;  (loop for i below n do (setq c (  i 2))))
;
;(defmacro with-speed (&body body)
;  `(let ((.char. characteristic) .prod. .sum.)
;     ,@body))
;
;
;     
;(defun te (n   c &aux )
;  (let ((d c))             ;;120 ms.
;  (loop for i below n do ((lambda(a b d)(cond  ((eq d 0) (* a b))
;                                           (t (remainder (* a b) d)))) i 2 d )
)))
;
;(progn 'compile (setf (function sp-ti) (function (lambda(a b d)(cond  ((eq d 0
) (* a b))
;                                           (t (remainder (* a b) d)))) )))
;(defmethod (sparse-matrix :test) (n)
;  (let ((type-of-entries type-of-entries))  ;;fairly-fast
;  (loop for i below n do (hh i 2 type-of-entries))))
;
;(defmethod (sparse-matrix :test) (n &aux a)
; (let ((type-of-entries type-of-entries))
;  (loop for i below n do 
;       (setq a (* i 2)) (cond ((zerop type-of-entries) a)
;                                               (t (remainder type-of-entries a
))))))
;
;(defmethod (sparse-matrix :test) (n)
;  (with-characteristic ; 77ms. in characteristic=0 this is best!!
;    (loop for i below n do (special-times i 2))))
;
;
;(defun-method  h sparse-matrix (a b)  ;;slow
;  
;                                     (cond ((eq type-of-entries 0) (* a b))
;                                           (t (remainder (* a b) type-of-entri
es))))
;


(defmethod (sparse-matrix :number-of-pivots)(&optional (below-row number-of-row
s))
  (let ((count 0))
      (loop for i below below-row
        when (aref column-used-in-row i) do (setq count (add1 count))
        finally (return count))))
;(defun te (&rest l &aux with bar five)
; (keyword-extract l vv    ((:with bar)  five ))
; (print (list bar five)))
  
;(for element of row with index in slot do body)
;(defmacro for (u &rest l &aux element row index slot)
;   (keyword-extract l vv ( (:of row) (:with index) (:in slot) (:do body)))
;    `(let ((,row (aref rows ,i)) ,element   ,index )
;    (loop for ,slot below (row-length ,row)
;         when (aref ,row ,slot 0)
;         do (setq ,element (aref ,row ,slot 1))
;         (setq ,index (aref ,row ,slot 0))
;        . ,body)))

  

(defmethod (sparse-matrix :solve ) (&rest l &aux reset-list-of-columns-flag red
uce-flag)
  (keyword-extract l vv nil ((:reduce reduce-flag)
                             (:reset-list-of-columns-occurring reset-list-of-co
lumns-flag)))
  (cond (reset-list-of-columns-flag (send self :reset-list-of-all-columns-occur
ring)))
  (cond ((or reduce-flag (null reduced))
         (send self :clear-pivots)
         (send self :reduce)))

  
  (setq columns-with-no-pivot
        (loop for u in list-of-all-columns-occurring
              when (null (gethash  u columns-used-to-pivot)) collecting u))
  (let* ((number-of-columns (length list-of-all-columns-occurring))
         (number-of-pivots (send self :number-of-pivots))
         (number-of-solutions (- number-of-columns number-of-pivots))
         a-solution a-new-entry a-special-solution
         (solution-rows  (make-array (length columns-with-no-pivot) :fill-point
er 0)))
    (cond ((not (equal (length columns-with-no-pivot) number-of-solutions))
           (format t "~%There are ~D columns and ~D pivots and ~D columns with 
no pivot,
something is wrong" (length list-of-all-columns-occurring) number-of-pivots (le
ngth columns-with-no-pivot))))

    (cond
      ((>  number-of-solutions 0)
       (with-characteristic
         
         (loop for u in  columns-with-no-pivot
               do (setq a-solution (make-array (* (add1 number-of-pivots) 2)
                                               :leader-list (list 0 u)))

               (array-push solution-rows a-solution)
             (fmat t "~%solution-rows ~A"  (listarray solution-rows))
               (set-entry 1 a-solution u)
               (loop for nn downfrom (sub1 (row-length rows)) downto 0
                     when (aref column-used-in-row nn)
                     do
                     (setq pivot-entry (send self :entry nn (aref column-used-i
n-row nn)))
                     (setq a-new-entry (special-times -1
                                          (special-inverse  pivot-entry)
                                         (send self :row-dot a-solution (aref r
ows nn))))
;                     (+ (send self :row-dot a-solution (aref rows nn))
;                        (cond ((null constants-column) 0)
;                              (t (aref constants-column nn))))))            stants-column
           (loop for i below (array-length column-used-in-row)
                 when (null (aref column-used-in-row i))
                 do
                 (cond ((not (macsyma:$zerop  (aref constants-column i)))
                        (format t "~%~%  ******************************~%")
                (format   t "~%Row ~D has no pivot but the constants-column has
 entry ~D.
                   ~%WARNING.  The equations were INCONSISTENT.
                   ~%The special-solution is NOT VALID.
                   ~%  ******************************" i (aref  constants-colum
n i)))))
           (with-characteristic      
             (setq a-special-solution (make-array (* (add1 number-of-pivots) 2)
                                                  :leader-list (list 0 )))
             (loop for nn downfrom (sub1 (row-length rows)) downto 0
                   when (aref column-used-in-row nn)
                   do
                   (setq pivot-entry (send self :entry nn (aref column-used-in-
row nn)))
                   (setq a-new-entry
                         (special-times -1
                           (special-inverse  pivot-entry)                     
                           (special-plus (send self :row-dot a-special-solution
 (aref rows nn))
                                         (aref constants-column nn))))
                   (cond ((not (macsyma:$zerop  a-new-entry))
                          (array-push a-special-solution (aref column-used-in-r
ow nn))
                          (array-push a-special-solution a-new-entry)))))))
    (cond ((and (variable-boundp solutions)(typep solutions 'sparse-matrix))
           (send solutions :set-rows solution-rows )
           (send solutions :set-type-of-entries type-of-entries))
          
          (t (setq solutions (make-instance 'sparse-matrix :rows solution-rows
                                            :type-of-entries type-of-entries)))
)
    (set-in-instance solutions 'special-solution a-special-solution)))
macsyma:
(defun bring-to-left-side (possible-eqn)
  "Converts a=b into a-b, or a into a also doing nothing if b is 0 "
  (cond ((atom possible-eqn) possible-eqn)
        ((eq (caar possible-eqn) 'mequal)
         (cond ((eq (third possible-eqn) 0)(second possible-eqn))
               (t (sub (second possible-eqn) (third possible-eqn)))))
        (t possible-eqn)))



(defmethod (sparse-matrix :show-solutions)()
   (send   (send self :solutions) :show-matrix))

(defmethod (sparse-matrix :verify-solutions) ()
  (loop for i below number-of-rows
        do
        (loop for j below (send solutions :number-of-rows)
              do
              (format t "~%The dot product of row ~D and solution ~D is ~D"
                      i j (send self :row-dot (send self :row i) (send solution
s :row j))))))

(defun nil-lessp (x y)
  (cond ((null y)  (cond ((null x) nil)
                         (t t)))
        ((null x) nil)
        (t (< x y))))



(defmethod (sparse-matrix :sort-row) (i)
  (sory ws
))
rable-row (x) x nil)                 ;
(defun desirable-row (x) (eader-length x) 2))

) p-col)
  (setq pivot-entry nil)
  q   (fmat t "~%What is best po pio (aref rows-with-no-pivot pivot-row-number))
     (fmat t "Row ~D was previously found to have no possible pivot."
             pivot-row-number))
    (t
     (*catch 'done 
       
       (loop
         for test-name in pivot-test-list
         when (may-have-pivot pivot-row-number)
         do
         (setq last-good-row (sub1 number-of-rows))
         (let ((fresh-row t)
               best no-gcd test col-to-pivot)
           
           (loop
             while fresh-row
             do
             (cond
               ((and (desirable-row pivot-row)
                     (equal type-of-entries :integer))(setq test-name 'gcd-colu
mn)))
             (selectq test-name
               (any (setq test (function (lambda (ignore  ignore) t)))
                    (setq best 1))
               (any-macsyma (send self :best-pivot-macsyma )
                            (throw 'done 'here-maybe-pivot))
               (gcd (multiple-value (best no-gcd)
                      (catch-error (send self :gcd-row pivot-row-number) nil))
                    
                    (setq test (function equal)))
               (min (setq best (send self :smallest-possible-pivot))
                    (setq test (function equal)))
               (gcd-column (setq best (send self :smallest-possible-pivot))
                           (setq test (function equal)))
               (unit (cond ((numberp type-of-entries) (setq best 1)
                            (setq test (function (lambda (ignore  ignore) t))))
                           (t (setq best 1) (setq test (function equal)))))
               (otherwise (ferror "~A is not a possible test." test-name)))
             (setq value nil)
             (cond
               (no-gcd nil)
               ((or   (null best) (macsyma:$zerop  best))
                (fmat t "~%Row ~D was found to be zero while looking for ~A."
                        pivot-row-number
                        test-name)
                (send self :put-back-row-with-no-pivot))
               ((and (eq test-name 'gcd) no-gcd) nil)
               (t
                (with-once-only
                  (pivot-row)
                  (loop for ii below (array-active-length pivot-row) by 2
                        when (aref pivot-row ii)
;                                (and (aref pivot-row ii )      
;                                          (null (gethash  ;;these entries shou
ld be zero!!
;                                                  (aref pivot-row ii )
;                                                  columns-used-to-pivot)))
                        do  (setq value (abs (aref pivot-row (add1 ii ))))
                        
                        (cond ((funcall test value best)
                               (setq col-to-pivot (aref pivot-row ii))
                               (cond ((equal test-name 'gcd-column)
                                      (cond
                                        ((and
                                           (desirable-row pivot-row)
                                           (setq temp-col
                                                 (send self
                                                        :find-good-column-to-pi
vot)))
                                         (setq col-to-pivot temp-col)))
                                      
                                      (setq pivot-entry
                                            (send self
                                                  :force-pivot-row-to-contain-g
cd
                                                  col-to-pivot))
                                      (setq pivot-row (aref rows pivot-row-numb
er)))
                                     (t (setq pivot-entry
                                              (aref pivot-row (add1 ii) ))))
                               (send self :enter-pivot-data col-to-pivot )
                               (*throw 'done 'here-is-pivot)))))))
             (cond ( no-gcd nil)
                   ((null value)
                    (send self :put-back-row-with-no-pivot)
                    (fmat t "It is zero.")))
;                        (fmat t "~%Row ~D has no possible pivot." pivot-row-nu
mber)
;                                               (aset 1 rows-with-no-pivot pivo
t-row-number)
;                                               (*throw 'done 'no-pivot)))
;                 (cond ((memq test-name '(min any gcd-column))
;                        (fmat t "There  is no possible pivot in row ~D." pivot
-row-number)
;                        (aset 1 rows-with-no-pivot pivot-row-number)))
             (cond (no-gcd (fmat t "~%Row ~D has no gcd." pivot-row-number))
                   ((eq test-name 'gcd)
                    (fmat t "~%Row ~D has gcd ~D but no pivot of that size."
                            pivot-row-number best ))
                   ((eq test-name 'unit)
                    (fmat t "~%Row ~D does not have a unit for a pivot."
                            pivot-row-number)))
             
             (setq fresh-row (send self :swap-pivot-row-with-later-one)))))))))
(defmacro swap-rows-and-constants (m n)
  `(prog () (swapf (aref rows ,m) (aref rows ,n))
         (setq sign-of-row-permutation (minus sign-of-row-permutation))
         ;(cond ((variable-boundp sign)(setq sign (- sign))) ;;keep track of si
gn for det
         (cond (constants-column
                (swapf (aref constants-column ,m) (aref constants-column ,n))))
))
(defmethod (sparse-matrix :put-back-row-with-no-pivot)()
  (cond (row-number-before-swap
         (swap-rows-and-constants pivot-row-number row-number-before-swap)
                ;(swapf (aref rows pivot-row-number) (aref rows row-number-befo
re-swap ))
         (fmat t "There is no pivot in row ~D so exchanging it back"
                 row-number-before-swap )
         (setq pivot-row (aref rows pivot-row-number))
         
         (aset 1 rows-with-no-pivot row-number-before-swap )
         (setq row-number-before-swap nil))))

(defmethod (sparse-matrix :swap-pivot-row-with-later-one)()
  "Returns t if it did nil if it did not"
  (*catch 'exchanged
    (loop for j downfrom last-good-row 
          until (<= j pivot-row-number)
          when  (macsyma:$zerop  (aref rows-with-no-pivot j))
          do (swap-rows-and-constants pivot-row-number j)
          ;(swapf (aref rows pivot-row-number) (aref rows j))
          (setq pivot-row (aref rows pivot-row-number))

        (setq last-good-row (sub1 j) )
        (setq row-number-before-swap j)        
        (fmat t " Exchanging Row ~D for Row ~D." pivot-row-number j)
        (*throw 'exchanged t))
    nil))
;macsyma:
;(defun sp-rat (x)($vrat x))
;;the new generic functions n* n+ etc. do not require rat form entries, they co
nvert to
;;them.
;
;(defmethod (sparse-matrix :best-pivot-macsyma)()
;  (loop for i below (array-active-length pivot-row) by 2
;       when (aref pivot-row i)
;       do
;       
;       (setq pivot-entry (aref pivot-row (add1 i)))
;       (cond ((numberp pivot-entry) nil)
;             (t (cond ((macsyma:$numberp pivot-entry)
;                       (setq pivot-entry
;                             (cond ((atom pivot-entry)pivot-entry)
;                                   ((or (macsyma:polynomialp pivot-entry)
;                                        (macsyma:rational-functionp pivot-entr
y))
;                                    pivot-entry)
;                                   
;                                   (t
;                             (macsyma:$ratsimp pivot-entry)))))
;                      (t
;                       (setq pivot-entry (macsyma:sp-rat pivot-entry))
;                       ))
;                (aset  pivot-entry pivot-row (add1 i) )))
;       (send self :enter-pivot-data (aref pivot-row i))
;       (return 'done)
;       finally (cond ((send self :swap-pivot-row-with-later-one)
;                      (send self :best-pivot-macsyma)))))
;
;(defmethod (sparse-matrix :best-pivot-macsyma)()
;  (cond ((loop for i below (array-active-length pivot-row) by 2
;              when (and (aref pivot-row i)
;                        (macsyma:$numberp
;                          (aref pivot-row (add1 i))))
;              do
;              (setq pivot-entry (aref pivot-row (add1 i)))
;              (send self :enter-pivot-data (aref pivot-row i))
;              (return 'done)))
;       (t
;        (loop for i below (array-active-length pivot-row) by 2
;              when  (aref pivot-row i)
;              do
;              (setq pivot-entry (aref pivot-row (add1 i)))
;              (send self :enter-pivot-data (aref pivot-row i))
;              (return 'done)
;              finally (cond ((send self :swap-pivot-row-with-later-one)
;                             (send self :best-pivot-macsyma)))))))


(defmethod (sparse-matrix :best-pivot-macsyma)()
  (loop named sue for test in (list #'(lambda (x) (or (eq x -1)(eq x 1)))
                                    #'(lambda (x) (and (numberp x) (< (abs x) 1
00)))
                                    #'(lambda (x) (numberp x))
                                    #'(lambda (x) (macsyma:$numberp x))
                                    #'(lambda (ignore) t))
        do                
        (loop for i below (array-active-length pivot-row) by 2
              when (and (aref pivot-row i)
                        (funcall test
                                 (aref pivot-row (add1 i))))
              do
              (setq pivot-entry (aref pivot-row (add1 i)))
              (send self :enter-pivot-data (aref pivot-row i))
              (return-from sue 'done))
        finally (cond ((send self :swap-pivot-row-with-later-one)
                       (send self :best-pivot-macsyma)))))



(defmethod (sparse-matrix :smallest-possible-pivot)(&aux  (.pivot-row. pivot-ro
w))
  (loop for ii below (array-active-length  .pivot-row.) by 2
        when (aref .pivot-row. ii)
;       (and (setq col (aref .pivot-row. ii )) (null (gethash col
;                                                      columns-used-to-pivot)))
        minimize (abs (aref .pivot-row. (add1 ii )))))
 
(defmethod (sparse-matrix :verify-solutions-for-original-array) (aarray)
  (send self :get-rows-from-array aarray type-of-entries)
  (send self :verify-solutions))



(defmethod (sparse-matrix :init) (plist)
  (let ((initial-data (get plist ':rows))
        (atype-of-entries (get plist ':type-of-entries))
        (asolutions (get plist :solutions))
        (acolumn-used-in-row (get plist :column-used-in-row))
        (acolumns-used-to-pivot (get plist :columns-used-to-pivot)))
    (if initial-data (send self :set-rows initial-data))
    (if atype-of-entries (send self :set-type-of-entries atype-of-entries))
    (if asolutions (send self :eval-inside-yourself `(setq solutions ',asolutio
ns)))
    (if acolumns-used-to-pivot (send self :eval-inside-yourself
                                    `(setq columns-used-to-pivot ',acolumns-use
d-to-pivot)))
    (if acolumn-used-in-row (send self :eval-inside-yourself
                                   `(setq column-used-in-row ',acolumn-used-in-
row)))))

;(once (piv div ) (setq div 4)(setq piv 3));;watch out if control leaves in mid
dle of body the
                ;values of the variables may not be restored!!


(defun create-sparse-matrix (&rest options)

  (LET* ((PLIST (CONS NIL (COPYLIST OPTIONS)))
         (FLAVOR (GET PLIST ':FLAVOR)))
    flavor
    (REMPROP PLIST ':FLAVOR)
    (INSTANTIATE-FLAVOR 'sparse-matrix PLIST ':MAYBE NIL
                        (GET PLIST ':AREA))))




;;The t in the instantiate-flavor tells it to send the :init message to
;;the newly created flavor.  It uses the values present in the options-present
;;list.  The catch-error is for those instance variables which may be unbound.
;;We do not want them on the options-present list.

(defmethod (sparse-matrix :fasd-form) ()
  (let ((options-present
          (loop for u in (list :so-present t)))
(defun set-fill-pointer (array n)
  (store-array-leader n array 0))
(defmethod (sparse-matrix :make-transpose) ()
  "Creates the transpose of the sparse-matrix.  The result is stored in the tra
nspose
   instance-variable.  The original column is stored in slot 1 of the array-lea
der of the row"
  (let ((transpose-rows (make-array (length list-of-all-columns-occurring)))
        
        rowj val)
    (setq list-of-all-columns-occurring (sort list-of-all-columns-occurring '<)
)
    (loop for j in list-of-all-columns-occurring
          and for i below (length list-of-all-columns-occurring)
          do
          (setq rowj (make-array 100 :leader-list (list 0 j)))
          
          
          (loop for ii below number-of-rows
                when (setq val (send self :entry ii j))
                do
                (array-push-extend-replace rowj ii)
                (array-push-extend-replace rowj val))
          
          (aset  rowj transpose-rows i))
    
    (setq transpose (make-instance 'sparse-matrix
                                    :rows transpose-rows
                                    :type-of-entries type-of-entries))))

(defmacro make-sparse-matrix (array name)
 ` (progn (setq ,name (make-instance 'sparse-matrix))
  (send ,name :get-rows-from-array ,array)))


;;   To handle integer matrices properly we will have to find the pivot
;;in a given column.  To do this we will find the gcd of that column.
;;Then find a row where it occurs or create a linear combination of rows
;;where it occurs. WE add that to the set of rows.  Then use that row to
;;clean the given column.  The span over Z of the set of rows is the
;;same as before (since adding a row did not hurt and cleaning out with
;;respect to a given row is a reversible operation, since all entries in
;;that column are integer multiples of the given entry).

;;   We repeat the process applying it to the "set of rows occurring
;;after our row and to the remaining columns" Note that the previous
;;pivot column does not occur anyway.  Eventually we end up with a set
;;of rows which span the same lattice as the original, but which are
;;clearly independent over the rationals.  Therfore the number of them
;;must be correct and they must be a basis.

;;   Alternateley we could take our row and choose some column say j.
;;Then we could perform row' -q*row + remainder.  We would then replace
;;row' by remainder.  Here row' is another row that has an entry in
;;column j which is not a multiple of the the entry in row column j.
;;The remainder will have an entry smaller than that of row. Then we swap
;; the new row' and row.  If row now has entry in column j 
;;equal to the gcd of the column, fine we use the remainder as our
;;pivot.  Otherwise we repeat with remainder taking the place of row and
;;we find some row' whose entry in column j is not a multiple of the
;;entry in row column j.

(defmethod (sparse-matrix :set-current-column-above-pivot-row-number ) (j)
;  (setq current-column-number j)
  (cond ((flag current-column-above-pivot-row-number)
         (setq current-column-above-pivot-row-number
               (adjust-array-size current-column-above-pivot-row-number
                             number-of-rows))
         (fillarray current-column-above-pivot-row-number nil))
        (t (setq current-column-above-pivot-row-number
                 (make-array number-of-rows ))))
           (loop for i from pivot-row-number below number-of-rows
                 do (aset (send self :entry i j)
                          current-column-above-pivot-row-number  i)))

(defmethod (sparse-matrix :set-constants-column) (j &aux this-row)
  (setq constants-column-number j)
  (cond (constants-column (if (< (array-length constants-column) (array-length 
rows))
                          (setq constants-column
                                (array-grow constants-column (array-length rows
)))))
        (t (setq constants-column (make-array (array-length rows) :fill-pointer
 0))))
  (fillarray constants-column '(0))
  (setq list-of-all-columns-occurring
        (delete constants-column-number list-of-all-columns-occurring))
  (loop for i below number-of-rows
        do
        (setq this-row (aref rows i))
        (loop for ii below (array-active-length this-row) by 2
              when (eq (aref this-row ii) j)
              do
              (aset nil this-row ii)
        (aset (aref this-row (add1 ii)) constants-column i))))
  
(defun where-the-min (an-array &aux temp the-min where-the-min)
  "Where an-array has its minimum"
  (loop for i below (array-length an-array) do
        (cond ((setq the-min (aref an-array i)) (setq where-the-min i) (return 
'done))))
    (cond ((null where-the-min) nil)
        (t (setq the-min (abs the-min))
           (loop for i below (array-length an-array)
                 
                 when (and (setq temp (aref an-array i)) (< (abs temp) the-min)
)
                 do (setq where-the-min i))))
        
  where-the-min)

(defmethod (sparse-matrix :force-pivot-row-to-contain-gcd) (j)
  "J is column number.  Elementary row operations and swaps of rows
   are performed with rows occurring after pivot-row-number to ensure that
   the pivot-row contains the gcd of the entries in rows greater than
   the pivot-row-number and in column j."
  (send self :set-current-column-above-pivot-row-number j)
  (let* ((colj current-column-above-pivot-row-number)
        (first-entry (aref colj pivot-row-number)) temp
         rem factor  where-the-smallest-remainder
         the-gcd where-the-min smallest-remainder )
    (setq temp first-entry)
    (setq the-gcd temp)
    (loop for i below (row-length current-column-above-pivot-row-number)
          when (setq temp (aref colj i))
          do (setq the-gcd (gcd temp the-gcd)))
    (loop
      do
      (setq where-the-min (where-the-min colj))
      (cond ((neq where-the-min pivot-row-number)
             (swap-rows-and-constants pivot-row-number where-the-min)
            ; (swapf (aref rows pivot-row-number) (aref rows where-the-min))
             ;(swapf (aref colj pivot-row-number) (aref colj where-the-min))
             (fmat t "~%Exchanging  rows ~D and ~D to help force gcd ~D into pi
vot-row."
                     pivot-row-number where-the-min the-gcd)
             (send self :set-pivot-row pivot-row-number)))
      (cond
        ((equal the-gcd (abs (aref colj  pivot-row-number )))
         (fmat t "~%Row ~D has ~D in column ~D which is the gcd of the column a
bove row ~D."
                 pivot-row-number (aref colj  pivot-row-number) j pivot-row-num
ber)
         (return the-gcd))
        (t
         (setq smallest-remainder (abs (aref colj  pivot-row-number)))
         (loop for i below (array-length colj)
               when (and
                      (aref colj i)
                      (not (macsyma:$zerop  (setq rem (mod (aref colj i)
                                                    (aref colj pivot-row-number
)))))
                         (< rem smallest-remainder))
               do (setq where-the-smallest-remainder i) (setq smallest-remainde
r rem))

SHUTDOWN message on CRLV4 from user CHANG at _CRLV4$OPA0:   10:53:03

CRLV4 will shut down in 8 minutes; back up shortly via automatic reboot.
REBOOT



         (setq factor (special-times -1
                                      (aref colj where-the-smallest-remainder)
                                (special-inverse       (aref colj pivot-row-num
ber))))
         (send self :set-current-row where-the-smallest-remainder)
         (send self :row-operation factor)
         (aset (special-plus (special-times (aref colj pivot-row-number)
                                            factor)
                             (aref colj current-row-number)) 
               colj current-row-number))))
    (aref colj pivot-row-number)))

(defun gcd-array (an-array &aux where the-gcd temp)
 "Gcd of all non-nil elements occurring in an array"
  (loop for ii below (array-length an-array)
        until (setq the-gcd (aref an-array ii)))
  (loop for ii below (array-length an-array)
        when (setq temp (aref an-array ii))
        do (setq the-gcd (gcd the-gcd temp))
        (cond ((equal the-gcd (abs temp)) (setq where ii)
               (cond ((eq the-gcd 1) (return 'done))))))
  (values the-gcd where))
(defun rational-inverse (x)
  (sys:rational-quotient 1 x))


(defun divides (a b)
  (macsyma:$zerop  (mod b a)))

(defmethod (sparse-matrix :find-good-column-to-pivot) ( &aux the-gcd)
  "Trys to find a column where the gcd is equal to the entry of the pivot-row
   without changing the pivot row"
  (loop for ii below (array-active-length pivot-row) by 2
        when (aref pivot-row ii)
        do (send self :set-current-column-above-pivot-row-number (aref pivot-ro
w ii))
        (setq the-gcd (gcd-array current-column-above-pivot-row-number))
        (cond ((eq (abs (aref pivot-row (add1 ii))) the-gcd)(return (aref pivot
-row ii))))))
(defmethod (sparse-matrix :gcd-column) (j )
  (setq pivot-row-number 0)
  (send self :set-current-column-above-pivot-row-number j)
     
    (gcd-array current-column-above-pivot-row-number))
  
(defun show-gcd-of-columns (a-sparse-matrix)
  (let (the-gcd where (all-col (send a-sparse-matrix :list-of-all-columns-occur
ring)))
    (loop for i in all-col do
          (multiple-value (the-gcd where) (send a-sparse-matrix :gcd-column i))
          (format t "~%Column ~D has gcd ~D at it occurs in row ~A. "i the-gcd 
where))))

(defmethod (sparse-matrix :show-row-array-leaders)()
  (loop for i below (array-length rows)
        do
        (format t "~% Row ~D has array-leader ~A." i (list-array-leader
                                                       (send self :row i)))))

(defmethod (sparse-matrix :make-rows-desirable) (&rest a-list &aux temp this-ro
w)
  (loop for i in a-list
        do
        (setq this-row (aref rows i))
        (setq temp (make-array (array-length (aref rows i))
                               :leader-list (list (fill-pointer this-row ) nil)
))
        (fillarray temp this-row)
        (aset  temp rows i)))
si:
(defmethod (si:basic-hash-table :get-key) (value)
  (*catch 'key
    (send self :map-hash `(lambda (u v) (cond ((eq v ,value) (*throw 'key u))))
)))

(defvar *verbose* nil)
(defun fmat (&rest l)
  (cond (*verbose* (lexpr-funcall 'format l))
        (t nil)))


(defmethod (sparse-matrix :show-column) (j)
           (loop for i below number-of-rows do
                 (format t "~% entry in row ~D col ~D is ~A" i j (send self :en
try i j))))
(defmethod (sparse-matrix :verify-columns-above-pivots-are-zero)(&aux (ok t) co
l )
  "Verifies the entries above the pivot are indeed 0"
  (loop for i below number-of-rows
        when (setq col (aref column-used-in-row i))
        do
        (setq ok t)
        (loop for ii from (add1 i) below number-of-rows
              when (send self :entry ii col)
              do (format t "~%Pivot in row ~A has nonzero entry above it in col
umn ~A row ~D."
                         i col ii)
              (setq ok nil))
        (cond (ok
               (format t "~%For Row ~D column ~D is ok above the pivot" i col))
)))

(defmethod (sparse-matrix :reduce-row-with-respect-to-rows) (a-row
                                                              &aux (not-done t)
                                                              piv-row col facto
r)
  "Cleans out all the columns in a-row such that rows has a pivot in that colum
n."
  
  (setq current-row a-row)
  (setq current-row-number "Fake row number")
  (loop while not-done
        do
  (loop for ii below (array-active-length a-row) by 2
        when (and (setq col (aref a-row ii))(setq piv-row (send columns-used-to
-pivot
                                                                :get-hash col))
)
        do
        (send self :set-pivot-row piv-row)
        (setq pivot-entry (send self :entry piv-row col))
        (setq factor
              (special-times -1
                             (special-inverse pivot-entry)
                             (aref a-row (add1 ii))))
        (send self :row-operation factor)
        (return 'try-again)
        finally (setq not-done nil)))
  (send self :set-current-row 0)
  a-row)

(defmethod (sparse-matrix :determinant)(&aux answer col entry (correct 0))
  (setq sign-of-row-permutation 1)
  
  (send self :reduce)
  (setq answer sign-of-row-permutation)
  (loop for i below number-of-rows
        when (eq 0 (aref column-used-in-row i))
        do (return 'done)
        finally (setq correct -1))
    (loop for i below number-of-rows
          when (setq col (aref column-used-in-row i))
          do
          
          (setq entry (send self :entry i col)) 
          (setq answer (macsyma:sp-mul* answer entry))
          and
          collecting (+ col correct) into tem
          else
          do (format t "~%There is no pivot in row ~A" i)(return 0 )
          finally
                  (return (setq answer (macsyma:sp-mul*
                            (macsyma:sign-of-permutation tem)
                              answer))))
     answer)
 
@