;;; -*-Lisp-*-

;;; A little bit of topology.

(deftype topology
  (lambda (T collection)
    (and (is the-empty-set (element-of T))
	 (forall (A (subset T))
	   (is (coll-union A)
	       (element-of T)))
	 (forall (A (finite-subset T))
	   (is (coll-intersection A)
	       (element-of T))))))

(deftype (topology-on (S set))
  (lambda (T topology)
    (is S (coll-union T))))

(deftype space
  (term-type (assign 'uset S 'topology T struct)
	     (S set)
	     (T (topology-on S))
	     (struct structure)))

(defterm (make-space (S set) (T (topology-on S)))
  (assign 'uset S
	  'topology T))

(defterm the-topology
  (apply-struct 'topology))

(deftype open-set
  (element-of the-topology))

(deftype continuous-map
  (lambda (F function)
    (with-map F
      (and (is the-domain   space)
	   (is the-codomain space)
	   (in the-codomain
	     (forall (U open-set)
	       (in the-domain
		 (is (preimage U) open-set))))))))

(deftype (continuous-map-from-to (X space) (Y space))
  (lambda (F (function-from-to X Y))
    (is F continuous-map)))

(deftype homeomorphism
  (lambda (phi continuous-map)
    (exists (inv (inverse-map phi))
      (is inv continuous-map))))

(deftype basis
  (lambda (B collection)
    (forall (U (element-of B))
      (forall (V (element-of B))
	(forall (x (element-of (intersection U V)))
	  (exists (W (element-of B))
	    (is x (member-of W))))))))

(lemma (forall (S total-order)
	 (is (set-of-all open-interval) basis)))

(defterm (topology-generated-by-basis (B basis))
  (set-of-all (term-type (coll-union Z)
		(Z (subset B)))))

(defterm (order-topology (S total-order))
  (topology-generated-by-basis (set-of-all open-interval)))

(defterm (order-topology-space (S total-order))
  (assign 'topology (order-topology S) S))

(deftype has-order-topology
  (term-type (order-topology-space S)
    (S total-order)))

(deftype linear-continuum
  (lambda (X total-order)
    (and (is X dense-order)
	 (is X complete-order)
	 (is X has-order-topology))))

(defterm (make-subspace-topology (S (subset uset)))
  (set-of-all (term-type (intersection S U)
		(U open-set))))

(defterm (subspace (S (subset uset)))
  (assign 'topology (make-subspace-topology S)
	  'uset S))

(defterm unit-interval
  (in *the-reals*
    (subspace (closed-interval zero one))))

(deftype (path-from-to (x in-uset) (y in-uset))
  (lambda (f (continuous-map-from-to unit-interval *the-structure*))
    (with-map f
      (and (= (map zero) x)
	   (= (map one) y)))))

(deftype (loop-at (x in-uset))
  (path-from-to x x))

;;; Product topology
;;; Homotopy
;;; Homotopic
;;; Relative homotopy
;;; Path homotopic
;;; Equivalence relations
;;; Equivalence classes
;;; Fundamental groupoid
;;; Fundamental group


;;; Local Modes:
;;; Lisp forall Indent:1
;;; Lisp exists Indent:1
;;; Lisp term-type Indent:1
;;; Lisp in Indent:1
;;; Lisp with-map Indent:1
;;; Lisp with-brule Indent:1
;;; Lisp with-rule Indent:1
;;; End:
