;;; -*- Mode:LISP; Package:USER; Fonts:(CPTFONT HL12B HL12BI); Base:10 -*-

(DEFUN backup-to-tape (&optional (directory "lam2:nichols;") (copy-subdirs? t))
  "2Backup 'directory' to tape. Will optionally backup all subdirectories. Defalt is T.*"
  (mt:%MULTIBUS-IO-WRITE-8 (mt:TM+ :IO 1) 0)          ;1 reset system configuration-pointer* 
  (COMPILER:%MULTIBUS-WRITE-8                   ; 1a 16 bit bus*
    mt:tapemaster-system-configuration-pointer-address 1)
  (COMPILER:%MULTIBUS-WRITE-8                   ; 1unused byte*
    (mt:TM+ :configuration-pointer 1) 0)	
  (COMPILER:%MULTIBUS-WRITE-8                   ; 1low 8 bits*
    (mt:TM+ :configuration-pointer 2)
    (LDB #o0010 mt:tapemaster-system-configuration-block-address))
  (COMPILER:%MULTIBUS-WRITE-8                   ; 1next 8 bits*
    (mt:TM+ :configuration-pointer 3)
    (LDB #o1010 mt:tapemaster-system-configuration-block-address))
  (COMPILER:%MULTIBUS-WRITE-8
    (mt:TM+ :configuration-pointer 4)
    (LDB #o2010 mt:tapemaster-system-configuration-block-address))
  (COMPILER:%MULTIBUS-WRITE-8
    (mt:TM+ :configuration-pointer 5)
    (LDB #o3010 mt:tapemaster-system-configuration-block-address))
  ; 1set up system configuration block*
  (mt:=MULTIBUS-WRITE-16 mt:tapemaster-system-configuration-block-address 3)
  (mt:=MULTIBUS-WRITE-16 (mt:TM+ :configuration-block 2)
                      mt:tapemaster-channel-control-block-address)
  (mt:=MULTIBUS-WRITE-16 (mt:TM+ :configuration-block 4)
                      (LDB #o2020 mt:tapemaster-channel-control-block-address))
  ; 1set up channel control block*
  (mt:=MULTIBUS-WRITE-16 mt:tapemaster-channel-control-block-address #xff11) ; 1ccw and gate*
  (mt:TAPEMASTER-CHANNEL-ATTENTION)                ; 1Send channel attention*
  (mt:TAPEMASTER-WAIT-CONTROLLER-RESTARTABLE 500 "Keep waiting for init to finish")
  ; 1set up*
  (mt:TAPEMASTER-EXECUTE-COMMAND mt:tapemaster-configure 0 0 0 t nil)
  ;1 now find out what happened*
  (WHEN (mt:check-status (mt:tapemaster-status) ':write)
    (PROCESS-RUN-FUNCTION "Tape-Backup" 'backup-to-tape-aux DIRECTORY copy-subdirs?)
      (mt:TAPEMASTER-ERROR-AS-STRING               ;1 this is the drive not the read*
        (LDB mt:%%tapemaster-error (mt:TAPEMASTER-READ-IOPB-16 mt:%tapemaster-status)))))

(DEFUN backup-to-tape-aux (directory copy-subdirs? &aux dir-list)
  ;(LET ((terminal-io (FSYMEVAL 'si:null-stream)))
    ;(DECLARE (SPECIAL terminal-io))
   (notify-user (format nil "Starting backup of ~A to tape." DIRECTORY))
  (write-centered-lines tv:selected-window
                        "Backup in progress.
Do not interupt this LL Process.
The machine is otherwise free.
Use sys-ctrl-l to create a new LL." fonts:cmdunh)
   ;(FORMAT t "~%directory = ~A" DIRECTORY)
  (SETQ directory (SEND (fs:parse-pathname directory)
                      ':new-pathname
                      ':name ':wild
                      ':type ':wild
                      ':version ':wild))
  (SETQ dir-list (IF copy-subdirs?
                     (find-subdirs (NCONS directory))
                     directory))
   ;(FORMAT t "~%DIR-LIST : ~A" dir-list)
  (SEND (tv:window-under-mouse) ':set-deexposed-typeout-action ':permit)
  (SEND (tv:window-under-mouse) ':set-more-p nil)
  (ERRSET
    (progn
     (LOOP for dir in
           (IF (OR (NULL (VARIABLE-BOUNDP *directory-last-sucessfully-copied*)) 
                   (null (EVAL '*directory-last-sucessfully-copied*)))
               dir-list
               (OR (CDR (MEMBER (EVAL '*directory-last-sucessfully-copied*) dir-list))
                   dir-list))
           DO
            ;(FORMAT t "~%IN LOOP DIR = ~A" dir)
           (fs:copy-directory dir "mt:" ':query nil)
            ;(FORMAT t "~%Successfully copied ~A" dir)
           (SETQ *directory-last-sucessfully-copied* dir)
           finally (fs:mt-write-eof)
                   (fs:mt-write-eof)
           (notify-user (format NIL "Backup for ~A is complete." DIRECTORY))
            )) nil)
  (fs:mt-rewind));)

(DEFUN find-subdirs (dirlist)
  "2When passed a directory list, add to the list any non-empty subdirectories which
    occur within the given list of directories. This only works for up to 3 levels of
    nesting.*"
  (SETQ master-list nil)
  (PROG bar()
        (DOLIST (dir dirlist)
           ;(format t "~%Checking for Subdirs in ~A" dir)
           (PUSH dir master-list)                    1 ;we know this is a valid directory*
           (SETQ elements-1 (CDR (SEND dir ':directory-list nil)))  1 ;get everything in this dir*
           (DOLIST (element elements-1)
             (SETQ p (SEND (CAR element) ':properties))
             ;(FORMAT t "~%Current element is ~A" element)
             ;(FORMAT t "~%~%element is: ~A ~%and the Props are ~A" element p)
           (WHEN (EQ  (CADR (MEMQ ':directory p)) 'T)
             (SETQ sub1dir
                   (SEND (SEND (CAR element) ':pathname-as-directory)
                         ':new-pathname
                         ':name ':wild
                         ':type ':wild
                         ':version ':wild))
             (PUSH sub1dir master-list)
             (SETQ elements-2 (SEND sub1dir ':directory-list nil))
             (COND ((> (LENGTH elements-2) 1)
                    (SETQ elements-2 (CDR elements-2))
                    (DOLIST (element elements-2)
                      (SETQ p (SEND (CAR element) ':properties))
                      (WHEN (EQ  (CADR (MEMQ ':directory p)) 'T)
                        (SETQ sub2dir
                              (SEND (SEND (CAR element) ':pathname-as-directory)
                                    ':new-pathname
                                    ':name ':wild
                                    ':type ':wild
                                    ':version ':wild))
                        (WHEN (CDR (SEND sub2dir ':directory-list nil))
                          (PUSH sub2dir master-list)))))))))
  (RETURN (NREVERSE master-list))))

(DEFUN notify-user (message)
  (if tv:selected-window
      (let ((old-more-p (send tv:selected-window ':MORE-P)))
        (unwind-protect
            (progn (send tv:selected-window ':SET-MORE-P NIL)
                   (tv:notify NIL message))
          (send tv:selected-window ':SET-MORE-P old-more-p)))
      (tv:notify NIL message)))

MT:
(DEFUN check-status (STATUS operation &aux (flag t))
  "2verify that the tape is ready and complain if it 'aint*"
  (WHEN (AND (EQ operation ':write)
             (LDB-TEST %%tapemaster-write-protect STATUS))
    (FORMAT terminal-io "~&Write ring missing")
    (SETQ flag nil))
  (WHEN (ZEROP (LDB %%tapemaster-ready STATUS)) 
    (FORMAT terminal-io "~&Drive not ready ; Check drive and try again")
    (SETQ flag nil))
  (WHEN (LDB-TEST %%tapemaster-formatter-busy STATUS)
    (FORMAT terminal-io "~&Formatter busy ; Check drive")
    (SETQ flag nil))
  (WHEN (ZEROP (LDB %%tapemaster-online STATUS))
    (FORMAT terminal-io "~&Drive is not on line")
    (SETQ flag nil))
  (WHEN (ZEROP (LDB %%tapemaster-load-point STATUS))
    (FORMAT terminal-io "~&Tape not loaded at the beggining, rewind")
    (SETQ flag nil))
  (WHEN (LDB-TEST %%tapemaster-error STATUS)
    (FORMAT terminal-io
            "~%ERROR ~D.: ~A"
            (LDB %%tapemaster-error STATUS)
            (TAPEMASTER-ERROR-AS-STRING (LDB %%tapemaster-error STATUS)))
    (SETQ flag nil))
  (WHEN (ZEROP (LDB %%tapemaster-complete STATUS))
    (FORMAT terminal-io "~&Command incomplete ; fix and try again")
    (SETQ flag nil))
  (WHEN (ZEROP (LDB %%tapemaster-entered STATUS))
    (FORMAT terminal-io
            "~&Command did not reach controller ; fix any errors and retry")
    (SETQ flag nil))
  (WHEN (OR (NOT (ZEROP (TAPEMASTER-READ-IOPB-16 %TAPEMASTER-LINK)))
            (NOT (ZEROP (TAPEMASTER-READ-IOPB-16 %TAPEMASTER-LINK-HIGH))))
    (FORMAT terminal-io "~&WARNING : Interrupt//Link field is not zero"))
  flag)

(DEFUN Backup-to-Lam5 ()
  (fs:balance-directories "lam2:nichols;*.lisp" "lam5:nichols;*.lisp"
                                 ':direction ':1->2 ':query-mode nil)
;  (fs:balance-directories "lam2:nichols.cube;*.lisp" "lam5:nichols.cube;*.lisp"
;                                 ':direction ':1->2 ':query-mode nil)
;  (fs:balance-directories "lam2:nichols.demo;*.lisp" "lam5:nichols.demo;*.lisp"
;                                 ':direction ':1->2 ':query-mode nil)
;  (fs:balance-directories "lam2:nichols.fonts;*.lisp" "lam5:nichols.fonts;*.lisp"
;                                 ':direction ':1->2 ':query-mode nil)
  (fs:balance-directories "lam2:nichols.graphics;*.lisp" "lam5:nichols.graphics;*.lisp"
                                 ':direction ':1->2 ':query-mode nil)
  (fs:balance-directories "lam2:nichols.hacks;*.lisp" "lam5:nichols.hacks;*.lisp"
                                 ':direction ':1->2 ':query-mode nil)
  (fs:balance-directories "lam2:nichols.math;*.lisp" "lam5:nichols.math;*.lisp"
                                 ':direction ':1->2 ':query-mode nil)
;  (fs:balance-directories "lam2:nichols.marine;*.lisp" "lam5:nichols.marine;*.lisp"
;                                 ':direction ':1->2 ':query-mode nil)
;  (fs:balance-directories "lam2:nichols.survey;*.lisp" "lam5:nichols.survey;*.lisp"
;                                 ':direction ':1->2 ':query-mode nil)
;  (fs:balance-directories "lam2:nichols.turtle;*.lisp" "lam5:nichols.turtle;*.lisp"
;                                 ':direction ':1->2 ':query-mode nil)
;  (fs:balance-directories "lam2:nichols.ucl;*.lisp" "lam5:nichols.ucl;*.lisp"
;                                 ':direction ':1->2 ':query-mode nil)
  (fs:balance-directories "lam2:nichols.utilities;*.lisp" "lam5:nichols.utilities;*.lisp"
                                 ':direction ':1->2 ':query-mode nil)
  (fs:balance-directories "lam2:nichols.window;*.lisp" "lam5:nichols.window;*.lisp"
                                 ':direction ':1->2 ':query-mode nil)
  (fs:balance-directories "lam2:nichols.zmacs;*.lisp" "lam5:nichols.zmacs;*.lisp"
                                 ':direction ':1->2 ':query-mode nil))

;(DEFUN backup-to-tape (&optional (directory "lam2:nichols;") (copy-subdirs? t) &aux dir-list)
;  (mt:tapemaster-initialize)
;  (write-centered-lines tv:selected-window
;                        "Backup in progress.
;Do not interupt this LL Process.
;The machine is otherwise free.
;Use sys-ctrl-l to create a new LL." fonts:cmdunh)
;  ;(FORMAT t "~%directory = ~A" DIRECTORY)
;  (SETQ directory (SEND (fs:parse-pathname directory)
;                      ':new-pathname
;                      ':name ':wild
;                      ':type ':wild
;                      ':version ':wild))
;  (COND (copy-subdirs?
;         (SETQ dir-list (find-subdirs
;                          (NCONS DIRECTORY)))))
;  (SEND (tv:window-under-mouse) ':set-deexposed-typeout-action ':permit)
;  (SEND (tv:window-under-mouse) ':set-more-p nil)
;  (ERRSET
;    (progn
;     (LOOP for dir in
;           (IF (OR (NULL (VARIABLE-BOUNDP *directory-last-sucessfully-copied*)) 
;                   (null (EVAL '*directory-last-sucessfully-copied*)))
;               dir-list
;               (OR (CDR (MEMBER (EVAL '*directory-last-sucessfully-copied*) dir-list))
;                   dir-list))
;           DO 
;;           (LOOP for i from 1 to 21
;;            DO (FORMAT t
;;               "~% ~% File system backup in progress. Do not interupt this LL Process")
;;               (FORMAT t
;;               "~% The machine is otherwise free. Use sys-ctrl-l to create a new LL")
;;            finally (FORMAT t "~% ~%"))
;;           (FORMAT t "~%Succesfully copied ~A" dir)
;           (fs:copy-directory dir "mt:" ':query-nil)
;           (SETQ *directory-last-sucessfully-copied* dir)
;           finally (fs:mt-write-eof)
;                   (fs:mt-write-eof)
;                   (FORMAT t "~% ~% File system backup for ~a is complete" directory))) nil)
;  (fs:mt-rewind))

