;;           -*- Package:SYSTEM-INTERNALS; Mode:LISP; Base:8 -*-


;;;
;;; Copyright (c) 1984 Texas Instruments Incorporated  All Rights Reserved
;;;


(DEFUN CALLED-FUNCTIONS (Caller &aux defn tem sym Return-List)  ;works 4/10/84 raf
  "Returns an a-list (name . type) of all? functions called by CALLER."
  (Unless (memq caller '(Global:list))          ;These functions crash us.
    (Setq defn (fsymeval caller))
    (DO ((I %FEF-HEADER-LENGTH (1+ I))
         (lim (Truncate (FEF-INITIAL-PC defn) 2)))
        ((>= I LIM) NIL)
      (Cond ((= DTP-EXTERNAL-VALUE-CELL-POINTER (%P-LDB-OFFSET %%Q-DATA-TYPE defn I))
             (Setq tem (%P-CONTENTS-AS-LOCATIVE-OFFSET defn i)
                   sym (%FIND-STRUCTURE-HEADER tem))
             (If (= (%POINTER-DIFFERENCE tem sym) 2)    ;Function cell reference
                 (Push (cons sym ':FUNCTION) Return-list)))
            ((= DTP-SELF-REF-POINTER (%P-LDB-OFFSET %%Q-DATA-TYPE defn I))
             (LET* ((FN (FEF-FLAVOR-NAME defn)))
               (IF FN
                   (MULTIPLE-VALUE-BIND (sym use)
                       (flavor-DECODE-SELF-REF-POINTER FN (%P-LDB-OFFSET %%Q-POINTER defn I))
                     (If use (Push (cons sym ':FLAVOR) Return-list))))))))
    ;; Check the macros
    (Let ((di (DEBUGGING-INFO defn)))
      (Dolist (M (Cadr (Assq ':MACROS-EXPANDED di)))
        (Push (cons (IF (CONSP M) (CAR M) M) ':MACRO) Return-list)))
    ;; See if we have a function reference compiled into a misc instruction
    (Comment (IF (SYMBOLP SYMBOL)
                 (IF (FEF-CALLS-MISC-FUNCTION DEFN SYMBOL)
                     (FUNCALL FUNCTION CALLER SYMBOL ':MISC-FUNCTION))
               (DOLIST (SYM SYMBOL)
                 (IF (FEF-CALLS-MISC-FUNCTION DEFN SYM)
                     (FUNCALL FUNCTION CALLER SYM ':MISC-FUNCTION)))))
    (Comment (AND (LDB-TEST %%FEFHI-MS-DEBUG-INFO-PRESENT
                            (%P-CONTENTS-OFFSET DEFN %FEFHI-MISC))
                  (SETQ TEM (CDR (ASSQ ':INTERNAL-FEF-OFFSETS
                                       (%P-CONTENTS-OFFSET DEFN (1- (%P-LDB %%FEFH-PC-IN-WORDS DEFN))))))
                  (LOOP FOR OFFSET IN TEM
                        FOR I FROM 0
                        DO (FIND-CALLERS-OF-SYMBOLS-AUX-FEF `(:INTERNAL ,CALLER ,I)
                                                            (%P-CONTENTS-OFFSET DEFN OFFSET))))))
  Return-List)


;(Defun PRINT-CALLED-FUNCTIONS
;       (symbol &optional print-macros (stream-or-file t) pkg (no-levels -1) trace-macros)
;  "Prints all functions called under SYMBOL, in package PKG.  
;   If PKG is nil, use all packages.  PKG may also be a list of pacages. 
;   Will not list functions in GLOBAL pkg unless PKG = 'GLOBAL.
;   STREAM-OR-FILE defaults to the standard output.  It may be a File Name or stream.
;   NO-LEVELS is the number of levels to trace down, -1 represents infinity, 1 is who I call.
;   If PRINT-MACROS is T, macros will be printed.  
;   If TRACE-MACROS is T, all macro calls will be tracecd to see who they call."
;  (if (null pkg) nil
;    (if (symbolp pkg) (setq pkg (list pkg)))
;    (setq pkg (mapcar #'pkg-find-package pkg (circular-list ':find))))
;  (if (typep stream-or-file 'string)
;      (with-open-stream (standard-output (open stream-or-file ':direction ':output))
;        (PRINT-CALLED-FUNCTIONS-INTERNAL
;          symbol pkg
;          "Top Level"
;          print-macros trace-macros
;          nil          no-levels))
;    (let ((Standard-output (if (eq stream-or-file T) standard-output stream-or-file)))
;      (PRINT-CALLED-FUNCTIONS-INTERNAL
;        symbol pkg
;        "Top Level"
;        print-macros trace-macros
;        nil          no-levels))))


(Defun PRINT-CALLED-FUNCTIONS-INTERNAL (Symbol Pkg Label Print-Macros Trace-Macros Callers Levels)
  "Prints all functions called under SYMBOL, except functions in Global pkg.
   If PKG is non-NIL, only traces packages in the PKG list, otherwise traces all packages.
   LABEL describes the type of function object.
   LEVELS is the number of levels to trace down, -1 represents infinity.
   If PRINT-MACROS is T, macros will be printed.  
   If TRACE-MACROS is T, all macro calls will be tracecd to see who they call.
   CALLERS is a list of all the functions above SYMBOL in the recursive descent."
  (When (or (and (null pkg) (neq (symbol-package symbol) (pkg-find-package 'Global)))
            (memq (symbol-package symbol) pkg))
    (When (or print-macros (not (equal label ':Macro)))
      (Format Standard-output "~&~2D:" (length callers))
      (Dotimes (i (length callers)) (Princ "  " Standard-Output))
      (Format Standard-Output "  ~A - ~S" label symbol))
    (Cond ((not (Fboundp symbol))  (Princ " - Undefined" Standard-Output))
          ((member symbol callers) (Princ " - Recursion" Standard-Output))
          ((and (not (= levels 0))
                (or trace-macros (not (equal label ':Macro))))
           (Dolist (elem (CALLED-FUNCTIONS symbol))
             (PRINT-CALLED-FUNCTIONS-INTERNAL (car elem)
                                              pkg
                                              (cdr elem)
                                              print-macros trace-macros
                                              (cons symbol callers)
                                              (1- levels)))))
    ))

