;;; -*- Mode:Common-Lisp; Package:USER; Base:10; Fonts:(CPTFONT TR10B TR10BI TR10I CPTFONTB) -*-

(DEFUN 4NET* (OBJECT)
  "2Locate a net address*"
  (WHEN (NOT (STRINGP OBJECT))
    (SETQ OBJECT (STRING OBJECT)))
  (WITH-OPEN-FILE (NET-LIST "3DAN:NICHOLS;NET.LIST*")
    (LOOP FOR INPUT-LINE = (READ-LINE NET-LIST ()) WHILE INPUT-LINE WHEN
       (SEARCH (THE STRING (STRING OBJECT)) (THE STRING (STRING INPUT-LINE)) :TEST #'CHAR-EQUAL)
       DO (FORMAT T "3~%~A*" INPUT-LINE)))) 

(DEFUN 4NET2* (OBJECT)
  "2Locate a net address*"
  (WHEN (NOT (STRINGP OBJECT))
    (SETQ OBJECT (STRING OBJECT)))
  (WITH-OPEN-FILE (NET-LIST "3cerebus:NICHOLS;NET.LIST*")
    (LOOP FOR INPUT-LINE = (READ-LINE NET-LIST ())
          WHILE INPUT-LINE
          WHEN (SEARCH (THE STRING (STRING OBJECT)) (THE STRING (STRING INPUT-LINE)) :TEST #'CHAR-EQUAL)
          DO (RETURN INPUT-LINE)))) 

(DEFUN 4PHONE* (OBJECT)
  "2Locate a phone number*"
  (WHEN (NOT (STRINGP OBJECT))
    (SETQ OBJECT (STRING OBJECT)))
  (WITH-OPEN-FILE (PHONE-LIST "3Cerebus:NICHOLS;PHONE.LIST*")
    (LOOP FOR INPUT-LINE = (READ-LINE PHONE-LIST ())
          WHILE INPUT-LINE
          WHEN (SEARCH (THE STRING (STRING OBJECT)) (THE STRING (STRING INPUT-LINE)) :TEST #'CHAR-EQUAL)
          DO (FORMAT T "3~%~A*" INPUT-LINE)))) 

(DEFUN 4PHONE2* (OBJECT)
  "2Locate a phone number*"
  (WHEN (NOT (STRINGP OBJECT))
    (SETQ OBJECT (STRING OBJECT)))
  (WITH-OPEN-FILE (PHONE-LIST "3Cerebus:NICHOLS;PHONE.LIST*")
    (LOOP FOR INPUT-LINE = (READ-LINE PHONE-LIST ())
          WHILE INPUT-LINE
          WHEN (SEARCH (THE STRING (STRING OBJECT)) (THE STRING (STRING INPUT-LINE)) :TEST #'CHAR-EQUAL)
          DO (RETURN INPUT-LINE)))) 

;1;;---------------------------*
(defmacro 4with-font* ((font window) &body body)
  (let ((old-font-var (gensym)))
    `(let ((,old-font-var (send ,window :current-font)))
       (unwind-protect
	 (progn (send ,window :set-current-font ,font)
		. ,body)
	 (send ,window :set-current-font ,old-font-var)))))

(DEFUN 4write-string-in-font* (window string font x y)
  (dotimes (index (array-active-length string))
    (SEND window :draw-char font (aref string index) x (- y (/ (tv:font-char-height font) 2)))
    (setq x (+ x (if
		   (tv:font-char-width-table font)
		   (aref (tv:font-char-width-table font) (aref string index))
		   (tv:font-char-width font))))))

(defun 4get-string-length* (string font &aux (hold 0))
  (dotimes (index (array-active-length string))
    (setq hold (+ hold (if
			 (tv:font-char-width-table font)
			 (aref (tv:font-char-width-table font) (aref string index))
			 (tv:font-char-width font)))))
  hold)

(DEFUN 4write-centered-text* (window string font y)
  (write-string-in-font window string font (/ (- (SEND window :width)
							  (get-string-length string font))
						       2) y))

(defun 4write-centered-lines* (window lines font)
  (SEND window :string-out-centered-explicit lines
		(tv:sheet-inside-left window)
		200.
		(tv:sheet-inside-right window)
		(tv:sheet-inside-bottom window)
		font
		tv:alu-ior 0 nil (tv:font-char-height font)))

;1;;------------------------------*
(DEFUN 4UNROLL* (LST)
  "2Return LST with 'all parens' removed, i. e., completely flattened.*"
  (COND ((NULL LST) NIL)
        ((ATOM LST) (LIST LST))
        (T (APPEND (UNROLL (CAR LST)) (UNROLL (CDR LST))))))

(DEFINE-LOOP-PATH 4string-characters* string-chars-path
  (of))

(DEFUN 4string-chars-path* (path-name variable data-type
                          prep-phrases inclusive?
                          allowed-prepositions data
                          &aux (bindings nil)
                               (prologue nil)
                               (string-var (GENSYM))
                               (index-var (GENSYM))
                               (size-var (GENSYM)))
  allowed-prepositions data ;1unused variables*
  ;1To iterate over the characters of a string, we need to save the string, save the size of*
  ;1the string, step an index variable through that range, setting the user's variable to the*
  ;1character at that index.*
  ;1Default the data-type of the user's variable:*
  (COND ((NULL data-type) (SETQ data-type 'fixnum)))
  ;1We support exactly one "preposition", which is required, so this check suffices:*
  (COND ((NULL prep-phrases)
         (FERROR nil "3OF missing in ~S iteration path of ~S*" path-name variable)))
  ;1We do not support "inclusive" iteration:*
  (COND ((NOT (NULL inclusive?))
         (FERROR nil "3Inclusive stepping not supported in ~S path ~ of ~S (prep phrases = ~:S)*"
                 path-name variable prep-phrases)))
  ;1Set up the bindings*
  (SETQ bindings (LIST (LIST variable nil data-type)
                       (LIST string-var (CADAR prep-phrases))
                       (LIST index-var 0 'fixnum)
                       (LIST size-var 0 'fixnum)))
  ;1Now set the size variable*
  (SETQ prologue (LIST `(SETQ ,size-var (STRING-LENGTH ,string-var))))
  ;1and return the appropriate stuff, explained below.*
  (LIST bindings prologue `(= ,index-var ,size-var)
        nil nil
        ;1char-n is the NIL string referencing primitive.*
        ;1In Zetalisp, aref could be used instead.*
        (LIST variable `(aref ,string-var ,index-var)
              index-var `(1+ ,index-var))))
;1;If on desired the index variable to be user-accessible through the using phrase feature with the*
;1;index keyword, bind index-var to (si:loop-named-variable 'index) instead of (gensym) and change*
;1;the last form to:*
;1;   (list bindings prologue nil*
;1;        (list index-var `(1+ ,index-var))*
;1;        `(= ,index-var ,size-var)*
;1;        (list variable `(char-n ,string-var ,index-var))*
;1;        nil nil*
;1;        `(= ,index-var ,size-var)*
;1;        (list variable `(char-n ,string-var ,index-var)))*

(DEFUN 4laytex-fontify* (string word-list font &optional (stream *standard-output*))
  (LOOP for ch being the string-characters of STRING
	for i from 1 with j = 0
	with alphabetic-case-affects-string-comparison = t
	DO 
	(WHEN (MEMBER ch '(#\return #\space #\tab #\. #\,) :test 'eq)
	  (COND ((EQ (1- i) j)
		 (write-char (INT-CHAR ch) stream)
		 (SETQ j i))
		(t (LOOP for word in word-list
			 WHEN (LISTP word) DO (SETQ word (CAR word))
;			 WHEN (STRING-EQUAL word string 0 j nil (1- i))
			 WHEN (STRING-EQUAL word string :start1 0 :end1 j :end2 (1- i))
			 DO (FORMAT stream "3{\~a ~v:q}*" font word 'texprint)
			 (write-char (INT-CHAR ch) stream)
			 (RETURN)
			 finally
			 (SEND stream :string-out string j i))
		   (SETQ j i))))
	finally (SEND stream :string-out STRING j i)))  

(DEFUN 4TEXPRINT* (SYMBOL &OPTIONAL (DOWNCASE-P FORMAT::COLON-FLAG) (STREAM *STANDARD-OUTPUT*) &AUX TEMP)
  "2print symbol for tex*"
  (IF (SETQ TEMP
	 (ASSOC SYMBOL
		'((&OPTIONAL . "3optional*") (&KEY . "3key*") (&REST . "3rest*") (&BODY . "3body*"))
		:TEST #'EQ))
    (SETQ SYMBOL (CDR TEMP))
    (IF DOWNCASE-P
      (SETQ SYMBOL (STRING-DOWNCASE SYMBOL))
      (SETQ SYMBOL (STRING SYMBOL))))
  (LOOP FOR CH BEING THE ARRAY-ELEMENTS OF SYMBOL DOING
     (WHEN (OR (EQL CH #\&) (EQL CH #\%))
       (WRITE-CHAR #\\ STREAM))
     (WRITE-CHAR (INT-CHAR CH) STREAM))) 

;(DEFUN texprint (symbol &optional (downcase-p format:colon-flag) (stream *standard-output*) &aux temp)
;  "1print symbol for tex*"
;  (COND ((LISTP symbol)
;	 (TYO #\( stream)
;	 (texprint (CAR symbol) downcase-p stream)
;	 (FORMAT stream " {\sf")
;	 (LOOP for s in (CDR symbol) doing
;	       (TYO #\space stream)
;	       (texprint s downcase-p stream))
;	 (FORMAT stream "}) "))
;	(t
;	 (IF (SETQ temp (ASSOC symbol '((&optional . "\optional") (&key . "\key")
;				       (&rest . "\rest") (&body . "\body"))))
;	     (SETQ symbol (CDR temp))
;	   (UNLESS (OR (SYMBOLP symbol) (STRINGP symbol))
;	     (SETQ symbol (FORMAT nil "~a" symbol)))
;	   (IF downcase-p
;	       (SETQ symbol (STRING-DOWNCASE symbol))
;	     (SETQ symbol (STRING symbol))))
;	 (LOOP for ch being the array-elements of symbol doing
;	       (WHEN (OR (EQL ch #\&) (EQL ch #\%))
;		 (TYO #\\ stream))
;	       (TYO ch stream)))))

(DEFUN document-all-functions (pkg &optional laytex-p (stream *standard-output*))
  "1Document all functions in package PKG*"
  (LET ((functions  (APROPOS "" :dont-print t :predicate 'FBOUNDP :package pkg
			     :inherited nil)))
    (SETQ functions (SORT functions #'STRING-LESSP))
    (LOOP for FUNCTION in functions
	  for doc = (DOCUMENTATION FUNCTION)
	  WHEN doc DO (document-function FUNCTION laytex-p stream)
	  else collect FUNCTION into nodoc-functions
	  finally (COMMENT LOOP for FUNCTION in nodoc-functions doing
			(document-function FUNCTION laytex-p stream)))))

(DEFUN document-function (FUNCTION &optional laytex-p (stream *standard-output*)
			  &aux (doc (DOCUMENTATION FUNCTION)))
  (MULTIPLE-VALUE-BIND (ARGLIST nil macro-p)
      (ARGLIST FUNCTION)
    (WHEN (ATOM ARGLIST) (SETQ ARGLIST nil))
    (COND (laytex-p
	   (FORMAT stream "~2%{\~a{~v:q}{"1 *;1~{~a ~}}~%{~a}}"*
		   (IF macro-p "macro" "function")
		   FUNCTION 'texprint)
	   (WHEN (AND macro-p (LISTP (FIRST ARGLIST)))
	     (TYO #\( stream)
	     (LOOP for ARG in (FIRST ARGLIST) doing
		   (texprint ARG t stream) (TYO #\space stream))
	     (TYO #\) stream)
	     (POP ARGLIST))
	   (LOOP for ARG in ARGLIST doing
		 (texprint ARG t stream) (TYO #\space stream)) 
	   (FORMAT stream "}~%{")
	   (IF doc (laytex-fontify doc (unroll ARGLIST) "it" stream)
	     (TYO #\space stream))
	   (FORMAT stream "}}")
	   )
	  (t (FORMAT stream "~2%~a (~{~a ~})~% 	~~a~"
		     FUNCTION arglist doc)))))

(DEFUN document-all-variables (pkg &optional latex-p (stream *standard-output*))
  "1Document all variables in package PKG*"
  (LET ((variables  (APROPOS "" :dont-print t :predicate 'BOUNDP :package pkg
			     :inherited nil)))
    (SETQ variables (SORT variables #'STRING-LESSP))
    (LOOP for VARIABLE in variables doing
	  (document-variable variable latex-p stream))))

(DEFUN document-variable (variable &optional latex-p (stream *standard-output*))
  (LET ((doc (DOCUMENTATION variable)))
    (WHEN doc
      (IF latex-p
	  (FORMAT stream "~2%{\~a{~v:q}~%{~a}}"
		  "variable" variable 'texprint doc)
	(FORMAT stream "~2%~a% 	~~a~"
		VARIABLE doc)))))

;1;;------------------------------------------*

(DEFUN vaxps (&aux (pw "3kuyeji*"))
  (WHEN (STRING-EQUAL user-id "3Nichols*")
    (PUSHNEW `(("dnichols" "TILDE") ,pw) fs:user-host-password-alist :test #'EQUALP)
    (PUSHNEW `(("dnichols" "HOME") ,pw) fs:user-host-password-alist :test #'EQUALP)
    (PUSHNEW `(("dnichols" "3m2*") ,pw) fs:user-host-password-alist :test #'EQUALP)
    (PUSHNEW `(("dnichols" "3lagoon*") ,pw) fs:user-host-password-alist :test #'EQUALP)
    (PUSHNEW `(("dnichols" "3tan*") ,pw) fs:user-host-password-alist :test #'EQUALP)
    (PUSHNEW `(("dnichols" "3stroke*") ,pw) fs:user-host-password-alist :test #'EQUALP)
    (PUSHNEW `(("DNICHOLS" "ALL41") ,pw) fs:user-host-password-alist :test #'EQUALP)
;    (PUSHNEW `(("DALLAS" "AUSOME") "goodguys") fs:user-host-password-alist :test #'EQUALP)
    #-elroy
    (when (fboundp 'fs:disguise) ;; When FTP is loaded
      (PUSHNEW `("TILDE" "dnichols" ,(fs:disguise pw "dnichols") "") fs:ftp-user-alist :test #'EQUALP))
    ;1; Paper over a bug in FS:LOGIN-HOST-UNIT by ensuring the FS:USER-UNAMES list includes all host/user pairs*
    (LOOP for ((user-id host-name)) in fs:user-host-password-alist
	  for host = (si:parse-host host-name)
	  unless (ASSOC host fs:user-unames :test #'EQ)
	  do (PUSH (CONS host user-id) fs:user-unames))
    t))

(vaxps)
(add-initialization "Remove Passwords" '(setq fs:user-host-password-alist nil) '(:redo :logout))
(add-initialization "Add Passwords" '(vaxps) '(:redo :login))

(DEFUN 4LS* (&OPTIONAL (DIR "3dan:nichols;*.**"))
  "2Brief directory listing. Lists several files per line*"
  (LET (PATHNAME)
    (COND
      (DIR (SETQ PATHNAME (FS:PARSE-PATHNAME DIR)))
      (T (SETQ PATHNAME (FS:PARSE-PATHNAME (PROMPT-AND-READ :PATHNAME-OR-NIL "3~%List Files: *")))))
    (FORMAT T "3~&~A~%*" PATHNAME)
    (LET ((LIST (FS:DIRECTORY-LIST PATHNAME :FAST)))
      (SETQ LIST (DELETE (ASSOC () LIST :TEST #'EQ) (THE LIST LIST) :TEST #'EQ));1Don't care about system info*
      (DO ((L LIST (CDR L)))
	  ((NULL L))
	(SETF (CAR L) (CONS (SEND (CAAR L) :STRING-FOR-DIRED) (CAAR L))))
      (SEND *STANDARD-OUTPUT* :ITEM-LIST 'FILE LIST)))) 

(DEFUN 4DOC* (fun &aux DOC temp)
  "2This is a function which prints the documentation for the specified object.
Unlike DESCRIBE it only prints the documentation for the object and not all of
internal details.*"
  (DECLARE (RETURN-LIST nil))
  (COND-EVERY ((LISTP fun)
	       (SETQ fun (FUNCALL 'FUNCTION fun)))
	      ((FUNCTIONP fun t)
	       (FORMAT t "3~%~A is a function~%*" fun)
	       (MULTIPLE-VALUE-BIND (args RETURN) (ARGLIST fun)
		 (FORMAT t "3arguments  ~A~%*" args)
		 (COND (RETURN (FORMAT t "3returns  ~{~A  ~}~%*" RETURN))))
	       (COND ((SETQ DOC (DOCUMENTATION fun)) (FORMAT t "3~A~%*" DOC))))
	      ((SETQ temp (GET fun 'si:flavor))
	       (FORMAT t "3~%~A is a flavor~%*" fun)
	       (COND ((SETQ temp (si:flavor-plist temp))
		      (COND ((SETQ DOC (SECOND (MEMBER ':documentation temp :test #'EQ)))
			     (FORMAT t "3~a~%*" DOC))))))
	      ((SETQ temp (GET fun 'si:defstruct-description))
	       (FORMAT t "3~%~A is a structure~%*" fun)
	       (COND ((SETQ temp (si:defstruct-description-property-alist temp))
		      (COND ((SETQ DOC (CDR (ASSOC  ':documentation temp :test #'EQ)))
			     (FORMAT t "3~a~%*" DOC))))))
	      ((SETQ DOC (GET fun ':documentation))
	       (FORMAT t "3~%~A is a ~a~%*" fun (TYPE-OF fun))
	       (FORMAT t "3~a~%*" DOC))
	      ((AND (SYMBOLP fun) (BOUNDP fun))
	       (FORMAT t "3~%~A is a variable~%*" fun)
	       (COND ((SETQ DOC (GET fun ':value-documentation))
		      (FORMAT t "3~a~%*" DOC)))))
  (TERPRI))

(DEFUN 4file* (function-spec)
  "2List all source files for a function. For example: (FILE '(:method tv:sheet :expose))*"
  (LET ((alist (si:get-all-source-file-names function-spec)))
    (DOLIST (files alist)
      (DOLIST (file (CDR files))
	(LET ((PLIST (SEND file ':property-list))
	      (file-id nil)
	      (qfasl-id nil)
	      (patch nil))
	  (DO ((property PLIST (CDDR property)))
	      ((NULL property))
	    (CASE  (FIRST property)
	      (:file-id-package-alist (SETQ file-id (CAAR (SECOND property))))
	      (:patch-file (SETQ patch (SECOND property)))
	      (:qfasl-source-file-unique-id (SETQ qfasl-id (SECOND property)))))
	  (COND ((EQ (DATA-TYPE file-id) 'dtp-instance)
		 (FORMAT t "3~%Source File  ~a*" file-id))
		((EQ (DATA-TYPE qfasl-id) 'dtp-instance)
		 (FORMAT t "3~%Qfasl Source ~a*" qfasl-id))
		(t (FORMAT t "3~%File Name    ~a*" file)))
	  (IF patch (FORMAT t "3     patch*")))))
    nil))

(DEFUN 4GET-INSTANCE-VARIABLE* (instance variable)
  "2Return the value of an instance variable or NIL if its unbound.*"
  (LET ((locative (LOCATE-IN-INSTANCE instance variable)))
    (AND (LOCATION-BOUNDP locative) (CDR locative))))

(DEFUN 4GREP* (DIRECTORY-NAME &OPTIONAL SEARCH-STRING (PRINT-SEARCH-FILE-NAME NIL) &AUX FILE-STREAM
  ONE-PATH-NAME (PREVIOUS-NAME "3NOT-THERE-AT-ALL*") UNPARSED-PATH-NAME)
  "2Search a directory of Lisp files for a specified string.*"
  (UNLESS SEARCH-STRING
    (SETQ SEARCH-STRING "3:who-line-documentation-string*"))
  ;1;Make sure that the directory separator is present.*
  (UNLESS (SEARCH (THE STRING (STRING "3;*")) (THE STRING (STRING DIRECTORY-NAME)) :TEST #'CHAR-EQUAL)
    (SETQ DIRECTORY-NAME (STRING-APPEND DIRECTORY-NAME "3;*")))
  ;1;Make sure that the wildcard file indicators are present.*
  (UNLESS (SEARCH (THE STRING (STRING "3*.**")) (THE STRING (STRING DIRECTORY-NAME)) :TEST #'CHAR-EQUAL)
    (SETQ DIRECTORY-NAME (STRING-APPEND DIRECTORY-NAME "3*.**")))
  ;1;Do the directory search here.*
  (DOLIST (ONE-FILE (FS:DIRECTORY-LIST DIRECTORY-NAME :SORTED))
    (SETQ ONE-PATH-NAME (CAR ONE-FILE))
    ;1;The first element of the directory list is nil. All others have a CAR which is a pathname.*
    (WHEN ONE-PATH-NAME
      (WHEN (AND (STRING-EQUAL (SEND ONE-PATH-NAME :TYPE) "3LISP*")
	  (NOT (STRING-EQUAL (SEND ONE-PATH-NAME :NAME) PREVIOUS-NAME)))
	(SETQ PREVIOUS-NAME (SEND ONE-PATH-NAME :NAME))
	;1;Build up the pathname from the components. This will make sure that we*
	;1;get the latest version of the file.*
        (SETQ unparsed-path-name (SEND one-path-name :new-pathname :version :newest))
	(IF PRINT-SEARCH-FILE-NAME
	  (FORMAT *STANDARD-OUTPUT* "3~&Searching file ~A*" UNPARSED-PATH-NAME))
	(SETQ FILE-STREAM (OPEN UNPARSED-PATH-NAME :DIRECTION :INPUT))
	(LOOP
	 (MULTIPLE-VALUE-BIND (INPUT-STRING EOF-FLAG)
	   (SEND FILE-STREAM :LINE-IN)
	   (IF EOF-FLAG
	     (RETURN ()));1exit from the do-forever*
	   (WHEN (SEARCH (THE STRING (STRING SEARCH-STRING)) (THE STRING (STRING INPUT-STRING)) :TEST
		    #'CHAR-EQUAL)
	     (FORMAT *STANDARD-OUTPUT* "3~&Found in file ~A*" UNPARSED-PATH-NAME)
	     (RETURN ()))));1exit from the do-forever*
	(CLOSE FILE-STREAM))))) 

fs:
(DEFUN user:disk-usage (&optional directory)
  "2Display the disk-usage by directory.*"
  (LET ((dir (LOOKUP-DIRECTORY (AND directory (STRING directory)) t))
	size count date total)
    (IF (NULL dir)			   ;1Don't crap out if directory is bad*
	(FORMAT t "~%Directory not found: ~s" directory)
      ;;1 Print header*
      (FORMAT t "~%~16a ~5a  ~a~43t~6a     ~a"
	      "Directory" "Files" "Last Creation Date" "  Size" "Author")
      ;1; Print top level directory size*
      (MULTIPLE-VALUE-SETQ (total count date) (get-directory-size dir nil))
      (FORMAT t "~%~16a ~5d  ~\\time\\~43t~6d     ~a"
	      (file-name dir) count date total (file-author-internal dir))
      ;1; Print size of each sub-directory*
      (DOLIST (f (READ-DIRECTORY-FILES dir))
	(WHEN (STRING-EQUAL (file-type f) "directory")
	  (MULTIPLE-VALUE-SETQ (size count date) (get-directory-size f t))
	  (INCF total size)
	  (FORMAT t "~%~16a ~5d  ~\\time\\~43t~6d     ~a"
		  (file-name f) count date size (file-author-internal f))))
      ;1; Print the total size*
      (FORMAT t "~%Total~43t~6d" total))))

fs:
(DEFUN get-directory-size (f &optional sub-directories-p &aux (size 0) (COUNT 0) (date 0))
  "2Return the size, number of files and latest creation date for directory F and all its sub-directories.*"
  (DOLIST (file (read-directory-files f))
    (SETQ date (MAX date (file-creation-date-internal file)))
    (INCF size (map-npages (file-map file)))
    (SETQ count (LENGTH (file-files f)))
    (WHEN (AND sub-directories-p (fs:file-attribute file :directory)) ; (STRING-EQUAL (file-type file) "directory"))
      (MULTIPLE-VALUE-BIND (dir-size dir-count dir-date)
	  (get-directory-size file sub-directories-p)
	(INCF size dir-size)
	(INCF count dir-count)
	(SETQ date (MAX date dir-date)))))
  (VALUES size count date))

