;;; -*- Mode:Common-Lisp; Package:USER; Base:10; Fonts:(MEDFNB HL12B HL12BI) -*-

;;; Simple hack to do something like meta-point for C source files
;;; which have been processed by the Ultrix program `etags'.  Another
;;; program needs to be run to read in the tags file and put the
;;; :super-source-file-name and :super-source-line-number properties
;;; on the symbols mentioned in the tags file.  (This program hasn't
;;; been written yet.)  After that program is run, doing a super-.
;;; on a symbol defined in the tags file will go to that file, and
;;; position one to the symbol.
(ZWEI:DEFCOM COM-SUPER-POINT "Like meta-point, only it works on files
processed by the ultrix program `etags'." ()
  (LET (SPEC STRING EXPLICIT-PACKAGE-P)
    (SETF (VALUES SPEC STRING EXPLICIT-PACKAGE-P)
          (ZWEI:READ-FUNCTION-NAME "Edit definition" (ZWEI:RELEVANT-FUNCTION-NAME (ZWEI:POINT))
                                   'ZWEI:AARRAY-OK 'ZWEI:MULTIPLE-OK))
    (OR (AND (CONSP SPEC)
             (NEQ (CAR SPEC) :METHOD)) ;single entry now with equaleq fixes. gsl
        (SETQ SPEC (LIST SPEC)))
    ;; If there's only one entry in the aarray, and its for a different package,
    ;; but the symbol in the current package has some sort of definition in a file,
    ;; include them both.
    (IF (AND (NOT EXPLICIT-PACKAGE-P) (SYMBOLP (CAR SPEC)))
        (MULTIPLE-VALUE-BIND (THIS-PKG-SYMBOL FOUNDP)
            (FIND-SYMBOL (STRING-UPCASE (STRING (CAR SPEC))))
          ;; neq no good for methods, gsl
          (IF (AND FOUNDP (NOT (EQUAL THIS-PKG-SYMBOL (CAR SPEC)))
                   (GET THIS-PKG-SYMBOL :SUPER-SOURCE-FILE-NAME))
              (PUSH THIS-PKG-SYMBOL SPEC))))
    (LET* ((SYMBOL-NAME (CAR SPEC))
           (SOURCE-FILE (GET SYMBOL-NAME :SUPER-SOURCE-FILE-NAME))
           (SOURCE-LINE (GET SYMBOL-NAME :SUPER-SOURCE-LINE-NUMBER))
          DEFAULT-MENU-ITEM)
      (WHEN (CONSP SOURCE-FILE)
        ;; There is more than one definition.  Pop up a menu and let the
        ;; user select the one of interest.
        (SETQ SOURCE-FILE (W:MENU-CHOOSE
                            (NREVERSE
                              (LOOP FOR FILE IN SOURCE-FILE
                                    FOR LINE IN SOURCE-LINE
                                    COLLECT `(,(FORMAT NIL "File ~A at line ~D"
                                                       FILE LINE)
                                              :VALUE (,FILE ,LINE)) INTO MENU-ITEMS
                                    FINALLY (PROGN
                                              (SETQ DEFAULT-MENU-ITEM (CAR (LAST MENU-ITEMS)))
                                              (RETURN MENU-ITEMS))))
                                         :LABEL (FORMAT NIL "~A has more than one definition.  ~
                                                             ~%Pick the one you want."
                                                        SYMBOL-NAME)
                                         :DEFAULT-ITEM DEFAULT-MENU-ITEM))
        ;; What is returned from the menu is the filename and the line number, as a list.
        (PSETQ SOURCE-FILE (CAR SOURCE-FILE)
               SOURCE-LINE (CADR SOURCE-FILE)))
      ;; If the user moved the mouse out of the menu then assume nothing is to be done.
      (WHEN SOURCE-FILE
        ;; Read in the source file.
        (ZWEI:FIND-FILE SOURCE-FILE)
        ;; Move to the beginning of the source file, and then move down the
        ;; specified number of lines.
        (ZWEI:MOVE-BP (ZWEI:POINT) (ZWEI:INTERVAL-FIRST-BP ZWEI:*INTERVAL*))
        (ZWEI:DOWN-REAL-LINE (1- SOURCE-LINE))
        ;; Recenter the window so that this thing is at the top of the screen.
        (LET ((N-PLINES (ZWEI:WINDOW-N-PLINES ZWEI:*WINDOW*)))
          (ZWEI:RECENTER-WINDOW ZWEI:*WINDOW* :ABSOLUTE
                                (QUOTIENT (ZWEI:RANGE 0 0 (1- N-PLINES))
                                          (SMALL-FLOAT N-PLINES))))))
    ZWEI:DIS-TEXT))

;;; Bind the unfonted version of this command to META SHIFT I.
(ZWEI:SET-COMTAB  ZWEI:*STANDARD-COMTAB*
                  `(
#+ELROY           #\META-SHIFT-I
#-ELROY           ,(CHAR-INT #\META-SHIFT-I)
                  COM-SUPER-POINT)
                  '(("INSERT CHANGE HISTORY " . COM-SUPER-POINT)))

;;; Install com-super-point onto the SUPER-. key.
(ZWEI:COMMAND-STORE 'COM-SUPER-POINT #\SUPER-. ZWEI:*STANDARD-COMTAB*)

(DEFPARAMETER TAG-LINE-NUMBER NIL)

(DEFUN READ-A-TAG-LINE (STREAM)
  "2Reads a line from a tags file.*"
  (INCF TAG-LINE-NUMBER)
  ;; Loop through each line read, skipping over special case lines.
  (LOOP WITH STRING = (MAKE-ARRAY 0 :ELEMENT-TYPE :STRING-CHAR :FILL-POINTER 0)
        FOR CHAR = (OR (READ-CHAR STREAM NIL NIL)
                       (RETURN (IF (PLUSP (LENGTH STRING))
                                   STRING
                                   NIL)))
        ;; If the file is copied from tilde to an explorer, then the
        ;; termination character is a hacked up line feed.  If the
        ;; file is being read directly from tilde, then the character
        ;; is a newline.
;;;;;;;;UNTIL (CHAR= CHAR (INT-CHAR (LOGAND (CHAR-INT #\LINE-FEED) #O177)))
        UNTIL (CHAR= CHAR #\NEWLINE)
        DO (VECTOR-PUSH-EXTEND CHAR STRING)
        FINALLY (RETURN STRING)))

(DEFPARAMETER TAG-LINE NIL)

(DEFCONSTANT PAGE-LINE (MAKE-STRING 1 :INITIAL-ELEMENT #\PAGE))

(DEFUN SCAN-TAG-FILE (PATHNAME)
  "2Scan a tags file and set up the properties appropriately.*"
  (SETQ TAG-LINE-NUMBER 0)
  (WITH-OPEN-FILE (TAG-STREAM PATHNAME :DIRECTION :INPUT)
    (SETQ TAG-LINE (READ-A-TAG-LINE TAG-STREAM))
    (WHEN (NOT (EQUAL TAG-LINE PAGE-LINE))
      (FERROR NIL "Tag file is not in the proper format"))
    ;; Process the pathname and line number line.
    (LOOP FOR TAG-LINE = (READ-A-TAG-LINE TAG-STREAM)
          WHILE TAG-LINE
          DO (LET ((COMMA-POSITION (POSITION #\, TAG-LINE))
                   SYMBOL-PATHNAME)
               (WHEN (NULL COMMA-POSITION)
                 (FERROR NIL "Comma not found in line ~D" TAG-LINE-NUMBER))
               (SETQ SYMBOL-PATHNAME (FS:PARSE-PATHNAME (CONCATENATE
                                                          'SIMPLE-STRING
                                                          ;; These pathnames don't have the
                                                          ;; host specified.  Shove tilde in
                                                          ;; as the host.
                                                          "T:"
                                                          (SUBSEQ TAG-LINE 0 COMMA-POSITION))))
               ;; Process the definition lines.
               (LOOP WITH FUNCTION-NAME        = NIL
                     WITH FUNCTION-SYMBOL      = NIL
                     WITH FUNCTION-LINE-NUMBER = NIL
                     WITH OLD-PATHNAME         = NIL
                     WITH OLD-LINE-NUMBER-PROPERTY = NIL
                     FOR DEFINITION-LINE       = (READ-A-TAG-LINE TAG-STREAM)
                     WHILE DEFINITION-LINE
                     UNTIL (EQUAL DEFINITION-LINE PAGE-LINE)
                     FOR RUBOUT-POSITION       = (POSITION #\RUBOUT DEFINITION-LINE)
                     FOR LINE-NUMBER-POSITION  = (1+ RUBOUT-POSITION)
                     FOR COMMA-POSITION        = (POSITION #\,      DEFINITION-LINE)
                     FOR SPACE-POSITION        = (OR (POSITION #\SPACE DEFINITION-LINE :FROM-END T
                                                               :END RUBOUT-POSITION)
                                               -1)
                     FOR RUBOUT-POSITION-CHAR = (AREF DEFINITION-LINE (MAX 0 (1- RUBOUT-POSITION)))
                     WHEN (PLUSP RUBOUT-POSITION)
                     DO (PROGN
                          (WHEN (OR (CHAR= RUBOUT-POSITION-CHAR #\()
                                    (CHAR= RUBOUT-POSITION-CHAR #\SPACE))
                            ;; Check to see if this is a function definition.  If so, move
                            ;; the pointer to point 1 past the last character of the
                            ;; function name.
                            (DECF RUBOUT-POSITION)
                            (WHEN (CHAR= RUBOUT-POSITION-CHAR #\SPACE)
                              (SETQ SPACE-POSITION (OR (POSITION #\SPACE DEFINITION-LINE
                                                                 :FROM-END T
                                                                 :END RUBOUT-POSITION)
                                                       -1))))
                          (SETQ FUNCTION-NAME (SUBSEQ DEFINITION-LINE (1+ SPACE-POSITION)
                                                      RUBOUT-POSITION))
                          (WHEN (POSITION #\* FUNCTION-NAME :TEST #'CHAR=)
                            ;; Strip off punctuation from the function name.
                            ;; This doesn't work for all cases, but will work for
                            ;; most of them.
                            (SETQ FUNCTION-NAME (STRING-TRIM "(*" FUNCTION-NAME)))
                          (SETQ FUNCTION-SYMBOL (INTERN (STRING-UPCASE FUNCTION-NAME) 'USER))
                          (SETQ FUNCTION-LINE-NUMBER (READ-FROM-STRING
                                                       DEFINITION-LINE T NIL
                                                       :START LINE-NUMBER-POSITION))
                          (SETQ OLD-LINE-NUMBER-PROPERTY (GET FUNCTION-SYMBOL
                                                              :SUPER-SOURCE-LINE-NUMBER))
                          (SETQ OLD-PATHNAME (GET FUNCTION-SYMBOL :SUPER-SOURCE-FILE-NAME))
                          ;; If we have already processed this entry, then ignore it.
                          (WHEN (NULL (OR (AND (NUMBERP OLD-LINE-NUMBER-PROPERTY)
                                               (= OLD-LINE-NUMBER-PROPERTY FUNCTION-LINE-NUMBER)
                                               (EQ SYMBOL-PATHNAME OLD-PATHNAME))
                                          (AND (LISTP OLD-LINE-NUMBER-PROPERTY)
                                               (MEMBER FUNCTION-LINE-NUMBER
                                                       OLD-LINE-NUMBER-PROPERTY)
                                               (MEMBER SYMBOL-PATHNAME OLD-PATHNAME))))
                            (IF OLD-LINE-NUMBER-PROPERTY
                                ;; We have already seen this symbol.  Combine the information
                                ;; about this entry with that of the earlier entry.
                                (IF (LISTP OLD-LINE-NUMBER-PROPERTY)
                                    (PROGN
                                      (SETF (GET FUNCTION-SYMBOL :SUPER-SOURCE-LINE-NUMBER)
                                            (CONS FUNCTION-LINE-NUMBER
                                                  OLD-LINE-NUMBER-PROPERTY))
                                      (SETF (GET FUNCTION-SYMBOL :SUPER-SOURCE-FILE-NAME)
                                            (CONS SYMBOL-PATHNAME OLD-PATHNAME))
                                      (LET ((SYS:FDEFINE-FILE-PATHNAME SYMBOL-PATHNAME))
                                        (SYS:RECORD-SOURCE-FILE-NAME FUNCTION-SYMBOL 'DEFUN T)))
                                    ;;1ELSE*
                                    (PROGN
                                      (SETF (GET FUNCTION-SYMBOL :SUPER-SOURCE-LINE-NUMBER)
                                            (CONS FUNCTION-LINE-NUMBER
                                                  `(,OLD-LINE-NUMBER-PROPERTY)))
                                      (SETF (GET FUNCTION-SYMBOL :SUPER-SOURCE-FILE-NAME)
                                            (CONS SYMBOL-PATHNAME `(,OLD-PATHNAME)))
                                      (LET ((SYS:FDEFINE-FILE-PATHNAME SYMBOL-PATHNAME))
                                        (SYS:RECORD-SOURCE-FILE-NAME FUNCTION-SYMBOL 'DEFUN T))))
                                ;;1ELSE*
                                ;; This is the first time we have seen this symbol.
                                (PROGN
                                  (SETF (GET FUNCTION-SYMBOL :SUPER-SOURCE-FILE-NAME)
                                        SYMBOL-PATHNAME)
                                  (LET ((SYS:FDEFINE-FILE-PATHNAME SYMBOL-PATHNAME))
                                    (SYS:RECORD-SOURCE-FILE-NAME FUNCTION-SYMBOL 'DEFUN T))
                                  (SETF (GET FUNCTION-SYMBOL :SUPER-SOURCE-LINE-NUMBER)
                                        FUNCTION-LINE-NUMBER))))))))))

