;;; -*- Mode: LISP; Package: USER; Base: 10.; Fonts: CPTFNT, HL12B, HL12BI; -*-
;;; Created 2/04/85 05:09:56 by LaMott Oren
;
;===============================================================================
;
;   This data and information is proprietary to, and a valuable trade secret of
;   Texas Instruments, Incorporated, a Delaware corporation.  It is given in
;   confidence by Texas Instruments, and may not be used as the basis of
;   manufacture, or be reproduced or copied, or be distributed to any other
;   party, in whole or in part, without the prior written consent of Texas
;   Instruments.
;
;===============================================================================
;
;   (c) Unpublished Copyright 1985 by Texas Instruments.  All rights reserved.
;
;===============================================================================



(Defmacro timeit (options &body body &aux (label "  Total:") PRINT repeat disk cpu CONS units interrupts MULTIPLE-VALUE temp)
  "1Execute body and print or return the execution time.
Options are :label /"label to print/"*
	1    :print stream-to-print-on ;defaults to DEBUG-IO*
	1    :repeat repeat-count *	1; time is divided by repeat count*
	1    :interrupts*		1; If present, allow interrupts*
	1    :disk *		1; If present, print disk wait time*
	1    :cpu*	1 *		1; If present, time will not include disk wait time*
	1    :cons*		1; If present, print number of words consed*
	1    :nanoseconds*		1; time in nanoseconds*
	1    :microseconds*	1; time in microseconds*
	1    :milliseconds*		1; time in milliseconds*
	1    :seconds*		1; time in seconds*
	1   * 1:multiple-value*	1; Return multiple values from body
If the first option is a string, it is taken as the label.
If there are label or print options, and no repeat count, all the values
returned by BODY are returned, otherwise the time and disk wait
time (if asked for) are returned.*"
  temp
  (WHEN (STRINGP (CAR options))
    (SETQ label (POP options)))
  (KEYWORD-EXTRACT options temp (label PRINT repeat units) (disk cpu CONS interrupts MULTIPLE-VALUE)
		   ((:seconds :milliseconds :microseconds :nanoseconds)
		    (SETQ units (CAR temp))))
  (WHEN (AND label (NOT print)) (SETQ PRINT 'debug-io))
  (SETQ temp '(tim))
  `(LET (%start-time% %end-time%
	 ,@(WHEN repeat `((%repeat-count% ,repeat))) ;1 evaluate repeat count outside of timing*
	 ,@(WHEN (AND PRINT (NOT repeat)) '(value))
	 ,@(WHEN (OR disk cpu) '(%start-disk% %end-disk%))
	 ,@(WHEN CONS '(%start-cons% %end-cons%))
	 ,@(UNLESS interrupts '((inhibit-scheduling-flag t))))
						;1 Execute BODY and collect times*
     ,@(WHEN CONS '((SETQ %start-cons% (area-size working-storage-area))))
     ,@(WHEN (or disk cpu)
	 '(#+3600(SETQ %start-disk% si:*ms-time-page-fault*)
	   #-3600(SETQ %start-disk% (read-meter 'sys:%disk-wait-time))))
     (setq %start-time% (time:microsecond-time))
;     #-3600(setq %start-time% (%microsecond-time))
     ,(IF (AND PRINT (NOT repeat))
	  (IF MULTIPLE-VALUE
	      `(SETQ value (MULTIPLE-VALUE-LIST ,@body))
	    `(SETQ value (PROGN ,@body)))
	(IF repeat
	    `(DO ((%repeat-count%% %repeat-count% (1- %repeat-count%%)))
		 ((ZEROP %repeat-count%%)) ,@body)
	  `(PROGN ,@body)))
     (setq %end-time% (time:microsecond-time))
;     #-3600(setq %end-time% (%microsecond-time))
     ,@(WHEN (or disk cpu)
	 '(#+3600(SETQ %end-disk% si:*ms-time-page-fault*)
	   #-3600(SETQ %end-disk% (read-meter 'sys:%disk-wait-time))))
     ,@(WHEN CONS '((SETQ %end-cons% (area-size working-storage-area))))
						;1 Calculate the time*
     (LET ((tim (microsecond-time-difference %end-time% %start-time%))
	   ,@(WHEN (or disk cpu)
	       (PUSH 'dsk temp)
	       '((dsk (microsecond-time-difference %end-disk% %start-disk%))))
	   ,@(WHEN CONS
	       (PUSH 'CONS temp)
	       '((cons (- %end-cons% %start-cons%)))))
       #+3600,@(WHEN (OR disk cpu) '((setq dsk (* 1000. dsk)))) ;; milliseconds to microseconds
       ,@(WHEN repeat
	   `((SETQ tim (// tim (FLOAT %repeat-count%))
		   ,@(WHEN (or disk cpu) `(dsk (// dsk (FLOAT %repeat-count%))))
		   ,@(WHEN CONS `(CONS (// CONS %repeat-count%))))))
       ,@(WHEN cpu '((SETQ tim (- tim dsk))))
						;1 Return the results*
       ,@(IF (NULL PRINT)
	     (APPEND 
	       (SELECTQ units
		 (nil)				;1defaults to microseconds*
		 (:nanoseconds '((SETQ tim (* tim 1000.0) dsk (* dsk 1000.0))))
		 (:microseconds)
		 (:milliseconds  '((SETQ tim (// tim 1000.0) dsk (// dsk 1000.0))))
		 (:seconds '((SETQ tim (// tim 1e6) dsk (// dsk 1e6))))
		 (otherwise (FSIGNAL "unknown time unit: ~s" units)))
	       `((VALUES ,@(REVERSE temp))))
						;1 Print the results*
	   `((FORMAT ,PRINT "~%~a " ,(OR label ""))
	     (timeit-print ,PRINT tim ,units)
	     ,@(WHEN disk
		 `((FORMAT ,PRINT "~%  Disk: ")
		   (timeit-print ,PRINT dsk ,units)))
	     ,@(WHEN CONS
		 `((FORMAT ,PRINT "~%  Memory: ~d words" cons)))
	     ,@(IF (AND PRINT (NOT repeat))
		   (IF MULTIPLE-VALUE
		       '((VALUES-LIST value))
		     '(value))
		 `((VALUES ,@(REVERSE temp)))))))))

(defconst maximum-usec-timer-value #x+100000000)

(DEFUN microsecond-time-difference (end start &aux (diff (- end start)))
  (IF (< diff 0)
      (+ end (- maximum-usec-timer-value start))
    diff))

(DEFUN timeit-print (stream TIME &optional units)
  "1Print TIME on STREAM using UNITS which is one of
:nanoseconds :microseconds :milliseconds :seconds :minutes :hours*"
  (UNLESS units
    (SETQ units (cond ((ZEROP time) :zero)
		      ((< time 1) :nanoseconds)
		      ((< time 1000) :microseconds)
		      ((< time 1000000.) :milliseconds)
		      (t :seconds))))
  (SELECTQ units
    (:zero (format stream "0.0"))
    (:nanoseconds (format stream "~D nanoseconds" (* time 1000.0)))
    (:microseconds (format stream "~D microseconds" time))
    (:milliseconds (format stream "~4F milliseconds" (// time 1000.0)))
    (:seconds (format stream "~5F seconds" (// time 1e6)))
    (:minutes (FORMAT stream "~5f minutes" (// TIME '#,(// 1e6 60.))))
    (:hours (FORMAT stream "~5f hours" (// TIME '#,(// 1e6 60. 60.))))
    (otherwise (FSIGNAL "unknown time unit: ~s" units))))


(DEFUN area-size (area-number)
  "1Return the number of words used in AREA-NUMBER*"
  (DO ((region (si:area-region-list area-number) (si:region-list-thread region))
       (sum 0 (+ sum (si:REGION-FREE-POINTER REGION))))
      ((MINUSP region) sum)))

;(DEFMACRO timeit (options &body body &aux label PRINT repeat disk cpu CONS units interrupts MULTIPLE-VALUE temp)
;  "1Execute body and print or return the execution time.*
;1Options are :label /"label to print/"*
;	1    :print stream-to-print-on ;defaults to DEBUG-IO*
;	1    :repeat repeat-count *	1; time is divided by repeat count*
;	1    :interrupts*		1; If present, allow interrupts*
;	1    :disk *		1; If present, print disk wait time*
;	1    :cpu*	1 *		1; If present, time will not include disk wait time*
;	1    :cons*		1; If present, print number of words consed*
;	1    :nanoseconds*		1; time in nanoseconds*
;	1    :microseconds*	1; time in microseconds*
;	1    :milliseconds*		1; time in milliseconds*
;	1    :seconds*		1; time in seconds*
;	1   * 1:multiple-value*	1; Return multiple values from body*
;1If the first option is a string, it is taken as the label.*
;1If there are label or print options, and no repeat count, all the values*
;1returned by BODY are returned, otherwise the time and disk wait*
;1time (if asked for) are returned.*"
;  temp
;  (WHEN (STRINGP (CAR options))
;    (SETQ label (POP options)))
;  (KEYWORD-EXTRACT options temp (label PRINT repeat units) (disk cpu CONS interrupts MULTIPLE-VALUE)
;		   ((:seconds :milliseconds :microseconds :nanoseconds)
;		    (SETQ units (CAR temp))))
;  (WHEN (AND label (NOT print)) (SETQ PRINT 'debug-io))
;  (SETQ temp '(tim))
;  `(LET (%start-time% %end-time%
;	 ,@(WHEN repeat `((%repeat-count% ,repeat))) ;1 evaluate repeat count outside of timing*
;	 ,@(WHEN (AND PRINT (NOT repeat)) '(value))
;	 ,@(WHEN (OR disk cpu) '(%start-disk% %end-disk%))
;	 ,@(WHEN CONS '(%start-cons% %end-cons%))
;	 ,@(UNLESS interrupts '((inhibit-scheduling-flag t))))
;						;1 Execute BODY and collect times*
;     ,@(WHEN CONS '((SETQ %start-cons% (area-size working-storage-area))))
;     ,@(WHEN (or disk cpu)
;	 '(#+3600(SETQ %start-disk% si:*ms-time-page-fault*)
;	   #-3600(SETQ %start-disk% (read-meter 'sys:%disk-wait-time))))
;     (setq %start-time% (time:microsecond-time))
;;     #-3600(setq %start-time% (%microsecond-time))
;     ,(IF (AND PRINT (NOT repeat))
;	  (IF MULTIPLE-VALUE
;	      `(SETQ value (MULTIPLE-VALUE-LIST ,@body))
;	    `(SETQ value (PROGN ,@body)))
;	(IF repeat
;	    `(DO ((%repeat-count%% %repeat-count% (1- %repeat-count%%)))
;		 ((ZEROP %repeat-count%%)) ,@body)
;	  `(PROGN ,@body)))
;     (setq %end-time% (time:microsecond-time))
;;     #-3600(setq %end-time% (%microsecond-time))
;     ,@(WHEN (or disk cpu)
;	 '(#+3600(SETQ %end-disk% si:*ms-time-page-fault*)
;	   #-3600(SETQ %end-disk% (read-meter 'sys:%disk-wait-time))))
;     ,@(WHEN CONS '((SETQ %end-cons% (area-size working-storage-area))))
;						;1 Calculate the time*
;     (LET ((tim (microsecond-time-difference %end-time% %start-time%))
;	   ,@(WHEN (or disk cpu)
;	       (PUSH 'dsk temp)
;	       '((dsk (microsecond-time-difference %end-disk% %start-disk%))))
;	   ,@(WHEN CONS
;	       (PUSH 'CONS temp)
;	       '((cons (- %end-cons% %start-cons%)))))
;       #+3600,@(WHEN (OR disk cpu) '((setq dsk (* 1000. dsk)))) ;; milliseconds to microseconds
;       ,@(WHEN repeat
;	   `((SETQ tim (// tim (FLOAT %repeat-count%))
;		   ,@(WHEN (or disk cpu) `(dsk (// dsk (FLOAT %repeat-count%))))
;		   ,@(WHEN CONS `(CONS (// CONS %repeat-count%))))))
;       ,@(WHEN cpu '((SETQ tim (- tim dsk))))
;						;1 Return the results*
;       ,@(IF (NULL PRINT)
;	     (APPEND 
;	       (SELECTQ units
;		 (nil)				;1defaults to microseconds*
;		 (:nanoseconds '((SETQ tim (* tim 1000.0) dsk (* dsk 1000.0))))
;		 (:microseconds)
;		 (:milliseconds  '((SETQ tim (// tim 1000.0) dsk (// dsk 1000.0))))
;		 (:seconds '((SETQ tim (// tim 1e6) dsk (// dsk 1e6))))
;		 (otherwise (FSIGNAL "unknown time unit: ~s" units)))
;	       `((VALUES ,@(REVERSE temp))))
;						;1 Print the results*
;	   `((FORMAT ,PRINT "~%~a " ,(OR label ""))
;	     (timeit-print ,PRINT tim ,units)
;	     ,@(WHEN disk
;		 `((FORMAT ,PRINT "  Disk: ")
;		   (timeit-print ,PRINT dsk ,units)))
;	     ,@(WHEN CONS
;		 `((FORMAT ,PRINT "  Memory: ~d words" cons)))
;	     ,@(IF (AND PRINT (NOT repeat))
;		   (IF MULTIPLE-VALUE
;		       '((VALUES-LIST value))
;		     '(value))
;		 `((VALUES ,@(REVERSE temp)))))))))
;
;(defconst maximum-usec-timer-value #x+100000000)
;
;(DEFUN microsecond-time-difference (end start &aux (diff (- end start)))
;  (IF (< diff 0)
;      (+ end (- maximum-usec-timer-value start))
;    diff))
;
;(DEFUN timeit-print (stream TIME &optional units)
;  "1Print TIME on STREAM using UNITS which is one of*
;1:nanoseconds :microseconds :milliseconds :seconds :minutes :hours*"
;  (UNLESS units
;    (SETQ units (cond ((ZEROP time) :zero)
;		      ((< time 1) :nanoseconds)
;		      ((< time 1000) :microseconds)
;		      ((< time 1000000.) :milliseconds)
;		      (t :seconds))))
;  (SELECTQ units
;    (:zero (format stream "0.0"))
;    (:nanoseconds (format stream "~D nanoseconds" (* time 1000.0)))
;    (:microseconds (format stream "~D microseconds" time))
;    (:milliseconds (format stream "~4F milliseconds" (// time 1000.0)))
;    (:seconds (format stream "~5F seconds" (// time 1e6)))
;    (:minutes (FORMAT stream "~5f minutes" (// TIME '#,(// 1e6 60.))))
;    (:hours (FORMAT stream "~5f hours" (// TIME '#,(// 1e6 60. 60.))))
;    (otherwise (FSIGNAL "unknown time unit: ~s" units))))
;
;
;(DEFUN area-size (area-number)
;  "1Return the number of words used in AREA-NUMBER*"
;  (DO ((region (si:area-region-list area-number) (si:region-list-thread region))
;       (sum 0 (+ sum (si:REGION-FREE-POINTER REGION))))
;      ((MINUSP region) sum)))
