;;; -*- Mode: COMMON-LISP; Package: USER; Base: 10; Fonts: (CPTFONT TR10B TR10BI TR10I CPTFONTB); -*-

;1;; Created 11/21/86 11:42:31 by NICHOLS*

(defun 4dir* (&optional (dir "3dan:nichols;*.**"))
  (let ((files (fs:directory-list dir :sorted)))
    (format t "3~&~18@T Lispm Name ~13@T Author ~7@T Creation Date~2%*")
    (loop for file-attributes in files
          for file = (FIRST file-attributes)
	  do
	  (COND (file
                   (format t "3~&    ~35A     ~15A*"
                           (send file :string-for-printing)
                           (GET file-attributes :author))
                   (TIME:print-universal-time (GET file-attributes :creation-date))
                   (TERPRI))))))

(DEFUN type (&optional file)
 2 "View contents of a file. While viewing, you can use Space and Overstrike
    to scroll forward and backward. Type Rubout to exit.  You cannot edit;
    but you can see the beginning of the file without waiting for the whole
    file to be read in."*
  (LET (PATHNAME)
    (COND (file
           (SETQ PATHNAME (fs:parse-pathname file)))
          (t
           (SETQ PATHNAME (fs:parse-pathname (PROMPT-AND-READ :pathname-or-nil "~%View File: ")))))
    (MY-VIEW-FILE PATHNAME)))

1;;; Show the file in the "display window".
;;; The caller should set up a reasonable prompt.*
(DEFUN my-VIEW-FILE (FILENAME &OPTIONAL (OUTPUT-STREAM *STANDARD-OUTPUT*))
  (SEND OUTPUT-STREAM :HOME-CURSOR)
  (SEND OUTPUT-STREAM :CLEAR-EOL)
  (FORMAT t "Viewing ~A~%" filename)
  (WITH-OPEN-FILE (STREAM FILENAME :ERROR :RETRY)
    (STREAM-COPY-UNTIL-EOF STREAM OUTPUT-STREAM))
  (SEND OUTPUT-STREAM :CLEAR-EOF))

