;;; -*- Mode: LISP ; Base: 10. ; Package: USER ; Fonts: MEDFNT,HL12B,HL12BI -*-

;1;*
;1; This is a collection of generally useful utility functions which can be shared by lots of*
;1; different systems.*
;1;*

;;
;1; SCALEF, MINF, MAXF*
;;
;1; These macros work like INCF and DECF.  They set their* 1first argument to the value*
;1; of the function applied to both* 1arguments.*
;;

(DEFMACRO SCALEF (ref amount)
  `(SETF ,ref (* ,ref ,amount)))


(DEFMACRO MINF (ref amount)
  `(SETF ,ref (MIN ,ref ,amount)))


(DEFMACRO MAXF (ref amount)
  `(SETF ,ref (MAX ,ref ,amount)))



(DEFUN RPLAC-NTH (n LIST x)
  "2This function changes the Nth element of a list and returns the modified list.
Just like the function Nth, this funciton is also zero based. The list which is
supplied is actually modified when the element is replaced so be careful in using* 2this.*"
  (DECLARE (RETURN-LIST modified-list))
  (RPLACA (NTHCDR n LIST) x)
  LIST)

(defun DEL-NTH (n LIST)
  "2This function deletes the Nth element of a list and returns the modified list.
Just like the function Nth, this funciton is also zero based. The list which is
supplied is actually modified when the element is spliced out, except when N is
zero, so this funtion must be used for value and not effect.*"
  (DECLARE (RETURN-LIST modified-list))
  (COND ((ZEROP n) (REST1 LIST))
	(t         (RPLACD (NTHCDR (1- n) LIST) (NTHCDR (1+ n) LIST))
		   LIST)))





(DEFUN GET-KEYSTROKE (&optional (prompt      "Enter keystroke")
		      		(superior    tv:mouse-sheet)
				(pop-up-near '(:mouse)))
  "2This function gets a keystroke through a pop-up type-in window.*"
  (DECLARE (RETURN-LIST keystroke))
  (USING-RESOURCE (key-window tv:pop-up-text-window-without-more superior)
    (FUNCALL key-window ':set-label nil)
    (FUNCALL key-window ':set-size-in-characters prompt prompt)
    (FUNCALL key-window ':clear-input)
    (tv:expose-window-near key-window pop-up-near nil)
    (tv:window-call (key-window :deactivate)
      (FUNCALL key-window ':string-out prompt)
      ;1;*
      ;1; Back up the cursor by one.  This is easier than trying to make the window*
      ;1; come out wider, because of the interface to :set-size-in-characters.*
      ;1;*
      (MULTIPLE-VALUE-BIND (x-pos y-pos)
	  (FUNCALL key-window ':read-cursorpos ':character)
	(FUNCALL key-window ':set-cursorpos (1- x-pos) y-pos ':character))
      (FUNCALL key-window ':tyi))))


(DEFUN GET-PATHNAME
       (&optional (allow-any t)
	          (prompt    "Enter pathname")
		  (default   (fs:merge-pathname-defaults "foo.picture")))
  "2This function gets a valid file pathname through a pop-up type-in window.
The allow-any argument specifies if the pathname of a non-existant file should
be allowed or not.*"
  (DECLARE (RETURN-LIST pathname))
  (DO (new-pathname STATUS) (nil)
    (SETQ new-pathname (tv:get-line-from-keyboard
			 (FORMAT nil "~A~%(Default=~A)" prompt default))
	  default      (fs:merge-pathname-defaults new-pathname default)
	  STATUS       (OR allow-any (PROBEF default)))
    (COND ((NOT STATUS)
	   (MULTIPLE-VALUE (new-pathname STATUS)
	     (fs:complete-pathname default new-pathname "picture" nil))
	   (COND ((EQ STATUS ':old)
		  (RETURN (fs:parse-pathname new-pathname)))
		 (t (SETQ default (fs:merge-pathname-defaults new-pathname
							      default)))))
	  (t (RETURN default)))
    (FUNCALL tv:selected-window ':beep)))


(si:make-obsolete list-minus "Use SET-DIFFERENCE instead")
(DEFUN LIST-MINUS (source &rest lists)
  "2This function impliments a list subtraction operation.  The first argument* 2has all of
the rest of the arguments subtracted from it and the result is* 2returned.  Subtraction is
done by DELQ for each item in the subtracted* 2list.*"
  (LET ((new (COPYLIST source)))
    (DOLIST (next lists)
      (DOLIST (element next)
	(SETQ new (DELQ element new))))
    new))


(DEFUN RESOURCEP (symbol)
  "2Return non-nil if SYMBOL is the name of a resource.*"
  (AND (SYMBOLP symbol) (GET symbol 'DEFRESOURCE)))


(DEFUN remove-font-change-chars
       (string &optional (from 0.) (to (STRING-LENGTH string)))
  "2This function removes the ZMACS font change sequences from a string.*"
  (WHEN string
    (LET ((index (STRING-SEARCH-CHAR 6. string from to)))
      (COND (index (STRING-APPEND (SUBSTRING string from index)
				  (remove-font-change-chars STRING
							    (+ index 2.) to)))
	    (t     (SUBSTRING string from to))))))


(DEFUN SORTED-ARRAY-ASS (key ARRAY
			 &optional (equal-fun     #'=)
			 	   (less-than-fun #'<)
				   (FIRST 0.)
				   (LAST  (1- (ARRAY-ACTIVE-LENGTH ARRAY))))
  "2This function searches, like ASS, for an item in a sorted array.
Each element of the sorted array is assumed to be a list whose first element is
the key which is to be tested against the desired key.  The two optional function
arguments are predicates which are used to test keys for equality and less than.
The other two optional arguments are the array indices of the subrange within the
sorted array which should be searched.*"
  (DECLARE (RETURN-LIST array-element array-index))
  ;1;*
  ;1; If first is bigger than last then the item obviously cannot be found.*
  ;1;*
  (COND ((> FIRST LAST) (VALUES nil nil))
	;1;*
	;1; Calculate the index of the middle item in the array range and get it.*
	;1;*
	(t (LET* ((middle      (FIX (// (+ FIRST LAST) 2.)))
		  (middle-item (AREF ARRAY middle))
		  (middle-key  (FIRST middle-item)))
	     ;1;*
	     ;1; If this is the right item then we found it so return.*
	     ;1;*
	     (COND ((FUNCALL equal-fun key middle-key)
		    (VALUES middle-item middle))
		   ;1;*
		   ;1; If the desired item is less than the middle item then it must be in*
		   ;1; the lower half of the array range, if it is in here at all, so search*
		   ;1; the lower half.*
		   ;1;*
		   ((FUNCALL less-than-fun key middle-key)
		    (SORTED-ARRAY-ASS key ARRAY equal-fun less-than-fun
				      FIRST (1- middle)))
		   ;1;*
		   ;1; The only part left is the upper half of the array range so search*
		   ;1; it.*
		   ;1;*
		   (t (SORTED-ARRAY-ASS key ARRAY equal-fun less-than-fun
					(1+ middle) LAST)))))))


(DEFUN SORTED-ARRAY-DEL (key ARRAY &optional (equal-fun     #'=)
					     (less-than-fun #'<))
  "2This function deletes an item, like DEL, from a sorted array.
Each element of the sorted array is assumed to be a key which is to be tested against
the desired key to find the item for deletion.  The two optional function arguments are
predicates which are used to test keys for equality and less than.*"
  (DECLARE (RETURN-LIST modified-array))
  ;1;*
  ;1; First find the index of the element which is to be deleted.*
  ;1;*
  (MULTIPLE-VALUE-BIND (item index)
      (SORTED-ARRAY-MEM key ARRAY equal-fun less-than-fun)
    ;1;*
    ;1; Next delete the item, if it was found, by moving the rest of the array forward and*
    ;1; deleting the last element.*
    ;1;*
    (COND (item (LET ((LENGTH (1- (ARRAY-ACTIVE-LENGTH ARRAY))))
		  (DO ((i index (1+ i)))
		      ((>= i LENGTH))
		    (ASET (AREF ARRAY (1+ i)) ARRAY i))
		  (ASET nil ARRAY LENGTH))
		(COND ((AND (ARRAY-HAS-LEADER-P ARRAY)
			    (FIXP (ARRAY-LEADER ARRAY 0.)))
		       (ARRAY-POP ARRAY))))))
  ARRAY)


(DEFUN SORTED-ARRAY-MEM (key ARRAY
			 &optional (equal-fun     #'=)
			 	   (less-than-fun #'<)
				   (FIRST 0.)
				   (LAST  (1- (ARRAY-ACTIVE-LENGTH ARRAY))))
  "2This function searches, like MEM, for an item in a sorted array.
Each element of the sorted array is assumed to be a key which is to be tested
against the desired key.  The two optional function arguments are predicates which
are used to test keys for equality and less than. The other two optional arguments
are the array indices of the subrange within the sorted array which should be
searched.*"
  (DECLARE (RETURN-LIST array-element array-index))
  ;1;*
  ;1; If first is bigger than last then the item obviously cannot be found.*
  ;1;*
  (COND ((> FIRST LAST) (VALUES nil nil))
	;1;*
	;1; Calculate the index of the middle item in the array range and get it.*
	;1;*
	(t (LET* ((middle     (FIX (// (+ FIRST LAST) 2.)))
		  (middle-key (AREF ARRAY middle)))
	     ;1;*
	     ;1; If this is the right item then we found it so return.*
	     ;1;*
	     (COND ((FUNCALL equal-fun key middle-key)
		    (VALUES middle-key middle))
		   ;1;*
		   ;1; If the desired item is less than the middle item then it must be in*
		   ;1; the lower half of the array range, if it is in here at all, so search*
		   ;1; the lower half.*
		   ;1;*
		   ((FUNCALL less-than-fun key middle-key)
		    (SORTED-ARRAY-MEM key ARRAY equal-fun less-than-fun
				      FIRST (1- middle)))
		   ;1;*
		   ;1; The only part left is the upper half of the array range so search*
		   ;1; it.*
		   ;1;*
		   (t (SORTED-ARRAY-MEM key ARRAY equal-fun less-than-fun
					(1+ middle) LAST)))))))

  
;;
;1; STRING-CHARS-PATH*
;;
;1; This function allows the LOOP iteration pattern of*
;1; "FOR var BEING THE STRING-CHARS OF string"*
;;

(DEFUN STRING-CHARS-PATH (path-name variable DATA-TYPE
			  prep-phrases inclusive?
			  allowed-prepositions data
			  &aux (bindings nil)
			  (prologue nil)
			  (string-var (GENSYM))
			  (index-var (GENSYM))
			  (size-var (GENSYM)))
  allowed-prepositions data			; 1unused parameters*
  (COND ((NULL prep-phrases)
	 (FERROR nil "OF missing in ~S iteration path of ~S"
		 path-name variable)))
  (COND ((NOT (NULL inclusive?))
	 (FERROR nil "Inclusive stepping not supported in ~S path of ~S (prep-phrases = ~:S)"
		 path-name variable prep-phrases)))
  (SETQ bindings (LIST (LIST variable nil DATA-TYPE)
		       (LIST string-var (CADAR prep-phrases))
		       (LIST index-var 0 'FIXNUM)
		       (LIST size-var 0 'FIXNUM)))
  (SETQ prologue (LIST `(SETQ ,size-var (STRING-LENGTH ,string-var))))
  (LIST bindings
	prologue
	`(= ,index-var ,size-var)
	nil
	nil
	(LIST variable `(AREF ,string-var ,index-var)
	      index-var `(1+ ,index-var))))

(GLOBALIZE 'STRING-CHARS-PATH)
(DEFINE-LOOP-PATH string-characters STRING-CHARS-PATH (of))


(comment DEFUN COPY-INSTANCE (instance &optional area-to-cons-instance-in)
  "2Make a copy of a flavor instance*"
  (CHECK-ARG-TYPE instance :instance)
  (LET* ((fl (GET (TYPEP instance) 'si:flavor))
	 (size (si:flavor-instance-size fl))
	 (copy (si:%make-instance fl area-to-cons-instance-in size))
	 (vars (si:flavor-all-instance-variables fl)))
    (DO ((v vars (CDR v))
	 (i 1 (1+ i))
	 val)
	((NULL v))
      ;1 make instance variable unbound.*
      ;1 * i'm not sure this is necessary, but it can't hurt
      (%P-STORE-TAG-AND-POINTER (%MAKE-POINTER-OFFSET dtp-locative copy i)
				dtp-null (CAR v))
      ;1 copy value from origional instance to the copy*
      (SETQ val (si:%instance-ref instance i))
      (si:%instance-set val copy i))
    copy))

