;;; -*- Mode:Zetalisp; Package:ZWEI; Base:10 -*-

(defcom com-send-anon-mail "Send mail and exit mail mode."()
  (DECLARE (SPECIAL zwei:host-abbreviation))
  (LET* ((host-alist (SYMEVAL-IN-INSTANCE si:local-host 'si:alist-elem))
	 (save-host-alist (COPYLIST host-alist)))
    (UNWIND-PROTECT
	(LET-GLOBALLY ((user-id "Anonymous")
		       (si:local-host-name "UNKNOWN")
		       (si:local-host (si:copy-object si:local-host))
		       (mail:*mail-user-personal-name* user-id)
		       (user:*remote-host* user-id)
		       (zwei:zwei:host-abbreviation user-id)
;;		     (si:local-host-pretty-name si:local-host-name)
		       (si:local-pretty-host-name si:local-host-name)
		       (mail:*mail-server-p* nil)
		       (ip:my-address #x41000000)
		       (chaos:my-address #o1537);; Cadr1
		       (chaos:MY-ADDRESSES (LIST chaos:my-address))
		       )
	  (SETF (CAR host-alist) si:local-host-name
		(CDR host-alist)
		`(,si:local-host
		  (,si:local-host-name ,si:local-host-name)
		  :LISPM
		  :LISPM
		  "Hackers Annon"
		  :MISC-OPTIONS
		  NIL
		  :CHAOS
		  (,chaos:my-address)
		  :IP
		  (,ip:my-address)
		  :FILE-SERVER-TYPE
		  :CHAOS-NOT-COMMON
		  :IP-GATEWAY
		  NIL))
	  (ip:ip-reset)
	  (com-send-mail)
	  (format t "Hit any key after mail is sent")
	  (read-char))
      (SETF (CAR host-alist) (CAR save-host-alist)
	    (CDR host-alist) (CDR save-host-alist))
      (ip:ip-reset)
      )))

(Set-comtab *standard-comtab* '(#\super-end com-send-anon-mail))
