;;; -*- Mode:Common-Lisp; Package:ZWEI; Fonts:(COURIER TR12I TR12BI TR12B); Base:101; patch: t* -*-
;1;;This file was created by Glenda S. McKinney on 15 April 86.  Since dired has not been fixed so that it can be used with medfnb,  this redefines the function that creates dired buffers so that the actual directory listing is always in cptfont.  Explorer mail also looked awful (lines wrapped around), so I fixed that, too.*

(DEFUN DIRECTORY-EDIT (PATHNAME &OPTIONAL (SELECT-P T))
  "Create a ZMACS buffer editing the directory PATHNAME, and select it unless inhibited.
The buffer is selected unless SELECT-P is NIL.2  Modified so that dired is always in cptfont.*"
  (LET ((INTERVAL
	  ;;  The following comment may now be bogus. - pf, Apr 29, 1985
	  ;; We do not use :FIND-SPECIAL-BUFFER because we can be called
	  ;; while not inside ZMACS, and there may not even be a good way to
	  ;; pick which ZMACS window to call.
	  (or (find-dired-buffer pathname) ;;gsl. 4-20-85
	      (MAKE-INSTANCE
		'ZMACS-BUFFER
		:NAME
		(LOOP FOR I FROM 1
		      AS BUFNAM = (FORMAT NIL "~A (~D)"
					  PATHNAME
					  I)
		      UNLESS (FIND-BUFFER-NAMED BUFNAM)
		      RETURN BUFNAM)))))
    (MAKE-BUFFER-READ-ONLY INTERVAL)
    (SETF (NODE-SPECIAL-TYPE INTERVAL) :DIRED)
    (SETF (BUFFER-SAVED-MAJOR-MODE INTERVAL) 'DIRED-MODE)
    (set-buffer-fonts interval '(:cptfont))                ;1;;;;  Make buffer have CPTFONT ---- LS*
    (IF SELECT-P
	(SEND INTERVAL :SELECT))
    ;;this was the else of the preceeding if. 1 *Direds didn't get on other histories. gsl.
    (SEND INTERVAL :ACTIVATE)
    (PUTPROP INTERVAL (LIST PATHNAME) 'PATHNAME-LIST)
    (LET ((*INTERVAL* NIL))
      (DIRECTORY-EDIT-REVERT INTERVAL))
    (IF SELECT-P
	(SETQ *DIRED-PATHNAME-NAME* (SEND (BUFFER-PATHNAME INTERVAL) :STRING-FOR-PRINTING))))
    DIS-TEXT)

(defun mail-summary-edit (&optional select-p (select-type :summary-mode) (pathname *user-default-mail-file*))
  "Create a ZMACS buffer with the users mail summary, and possibly selects it.
   The buffer is selected if SELECT-P is T.2  Modified so that mail summary is always in cptfont.*"

  (fs:force-user-to-login)
  (setf pathname (fs:parse-namestring pathname))
  (setf pathname (send pathname :new-version :newest))
  
  (let ((buffer-name)
	(buffer-pathname)
	(interval)
	(mail-buffer)
	(new-buffer-created-p))

    (multiple-value-setq (buffer-pathname buffer-name) (editor-file-name pathname))
    (setf mail-buffer (find-mail-buffer buffer-pathname))
    
    (when (and mail-buffer (get mail-buffer :summary-buffer))
      (setf interval (get mail-buffer :summary-buffer)))
    
    
    (when (or (not interval)
	      (not mail-buffer))      
      
      ;; Create buffers that were not found.
      (when (not mail-buffer)
	(setf mail-buffer
	      (make-instance
		'zwei-mail-file-buffer
		:pathname buffer-pathname
		:name (string-append buffer-name "(m)")))
	;; Make sure the new buffer is recorded in the right places
	(send mail-buffer :activate)
	)

      (when (not interval)
	(setf interval 
	      (make-instance
		'zmacs-buffer
		:pathname buffer-pathname
		:name (string-append buffer-name "(s)")))
	(setf (node-undo-status interval) :dont)
	;; Make sure the new buffer is recorded in the right places
	(send interval :activate))

      ;; Activate correct buffer.
      (cond ((eq select-type :summary-mode)
	     (send interval :activate))
	    (t
	     (send mail-buffer :activate)))

      ;; Tell each of the buffers about each other.
      (putprop interval mail-buffer :mail-buffer)
      (putprop mail-buffer interval :summary-buffer)
      (putprop interval (send pathname :directory) :user-id)
      
      (make-buffer-read-only interval)
      (setf (node-special-type interval) :mail-summary)    
      (setf (buffer-saved-major-mode interval) 'mail-summary-mode)
      (set-buffer-fonts interval '(:cptfont))                ;1;;;  Make buffer have CPTFONT --- LS.*
      (setf new-buffer-created-p t))


    (cond ((and (get mail-buffer :buffer-lock)
		(neq (get mail-buffer :buffer-lock) si:current-process))
	   (process-wait "Input wait" #'(lambda (buffer) (not (get buffer :buffer-lock))) mail-buffer))
	  (t
	   (with-lock ((get mail-buffer :buffer-lock))
	     
	     ;; Read mail file if this is a new buffer.
	     (when new-buffer-created-p	       
	       (send mail-buffer :read-babyl-mail-file t)
	       (mail-summary-revert interval))
	     
	     ;; Read inboxes and save file if necessary.
	     (cond ((or new-buffer-created-p *always-check-inboxes*)
		    (when (send mail-buffer :read-inboxes)
		      (process-run-function '(:name "Save mail file" :priority -20)
					    #'(lambda (mail-buffer) (send mail-buffer :save-buffer))
					    mail-buffer)
		      (when (send *query-io* :exposed-p)	     
			(format *query-io* "~&New mail read. Saving mail file."))
		      ;; Revert summary buffer since there is new mail
		      (mail-summary-revert interval)))))))

    ;; Select correct buffer.
    (if select-p
	(progn
	  (cond ((eq select-type :summary-mode)
		 (send interval :select))
		(t
		 (send mail-buffer :select)))
;	  ;1;added by GSM on 15 April 86*
;	  (REDEFINE-FONTS 1*window** '(("cptfont" . fonts:cptfont)))
	  ))))
