;;; -*- Mode:Common-Lisp; Package:ZWEI; Patch-file:T; Fonts:(CPTFONT HL12B HL12BI); Base:8 -*-

;1;; Fonts defined as:*
;1;;  Default font       A *
;1;;  Comments         B *
;1;;  Doc Strings       C *
;1;;  Non Doc Strings   D or *ELECTRIC-FONT-LOCK-NON-DOC-STRING-FONT* if a fixnum*
;1;;  Function Spec     E*

(DEFCOM com-fontify-region-or-buffer
  "2Fontify a marked region or the whole buffer according to electric font lock rules*" ()
  (LET* ((current-font 0)
	(number-of-fonts (length (window-font-alist *window*)))
        (font-comments (>= number-of-fonts 2))
	(font-doc-string (>= number-of-fonts 3))
	(font-fspec (>= number-of-fonts 4))
	(font-non-doc-strings (>= number-of-fonts 5))
	(save-font *font*)
	first-line mode-line-exists last-line slash in-string dbl-quote-char
	next-char-in-string next-char-in-comment in-comment doc-string-p
        func-spec-start func-spec-end max-index start-bp end-bp new-bp)

    (WHEN (NEQ *interval* (window-interval *mini-buffer-window*))
      ;1;get the interval to fontify.  Use marked region, or do the whole buffer*
      (multiple-value-setq (start-bp end-bp)
          (if (window-mark-p *window*)               ;1region is marked*
	      (region (a b)
		 (values a b))                       ;1 just return start and end of marked region*
	      (values (interval-first-bp *interval*) ;1 else the start and end of whole buffer*
		      (interval-last-bp *interval*))))
      (setq first-line (bp-line start-bp)
	    mode-line-exists (cli:search "-*-" first-line :test #'char-equal)) ;1should be a better way to determine this*

      ;1;loop thru the whole region character by character via charmap*
      (charmap (start-bp end-bp)
 
	 ;1;Some things to do each time we get a new line*
         (WHEN (NEQ line last-line)
            (and font-fspec            ;1see if there is func spec on this line, if we're fonting them*
		 (multiple-value-setq (func-spec-start func-spec-end)
		      (in-function-spec line)))
	    (setq max-index (1- (length line))
		   last-line line
		   in-comment nil))

	 ;1;Determine where this character is and set the appropriate state variables.*
	 (LET ((CH (charmap-ch-char)))
	   (COND (SLASH (SETQ SLASH NIL))
		 (T
		   (WHEN NEXT-CHAR-IN-STRING
		     (SETQ IN-STRING T
                           NEXT-CHAR-IN-STRING NIL))
		   (WHEN NEXT-CHAR-IN-COMMENT
		     (SETQ IN-COMMENT T
			   NEXT-CHAR-IN-COMMENT NIL))
		   (SELECT (LIST-SYNTAX-OPEN-CODED CH)
		      (LIST-SLASH (SETQ SLASH T))
		      (LIST-COMMENT (OR IN-STRING (SETQ NEXT-CHAR-IN-COMMENT T)))
		      (LIST-DOUBLE-QUOTE
			(COND (IN-COMMENT)
			      ((NOT IN-STRING)
			       (SETQ NEXT-CHAR-IN-STRING CH
			               dbl-quote-char ch)
			       (WHEN FONT-DOC-STRING
			         (LET ((BP (CREATE-BP LINE INDEX)))
				   (SETQ DOC-STRING-P
					 (BP-= (FORWARD-CHAR (FORWARD-DEFUN BP -1 T) 1 T)
					       (FORWARD-SEXP BP -3))))))
			      ((CHAR= CH dbl-quote-char)
			       (SETQ IN-STRING NIL
				     DOC-STRING-P NIL))))))))

	 ;1;Determine which font this character should be in*
	 (LET ((NEW-FONT
		 (COND
		   ((AND FONT-COMMENTS IN-COMMENT )	                ;1In a Comment.*
		    (IF (AND MODE-LINE-EXISTS (EQ LINE FIRST-LINE))	;1  don't font mode line*
			0 1))
		   ((AND FONT-DOC-STRING IN-STRING DOC-STRING-P)	;1in a documentation string*
		    2)
		   ((AND FONT-NON-DOC-STRINGS IN-STRING)		;1in a non-documentation string*
		    (IF (INTEGERP  *ELECTRIC-FONT-LOCK-NON-DOC-STRING-FONT*)
			*ELECTRIC-FONT-LOCK-NON-DOC-STRING-FONT*
			3))
		   ((AND FUNC-SPEC-START (<= FUNC-SPEC-START INDEX FUNC-SPEC-END))	;1in a function spec*
		    4)		
		   (T 0))))						;1in a default area*
	   
	   ;1;See if we have a new-font.  change the previous interval to the correct font*
	   (COND ((/= *FONT* NEW-FONT)
		  (SETQ *FONT* NEW-FONT)	
		  (CHANGE-FONT-INTERVAL START-BP
					(SETQ NEW-BP (CHARMAP-BP-BEFORE)) 
					T CURRENT-FONT)
		  (SETQ CURRENT-FONT *FONT*
			START-BP NEW-BP
			LAST-LINE (BP-LINE START-BP))))))

      ;1;Change the font of the last interval if necessary.*
      (UNLESS (BP-= START-BP END-BP)
	  (CHANGE-FONT-INTERVAL START-BP END-BP T *FONT*))
      ;1;Put the font back to the value it was when we started all this*
      (SETQ *FONT* SAVE-FONT)
      (UPDATE-FONT-NAME)))
  DIS-TEXT)

(DEFUN IN-FUNCTION-SPEC (LINE)
  "Returns location of of the function spec or nil if not a line starting with (def."
  (DECLARE (VALUES START-LOC END-LOC))
  (LET ((LINE-SIZE (LENGTH LINE)))
    (WHEN (AND (PLUSP LINE-SIZE)
	       (STRING-EQUAL LINE "(DEF" :END1 4 :END2 4))	;1does this line start with "(def" ? *
	  (LET* ((FIRST-SPACE (POSITION #\SPACE LINE))
		 (START-OF-FSPEC (AND FIRST-SPACE
				      (OR (POSITION #\SPACE LINE :TEST-NOT #'CHAR-EQUAL
						    :START (1+ FIRST-SPACE))
					  (1- LINE-SIZE))))
		 (FSPEC-IN-PARENS (AND START-OF-FSPEC
				       (CHAR-EQUAL (AREF LINE START-OF-FSPEC) #\( )))
		 (ENDING-CHAR (IF (AND FSPEC-IN-PARENS
				       (NOT (STRING-EQUAL "(DEFSTRUCT" LINE :END2 10.)))
				  #\) #\SPACE))
		 (ENDING-POS (AND START-OF-FSPEC
				  (1- (OR (POSITION ENDING-CHAR LINE :START (1+ START-OF-FSPEC) :TEST #'CHAR-EQUAL)
					  LINE-SIZE)))))
	    (VALUES START-OF-FSPEC
		    ENDING-POS)))))



;1;; Fonts defined as:*
;1;;  DEFAULT FONT     A *
;1;;  COMMENTS         B *
;1;;  DOC STRINGS      C *
;1;;  NON DOC STRINGS  D OR *ELECTRIC-FONT-LOCK-NON-DOC-STRING-FONT* IF A FIXNUM*
;1;;  FUNCTION SPEC    E*
;1NOTE  This guy still will change the font on the mode line.  i don't know of a cheap *
;1   check i can do to prevent it (like (mode-line-bp inteval) ).  it has to be cheap*
;1   because this takes too much time as it is.*
;1ALSO, this guy could be smarter.  it checks state of the current point in total, without*
;1   regard for what it did on the last character.  this can be very expensive on strings.*
;1   maybe lisp-bp-syntactic-context tries to save state, but it doesn't appear to do so.*
;1   turn electric font lock on in some very large buffer sometime ... S L O W.*
(DEFUN FONT-LOCK-HOOK (CHAR)						
  (LET (COMMENT-P
	STRING-P
	(POINT (POINT))
	(*LISP-PARSE-PREPARSED-FLAG* T)
	SLASHIFIED-P)
    (COND ((NEQ *INTERVAL* (WINDOW-INTERVAL *MINI-BUFFER-WINDOW*))
	   (OR (AND (EQ *LAST-COMMAND-TYPE* 'SELF-INSERT)
		    (EQ (BP-LINE POINT) *SHIFT-LOCK-HOOK-LAST-LINE*))
	       (SETQ *SHIFT-LOCK-HOOK-DEFUN-BEGINNING* (FORWARD-DEFUN POINT -1 T)
		     *SHIFT-LOCK-HOOK-LAST-LINE* (BP-LINE POINT)
		     *LISP-PARSE-PREPARSED-FLAG* NIL))
	   (MULTIPLE-VALUE-SETQ (STRING-P SLASHIFIED-P COMMENT-P)
	     (LISP-BP-SYNTACTIC-CONTEXT POINT *SHIFT-LOCK-HOOK-DEFUN-BEGINNING*))
	   (LET ((NEW-FONT (COND
			     ;1;If there are no fonts declared, see if fonts should be used anyways*
			     ((AND (NULL *ELECTRIC-FONT-LOCK-IF-NO-FONTS-DECLARED-P*)
				   (NULL (WINDOW-FONT-ALIST *WINDOW*)))
			      0)
			     ;1;A Comment*
			     (COMMENT-P
			      1)
			     ;1;A Documentation String*
			     ((AND STRING-P (BP-IN-DOC-STRING POINT CHAR SLASHIFIED-P))
			      2)
			     ;1;A Non-Documentation String*
			     ((AND STRING-P
				   (OR SLASHIFIED-P (NOT (EQL CHAR #\"))))	 ;1make sure not to include terminating quotes*
			      (COND ((INTEGERP *ELECTRIC-FONT-LOCK-NON-DOC-STRING-FONT*)
				     *ELECTRIC-FONT-LOCK-NON-DOC-STRING-FONT*)
				    ((< (LENGTH (WINDOW-FONT-ALIST *WINDOW*)) 4)
				     0)
				    (T 3)))
			     ((AND (>= (LENGTH (WINDOW-FONT-ALIST *WINDOW*)) 5)
				   (MULTIPLE-VALUE-BIND (BEG END)
				       (IN-FUNCTION-SPEC (BP-LINE *POINT*))
				     (AND BEG END (<= BEG (1- (BP-INDEX *POINT*)) END))))
			      4)
			     (T 0))))
	     (COND
	       ((/= *FONT* NEW-FONT)
		(SETQ *FONT* NEW-FONT)
		(UPDATE-FONT-NAME))))))))

;1;;This stuff is just because zmacs still references the fed version of this*
;1;;in rel3b bands.  the newer zmacs uses the tv version.*

(UNLESS (FIND-PACKAGE 'FED)
   (MAKE-PACKAGE 'FED))

(DEFUN FED:FONT-CHAR-MIN-RASTER-WIDTH (FONT CHAR-CODE &OPTIONAL LOW-LEVEL
				   &AUX BIT-POS WORD-POS TEM MIN-RASTER-WIDTH F-RASTER-WIDTH RASTER-HEIGHT)
  (COND
    ((AND (NOT LOW-LEVEL) (SETQ TEM (TV:FONT-INDEXING-TABLE FONT)))
     ;1; IF IT'S A WIDE FONT, GO BY THE NUMBER OF VERTICAL STRIPES,*
     ;1; BUT ALSO SEE HOW WIDE THE RIGHTMOST STRIPE REALLY NEEDS TO BE.*
     (LET ((START-IDX (AREF TEM CHAR-CODE))
	   (END-IDX (AREF TEM (1+ CHAR-CODE))))
       (IF (= START-IDX END-IDX)
	 0
	 (MAX 0
	      (+ (* 32. (- END-IDX START-IDX)) -32.
		 (FED:FONT-CHAR-MIN-RASTER-WIDTH FONT (1- END-IDX) T))))))
    (T
     (SETQ WORD-POS (* CHAR-CODE (TV:FONT-WORDS-PER-CHAR FONT))
	   BIT-POS 0
	   MIN-RASTER-WIDTH 0
	   F-RASTER-WIDTH (TV:FONT-RASTER-WIDTH FONT)
	   RASTER-HEIGHT (TV:FONT-RASTER-HEIGHT FONT))
     (DOTIMES (VPOS RASTER-HEIGHT)
       (AND (> (+ BIT-POS F-RASTER-WIDTH) 32.) (SETQ BIT-POS 0
						    WORD-POS (1+ WORD-POS)))
       (DO ((HPOS 0 (1+ HPOS))
	    (INDEX (+ BIT-POS (LSH WORD-POS 5)) (1+ INDEX)))
	   ((= HPOS F-RASTER-WIDTH))
	 (OR (ZEROP (AREF FONT INDEX)) (SETQ MIN-RASTER-WIDTH (MAX (1+ HPOS) MIN-RASTER-WIDTH))))
       (SETQ BIT-POS (+ F-RASTER-WIDTH BIT-POS)))
     MIN-RASTER-WIDTH)))
