;;; -*- Mode: LISP; Package: ZWEI; Base: 10.; Fonts: MEDFNT,HL12B,HL12BI -*-

;1;*
;1;  ELECTRIC-FONT-LOCK-MODE is redefined below to lock semicolon comments into*
;1;  font B and DEF-form documentation strings into font C.  Also, when font-locking*
;1;  happens, the previous font is saved, to be restored when moving into a non-font-lock*
;1;  context.*
;1;*


(DEFVAR *font-lock-context* nil
  "2Value is*	2:COMMENT if point is in a comment,*
		2:DOC if in a DEF-form documentation string,*
		2:LEADIN if font is not locked but previous character was a font-lock*
			2leadin,*
		2NIL otherwise.*")


(DEFVAR *non-locked-font* 0.
  "2Used to save previous font when font is locked.*")


(DEFVAR *font-lock-leadin-chars* '(#/" #/;)
  "2Leadins to comments and documentation strings.*")


(DEFUN font-lock-hook (char)
  "2An ugly function for automatically putting semicolon comments in font B and
function documentation strings in font C.  This version is nowhere near as
clean as the original FONT-LOCK-HOOK, which used to calculate the context
of the cursor on every character typed; it now has to take documentation
strings (defined as the fourth element of a DEF-form, if that element is a
string) into consideration, the calculation of which is too time-consuming to
perform on every character.  So instead it tries to be smart about when to
calculate context.*"
  (LET ((command *current-command*))
    (IF (EQ command 'com-standard)
	(SETQ command *standard-command*))
    (SETQ char (LDB %%ch-char char))	  ;1 unfontify the character*
    (COND ((AND *font-lock-context*  
		(OR (EQ *interval*
			(window-interval *mini-buffer-window*))
		    (NOT (MEMQ command
			       '(com-self-insert com-ordinarily-self-insert)))))
	   ;1;*
	   ;1; we were in :COMMENT or :DOC, and have entered the minibuffer*
	   ;1; or have typed a non-inserting char; reset to the non-comment*
	   ;1; font and update the mode line*
	   ;1;*
	   (SETQ *font*              *non-locked-font*
		 *font-lock-context* nil)
	   (update-font-name))
	  ((MEMQ command '(com-self-insert com-ordinarily-self-insert))
	   ;1;*
	   ;1; we just typed an inserting character*
	   ;1;*
	   (IF (OR (NEQ *last-command-type* 'self-insert)
		   (EQ *font-lock-context* ':LEADIN))
	       ;1;*
	       ;1; if the previous character was not self-inserting, or it was a comment*
	       ;1; leadin character, we may have entered a comment; better check it out.*
	       ;1;*
	       (reset-font-lock-context))
	   ;1;*
	   ;1; we still have just typed an inserting character*
	   ;1;*
	   (COND ((AND (EQ *font-lock-context* ':DOC)
		       (EQ char #/"))
		  ;1;*
		  ;1; we were typing a documentation string and just typed the*
		  ;1; closing quote; reset to the non-comment font and update*
		  ;1; the mode line*
		  ;1;*
		  (SETQ *font*              *non-locked-font*
			*font-lock-context* nil)
		  (update-font-name))
		 ((AND (NOT *font-lock-context*)
		       (MEMQ char *font-lock-leadin-chars*))
		  ;1;*
		  ;1; we weren't typing any sort of comment, but have just typed*
		  ;1; a comment leadin; set the flag so that next time through this*
		  ;1; function we'll know what has happened.*
		  ;1;*
		  (SETQ *font-lock-context* ':LEADIN)))))))


(DEFUN reset-font-lock-context (&aux STRING slash COMMENT (point (point)) 
				     (*lisp-parse-preparsed-flag* t)
				     (defun-begin (forward-defun point -1 t)))
  "2Figures out whether the current POINT is inside a semicolon comment or
a DEF-form documentation string; if current context is different from the
previous context, appropriate changes in fonts and global variables are made.*
	2NOTE:*	2The old FONT-LOCK-MODE used to force all non-comment characters*
		2into font A; this revision tries to let you use any font you like*
		2for non-comment text.*"
  (SETQ *lisp-parse-preparsed-flag* nil)
  (MULTIPLE-VALUE (string slash comment)
    (lisp-bp-syntactic-context point defun-begin))
  (COND (comment			  ;1 we are in a semicolon comment*
	 (COND ((NEQ *font-lock-context* ':comment)1     *;1 if we weren't already in one*
		(IF (NOT *font-lock-context*)	1 *;1 if we're in default context*
		    (SETQ *non-locked-font* *font*))1    *;1 save off the default font*

		(SETQ *font*              1	1 *;1 switch to font B*
		      *font-lock-context* ':comment)1    *;1 change context flag*
		(update-font-name))))	1   *;1 update the mode line*
	((AND string
	      (bp-= defun-begin
		    (forward-sexp (forward-up-string (point) t) -4 t)))
	 ;1;*
	 ;1; we are in a documentation string*
	 ;1;*
	 (COND ((NEQ *font-lock-context* ':doc)	  ;1 if we weren't already in one*
		(IF (NOT *font-lock-context*)	  ;1 if we're in default context*
		    (SETQ *non-locked-font* *font*))	  ;1 save off the default font*
		(SETQ *font*              2	  ;1 switch to font C*
		      *font-lock-context* ':doc)  ;1 change context flag*
		(update-font-name))))	  ;1 update the mode line*
	(t				  ;1 we aren't in either sort of comment*
	 (COND (*font-lock-context*	  ;1 if we were in some comment*
		(SETQ *font* *non-locked-font*)	  ;1 switch to non-comment font*
		(update-font-name)))	  ;1 update the mode line*
	 (SETQ *font-lock-context* nil))));1 change context flag

