;;; -*- Mode:LISP; Package:ZWEI; Fonts:(HL12BI HL12I HL10B CPTFONT); Base:10 -*-

;;;     CODE FOR DEFAULT MULTIPLE FONTS WHEN USING UT-MODS VERSION OF FONT LOCK
;;;     -----------------------------------------------------------------------
;;;
;;;                              coded by Terry Thrift as of release 5.1

;;;        NOTES AND ADDITIONS
;;; Add a comtab to set attribute lists of lisp mode buffers associated with files?
;;; Add more user variables for mode specific defaults?
;;;     

;;; A user might use this file by placing similar forms in
;;; an init file or world load,

;;;         ;; In Zwei use shift lock & font lock 
;;;         (DEFUN ELECTRIC-SHIFT-AND-FONT-LOCK-IF-APPROPRIATE ()
;;;           (zwei:electric-SHIFT-lock-if-appropriate)
;;;           (ZWEI:ELECTRIC-FONT-LOCK-IF-APPROPRIATE))
;;;         (setq Zwei:lisp-mode-hook 'ELECTRIC-SHIFT-AND-FONT-LOCK-IF-APPROPRIATE)
;;;         
;;;         ;; give zmacs default buffers a font list so that electric font defaults to being useful for lisp code
;;;         (LOAD "pathname for the definitions in this file")
;;;         (SETQ ZWEI:*ZMACS-DEFAULT-FONT-LIST-STRING* "CPTFONT HL10B HL12i HL12BI")
    
;;; This is intended to be a user init file defineable variable.
(DEFVAR *ZMACS-DEFAULT-FONT-LIST-STRING*)

;;;This method is a modified com-set-fonts from sys:zwei;font.lisp.86 ,release 5.1
;;;Each time a lisp mode buffer not associated with a file is activated this adds the default attribute list.
(DEFMETHOD (ZMACS-BUFFER :AFTER :activate) (ignore)
  (WHEN (AND (BOUNDP '*ZMACS-DEFAULT-FONT-LIST-STRING*)
             ;(EQUAL :NEW-FILE (SEND SELF ':EDITING-FILE-P))
             (EQUAL 'LISP-MODE *MAJOR-MODE*))
    (LET ((TEM (DO ((FL (OR (WINDOW-FONT-ALIST *WINDOW*)
			  (LIST (LIST (TV:FONT-NAME (AREF (SEND (WINDOW-SHEET *WINDOW*)
								':FONT-MAP)
							  0)))))
		      (CDR FL))
		  (STR (MAKE-ARRAY 100
				   ':TYPE 'ART-STRING
				   ':LEADER-LIST '(0)))
		  (FIL "" " "))
		 ((NULL FL) STR)
	       (SETQ STR (STRING-NCONC STR FIL (CAAR FL))))))
      (PKG-BIND "FONTS"
        (SETQ TEM (READ-FROM-STRING (STRING-APPEND "(" *ZMACS-DEFAULT-FONT-LIST-STRING* ")"))))
      (DO ((L TEM (CDR L))
           (FONT)
           (FONT-NAMES)
           (AL NIL))
          ((NULL L)
	 (SEND *INTERVAL* ':SET-ATTRIBUTE ':FONTS FONT-NAMES ':QUERY)
           (SETQ TEM (NREVERSE AL)))
        (SETQ FONT (CAR L))
        (COND ((NOT (SYMBOLP FONT))
               (BARF "~S is not the name of a font" FONT))
              ((NOT (BOUNDP FONT))
               (LOAD (FORMAT NIL "SYS: FONTS; ~A" FONT) "FONTS" T)
               (OR (BOUNDP FONT) (BARF "~S is not a defined font" FONT))))
      (PUSH FONT FONT-NAMES)
      (PUSH (CONS (GET-PNAME FONT) (SYMEVAL FONT)) AL))
    (REDEFINE-FONTS *WINDOW* TEM)
    (UPDATE-FONT-NAME))))

;^F0;;;^F2This method is a modified com-set-fonts from sys:zwei;font.lisp.86 ,re
;lease 5.1
;^F0;;;^F2Each time a lisp mode buffer not associated with a file is activated t
;his adds the default attribute list.
;^F0(DEFMETHOD ^F3(BUFFER :AFTER :ACTIVATE)^F0 ()
;  (WHEN (AND (BOUNDP '*ZMACS-DEFAULT-FONT-LIST-STRING*)
;             (EQUAL :NEW-FILE (SEND SELF :EDITING-FILE-P))
;             (EQUAL :LISP (SEND *MAJOR-MODE* :MAJOR-MODE-KEYWORD))) 
;    (LET (TEM (*SET-ATTRIBUTE-UPDATES-LIST* t))
;      (PKG-BIND "FONTS"
;        (SETQ TEM (READ-FROM-STRING (STRING-APPEND "(" *ZMACS-DEFAULT-FONT-LIST
;-STRING* ")"))))
;      (DO ((L TEM (CDR L))
;           (FONT)
;           (AL NIL))
;          ((NULL L)
;           (SETQ TEM (NREVERSE AL)))
;        (SETQ FONT (CAR L))
;        (COND ((NOT (SYMBOLP FONT))
;               (BARF "~S is not the name of a font" FONT))
;              ((NOT (BOUNDP FONT))
;               (FED:FIND-AND-LOAD-FONT FONT)
;               (OR (BOUNDP FONT) (BARF "~S is not a defined font" FONT))))
;        (PUSH (CONS (GET-PNAME FONT) (SYMEVAL FONT)) AL))
;      (SEND SELF ':PUTPROP TEM ':FONT-ALIST))
;    (UPDATE-ATTRIBUTE-LIST-INTERNAL SELF)))
