;;; -*- Mode:Zetalisp; Package:ZWEI; Patch-file:T; Base:8 -*-
;;;
;;;  Fancy macro handling a la the Macro key on cadrs.
;;;  What a can of worms, with gems hidden among them. gsl.
(defvar macro-function-string nil "For the macro F option in Macro-tyi.")
(defvar macro-function-string-index nil "For the macro F option in Macro-tyi.")

(DEFUN MACRO-TYI (&OPTIONAL (OP ':MOUSE-OR-KBD-TYI))
  (DO ((CH) (TEM) (NUMARG) (FLAG) (TEM2) (SUPPRESS))
      (())
   (*CATCH 'MACRO-LOOP
    (COND (MACRO-FUNCTION-STRING
	   (SETQ CH (AREF MACRO-FUNCTION-STRING MACRO-FUNCTION-STRING-INDEX))
	   (INCF MACRO-FUNCTION-STRING-INDEX)
	   (IF (=  MACRO-FUNCTION-STRING-INDEX (LENGTH MACRO-FUNCTION-STRING))
	       (SETQ MACRO-FUNCTION-STRING NIL) )
	   (RETURN CH) )
	  ((AND MACRO-CURRENT-ARRAY (SETQ TEM2 (MACRO-DEFAULT-COUNT MACRO-CURRENT-ARRAY)))
	   (SETQ TEM (MACRO-POSITION MACRO-CURRENT-ARRAY)
		 CH (AREF MACRO-CURRENT-ARRAY TEM))
	   (COND ((EQ CH '*SPACE*);;We have found a macro query in a macro.
		  (format *typein-window* "Pausing at macro query.");;gsl 3-23-85
                  (SELECTQ (FUNCALL MACRO-STREAM ':MOUSE-OR-KBD-TYI)
                   (#\SP
                    (SETQ CH '*IGNORE*))
                   ((#/? #\HELP)
                    (FORMAT T "~&You are in an interactive macro.~@
                               ~2xSpace - continues on,~@
                               ~2xRubout - skips this one,~@
                               ~2xPeriod - finishes this one,~@
                               ~2x! - Eliminates this macro query this run,~@
                               ~2xClear-screen - refreshes the screen,~@
                               ~2xControl-R - enters a typein macro level (~:C R exits),~@
                               ~2xAnything else exits." MACRO-ESCAPE-CHAR)
		    (send *typein-window* :clear-screen)
                    (*THROW 'MACRO-LOOP NIL))
                   (#\RUBOUT
                    (SETQ TEM (MACRO-LENGTH MACRO-CURRENT-ARRAY)
                          CH '*IGNORE*))
                   ((#\C-R #\C-/r)
                    (SETQ CH NIL));;nil acts as a code to indicate we want to push a macro level, see cond below.
                   (#\FF ;; Used to (return #\ff) gsl. 4-16-85
                    (redisplay *window* :none)
		    (send *typein-window* :clear-screen)
		    (*throw 'macro-loop nil) )
                   (#/. 
                    (SETF (MACRO-DEFAULT-COUNT MACRO-CURRENT-ARRAY) 0)
                    (SETF (MACRO-COUNT MACRO-CURRENT-ARRAY) 0)
                    (SETQ CH '*IGNORE*))
                   (#/!
		    (if (or (not (eq (macro-count MACRO-CURRENT-ARRAY) '*REPEAT*))
			    (queried-gsl MACRO-CURRENT-ARRAY tem)
			    (y-or-n-p "This will cause uninterrupted repetition till ~
                                                  end of buffer is reached, if ever. O.K.?" query-io))
			(ASET '*RUN* MACRO-CURRENT-ARRAY TEM))
                    (SETQ CH '*IGNORE*))
                   (OTHERWISE
                    (MACRO-STOP 1)
		    (send *typein-window* :clear-screen);;gsl 3-23-85
                    (*THROW 'MACRO-LOOP NIL)))
		  (send *typein-window* :clear-screen) );;gsl 3-23-85
		 ;;We have encountered a place the user used the mouse in the macro.
		 ((MEMQ CH '(*MOUSE* *MICE*))
		  (AND (EQ CH '*MOUSE*) (FORMAT *typein-window* "~&Use the mouse.~%"))
		  (SETQ CH (prog1 (FUNCALL MACRO-STREAM ':MOUSE-OR-KBD-TYI)
				  (if (EQ CH '*MOUSE*) (send *typein-window* :clear-screen)) ));;gsl 4-16-85
		  (COND ((TV:CHAR-MOUSE-P CH)
			 (ASET '*MICE* MACRO-CURRENT-ARRAY TEM)
			 (setf (MACRO-POSITION MACRO-CURRENT-ARRAY);;this & next 2 lines gsl. 4-14-85
			       (1+ (MACRO-POSITION MACRO-CURRENT-ARRAY)) )
			 (RETURN `(:mouse-button ,CH ,*window* ,tv:mouse-x ,tv:mouse-y)) )
			(T
			 (ASET '*MOUSE* MACRO-CURRENT-ARRAY TEM)
			 (SETQ CH '*IGNORE*)))))
	    ;;This cond handles macro repetition or termination.
           (COND ((AND (ZEROP TEM)
		       ;; old check for tem2. gsl. 4-14-85
		       (eq (macro-count macro-current-array) '*REPEAT*)
		       ;;Stop infinite repetitions at macro begin if a buffer end reached.
		       (MEMQ ':MACRO-TERMINATE MACRO-OPERATIONS)
		       (FUNCALL MACRO-STREAM ':MACRO-TERMINATE));;check for buffer end.
		  (setq ch '*ignore*);;Ending macro with M-C-term r needs this. gsl 4-14-85
		  (COND (( (SETQ MACRO-LEVEL (1- MACRO-LEVEL)) 0)
			 (SETQ MACRO-CURRENT-ARRAY
			       (AREF MACRO-LEVEL-ARRAY MACRO-LEVEL)))
			(T
			 (SETQ MACRO-CURRENT-ARRAY NIL))))
		 ((< TEM (MACRO-LENGTH MACRO-CURRENT-ARRAY));;Go to next char in macro.
		  (SETF (MACRO-POSITION MACRO-CURRENT-ARRAY) (1+ TEM)))
		 ((eq (macro-count macro-current-array) '*REPEAT*);;Reset infinite macros. ;;gsl 4-17-85
		  (SETF (MACRO-POSITION MACRO-CURRENT-ARRAY) 0))
		 ((> (SETQ TEM (1- (MACRO-COUNT MACRO-CURRENT-ARRAY))) 0);;Others repeat here.
		  (SETF (MACRO-COUNT MACRO-CURRENT-ARRAY) TEM)
                  (SETF (MACRO-POSITION MACRO-CURRENT-ARRAY) 0))
		 (( (SETQ MACRO-LEVEL (1- MACRO-LEVEL)) 0);;Higher level macros pop here.
		  (SETQ MACRO-CURRENT-ARRAY (AREF MACRO-LEVEL-ARRAY MACRO-LEVEL)))
		 (T ;;Done with top level macro here.
 		  (SETQ MACRO-CURRENT-ARRAY NIL)))
	   (COND ((NUMBERP CH) (OR SUPPRESS (RETURN CH)));;Finally, do something with the macro character.
                 ((MEMQ CH '(*RUN* *IGNORE*)))
		 ((AND (CONSP CH) (EQ (CAR CH) '*A*));;Handles the macro-escape-char A command's form.
		  (LET ((X (MACRO-A-VALUE CH)))
		    (SETF (MACRO-A-VALUE CH) (+ X (MACRO-A-STEP CH)))
		    (OR SUPPRESS (RETURN X))))
		 ((AND (CONSP CH) (EQ (CAR CH) '*F*));;Handles the macro-escape-char F command's form.
		  (let ((f-string (eval-macro-f-form (second ch))))
		    (or (= (string-length f-string) 0)
			(setq macro-function-string f-string
			      macro-function-string-index 0))))
		 (T (MACRO-PUSH-LEVEL CH))))
	  ;;There is no current macro, so read a character from the keyboard.
	  (T 
	   (MACRO-UPDATE-LEVEL)
	   (MULTIPLE-VALUE (CH TEM) (FUNCALL MACRO-STREAM OP));;macro stream is kbd input.
	   (COND (FLAG  ;;This is only when the macro-escape-char has just been entered.
		  (OR (NUMBERP CH) (MACRO-BARF))
		  (SETQ CH (CHAR-UPCASE CH))
		  (COND ((AND ( #/0 CH #/9);;Numeric arg entered, stored in numarg.
			 (SETQ NUMARG (+ (- CH #/0) (* (OR NUMARG 0) 10.)))))
			(T ;;We are accepting a macro-escape-char command.
			 (if (eq flag :help) (redisplay *window* :none));;gsl 4-14-85
			 (SETQ FLAG NIL)
			 (SELECTQ CH
			   (#\end (return #\space)) ;;gsl 3-23-85
			   (#/C
			    (SETQ TEM (MACRO-DO-READ "Macro to call: "))
			    (OR (SETQ TEM (GET TEM 'MACRO-STREAM-MACRO)) (MACRO-BARF))
			    (MACRO-STORE TEM)
			    (OR SUPPRESS (MACRO-PUSH-LEVEL TEM)))
			   (#/D
			    (SETQ SUPPRESS MACRO-LEVEL)
			    (MACRO-PUSH-LEVEL (MACRO-MAKE-NAMED-MACRO)))
			   (#/M
			    (MACRO-PUSH-LEVEL (MACRO-STORE (MACRO-MAKE-NAMED-MACRO))))
			   (#/P
			    (MACRO-PUSH-LEVEL (MACRO-STORE)))
			   (#/R
			    (MACRO-REPEAT numarg)
			    (AND (EQ SUPPRESS MACRO-LEVEL) (SETQ SUPPRESS NIL)))
			   (#/S
                            (MACRO-STOP NUMARG) )
			   (#/T
			    (MACRO-PUSH-LEVEL (MACRO-STORE NIL)))
			   (#/U
			    (MACRO-PUSH-LEVEL NIL))
                           (#\SP
                            (MACRO-STORE '*SPACE*))
			   (#/A
			    (LET ((STR (MACRO-READ-STRING
				         "Initial character (type a one-character string):")))
			      (OR (= (STRING-LENGTH STR) 1) (MACRO-BARF))
			      (LET ((VAL (AREF STR 0))
				    (NUM (MACRO-READ-NUMBER
                                  "Amount by which to increase it (type a decimal number):")))
				(MACRO-STORE (MAKE-MACRO-A MACRO-A-VALUE (+ VAL NUM)
							   MACRO-A-STEP NUM
							   MACRO-A-INITIAL-VALUE VAL))
				(OR SUPPRESS (RETURN VAL)))))
			   (#/F
			    (LET ((Sexp (MACRO-READ-FORM
				         "Item or function for insertion:  (end with End.)")))
			      (if Sexp 
				  (progn
				    (MACRO-STORE (list '*F* Sexp))
				    (OR SUPPRESS
					(let ((string (eval-macro-f-form Sexp)))
					  (or (= 0 (string-length string))
					      (setq macro-function-string string
						    macro-function-string-index 0))))
				     ))))
                           (#\HELP
			    (FORMAT T "~&Macro commands are:~@
                                        ~2xP - Push a level of macro,~@
                                        ~2xR - End and Repeat arg times (0 means infinite times),~@
                                        ~2xC - Call a macro by name,~@
                                        ~2xS - Stop macro definition,~@
                                        ~2xU - Allow typein now only, ~@
                                        ~2xT - Allow typein in expansion too. /(terminate typein with ~:C R/)~@
                                        ~2xM - Define a named macro,~@
                                        ~2xD - Define a named macro but don't execute as building.~@
                                        ~2xA - Enter a character,  then a numeric increment used for each macro iteration.~@
                                        ~2xF - Gets function or form from minibuffer.  Result as string inserted at point.~@
                                        ~2xSpace - Enter macro query, ~@
                                        ~2xEnd - Cancels ~0g ~:c prefix and refreshes screen.~@
                                        ~2x (Arguments are digits following ~0g~:c.)~@
                                        ~2xNow type a macro command: "
				    MACRO-ESCAPE-CHAR)
			    (SETQ FLAG :help))
			   (OTHERWISE
			    (MACRO-BARF))))))
		 ((EQ CH MACRO-ESCAPE-CHAR)
		  (SETQ FLAG T NUMARG NIL))
		 (T
		  (cond ((NUMBERP CH)
			 (macro-store (if (TV:CHAR-MOUSE-P CH) '*mouse* ch)) )
			((and (listp ch) (eq (car ch) ':mouse-button));;added. gsl 4-14-85
			 (macro-store '*mouse*) ))
		  (OR SUPPRESS (RETURN CH TEM)))))))))

;;;
;;; In support of the macro function option in macro-tyi (M-C-Term F).
(defun MACRO-READ-FORM (prompt)
  "Reads a form whose value, as determined by eval-macro-f-form will be
inserted in the buffer.  As a special case, if the form returns something
which gives a 0 length string then nothing at all is inserted.  Forms are of 4
varieties: Anything recognizable as a function is called, Any list whose
car is recognizable as a function is evaluated, any symbol is symevaled,
and anything else is inserted literally (which isn't too useful, but handles
errors).  This function is called within macros by means of the F
option (See documentation on help key after typing the key which is the value of
zwei:macro-escape-char)"
  (LET (INTERVAL (old-tab-command (command-lookup #\tab *MINI-BUFFER-MULTI-LINE-COMTAB*))
	(former-macro-position (and MACRO-CURRENT-ARRAY (MACRO-POSITION MACRO-CURRENT-ARRAY))) )
    (unwind-protect  
	(progn
	  (command-store 'com-indent-for-lisp #\tab *MINI-BUFFER-MULTI-LINE-COMTAB*)	;pardon the kludge
	  (MULTIPLE-VALUE (NIL NIL INTERVAL)
	    (EDIT-IN-MINI-BUFFER *MINI-BUFFER-MULTI-LINE-COMTAB* NIL NIL (list prompt))))
      (command-store old-tab-command #\tab *MINI-BUFFER-MULTI-LINE-COMTAB* ))
    (if MACRO-CURRENT-ARRAY (setf (MACRO-POSITION MACRO-CURRENT-ARRAY) former-macro-position))
    (LET ((FORM-STRING (STRING-INTERVAL INTERVAL)) FORM (EOF '(NIL)) )
      (with-lisp-mode (lisp-mode)
	(CONDITION-CASE (ERROR)
	    (MULTIPLE-VALUE (FORM NIL)
	      (case (lisp-mode)
		    (:zetalisp     (si:read-from-string form-string eof))
		    (:common-lisp (cli:read-from-string form-string nil eof))))
	  (SYS:READ-ERROR
	   (BARF (SEND ERROR ':REPORT-STRING)) ))
	(if (NEQ FORM EOF) form) ))))

(defun eval-macro-f-form (form)
  ;;Support for macro-tyi."
  (format nil "~a" (cond ((functionp form t)
			  (funcall form) )
			 ((and (consp form)(functionp (car form) t))
			  (case (lisp-mode)
				(:zetalisp     (si:eval form))
				(:common-lisp (cli:eval form))) )
			 ((and (symbolp form) (boundp form))
			  (symeval form) )
			 (:else form) )))

(DEFCOM COM-VIEW-KBD-MACRO "Typeout the specified keyboard macro.
The macro should be a /"permanent/" macro, that has a name.
The name of the macro is read from the mini-buffer.
Just Return means the last one defined, even if temporary." ()
  (OR (MEMQ ':MACRO-PREVIOUS-ARRAY (FUNCALL STANDARD-INPUT ':WHICH-OPERATIONS))
      (BARF "This stream does not support macros"))
  (LET ((PACKAGE SI:PKG-KEYWORD-PACKAGE)
	NAME MAC)
    (SETQ NAME (TYPEIN-LINE-READ "Name of macro to view (CR for last macro defined):"))
    (COND ((EQ NAME '*EOF*)
	   (SETQ MAC (FUNCALL STANDARD-INPUT ':MACRO-PREVIOUS-ARRAY))
	   (unless mac (barf "There is no previously defined macro.")))
	  ((NOT (SETQ MAC (GET NAME 'MACRO-STREAM-MACRO)))
	   (BARF "~A is not a defined macro." NAME)))
    (DO ((I 0 (1+ I))
	 (LEN (MACRO-LENGTH MAC))
	 (CH))
	((> I LEN))
      (cond ((atom (SETQ CH (AREF MAC I)))
	     (FORMAT T (SELECTQ CH
		      (*MOUSE* "Mouse command ~*")
		      (*SPACE* "Macro query ~*")
		      (*RUN* "Repeat ~*")
		      (NIL "Input ~*")
		      (OTHERWISE "~:C ") )
		  CH))
	    ((not (listp ch)) (format t "There's something I don't understand in the macro: ~a " ch))
	    ((eq (car ch) '*A*)
	     (FORMAT T "Incremented Character: Start ~:c, Increment ~d. "
		     (MACRO-A-INITIAL-VALUE ch) (MACRO-A-STEP ch) ))
	    ((eq (car ch) '*F*)
	     (FORMAT T "Insertion form: ~a" (second ch)) ))))
  DIS-NONE)

;;;
;;; Eyes for Kbd macros.  A creature of great use I believe.
(defvar *READ-PDL* nil "Contains values from Read Forward command.")

(defun read-at-bp (bp1)
   "This function reads an s-expression infront of the buffer pointer bp1."
  (declare (values s-expression errorp))
  (let ((bp2 (FORWARD-SEXP bp1) ))
    (if bp2
	(LET ((FORM-STRING (STRING-INTERVAL (make-INTERVAL bp1 bp2)))
	      FORM (EOF '(NIL)) )
	  (with-lisp-mode (lisp-mode)
	    (CONDITION-CASE (ERROR)
		(MULTIPLE-VALUE (FORM NIL)
		  (case (lisp-mode)
			(:zetalisp     (si:read-from-string form-string eof))
			(:common-lisp (cli:read-from-string form-string nil eof))))
	      (SYS:READ-ERROR (values nil error)))
	    (if (EQ FORM EOF) (values nil :eof) (values form nil)) ))
	(values nil :eof) )))

(defcom com-read-at-point
	"This reads the s-expression infront of point and pushes it
This can be useful when useing the ~a F command for entering functions calls in macros.
This command in effect gives keyboard macros the ability to look at what they are about
to act upon."
   ()
  (multiple-value-bind (sexp errorp)
      (read-at-bp (point))
      (or errorp
	  (PUSH sexp *READ-PDL*) ))
  dis-none)

;;************************************************************************
;;other things
;;************************************************************************

si:(defun flavorp (symbol)
     (get symbol 'flavor) )

;;;
;;; ***=> while we are at creatures, here is a nice one.
;;from Bambi: LYSTAD; IPATCHES2.#
(DEFCOM COM-METHOD-APROPOS "You supply the flavor at the prompt, and then the extended search string to match
the methods against.  The result is a mouse sensitive typeout display of matching methods of flavor and its
components." ()
  (LET* ((FLAVOR-name
	   (READ-FLAVOR-NAME "Flavor"
	      "You are typing a flavor name, to list its methods which match a string you will enter."))
	 (flavor (get flavor-name 'si:flavor))
	FUNCTION KEY STR method-list)
    ;;Make sure we have a valid flavor name.
    (or (symbolp flavor-name) (barf "Enter a symbol which is the name of a flavor"))
    (and (null flavor)
	 (setq flavor
	       (si:COMPILATION-FLAVOR 
		 (*catch 'system:dwimify-package
		   (si:MAP-OVER-LOOKALIKE-SYMBOLS
		     (string flavor-name) nil #'si:dwimify-package-2
		     flavor-name (list #'si:flavorp #'si:flavorp nil "flavor definition" nil) t)))))
    (or flavor (barf "~a does not seem to be the name of any flavor in the system." flavor-name))
    ;;Get the search function and string.
    (MULTIPLE-VALUE (FUNCTION KEY STR)
      (GET-EXTENDED-SEARCH-STRINGS (format nil "Find methods for ~a containing substring:" flavor-name)))
    ;;Get the list of matching methods for the flavor.
    (loop for element in (all-methods-sorted flavor)
	    as name = (string (car (last element)))
	    when (FUNCALL FUNCTION KEY NAME)
	    do (push element method-list) )
    ;;Put up the list on the screen.
    (with-typeout-font-map-of ((get-search-mini-buffer-window))
      (EDIT-DEFINITIONS T
			'DEFUN
			(MAPCAR #'(LAMBDA (OBJ)
					(CONS (FORMAT NIL "~S" OBJ) OBJ))
			      (reverse method-list))
			'com-go-to-next-possibility
			#/c-sh-p
			"All methods of flavor ~S and its components matching ~a:"
			"No methods of flavor ~S matching ~a."
			FLAVOR-name str)))
  dis-none)

;;;
;;; ***=> Paul, I squandered 25 minutes here. How about this for a non-zmacs-variable apropos?
;;        I tried this with a C-U arg, on symbol<and>apropos, and, much to my surprise, found
;;        a function in the tv: package.  It is the same idea, but no extended search, and who knows it's there.  
;;from Bambi: LYSTAD; IPATCHES2.#
(DEFCOM SYMBOL-APROPOS "Find symbols matching a string read from minibuffer.
Searches current package with no arg. C-U prefix (arg of 4) searches all packages.
C-U C-U prefix (arg >= 16) searches package read from minibuffer.
Package superiors are searched unless an arg < 4 or > 16 is given." ()
  (MULTIPLE-VALUE-BIND (PKG PKG-NAME) (GET-PACKAGE-TO-SEARCH)
    (LET (FUNCTION KEY STR symbol-list
	  (header "All symbols in ~a matching ~a:")
	  (superpackages-p (or (null *numeric-arg-p*)(= *numeric-arg* 16.)))
	  (symbol-collector
	    #'(lambda (sym)
		(declare (special FUNCTION KEY symbol-list))
		(if (and (boundp sym)
			 (FUNCALL FUNCTION KEY (string sym)))
		    (push sym symbol-list)) )))
      (declare (special FUNCTION KEY symbol-list))
      (MULTIPLE-VALUE (FUNCTION KEY STR)
	(GET-EXTENDED-SEARCH-STRINGS (format nil "Find symbols in ~a containing substring:" PKG-NAME)))
      (IF (EQ PKG PKG-GLOBAL-PACKAGE)
	  (funcall #'MAPATOMS-ALL symbol-collector)
	(funcall #'MAPATOMS symbol-collector pkg superpackages-p)
	(setq header (format nil "All symbols in ~a~:[~; and its superpackages~] matching ~a:"
	      "~a" superpackages-p "~a")))
      ;;Put up the list on the screen.
      (with-typeout-font-map-of ((get-search-mini-buffer-window))
	(EDIT-DEFINITIONS T
			  'DEFUN
			  (MAPCAR #'(LAMBDA (OBJ)
				      (CONS (FORMAT NIL "~S" OBJ) OBJ))
				  (reverse symbol-list))
			  'com-go-to-next-possibility
			  #/c-sh-p
			  header
			  "No symbols in ~a matching ~a."
			  pkg-name str))))
  dis-none)


(defvariable *EVALUATE-AND-GRIND-INTO-BUFFER-options* '(:comment-out :no-quotes) :anything
  "This is a list which may contain the symbols :comment-out and :no-quotes.  These are the
   default options for the command com-evaluate-and-grind-into-buffer.")

(DEFCOM COM-EVALUATE-AND-GRIND-INTO-BUFFER 
"This evaluates the expression which begins at the curson and puts the result into the buffer in one of several ways.
 If the resulting value is not a string it is pretty printed into the buffer.  If the result is a string it is written
 into the buffer (i.e. the double quotes are removed.)  The double quotes are retained if the value of
 the zmacs variable *EVALUATE-AND-GRIND-INTO-BUFFER-options* doesn't contain :no-quotes.
   The original expression is either commented out or deleted from the buffer.  If commented out, the value is inserted
 on a new line after the comment line(s).  The original expression is commented out as the default, but if
 the zmacs variable *EVALUATE-AND-GRIND-INTO-BUFFER-options* doesn't contain :comment-out then the expression
 is deleted instead." ()
  (dotimes (i *numeric-arg*)
    (LET* ((POINT (POINT)) (MARK (MARK))
	   (STREAM (REST-OF-INTERVAL-STREAM POINT))
	   (FORM (read stream '*eof*)))
      (AND (EQ FORM '*EOF*) (BARF "Unbalanced parentheses or no form."))
      (SETQ FORM (si:eval-abort-trivial-errors form))	; si:eval1 internally.
      (MOVE-BP MARK (FUNCALL STREAM ':READ-BP))
      (WITH-UNDO-SAVE ("replacement" POINT MARK T)
	(WITH-BP (END (FUNCALL STREAM ':READ-BP) ':NORMAL)
	  ;;take care of the original form
	  (if (memq :comment-out *EVALUATE-AND-GRIND-INTO-BUFFER-options*)
	      (progn
		;;comment out the old expression
		(setf (WINDOW-MARK-P *WINDOW*) t)
		(let ((*numeric-arg* 1)
		      (*numeric-arg-p* (and *numeric-arg-p* :digits)) )
		  (com-comment-out-region) ))
	    (DELETE-INTERVAL POINT MARK T))
	  ;;insert the new stuff and move over it.
	  (MOVE-BP POINT END)
	  (if (or (not (memq :no-quotes *EVALUATE-AND-GRIND-INTO-BUFFER-options*))
		  (not (stringp form)) )
	      (progn
		(GRIND-INTO-BP (POINT) form)
		(move-bp point (FORWARD-OVER-MATCHING-DELIMITERS point)) )
	    (let ((OUTPUT-STREAM (INTERVAL-STREAM-INTO-BP (POINT))))
	      (format output-stream (string-append "~&" form))
	      (move-bp point (send output-stream :read-bp))
	      ))))))
  DIS-TEXT)

;; turn more processing on.
(defcom com-show-kill-ring "Show complete contents of kill ring." ()
  (WITH-TYPEOUT-FONT-MAP-OF (*window*)
    (let ((count 0)
	  (indentation 0)
	  (tv:more-processing-global-enable t))
      (format t "~VXMouseable Kill Ring Contents:~%~%" indentation)
      (format t "~VT"  indentation)
      (funcall standard-output ':item 'kill-ring-thing (string #\Return)
	       " Insert a Carriage Return. ")
      (format t "~45T")
      (funcall standard-output ':item 'kill-ring-thing (string #\r)
	       " Toggle of Insert a Carriage Return. ")
      (format t "~%~%")
      (format t "~VT"  indentation)
      (funcall standard-output ':item 'kill-ring-thing (string #\space) " Finished ")
      (format t "~45T")
      (funcall standard-output ':item 'kill-ring-thing (string #\f)
	       " Toggle finished when entire yank is done. ")
      (format t "~%~%")
      (display-mouse-yank-status )
      (dolist (node (zwei:history-list zwei:*kill-history*)) ;; Patch 98.165.   ddd, 3/15/84.
	(setq count (1+ count))
	(format t "~%")
	(show-yankable-node node (format NIL "~VX~D:" 1 count)
			    "<< ALL of the following kill. >>"
			    count indentation))))
  dis-text)

;;**********************************************************************
;; LIST CALLEES  7-9-86
;;**********************************************************************
(defcom com-find-callees "This puts a list of everything called in the typeout window." ()
  (LET ((FUNCTION (READ-FUNCTION-NAME
		      "List callees of"
		      (RELEVANT-FUNCTION-NAME (POINT))
		      t
		      'ALWAYS-READ))
	(tv:more-processing-global-enable t) )
    (selectq (typep (fsymeval function))
      (:compiled-function
       (format t "~{~&~s~^~30t ~s~^~60t ~s~}~%" (find-callees function)) )
      (:cons
       (if (and (eq (first (fsymeval function)) 'macro)
		(typep (cdr (fsymeval function)) :compiled-function) )
	   (progn
	     (format t "~%This is a macro, I'll look at the expander function.~%~%")
	     (format t "~{~&~s~^~30t ~s~^~60t~s~}~%" (find-callees-macro function)) )
	 (format t "~%This is not a compiled function or a compiled macro.~%~%") ))
      (otherwise (format t "~% This is not a compiled function or a compiled macro.~%~%")) ))
  dis-none)


(DEFUN find-callees (caller &optional (function #'(lambda (sym call-type)(declare (special result-find-callees))
							  (if (not (assq sym  result-find-callees))
							      (push (list sym call-type) result-find-callees) ))))
  (declare (special function))
  (let (result-find-callees)
    (declare (special result-find-callees))
    (FIND-CALLEES-FEF caller (fsymeval caller))
    result-find-callees) )

(defun find-callees-macro (caller &optional (function #'(lambda (sym call-type)(declare (special result-find-callees))
							  (if (not (assq sym  result-find-callees))
							      (push (list sym call-type) result-find-callees) ))))
  (declare (special function))
  (let (result-find-callees)
    (declare (special result-find-callees))
    (FIND-CALLEES-FEF caller (cdr (fsymeval caller)))
    result-find-callees) )

(DEFUN FIND-CALLEES-FEF (CALLER DEFN &AUX TEM OFFSET SYM)
  (DECLARE (SPECIAL FUNCTION))
  (DO ((I SI:%FEF-HEADER-LENGTH (1+ I))
       (LIM (TRUNCATE (SI:FEF-INITIAL-PC DEFN) 2)))
      ((>= I LIM) NIL)
    (COND ((= (%P-LDB-OFFSET %%Q-DATA-TYPE DEFN I) DTP-EXTERNAL-VALUE-CELL-POINTER)
	   (SETQ TEM (%P-CONTENTS-AS-LOCATIVE-OFFSET DEFN I)
		 SYM (%FIND-STRUCTURE-HEADER TEM)
		 OFFSET (%POINTER-DIFFERENCE TEM SYM))
	   (COND ((NOT (SYMBOLP SYM)))
		 ((= OFFSET 2)			;Function cell reference
		  (IF (NOT (FBOUNDP SYM))
		      (FUNCALL FUNCTION SYM ':UNBOUND-FUNCTION)
		    (FUNCALL FUNCTION SYM ':FUNCTION))
		  )
		 (T				;Value reference presumably
		  (FUNCALL FUNCTION SYM ':VARIABLE))))
	  ((= (%P-LDB-OFFSET %%Q-DATA-TYPE DEFN I) DTP-SELF-REF-POINTER)
	   (LET* ((FN (SI:FEF-FLAVOR-NAME DEFN)))
	     (IF FN
		 (MULTIPLE-VALUE-BIND (SYM USE)
		     (SI:FLAVOR-DECODE-SELF-REF-POINTER FN (%P-LDB-OFFSET %%Q-POINTER DEFN I))
		   (FUNCALL FUNCTION SYM
			       (IF USE ':FLAVOR ':VARIABLE))))))
	  ((SYMBOLP (SETQ SYM (%P-CONTENTS-OFFSET DEFN I)))
	   (FUNCALL FUNCTION SYM ':CONSTANT))))
  ;; See if the fef uses the symbol as a macro.
  (LET ((DI (DEBUGGING-INFO DEFN)))
    (DOLIST (M (CADR (ASSQ ':MACROS-EXPANDED DI)))
      (FUNCALL FUNCTION (IF (CONSP M) (CAR M) M) ':MACRO)))
  ;; See if we have a function reference compiled into a misc instruction
;  (IF (SYMBOLP SYMBOL)
;      (IF (FEF-CALLS-MISC-FUNCTION DEFN SYMBOL)
;	  (FUNCALL FUNCTION CALLER SYMBOL ':MISC-FUNCTION))
;      (DOLIST (SYM SYMBOL)
;	(IF (FEF-CALLS-MISC-FUNCTION DEFN SYM)
;	    (FUNCALL FUNCTION CALLER SYM ':MISC-FUNCTION))))
  (AND (LDB-TEST SI:%%FEFHI-MS-DEBUG-INFO-PRESENT
		 (%P-CONTENTS-OFFSET DEFN SI:%FEFHI-MISC))
       (SETQ TEM (CDR (ASSQ ':INTERNAL-FEF-OFFSETS
			    (%P-CONTENTS-OFFSET DEFN (1- (%P-LDB SI:%%FEFH-PC-IN-WORDS DEFN))))))
       (LOOP FOR OFFSET IN TEM
	     FOR I FROM 0
	     DO (FIND-CALLEES-FEF `(:INTERNAL ,CALLER ,I)
				  (%P-CONTENTS-OFFSET DEFN OFFSET)))))

;;**********************************************************************
;; THIS IS A COPY OF THE COPY OBLITERATE STUFF
;;**********************************************************************

(DEFCOM COM-COPY-DIRECTORY-ALL "Copy a directory and all its subdirectories and theirs.  Exclusions may be made
   by puting them in the global variable *copy-directory-exclusions*.  Use this as a zmacs command from M-C-x." ()
  (declare (special *copy-directory-exclusions*))
  (LET* ((directory (read-directory-name (format nil "Directory to copy:") (fs:default-pathname (pathname-defaults))))
	 (default (or *dired-last-copied-pathname* (fs:default-pathname (pathname-defaults))))
	 (NEW-directory (read-directory-name (FORMAT NIL "Pathname to copy ~A to" directory)
					    default)) )
    (COPY-DIRECTORY-ALL-internal directory
				 new-directory
				 (y-or-n-p "Newest versions only?")
				 0
				 (if (variable-boundp *copy-directory-exclusions*) *copy-directory-exclusions*)
				 (y-or-n-p "Do you wish to be to be asked about each file individually?") ))
  DIS-TEXT)

(defun COPY-DIRECTORY-ALL-internal (pathname destination &optional (newest-only nil) (level 0)
				    (exclusions nil) query-p)
  "Recursively copies all (or newest versions only if newest-only is non-nil) files in pathname and its subdirectories
to destination."
  (format t "~vxDirectory ~a~%" level pathname)
  (let ((info (FS:DIRECTORY-LIST PATHNAME :SORTED)))
    (do* ((tail info (cdr tail)))
	 ((null tail))
      (let* ((file-info-list (car tail))
	    (filename (car file-info-list)))
	(cond ((null filename))
	      ((string-equal "DIRECTORY" (send filename :type))
	       (let ((source-dir (send filename :directory))
		     (destin-dir (send destination :directory)) )
		 (if (nlistp source-dir)(setq source-dir (list source-dir)))
		 (if (nlistp destin-dir)(setq destin-dir (list destin-dir)))
		 (setq destin-dir (send destination :new-directory
					(append destin-dir (list (send filename :name))) ))
		 (if (member source-dir exclusions)
		     (format t "~&Skipping ~a~%" (send filename :pathname-as-directory-wild))
		   (fs:create-directory destin-dir :recursive t)
		   (copy-directory-all-internal
		     (send filename :pathname-as-directory-wild)
		     destin-dir
		     newest-only (1+ level) exclusions query-p)
		   (format t "~%") )))
	      ((and newest-only
		    (car (second tail))
		    (string-equal (send (send filename :new-version :unspecific) :string-for-printing)
				  (send (send (car (second tail)) ;;the next filename after the present
					      :new-version :unspecific)
					:string-for-printing))) ;;There is a later version, don't copy.
	       )
	      (t (let* ((dest-file (send destination :new-pathname :name (send filename :name)
				      :type (send filename :type)
				      :version :newest))
			(result (errset
				  (if (or (not query-p)
					  (y-or-n-p "~&Copy ~s?" (send filename :string-for-printing)) )
				      (MULTIPLE-VALUE-LIST
					(COPY-FILE filename dest-file :ERROR NIL))
				    "No copy desired")
				 nil))
			(car-result (and (listp result)(car result)));;because errset puts result in a list.
			(outcome (and (listp car-result)
				      (if (listp (THIRD CAR-RESULT))
					  (first (THIRD CAR-RESULT))
					(THIRD CAR-RESULT)))) )
		   (COND ((or (ERRORP outcome) (not (listp result)))
			  (FORMAT QUERY-IO "~&Not copied: ~A~%" (or OUTCOME "Unknown error"))
			  NIL)
			 ((string-equal (format nil "~a" car-result) "No copy desired"))
			 (T (format t "~&~vx Copied ~a~%~vx~5xto ~a~%" level filename level dest-file)) )
		   )) )))))

(DEFUN COPY-DIRECTORY-ALL (pathname) "Copy a directory and all its subdirectories and theirs.  Exclusions may be made
   by puting them in the global variable *copy-directory-exclusions*.  Use this command from DIRED A."
  (declare (special *copy-directory-exclusions*))
  (LET* ((directory (send pathname :pathname-as-directory-wild))
	 (default (or *dired-last-copied-pathname* (fs:default-pathname (pathname-defaults))))
	 (NEW-directory (read-directory-name (FORMAT NIL "Pathname to copy ~A to" directory)
					     default)) )
    (if (string-equal (send pathname :type) "Directory")
	(COPY-DIRECTORY-ALL-internal directory
				     new-directory
				     (y-or-n-p "Newest versions only?")
				     0
				     (if (variable-boundp *copy-directory-exclusions*) *copy-directory-exclusions*)
				     (y-or-n-p "Do you wish to be to be asked about each file individually?") )
      (COPY-DIRECTORY-ALL-GETS-A-FILE pathname NEW-directory) )))

(defun COPY-DIRECTORY-ALL-GETS-A-FILE (filename destination)
  (let* ((dest-file (send destination :new-pathname :name (send filename :name)
		       :type (send filename :type)
		       :version :newest))
	 (result (errset
		   (MULTIPLE-VALUE-LIST
			 (COPY-FILE filename dest-file :ERROR NIL)))
		   nil)
	 (car-result (and (listp result)(car result)));;because errset puts result in a list.
	 (outcome (and (listp car-result)
		       (if (listp (THIRD CAR-RESULT))
			   (first (THIRD CAR-RESULT))
			   (THIRD CAR-RESULT)))) )
    (COND ((or (ERRORP outcome) (not (listp result)))
	   (FORMAT QUERY-IO "~&Not copied: ~A~%" (or OUTCOME "Unknown error"))
	   NIL)
	  (T (format t "~&~vx Copied ~a~%~vx~5xto ~a~%" 1 filename 1 dest-file)) )
    ))

fs:
(DEFMETHOD (PATHNAME :PATHNAME-AS-DIRECTORY-wild) ()
  (FUNCALL-SELF ':NEW-PATHNAME
		':RAW-DIRECTORY (IF (EQ DIRECTORY ':ROOT)
				    NAME
				  (APPEND (IF (LISTP DIRECTORY) DIRECTORY
					    (NCONS DIRECTORY))
					  (NCONS NAME)))
		':NAME ':WILD ':TYPE ':WILD ':VERSION ':WILD))


(defun obliterate (pathname)
  "To obliterate directories with the Dired A command."
  (let ((*blocks-freed* 0.))
    (obliterate-directory-internal (send pathname :pathname-as-directory-wild) 0)
    (format query-io "~d Blocks Freed." *blocks-freed*) )
  )

(DEFCOM obliterate-DIRECTORY "Copy the file on this line" ()
  (declare (special *copy-directory-exclusions*))
  (setq *blocks-freed* 0.)
  (LET* ((pathname (read-directory-name (format nil "Directory to obliterate:")
					(fs:default-pathname (pathname-defaults)))) )
    (obliterate-directory-internal pathname 0) )
  (format query-io "~d Blocks Freed." *blocks-freed*)
  dis-none)

(defun obliterate-directory-internal (pathname &optional (level 0) (query nil))
  "Deletes and expunges directory, its subdirectories, and their contents."
  (format t "~vxStarting directory ~a~%" level pathname)
  (if (or (null query) (y-or-n-p "Delete its files?"))
      (let ((info (car (errset (FS:DIRECTORY-LIST PATHNAME :SORTED) nil))))
	(do* ((tail info (cdr tail)))
	     ((null tail))
	  (let* ((file-info-list (car tail))
		 (filename (car file-info-list)))
	    (cond ((null filename))
		  ((string-equal "DIRECTORY" (string-upcase (send filename :type)))
		   (let ((source-dir (send filename :pathname-as-directory-wild)))
		     (obliterate-directory-internal source-dir (1+ level) query)
		     (send filename :delete)
		     (let ((result (send filename :expunge)))
		       (cond ((errorp result)
			      (FORMAT QUERY-IO "~&Not deleted: ~A~%" result))
			     (T
			      (and (numberp result) (incf *blocks-freed* result))
			      (format t "~&~vx Deleted ~a~%" level source-dir) )))
		     (format t "~%") ))
		  (t (let ((result (or (send filename :send-if-handles :delete-and-expunge)
				       (let ((r (send filename :delete)))
					 (if (errorp r) r nil))
				       (send filename :expunge))))
		       (COND ((ERRORP result)
			      (FORMAT QUERY-IO "~&Not deleted: ~A~%" result)
			      NIL)
			     (T
			      (and (numberp result) (incf *blocks-freed* result))
			      (format t "~&~vx Deleted ~a~%" level filename) ))))) )))))

;; **********************************************************************
;;a patch
;; **********************************************************************
FS:
(DEFUN GET-CHARACTERS-AND-BYTE-SIZE-FROM-PLIST (INPUT-PLIST &AUX TRUE-CHARACTERS TRUE-BYTE-SIZE)
  ;; Get character and byte-size from plist
  (setq input-plist (cdr input-plist));;addition by garr lystad 6-3-86 because lead entry is unmatched.
  (LET ((CHRLOC (LOCF (GET (LOCF INPUT-PLIST) :CHARACTERS))))
    (AND CHRLOC (SETQ TRUE-CHARACTERS (CDR CHRLOC))))
  
  ;; Take :DIRECTORY-LIST information with a grain of salt...
  ;; Note that we are assuming here that the files are used for LISPMs...
  (LET ((POSSIBLE-BYTE-SIZE (GET (LOCF INPUT-PLIST) :BYTE-SIZE)))
    (AND POSSIBLE-BYTE-SIZE
	 (COND ((EQ POSSIBLE-BYTE-SIZE 7.)
		(SETQ TRUE-BYTE-SIZE 8.))
	       ((NEQ POSSIBLE-BYTE-SIZE 36.)
		(SETQ TRUE-BYTE-SIZE POSSIBLE-BYTE-SIZE)))))
  (VALUES TRUE-CHARACTERS TRUE-BYTE-SIZE))