;-*- Mode:Common-Lisp; Package:ZWEI; Patch-file:T; Base:10; Fonts:(MEDFNT HL12B MEDFNB) -*-

;1; Written by Rick Saenz 1983*
;1; Modified by LaMott Oren 9/85 to put commands on *command-alist* so apropos can find them.*

;1; *The zwei:bind-key function has been modified so keyboard macros
;1; *defined with it can be found with the help apropos utility.

;1; *For those of you who are unfamiliar with zwei:bind-key, its used
;1; *to define keyboard macros in your login-init file.

;1; *Some examples:
;1; *(bind-key #/h-l '(#/m-x "list definitions" #/return #/return)
;1; *  "List the definitions in this buffer")
;1; *(bind-key #/h-s 'com-kill-or-save-buffers)

;1; *The following by Raj Wall demonstrates the power of keyboard macros:
;1; *(bind-key #/h-t '(#/c-m-a       ;move to beginning of function
;1; *                  #/c-shift-e   ;Evaluate function incase it was compiled
;1; *                  #/c-f         ;skip paren
;1; *                  #/c-m-f       ;move to next sexp -hopefully func name
;1; *                  #/c-f         ;skip space
;1; *                  #/c-m-@       ;mark the function name
;1; *                  #/m-w         ;save it on the kill ring
;1; *                  #/m-x "TRACE" #/cr ;enter trace
;1; *                  #/c-y #/cr    ;enter function name
;1; *                  #/c-m-space   ;put point back where it was
;1; *                 ) "Trace this function")


(DEFUN bind-key (keys command &optional name)
  "2Binds a keystroke sequence to COMMAND in *STANDARD-COMTAB*.
 KEYS may be a character (e.g. #\hyper-meta-z) or a list of a
      prefix-character and the command character
      (e.g. (#\control-x #\hyper-meta-z)).
 COMMAND may be a string or a list of characters and strings, or
      a symbol.  If a symbol, its the command name
      (e.g. zwei:com-kill-or-save-buffers).
 NAME is a string or symbol used as the name of the macro.
      Its not used when COMMAND is a symbol.*"
  (LET ((comtab zwei:*standard-comtab*))
    (COND ((OR (LISTP command) (STRINGP command))
	   (UNLESS name
	     (IF (STRINGP command)
		 (SETQ name (FORMAT nil "Macro ~a" command))
	       (SETQ name (FORMAT nil "Macro~{ ~:c~}" command))))
	   (bind-macro-expansion-to-keystrokes
	     comtab
	     (IF (ATOM command) (LIST command) command)
	     (IF (ATOM keys)       (LIST keys)    keys)
	     (string name)))
	  (t (hacked-install-command-internal comtab
					      command
					      (if (LISTP keys)
						  keys
						(LIST keys)))))))
  
(defun bind-macro-expansion-to-keystrokes (comtab expansion key-or-key-list
				 macro-name &aux command)
  (setq command
	(make-macro-command (define-keyboard-macro-1 macro-name 1 expansion)))
  (UNLESS (ASSOC macro-name *command-alist* :test 'EQUALP)
    (PUSH (CONS macro-name command) *command-alist*)) ;1 Do this so command apropos can work*
  (hacked-install-command-internal comtab command key-or-key-list t))

(DEFUN hacked-INSTALL-COMMAND-INTERNAL (comtab COMMAND key-list
					&OPTIONAL REMEMBER-OLD-P)

  "A hacked version of INSTALL-COMMAND-INTERNAL from ZWEI;COMG.LISP.
   Changes made simply eliminate the minibuffer interactions used
   to install a command on a key."

      (DO ((keys key-list (cdr keys))
	    key)
	   ((null key-list))
	(setq key (car key-list))
	(LET ((OLD-COMMAND (COMMAND-LOOKUP KEY COMTAB)))
	  (COND ((AND (PREFIX-COMMAND-P OLD-COMMAND)
		      (NOT (null (cdr key-list))))
		 (SETQ COMTAB (SYMEVAL-IN-CLOSURE OLD-COMMAND 'COMTAB)))
		(T (AND REMEMBER-OLD-P
			(SET-MOUSE-MACRO-COMMAND-LAST-COMMAND
			  COMMAND
			  (COMMAND-LOOKUP KEY COMTAB)))
		   (COMMAND-STORE COMMAND KEY COMTAB)
		   (RETURN NIL))))))
