; -*- Mode:Common-Lisp; Package:USER; Base:10 -*-

;For computing and displaying calendars for any month after 12/31/1899.

;Converted from Zetalisp to Commonlisp 12/29/86 -- lgo.
;Converted from RUCI-LISP to Zetalisp 1/3/84 -- bef.

;To display a calendar for 1984 do (CALENDAR 1984), (CALENDAR) defaults to current year.


(defun DATE ()
  (multiple-value-bind (nil nil nil day month year)
      (time:get-time)
    (list month day year)))

;Not sure this is sufficient, but it's close:
(DEFMACRO MSG (&rest args)
  `(PROGN 
     ,@(loop for item in args collect
	     (cond
	       ((numberp item)
		(cond ((zerop item) '(terpri))
		      ((> item 0) `(format t "~V@t" ,item))
		      (t `(format t "~V%" ,item))))
	       ((consp item)
		(if (eq t (first item))
		    `(format t "~VT" ',(second item))
		  `(format t "~A" ,item)))
	       (t `(format t "~A" ,item))))))

(DEFPARAMETER N-DAYS-IN-MO (VECTOR 0 31 28 31 30 31 30 31 31 30 31 30 31))

(defun N-DAYS-IN-MO (index) (aref N-days-in-mo index))

(DEfun N-DAYS-IN-MO-YR (MO YR)
 (+ (N-DAYS-IN-MO MO)
    (IF (AND (= MO 2) (= 0 (REMAINDER YR 4))) 1 0)))

;Function DAY-OF-THE-WEEK relies on the fact that 12/31/1899 was a
;Saturday, and returns Sunday=1, Monday=2, ..., Saturday=7.
;The argument DATE=(MO DA YR) where YR=xx in 19xx.

(DEfun DAY-OF-THE-WEEK (DATE)
 (PROG (DAY MONTH YEAR N-DAYS)
   (SETQ DAY (CADR DATE)
         MONTH (CAR DATE)
         YEAR (+ 1900 (CADDR DATE))
         N-DAYS 0)
   (loop FOR YR from 1900 TO YEAR DO
    (IF (< YR YEAR)
        (INCF N-DAYS (IF (= 0 (REMAINDER YR 4)) 366 365))
     (loop FOR MO from 1 TO MONTH DO
      (INCF N-DAYS (IF (< MO MONTH) (N-DAYS-IN-MO-YR MO YR) DAY)))))
   (RETURN
    (IF (= 0 (REMAINDER N-DAYS 7)) 7 (REMAINDER N-DAYS 7)))))

(DEfun FILL-MONTH (MOARRAY MO YR)   ;fill MOARRAY w/ dates of that month
 (LET (DAY1 DAY)
   (SETQ DAY1 (DAY-OF-THE-WEEK (LIST MO 1 YR)))
   (loop FOR I from 1 TO (1- DAY1) BY 1 DO
	 (SETF (AREF moarray i) 0))
   (SETQ DAY 0)
   (loop FOR I from DAY1 TO (+ -1 DAY1 (N-DAYS-IN-MO-YR MO YR)) BY 1 DO
         (INCF DAY)
	 (SETF (AREF moarray i) day))
   (loop FOR I from (+ DAY1 (N-DAYS-IN-MO-YR MO YR)) TO 42 BY 1 DO
         (SETF (AREF moarray i) 0))))

(DEfun MONTH-SUCC (MOYR)
 (IF (= (CAR MOYR) 12)
     (LIST 1 (1+ (CADR MOYR)))
     (LIST (1+ (CAR MOYR)) (CADR MOYR))))

(DEfun MONTH-PRED (MOYR)
 (IF (= (CAR MOYR) 1)
     (LIST 12 (1- (CADR MOYR)))
     (LIST (1- (CAR MOYR)) (CADR MOYR))))

;(DCAL [MO [YR [N+-]]]) Displays calendars for three months, including
;the mo/yr specified (current mo/yr are defaults) and the preceeding 2
;months (if N+- < 0) or the following 2 months (if N+- > 0); if N+- = 0
;then the preceeding and following months are displayed; default: N+- > 0.

(Defun DCAL (&rest ARGS)
 (PROG (MO YR N+-)
   (IF (NULL ARGS)
    (SETQ MO (CAR (DATE))
	  YR (- (CADDR (DATE)) 1900)
	  N+- 1)
    (SETQ MO (CAR ARGS))
         (IF (NULL (CDR ARGS))
	  (SETQ YR (CADDR (DATE)) N+- 1)
	  (SETQ YR (CADR ARGS))
	       (IF (NULL (CDDR ARGS))
		(SETQ N+- 1)
		(SETQ N+- (CADDR ARGS)))))
   (COND ((= N+- 0) (DMONTHS (MONTH-PRED (LIST MO YR))
			     (LIST MO YR)
			     (MONTH-SUCC (LIST MO YR))))
	 ((< N+- 0) (DMONTHS (MONTH-PRED (MONTH-PRED (LIST MO YR)))
			     (MONTH-PRED (LIST MO YR))
			     (LIST MO YR)))
	 (T         (DMONTHS (LIST MO YR)
			     (MONTH-SUCC (LIST MO YR))
			     (MONTH-SUCC (MONTH-SUCC (LIST MO YR))))))))

(DEfun DMONTHS (MOYR1 MOYR2 MOYR3)
 (LET ((DNAME)
       (moarray (MAKE-ARRAY 43)))
   (MSG 0 (MONTH-NAME (CAR MOYR1)) (T 16) (+ 1900 (CADR MOYR1))
        3 (MONTH-NAME (CAR MOYR2)) (T 39) (+ 1900 (CADR MOYR2))
	3 (MONTH-NAME (CAR MOYR3)) (T 62) (+ 1900 (CADR MOYR3)))
   (MSG 0 "====================   ====================   ====================")
   (MSG 0 "S  M  T  W  R  F  S    S  M  T  W  R  F  S    S  M  T  W  R  F  S")
   (MSG 0 "-- -- -- -- -- -- --   -- -- -- -- -- -- --   -- -- -- -- -- -- --")
   (loop FOR L from 0 TO 5 do
    (TERPRI)
    (APPLY 'fill-month moarray moyr1)
    (loop FOR D from 1 TO 7 do
     (IF (= 0 (SETQ DNAME (AREF MOARRAY (+ D (* 7 L)))))
      (MSG "   ")
      (IF (< DNAME 10) (MSG " "))
           (MSG DNAME " ")))
    (MSG "  ")
    (APPLY 'fill-month moarray moyr2)
    (loop FOR D from 1 TO 7 do
     (IF (= 0 (SETQ DNAME (AREF MOARRAY (+ D (* 7 L)))))
      (MSG "   ")
      (IF (< DNAME 10) (MSG " "))
           (MSG DNAME " ")))
    (MSG "  ")
    (APPLY 'fill-month moarray moyr3)
    (loop FOR D from 1 TO 7 do
     (IF (= 0 (SETQ DNAME (AREF MOARRAY (+ D (* 7 L)))))
      (MSG "   ")
      (IF (< DNAME 10) (MSG " "))
           (MSG DNAME " "))))
   (TERPRI)))

(DEfun MONTH-NAME (MO)
  (AREF #(nil January Feburary March April May June July August September October November December) MO))

;(CAL [MO [YR]]) displays a six month calendar starting w/ MO,YR
;defaulting to current MO,YR.

(Defun CAL (&rest ARGS)
  (LET (MO YR)
    (IF (NULL ARGS)
	(SETQ MO (FIRST (DATE))
	      YR (THIRD (DATE)))
      (SETQ MO (FIRST ARGS))
      (SETQ YR (IF (CDR ARGS) (SECOND ARGS) (THIRD (DATE)))))
    (DCAL MO (- YR 1900))
    (SETQ MO (MONTH-SUCC (MONTH-SUCC (MONTH-SUCC (LIST MO YR))))
	  YR (CADR MO)
	  MO (CAR MO))
    (TERPRI)
    (DCAL MO (- YR 1900))))

(defun CALENDAR (&optional year &aux yr)
  (if (null year)
      (MULTIPLE-VALUE-SETQ (nil nil nil nil nil yr) (time:get-time))
      (setf yr year))
  (cal 1 yr)
  (cal 7 yr))
