;;; -*- Mode:Common-Lisp; Package:ZWEI; Base:10; Fonts:(CPTFONT CPTFONTB); Patch-file:T -*-

;1;***********************************************************************
;1;*
;1;  THIS IS THE GARBLE CODE.  Nov. 1986*
;1;*
;1;  Written by Garr Lystad.  Adapted from the T.I. Pascal program of the *
;1;                           same name for the T.I. 990 by Garr Lystad.*
;1;*
;1;  This provide functions to effectively gargle the contents of a character*
;1;  file such that it is next to impossible for anyone to ungarble it *
;1;  without knowing the key it was originally garbled under.  Before garbling*
;1;  or ungarbling, you are prompted for a string to be used to encode/decode*
;1;  a unique garble pattern*
;1;*
;1;  M-X GARBLE BUFFER   Garbles the current buffer and puts the ungarbled buffer on kill ring (C-Y).*
;1;*
;1;  M-X UNGARBLE BUFFER Ungarbles a garbled buffer and puts the garbled buffer on kill ring (C-Y).*
;1;*
;1;  M-X GARBLE FILE     Garbles a specifed file, creating a new version of the file.*
;1;                      With a numeric arg, it overwrites the file in garbled form, and*
;1;                      leaves a copy of the ungarbled file in a ZMACS buffer.*
;1;*
;1;  M-X UNGARBLE FILE   Reverse of M-X GARBLE FILE.*
;1;                      Advertised Editor Commands (Meta-x)*
;1;*
;1;  M-X GARBLE BYTE SIZE - Indicates number of bits available for character codes.  This can be 7 (default) *
;1;                         or 8.  A numeric arg of 7 or 8 will set the garble byte size to that value.  Using*
;1;                         7 bits (chars 0-127) is adequate and allows you to write this file to all hosts.  *
;1;                         Using 8 bits (chars 0-255) gives a more random garbled file including *
;1;                            lozenged characters*
;1;                         but may not be able to be written to some hosts.*
;1;*
;1;  M-X TOGGLE KEY VISIBILITY - Determines whether you see X's or the letters you type when*
;1;                              entering the garble key.*
;1;*
;1;  zwei:*line-length*  - the number of garbled characters per line when writing garbled file (defaults to 72).*
;1;*
;1;***********************************************************************


(defvar *gla-length* 64)
(defvar *garble-large-array* (make-array *gla-length*))
(defvar *mod-64-seed* 1 "This is the mod random number generator seed.")
(defvar *line-length* 72 "The length of the output line.")
(defvar *short-random-state* 0 "The small random number state")
(defvar *short-count* 100 "Use count for *short-random-state*" )
(defvar *change-time* 0 "How many times to use the short random number generator")
(defvar *seven-bits* t "Garbled output should be in 7, rather than 8 bits.")

;1;***********************************************************************
;1; Random number stuff *
;1;***********************************************************************



(defun shiftr (number)
  (setq number (+ number (ldb #o1721 number))
	number (ldb #o0040 (dpb number #o2117 number)) ))

(defun mod-64 ()
  "This refreshes its state and returns an number between 0 and 63."
  (ldb #o1206 (setq *mod-64-seed* (ldb #o0020 (* (1+ *mod-64-seed*) 69069)))) )

(defun lrand ()
  "returns a large random number from the big generator."
  (let ((idx (mod-64)))
;1    (prog1*
    (setf (aref *garble-large-array* idx) (shiftr (aref *garble-large-array* idx)))
;1    (format t "large  idx=~d  val = ~d  " idx (aref *garble-large-array* idx)); )*
    ))

(defun srand ()
  "Return a short random number."
  (if (> *short-count* *change-time*)
      (setq *change-time* (ldb #o0003 (lrand))
	    *short-random-state* (ldb #o0020 (lrand))
	    *short-count* 1)
    (incf *short-count*) )
;1  (format t " -srand ~d- " *short-random-state*)*
;1  (format t "~%*change-time* ~d srand = ~d *short-count* = ~d~%" *change-time* *short-random-state* *short-count*)*
  (setq *short-random-state* (ldb #o0020 (+ (* 25173 *short-random-state*) 13849))) )

;1;***********************************************************************
;1;  Initialization stuff*
;1;***********************************************************************
(defvar *garble-key-visibility* t "Controls echo visibility of the key for garble or ungarble")

(defcom com-toggle-garble-key-visibility "Toggles how garble keys are echoed." (km)
  (setq *garble-key-visibility* (not *garble-key-visibility* ))
  (send zwei:*mode-line-window* :home-cursor)
  (send zwei:*mode-line-window* :clear-screen)
  (format *query-io* "~&~:[Now echo Xs~;Now echo key~]" *garble-key-visibility*)
  dis-none)

(defun single-key-string-read (prompt visiblep)
  (if visiblep
      (MULTIPLE-VALUE-bind (NIL NIL INTERVAL)
	  (EDIT-IN-MINI-BUFFER *MINI-BUFFER-MULTI-LINE-COMTAB* nil 0
			       `(,prompt))
	(STRING-INTERVAL INTERVAL nil :in-order :remove-fonts) )
    (let ((string (make-array 80 :element-type 'string-char :fill-pointer 0)) ch)
      (send zwei:*mode-line-window* :home-cursor) 
      (send zwei:*mode-line-window* :clear-screen)
      (format zwei:*mode-line-window* "~a:~&" prompt) 
      (loop do (setq ch (send
			  *terminal-io* :tyi))
	    until (char-equal ch #\end)
	    do (if (char-equal ch #\rubout)
		   (progn
		     (setf (fill-pointer string) (max 0 (1- (fill-pointer string))))
		     (send zwei:*mode-line-window* :set-cursorpos
			   (max 0 (- (send zwei:*mode-line-window* :cursor-x)
				     (send zwei:*mode-line-window* :char-width)
				     (send zwei:*mode-line-window* :left-margin-size)) )
			   (- (send zwei:*mode-line-window* :cursor-y)
			      (send zwei:*mode-line-window* :top-margin-size)) )
		     (send zwei:*mode-line-window* :clear-eol) )
		   (vector-push-extend ch string)
		   (format zwei:*mode-line-window* "X")))
      string)))

(defun read-key ()
  (let (key-string-1 key-string-2)
    (unwind-protect
	(progn
	  (send zwei:*mode-line-window* :select)
	  (setq key-STRING-1 (single-key-string-read "Enter key phrase. (end with End)" *garble-key-visibility*)
		key-STRING-2 (single-key-string-read "Enter key phrase again please, just to make sure. (end with End)"
						     *garble-key-visibility*)))
      (send zwei:*window* :select))
    (if (string-equal key-string-1 key-string-2)
	      key-string-1
	      (progn
		(format t "~%~%*** Sorry, your key phrases don't match. ***~%~%")
		(THROW :garble-out nil) ))))

(defun get-key ()
  (let (key-string copy-times)
    (setq key-STRING (read-key)
	  copy-times (ceiling (* *gla-length* 4) (length (the string key-string))))
    (apply #'string-append (make-list copy-times :initial-element (the string key-string))) ))

(defun fill-array-from-key (key)
  "Key is a string, array is an array.  Values in the range 0 (1- (expt 2 32)) are put in the array using the key."
  (do ((string-index 0 (incf string-index 4))
       (array-index 0 (incf array-index))
       (count 0 (incf count)) )
      ((>= array-index *gla-length*))
    (setq *mod-64-seed* (shiftr (length key)))
    (setf (aref *garble-large-array* array-index) (dpb (char-code (aref key string-index)) #o0725
					(dpb (char-code (aref key (1+ string-index))) #o0716
					     (dpb (char-code (aref key (+ 2 string-index))) #o0707
						  (char-code (ldb #o0010 (+ count (aref key (+ 3 string-index))))) ))))))

(defun init-all ()
  (setq *short-random-state* 0 
        *short-count* 100
	*change-time* 0)
  (fill-array-from-key (get-key))
  (dotimes (i 100) (lrand)) )

;1;***********************************************************************
;1;  The encryption code*
;1;***********************************************************************

(defvar *CR* #\newline)

(defun set-char-size-option (sevenp)
  (if (numberp sevenp)(setq sevenp (if (= sevenp 7) t nil)))
  (if sevenp
      (progn
	(fdefine 'char-out-g
		 #'(named-lambda char-out-g (new old)
				 (code-char (ldb #o0007 (+ (char-code new) (srand) (char-code old)))) ))
	(fdefine 'char-out-ug
		 #'(named-lambda char-out-ug (new old)
				 (code-char (ldb #o0007 (- (char-code new)
							   (+ (srand) (char-code old)) ))) ))
	(setq *CR* (code-char (ldb #o0007 (char-code #\newline))) *seven-bits* t))
    (progn
      (fdefine 'char-out-g
	       #'(named-lambda char-out-g (new old)
			       (code-char (ldb #o0010 (+ (char-code new) (srand) (char-code old)))) ))
      (fdefine 'char-out-ug
	       #'(named-lambda char-out-ug (new old)
			       (code-char (ldb #o0010 (- (char-code new)
							 (+ (srand) (char-code old)) ))) ))
      (setq *CR* #\newline *seven-bits* nil) ))
;  (compile 'char-out-g)
;  (compile 'char-out-ug)
  )



(set-char-size-option *seven-bits*)

(defcom COM-GARBLE-BYTE-SIZE
	"Displays the current garble output byte size.  Args of 7 or 8 set size."
        (km)
  (if *numeric-arg-p*
      (case *numeric-arg*
	    (7 (set-char-size-option t))
	    (8 (set-char-size-option nil))
	    (otherwise (format t "~&Garble Byte Size takes only arguments of 7 and 8.~%")) ))
  (format t "~&Garble byte size is ~d.~%" (if  *seven-bits* 7 8))
  dis-none)

;1;*************************************************************************

(defun garble-body (in-s out-s)
  "This actually does the garble operation, given the streams."
  (init-all)
  (send out-s :tyo (code-char 0))
  (send out-s :tyo (code-char (if *seven-bits* 7 8))) 
  (send out-s :tyo (code-char *line-length*))
  (send out-s :tyo (code-char 0))
  (send out-s :tyo #\return)
  (Format *query-io* "Lines out: ")
  
  (do ((old-char (ldb #o0804 (aref *garble-large-array* 0)) char)
       (char (send in-s :tyi) (send in-s :tyi))
       (count 0 (if (>= count *line-length*);1;count = number of chars written out.*
		    (progn
		      (send out-s :tyo #\return)
		      (format *query-io* ".")
		      0)
		  (incf count))) )
      ((null char))
    (send out-s :tyo (char-out-g char old-char)) ))

(defun garble-body-buffer (in-s out-s) 
  "This actually does the garble operation, given the streams."
  (init-all)
  (send out-s :tyo (code-char 0))
  (send out-s :tyo (code-char (if *seven-bits* 7 8))) 
  (send out-s :tyo (code-char *line-length*))
  (send out-s :tyo (code-char 0))
  (send out-s :tyo #\return)
  (Format *query-io* "Lines out: ")
  (do ((string-output-buffer (make-array (+ 1 *line-length*) :element-type 'string-char :fill-pointer 0))
       (old-char (ldb #o0804 (aref *garble-large-array* 0)) char)
       (char (send in-s :tyi) (send in-s :tyi))
       garb-char
       (count 0 (if (>= count *line-length*);1;count = number of chars written out.*
		    (progn
		      (send out-s :line-out string-output-buffer)
		      (store-array-leader 0 string-output-buffer 0)
		      (format *query-io* ".")
		      0)
		  (incf count))) )
      ((null char)
       (if (/= (char-code garb-char)(char-code #\return))
	   (dotimes (i (length string-output-buffer))
	     (send out-s :tyo (aref string-output-buffer i)) ) ))
    (setq garb-char (char-out-g char old-char))
    (if (/= (char-code garb-char) (char-code #\return))
	(vector-push-extend garb-char string-output-buffer)
      (send out-s :line-out string-output-buffer)
      (store-array-leader 0 string-output-buffer 0) )))

(defun ungarble-body (in-s out-s)
  "This is the inverse operation of garr-bull-body, given the same key.  The parms are the in and out streams."
  (init-all)
  (or (char-equal (code-char 0)(send in-s :tyi)) (ferror "not a garbled file."))
  (set-char-size-option (send in-s :tyi))
  (setq *line-length* (char-code (send in-s :tyi)))
  (or (char-equal (code-char 0)(send in-s :tyi))(ferror "not a garbled file."))
  (send in-s :tyi) ;1;the return*
  (Format *query-io* "Lines in: ")
  
  (do ((old-char (ldb #o0804 (aref *garble-large-array* 0)))
       (count 0 (if (>= count *line-length*);1;char count = one less than characters input*
		    (progn
		      (or (char-equal (send in-s :tyi) #\return)
			  (ferror "End of line not found where expected."))
		      (format *query-io* ".")
		      0)
		  (incf count)))
       (char (send in-s :tyi) (send in-s :tyi)) )
      ((null char))
    (setq old-char (char-out-ug char old-char))
    (send out-s :tyo (if (and *seven-bits*
				     (member (char-code old-char) '(9 12 13)) )	;1 for tab,page,& return*
				(code-char (+ (char-code old-char) 128.))
				old-char))))


(defun ungarble-body-buffer (in-s out-s &aux +line-length+)
  "This is the inverse operation of garr-bull-body, given the same key.  The parms are the in and out streams."
  (init-all)
  (or (char-equal (code-char 0)(send in-s :tyi)) (ferror "not a garbled file."))
  (set-char-size-option (send in-s :tyi))
  (setq +line-length+ (1+ (setq *line-length* (char-code (send in-s :tyi)))));1;the code is goofy, 1 short, sorry.*
  (or (char-equal (code-char 0)(send in-s :tyi))(ferror "not a garbled file."))
  (send in-s :tyi) ;1;the return*
  (Format *query-io* "Lines in: ")

  (let (line-in eofflg
	(string-output-buffer (make-array 500 :element-type 'fat-char :fill-pointer 0))
	(old-char (ldb #o0804 (aref *garble-large-array* 0)))
	(output-index 0)     (chars-out 0))
    (loop do (multiple-value-SETQ (line-in eofflg)(FUNCALL in-S ':LINE-IN +line-length+))
	  with font = 0
	  with font-ch-flag = nil
	  do (if (/= (length line-in) +line-length+)
		 (progn ;1;TAKE CARE OF EXTRANIOUS #\RETURN CHARACTERS*
		   (setq chars-out (+ chars-out (length line-in)))
		   (if (or (= chars-out +line-length+) eofflg)
		       (setq chars-out 0)
		     (vector-push-extend #\return line-in)  ;1;array-push would be sufficient if it worked. gsl 3-25-87*
		     (incf chars-out) )))
	  do (format *query-io* ".")
	  do (dotimes (index (min +line-length+ (length line-in)))
	       (setq old-char (char-out-ug (aref line-in index) old-char))
	       (cond (font-ch-flag
		      (setq font-ch-flag nil)
		      (if (= (char-code old-char) (char-code #\*))
			    (setq font 0)
			  (setq font (- (char-code old-char) (char-code #\0))) ))
		     ((and *seven-bits*
			   (member (char-code old-char) '(9 12 13))
			   (setq old-char (int-char (+ (char-code old-char) 128.)))
			   nil)) ;1;kludgy, I'll admit, but does a character switch for tab, page, and return*
;		1     ((format t "~c" old-char)) ;;DEBUG *
		     ((= (char-code old-char) (char-code #\return))
		      (store-array-leader output-index string-output-buffer 0)
		      (send out-s :line-out string-output-buffer)
		      (setq output-index 0) )
		     ((= (char-code old-char) (char-code #\epsilon))
		      (setq font-ch-flag t) )
		     (t
		      (setf (aref string-output-buffer output-index)
			    (if (zerop font) old-char (in-current-font old-char font)) )
		      (incf output-index) )))
	  until eofflg
	  finally (if (/= (char-code old-char) (char-code *cr*))
		      (progn
			(store-array-leader output-index string-output-buffer 0)
			(send out-s :string-out string-output-buffer) ))
	  )))



;1;***********************************************************************
;1;  Garble for pathnames*
;1;***********************************************************************

(defmacro with-any-open-file ((stream filename . options) &body body)
  `(cond ((or (pathnamep ,filename) (stringp ,filename))
	  (with-open-file (,stream ,filename ,@options) ,@body))
	 ((typep ,filename 'zwei:interval-stream)
	  (let ((,stream ,filename))
	    ,@body))
	 (t (format t "Error in WITH-ANY-OPEN-FILE: filename was ~s~%" ,filename)) ))

(defun garr-bull (path-in path-out &optional overwrite)
  "This is the top level function for file garbling. The args are strings.
    Overwrite indicates that if the given version of the file exists then overwrite it. "
  (cli:catch :garble-out
    (with-any-open-file (in-s path-in :direction :input :characters t :byte-size 8. :if-does-not-exist :error)
      (with-open-file (out-s path-out :direction :output :characters t :byte-size 8.
			     :if-does-not-exist :create :if-exists (if overwrite :supersede :new-version))
	(garble-body in-s out-s) ))
    (if *numeric-arg-p*
	(format *terminal-io* "~2% ** The ungarbled version of your file has been overwritten. ~
                                       The ungarbled version still exists in a Zmacs buffer!~%")
      (format *terminal-io* "~%~% ** The ungarbled version of your file still exists.  ~
                                       YOU must specifically delete it.~%") )
    ))


(defun un-garr-bull (path-in path-out &optional overwrite)
  "This is the top level function for file garbling. The args are strings.
    Overwrite indicates that if the given version of the file exists then overwrite it."
  (cli:catch :garble-out
    (with-any-open-file (in-s path-in :direction :input :characters t :byte-size 8. :if-does-not-exist :error)
      (with-open-file (out-s path-out :direction :output :characters t :byte-size 8.
			     :if-does-not-exist :create :if-exists (if overwrite :supersede :new-version))
	(ungarble-body in-s out-s) ))
    (if *numeric-arg-p*
	(format *terminal-io* "~2% ** The garbled version of your file has been overwritten. ~
                                        The garbled version still exists in a Zmacs buffer!~%")
      (format *terminal-io* "~2% ** The garbled version of your file still exists. ~
                                     YOU must specifically delete it.~%") )
    ))

(defun garble (pathname &optional overwrite)
  "This is the version usable in dired, where it doesn't overwrite.  It checks to see if this is currently a garbled file.
   This is used in the zmacs command Garble File."
  (let (probably-already-garbled)
    ;1;check to see if it is already garbled.*
    (with-open-file (in-s pathname :direction :input :characters t :byte-size 8. :if-does-not-exist :error)
      (and (char-equal (code-char 0)(send in-s :tyi))
	   (send in-s :tyi)
	   (send in-s :tyi)
	   (char-equal (code-char 0)(send in-s :tyi))
	   (char-equal #\return (send in-s :tyi))
	   (setq probably-already-garbled t) ))

    ;1;Rename existing buffer if it already exists*
    (let* ((buf-name (send pathname :string-for-editor))
	   (existing-buf (cli:assoc buf-name *ZMACS-BUFFER-NAME-ALIST* :test #'string-equal)) )
      (if (and overwrite existing-buf)
	  (rename-buffer (cdr existing-buf) (string-append "OLD-" buf-name))) )

    ;1;if ok do the garble*
    (if (or (null probably-already-garbled)
	    (y-or-n-p "This file appears to already be garbled, proceed anyway?" pathname))
	(garr-bull (if overwrite
		       (let* ((buffer (find-file pathname nil :quietly :load-p :no-sectionize)))
			 (interval-stream (interval-first-bp buffer) (interval-last-bp buffer) t nil))
		     pathname)
		   (if overwrite
		       pathname
		     (send pathname :new-version :newest) )
		   overwrite) )))

(defun ungarble (pathname &optional overwrite)
  "This is the version usable in dired, where it doesn't overwrite.  It checks to see if this is currently a garbled file.
   This is used in the zmacs command Ungarble File."
  (let (probably-already-garbled)
    ;1;check to see if it is already garbled.*
    (with-open-file(in-s pathname :direction :input :characters t :byte-size 8. :if-does-not-exist :error)
      (and (char-equal (code-char 0)(send in-s :tyi))
	   (send in-s :tyi)
	   (send in-s :tyi)
	   (char-equal (code-char 0)(send in-s :tyi))
	   (char-equal #\return (send in-s :tyi))
	   (setq probably-already-garbled t) ))

    ;1;Rename existing buffer if it already exists*
    (let* ((buf-name (send pathname :string-for-editor))
	   (existing-buf (cli:assoc buf-name *ZMACS-BUFFER-NAME-ALIST* :test #'string-equal)) )
      (if existing-buf (rename-buffer (cdr existing-buf) (string-append "OLD-" buf-name))) )

    ;1;if ok do the garble*
    (if (null probably-already-garbled)
	(format t "~%~%*** ~a is not a garbled file. ***  NO action taken.~%~%" pathname)
      (un-garr-bull (if overwrite
			(let* ((buffer (find-file pathname nil :quietly :load-p :no-sectionize)))
			  (interval-stream (interval-first-bp buffer) (interval-last-bp buffer) t nil))
			pathname)
		    (if overwrite
		       pathname
		     (send pathname :new-version :newest) )
		    overwrite) )))


(pushnew '("Garble File" . com-garble-file) (comtab-extended-commands *standard-comtab*))
(pushnew '("Ungarble File" . com-ungarble-file) (comtab-extended-commands *standard-comtab*))
(pushnew '("Garble Buffer" . com-garble-buffer) (comtab-extended-commands *standard-comtab*))
(pushnew '("Ungarble Buffer" . com-ungarble-buffer) (comtab-extended-commands *standard-comtab*))
;1(pushnew '("Method Apropos" . com-method-apropos) (comtab-extended-commands *standard-comtab*))*
(pushnew '("Garble Byte Size" . COM-GARBLE-BYTE-SIZE) (comtab-extended-commands *standard-comtab*))
(pushnew '("Toggle Garble Key Visibility" . com-toggle-garble-key-visibility) (comtab-extended-commands *standard-comtab*))
;1(pop (comtab-extended-commands *standard-comtab*))*

(DEFCOM COM-GARBLE-FILE "provides file encryption  Creates a new version, with arg overwrites old version." ()
  (LET ((PATHNAME (READ-DEFAULTED-PATHNAME "Garble file:" (PATHNAME-DEFAULTS)
					   NIL :newest :READ)))
    (garble PATHNAME *numeric-arg-p*))
  DIS-TEXT)

(DEFCOM COM-UNGARBLE-FILE "provides file encryption  Creates a new version,
 with arg overwrites old version, leaving a few garbled characters at the end (which is messy)." ()
  (LET ((PATHNAME (READ-DEFAULTED-PATHNAME "Ungarble file:" (PATHNAME-DEFAULTS)
					   NIL :newest :READ)))
    (ungarble PATHNAME *numeric-arg-p*))
  DIS-TEXT)



;1;***********************************************************************
;1;  garble buffers.*
;1;***********************************************************************

(DEFCOM COM-GARBLE-BUFFER "Provides buffer encryption.   ." (nm)
  (garr-bull-buffer *interval*)
  DIS-all)

(DEFCOM COM-UNGARBLE-BUFFER "Provides buffer decryption.   ." (nm)
  (ungarr-bull-buffer *interval*)
  DIS-all)

(defun garr-bull-buffer (interval)
  "This is the top level function for file garbling. The args are strings."
  (cli:catch :garble-out
    (let* ((mid-bp (copy-bp (interval-last-bp interval)))
	   (in-s (interval-stream (copy-bp (interval-first-bp interval)) (copy-bp mid-bp) t t))
	   (out-s (interval-stream-into-bp (interval-last-bp interval))) )
      (garble-body-buffer in-s out-s)
      (move-bp (point) (bp-line mid-bp) (bp-index mid-bp))
      (kill-interval (interval-first-bp interval) mid-bp)
      (com-reparse-attribute-list)
      (format *terminal-io* "~%~% ** The ungarbled version of your buffer is in the kill history. (C-y)~%"))))

(defun ungarr-bull-buffer (interval)
  "This is the top level function for file garbling. The args are strings."
  (cli:catch :garble-out
    (let* ((mid-bp (copy-bp (interval-last-bp interval)))
	   (in-s (interval-stream (copy-bp (interval-first-bp interval)) (copy-bp mid-bp) t))
	   (out-s (interval-stream-into-bp (interval-last-bp interval) T)) )
      (ungarble-body-BUFFER in-s out-s)
      (move-bp (point) (bp-line mid-bp) (bp-index mid-bp))
      (kill-interval (interval-first-bp interval) mid-bp)
      (com-reparse-attribute-list)
      (format *terminal-io* "~%~% ** The garbled version of your buffer is in the kill history. (C-y)~%") )))

	  
;1;***********************************************************************
;1; PATCHES*
;1;***********************************************************************

(DEFUN IN-CURRENT-FONT (X &OPTIONAL (FONT *FONT*))
  "Return string or character X, converted to font FONT."
  (COND ((ZEROP FONT)		;1Little efficiency for strings*
	 X)
	((MEMBER X '(#\CR #\TAB) :test 'eql)
	 X)
	((NUMBERP X)
	 (DPB FONT SI:%%CH-FONT X))
	((characterp x);1;*** ADDED BY GSL. 11/4/86*
	 (code-char (char-code x) 0 font))
	(T (LET ((LENGTH (LENGTH X)))
	     (LET ((S (MAKE-ARRAY LENGTH ':element-TYPE 'FAT-char)))
	       (DO ((I 0 (1+ I)))
		   ((>= I LENGTH) S)
		 (setf (aref S I)  (code-char (char-code (aref X I)) 0 font))))))))

;1;************************************************************************ END