;;; -*- Mode:Common-Lisp; Package:USER; Base:8; Fonts:(MEDFNT HL12B HL12I MEDFNB) -*-

;1; Display the QIX demo on the black-screen window*

;1; Modified to not do :tyi-no-hang (i.e. run forever)*
;1; Modified to not use alu-xor, because this leaves garbage on the screen when the screen is cleared*

(defun idle-qix (&optional (length 100) (stream *terminal-io*) (times NIL))
;;; (with-real-time
  (unwind-protect
   (let* ((list (make-list (1+ length)))
	  (history (nthcdr (1- length) list)))
     ;; Make history a circular list.
     (si:%p-store-cdr-code (cdr history) cdr-error)
     (si:%p-store-cdr-code history cdr-normal)
     (rplacd history list)
     (send stream :clear-screen)
     (loop repeat length
	   for h = history then (cdr h)
	   do (setf (car h) (make-list 4)))
     (multiple-value-bind (xlim ylim)
	 (send stream :inside-size)
       (loop with x1 = 0
	     and y1 = (1- ylim)
	     and x2 = 0
	     and y2 = (1- ylim)
	     and dx1 = 5
	     and dy1 = 12
	     and dx2 = 12
	     and dy2 = 5
	     with tem
	     until (or ;(send stream :tyi-no-hang)
		       (if times (= (setf times (1- times)) 0) NIL))
	     when (caar history)
	     do (send stream :draw-line
		      (first (car history))
		      (second (car history))
		      (third (car history))
		      (fourth (car history))
		      tv:alu-andca)
	     do (setf (first (car history)) x1)
	     (setf (second (car history)) y1)
	     (setf (third (car history)) x2)
	     (setf (fourth (car history)) y2)
	     (setf history (cdr history))
	     (send stream :draw-line x1 y1 x2 y2 tv:alu-ior)
	     (setf dx1 (1- (+ dx1 (random 3)))
		   dy1 (1- (+ dy1 (random 3)))
		   dx2 (1- (+ dx2 (random 3)))
		   dy2 (1- (+ dy2 (random 3))))
	     (cond ((> dx1 12) (setf dx1 12))
		   ((< dx1 -12) (setf dx1 -12)))
	     (cond ((> dy1 12) (setf dy1 12))
		   ((< dy1 -12) (setf dy1 -12)))
	     (cond ((> dx2 12) (setf dx2 12))	
		   ((< dx2 -12) (setf dx2 -12)))
	     (cond ((> dy2 12) (setf dy2 12))
		   ((< dy2 -12) (setf dy2 -12)))
	     (cond ((or (>= (setf tem (+ x1 dx1)) xlim)
			(minusp tem))
		    (setf dx1 (- dx1))))
	     (cond ((or (>= (setf tem (+ x2 dx2)) xlim)
			(minusp tem))
		    (setf dx2 (- dx2))))
	     (cond ((or (>= (setf tem (+ y1 dy1)) ylim)
			(minusp tem))
		    (setf dy1 (- dy1))))
	     (cond ((or (>= (setf tem (+ y2 dy2)) ylim)
			(minusp tem))
		    (setf dy2 (- dy2))))
	     (setf x1 (+ x1 dx1)
		     y1 (+ y1 dy1)
		     x2 (+ x2 dx2)
		     y2 (+ y2 dy2))
	  finally (loop repeat length
			when (caar history)
			 do (send stream :draw-line
				  (first (car history))
				  (second (car history))
				  (third (car history))
				  (fourth (car history))
				  tv:alu-xor)
			do (setf history (cdr history))))))
    (send stream :clear-screen)))                                  ; took out the "with-real-time"


;1; This hangs waiting on OUTPUT-HOLD until BLACKOUT-SCREEN-WINDOW is exposed*
(UNLESS (find-process 'idle-qix)
  (PROCESS-RUN-FUNCTION '(:name "IDLE-QIX" :priority -200. :restart-after-boot t :restart-after-reset t)
			'idle-qix 100 tv:blackout-screen-window))

