;; -*- Mode:LISP; Package:TV; Base:8; Patch-file:t -*-

;;; This file contains a new command for the Input Editor (rubout handler),
;;; CTRL-META-C, that is the opposite of META-C, and is meant to be used in
;;; conjunction with CTRL-C and META-C.  It traverses the kill ring in the
;;; opposite direction from META-C.

;;; Also included here is the analogous command for ZMACS, CTRL-META-Y,
;;; which works in conjuction with CTRL-Y and META-Y.

;;; I find these commands useful if I accidentally META-C past the text I wanted
;;; to yank.   Steve Ford  8-7-85

(DEFCOMMAND RH-COM-YANK-PUSH-HISTORY-RING (N)
  '(:NAMES (("Yank Push History Ring" :TYPEIN-NAME? NIL))
    :KEYS  (#\C-M-C #\C-M-Y )
    :DESCRIPTION "Inserts the next later kill ring entry."
    :DOCUMENTATION "This command is valid when preceded directly by either Yank-Input-Ring (CTRL-C),
Yank-Kill-Ring (CTRL-Y), Yank-Pop-History-Ring (META-C or META-Y), or itself.  It erases what was
just yanked and inserts the next later entry in the Zwei kill ring.  Try typing
      (1+ 1)
      (1+ 2)
      (1+ 3)
      CTRL-C   
      META-C
      META-C
      CTRL-META-C
CTRL-C will yank (1+ 3).  META-C will first yank (1+ 2), and then (1+ 1), going backward in time.
CTRL-META-C will then yank (1+ 2), going forward in time.  It is the opposite of META-C.
There is no limit to the number of times you can repeat this command, alone or in combination with META-C."
    :COMMAND-FLAVOR RH-COMMAND)
  (DECLARE (:SELF-FLAVOR TV:STREAM-MIXIN))
  (WHEN (TYPEP *LAST-COMMAND-TYPE* 'ZWEI:HISTORY)
    (AND (NEQ N 0)
	 (RH-YANK-FROM-HISTORY
	   (ZWEI:ROTATE-HISTORY-YANK-POINTER *LAST-COMMAND-TYPE* (MINUS (OR N 1)))
	   T (EQ *LAST-COMMAND-TYPE* (RH-INPUT-RING))))
    (SETQ *CURRENT-COMMAND-TYPE* *LAST-COMMAND-TYPE*))
  T)

(BUILD-COMMAND-TABLE 'RH-COMMAND-TABLE NIL
  '(RH-COM-APROPOS-COMPLETE 
    RH-COM-BACKWARD-CHARACTER 
    RH-COM-BACKWARD-PARENTHESES 
    RH-COM-BACKWARD-WORD 
    RH-COM-BASIC-HELP 
    RH-COM-BEGINNING-OF-BUFFER 
    RH-COM-BEGINNING-OF-LINE 
    RH-COM-CLEAR-INPUT 
    RH-COM-COMPLETE 
    RH-COM-DELETE-CHARACTER 
    RH-COM-DELETE-PARENTHESES 
    RH-COM-DELETE-WORD 
    RH-COM-DISPLAY-INTERNAL-STATE 
    RH-COM-END-OF-BUFFER 
    RH-COM-END-OF-LINE 
    RH-COM-EXCHANGE-WORDS 
    RH-COM-FORWARD-CHARACTER 
    RH-COM-FORWARD-PARENTHESES 
    RH-COM-FORWARD-WORD 
    RH-COM-KILL-LINE 
    RH-COM-KILL-REGION 
    RH-COM-LIST-APROPOS-COMPLETIONS 
    RH-COM-LIST-COMMANDS 
    RH-COM-LIST-COMPLETIONS 
    RH-COM-LIST-INPUT-RING 
    RH-COM-LIST-KILL-RING 
    RH-COM-LIST-SPELLING-COMPLETIONS 
    RH-COM-MARK-BEGINNING 
    RH-COM-MARK-END 
    RH-COM-MENU-POP-UP-INPUT-RING 
    RH-COM-MENU-POP-UP-KILL-RING 
    RH-COM-MENU-POP-UP-OUTPUT-RING 
    RH-COM-NEXT-LINE 
    RH-COM-OPEN-LINE 
    RH-COM-POSITION-AT-ERROR 
    RH-COM-PREVIOUS-LINE 
    RH-COM-QUOTE-CHARACTER 
    RH-COM-REFRESH-SCREEN 
    RH-COM-RUBOUT-CHARACTER 
    RH-COM-RUBOUT-PARENTHESES 
    RH-COM-RUBOUT-WORD 
    RH-COM-SAVE-REGION 
    RH-COM-SET-MARK 
    RH-COM-SHOW-ARGUMENT-LIST 
    RH-COM-SHOW-DOCUMENTATION 
    RH-COM-SPELLING-COMPLETE 
    RH-COM-TWIDDLE-CHARACTERS 
    RH-COM-YANK-INPUT-RING 
    RH-COM-YANK-KILL-RING 
    RH-COM-YANK-POP-HISTORY-RING
    RH-COM-YANK-PUSH-HISTORY-RING)
  ':INIT-OPTIONS '(:NAME "Input Editor commands"
		   :DOCUMENTATION
  "This command table holds all of the Input Editor commands.  The Input Editor is a set of
available commands to use when typing input to modify the typed expression.
Traditionally computer systems provide a simple Input Editor consisting of the RUBOUT
key to allow you to delete the previously typed character.  Our Input Editor contains
over fifty commands for modifying the input."))

zwei:
(DEFCOM COM-YANK-PUSH "Correct a Yank command to get something newer.
Replaces the last thing you yanked -- the text now in the region --
with another entry from the same history list.
By default, the next later entry is used, so that successive uses of this command
get newer and newer things from the history.
A numeric argument specifies how many entries forward or back to go;
negative means to yank older text.
An argument of zero means kill the yanked text and don't replace it with anything."
	()
  ;; Need not check for MARK-P, by special case.
  (OR (TYPEP *LAST-COMMAND-TYPE* 'HISTORY) (BARF))
  (FUNCALL (HISTORY-YANK-METHOD *LAST-COMMAND-TYPE*)
	   (AND (NOT (ZEROP *NUMERIC-ARG*))
		(ROTATE-HISTORY-YANK-POINTER *LAST-COMMAND-TYPE*
					     (MINUS *NUMERIC-ARG*))))
  (SETQ *CURRENT-COMMAND-TYPE* *LAST-COMMAND-TYPE*)
  DIS-TEXT)

zwei:
(COMMAND-STORE 'COM-YANK-PUSH #\C-M-Y *STANDARD-COMTAB*)
