;;; -*- Mode:Common-Lisp; Package:TV; Fonts:(MEDFNT HL12B HL12BI); Base:10; Patch-file:T -*-
;===============================================================================
;
;   (c) Unpublished Copyright 1985 by Texas Instruments.  All rights reserved.
;
;===============================================================================

;;; Created 10/24/85 08:54:51 by LaMott G. OREN

;1; Add the following new terminal keys:*
;1;  terminal e*	1- Select a background error window*
;1;  terminal meta-s*	1- Select a window from a menu*
;1;  terminal meta-e*	1- Expand the selected window, or with an argument the window you mouse*
;1;  terminal meta-m*	1- Move a window*
;1;  terminal meta-r*	1- Reshape a window*

;1-----------------------------------------------------------------------------*
;1 from window;basstr*

;Select an "interesting" background window.
;1Called from terminal-0-s and terminal-e*
(DEFUN SELECT-INTERESTING-WINDOW (&optional n &AUX INTERESTING NOTIFICATION-WINDOW)
  (COND ((SETQ INTERESTING (FIND-INTERESTING-WINDOW n)) ;1 Modified to pass in N*
	 (SETQ NOTIFICATION-WINDOW (CDR (ASSQ INTERESTING BACKGROUND-INTERESTING-WINDOWS)))
	 (AND NOTIFICATION-WINDOW
	      (EQ (FUNCALL NOTIFICATION-WINDOW ':WINDOW-OF-INTEREST) INTERESTING)
	      (FUNCALL NOTIFICATION-WINDOW ':EXPOSED-P)
	      (FUNCALL NOTIFICATION-WINDOW ':DEEXPOSE))
	 (FUNCALL INTERESTING ':MOUSE-SELECT)
	 (SETQ BACKGROUND-INTERESTING-WINDOWS
	       (DELQ (ASSQ INTERESTING BACKGROUND-INTERESTING-WINDOWS)
		     BACKGROUND-INTERESTING-WINDOWS)))))

(DEFVAR *error-windows* nil "2List of windows with errors*")

;1 Re-written to save the list of windows in error*
(DEFUN FIND-INTERESTING-WINDOW (&optional n)
  (MULTIPLE-VALUE-BIND (NIL W)
      (FIND-PROCESS-IN-ERROR)
    (COND (w (PUSH w *error-windows*) w)
	  ((CAAR BACKGROUND-INTERESTING-WINDOWS))
	  (t (LOOP for window = (NTH (OR n 0) *error-windows*)
		   while window
		   do (IF (SEND window :active-p)
			  (RETURN window)
			(SETQ *error-windows* (DELQ window *error-windows*))))))))

(add-terminal-key (char-int #\E) #'select-interesting-window "2Select the window in error*")

;1-----------------------------------------------------------------------------*

(DEFUN terminal-select-window (IGNORE)
  (system-menu-select-window))

(add-terminal-key (char-int #\meta-s) #'terminal-select-window "2Select a window from a menu*")

;1-----------------------------------------------------------------------------*

(DEFUN terminal-expand-window (mouse-it-p &aux window)
  (IF mouse-it-p ;1; Select a window with the mouse*
      (SETQ WINDOW (CAR (SCREEN-EDITOR-FIND-WINDOW
			  (get-window-edge-alist tv:mouse-sheet) NIL
			  "Expand window"
			  '(:MOUSE-L-1 "Choose a window to expand"
				       :MOUSE-M-1 "aborts the expand operation."))))
    ;1; If the selected window is a pane, find its associated outer frame*
    (LOOP for previous first tv:selected-window then superior
	  for superior = (sheet-superior previous)
	  while (AND superior (sheet-superior superior))
	  finally (SETQ window previous)))
  (expand-window window))

(add-terminal-key (CHAR-INT #\meta-e) 'terminal-expand-window
		  "2Expand the selected window to full screen.
  With argument, expand the window you mouse.*")

;1-----------------------------------------------------------------------------*

;1; The following is stollen from tv:edit-screen*
(DEFUN edit-screen-doit (new old)
  (OR (EQUAL (CDDR OLD) (CDDR NEW))	   ;Edges not the same?
      (MULTIPLE-VALUE-BIND (WIN LOSE)
	  (FUNCALL (FIRST NEW) ':SET-EDGES (THIRD NEW) (FOURTH NEW)
		   (FIFTH NEW) (SIXTH NEW) ':VERIFY)
	(IF WIN (LEXPR-FUNCALL (CAR NEW) ':SET-EDGES (CDDR NEW))
	  (BEEP)
	  (POP-UP-FORMAT "Illegal edges for ~S:~%~A"
			 (CAR NEW) LOSE)))))

(DEFUN terminal-move-window (IGNORE)
  (LET* ((window-edge-alist (get-window-edge-alist tv:mouse-sheet))
	 (new-window-edge-alist  (sec-move-window nil window-edge-alist))
	 (new (CAR new-window-edge-alist))
	 (old (ASSQ new window-edge-alist)))
    (edit-screen-doit new old)))

(add-terminal-key (CHAR-INT #\meta-m) 'terminal-move-window "2Move a window*")

(DEFUN terminal-reshape-window (IGNORE)
  (LET* ((window-edge-alist (get-window-edge-alist tv:mouse-sheet))
	 (new-window-edge-alist  (sec-reshape nil window-edge-alist))
	 (new (CAR new-window-edge-alist))
	 (old (ASSQ new window-edge-alist)))
    (edit-screen-doit new old)))

(add-terminal-key (CHAR-INT #\meta-r) 'terminal-reshape-window "2Reshape a window*")
