;;; -*- Mode:Common-Lisp; Fonts:(cptfont, hl10, hl10b); Base:10. ;package: tv -*-


;; The :bitblt tests in this file need to be expanded to accept
;; random parameters.  These have been temporarily commented out
;; since these currently take one into the error handler instead of
;; clipping.  11-6-85 -GRH

(send initial-lisp-listener :select)
(send initial-lisp-listener :clear-screen)
						
(defvar test-window nil)
(setq test-window (make-instance 'tv:window
				   :edges '(100. 450. 800. 700.)
				   :border-margin-width 25.
                                   :label "Test window with wide border margin"))

(defvar message-window nil)
(setq message-window (make-instance 'tv:window
				   :edges '(100. 100. 800. 400.)
				   :border-margin-width 5
				   :label "Message window"
				   :more-p nil))

(defun random-x () (- (random 800.) 50.))
(defun random-y () (- (random 450.) 50.))

(defun initialize-test (string)
  (send test-window :expose)
  (send test-window :refresh)
  (send message-window :expose)
  (format message-window string)
  (format message-window "~%"))

(initialize-test  
"None of the window drawing methods should overwrite the wide margin areas of
  the test window.  However some of the primitives such as %draw-char clip to
  the outside edges instead of the inside edges.  Nothing should ever write 
  beyond the outside edges of the window.

Test (:method tv:graphics-mixin :draw-point)")

(dotimes (x 10000.)
  (send test-window :draw-point (random-x) (random-y)))

(initialize-test "Test (:method tv:graphics-mixin :draw-char)")

(dotimes (x 1000.)
  (send test-window :draw-char fonts:cptfont #o117
	(random-x) (random-y))
  (send test-window :draw-char fonts:bigfnt #o117
	(random-x) (random-y)))

(initialize-test "Test (:method tv:graphics-mixin :draw-line)")

(dotimes (x 1000.)
  (send test-window :draw-line
	(random-x) (random-y)
	(random-x) (random-y)
	(send test-window :char-aluf) t))

(initialize-test "Test (:method tv:graphics-mixin :draw-lines)")

(dotimes (x 200.)
  (send test-window :draw-lines
	(send test-window :char-aluf)
	(random-x) (random-y)
	(random-x) (random-y)
	(random-x) (random-y)
	(random-x) (random-y)
	(random-x) (random-y)
	(random-x) (random-y)
	(random-x) (random-y)
	(random-x) (random-y)))

(initialize-test "Test (:method tv:graphics-mixin :draw-dashed-line)")

(dotimes (x 200.)
  (send test-window :draw-dashed-line
	(random-x) (random-y)
	(random-x) (random-y))
  (send test-window :draw-dashed-line
	(random-x) (random-y)
	(random-x) (random-y)
	(send test-window :char-aluf) 40. t)
  (send test-window :draw-dashed-line
	(random-x) (random-y)
	(random-x) (random-y)
	(send test-window :char-aluf) 20. t 10.)
  (send test-window :draw-dashed-line
	(random-x) (random-y)
	(random-x) (random-y)
	(send test-window :char-aluf) 20. t 15.))

;; Set up some arrays needed for the next test
(defvar x-array (make-array 20. :type :art-fix))
(defvar y-array (make-array 20. :type :art-fix))

(initialize-test "Test (:method tv:graphics-mixin :draw-curve)")

(dotimes (x 10.)
  (dotimes (z 20.)
    (aset (random-x) x-array z)
    (aset (random-y) y-array z))
  (send test-window :draw-curve
	x-array y-array 15.
	(send test-window :char-aluf) nil)
  (dotimes (z 20.)
    (aset (random-x) x-array z)
    (aset (random-y) y-array z))
  (send test-window :draw-curve
	x-array y-array 15.
	(send test-window :char-aluf) t))

(initialize-test "Test (:method tv:graphics-mixin :draw-wide-curve)")

(dotimes (x 10.)
  (dotimes (z 20.)
    (aset (random-x) x-array z)
    (aset (random-y) y-array z))
  (send test-window :draw-wide-curve
	x-array y-array 3. 15.
	(send test-window :char-aluf) nil)
  (dotimes (z 20.)
    (aset (random-x) x-array z)
    (aset (random-y) y-array z))
  (send test-window :draw-wide-curve
	x-array y-array 20. 15.
	(send test-window :char-aluf) t))

(defun random-x-near (x) (+ x (- (random 50.) 25.)))
(defun random-y-near (y) (+ y (- (random 50.) 25.)))

(initialize-test "Test (:method tv:graphics-mixin :draw-triangle)")

(Let (x y)
  (dotimes (n 100.)
  (setq x (random-x))
  (setq y (random-y))
  (send test-window :draw-triangle
	x y
	(random-x-near x) (random-y-near y)
	(random-x-near x) (random-y-near y))))

(initialize-test "Test (:method tv:graphics-mixin :draw-circle)")

(defun random-radius () (random 45.))

(dotimes (x 300.)
  (send test-window :draw-circle
	(random-x) (random-y) (random-radius)))

(initialize-test "Test (:method tv:graphics-mixin :draw-filled-in-circle)")

(dotimes (x 300.)
  (send test-window :draw-filled-in-circle
	(random-x) (random-y) (random-radius)))

(defun random-theta () (random 8.0))

(initialize-test "Test (:method tv:graphics-mixin :draw-circular-arc)")

(dotimes (x 300.)
  (send test-window :draw-circular-arc
	(random-x) (random-y) (random-radius)
	(random-theta) (random-theta)))

(initialize-test "Test (:method tv:graphics-mixin :draw-filled-in-sector)")

(dotimes (x 300.)
  (send test-window :draw-filled-in-sector
	(random-x) (random-y) (random-radius)
	(random-theta) (random-theta)))

(defun random-sides () (random 9.))

(initialize-test "Test (:method tv:graphics-mixin :draw-regular-polygon)")

(Let (x y)
  (dotimes (n 100.)
  (setq x (random-x))
  (setq y (random-y))
  (send test-window :draw-regular-polygon x y
	(random-x-near x) (random-y-near y)
	(random-sides))))

(initialize-test "Test (:method tv:graphics-mixin :draw-cubic-spline)")

(dotimes (x 10.)
  (dotimes (z 20.)
    (aset (random-x) x-array z)
    (aset (random-y) y-array z))
  (send test-window :draw-cubic-spline
	x-array y-array 4. 1 
	(send test-window :char-aluf)
	:relaxed :relaxed)
  (dotimes (z 20.)
    (aset (random-x) x-array z)
    (aset (random-y) y-array z))
  (send test-window :draw-cubic-spline
	x-array y-array 4. 1 
	(send test-window :char-aluf)
	:clamped :clamped 0 0.5 0.75 1.0))

;; put a pattern in a 2d array
(defvar bitblt-array nil)
(setq bitblt-array (make-array '(128. 128.) :type :art-1b :initial-value 0))
(dotimes (x 64.)
  (dotimes (y 64.)
    (aset 1 bitblt-array (* 2 x) (* 2 y))))

(initialize-test "Test (:method tv:stream-mixin :bitblt)")

(dotimes (x ;10)
	   1) 
  (send test-window :bitblt tv:alu-seta
	128. 128. bitblt-array 0 0                   ;    (random-x) (random-y)))
	;; Temporarily use these values since clipping does not work on
	;; the right or bottom.  Switch back to the randoms after this is fixed.
                                         50. 50.))

(format message-window "Test (:method tv:stream-mixin :bitblt-from-sheet)~%")

(dotimes (x ;10)
	   1) 
  (send test-window :bitblt-from-sheet tv:alu-seta
	128. 128. 50. 50. bitblt-array                            ;    (random-x) (random-y)))
	;; Temporarily use these values since clipping does not work on
	;; the right or bottom.  Switch back to the randoms after this is fixed.
                                         0 0)
  (send test-window :bitblt tv:alu-seta
	128. 128. bitblt-array 0 0                            ;    (random-x) (random-y)))
	;; Temporarily use these values since clipping does not work on
	;; the right or bottom.  Switch back to the randoms after this is fixed.
                                         200. 50.))

(defun random-height () (- (random 200.) 100.))
(defun random-width () (- (random 200.) 100.))

(initialize-test "Test (:method tv:stream-mixin :bitblt-within-sheet)")

;; Put some pattern on the screen. 
(dotimes (x 300.)
  (send test-window :draw-line x 0 x 250. tv:alu-xor))

(dotimes (n 300.)
  (send test-window :bitblt-within-sheet tv:alu-seta
	(random-width) (random-height) 
	(random-x) (random-y)
	(random-x) (random-y)))

(defun rect-height () (random 100.))
(defun rect-width () (random 100.))

(initialize-test "Test (:method tv:stream-mixin :draw-rectangle)")

(dotimes (n 100.)
  (send test-window :draw-rectangle
	(rect-width) (rect-height)
	(random-x) (random-y)))

(initialize-test 
"Test microcode primitive %draw-char
  - should clip to OUTSIDE edges, not inside.")

(dotimes (x 3000.)
  (prepare-sheet (test-window)
    (si:%draw-char fonts:cptfont #\O (random-x) (random-y) tv:alu-ior test-window)))


