;;; -*- Mode:LISP; Package:USER; Fonts:(MEDFNT HL12B HL12BI); Base:10 -*-


(DEFFLAVOR constraint-frame-with-shared-io-buffer
           ((top-level (MAKE-INSTANCE 'geophysical-processing-workstation))
            (who-line-string nil)
            (previous-selection-substitute nil))
           (tv:process-mixin
            tv:alias-for-inferiors-mixin
            tv:inferiors-not-in-select-menu-mixin
            tv:select-mixin
            tv:stream-mixin
            tv:label-mixin
            tv:window-with-typeout-mixin
            tv:essential-mouse
            tv:bordered-constraint-frame-with-shared-io-buffer)
  :inittable-instance-variables
  :settable-instance-variables
  :gettable-instance-variables
  (:default-init-plist
    :process   '(geophysical-processing-workstation :regular-pdl-size 5000)
    :name      "GEOPHYSICAL PROCESSING WORKSTATION"
    :label     nil
    :save-bits ':delayed
    :typeout-window
    '(tv:typeout-window :deexposed-typeout-action (:expose-for-typeout))))


(DEFMETHOD (tv:typeout-window :who-line-documentation-string) ()
  (SEND tv:superior ':who-line-string))


(DEFFLAVOR constraint-frame-plain-pane ()
           (tv:stream-mixin
            tv:borders-mixin
            tv:select-mixin
            tv:minimum-window))


(DEFFLAVOR constraint-frame-menu-pane ()
           (tv:command-menu-pane
            tv:stream-mixin
            tv:select-mixin))


(DEFFLAVOR constraint-frame-graphics-pane ()
           (gwin:graphics-window-pane))


(DEFFLAVOR constraint-frame-lisp-pane ()
           (tv:interaction-pane))


(DEFMETHOD (constraint-frame-with-shared-io-buffer :name-for-selection) () tv:name)
  

(DEFMETHOD (constraint-frame-with-shared-io-buffer :io-buffer) () tv:io-buffer)


(DEFMETHOD (constraint-frame-with-shared-io-buffer :before :init) (&rest ignore)
  "2INITIALIZE MASTER CONSTRAINT FRAME*"
  (SETQ tv:superior tv:main-screen
        tv:panes
          `((herald-pane    constraint-frame-plain-pane
                            :deexposed-typeout-action :permit
                            :font-map ,'(fonts:cmr18  fonts:medfnt)
                            :name "HERALD-PANE"
                            :blinker-p t
                            :blinker-deselected-visibility :off
                            :save-bits t)
            (heading-pane   constraint-frame-plain-pane
                            :deexposed-typeout-action :permit
                            :font-map ,'(fonts:medfnb)
                            :name "HEADING-PANE"
                            :blinker-p nil
                            :save-bits t)
            (prompt-pane-01 constraint-frame-plain-pane
                            :deexposed-typeout-action :permit
                            :font-map ,'(fonts:medfnb)
                            :name "PROMPT-PANE-01"
                            :blinker-p nil
                            :save-bits nil)
            (prompt-pane-02 constraint-frame-plain-pane
                            :deexposed-typeout-action :permit
                            :font-map ,'(fonts:medfnb)
                            :name "PROMPT-PANE-02"
                            :blinker-p nil
                            :save-bits nil)
            (complaint-pane constraint-frame-plain-pane
                            :deexposed-typeout-action :permit
                            :font-map ,'(fonts:medfnb)
                            :name "COMPLAINT-PANE"
                            :blinker-p nil
                            :save-bits nil)
            (menu-pane-01   constraint-frame-menu-pane
                            :deexposed-typeout-action :permit
                            :name "MENU-PANE-01"
                            :label " "
                            :item-list nil
                            :save-bits t)
            (menu-pane-02   constraint-frame-menu-pane
                            :deexposed-typeout-action :permit
                            :name "MENU-PANE-02"
                            :label " "
                            :item-list nil
                            :save-bits nil)
            (menu-pane-03   constraint-frame-menu-pane
                            :deexposed-typeout-action :permit
                            :name "MENU-PANE-03"
                            :label " "
                            :item-list nil
                            :save-bits nil)
            (prospect-pane  constraint-frame-plain-pane
                            :deexposed-typeout-action :permit
                            :font-map ,'(fonts:medfnb)
                            :name "PROSPECT-PANE"
                            :blinker-p nil
                            :save-bits t)
            (graphics-pane  constraint-frame-graphics-pane
                            :deexposed-typeout-action :permit
                            :name "GRAPHICS-PANE"
                            :save-bits nil)
            (lisp-pane      constraint-frame-lisp-pane
                            :name "LISP-PANE"
                            :label ""))
          tv:constraints
          '((config-00.0 . ((herald-pane)
                            ((herald-pane 1.00))))
            (config-01.0 . ((heading-pane prompt-pane-01 prompt-pane-02 complaint-pane
                                          strip-pane prospect-pane graphics-pane)
                            ((heading-pane   0.025)
                             (prompt-pane-01 0.025)
                             (prompt-pane-02 0.025)
                             (complaint-pane 0.025)
                             (strip-pane
                               :horizontal
                               (0.20) . ((menu-pane-01 menu-pane-02 menu-pane-03)
                                         ((menu-pane-01 :even)
                                          (menu-pane-02 :even)
                                          (menu-pane-03 :even))))
                             (prospect-pane 0.025)
                             (graphics-pane 0.675))))
            (config-01.1 . ((heading-pane prompt-pane-01 prompt-pane-02 complaint-pane
                                          strip-pane prospect-pane graphics-pane
                                          lisp-pane)
                            ((heading-pane   0.025)
                             (prompt-pane-01 0.025)
                             (prompt-pane-02 0.025)
                             (complaint-pane 0.025)
                             (strip-pane
                               :horizontal
                               (0.20) . ((menu-pane-01 menu-pane-02 menu-pane-03)
                                         ((menu-pane-01 :even)
                                          (menu-pane-02 :even)
                                          (menu-pane-03 :even))))
                             (prospect-pane 0.025)
                             (graphics-pane 0.575)
                             (lisp-pane     0.100)))))
            ))


(COMPILE-FLAVOR-METHODS constraint-frame-with-shared-io-buffer
                        constraint-frame-plain-pane
                        constraint-frame-menu-pane
                        constraint-frame-graphics-pane
                        constraint-frame-lisp-pane)