;;; -*- Mode:LISP; Package:TV; Base:10; Fonts:(MEDFNT MEDFNB HL12B) -*-

;1 Functions to allow modifying data structures with choose-variable-values*
;1 LaMott Oren 11/83*

;1 CHOOSE-VALUES-LIST*
(DEFUN choose-values-list (form data-list &rest options)
  "2Like Choose-variable-values, except it lets you separate the description from the data.
FORM is a choose-variable-values ITEM list where the variable symbol is does not need to be special.
DATA-LIST is a list of values.  CHOOSE-VALUES-LIST locally binds variable symbols from FORM with
data values from DATA-LIST, then calls CHOOSE-VARIABLE-VALUES with OPTIONS.  The resulting
value list is returned.*"
  (LET (symbol symbol-list)
    (DOLIST (item form)
      (SETQ symbol (COND ((SYMBOLP item) item)
			 ((LISTP item) (CAR item))))
      (WHEN symbol
	;1;(push-end symbol symbol-list)*
	(SETQ symbol-list (NCONC symbol-list (LIST symbol)))))
    (PROGV symbol-list data-list
      (LEXPR-FUNCALL 'tv:choose-variable-values form options)
      (MAPCAR #'SYMEVAL symbol-list))))

;1 CHOOSE-VALUES*
(DEFUN choose-values (form data &rest options)
  "2Like Choose-variable-values, except it lets you separate the description from the data.
FORM is a choose-variable-values ITEM list where the variable symbol is now a variable name
used to access DATA. 
OPTIONS are optional choose-variable-values keyword options.
DATA may be a named structure, alist, or flavor-instance; If the
variable name is a fixnum, DATA may be a list or array, where the fixnum is used as an
index into the values.*"
  (LET (symbol-list data-list number-p)
    (WHEN (MEMQ ':numbered options)
      (SETQ options (DELQ ':numbered options)
	    number-p t
	    form (COPYTREE form)))
    (DOLIST (item form)
      (LET ((symbol (COND ((SYMBOLP item) item)
			  ((FIXNUMP item) item)
			  ((LISTP item) (CAR item)))))
	(WHEN symbol
	  (PUSH (get-pointer-to symbol data) data-list)
	  (WHEN (FIXNUMP symbol)
	    (WHEN (NOT number-p)
	      (FERROR nil "~s - Variable numbers not allowed without ~
 			   the :NUMBERED keyword parameter" item))
	    (SETQ symbol (INTERN (GENSYM)))
	    (WHEN (NLISTP item)
	      (FERROR nil "~s Variable numbers must be inside an item list" item))
	    (RPLACA item symbol))
	  (PUSH symbol symbol-list))))
    (PROGV symbol-list (MAPCAR #'CONTENTS data-list)
      (LEXPR-FUNCALL 'tv:choose-variable-values form options)
      (DO ((item data-list (CDR item))
	   (symbol symbol-list (CDR symbol)))
	  ((NULL item))
	(RPLACA (CAR item) (SYMEVAL (CAR symbol))))))
  data)
  
;1 GET-POINTER-TO (helper function)*
(DEFUN get-pointer-to (name data)
  "2Return a locative into DATA for data item NAME
Name may be a fixnum or a symbol, DATA may be a list, alist, flavor-instance,
array, or named structure.*"
  (SELECTQ (DATA-TYPE data)
    (:dtp-list		 (COND ((NUMBERP name)
				(LOCF (NTH name data)))
			       ((GET name 'si:defstruct-slot)
				(EVAL `(LOCF (,name ',data))))
			       (t
				(LET ((item (ASSOC name data)))
				  (IF (LISTP item) (LOCF (CAR item))
				    (FERROR nil "~S not found in data" name))))))
    (:dtp-instance 	(LOCATE-IN-INSTANCE data name))
    (:dtp-array-pointer (IF (NUMBERP name)
			    (ALOC data name)
			  (EVAL `(LOCF (,name ',data)))))
    (otherwise 		(FERROR nil "~s Data type not handled"
				(DATA-TYPE data)))))
	    


