;;; -*- MODE:LISP; Package:USER; Fonts:(CPTFONT MEDFNB HL12B); Base:10 -*-

(DEFVAR CURRENCY 'DOLLAR)
(DEFVAR AMOUNT 0.0)
(DEFUN SELECT-CURRENCY ()
  "Select a currency and a particular amount.
Returns the currency and the amount as a list of two elements."
    (W:CHOOSE-VARIABLE-VALUES
      '((CURRENCY
          "Monetary Unit"
          :MENU-ALIST
          (("Dollar" :VALUE DOLLAR :DOCUMENTATION "Currency of the United States.")
           ("Pound"  :VALUE POUND  :DOCUMENTATION "Currency of Britain.")
           ("Yen"    :VALUE YEN    :DOCUMENTATION "Currency of Japan.")
           ("Ruble"  :VALUE RUBLE  :DOCUMENTATION "Currency of the USSR.")))
        (AMOUNT "Numerical amount" ));:CONSTRAINT CHECK-AMOUNT))
       ':EXTRA-WIDTH 50.
      :margin-choices `((,W:MARGIN-CHOICE-ABORT-STRING
                         (SIGNAL-CONDITION EH:*ABORT-OBJECT*))
                        ("Help" (*THROW 'get-help T))
                        ,W:MARGIN-CHOICE-COMPLETION-STRING
                        )
       )
    (LIST CURRENCY AMOUNT)
  )

(DEFUN CHECK-AMOUNT (IGNORE VARIABLE ITEM-VALUE-FOR-SET &OPTIONAL IGNORE)
  "Validate the amount relative to the specified currency."
  (LET ((FRACTIONAL (* ITEM-VALUE-FOR-SET 100.0)))
    (IF (NOT (= (FIX FRACTIONAL) FRACTIONAL))
        (STRING-APPEND
          "Amount can't be a fractional "
          (SELECTQ CURRENCY
            (DOLLAR "penny")
            (POUND  "pence")
            (YEN    "sen")
            (RUBLE  "kopeck"))
          ".")
      NIL)))

(DEFVAR ITEM-TO-QUOTE 5)
(DEFVAR FAMILY-SIZE 0)
(DEFVAR BROTHERS NIL)
(DEFVAR SISTERS NIL)
(DEFVAR NERF-BALL-IQ .1)
(DEFUN CVV-EXAM ()
  "Example of CHOOSE-VARIABLE-VALUES features."
  (TV:CHOOSE-VARIABLE-VALUES
    '((ITEM-TO-QUOTE "Item-to-quote" :QUOTE
		     :DOCUMENTATION "This item will be quoted within a list.")
      (FAMILY-SIZE   "Size of family"
		     :DOCUMENTATION "Number of brothers and sisters in your family."
		     :FIXNUM)
      (BROTHERS      "Number of brothers" :FIXNUM-OR-NIL)
      (SISTERS       "Number of sisters"  :FIXNUM-OR-NIL)
      (NERF-BALL-IQ  "IQ of a nerf ball"
		     :DOCUMENTATION "Intelligence quotient of a nerf ball."
		     :SMALL-FRACTION))))



(DEFVAR BIRTHDAY (GET-UNIVERSAL-TIME))
(DEFUN CVV-DATES ()
  "Example of date entry using CHOOSE-VARIABLE-VALUES."
  (TV:CHOOSE-VARIABLE-VALUES
    '((BIRTHDAY "Your birthday" :DATE
		:DOCUMENTATION "Enter your birthday"))))

(DEFCONST CVVMENU '("2Meat Department*"
		(VARIABLE "Cuts of beef menu"
                          :DOCUMENTATION "Select from one of several cuts of beef."
                          :MENU CUTS-OF-BEEF-MENU)
		(VARIABLE "Foo menu" 
                          :DOCUMENTATION "Select one item from the foo menu."
                          :MENU
                          '(("Foo-item" . FOO)
                            ("Bar-item" . BAR)
                            ("Baz-item" . BAZ))))
  "Example of two different menus.")

; (tv:choose-variable-values cvvmenu)

(DEFCONST CVV '("2Meat Department*"
		(CUTS-OF-BEEF "Beef" :SEXP)
		(PRICE-OF-BEEF "Price" :NUMBER)
		(CUTS-OF-PORK "Pork" :PRINC)
		(CUTS-OF-LAMB "Lamb" :EDIT :SIDE-EFFECT (BEEP 200) :STRING-LIST)
		(VARIABLE "Cuts of beef menu" :MENU CUTS-OF-BEEF-MENU)
		(VARIABLE "Number menu" :MENU NUMBER-menu) 
		""
		"Produce"
		(LETTUCE-TYPES "Lettuce" :STRING-LIST)
		(SQUASH-TYPE "Squash" :CHOOSE
                               ("Summer" "Winter"      "Spring-time" "Fall"
                                "sometime in August"   "sometime in May"
                                "sometime in June"     "sometime in July"
                                "sometime in December" "sometime in January"))
		(SQUASH-TYPE "More squash" :ASSOC
			       ((SUMMER . "Summer") (WINTER . "Winter")))
		""
		(VEGIE-SET "Vegies" :SET (SQUASH PEAS BEANS CABBAGE))
		""
		"Dairy"
		(MILK-PRICE "Milk"
			      :DOCUMENTATION
                              "Click left to raise the price of milk."
			      :number))
  "Example showing the use of several variable types.")

(DEFCONST CUTS-OF-BEEF-MENU '(steak ground roast))
(DEFCONST number-menu '(("one" . 1)("two" . 2)("three" . 3)))
(DEFVAR CUTS-OF-BEEF        '(steak ground roast))
(DEFVAR PRICE-OF-BEEF 10.45 "Price of beef in dollars.")
(DEFVAR CUTS-OF-PORK        '(steak ground roast chop))
(DEFVAR CUTS-OF-LAMB        '("Steak" "Roast" "Chop"))
(DEFVAR LETTUCE-TYPES       '("Romain" "Head" "Spinache"))
(DEFVAR SQUASH-TYPE nil)
(DEFVAR MILK-PRICE 2.50)
(DEFVAR VARIABLE nil "General-use variable in this example.")
(DEFVAR VEGIE-SET '(squash beans))

; (tv:choose-variable-values cvv)

(DEFCONST
  form 
  `("2This is a title line*"
    (Item-1 "Item One" :sexp)
    (Item-2 "Item twp" :sexp)
    (Item-3 "Item three" :sexp)
    (Item-4 "Item four" :sexp)))

(DEFSTRUCT (item :LIST (:CONSTRUCTOR NIL))
  item-1 item-2 item-3 item-4)

(DEFCONST
  data
  '(1 2 3 4))

(DEFCONST table '((line1 1 2 3 4)
		  (line2 5 6 7 8)
		  (line3 9 0 1 2)
		  (line4 3 4 5 6)))

;;; The following CVV test does not work properly (TWE 24-SEP-84)
(DEFCONST ct '((CUTS-OF-PORK "Pork" :princ)
	       (CUTS-OF-LAMB "lamb" :edit :side-effect (BEEP 200) :string-list)
	       (VARIABLE "try-me" :menu CUTS-OF-BEEF-MENU)
	       (VARIABLE "try-me too" :menu number-menu)
	       (table (0 "item 1" sexp)
		      (1 "item 2" number)
		      (2 "item 3" boolean)
		      (3 "item 4" number)
		      (4 "item 5" number))
	       (vegie-set "Vegies" :set (squash peas beans cabbage))
	       ""
	       "Dairy"
	       (Milk-price "Milk"
			     :documentation
			     "Click left to raise the proce of milk"
			     :number)))