;;; -*- Mode:Common-Lisp; Package:USER; Fonts:(CPTFONT HL12BI HL12B); Base:10 -*-

2;;;
;;; Description:  Test suite for window :draw methods and %draw-character function
;;;
;;; History:      03/25/86  Russ Hunt                 Created
;;;              11/21/86  Kerry Kimbrough           Modified to use standard test
;;;                                                     macros and functions. Functions
;;;                                                     were reorganized and some test cases 
;;;                                                     were extended.
;;;              01/29/87  Kerry Kimbrough           Modified to use W: package.
;;;                                                     Test %draw-character instead of
;;;                                                     obsolete %draw-char.
;;;                                                     New graphics methods tested.
;;;                                                     New color, thickness parameters added.
;;;                                                     
;;;
;;; 
;;; *			2  RESTRICTED RIGHTS LEGEND 
;;; 
;;; Use, duplication, or disclosure by the Government is subject to restrictions as  set
;;; forth in  subdivision  (b)(3)(ii)  of  the  Rights  in  Technical  Data and Computer
;;; Software clause at 52.227-7013. 
;;; 
;;; TEXAS INSTRUMENTS  INCORPORATED,  P.O.   BOX  2909  AUSTIN,  TEXAS 78769
;;; Copyright (C) 1986, Texas Instruments Incorporated.  All rights reserved.
;;; *

;1;*
;1; Notes on test limitations:*
;1;
;; The :bitblt tests in this file need to be expanded to accept
;; random parameters.  These have been temporarily commented out
;; since these currently take one into the error handler instead of
;; clipping.  11-6-85 -GRH*
;1;*
;1; The :bitblt tests have been amplified somewhat, using some random*
;1; parameters. The range of parameter values is still limited, however.*
;1; Values which cause array addressing errors, as mentioned in the previous*
;1; note, are still avoided (even though the test functions allow graceful*
;1; recovery from the error handler), because it is not clear if this behavior*
;1; is a problem or a feature.*
;1; KK, 11/24/86 *
;1;*


(DEFVAR  NUMBER-OF-RANDOM-REPETITIONS 100)

(defvar dg-message-window nil)
(defvar dg-test-window nil)
(defvar dg-x-array (make-array 20. :type :art-fix))
(defvar dg-y-array (make-array 20. :type :art-fix))
(defvar dg-bitblt-array nil)
(defvar dg-all-colors (LIST 0 1 2 3 4 5 6 7 8 nil w:black w:white))
(defvar dg-various-thicknesses '(1 32 997))

(defun random-x () (- (random 800.) 50.))
(defun random-y () (- (random 450.) 50.))

(defun rect-height () (random 100.))
(defun rect-width () (random 100.))

  
(defun random-x-near (x) (+ x (- (random 50.) 25.)))
(defun random-y-near (y) (+ y (- (random 50.) 25.)))
  

(defun random-theta () (random 720.0))
(defun random-sides () (* (random 20.) (expt -1 (random 2))))
  
(defun random-height () (- (random 200.) 100.))
(defun random-width () (- (random 200.) 100.))

(DEFUN dg-random-array ()
  (LET* ((n     (RANDOM 2047))
	 (array (MAKE-ARRAY (1+ n))))
    (LOOP for i from 0 to n
	  do (SETF (AREF array i) (random-x))
	  )
    array
    )
  )
(defun dg-initialize-test (string)
  (prepare-test-case string)
  (INCF user:*number-of-tests-attempted*)
  (dg-display-message string)
  )

(DEFUN dg-display-message (string)
  (send dg-test-window :expose)
  (send dg-test-window :refresh)
  (send dg-message-window :expose)
  (format dg-message-window string)
  (format dg-message-window "~%")
  )

(DEFUN dg-point-inside-p (x y left top right bottom)
  "2Return non-nil iff (x,y) is inside the given rectangle.*"
  (AND (> x left) (< x right) (> y top) (< y bottom))
  )

(DEFUN draw-primitives-test ()
;1;*
;1; Establish test environment*
;1;*
  (send w:initial-lisp-listener :select)
  (send w:initial-lisp-listener :clear-screen)
  

  (setq dg-test-window (make-instance 'w:window
				   :deexposed-typeout-action :expose
				   :edges '(100. 450. 800. 700.)
				   :border-margin-width 25.
                                   :label "Test window with wide border margin"))
  

  (setq dg-message-window (make-instance 'w:window
				      :deexposed-typeout-action :expose
				      :edges '(100. 100. 800. 400.)
				      :border-margin-width 5
				      :label "Message window"
				      :more-p nil))
  
  

;1;*
;1; Perform tests cases*
;1;*
  (dg-display-message  
    "None of the window drawing methods should overwrite the wide margin areas 
the test window.  However some of the primitives such as %draw-character clip to 
the outside edges instead of the inside edges.  Nothing should ever write 
beyond the outside edges of the window.
")

1;;;
;;; Test :draw-point, :point
;;;*
  (SETQ NUMBER-OF-RANDOM-REPETITIONS 1000)  

  (DO* ((all-pixel-values dg-all-colors                   (CDR all-pixel-values))
	(pixel-value      (CAR all-pixel-values)   (CAR all-pixel-values)))
       ((NULL all-pixel-values))
    (DECLARE (SPECIAL  pixel-value))    
    (dg-initialize-test
      (FORMAT nil "Test (:method w:graphics-mixin :draw-point), pixel-value ~a" pixel-value))
    
    (MULTIPLE-VALUE-BIND (left top right bottom) (SEND  dg-test-window :inside-edges)
      (dotimes (x NUMBER-OF-RANDOM-REPETITIONS)
	(LET ((point-x (random-x))
	      (point-y (random-y)))
	  (DECLARE (SPECIAL point-x point-y))
	  (send dg-test-window :draw-point
		point-x    point-y
		w:alu-seta pixel-value)
	  (IF (dg-point-inside-p point-x point-y left top right bottom)
	      (compare-safely = (SEND dg-test-window :point point-x point-y) pixel-value)
	      (compare-safely = (SEND dg-test-window :point point-x point-y) 0)
	      )))))

1;;;
;;; Test :draw-char
;;;*
  (dg-initialize-test "Test (:method w:graphics-mixin :draw-char)")
  
  (dotimes (x NUMBER-OF-RANDOM-REPETITIONS)
    (send dg-test-window :draw-char fonts:cptfont #o117
	  (random-x) (random-y))
    (send dg-test-window :draw-char fonts:bigfnt #o117
	  (random-x) (random-y)))
 
1;;;
;;; Test :draw-line
;;;*
  (SETQ NUMBER-OF-RANDOM-REPETITIONS 100)

  (DOLIST (color dg-all-colors)
    (DOLIST (thickness dg-various-thicknesses)
      (dg-initialize-test
	(FORMAT nil "Test (:method w:graphics-mixin :draw-line), color ~a, thickness ~a"
		color thickness))
      
      (dotimes (x NUMBER-OF-RANDOM-REPETITIONS)
	(send dg-test-window :draw-line
	      (random-x) (random-y)
	      (random-x) (random-y)
	      thickness color
	      ))))


1;;;
;;; Test :draw-polyline
;;;*
  (SETQ NUMBER-OF-RANDOM-REPETITIONS 10)

  (DOLIST (color dg-all-colors)
    (DOLIST (thickness dg-various-thicknesses)

  (dg-initialize-test
    (FORMAT nil "Test (:method w:graphics-mixin :draw-polyline), color ~a, thickness ~a"
		color thickness))
  
  (dotimes (x NUMBER-OF-RANDOM-REPETITIONS)
    (send dg-test-window :draw-polyline
	  (dg-random-array) (dg-random-array)
	  thickness         color
	  ))))

  
1;;;
;;; Test :draw-dashed-line
;;;*
  (SETQ NUMBER-OF-RANDOM-REPETITIONS 10)

  (DOLIST (color dg-all-colors)
    (DOLIST (thickness dg-various-thicknesses)
      
      (dg-initialize-test
	(FORMAT nil "Test (:method w:graphics-mixin :draw-dashed-line), color ~a, thickness ~a"
		color thickness
		))
      
      (dotimes (x NUMBER-OF-RANDOM-REPETITIONS)
	(send dg-test-window :draw-dashed-line
	      (random-x) (random-y)
	      (random-x) (random-y)
	      thickness  color
	      )
	(send dg-test-window :draw-dashed-line
	      (random-x) (random-y)
	      (random-x) (random-y)
	      thickness  color
	      w:alu-seta 40. t)
	(send dg-test-window :draw-dashed-line
	      (random-x) (random-y)
	      (random-x) (random-y)
	      thickness  color
	      w:alu-seta 20. t 10.)
	(send dg-test-window :draw-dashed-line
	      (random-x) (random-y)
	      (random-x) (random-y)
	      thickness  color
	      w:alu-seta 20. t 15.))))
  
1;;;
;;; Test :draw-arc
;;;*
  (SETQ NUMBER-OF-RANDOM-REPETITIONS 100)

  (DOLIST (color dg-all-colors)
    (DOLIST (thickness dg-various-thicknesses)
      
      (dg-initialize-test
	(FORMAT nil "Test (:method w:graphics-mixin :draw-arc), color ~a, thickness ~a"
		color thickness))
      
      (dotimes (n NUMBER-OF-RANDOM-REPETITIONS)
	  (send dg-test-window :draw-arc
		0          0
		(random-x) (random-y)
		(random-theta)
		thickness         color))))

  ;1; check some boundary conditions*
  (LET* ((mid-x  (ROUND (- (w:sheet-inside-right dg-test-window) (w:sheet-inside-left dg-test-window)) 2))
	 (mid-y  (ROUND (- (w:sheet-inside-bottom dg-test-window) (w:sheet-inside-top dg-test-window)) 2))
	 (start-x (+ mid-x (ROUND (MIN (w:sheet-inside-height dg-test-window) (w:sheet-inside-width dg-test-window)) 4)))
	 )    
    (DOLIST (arc-angle '(0 360 -0 -360 -180))
      (dg-initialize-test
	(FORMAT nil "Test (:method w:graphics-mixin :draw-arc), arc-angle ~a"
		arc-angle))
      (send dg-test-window :draw-arc
	    mid-x      mid-y
	    start-x    mid-y
	    arc-angle  4
	    )))
1;;;
;;; Test :draw-filled-arc
;;;*
  (DOLIST (color dg-all-colors)
      (dg-initialize-test
	(FORMAT nil "Test (:method w:graphics-mixin :draw-filled-arc), color ~a"
		color))
      
      (dotimes (n NUMBER-OF-RANDOM-REPETITIONS)
	  (send dg-test-window :draw-filled-arc
		0          0
		(random-x) (random-y)
		(random-theta)
		color)))

  ;1; check some boundary conditions*
  (LET* ((mid-x  (ROUND (- (w:sheet-inside-right dg-test-window) (w:sheet-inside-left dg-test-window)) 2))
	 (mid-y  (ROUND (- (w:sheet-inside-bottom dg-test-window) (w:sheet-inside-top dg-test-window)) 2))
	 (start-x (+ mid-x (ROUND (MIN (w:sheet-inside-height dg-test-window) (w:sheet-inside-width dg-test-window)) 4)))
	 )    
    (DOLIST (filled-arc-angle '(0 360 -0 -360 -180))
      (dg-initialize-test
	(FORMAT nil "Test (:method w:graphics-mixin :draw-filled-arc), filled-arc-angle ~a"
		filled-arc-angle))
      (send dg-test-window :draw-filled-arc
	    mid-x      mid-y
	    start-x    mid-y
	    filled-arc-angle
	    )))  


1;;;
;;; Test :draw-triangle
;;;*
  (DOLIST (color dg-all-colors)
    (DOLIST (thickness dg-various-thicknesses)
      
      (dg-initialize-test
	(FORMAT nil "Test (:method w:graphics-mixin :draw-triangle), color ~a, thickness ~a"
		color thickness))
      
      (let (x y)
	(dotimes (n NUMBER-OF-RANDOM-REPETITIONS)
	  (setq x (random-x))
	  (setq y (random-y))
	  (send dg-test-window :draw-triangle
		x y
		(random-x-near x) (random-y-near y)
		(random-x-near x) (random-y-near y)
		thickness         color)))))
  
1;;;
;;; Test :draw-filled-triangle
;;;*
  (DOLIST (color dg-all-colors)
    (dg-initialize-test
	(FORMAT nil "Test (:method w:graphics-mixin :draw-filled-triangle), color ~a"
		color))
      
      (let (x y)
	(dotimes (n NUMBER-OF-RANDOM-REPETITIONS)
	  (setq x (random-x))
	  (setq y (random-y))
	  (send dg-test-window :draw-filled-triangle
		x y
		(random-x-near x) (random-y-near y)
		(random-x-near x) (random-y-near y)
		color))))

  ;1; Check edge drawing*
  (dg-initialize-test
	(FORMAT nil "Test (:method w:graphics-mixin :draw-triangle), draw selective edges" ))
  (LET* ((mid-x  (ROUND (- (w:sheet-inside-right dg-test-window) (w:sheet-inside-left dg-test-window)) 2))
	 (mid-y  (ROUND (- (w:sheet-inside-bottom dg-test-window) (w:sheet-inside-top dg-test-window)) 2))
	 (x1     (w:sheet-inside-left dg-test-window))
	 (y1     mid-y)
	 (x2     (w:sheet-inside-right dg-test-window))
	 (y2     mid-y)
	 (x3     mid-x)
	 (y3     (w:sheet-inside-bottom dg-test-window))
	 )
    (send dg-test-window :draw-filled-triangle
	  x1 y1 x2 y2 x3 y3
	  w:black w:alu-seta
	  nil nil nil)				;1no edges drawn*
    (send dg-test-window :draw-filled-triangle
	  x1 y1 x1 y3  x3 y3
	  w:black w:alu-seta
	  nil t t)				;1skip third edge only*
    (send dg-test-window :draw-filled-triangle
	  x3 0 x2 y2 x1 y1 
	  w:black w:alu-seta
	  t nil t)				;1skip second edge only*
    (send dg-test-window :draw-filled-triangle
	  x2 y2 x3 y3 x2 y3
	  w:black w:alu-seta
	  t t nil)				;1skip first edge only*
    )
  
1;;;
;;; Test :draw-rectangle
;;;*
  (DOLIST (color dg-all-colors)
    (DOLIST (thickness dg-various-thicknesses)
      
      (dg-initialize-test
	(FORMAT nil "Test (:method w:graphics-mixin :draw-rectangle), color ~a, thickness ~a"
		color thickness))
      
      (dotimes (n NUMBER-OF-RANDOM-REPETITIONS)
	(send dg-test-window :draw-rectangle
	      (random-x) (random-y)	      
	      (rect-width) (rect-height)
	      thickness   color))))

1;;;
;;; Test :draw-filled-rectangle
;;;*
  (DOLIST (color dg-all-colors)
    (dg-initialize-test
	(FORMAT nil "Test (:method w:graphics-mixin :draw-filled-rectangle), color ~a"
		color))
      
      (dotimes (n NUMBER-OF-RANDOM-REPETITIONS)
	(send dg-test-window :draw-filled-rectangle
	      (random-x) (random-y)	      
	      (rect-width) (rect-height)
	      color)))

  ;1; check edge drawing*
  (dg-initialize-test
	(FORMAT nil "Test (:method w:graphics-mixin :draw-filled-rectangle), edge drawing"))
  (LET* ((mid-x  (ROUND (- (w:sheet-inside-right dg-test-window) (w:sheet-inside-left dg-test-window)) 2))
	 (mid-y  (ROUND (- (w:sheet-inside-bottom dg-test-window) (w:sheet-inside-top dg-test-window)) 2))
	 )
    (send dg-test-window :draw-filled-rectangle
	      0 0 mid-x mid-y
	      w:black w:alu-seta t)		;1draw edges*
    (send dg-test-window :draw-filled-rectangle
	      0 0 mid-x mid-y
	      w:black w:alu-xor nil)		;1erase interior, leave edges*
    )

1;;;
;;; Test :draw-circle
;;;*
  (DOLIST (color dg-all-colors)
    (DOLIST (thickness dg-various-thicknesses)
      
      (dg-initialize-test
	(FORMAT nil "Test (:method w:graphics-mixin :draw-circle), color ~a, thickness ~a"
		color thickness))
      
      (dotimes (x NUMBER-OF-RANDOM-REPETITIONS)
	(send dg-test-window :draw-circle
	      (random-x) (random-y) (random-x)
	      thickness  color))))

1;;;
;;; Test :draw-filled-circle
;;;*
  (DOLIST (color dg-all-colors)
    (dg-initialize-test
      (FORMAT nil "Test (:method w:graphics-mixin :draw-filled-circle), color ~a"
	      color))
    
    (dotimes (x NUMBER-OF-RANDOM-REPETITIONS)
      (send dg-test-window :draw-filled-circle
	    (random-x) (random-y) (random-x)
	    color)))
  
1;;;
;;; Test :draw-regular-polygon
;;;*
  (DOLIST (color dg-all-colors)
    
    (dg-initialize-test
      (FORMAT nil "Test (:method w:graphics-mixin :draw-regular-polygon), color ~a"
		color))
    
    (let (x y)
      (dotimes (n NUMBER-OF-RANDOM-REPETITIONS)
	(setq x (random-x))
	(setq y (random-y))
	(send dg-test-window :draw-regular-polygon x y
	      (random-x-near x) (random-y-near y)
	      (random-sides) color))))

  ;1; check edge drawing*
  (dg-initialize-test
	(FORMAT nil "Test (:method w:graphics-mixin :draw-regular-polygon), edge drawing"))

  (LET* ((mid-x  (ROUND (- (w:sheet-inside-right dg-test-window) (w:sheet-inside-left dg-test-window)) 2))
	 (mid-y  (ROUND (- (w:sheet-inside-bottom dg-test-window) (w:sheet-inside-top dg-test-window)) 2))
	 )
    (SEND dg-test-window :draw-regular-polygon
	  mid-x mid-y (+ mid-x 64) (+ mid-y 64) -5 w:black w:alu-seta t)	;1draw edges*
    (SEND dg-test-window :draw-regular-polygon
	  mid-x mid-y (+ mid-x 64) (+ mid-y 64) -5 w:black w:alu-xor nil)	;1erase interior*
    )

1;;;
;;; Test :draw-cubic-spline
;;;*

  (SETQ  NUMBER-OF-RANDOM-REPETITIONS 10)

  (DOLIST (color dg-all-colors)
    (DOLIST (thickness dg-various-thicknesses)
      
      (dg-initialize-test
	(FORMAT nil "Test (:method w:graphics-mixin :draw-cubic-spline), color ~a, thickness ~a"
		color thickness))
      
      (dotimes (x NUMBER-OF-RANDOM-REPETITIONS)
	(dotimes (z 20.)
	  (aset (random-x) dg-x-array z)
	  (aset (random-y) dg-y-array z))
	(send dg-test-window :draw-cubic-spline
	      dg-x-array dg-y-array 4.
	      thickness  color
	      w:alu-seta
	      :relaxed :relaxed)
	(dotimes (z 20.)
	  (aset (random-x) dg-x-array z)
	  (aset (random-y) dg-y-array z))
	(send dg-test-window :draw-cubic-spline
	      dg-x-array dg-y-array 4.
	      thickness  color  
	      w:alu-seta
	      :clamped :clamped 0 0.5 0.75 1.0))))
  
1;;;
;;; Test :bitblt
;;;*
  (SETQ NUMBER-OF-RANDOM-REPETITIONS 1000)
  
  (setq dg-bitblt-array (make-array '(128. 128.) :type :art-1b :initial-value 0))
  (dotimes (x 64.)
    (dotimes (y 64.)
      (aset 1 dg-bitblt-array (* 2 x) (* 2 y))))
  
  (dg-initialize-test "Test (:method w:stream-mixin :bitblt)")
  
  (dotimes (x NUMBER-OF-RANDOM-REPETITIONS) 
    (send dg-test-window :bitblt w:alu-seta
	  (RANDOM 128.) (RANDOM 128.) dg-bitblt-array 0 0 (RANDOM 128.) (RANDOM 128.)))
	  ;; Temporarily use these values since clipping does not work on
	  ;; the right or bottom.  Switch back to the randoms after this is fixed.

1;;;
;;; Test :bitblt-from-sheet
;;;*
  (dg-initialize-test "Test (:method w:stream-mixin :bitblt-from-sheet)")  
  
  (dotimes (x NUMBER-OF-RANDOM-REPETITIONS) 
    (send dg-test-window :bitblt-from-sheet w:alu-seta
	  (RANDOM 128.) (RANDOM 128.)  0 0 dg-bitblt-array	 0 0)) 
	  ;; Temporarily use these values since clipping does not work on
	  ;; the right or bottom.  Switch back to the randoms after this is fixed.

  
1;;;
;;; Test :bitblt-within-sheet
;;;*
  (dg-initialize-test "Test (:method w:stream-mixin :bitblt-within-sheet)")
  
;; Put some pattern on the screen. 
  (dotimes (n 300.)
    (LET ((x (random-x)))
	  (send dg-test-window :draw-line x 0 x 250. w:alu-xor)
	  )
    )
  
  (dotimes (n NUMBER-OF-RANDOM-REPETITIONS)
    (send dg-test-window :bitblt-within-sheet w:alu-seta
	  (random-width) (random-height) 
	  (random-x) (random-y)
	  (random-x) (random-y)))
1;;;
;;; Test sys:%draw-character
;;;*  
  (dg-initialize-test 
    "Test microcode primitive %draw-character
  - should clip to OUTSIDE edges, not inside.")

  (MULTIPLE-VALUE-BIND (left top right bottom) (SEND  dg-test-window :inside-edges)
    (w:with-clipping-rectangle (left top right bottom)
      (dotimes (x NUMBER-OF-RANDOM-REPETITIONS)
	(w:prepare-sheet (dg-test-window)
	  (si:%draw-character fonts:cptfont #\O nil (random-x) (random-y) w:alu-ior dg-test-window)))))

;1;*
;1;  Clean up test environment*
;1;*
  (SEND dg-message-window :kill)
  (SEND dg-test-window :kill) 
  )









;1;*
;1; Execute the test suite*
;1;*
(DEFUN draw-graphics-test ()
  
  (begin-test-suite)
  (EVAL-WITHOUT-ERROR (draw-primitives-test))
  (summarize-test-suite-results "Window :Draw Graphics")
  
  )
