;;; -*- Mode:Common-Lisp; package: W; Fonts:(MEDFNT MEDFNB CPTFONT); Base:10 -*-




(DEFVAR test-window nil)

(DEFVAR *number-of-tests-attempted*)
				
(SETQ test-window (MAKE-INSTANCE 'w:window
				1  * :edges '(100. 25. 900. 525.)
				   1:*border-margin-width 25.
                                   :label "Test window with wide border margin"))

(DEFVAR message-window nil)

(SETQ message-window (MAKE-INSTANCE 'w:window
				   :edges '(100. 550. 900. 750.)
				   :border-margin-width 8
				   :label "Message window"
				   :more-p nil))

(DEFVAR x-array (make-array 20. :type :art-fix))

(DEFVAR y-array (make-array 20. :type :art-fix))

(SETQ t-alu normal)

(DEFUN random-radius () (RANDOM 75.))

(DEFUN random-color () (RANDOM 9.))

(DEFUN random-thick () (random 15.))

(DEFUN random-height () (- (RANDOM 200.) 100.))

(DEFUN random-width () (- (RANDOM 300.) 150.))

(DEFUN random-x-near (x) (+ x (- (RANDOM 250.) 75.)))

(DEFUN random-y-near (y) (+ y (- (RANDOM 250.) 75.)))

(DEFUN random-x () (- (RANDOM 900.) 50.))

(DEFUN random-y () (- (RANDOM 550.) 50.))

(DEFUN random-sides () (RANDOM 9.))

(DEFUN draw-operations-test ()
  (begin-test-suite)
  (prepare-test-case "W: Draw Operations Test:")

  (user:eval-without-error (draw-arc))
  (user:eval-without-error (draw-circle))
  (user:eval-without-error (draw-filled-arc))
  (user:eval-without-error (draw-filled-circle))
  (user:eval-without-error (draw-filled-rectangle))
  (user:eval-without-error (draw-filled-triangle))
;;  (user:eval-without-error (draw-filled-triangle-list))
  (user:eval-without-error (draw-line))
  (user:eval-without-error (draw-polyline))
;;  (user:eval-without-error (draw-raster))
  (user:eval-without-error (draw-rectangle))
  (user:eval-without-error (draw-filled-polygon))
  (user:eval-without-error (draw-string))
  (user:eval-without-error (draw-triangle))
  (user:eval-without-error (draw-point))
  (user:eval-without-error (draw-dashed-line))
  (user:eval-without-error (draw-regular-polygon))
  (user:eval-without-error (draw-cubic-spline))
  )


(DEFUN initialize-test (string)
  (SEND test-window :expose)
  (SEND test-window :clear-screen)
  (SEND message-window :expose)
  (FORMAT message-window string)
  (FORMAT message-window "~%"))



(DEFUN DRAW-ARC ()
  (INCF *number-of-tests-attempted*)
  (INITIALIZE-TEST  
  "W DRAW OPERATIONS TEST
  None of the window drawing methods should overwrite the wide margin areas of
  the test window. Nothing should ever write beyond the outside edges of the window.

  Test (:method :draw-mixin :draw-arc)")

  (DOTIMES (x 100.)
    (SEND test-window :draw-arc (random-x) (random-y) (random-x) (random-y)
	(random 360.) (random-thick) (random-color) t-alu))
)

(DEFUN draw-circle ()
  (INCF *number-of-tests-attempted*)
  (INITIALIZE-TEST "Test (:method :draw-mixin :draw-circle)")

  (DOTIMES (x 100.)
    (SEND test-window :draw-circle (random-x) (random-y) (random-radius)
       (RANDOM 15.) (random-color) t-alu))
)


(DEFUN draw-filled-arc ()
  (INCF *number-of-tests-attempted*)
  (INITIALIZE-TEST "Test (:method :draw-mixin :draw-filled-arc)")
  (DOTIMES (n 100.)
    (LET (x y)
      (SEND test-window :draw-filled-arc
	    (SETQ x (random-x))
	    (SETQ y (random-y))
	    (random-x-near x) (random-y-near y)
	    (random 180.) (random-color) t-alu)))
  )


(DEFUN draw-filled-circle ()
  (INCF *number-of-tests-attempted*)
  (INITIALIZE-TEST "Test (:method :draw-mixin :draw-filled-circle)")
  (DOTIMES (x 200.)
    (SEND test-window :draw-filled-circle 
        (random-x) (random-y)
	(random-radius)
	(random-color) t-alu))
  )


(DEFUN draw-filled-rectangle ()
  (INCF *number-of-tests-attempted*)
  (INITIALIZE-TEST "Test (:method :draw-mixin :draw-filled-rectangle)")
  (DOTIMES (x 200.)
    (SEND test-window :draw-filled-rectangle
	  (random-x) (random-y)
	  (random-width) (random-height)
	  (random-color) t-alu))
  )


(DEFUN draw-filled-triangle ()
  (INCF *number-of-tests-attempted*)  
  (INITIALIZE-TEST "Test (:method :draw-mixin :draw-filled-triangle)")
  (LET (x y)
    (DOTIMES (n 300.)
      (SETQ x (random-x))
      (SETQ y (random-y))
      (SEND test-window :draw-filled-triangle x y
	    (random-x-near x) (random-y-near y)
            (random-x-near x) (random-y-near y) (random-color) t-alu)))
  )

;; (INITIALIZE-TEST "Test (:method :draw-mixin :draw-filled-triangle-list)")


(DEFUN draw-line ()
  (INCF *number-of-tests-attempted*)
  (INITIALIZE-TEST "Test (:method :draw-mixin :draw-line)")
  (DOTIMES (n 300.)
    (SEND test-window :draw-line
	  (random-x) (random-y)
	  (random-x) (random-y)
	  (random-thick) (random-color) t-alu))
  )


(DEFUN draw-polyline ()
  (INCF *number-of-tests-attempted*)
  (INITIALIZE-TEST "Test (:method :draw-mixin :draw-polyline)")
  (DOTIMES (n 10.)
    (LET (x y)
      (SETQ x (random-x))
      (SETQ y (random-y))
      (DOTIMES (z 10.)
	(SETF (AREF x-array z) (random-x-near x))
	(SETF (AREF y-array z) (random-y-near y)))
      (SEND test-window :draw-polyline
	    x-array y-array
	    (random-thick) (random-color) 10. t-alu)))
  )


;; (INITIALIZE-TEST "Test (:method :draw-mixin :draw-raster)")


(DEFUN draw-rectangle ()
  (INCF *number-of-tests-attempted*)  
  (INITIALIZE-TEST "Test (:method :draw-mixin :draw-rectangle)")
  (DOTIMES (n 100.)
    (SEND test-window :draw-rectangle
	  (random-x) (random-y)
	  (random-x) (random-y)
	  (random-thick) (random-color) t-alu))
  )


(DEFUN draw-filled-polygon ()
  (INCF *number-of-tests-attempted*)
  (INITIALIZE-TEST "Test (:method :draw-mixin :draw-filled-polygon)")
  (DOTIMES (n 20.)
    (LET (x y)
      (SETQ x (random-x))
      (SETQ y (random-y))
      (DOTIMES (z 10.)
	(SETF (AREF x-array z) (random-x-near x))
	(SETF (AREF y-array z) (random-y-near y)))
      (SEND test-window :draw-filled-polygon
	    x y x-array y-array (random-color) (random 10.) t-alu)))
  )


(DEFUN draw-string ()
  (INCF *number-of-tests-attempted*)
  (INITIALIZE-TEST "Test (:method :draw-mixin :draw-string)")
  (DOTIMES (n 200)
    (SEND test-window :draw-string w:medfnb-font "HELP!" (random-x) (random-y)
	  black 0 8))
  )


(DEFUN draw-triangle ()
  (INCF *number-of-tests-attempted*)
  (INITIALIZE-TEST "Test (:method :draw-mixin :draw-triangle)")
  (DOTIMES (n 250.)
    (LET (x y)
      (SETQ x (random-x))
      (SETQ y (random-y))
      (SEND test-window :draw-triangle
	    x y
	    (random-x-near x) (random-y-near y)
	    (random-x-near x) (random-y-near y)
            (random-thick) (random-color) t-alu)))
  )


(DEFUN draw-point ()
  (INCF *number-of-tests-attempted*)
  (initialize-Test "Test (:method w:graphics-mixin :draw-point)")
  (dotimes (x 5000.)
    (send test-window :draw-point (random-x) (random-y)))
  )


(DEFUN draw-dashed-line ()
  (INCF *number-of-tests-attempted*)
  (initialize-test "Test (:method w:graphics-mixin :draw-dashed-line)")
  (dotimes (x 10)
    (send test-window :draw-dashed-line
	  (random-x) (random-y)
	  (random-x) (random-y))
    (send test-window :draw-dashed-line
	  (random-x) (random-y)
	  (random-x) (random-y)
          3 )
    (send test-window :draw-dashed-line
	  (random-x) (random-y)
	  (random-x) (random-y)
          20. (random-color) t-alu 10. t 10.)
    (send test-window :draw-dashed-line
	  (random-x) (random-y)
	  (random-x) (random-y)
          40 (random-color) t-alu 20. t  15.))
  )


(DEFUN draw-regular-polygon ()
  (INCF *number-of-tests-attempted*)
  (initialize-test "Test (:method w:graphics-mixin :draw-regular-polygon)")
  (Let (x y)
    (dotimes (n 100.)
      (setq x (random-x))
      (setq y (random-y))
      (send test-window :draw-regular-polygon x y
	    (random-x-near x) (random-y-near y)
	    (random-sides) (random-color) T-ALU)))
  )


(DEFUN draw-cubic-spline ()
  (INCF *number-of-tests-attempted*)
  (initialize-test "Test (:method w:graphics-mixin :draw-cubic-spline)")
  (dotimes (x 10.)
    (dotimes (z 20.)
      (setf (aref x-array z) (random-x))
      (setf (aref y-array z) (random-y)))
    (send test-window :draw-cubic-spline
	  x-array y-array (RANDOM-THICK) (random-thick) (random-color)
	  t-alu :relaxed :relaxed)
    (dotimes (z 20.)
      (setf (aref x-array z) (random-x))
      (setf (aref y-array z) (random-y)))
    (send test-window :draw-cubic-spline
	  x-array y-array (RANDOM-THICK) (random-thick) (random-color)
	  t-alu :clamped :clamped 0 0.5 0.75 1.0))
  )
