;;; -*- Mode:Common-Lisp; Package:USER; Fonts:(CPTFONT TR10B TR10BI TR10I CPTFONTB); Base:10. -*-

;1;;                           RESTRICTED RIGHTS LEGEND*

;1;;Use, duplication, or disclosure by the Government is subject to*
;1;;restrictions as set forth in subdivision (b)(3)(ii) of the Rights in*
;1;;Technical Data and Computer Software clause at 52.227-7013.*
;1;;*
;1;;                     TEXAS INSTRUMENTS INCORPORATED.*
;1;;                              P.O. BOX 2909*
;1;;                           AUSTIN, TEXAS 78769*
;1;;                                 MS 2151*
;1;;*
;1;; Copyright (C) 1986, Texas Instruments Incorporated. All rights reserved.*

;1;; Created 2/04/87 17:54:26 by nichols*

	
	
;1 Author:  Bob Chafetz*
;1; create a number of "pages" of zmacs editor windows. this is *
;1; my editing environment.  Each page will be shorter in length,  *
;1; but wider than the previous page.  This results in windows that*
;1; always have some section exposed.*
	
(DEFVAR 4height-change* 80
 "2 the difference in height between successive pages*")
(DEFVAR 4width-change*  80
 "2 the difference in width between successive pages*")
(DEFVAR 4number-of-pages* 5
 "2 the number of page/windows to create*")
(DEFVAR 4first-right* 651
 "2 the horizontal position of the first page*")
(DEFVAR 4first-bottom* 739
 "2 the bottom position of the first page*")
(DEFVAR 4first-top* 0
 "2the top position of the first page*")
(DEFVAR 4first-left* 0
 "2the top position of the first page*")
(DEFVAR 4reverse-video-flag* t
 "2true if want reverse video*") 
(DEFVAR 4*reverse-video-flag-editor-pane** nil
 "2reverse video of editor pane if t*")
(DEFVAR 4*reverse-video-flag-buffer-pane** t
 "2reverse video of buffer pane if t*")
(DEFVAR 4*number-of-top-pages** 3
 "2number of top pages to display*")

(DEFVAR 4*book** nil
 "2A book of pages*")
(DEFVAR 4*screen** nil)

(DEFUN 4page-initializer* ()
  (SETQ *reverse-video-flag-editor-pane* t)
  (SETQ *reverse-video-flag-buffer-pane* t)
  (SETQ first-right 651)
  (SETQ first-bottom 739)
  (SETQ number-of-pages 5)
  (SETQ width-change 80)
  (SETQ height-change 80)
  (SETQ *number-of-top-pages* 5)
                                                ;1(tv:add-to-system-menu-programs-column "PAGES "*
                                                ;1	'(page-displayer)*
                                                ;1        "Set up the editor pages")*
  (tv:add-to-system-menu-column :programs "3TOP-PAGES *"
                                '(top-pages-displayer)
                                "3Set up the editor pages*")
                                                ;1(tv:add-to-system-menu-programs-column "CHOOSE-PAGE"*
                                                ;1	'(choose-page)*
                                                ;1        "Choose an editor page")*
  
  (SETQ *book* nil)) 
	
(COMMENT (page-initializer))
	
(DEFUN 4page-displayer* ()
  (LET ((book-length  (SUB1 (LENGTH *book*))) next-page)
    (LOOP for page-num from book-length downto 0 by 1 DO
          (SETQ next-page (NTH page-num *book*)) 
          (expose-page (NTH page-num *book*)))
    ))
	
(DEFUN 4top-pages-displayer* ()
  (LOOP for page-num from (SUB1 *number-of-top-pages*) downto 0 by 1 DO
        (expose-page (NTH page-num *book*)))
  )
	
	
(DEFUN 4expose-page* (page) 
  (SEND page :expose)
  (SEND page :select))
	
	;1Assuming that the mouse is on the current editor page of the book,*
	;1find the previous or next page*
	(DEFUN next-page (direction)
	(LET (
	      current-page
	      current-buffer
	      list-posn
	      next-page-num
	      pages-of-interest
	      the-next-page
	     )
	(SETQ pages-of-interest 5.)
	(SETQ current-buffer tv:mouse-window)
	(SETQ current-page (SEND current-buffer :superior))
	(SETQ list-posn (list-position current-page *book*))
	(COND
	  ((GREATERP list-posn 0)
	   (COND
	     ((EQ direction 'forward)
	        (SETQ next-page-num
		      (PLUS list-posn 1))
		(COND
		  ((EQ next-page-num (ADD1 pages-of-interest))
		     (SETQ next-page-num 1))))
	     ((EQ direction 'backward)
	        (SETQ next-page-num
		      (SUB1 list-posn))
	        (COND
		  ((EQ next-page-num 0.)
		      (SETQ next-page-num pages-of-interest)))))
	   (SETQ the-next-page (NTH (SUB1 next-page-num) *book*))
	   (SEND the-next-page :select)))
	))
	
	
(DEFUN 4list-position* (element the-list)
  (LET (
        list-length
        )
    (SETQ list-length (LENGTH the-list))
    (LOOP for elem in the-list
          for posn from 1 by 1 DO
          (COND 
            ((EQ elem element)
             (RETURN posn)) 
            ((EQ posn (ADD1 list-length))
             (RETURN 0))))
    ))
	   
	;1(list-position 'd '(b c a d))*
	
(DEFUN 4editor-pages* ()
  (LET ( 
        next-page f-page inferiors editor-pane buffer-pane
        ) 
    (page-initializer)
    (SETQ *screen* tv:mouse-sheet)
    (LOOP for page-number from 1 to number-of-pages by 1  DO
          (SETQ next-page 
                (make-page first-left first-top page-number))
          (SETQ *book* `( ,@*book*  ,next-page))
          (SETQ inferiors (SEND next-page :inferiors))
          (SETQ editor-pane (FIRST inferiors))
          (SETQ buffer-pane (SECOND inferiors))
          (COND
            ((EQ *reverse-video-flag-editor-pane* t)
             (rev-color editor-pane))
            ((EQ *reverse-video-flag-buffer-pane* t)
             (rev-color buffer-pane)))
	  )
    (SETQ next-page (make-file-system-page 1))
    (SETQ *book* `(,@*book* ,next-page))
    (SETQ next-page (make-lisp-listener-page))
    (SETQ *book* `(,@*book* ,next-page))
    (page-displayer)
                                                ;1(make-title-page) *
    ))
	
(COMMENT
  (NTH 7 *book*)
  (expose-page (FIRST *book*))
  )
	
	
	        
(DEFUN 4make-page* ( first-left first-top page-number)
  (LET (left top right bottom )
    (SETQ left (PLUS first-left
                     (TIMES (SUB1 page-number)
                            width-change))
          top  first-top
          right (PLUS first-right 
                      (TIMES (SUB1 page-number)
                             width-change))
          bottom (DIFFERENCE  first-bottom
                              (TIMES (SUB1 page-number)
                                     height-change)))
    (MAKE-INSTANCE 'zwei:zmacs-frame 
                   :reverse-video-p t
;                   1 :expose-p t*
                   :left left
                   :top  top
                   :right right 
                   :bottom bottom
;1			 :screen-array *screen**
                   :superior *screen*) 
    ))
	
(DEFUN 4make-file-system-page* ( page-number)
  (LET (left top right bottom )
    (SETQ left first-left
          top  first-top
          right 1088
          ;1	right (PLUS first-right 100*
          ;1		    (TIMES  page-number)*
          ;1			   width-change)*
          bottom 300)
    ;1	(DIFFERENCE  first-bottom*
    ;1			    (TIMES  page-number)*
    ;1				   height-change))*
    ;1  (PRIN1 "bottom") (PRINT bottom)*
    (MAKE-INSTANCE 'zwei:zmacs-frame 
;    (MAKE-INSTANCE 'fs:fsmaint-frame 
                   :expose-p t
                   :left left
                   :top  top
                   :right right
                   :bottom bottom
;1			 :screen-array *screen**
                   :superior *screen*)
    ))
	
	
(DEFUN 4make-lisp-listener-page* ()
  (LET (left top right bottom)
    (SETQ left first-left
          top  300
          bottom  735
          right 1088)
    (MAKE-INSTANCE 'tv:lisp-listener
                   :expose-p t
                   :left left
                   :top  top
                   :right right
                   :bottom bottom
;1			 :screen-array *screen**
                   :superior *screen*)
    ))
	
	
(DEFUN 4make-title-page* ()
  (SETQ title-page (MAKE-INSTANCE 'zwei:zmacs-frame
                                  :expose-p t
                                  :left 948.
                                  :top  194.
                                  :right 1083.
                                  :bottom 734.
;1			 :screen-array *screen**
                                  :superior *screen*))
  (SEND title-page :expose))
	;1(editor-pages)  *
	
(DEFUN 4pos* ()
  (PRINC  "3The x posn is*") (PRINT tv:mouse-x)
  (PRINC  "3The y posn is*") (PRINT tv:mouse-y))
	
(DEFUN 4rev-color* (win)
  (SEND win :set-reverse-video-p
        (IF (SEND win :reverse-video-p) nil t)))

(DEFUN 4rev* ()
  (LET (this-screen)
    (SETQ this-screen tv:mouse-sheet)
    (SEND this-screen :set-reverse-video-p t)))        
	
(comment
  
  (DEFUN tester ()
    (LOOP for page-number from 1 to number-of-pages by 1 DO 
          (SETQ next-page (NTH page-number page-names))
          (PRINT next-page)
          (EVAL `(SETQ ,next-page 2.))
          (PRINT (EVAL next-page))))
  
  (DEFUN reverse-video-tester ()
    (SEND p2 :set-reverse-video-p t)
    (SEND p3 :expose)
    (SEND p3 :describe)
    (SETQ foo (SEND p3 :which-operations)))
  
  (DEFUN rev-test ()
    (SEND p3 :expose)
    (SETQ inf (SEND p3 :inferiors)) 
                                                ;1(SEND inf :expose)*
    (SEND (FIRST inf) :reverse-video-p)
    (SEND (FIRST inf) :set-reverse-video-p nil))
  
  (SEND p2 :expose)
  (SEND p2 :current-font)
  
  )   
	
(COMMENT
  (editor-pages)
  (SETQ f-page (make-file-system-page (PLUS 5 1)))
  (SEND f-page :describe)
  (SEND f-page :expose)
  (tv:mouse-x)
  (tv:mouse-warp 1050 100) 
  (tv:mouse-warp 1050 300)
  (tv:mouse-warp 100 739)
  ) 
	
(COMMENT 
  (SETQ foo (make-file-system-page 5))
  (SEND foo :expose))    
	
	
(comment
  (DEFUN page-displayer ()
    (LET ( (number-of-pages (PLUS 1 number-of-pages)))
      (
       (LOOP for page-number from number-of-pages downto 1 by 1 DO 
             (SETQ next-page (NTH page-number page-names))
             (EVAL `(SEND ,next-page :expose))
             )))))
	
(COMMENT 
  (DEFUN page-displayer ()
    (PROG (next-page remaining-pages)
          (SETQ remaining-pages (REVERSE *book*))
       LOOP
          (SETQ next-page (CAR remaining-pages))
          (IF (NULL next-page) (RETURN nil))
          (expose-page next-page)
          (SETQ remaining-pages (CDR remaining-pages))
          (GO loop))))
	
;1      finally*
;1        (PROGN*
;1	(PRINT "now make the file system page")*
;1        *
;1	(page-displayer)))*
;1      (EVAL `(SEND ,next-page :select)))*
;1(SETQ f-page (make-file-system-page (PLUS number-of-pages 1)))*
;1(SETQ *book* `(,@*book* ,f-page))*
	
(COMMENT
  (SETQ f1 (make-file-system-page 1))
  (SEND f1 :describe)
  (SETQ sup (SEND f1 :superior))
  (SEND sup :describe)
  (SEND f1 :expose)
  (SEND *screen* :expose)
  (SEND *screen* :select)
  (SEND *screen* :describe)
  tv:mouse-sheet
  (SETQ foo (FIRST *book*))
  (SEND foo :describe)
  (SETQ fee (SEND foo :superior))
  (SEND fee :describe)
  (editor-pages)
  )  
